var searchIndex = JSON.parse('{\
"alloc":{"doc":"The Rust core allocation and collections libraryThis …","i":[[0,"alloc","alloc","Memory allocation APIs",null,null],[3,"AllocError","alloc::alloc","The <code>AllocError</code> error indicates an allocation failure that …",null,null],[8,"Allocator","","An implementation of <code>Allocator</code> can allocate, grow, …",null,null],[10,"allocate","","Attempts to allocate a block of memory.",0,[[["layout",3]],[["allocerror",3],["result",4],["nonnull",3]]]],[11,"allocate_zeroed","","Behaves like <code>allocate</code>, but also ensures that the returned …",0,[[["layout",3]],[["allocerror",3],["result",4],["nonnull",3]]]],[10,"deallocate","","Deallocates the memory referenced by <code>ptr</code>.",0,[[["u8",15],["nonnull",3],["layout",3]]]],[11,"grow","","Attempts to extend the memory block.",0,[[["nonnull",3],["u8",15],["layout",3]],[["allocerror",3],["result",4],["nonnull",3]]]],[11,"grow_zeroed","","Behaves like <code>grow</code>, but also ensures that the new contents …",0,[[["nonnull",3],["u8",15],["layout",3]],[["allocerror",3],["result",4],["nonnull",3]]]],[11,"shrink","","Attempts to shrink the memory block.",0,[[["nonnull",3],["u8",15],["layout",3]],[["allocerror",3],["result",4],["nonnull",3]]]],[11,"by_ref","","Creates a \\\"by reference\\\" adaptor for this instance of …",0,[[]]],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard …",null,null],[10,"alloc","","Allocate memory as described by the given <code>layout</code>.",1,[[["layout",3]]]],[10,"dealloc","","Deallocate the block of memory at the given <code>ptr</code> pointer …",1,[[["layout",3]]]],[11,"alloc_zeroed","","Behaves like <code>alloc</code>, but also ensures that the contents …",1,[[["layout",3]]]],[11,"realloc","","Shrink or grow a block of memory to the given <code>new_size</code>. …",1,[[["usize",15],["layout",3]]]],[3,"Layout","","Layout of a block of memory.",null,null],[6,"LayoutErr","","",null,null],[3,"LayoutError","","The parameters given to <code>Layout::from_size_align</code> or some …",null,null],[3,"Global","","The global memory allocator.",null,null],[5,"alloc","","Allocate memory with the global allocator.",null,[[["layout",3]]]],[5,"dealloc","","Deallocate memory with the global allocator.",null,[[["layout",3]]]],[5,"realloc","","Reallocate memory with the global allocator.",null,[[["usize",15],["layout",3]]]],[5,"alloc_zeroed","","Allocate zero-initialized memory with the global …",null,[[["layout",3]]]],[5,"handle_alloc_error","","Abort on memory allocation error or failure.",null,[[["layout",3]]]],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"Box","alloc::boxed","A pointer type for heap allocation.",null,null],[11,"new","","Allocates memory on the heap and then places <code>x</code> into it.",2,[[]]],[11,"new_uninit","","Constructs a new box with uninitialized contents.",2,[[],[["maybeuninit",19],["box",3]]]],[11,"new_zeroed","","Constructs a new <code>Box</code> with uninitialized contents, with …",2,[[],[["maybeuninit",19],["box",3]]]],[11,"pin","","Constructs a new <code>Pin<Box<T>></code>. If <code>T</code> does not implement …",2,[[],[["pin",3],["box",3]]]],[11,"try_new","","Allocates memory on the heap then places <code>x</code> into it, …",2,[[],[["allocerror",3],["result",4]]]],[11,"try_new_uninit","","Constructs a new box with uninitialized contents on the …",2,[[],[["box",3],["allocerror",3],["result",4]]]],[11,"try_new_zeroed","","Constructs a new <code>Box</code> with uninitialized contents, with …",2,[[],[["box",3],["allocerror",3],["result",4]]]],[11,"new_in","","Allocates memory in the given allocator then places <code>x</code> …",2,[[]]],[11,"try_new_in","","Allocates memory in the given allocator then places <code>x</code> …",2,[[],[["allocerror",3],["result",4]]]],[11,"new_uninit_in","","Constructs a new box with uninitialized contents in the …",2,[[],[["box",3],["maybeuninit",19]]]],[11,"try_new_uninit_in","","Constructs a new box with uninitialized contents in the …",2,[[],[["result",4],["box",3],["allocerror",3]]]],[11,"new_zeroed_in","","Constructs a new <code>Box</code> with uninitialized contents, with …",2,[[],[["box",3],["maybeuninit",19]]]],[11,"try_new_zeroed_in","","Constructs a new <code>Box</code> with uninitialized contents, with …",2,[[],[["result",4],["box",3],["allocerror",3]]]],[11,"pin_in","","Constructs a new <code>Pin<Box<T, A>></code>. If <code>T</code> does not implement …",2,[[],["pin",3]]],[11,"into_boxed_slice","","Converts a <code>Box<T></code> into a <code>Box<[T]></code>",2,[[],["box",3]]],[11,"new_uninit_slice","","Constructs a new boxed slice with uninitialized contents.",2,[[["usize",15]],["box",3]]],[11,"new_zeroed_slice","","Constructs a new boxed slice with uninitialized contents, …",2,[[["usize",15]],["box",3]]],[11,"new_uninit_slice_in","","Constructs a new boxed slice with uninitialized contents …",2,[[["usize",15]],["box",3]]],[11,"new_zeroed_slice_in","","Constructs a new boxed slice with uninitialized contents …",2,[[["usize",15]],["box",3]]],[11,"assume_init","","Converts to <code>Box<T, A></code>.",2,[[],["box",3]]],[11,"assume_init","","Converts to <code>Box<[T], A></code>.",2,[[],["box",3]]],[11,"from_raw","","Constructs a box from a raw pointer.",2,[[]]],[11,"from_raw_in","","Constructs a box from a raw pointer in the given …",2,[[]]],[11,"into_raw","","Consumes the <code>Box</code>, returning a wrapped raw pointer.",2,[[]]],[11,"into_raw_with_allocator","","Consumes the <code>Box</code>, returning a wrapped raw pointer and the …",2,[[]]],[11,"allocator","","Returns a reference to the underlying allocator.",2,[[]]],[11,"leak","","Consumes and leaks the <code>Box</code>, returning a mutable reference,…",2,[[]]],[11,"into_pin","","Converts a <code>Box<T></code> into a <code>Pin<Box<T>></code>",2,[[],["pin",3]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,[[],[["result",4],["box",3]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,[[],[["result",4],["box",3]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,[[],[["result",4],["box",3]]]],[0,"borrow","alloc","A module for working with borrowed data.",null,null],[8,"Borrow","alloc::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",3,[[]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",4,[[]]],[8,"ToOwned","","A generalization of <code>Clone</code> to borrowed data.",null,null],[16,"Owned","","The resulting type after obtaining ownership.",5,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",5,[[]]],[11,"clone_into","","Uses borrowed data to replace owned data, usually by …",5,[[]]],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",6,null],[13,"Owned","","Owned data.",6,null],[11,"is_borrowed","","Returns true if the data is borrowed, i.e. if <code>to_mut</code> …",6,[[],["bool",15]]],[11,"is_owned","","Returns true if the data is owned, i.e. if <code>to_mut</code> would …",6,[[],["bool",15]]],[11,"to_mut","","Acquires a mutable reference to the owned form of the …",6,[[]]],[11,"into_owned","","Extracts the owned data.",6,[[]]],[0,"collections","alloc","Collection types.",null,null],[0,"binary_heap","alloc::collections","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","alloc::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest …",null,null],[11,"pop","","Removes the peeked value from the heap and returns it.",7,[[["peekmut",3]]]],[11,"new","","Creates an empty <code>BinaryHeap</code> as a max-heap.",8,[[],["binaryheap",3]]],[11,"with_capacity","","Creates an empty <code>BinaryHeap</code> with a specific capacity. …",8,[[["usize",15]],["binaryheap",3]]],[11,"peek_mut","","Returns a mutable reference to the greatest item in the …",8,[[],[["peekmut",3],["option",4]]]],[11,"pop","","Removes the greatest item from the binary heap and …",8,[[],["option",4]]],[11,"push","","Pushes an item onto the binary heap.",8,[[]]],[11,"into_sorted_vec","","Consumes the <code>BinaryHeap</code> and returns a vector in sorted …",8,[[],["vec",3]]],[11,"append","","Moves all the elements of <code>other</code> into <code>self</code>, leaving <code>other</code> …",8,[[]]],[11,"drain_sorted","","Returns an iterator which retrieves elements in heap …",8,[[],["drainsorted",3]]],[11,"retain","","Retains only the elements specified by the predicate.",8,[[]]],[11,"iter","","Returns an iterator visiting all values in the underlying …",8,[[],["iter",3]]],[11,"into_iter_sorted","","Returns an iterator which retrieves elements in heap …",8,[[],["intoitersorted",3]]],[11,"peek","","Returns the greatest item in the binary heap, or <code>None</code> if …",8,[[],["option",4]]],[11,"capacity","","Returns the number of elements the binary heap can hold …",8,[[],["usize",15]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly <code>additional</code> more …",8,[[["usize",15]]]],[11,"reserve","","Reserves capacity for at least <code>additional</code> more elements …",8,[[["usize",15]]]],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",8,[[]]],[11,"shrink_to","","Discards capacity with a lower bound.",8,[[["usize",15]]]],[11,"into_vec","","Consumes the <code>BinaryHeap</code> and returns the underlying vector …",8,[[],["vec",3]]],[11,"len","","Returns the length of the binary heap.",8,[[],["usize",15]]],[11,"is_empty","","Checks if the binary heap is empty.",8,[[],["bool",15]]],[11,"drain","","Clears the binary heap, returning an iterator over the …",8,[[],["drain",3]]],[11,"clear","","Drops all items from the binary heap.",8,[[]]],[3,"Iter","","An iterator over the elements of a <code>BinaryHeap</code>.",null,null],[3,"IntoIter","","An owning iterator over the elements of a <code>BinaryHeap</code>.",null,null],[3,"IntoIterSorted","","",null,null],[3,"Drain","","A draining iterator over the elements of a <code>BinaryHeap</code>.",null,null],[3,"DrainSorted","","A draining iterator over the elements of a <code>BinaryHeap</code>.",null,null],[0,"linked_list","alloc::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","alloc::collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a <code>LinkedList</code>.",null,null],[3,"IterMut","","A mutable iterator over the elements of a <code>LinkedList</code>.",null,null],[3,"IntoIter","","An owning iterator over the elements of a <code>LinkedList</code>.",null,null],[11,"new","","Creates an empty <code>LinkedList</code>.",9,[[]]],[11,"append","","Moves all elements from <code>other</code> to the end of the list.",9,[[]]],[11,"prepend","","Moves all elements from <code>other</code> to the begin of the list.",9,[[]]],[11,"iter","","Provides a forward iterator.",9,[[],["iter",3]]],[11,"iter_mut","","Provides a forward iterator with mutable references.",9,[[],["itermut",3]]],[11,"cursor_front","","Provides a cursor at the front element.",9,[[],["cursor",3]]],[11,"cursor_front_mut","","Provides a cursor with editing operations at the front …",9,[[],["cursormut",3]]],[11,"cursor_back","","Provides a cursor at the back element.",9,[[],["cursor",3]]],[11,"cursor_back_mut","","Provides a cursor with editing operations at the back …",9,[[],["cursormut",3]]],[11,"is_empty","","Returns <code>true</code> if the <code>LinkedList</code> is empty.",9,[[],["bool",15]]],[11,"len","","Returns the length of the <code>LinkedList</code>.",9,[[],["usize",15]]],[11,"clear","","Removes all elements from the <code>LinkedList</code>.",9,[[]]],[11,"contains","","Returns <code>true</code> if the <code>LinkedList</code> contains an element equal …",9,[[],["bool",15]]],[11,"front","","Provides a reference to the front element, or <code>None</code> if the …",9,[[],["option",4]]],[11,"front_mut","","Provides a mutable reference to the front element, or <code>None</code>…",9,[[],["option",4]]],[11,"back","","Provides a reference to the back element, or <code>None</code> if the …",9,[[],["option",4]]],[11,"back_mut","","Provides a mutable reference to the back element, or <code>None</code> …",9,[[],["option",4]]],[11,"push_front","","Adds an element first in the list.",9,[[]]],[11,"pop_front","","Removes the first element and returns it, or <code>None</code> if the …",9,[[],["option",4]]],[11,"push_back","","Appends an element to the back of a list.",9,[[]]],[11,"pop_back","","Removes the last element from a list and returns it, or …",9,[[],["option",4]]],[11,"split_off","","Splits the list into two at the given index. Returns …",9,[[["usize",15]],["linkedlist",3]]],[11,"remove","","Removes the element at the given index and returns it.",9,[[["usize",15]]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if …",9,[[],["drainfilter",3]]],[3,"Cursor","","A cursor over a <code>LinkedList</code>.",null,null],[3,"CursorMut","","A cursor over a <code>LinkedList</code> with editing operations.",null,null],[11,"index","","Returns the cursor position index within the <code>LinkedList</code>.",10,[[],[["usize",15],["option",4]]]],[11,"move_next","","Moves the cursor to the next element of the <code>LinkedList</code>.",10,[[]]],[11,"move_prev","","Moves the cursor to the previous element of the <code>LinkedList</code>…",10,[[]]],[11,"current","","Returns a reference to the element that the cursor is …",10,[[],["option",4]]],[11,"peek_next","","Returns a reference to the next element.",10,[[],["option",4]]],[11,"peek_prev","","Returns a reference to the previous element.",10,[[],["option",4]]],[11,"index","","Returns the cursor position index within the <code>LinkedList</code>.",11,[[],[["usize",15],["option",4]]]],[11,"move_next","","Moves the cursor to the next element of the <code>LinkedList</code>.",11,[[]]],[11,"move_prev","","Moves the cursor to the previous element of the <code>LinkedList</code>…",11,[[]]],[11,"current","","Returns a reference to the element that the cursor is …",11,[[],["option",4]]],[11,"peek_next","","Returns a reference to the next element.",11,[[],["option",4]]],[11,"peek_prev","","Returns a reference to the previous element.",11,[[],["option",4]]],[11,"as_cursor","","Returns a read-only cursor pointing to the current …",11,[[],["cursor",3]]],[11,"insert_after","","Inserts a new element into the <code>LinkedList</code> after the …",11,[[]]],[11,"insert_before","","Inserts a new element into the <code>LinkedList</code> before the …",11,[[]]],[11,"remove_current","","Removes the current element from the <code>LinkedList</code>.",11,[[],["option",4]]],[11,"remove_current_as_list","","Removes the current element from the <code>LinkedList</code> without …",11,[[],[["option",4],["linkedlist",3]]]],[11,"splice_after","","Inserts the elements from the given <code>LinkedList</code> after the …",11,[[["linkedlist",3]]]],[11,"splice_before","","Inserts the elements from the given <code>LinkedList</code> before the …",11,[[["linkedlist",3]]]],[11,"split_after","","Splits the list into two after the current element. This …",11,[[],["linkedlist",3]]],[11,"split_before","","Splits the list into two before the current element. This …",11,[[],["linkedlist",3]]],[3,"DrainFilter","","An iterator produced by calling <code>drain_filter</code> on …",null,null],[0,"vec_deque","alloc::collections","A double-ended queue implemented with a growable ring …",null,null],[3,"Drain","alloc::collections::vec_deque","A draining iterator over the elements of a <code>VecDeque</code>.",null,null],[3,"IterMut","","A mutable iterator over the elements of a <code>VecDeque</code>.",null,null],[3,"IntoIter","","An owning iterator over the elements of a <code>VecDeque</code>.",null,null],[3,"Iter","","An iterator over the elements of a <code>VecDeque</code>.",null,null],[3,"VecDeque","","A double-ended queue implemented with a growable ring …",null,null],[11,"new","","Creates an empty <code>VecDeque</code>.",12,[[],["vecdeque",3]]],[11,"with_capacity","","Creates an empty <code>VecDeque</code> with space for at least <code>capacity</code>…",12,[[["usize",15]],["vecdeque",3]]],[11,"get","","Provides a reference to the element at the given index.",12,[[["usize",15]],["option",4]]],[11,"get_mut","","Provides a mutable reference to the element at the given …",12,[[["usize",15]],["option",4]]],[11,"swap","","Swaps elements at indices <code>i</code> and <code>j</code>.",12,[[["usize",15]]]],[11,"capacity","","Returns the number of elements the <code>VecDeque</code> can hold …",12,[[],["usize",15]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly <code>additional</code> more …",12,[[["usize",15]]]],[11,"reserve","","Reserves capacity for at least <code>additional</code> more elements …",12,[[["usize",15]]]],[11,"try_reserve_exact","","Tries to reserve the minimum capacity for exactly …",12,[[["usize",15]],[["result",4],["tryreserveerror",4]]]],[11,"try_reserve","","Tries to reserve capacity for at least <code>additional</code> more …",12,[[["usize",15]],[["result",4],["tryreserveerror",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of the <code>VecDeque</code> as much as possible.",12,[[]]],[11,"shrink_to","","Shrinks the capacity of the <code>VecDeque</code> with a lower bound.",12,[[["usize",15]]]],[11,"truncate","","Shortens the <code>VecDeque</code>, keeping the first <code>len</code> elements and …",12,[[["usize",15]]]],[11,"iter","","Returns a front-to-back iterator.",12,[[],["iter",3]]],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable …",12,[[],["itermut",3]]],[11,"as_slices","","Returns a pair of slices which contain, in order, the …",12,[[]]],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the …",12,[[]]],[11,"len","","Returns the number of elements in the <code>VecDeque</code>.",12,[[],["usize",15]]],[11,"is_empty","","Returns <code>true</code> if the <code>VecDeque</code> is empty.",12,[[],["bool",15]]],[11,"range","","Creates an iterator that covers the specified range in …",12,[[],["iter",3]]],[11,"range_mut","","Creates an iterator that covers the specified mutable …",12,[[],["itermut",3]]],[11,"drain","","Creates a draining iterator that removes the specified …",12,[[],["drain",3]]],[11,"clear","","Clears the <code>VecDeque</code>, removing all values.",12,[[]]],[11,"contains","","Returns <code>true</code> if the <code>VecDeque</code> contains an element equal to …",12,[[],["bool",15]]],[11,"front","","Provides a reference to the front element, or <code>None</code> if the …",12,[[],["option",4]]],[11,"front_mut","","Provides a mutable reference to the front element, or <code>None</code>…",12,[[],["option",4]]],[11,"back","","Provides a reference to the back element, or <code>None</code> if the …",12,[[],["option",4]]],[11,"back_mut","","Provides a mutable reference to the back element, or <code>None</code> …",12,[[],["option",4]]],[11,"pop_front","","Removes the first element and returns it, or <code>None</code> if the …",12,[[],["option",4]]],[11,"pop_back","","Removes the last element from the <code>VecDeque</code> and returns …",12,[[],["option",4]]],[11,"push_front","","Prepends an element to the <code>VecDeque</code>.",12,[[]]],[11,"push_back","","Appends an element to the back of the <code>VecDeque</code>.",12,[[]]],[11,"swap_remove_front","","Removes an element from anywhere in the <code>VecDeque</code> and …",12,[[["usize",15]],["option",4]]],[11,"swap_remove_back","","Removes an element from anywhere in the <code>VecDeque</code> and …",12,[[["usize",15]],["option",4]]],[11,"insert","","Inserts an element at <code>index</code> within the <code>VecDeque</code>, shifting …",12,[[["usize",15]]]],[11,"remove","","Removes and returns the element at <code>index</code> from the <code>VecDeque</code>…",12,[[["usize",15]],["option",4]]],[11,"split_off","","Splits the <code>VecDeque</code> into two at the given index.",12,[[["usize",15]]]],[11,"append","","Moves all the elements of <code>other</code> into <code>self</code>, leaving <code>other</code> …",12,[[]]],[11,"retain","","Retains only the elements specified by the predicate.",12,[[]]],[11,"resize_with","","Modifies the <code>VecDeque</code> in-place so that <code>len()</code> is equal to …",12,[[["usize",15]]]],[11,"make_contiguous","","Rearranges the internal storage of this deque so it is …",12,[[]]],[11,"rotate_left","","Rotates the double-ended queue <code>mid</code> places to the left.",12,[[["usize",15]]]],[11,"rotate_right","","Rotates the double-ended queue <code>k</code> places to the right.",12,[[["usize",15]]]],[11,"binary_search","","Binary searches this sorted <code>VecDeque</code> for a given element.",12,[[],[["usize",15],["result",4]]]],[11,"binary_search_by","","Binary searches this sorted <code>VecDeque</code> with a comparator …",12,[[],[["usize",15],["result",4]]]],[11,"binary_search_by_key","","Binary searches this sorted <code>VecDeque</code> with a key …",12,[[],[["usize",15],["result",4]]]],[11,"resize","","Modifies the <code>VecDeque</code> in-place so that <code>len()</code> is equal to …",12,[[["usize",15]]]],[0,"btree_map","alloc::collections","A map based on a B-Tree.",null,null],[4,"Entry","alloc::collections::btree_map","A view into a single entry in a map, which may either be …",null,null],[13,"Vacant","","A vacant entry.",13,null],[13,"Occupied","","An occupied entry.",13,null],[3,"OccupiedEntry","","A view into an occupied entry in a <code>BTreeMap</code>. It is part …",null,null],[3,"VacantEntry","","A view into a vacant entry in a <code>BTreeMap</code>. It is part of …",null,null],[3,"BTreeMap","","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a <code>BTreeMap</code>.",null,null],[3,"IterMut","","A mutable iterator over the entries of a <code>BTreeMap</code>.",null,null],[3,"IntoIter","","An owning iterator over the entries of a <code>BTreeMap</code>.",null,null],[3,"Keys","","An iterator over the keys of a <code>BTreeMap</code>.",null,null],[3,"Values","","An iterator over the values of a <code>BTreeMap</code>.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a <code>BTreeMap</code>.",null,null],[3,"IntoKeys","","An owning iterator over the keys of a <code>BTreeMap</code>.",null,null],[3,"IntoValues","","An owning iterator over the values of a <code>BTreeMap</code>.",null,null],[3,"Range","","An iterator over a sub-range of entries in a <code>BTreeMap</code>.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a …",null,null],[3,"DrainFilter","","An iterator produced by calling <code>drain_filter</code> on BTreeMap.",null,null],[0,"btree_set","alloc::collections","A set based on a B-Tree.",null,null],[3,"BTreeSet","alloc::collections::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over the items of a <code>BTreeSet</code>.",null,null],[3,"IntoIter","","An owning iterator over the items of a <code>BTreeSet</code>.",null,null],[3,"Range","","An iterator over a sub-range of items in a <code>BTreeSet</code>.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of …",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric …",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of …",null,null],[3,"Union","","A lazy iterator producing elements in the union of …",null,null],[3,"DrainFilter","","An iterator produced by calling <code>drain_filter</code> on BTreeSet.",null,null],[4,"TryReserveError","alloc::collections","The error type for <code>try_reserve</code> methods.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the …",14,null],[13,"AllocError","","The memory allocator returned an error",14,null],[12,"layout","alloc::collections::TryReserveError","The layout of allocation request that failed",15,null],[0,"fmt","alloc","Utilities for formatting and printing <code>String</code>s.",null,null],[4,"Alignment","alloc::fmt","Possible alignments returned by <code>Formatter::align</code>",null,null],[13,"Left","","Indication that contents should be left-aligned.",16,null],[13,"Right","","Indication that contents should be right-aligned.",16,null],[13,"Center","","Indication that contents should be center-aligned.",16,null],[3,"Error","","The error type which is returned from formatting a …",null,null],[5,"write","","The <code>write</code> function takes an output stream, and an …",null,[[["arguments",3],["write",8]],[["error",3],["result",4]]]],[3,"Arguments","","This structure represents a safely precompiled version of …",null,null],[8,"Binary","","<code>b</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",17,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Octal","","<code>o</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",18,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Debug","","<code>?</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",19,[[["formatter",3]],[["error",3],["result",4]]]],[14,"Debug","","Derive macro generating an impl of the trait <code>Debug</code>.",null,null],[8,"Display","","Format trait for an empty format, <code>{}</code>.",null,null],[10,"fmt","","Formats the value using the given formatter.",20,[[["formatter",3]],[["error",3],["result",4]]]],[3,"DebugList","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugMap","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugSet","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugStruct","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugTuple","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"Formatter","","Configuration for formatting.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A trait for writing or formatting into Unicode-accepting …",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether …",21,[[["str",15]],[["error",3],["result",4]]]],[11,"write_char","","Writes a [<code>char</code>] into this writer, returning whether the …",21,[[["char",15]],[["error",3],["result",4]]]],[11,"write_fmt","","Glue for usage of the [<code>write!</code>] macro with implementors of …",21,[[["arguments",3]],[["error",3],["result",4]]]],[8,"LowerExp","","<code>e</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",22,[[["formatter",3]],[["error",3],["result",4]]]],[8,"UpperExp","","<code>E</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,[[["formatter",3]],[["error",3],["result",4]]]],[8,"LowerHex","","<code>x</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",24,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Pointer","","<code>p</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",25,[[["formatter",3]],[["error",3],["result",4]]]],[8,"UpperHex","","<code>X</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",26,[[["formatter",3]],[["error",3],["result",4]]]],[5,"format","","The <code>format</code> function takes an [<code>Arguments</code>] struct and …",null,[[["arguments",3]],["string",3]]],[0,"prelude","alloc","The alloc Prelude",null,null],[0,"v1","alloc::prelude","The first version of the prelude of <code>alloc</code> crate.",null,null],[0,"rc","alloc","Single-threaded reference-counting pointers. \'Rc\' stands …",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. \'Rc\' stands …",null,null],[11,"new","","Constructs a new <code>Rc<T></code>.",27,[[],["rc",3]]],[11,"new_cyclic","","Constructs a new <code>Rc<T></code> using a weak reference to itself. …",27,[[],["rc",3]]],[11,"new_uninit","","Constructs a new <code>Rc</code> with uninitialized contents.",27,[[],[["maybeuninit",19],["rc",3]]]],[11,"new_zeroed","","Constructs a new <code>Rc</code> with uninitialized contents, with the …",27,[[],[["maybeuninit",19],["rc",3]]]],[11,"try_new","","Constructs a new <code>Rc<T></code>, returning an error if the …",27,[[],[["rc",3],["result",4],["allocerror",3]]]],[11,"try_new_uninit","","Constructs a new <code>Rc</code> with uninitialized contents, …",27,[[],[["rc",3],["allocerror",3],["result",4]]]],[11,"try_new_zeroed","","Constructs a new <code>Rc</code> with uninitialized contents, with the …",27,[[],[["rc",3],["allocerror",3],["result",4]]]],[11,"pin","","Constructs a new <code>Pin<Rc<T>></code>. If <code>T</code> does not implement <code>Unpin</code>…",27,[[],[["rc",3],["pin",3]]]],[11,"try_unwrap","","Returns the inner value, if the <code>Rc</code> has exactly one strong …",27,[[],["result",4]]],[11,"new_uninit_slice","","Constructs a new reference-counted slice with …",27,[[["usize",15]],["rc",3]]],[11,"new_zeroed_slice","","Constructs a new reference-counted slice with …",27,[[["usize",15]],["rc",3]]],[11,"assume_init","","Converts to <code>Rc<T></code>.",27,[[],["rc",3]]],[11,"assume_init","","Converts to <code>Rc<[T]></code>.",27,[[],["rc",3]]],[11,"into_raw","","Consumes the <code>Rc</code>, returning the wrapped pointer.",27,[[]]],[11,"as_ptr","","Provides a raw pointer to the data.",27,[[]]],[11,"from_raw","","Constructs an <code>Rc<T></code> from a raw pointer.",27,[[]]],[11,"downgrade","","Creates a new [<code>Weak</code>] pointer to this allocation.",27,[[],["weak",3]]],[11,"weak_count","","Gets the number of [<code>Weak</code>] pointers to this allocation.",27,[[],["usize",15]]],[11,"strong_count","","Gets the number of strong (<code>Rc</code>) pointers to this …",27,[[],["usize",15]]],[11,"get_mut","","Returns a mutable reference into the given <code>Rc</code>, if there …",27,[[],["option",4]]],[11,"get_mut_unchecked","","Returns a mutable reference into the given <code>Rc</code>, without …",27,[[]]],[11,"ptr_eq","","Returns <code>true</code> if the two <code>Rc</code>s point to the same allocation …",27,[[],["bool",15]]],[11,"make_mut","","Makes a mutable reference into the given <code>Rc</code>.",27,[[]]],[11,"downcast","","Attempt to downcast the <code>Rc<dyn Any></code> to a concrete type.",27,[[],[["rc",3],["rc",3],["result",4]]]],[3,"Weak","","<code>Weak</code> is a version of [<code>Rc</code>] that holds a non-owning …",null,null],[11,"new","","Constructs a new <code>Weak<T></code>, without allocating any memory. …",28,[[],["weak",3]]],[11,"as_ptr","","Returns a raw pointer to the object <code>T</code> pointed to by this …",28,[[]]],[11,"into_raw","","Consumes the <code>Weak<T></code> and turns it into a raw pointer.",28,[[]]],[11,"from_raw","","Converts a raw pointer previously created by <code>into_raw</code> …",28,[[]]],[11,"upgrade","","Attempts to upgrade the <code>Weak</code> pointer to an [<code>Rc</code>], delaying …",28,[[],[["option",4],["rc",3]]]],[11,"strong_count","","Gets the number of strong (<code>Rc</code>) pointers pointing to this …",28,[[],["usize",15]]],[11,"weak_count","","Gets the number of <code>Weak</code> pointers pointing to this …",28,[[],["usize",15]]],[11,"ptr_eq","","Returns <code>true</code> if the two <code>Weak</code>s point to the same …",28,[[],["bool",15]]],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, <code>[T]</code>.",null,null],[3,"ArrayChunks","alloc::slice","An iterator over a slice in (non-overlapping) chunks (<code>N</code> …",null,null],[3,"ArrayChunksMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"ArrayWindows","","A windowed iterator over a slice in overlapping chunks (<code>N</code> …",null,null],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",29,null],[10,"get","","Returns a shared reference to the output at this …",29,[[],["option",4]]],[10,"get_mut","","Returns a mutable reference to the output at this …",29,[[],["option",4]]],[10,"get_unchecked","","Returns a shared reference to the output at this …",29,[[]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this …",29,[[]]],[10,"index","","Returns a shared reference to the output at this …",29,[[]]],[10,"index_mut","","Returns a mutable reference to the output at this …",29,[[]]],[5,"from_mut","","Converts a reference to T into a slice of length 1 …",null,[[]]],[5,"from_ref","","Converts a reference to T into a slice of length 1 …",null,[[]]],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[["usize",15]]]],[5,"from_raw_parts_mut","","Performs the same functionality as [<code>from_raw_parts</code>], …",null,[[["usize",15]]]],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"Windows","","An iterator over overlapping subslices of length <code>size</code>.",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"Split","","An iterator over subslices separated by elements that …",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector …",null,null],[3,"GroupBy","","An iterator over slice in (non-overlapping) chunks …",null,null],[3,"GroupByMut","","An iterator over slice in (non-overlapping) mutable …",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"RSplit","","An iterator over subslices separated by elements that …",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are …",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that …",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that …",null,null],[3,"SplitN","","An iterator over subslices separated by elements that …",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that …",null,null],[8,"Concat","","Helper trait for <code>[T]::concat</code>.",null,null],[16,"Output","","The resulting type after concatenation",30,null],[10,"concat","","Implementation of <code>[T]::concat</code>",30,[[]]],[8,"Join","","Helper trait for <code>[T]::join</code>",null,null],[16,"Output","","The resulting type after concatenation",31,null],[10,"join","","Implementation of <code>[T]::join</code>",31,[[]]],[0,"str","alloc","Unicode string slices.",null,null],[0,"pattern","alloc::str","The string Pattern API.",null,null],[8,"Pattern","alloc::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",32,null],[10,"into_searcher","","Constructs the associated searcher from <code>self</code> and the …",32,[[["str",15]]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the …",32,[[["str",15]],["bool",15]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the …",32,[[["str",15]],["bool",15]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the …",32,[[["str",15]],["bool",15]]],[11,"strip_prefix_of","","Removes the pattern from the front of haystack, if it …",32,[[["str",15]],[["option",4],["str",15]]]],[11,"strip_suffix_of","","Removes the pattern from the back of haystack, if it …",32,[[["str",15]],[["option",4],["str",15]]]],[4,"SearchStep","","Result of calling [<code>Searcher::next()</code>] or […",null,null],[13,"Match","","Expresses that a match of the pattern has been found at …",33,null],[13,"Reject","","Expresses that <code>haystack[a..b]</code> has been rejected as a …",33,null],[13,"Done","","Expresses that every byte of the haystack has been …",33,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",34,[[],["str",15]]],[10,"next","","Performs the next search step starting from the front.",34,[[],["searchstep",4]]],[11,"next_match","","Finds the next [<code>Match</code>][SearchStep::Match] result. See […",34,[[],["option",4]]],[11,"next_reject","","Finds the next [<code>Reject</code>][SearchStep::Reject] result. See […",34,[[],["option",4]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",35,[[],["searchstep",4]]],[11,"next_match_back","","Finds the next [<code>Match</code>][SearchStep::Match] result. See […",35,[[],["option",4]]],[11,"next_reject_back","","Finds the next [<code>Reject</code>][SearchStep::Reject] result. See […",35,[[],["option",4]]],[8,"DoubleEndedSearcher","","A marker trait to express that a [<code>ReverseSearcher</code>] can be …",null,null],[3,"CharSearcher","","Associated type for <code><char as Pattern<\'a>>::Searcher</code>.",null,null],[3,"CharSliceSearcher","","Associated type for <code><&[char] as Pattern<\'a>>::Searcher</code>.",null,null],[3,"CharPredicateSearcher","","Associated type for <code><F as Pattern<\'a>>::Searcher</code>.",null,null],[3,"StrSearcher","","Associated type for <code><&str as Pattern<\'a>>::Searcher</code>.",null,null],[3,"EncodeUtf16","alloc::str","An iterator of [<code>u16</code>] over the string encoded as UTF-16.",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a …",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a …",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,[[],[["str",15],["utf8error",3],["result",4]]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string …",null,[[],[["str",15],["result",4],["utf8error",3]]]],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"CharIndices","","An iterator over the <code>char</code>s of a string slice, and their …",null,null],[3,"Chars","","An iterator over the <code>char</code>s of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without …",null,[[],["str",15]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without …",null,[[],["str",15]]],[3,"ParseBoolError","","An error returned when parsing a <code>bool</code> using <code>from_str</code> fails",null,null],[3,"EscapeDebug","","The return type of [<code>str::escape_debug</code>].",null,null],[3,"EscapeDefault","","The return type of [<code>str::escape_default</code>].",null,null],[3,"EscapeUnicode","","The return type of [<code>str::escape_unicode</code>].",null,null],[8,"FromStr","","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",36,null],[10,"from_str","","Parses a string <code>s</code> to return a value of this type.",36,[[["str",15]],["result",4]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a …",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method <code>lines_any</code>.",null,null],[3,"MatchIndices","","Created with the method <code>match_indices</code>.",null,null],[3,"RMatchIndices","","Created with the method <code>rmatch_indices</code>.",null,null],[3,"Matches","","Created with the method <code>matches</code>.",null,null],[3,"RMatches","","Created with the method <code>rmatches</code>.",null,null],[3,"RSplit","","Created with the method <code>rsplit</code>.",null,null],[3,"Split","","Created with the method <code>split</code>.",null,null],[3,"RSplitN","","Created with the method <code>rsplitn</code>.",null,null],[3,"SplitN","","Created with the method <code>splitn</code>.",null,null],[3,"RSplitTerminator","","Created with the method <code>rsplit_terminator</code>.",null,null],[3,"SplitTerminator","","Created with the method <code>split_terminator</code>.",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice …",null,[[["box",3]],[["box",3],["str",15]]]],[0,"string","alloc","A UTF-8–encoded, growable string.",null,null],[3,"String","alloc::string","A UTF-8–encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a <code>String</code> from a …",null,null],[3,"FromUtf16Error","","A possible error value when converting a <code>String</code> from a …",null,null],[11,"new","","Creates a new empty <code>String</code>.",37,[[],["string",3]]],[11,"with_capacity","","Creates a new empty <code>String</code> with a particular capacity.",37,[[["usize",15]],["string",3]]],[11,"from_utf8","","Converts a vector of bytes to a <code>String</code>.",37,[[["vec",3],["u8",15]],[["fromutf8error",3],["string",3],["result",4]]]],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid …",37,[[],[["cow",4],["str",15]]]],[11,"from_utf16","","Decode a UTF-16–encoded vector <code>v</code> into a <code>String</code>, …",37,[[],[["result",4],["string",3],["fromutf16error",3]]]],[11,"from_utf16_lossy","","Decode a UTF-16–encoded slice <code>v</code> into a <code>String</code>, replacing…",37,[[],["string",3]]],[11,"into_raw_parts","","Decomposes a <code>String</code> into its raw components.",37,[[]]],[11,"from_raw_parts","","Creates a new <code>String</code> from a length, capacity, and pointer.",37,[[["usize",15]],["string",3]]],[11,"from_utf8_unchecked","","Converts a vector of bytes to a <code>String</code> without checking …",37,[[["vec",3],["u8",15]],["string",3]]],[11,"into_bytes","","Converts a <code>String</code> into a byte vector.",37,[[],[["vec",3],["u8",15]]]],[11,"as_str","","Extracts a string slice containing the entire <code>String</code>.",37,[[],["str",15]]],[11,"as_mut_str","","Converts a <code>String</code> into a mutable string slice.",37,[[],["str",15]]],[11,"push_str","","Appends a given string slice onto the end of this <code>String</code>.",37,[[["str",15]]]],[11,"capacity","","Returns this <code>String</code>\'s capacity, in bytes.",37,[[],["usize",15]]],[11,"reserve","","Ensures that this <code>String</code>\'s capacity is at least <code>additional</code>…",37,[[["usize",15]]]],[11,"reserve_exact","","Ensures that this <code>String</code>\'s capacity is <code>additional</code> bytes …",37,[[["usize",15]]]],[11,"try_reserve","","Tries to reserve capacity for at least <code>additional</code> more …",37,[[["usize",15]],[["result",4],["tryreserveerror",4]]]],[11,"try_reserve_exact","","Tries to reserve the minimum capacity for exactly …",37,[[["usize",15]],[["result",4],["tryreserveerror",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of this <code>String</code> to match its length.",37,[[]]],[11,"shrink_to","","Shrinks the capacity of this <code>String</code> with a lower bound.",37,[[["usize",15]]]],[11,"push","","Appends the given [<code>char</code>] to the end of this <code>String</code>.",37,[[["char",15]]]],[11,"as_bytes","","Returns a byte slice of this <code>String</code>\'s contents.",37,[[]]],[11,"truncate","","Shortens this <code>String</code> to the specified length.",37,[[["usize",15]]]],[11,"pop","","Removes the last character from the string buffer and …",37,[[],[["option",4],["char",15]]]],[11,"remove","","Removes a [<code>char</code>] from this <code>String</code> at a byte position and …",37,[[["usize",15]],["char",15]]],[11,"retain","","Retains only the characters specified by the predicate.",37,[[]]],[11,"insert","","Inserts a character into this <code>String</code> at a byte position.",37,[[["usize",15],["char",15]]]],[11,"insert_str","","Inserts a string slice into this <code>String</code> at a byte …",37,[[["usize",15],["str",15]]]],[11,"as_mut_vec","","Returns a mutable reference to the contents of this <code>String</code>…",37,[[],["vec",3]]],[11,"len","","Returns the length of this <code>String</code>, in bytes, not [<code>char</code>]s …",37,[[],["usize",15]]],[11,"is_empty","","Returns <code>true</code> if this <code>String</code> has a length of zero, and …",37,[[],["bool",15]]],[11,"split_off","","Splits the string into two at the given byte index.",37,[[["usize",15]],["string",3]]],[11,"clear","","Truncates this <code>String</code>, removing all contents.",37,[[]]],[11,"drain","","Creates a draining iterator that removes the specified …",37,[[],["drain",3]]],[11,"replace_range","","Removes the specified range in the string, and replaces …",37,[[["str",15]]]],[11,"into_boxed_str","","Converts this <code>String</code> into a [<code>Box</code>]<code><</code><code>str</code><code>></code>.",37,[[],[["box",3],["str",15]]]],[11,"as_bytes","","Returns a slice of [<code>u8</code>]s bytes that were attempted to …",38,[[]]],[11,"into_bytes","","Returns the bytes that were attempted to convert to a …",38,[[],[["vec",3],["u8",15]]]],[11,"utf8_error","","Fetch a <code>Utf8Error</code> to get more details about the …",38,[[],["utf8error",3]]],[6,"ParseError","","A type alias for <code>Infallible</code>.",null,null],[8,"ToString","","A trait for converting a value to a <code>String</code>.",null,null],[10,"to_string","","Converts the given value to a <code>String</code>.",39,[[],["string",3]]],[3,"Drain","","A draining iterator for <code>String</code>.",null,null],[11,"as_str","","Returns the remaining (sub)string of this iterator as a …",40,[[],["str",15]]],[0,"sync","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::sync","A thread-safe reference-counting pointer. \'Arc\' stands …",null,null],[3,"Weak","","<code>Weak</code> is a version of [<code>Arc</code>] that holds a non-owning …",null,null],[11,"new","","Constructs a new <code>Arc<T></code>.",41,[[],["arc",3]]],[11,"new_cyclic","","Constructs a new <code>Arc<T></code> using a weak reference to itself. …",41,[[],["arc",3]]],[11,"new_uninit","","Constructs a new <code>Arc</code> with uninitialized contents.",41,[[],[["arc",3],["maybeuninit",19]]]],[11,"new_zeroed","","Constructs a new <code>Arc</code> with uninitialized contents, with …",41,[[],[["arc",3],["maybeuninit",19]]]],[11,"pin","","Constructs a new <code>Pin<Arc<T>></code>. If <code>T</code> does not implement …",41,[[],[["pin",3],["arc",3]]]],[11,"try_new","","Constructs a new <code>Arc<T></code>, returning an error if allocation …",41,[[],[["arc",3],["allocerror",3],["result",4]]]],[11,"try_new_uninit","","Constructs a new <code>Arc</code> with uninitialized contents, …",41,[[],[["result",4],["arc",3],["allocerror",3]]]],[11,"try_new_zeroed","","Constructs a new <code>Arc</code> with uninitialized contents, with …",41,[[],[["result",4],["arc",3],["allocerror",3]]]],[11,"try_unwrap","","Returns the inner value, if the <code>Arc</code> has exactly one …",41,[[],["result",4]]],[11,"new_uninit_slice","","Constructs a new atomically reference-counted slice with …",41,[[["usize",15]],["arc",3]]],[11,"new_zeroed_slice","","Constructs a new atomically reference-counted slice with …",41,[[["usize",15]],["arc",3]]],[11,"assume_init","","Converts to <code>Arc<T></code>.",41,[[],["arc",3]]],[11,"assume_init","","Converts to <code>Arc<[T]></code>.",41,[[],["arc",3]]],[11,"into_raw","","Consumes the <code>Arc</code>, returning the wrapped pointer.",41,[[]]],[11,"as_ptr","","Provides a raw pointer to the data.",41,[[]]],[11,"from_raw","","Constructs an <code>Arc<T></code> from a raw pointer.",41,[[]]],[11,"downgrade","","Creates a new [<code>Weak</code>] pointer to this allocation.",41,[[],["weak",3]]],[11,"weak_count","","Gets the number of [<code>Weak</code>] pointers to this allocation.",41,[[],["usize",15]]],[11,"strong_count","","Gets the number of strong (<code>Arc</code>) pointers to this …",41,[[],["usize",15]]],[11,"increment_strong_count","","Increments the strong reference count on the <code>Arc<T></code> …",41,[[]]],[11,"decrement_strong_count","","Decrements the strong reference count on the <code>Arc<T></code> …",41,[[]]],[11,"ptr_eq","","Returns <code>true</code> if the two <code>Arc</code>s point to the same allocation …",41,[[],["bool",15]]],[11,"make_mut","","Makes a mutable reference into the given <code>Arc</code>.",41,[[]]],[11,"get_mut","","Returns a mutable reference into the given <code>Arc</code>, if there …",41,[[],["option",4]]],[11,"get_mut_unchecked","","Returns a mutable reference into the given <code>Arc</code>, without …",41,[[]]],[11,"downcast","","Attempt to downcast the <code>Arc<dyn Any + Send + Sync></code> to a …",41,[[],[["arc",3],["result",4]]]],[11,"new","","Constructs a new <code>Weak<T></code>, without allocating any memory. …",42,[[],["weak",3]]],[11,"as_ptr","","Returns a raw pointer to the object <code>T</code> pointed to by this …",42,[[]]],[11,"into_raw","","Consumes the <code>Weak<T></code> and turns it into a raw pointer.",42,[[]]],[11,"from_raw","","Converts a raw pointer previously created by <code>into_raw</code> …",42,[[]]],[11,"upgrade","","Attempts to upgrade the <code>Weak</code> pointer to an [<code>Arc</code>], delaying…",42,[[],[["option",4],["arc",3]]]],[11,"strong_count","","Gets the number of strong (<code>Arc</code>) pointers pointing to this …",42,[[],["usize",15]]],[11,"weak_count","","Gets an approximation of the number of <code>Weak</code> pointers …",42,[[],["usize",15]]],[11,"ptr_eq","","Returns <code>true</code> if the two <code>Weak</code>s point to the same …",42,[[],["bool",15]]],[0,"task","alloc","Types and Traits for working with asynchronous tasks.",null,null],[8,"Wake","alloc::task","The implementation of waking a task on an executor.",null,null],[10,"wake","","Wake this task.",43,[[["arc",3]]]],[11,"wake_by_ref","","Wake this task without consuming the waker.",43,[[["arc",3]]]],[0,"vec","alloc","A contiguous growable array type with heap-allocated …",null,null],[3,"DrainFilter","alloc::vec","An iterator which uses a closure to determine if an …",null,null],[3,"Splice","","A splicing iterator for <code>Vec</code>.",null,null],[3,"Drain","","A draining iterator for <code>Vec<T></code>.",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Vec","","A contiguous growable array type, written <code>Vec<T></code> but …",null,null],[11,"new","","Constructs a new, empty <code>Vec<T></code>.",44,[[]]],[11,"with_capacity","","Constructs a new, empty <code>Vec<T></code> with the specified …",44,[[["usize",15]]]],[11,"from_raw_parts","","Creates a <code>Vec<T></code> directly from the raw components of …",44,[[["usize",15]]]],[11,"new_in","","Constructs a new, empty <code>Vec<T, A></code>.",44,[[]]],[11,"with_capacity_in","","Constructs a new, empty <code>Vec<T, A></code> with the specified …",44,[[["usize",15]]]],[11,"from_raw_parts_in","","Creates a <code>Vec<T, A></code> directly from the raw components of …",44,[[["usize",15]]]],[11,"into_raw_parts","","Decomposes a <code>Vec<T></code> into its raw components.",44,[[]]],[11,"into_raw_parts_with_alloc","","Decomposes a <code>Vec<T></code> into its raw components.",44,[[]]],[11,"capacity","","Returns the number of elements the vector can hold without…",44,[[],["usize",15]]],[11,"reserve","","Reserves capacity for at least <code>additional</code> more elements …",44,[[["usize",15]]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly <code>additional</code> more …",44,[[["usize",15]]]],[11,"try_reserve","","Tries to reserve capacity for at least <code>additional</code> more …",44,[[["usize",15]],[["result",4],["tryreserveerror",4]]]],[11,"try_reserve_exact","","Tries to reserve the minimum capacity for exactly …",44,[[["usize",15]],[["result",4],["tryreserveerror",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",44,[[]]],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",44,[[["usize",15]]]],[11,"into_boxed_slice","","Converts the vector into <code>Box<[T]></code>.",44,[[],["box",3]]],[11,"truncate","","Shortens the vector, keeping the first <code>len</code> elements and …",44,[[["usize",15]]]],[11,"as_slice","","Extracts a slice containing the entire vector.",44,[[]]],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",44,[[]]],[11,"as_ptr","","Returns a raw pointer to the vector\'s buffer.",44,[[]]],[11,"as_mut_ptr","","Returns an unsafe mutable pointer to the vector\'s buffer.",44,[[]]],[11,"allocator","","Returns a reference to the underlying allocator.",44,[[]]],[11,"set_len","","Forces the length of the vector to <code>new_len</code>.",44,[[["usize",15]]]],[11,"swap_remove","","Removes an element from the vector and returns it.",44,[[["usize",15]]]],[11,"insert","","Inserts an element at position <code>index</code> within the vector, …",44,[[["usize",15]]]],[11,"remove","","Removes and returns the element at position <code>index</code> within …",44,[[["usize",15]]]],[11,"retain","","Retains only the elements specified by the predicate.",44,[[]]],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the …",44,[[]]],[11,"dedup_by","","Removes all but the first of consecutive elements in the …",44,[[]]],[11,"push","","Appends an element to the back of a collection.",44,[[]]],[11,"pop","","Removes the last element from a vector and returns it, or …",44,[[],["option",4]]],[11,"append","","Moves all the elements of <code>other</code> into <code>Self</code>, leaving <code>other</code> …",44,[[]]],[11,"drain","","Creates a draining iterator that removes the specified …",44,[[],["drain",3]]],[11,"clear","","Clears the vector, removing all values.",44,[[]]],[11,"len","","Returns the number of elements in the vector, also …",44,[[],["usize",15]]],[11,"is_empty","","Returns <code>true</code> if the vector contains no elements.",44,[[],["bool",15]]],[11,"split_off","","Splits the collection into two at the given index.",44,[[["usize",15]]]],[11,"resize_with","","Resizes the <code>Vec</code> in-place so that <code>len</code> is equal to <code>new_len</code>.",44,[[["usize",15]]]],[11,"leak","","Consumes and leaks the <code>Vec</code>, returning a mutable reference …",44,[[]]],[11,"spare_capacity_mut","","Returns the remaining spare capacity of the vector as a …",44,[[]]],[11,"resize","","Resizes the <code>Vec</code> in-place so that <code>len</code> is equal to <code>new_len</code>.",44,[[["usize",15]]]],[11,"extend_from_slice","","Clones and appends all elements in a slice to the <code>Vec</code>.",44,[[]]],[11,"extend_from_within","","Copies elements from <code>src</code> range to the end of the vector.",44,[[]]],[11,"dedup","","Removes consecutive repeated elements in the vector …",44,[[]]],[11,"splice","","Creates a splicing iterator that replaces the specified …",44,[[],["splice",3]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if …",44,[[],["drainfilter",3]]],[14,"vec","alloc","Creates a <code>Vec</code> containing the arguments.",null,null],[14,"format","","Creates a <code>String</code> using interpolation of runtime …",null,null],[11,"to_owned","alloc::alloc","",45,[[]]],[11,"clone_into","","",45,[[]]],[11,"to_string","","",45,[[],["string",3]]],[11,"from","","",45,[[]]],[11,"borrow","","",45,[[]]],[11,"borrow_mut","","",45,[[]]],[11,"try_from","","",45,[[],["result",4]]],[11,"into","","",45,[[]]],[11,"try_into","","",45,[[],["result",4]]],[11,"type_id","","",45,[[],["typeid",3]]],[11,"to_owned","","",46,[[]]],[11,"clone_into","","",46,[[]]],[11,"from","","",46,[[]]],[11,"borrow","","",46,[[]]],[11,"borrow_mut","","",46,[[]]],[11,"try_from","","",46,[[],["result",4]]],[11,"into","","",46,[[]]],[11,"try_into","","",46,[[],["result",4]]],[11,"type_id","","",46,[[],["typeid",3]]],[11,"to_owned","","",47,[[]]],[11,"clone_into","","",47,[[]]],[11,"to_string","","",47,[[],["string",3]]],[11,"from","","",47,[[]]],[11,"borrow","","",47,[[]]],[11,"borrow_mut","","",47,[[]]],[11,"try_from","","",47,[[],["result",4]]],[11,"into","","",47,[[]]],[11,"try_into","","",47,[[],["result",4]]],[11,"type_id","","",47,[[],["typeid",3]]],[11,"to_owned","","",48,[[]]],[11,"clone_into","","",48,[[]]],[11,"from","","",48,[[]]],[11,"borrow","","",48,[[]]],[11,"borrow_mut","","",48,[[]]],[11,"try_from","","",48,[[],["result",4]]],[11,"into","","",48,[[]]],[11,"try_into","","",48,[[],["result",4]]],[11,"type_id","","",48,[[],["typeid",3]]],[11,"to_owned","alloc::boxed","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"to_string","","",2,[[],["string",3]]],[11,"from","","",2,[[]]],[11,"from","","",2,[[]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"into","","",2,[[]]],[11,"try_into","","",2,[[],["result",4]]],[11,"into_searcher","","",2,[[["str",15]],["charpredicatesearcher",3]]],[11,"is_contained_in","","",2,[[["str",15]],["bool",15]]],[11,"is_prefix_of","","",2,[[["str",15]],["bool",15]]],[11,"strip_prefix_of","","",2,[[["str",15]],[["option",4],["str",15]]]],[11,"is_suffix_of","","",2,[[["str",15]],["bool",15]]],[11,"strip_suffix_of","","",2,[[["str",15]],[["option",4],["str",15]]]],[11,"into_iter","","",2,[[]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"into_future","","",2,[[]]],[11,"to_owned","alloc::borrow","",6,[[]]],[11,"clone_into","","",6,[[]]],[11,"to_string","","",6,[[],["string",3]]],[11,"from","","",6,[[]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"try_from","","",6,[[],["result",4]]],[11,"into","","",6,[[]]],[11,"try_into","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"to_owned","alloc::collections::binary_heap","",8,[[]]],[11,"clone_into","","",8,[[]]],[11,"from","","",8,[[]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"into","","",8,[[]]],[11,"try_into","","",8,[[],["result",4]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"from","","",7,[[]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"try_from","","",7,[[],["result",4]]],[11,"into","","",7,[[]]],[11,"try_into","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"to_owned","","",49,[[]]],[11,"clone_into","","",49,[[]]],[11,"from","","",49,[[]]],[11,"borrow","","",49,[[]]],[11,"borrow_mut","","",49,[[]]],[11,"try_from","","",49,[[],["result",4]]],[11,"into","","",49,[[]]],[11,"try_into","","",49,[[],["result",4]]],[11,"into_iter","","",49,[[]]],[11,"type_id","","",49,[[],["typeid",3]]],[11,"to_owned","","",50,[[]]],[11,"clone_into","","",50,[[]]],[11,"from","","",50,[[]]],[11,"borrow","","",50,[[]]],[11,"borrow_mut","","",50,[[]]],[11,"try_from","","",50,[[],["result",4]]],[11,"into","","",50,[[]]],[11,"try_into","","",50,[[],["result",4]]],[11,"into_iter","","",50,[[]]],[11,"type_id","","",50,[[],["typeid",3]]],[11,"to_owned","","",51,[[]]],[11,"clone_into","","",51,[[]]],[11,"from","","",51,[[]]],[11,"borrow","","",51,[[]]],[11,"borrow_mut","","",51,[[]]],[11,"try_from","","",51,[[],["result",4]]],[11,"into","","",51,[[]]],[11,"try_into","","",51,[[],["result",4]]],[11,"into_iter","","",51,[[]]],[11,"type_id","","",51,[[],["typeid",3]]],[11,"from","","",52,[[]]],[11,"borrow","","",52,[[]]],[11,"borrow_mut","","",52,[[]]],[11,"try_from","","",52,[[],["result",4]]],[11,"into","","",52,[[]]],[11,"try_into","","",52,[[],["result",4]]],[11,"into_iter","","",52,[[]]],[11,"type_id","","",52,[[],["typeid",3]]],[11,"from","","",53,[[]]],[11,"borrow","","",53,[[]]],[11,"borrow_mut","","",53,[[]]],[11,"try_from","","",53,[[],["result",4]]],[11,"into","","",53,[[]]],[11,"try_into","","",53,[[],["result",4]]],[11,"into_iter","","",53,[[]]],[11,"type_id","","",53,[[],["typeid",3]]],[11,"from","alloc::collections::btree_map","",13,[[]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"try_from","","",13,[[],["result",4]]],[11,"into","","",13,[[]]],[11,"try_into","","",13,[[],["result",4]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"from","","",54,[[]]],[11,"borrow","","",54,[[]]],[11,"borrow_mut","","",54,[[]]],[11,"try_from","","",54,[[],["result",4]]],[11,"into","","",54,[[]]],[11,"try_into","","",54,[[],["result",4]]],[11,"type_id","","",54,[[],["typeid",3]]],[11,"from","","",55,[[]]],[11,"borrow","","",55,[[]]],[11,"borrow_mut","","",55,[[]]],[11,"try_from","","",55,[[],["result",4]]],[11,"into","","",55,[[]]],[11,"try_into","","",55,[[],["result",4]]],[11,"type_id","","",55,[[],["typeid",3]]],[11,"to_owned","","",56,[[]]],[11,"clone_into","","",56,[[]]],[11,"from","","",56,[[]]],[11,"borrow","","",56,[[]]],[11,"borrow_mut","","",56,[[]]],[11,"try_from","","",56,[[],["result",4]]],[11,"into","","",56,[[]]],[11,"try_into","","",56,[[],["result",4]]],[11,"type_id","","",56,[[],["typeid",3]]],[11,"to_owned","","",57,[[]]],[11,"clone_into","","",57,[[]]],[11,"from","","",57,[[]]],[11,"borrow","","",57,[[]]],[11,"borrow_mut","","",57,[[]]],[11,"try_from","","",57,[[],["result",4]]],[11,"into","","",57,[[]]],[11,"try_into","","",57,[[],["result",4]]],[11,"into_iter","","",57,[[]]],[11,"type_id","","",57,[[],["typeid",3]]],[11,"from","","",58,[[]]],[11,"borrow","","",58,[[]]],[11,"borrow_mut","","",58,[[]]],[11,"try_from","","",58,[[],["result",4]]],[11,"into","","",58,[[]]],[11,"try_into","","",58,[[],["result",4]]],[11,"into_iter","","",58,[[]]],[11,"type_id","","",58,[[],["typeid",3]]],[11,"from","","",59,[[]]],[11,"borrow","","",59,[[]]],[11,"borrow_mut","","",59,[[]]],[11,"try_from","","",59,[[],["result",4]]],[11,"into","","",59,[[]]],[11,"try_into","","",59,[[],["result",4]]],[11,"into_iter","","",59,[[]]],[11,"type_id","","",59,[[],["typeid",3]]],[11,"to_owned","","",60,[[]]],[11,"clone_into","","",60,[[]]],[11,"from","","",60,[[]]],[11,"borrow","","",60,[[]]],[11,"borrow_mut","","",60,[[]]],[11,"try_from","","",60,[[],["result",4]]],[11,"into","","",60,[[]]],[11,"try_into","","",60,[[],["result",4]]],[11,"into_iter","","",60,[[]]],[11,"type_id","","",60,[[],["typeid",3]]],[11,"to_owned","","",61,[[]]],[11,"clone_into","","",61,[[]]],[11,"from","","",61,[[]]],[11,"borrow","","",61,[[]]],[11,"borrow_mut","","",61,[[]]],[11,"try_from","","",61,[[],["result",4]]],[11,"into","","",61,[[]]],[11,"try_into","","",61,[[],["result",4]]],[11,"into_iter","","",61,[[]]],[11,"type_id","","",61,[[],["typeid",3]]],[11,"from","","",62,[[]]],[11,"borrow","","",62,[[]]],[11,"borrow_mut","","",62,[[]]],[11,"try_from","","",62,[[],["result",4]]],[11,"into","","",62,[[]]],[11,"try_into","","",62,[[],["result",4]]],[11,"into_iter","","",62,[[]]],[11,"type_id","","",62,[[],["typeid",3]]],[11,"from","","",63,[[]]],[11,"borrow","","",63,[[]]],[11,"borrow_mut","","",63,[[]]],[11,"try_from","","",63,[[],["result",4]]],[11,"into","","",63,[[]]],[11,"try_into","","",63,[[],["result",4]]],[11,"into_iter","","",63,[[]]],[11,"type_id","","",63,[[],["typeid",3]]],[11,"from","","",64,[[]]],[11,"borrow","","",64,[[]]],[11,"borrow_mut","","",64,[[]]],[11,"try_from","","",64,[[],["result",4]]],[11,"into","","",64,[[]]],[11,"try_into","","",64,[[],["result",4]]],[11,"into_iter","","",64,[[]]],[11,"type_id","","",64,[[],["typeid",3]]],[11,"to_owned","","",65,[[]]],[11,"clone_into","","",65,[[]]],[11,"from","","",65,[[]]],[11,"borrow","","",65,[[]]],[11,"borrow_mut","","",65,[[]]],[11,"try_from","","",65,[[],["result",4]]],[11,"into","","",65,[[]]],[11,"try_into","","",65,[[],["result",4]]],[11,"into_iter","","",65,[[]]],[11,"type_id","","",65,[[],["typeid",3]]],[11,"from","","",66,[[]]],[11,"borrow","","",66,[[]]],[11,"borrow_mut","","",66,[[]]],[11,"try_from","","",66,[[],["result",4]]],[11,"into","","",66,[[]]],[11,"try_into","","",66,[[],["result",4]]],[11,"into_iter","","",66,[[]]],[11,"type_id","","",66,[[],["typeid",3]]],[11,"from","","",67,[[]]],[11,"borrow","","",67,[[]]],[11,"borrow_mut","","",67,[[]]],[11,"try_from","","",67,[[],["result",4]]],[11,"into","","",67,[[]]],[11,"try_into","","",67,[[],["result",4]]],[11,"into_iter","","",67,[[]]],[11,"type_id","","",67,[[],["typeid",3]]],[11,"to_owned","alloc::collections::btree_set","",68,[[]]],[11,"clone_into","","",68,[[]]],[11,"from","","",68,[[]]],[11,"borrow","","",68,[[]]],[11,"borrow_mut","","",68,[[]]],[11,"try_from","","",68,[[],["result",4]]],[11,"into","","",68,[[]]],[11,"try_into","","",68,[[],["result",4]]],[11,"type_id","","",68,[[],["typeid",3]]],[11,"to_owned","","",69,[[]]],[11,"clone_into","","",69,[[]]],[11,"from","","",69,[[]]],[11,"borrow","","",69,[[]]],[11,"borrow_mut","","",69,[[]]],[11,"try_from","","",69,[[],["result",4]]],[11,"into","","",69,[[]]],[11,"try_into","","",69,[[],["result",4]]],[11,"into_iter","","",69,[[]]],[11,"type_id","","",69,[[],["typeid",3]]],[11,"from","","",70,[[]]],[11,"borrow","","",70,[[]]],[11,"borrow_mut","","",70,[[]]],[11,"try_from","","",70,[[],["result",4]]],[11,"into","","",70,[[]]],[11,"try_into","","",70,[[],["result",4]]],[11,"into_iter","","",70,[[]]],[11,"type_id","","",70,[[],["typeid",3]]],[11,"to_owned","","",71,[[]]],[11,"clone_into","","",71,[[]]],[11,"from","","",71,[[]]],[11,"borrow","","",71,[[]]],[11,"borrow_mut","","",71,[[]]],[11,"try_from","","",71,[[],["result",4]]],[11,"into","","",71,[[]]],[11,"try_into","","",71,[[],["result",4]]],[11,"into_iter","","",71,[[]]],[11,"type_id","","",71,[[],["typeid",3]]],[11,"to_owned","","",72,[[]]],[11,"clone_into","","",72,[[]]],[11,"from","","",72,[[]]],[11,"borrow","","",72,[[]]],[11,"borrow_mut","","",72,[[]]],[11,"try_from","","",72,[[],["result",4]]],[11,"into","","",72,[[]]],[11,"try_into","","",72,[[],["result",4]]],[11,"into_iter","","",72,[[]]],[11,"type_id","","",72,[[],["typeid",3]]],[11,"to_owned","","",73,[[]]],[11,"clone_into","","",73,[[]]],[11,"from","","",73,[[]]],[11,"borrow","","",73,[[]]],[11,"borrow_mut","","",73,[[]]],[11,"try_from","","",73,[[],["result",4]]],[11,"into","","",73,[[]]],[11,"try_into","","",73,[[],["result",4]]],[11,"into_iter","","",73,[[]]],[11,"type_id","","",73,[[],["typeid",3]]],[11,"to_owned","","",74,[[]]],[11,"clone_into","","",74,[[]]],[11,"from","","",74,[[]]],[11,"borrow","","",74,[[]]],[11,"borrow_mut","","",74,[[]]],[11,"try_from","","",74,[[],["result",4]]],[11,"into","","",74,[[]]],[11,"try_into","","",74,[[],["result",4]]],[11,"into_iter","","",74,[[]]],[11,"type_id","","",74,[[],["typeid",3]]],[11,"to_owned","","",75,[[]]],[11,"clone_into","","",75,[[]]],[11,"from","","",75,[[]]],[11,"borrow","","",75,[[]]],[11,"borrow_mut","","",75,[[]]],[11,"try_from","","",75,[[],["result",4]]],[11,"into","","",75,[[]]],[11,"try_into","","",75,[[],["result",4]]],[11,"into_iter","","",75,[[]]],[11,"type_id","","",75,[[],["typeid",3]]],[11,"from","","",76,[[]]],[11,"borrow","","",76,[[]]],[11,"borrow_mut","","",76,[[]]],[11,"try_from","","",76,[[],["result",4]]],[11,"into","","",76,[[]]],[11,"try_into","","",76,[[],["result",4]]],[11,"into_iter","","",76,[[]]],[11,"type_id","","",76,[[],["typeid",3]]],[11,"to_owned","alloc::collections::linked_list","",9,[[]]],[11,"clone_into","","",9,[[]]],[11,"from","","",9,[[]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"into","","",9,[[]]],[11,"try_into","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"to_owned","","",77,[[]]],[11,"clone_into","","",77,[[]]],[11,"from","","",77,[[]]],[11,"borrow","","",77,[[]]],[11,"borrow_mut","","",77,[[]]],[11,"try_from","","",77,[[],["result",4]]],[11,"into","","",77,[[]]],[11,"try_into","","",77,[[],["result",4]]],[11,"into_iter","","",77,[[]]],[11,"type_id","","",77,[[],["typeid",3]]],[11,"from","","",78,[[]]],[11,"borrow","","",78,[[]]],[11,"borrow_mut","","",78,[[]]],[11,"try_from","","",78,[[],["result",4]]],[11,"into","","",78,[[]]],[11,"try_into","","",78,[[],["result",4]]],[11,"into_iter","","",78,[[]]],[11,"type_id","","",78,[[],["typeid",3]]],[11,"to_owned","","",79,[[]]],[11,"clone_into","","",79,[[]]],[11,"from","","",79,[[]]],[11,"borrow","","",79,[[]]],[11,"borrow_mut","","",79,[[]]],[11,"try_from","","",79,[[],["result",4]]],[11,"into","","",79,[[]]],[11,"try_into","","",79,[[],["result",4]]],[11,"into_iter","","",79,[[]]],[11,"type_id","","",79,[[],["typeid",3]]],[11,"to_owned","","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"from","","",10,[[]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"into","","",10,[[]]],[11,"try_into","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"from","","",11,[[]]],[11,"borrow","","",11,[[]]],[11,"borrow_mut","","",11,[[]]],[11,"try_from","","",11,[[],["result",4]]],[11,"into","","",11,[[]]],[11,"try_into","","",11,[[],["result",4]]],[11,"type_id","","",11,[[],["typeid",3]]],[11,"from","","",80,[[]]],[11,"borrow","","",80,[[]]],[11,"borrow_mut","","",80,[[]]],[11,"try_from","","",80,[[],["result",4]]],[11,"into","","",80,[[]]],[11,"try_into","","",80,[[],["result",4]]],[11,"into_iter","","",80,[[]]],[11,"type_id","","",80,[[],["typeid",3]]],[11,"from","alloc::collections::vec_deque","",81,[[]]],[11,"borrow","","",81,[[]]],[11,"borrow_mut","","",81,[[]]],[11,"try_from","","",81,[[],["result",4]]],[11,"into","","",81,[[]]],[11,"try_into","","",81,[[],["result",4]]],[11,"into_iter","","",81,[[]]],[11,"type_id","","",81,[[],["typeid",3]]],[11,"from","","",82,[[]]],[11,"borrow","","",82,[[]]],[11,"borrow_mut","","",82,[[]]],[11,"try_from","","",82,[[],["result",4]]],[11,"into","","",82,[[]]],[11,"try_into","","",82,[[],["result",4]]],[11,"into_iter","","",82,[[]]],[11,"type_id","","",82,[[],["typeid",3]]],[11,"to_owned","","",83,[[]]],[11,"clone_into","","",83,[[]]],[11,"from","","",83,[[]]],[11,"borrow","","",83,[[]]],[11,"borrow_mut","","",83,[[]]],[11,"try_from","","",83,[[],["result",4]]],[11,"into","","",83,[[]]],[11,"try_into","","",83,[[],["result",4]]],[11,"into_iter","","",83,[[]]],[11,"type_id","","",83,[[],["typeid",3]]],[11,"to_owned","","",84,[[]]],[11,"clone_into","","",84,[[]]],[11,"from","","",84,[[]]],[11,"borrow","","",84,[[]]],[11,"borrow_mut","","",84,[[]]],[11,"try_from","","",84,[[],["result",4]]],[11,"into","","",84,[[]]],[11,"try_into","","",84,[[],["result",4]]],[11,"into_iter","","",84,[[]]],[11,"type_id","","",84,[[],["typeid",3]]],[11,"to_owned","","",12,[[]]],[11,"clone_into","","",12,[[]]],[11,"from","","",12,[[]]],[11,"borrow","","",12,[[]]],[11,"borrow_mut","","",12,[[]]],[11,"try_from","","",12,[[],["result",4]]],[11,"into","","",12,[[]]],[11,"try_into","","",12,[[],["result",4]]],[11,"type_id","","",12,[[],["typeid",3]]],[11,"to_owned","alloc::collections","",14,[[]]],[11,"clone_into","","",14,[[]]],[11,"to_string","","",14,[[],["string",3]]],[11,"from","","",14,[[]]],[11,"borrow","","",14,[[]]],[11,"borrow_mut","","",14,[[]]],[11,"try_from","","",14,[[],["result",4]]],[11,"into","","",14,[[]]],[11,"try_into","","",14,[[],["result",4]]],[11,"type_id","","",14,[[],["typeid",3]]],[11,"from","alloc::fmt","",16,[[]]],[11,"borrow","","",16,[[]]],[11,"borrow_mut","","",16,[[]]],[11,"try_from","","",16,[[],["result",4]]],[11,"into","","",16,[[]]],[11,"try_into","","",16,[[],["result",4]]],[11,"type_id","","",16,[[],["typeid",3]]],[11,"to_owned","","",85,[[]]],[11,"clone_into","","",85,[[]]],[11,"to_string","","",85,[[],["string",3]]],[11,"from","","",85,[[]]],[11,"borrow","","",85,[[]]],[11,"borrow_mut","","",85,[[]]],[11,"try_from","","",85,[[],["result",4]]],[11,"into","","",85,[[]]],[11,"try_into","","",85,[[],["result",4]]],[11,"type_id","","",85,[[],["typeid",3]]],[11,"to_owned","","",86,[[]]],[11,"clone_into","","",86,[[]]],[11,"to_string","","",86,[[],["string",3]]],[11,"from","","",86,[[]]],[11,"borrow","","",86,[[]]],[11,"borrow_mut","","",86,[[]]],[11,"try_from","","",86,[[],["result",4]]],[11,"into","","",86,[[]]],[11,"try_into","","",86,[[],["result",4]]],[11,"type_id","","",86,[[],["typeid",3]]],[11,"from","","",87,[[]]],[11,"borrow","","",87,[[]]],[11,"borrow_mut","","",87,[[]]],[11,"try_from","","",87,[[],["result",4]]],[11,"into","","",87,[[]]],[11,"try_into","","",87,[[],["result",4]]],[11,"type_id","","",87,[[],["typeid",3]]],[11,"from","","",88,[[]]],[11,"borrow","","",88,[[]]],[11,"borrow_mut","","",88,[[]]],[11,"try_from","","",88,[[],["result",4]]],[11,"into","","",88,[[]]],[11,"try_into","","",88,[[],["result",4]]],[11,"type_id","","",88,[[],["typeid",3]]],[11,"from","","",89,[[]]],[11,"borrow","","",89,[[]]],[11,"borrow_mut","","",89,[[]]],[11,"try_from","","",89,[[],["result",4]]],[11,"into","","",89,[[]]],[11,"try_into","","",89,[[],["result",4]]],[11,"type_id","","",89,[[],["typeid",3]]],[11,"from","","",90,[[]]],[11,"borrow","","",90,[[]]],[11,"borrow_mut","","",90,[[]]],[11,"try_from","","",90,[[],["result",4]]],[11,"into","","",90,[[]]],[11,"try_into","","",90,[[],["result",4]]],[11,"type_id","","",90,[[],["typeid",3]]],[11,"from","","",91,[[]]],[11,"borrow","","",91,[[]]],[11,"borrow_mut","","",91,[[]]],[11,"try_from","","",91,[[],["result",4]]],[11,"into","","",91,[[]]],[11,"try_into","","",91,[[],["result",4]]],[11,"type_id","","",91,[[],["typeid",3]]],[11,"from","","",92,[[]]],[11,"borrow","","",92,[[]]],[11,"borrow_mut","","",92,[[]]],[11,"try_from","","",92,[[],["result",4]]],[11,"into","","",92,[[]]],[11,"try_into","","",92,[[],["result",4]]],[11,"type_id","","",92,[[],["typeid",3]]],[11,"to_owned","alloc::rc","",27,[[]]],[11,"clone_into","","",27,[[]]],[11,"to_string","","",27,[[],["string",3]]],[11,"from","","",27,[[]]],[11,"from","","",27,[[]]],[11,"borrow","","",27,[[]]],[11,"borrow_mut","","",27,[[]]],[11,"try_from","","",27,[[],["result",4]]],[11,"into","","",27,[[]]],[11,"try_into","","",27,[[],["result",4]]],[11,"type_id","","",27,[[],["typeid",3]]],[11,"to_owned","","",28,[[]]],[11,"clone_into","","",28,[[]]],[11,"from","","",28,[[]]],[11,"borrow","","",28,[[]]],[11,"borrow_mut","","",28,[[]]],[11,"try_from","","",28,[[],["result",4]]],[11,"into","","",28,[[]]],[11,"try_into","","",28,[[],["result",4]]],[11,"type_id","","",28,[[],["typeid",3]]],[11,"to_owned","alloc::slice","",93,[[]]],[11,"clone_into","","",93,[[]]],[11,"from","","",93,[[]]],[11,"borrow","","",93,[[]]],[11,"borrow_mut","","",93,[[]]],[11,"try_from","","",93,[[],["result",4]]],[11,"into","","",93,[[]]],[11,"try_into","","",93,[[],["result",4]]],[11,"into_iter","","",93,[[]]],[11,"type_id","","",93,[[],["typeid",3]]],[11,"from","","",94,[[]]],[11,"borrow","","",94,[[]]],[11,"borrow_mut","","",94,[[]]],[11,"try_from","","",94,[[],["result",4]]],[11,"into","","",94,[[]]],[11,"try_into","","",94,[[],["result",4]]],[11,"into_iter","","",94,[[]]],[11,"type_id","","",94,[[],["typeid",3]]],[11,"to_owned","","",95,[[]]],[11,"clone_into","","",95,[[]]],[11,"from","","",95,[[]]],[11,"borrow","","",95,[[]]],[11,"borrow_mut","","",95,[[]]],[11,"try_from","","",95,[[],["result",4]]],[11,"into","","",95,[[]]],[11,"try_into","","",95,[[],["result",4]]],[11,"into_iter","","",95,[[]]],[11,"type_id","","",95,[[],["typeid",3]]],[11,"to_owned","","",96,[[]]],[11,"clone_into","","",96,[[]]],[11,"from","","",96,[[]]],[11,"borrow","","",96,[[]]],[11,"borrow_mut","","",96,[[]]],[11,"try_from","","",96,[[],["result",4]]],[11,"into","","",96,[[]]],[11,"try_into","","",96,[[],["result",4]]],[11,"into_iter","","",96,[[]]],[11,"type_id","","",96,[[],["typeid",3]]],[11,"to_owned","","",97,[[]]],[11,"clone_into","","",97,[[]]],[11,"from","","",97,[[]]],[11,"borrow","","",97,[[]]],[11,"borrow_mut","","",97,[[]]],[11,"try_from","","",97,[[],["result",4]]],[11,"into","","",97,[[]]],[11,"try_into","","",97,[[],["result",4]]],[11,"into_iter","","",97,[[]]],[11,"type_id","","",97,[[],["typeid",3]]],[11,"to_owned","","",98,[[]]],[11,"clone_into","","",98,[[]]],[11,"from","","",98,[[]]],[11,"borrow","","",98,[[]]],[11,"borrow_mut","","",98,[[]]],[11,"try_from","","",98,[[],["result",4]]],[11,"into","","",98,[[]]],[11,"try_into","","",98,[[],["result",4]]],[11,"into_iter","","",98,[[]]],[11,"type_id","","",98,[[],["typeid",3]]],[11,"from","","",99,[[]]],[11,"borrow","","",99,[[]]],[11,"borrow_mut","","",99,[[]]],[11,"try_from","","",99,[[],["result",4]]],[11,"into","","",99,[[]]],[11,"try_into","","",99,[[],["result",4]]],[11,"into_iter","","",99,[[]]],[11,"type_id","","",99,[[],["typeid",3]]],[11,"from","","",100,[[]]],[11,"borrow","","",100,[[]]],[11,"borrow_mut","","",100,[[]]],[11,"try_from","","",100,[[],["result",4]]],[11,"into","","",100,[[]]],[11,"try_into","","",100,[[],["result",4]]],[11,"into_iter","","",100,[[]]],[11,"type_id","","",100,[[],["typeid",3]]],[11,"to_owned","","",101,[[]]],[11,"clone_into","","",101,[[]]],[11,"from","","",101,[[]]],[11,"borrow","","",101,[[]]],[11,"borrow_mut","","",101,[[]]],[11,"try_from","","",101,[[],["result",4]]],[11,"into","","",101,[[]]],[11,"try_into","","",101,[[],["result",4]]],[11,"into_iter","","",101,[[]]],[11,"type_id","","",101,[[],["typeid",3]]],[11,"from","","",102,[[]]],[11,"borrow","","",102,[[]]],[11,"borrow_mut","","",102,[[]]],[11,"try_from","","",102,[[],["result",4]]],[11,"into","","",102,[[]]],[11,"try_into","","",102,[[],["result",4]]],[11,"into_iter","","",102,[[]]],[11,"type_id","","",102,[[],["typeid",3]]],[11,"from","","",103,[[]]],[11,"borrow","","",103,[[]]],[11,"borrow_mut","","",103,[[]]],[11,"try_from","","",103,[[],["result",4]]],[11,"into","","",103,[[]]],[11,"try_into","","",103,[[],["result",4]]],[11,"into_iter","","",103,[[]]],[11,"type_id","","",103,[[],["typeid",3]]],[11,"from","","",104,[[]]],[11,"borrow","","",104,[[]]],[11,"borrow_mut","","",104,[[]]],[11,"try_from","","",104,[[],["result",4]]],[11,"into","","",104,[[]]],[11,"try_into","","",104,[[],["result",4]]],[11,"into_iter","","",104,[[]]],[11,"type_id","","",104,[[],["typeid",3]]],[11,"to_owned","","",105,[[]]],[11,"clone_into","","",105,[[]]],[11,"from","","",105,[[]]],[11,"borrow","","",105,[[]]],[11,"borrow_mut","","",105,[[]]],[11,"try_from","","",105,[[],["result",4]]],[11,"into","","",105,[[]]],[11,"try_into","","",105,[[],["result",4]]],[11,"into_iter","","",105,[[]]],[11,"type_id","","",105,[[],["typeid",3]]],[11,"from","","",106,[[]]],[11,"borrow","","",106,[[]]],[11,"borrow_mut","","",106,[[]]],[11,"try_from","","",106,[[],["result",4]]],[11,"into","","",106,[[]]],[11,"try_into","","",106,[[],["result",4]]],[11,"into_iter","","",106,[[]]],[11,"type_id","","",106,[[],["typeid",3]]],[11,"to_owned","","",107,[[]]],[11,"clone_into","","",107,[[]]],[11,"from","","",107,[[]]],[11,"borrow","","",107,[[]]],[11,"borrow_mut","","",107,[[]]],[11,"try_from","","",107,[[],["result",4]]],[11,"into","","",107,[[]]],[11,"try_into","","",107,[[],["result",4]]],[11,"into_iter","","",107,[[]]],[11,"type_id","","",107,[[],["typeid",3]]],[11,"to_owned","","",108,[[]]],[11,"clone_into","","",108,[[]]],[11,"from","","",108,[[]]],[11,"borrow","","",108,[[]]],[11,"borrow_mut","","",108,[[]]],[11,"try_from","","",108,[[],["result",4]]],[11,"into","","",108,[[]]],[11,"try_into","","",108,[[],["result",4]]],[11,"into_iter","","",108,[[]]],[11,"type_id","","",108,[[],["typeid",3]]],[11,"from","","",109,[[]]],[11,"borrow","","",109,[[]]],[11,"borrow_mut","","",109,[[]]],[11,"try_from","","",109,[[],["result",4]]],[11,"into","","",109,[[]]],[11,"try_into","","",109,[[],["result",4]]],[11,"into_iter","","",109,[[]]],[11,"type_id","","",109,[[],["typeid",3]]],[11,"from","","",110,[[]]],[11,"borrow","","",110,[[]]],[11,"borrow_mut","","",110,[[]]],[11,"try_from","","",110,[[],["result",4]]],[11,"into","","",110,[[]]],[11,"try_into","","",110,[[],["result",4]]],[11,"into_iter","","",110,[[]]],[11,"type_id","","",110,[[],["typeid",3]]],[11,"to_owned","","",111,[[]]],[11,"clone_into","","",111,[[]]],[11,"from","","",111,[[]]],[11,"borrow","","",111,[[]]],[11,"borrow_mut","","",111,[[]]],[11,"try_from","","",111,[[],["result",4]]],[11,"into","","",111,[[]]],[11,"try_into","","",111,[[],["result",4]]],[11,"into_iter","","",111,[[]]],[11,"type_id","","",111,[[],["typeid",3]]],[11,"from","","",112,[[]]],[11,"borrow","","",112,[[]]],[11,"borrow_mut","","",112,[[]]],[11,"try_from","","",112,[[],["result",4]]],[11,"into","","",112,[[]]],[11,"try_into","","",112,[[],["result",4]]],[11,"into_iter","","",112,[[]]],[11,"type_id","","",112,[[],["typeid",3]]],[11,"from","","",113,[[]]],[11,"borrow","","",113,[[]]],[11,"borrow_mut","","",113,[[]]],[11,"try_from","","",113,[[],["result",4]]],[11,"into","","",113,[[]]],[11,"try_into","","",113,[[],["result",4]]],[11,"into_iter","","",113,[[]]],[11,"type_id","","",113,[[],["typeid",3]]],[11,"from","","",114,[[]]],[11,"borrow","","",114,[[]]],[11,"borrow_mut","","",114,[[]]],[11,"try_from","","",114,[[],["result",4]]],[11,"into","","",114,[[]]],[11,"try_into","","",114,[[],["result",4]]],[11,"into_iter","","",114,[[]]],[11,"type_id","","",114,[[],["typeid",3]]],[11,"from","","",115,[[]]],[11,"borrow","","",115,[[]]],[11,"borrow_mut","","",115,[[]]],[11,"try_from","","",115,[[],["result",4]]],[11,"into","","",115,[[]]],[11,"try_into","","",115,[[],["result",4]]],[11,"into_iter","","",115,[[]]],[11,"type_id","","",115,[[],["typeid",3]]],[11,"from","","",116,[[]]],[11,"borrow","","",116,[[]]],[11,"borrow_mut","","",116,[[]]],[11,"try_from","","",116,[[],["result",4]]],[11,"into","","",116,[[]]],[11,"try_into","","",116,[[],["result",4]]],[11,"into_iter","","",116,[[]]],[11,"type_id","","",116,[[],["typeid",3]]],[11,"to_owned","alloc::str::pattern","",33,[[]]],[11,"clone_into","","",33,[[]]],[11,"from","","",33,[[]]],[11,"borrow","","",33,[[]]],[11,"borrow_mut","","",33,[[]]],[11,"try_from","","",33,[[],["result",4]]],[11,"into","","",33,[[]]],[11,"try_into","","",33,[[],["result",4]]],[11,"type_id","","",33,[[],["typeid",3]]],[11,"to_owned","","",117,[[]]],[11,"clone_into","","",117,[[]]],[11,"from","","",117,[[]]],[11,"borrow","","",117,[[]]],[11,"borrow_mut","","",117,[[]]],[11,"try_from","","",117,[[],["result",4]]],[11,"into","","",117,[[]]],[11,"try_into","","",117,[[],["result",4]]],[11,"type_id","","",117,[[],["typeid",3]]],[11,"to_owned","","",118,[[]]],[11,"clone_into","","",118,[[]]],[11,"from","","",118,[[]]],[11,"borrow","","",118,[[]]],[11,"borrow_mut","","",118,[[]]],[11,"try_from","","",118,[[],["result",4]]],[11,"into","","",118,[[]]],[11,"try_into","","",118,[[],["result",4]]],[11,"type_id","","",118,[[],["typeid",3]]],[11,"to_owned","","",119,[[]]],[11,"clone_into","","",119,[[]]],[11,"from","","",119,[[]]],[11,"borrow","","",119,[[]]],[11,"borrow_mut","","",119,[[]]],[11,"try_from","","",119,[[],["result",4]]],[11,"into","","",119,[[]]],[11,"try_into","","",119,[[],["result",4]]],[11,"type_id","","",119,[[],["typeid",3]]],[11,"to_owned","","",120,[[]]],[11,"clone_into","","",120,[[]]],[11,"from","","",120,[[]]],[11,"borrow","","",120,[[]]],[11,"borrow_mut","","",120,[[]]],[11,"try_from","","",120,[[],["result",4]]],[11,"into","","",120,[[]]],[11,"try_into","","",120,[[],["result",4]]],[11,"type_id","","",120,[[],["typeid",3]]],[11,"to_owned","alloc::str","",121,[[]]],[11,"clone_into","","",121,[[]]],[11,"from","","",121,[[]]],[11,"borrow","","",121,[[]]],[11,"borrow_mut","","",121,[[]]],[11,"try_from","","",121,[[],["result",4]]],[11,"into","","",121,[[]]],[11,"try_into","","",121,[[],["result",4]]],[11,"into_iter","","",121,[[]]],[11,"type_id","","",121,[[],["typeid",3]]],[11,"to_owned","","",122,[[]]],[11,"clone_into","","",122,[[]]],[11,"from","","",122,[[]]],[11,"borrow","","",122,[[]]],[11,"borrow_mut","","",122,[[]]],[11,"try_from","","",122,[[],["result",4]]],[11,"into","","",122,[[]]],[11,"try_into","","",122,[[],["result",4]]],[11,"into_iter","","",122,[[]]],[11,"type_id","","",122,[[],["typeid",3]]],[11,"to_owned","","",123,[[]]],[11,"clone_into","","",123,[[]]],[11,"from","","",123,[[]]],[11,"borrow","","",123,[[]]],[11,"borrow_mut","","",123,[[]]],[11,"try_from","","",123,[[],["result",4]]],[11,"into","","",123,[[]]],[11,"try_into","","",123,[[],["result",4]]],[11,"into_iter","","",123,[[]]],[11,"type_id","","",123,[[],["typeid",3]]],[11,"to_owned","","",124,[[]]],[11,"clone_into","","",124,[[]]],[11,"from","","",124,[[]]],[11,"borrow","","",124,[[]]],[11,"borrow_mut","","",124,[[]]],[11,"try_from","","",124,[[],["result",4]]],[11,"into","","",124,[[]]],[11,"try_into","","",124,[[],["result",4]]],[11,"into_iter","","",124,[[]]],[11,"type_id","","",124,[[],["typeid",3]]],[11,"to_owned","","",125,[[]]],[11,"clone_into","","",125,[[]]],[11,"from","","",125,[[]]],[11,"borrow","","",125,[[]]],[11,"borrow_mut","","",125,[[]]],[11,"try_from","","",125,[[],["result",4]]],[11,"into","","",125,[[]]],[11,"try_into","","",125,[[],["result",4]]],[11,"into_iter","","",125,[[]]],[11,"type_id","","",125,[[],["typeid",3]]],[11,"to_owned","","",126,[[]]],[11,"clone_into","","",126,[[]]],[11,"from","","",126,[[]]],[11,"borrow","","",126,[[]]],[11,"borrow_mut","","",126,[[]]],[11,"try_from","","",126,[[],["result",4]]],[11,"into","","",126,[[]]],[11,"try_into","","",126,[[],["result",4]]],[11,"into_iter","","",126,[[]]],[11,"type_id","","",126,[[],["typeid",3]]],[11,"to_owned","","",127,[[]]],[11,"clone_into","","",127,[[]]],[11,"to_string","","",127,[[],["string",3]]],[11,"from","","",127,[[]]],[11,"borrow","","",127,[[]]],[11,"borrow_mut","","",127,[[]]],[11,"try_from","","",127,[[],["result",4]]],[11,"into","","",127,[[]]],[11,"try_into","","",127,[[],["result",4]]],[11,"type_id","","",127,[[],["typeid",3]]],[11,"to_owned","","",128,[[]]],[11,"clone_into","","",128,[[]]],[11,"to_string","","",128,[[],["string",3]]],[11,"from","","",128,[[]]],[11,"borrow","","",128,[[]]],[11,"borrow_mut","","",128,[[]]],[11,"try_from","","",128,[[],["result",4]]],[11,"into","","",128,[[]]],[11,"try_into","","",128,[[],["result",4]]],[11,"into_iter","","",128,[[]]],[11,"type_id","","",128,[[],["typeid",3]]],[11,"to_owned","","",129,[[]]],[11,"clone_into","","",129,[[]]],[11,"to_string","","",129,[[],["string",3]]],[11,"from","","",129,[[]]],[11,"borrow","","",129,[[]]],[11,"borrow_mut","","",129,[[]]],[11,"try_from","","",129,[[],["result",4]]],[11,"into","","",129,[[]]],[11,"try_into","","",129,[[],["result",4]]],[11,"into_iter","","",129,[[]]],[11,"type_id","","",129,[[],["typeid",3]]],[11,"to_owned","","",130,[[]]],[11,"clone_into","","",130,[[]]],[11,"to_string","","",130,[[],["string",3]]],[11,"from","","",130,[[]]],[11,"borrow","","",130,[[]]],[11,"borrow_mut","","",130,[[]]],[11,"try_from","","",130,[[],["result",4]]],[11,"into","","",130,[[]]],[11,"try_into","","",130,[[],["result",4]]],[11,"into_iter","","",130,[[]]],[11,"type_id","","",130,[[],["typeid",3]]],[11,"to_owned","","",131,[[]]],[11,"clone_into","","",131,[[]]],[11,"to_string","","",131,[[],["string",3]]],[11,"from","","",131,[[]]],[11,"borrow","","",131,[[]]],[11,"borrow_mut","","",131,[[]]],[11,"try_from","","",131,[[],["result",4]]],[11,"into","","",131,[[]]],[11,"try_into","","",131,[[],["result",4]]],[11,"type_id","","",131,[[],["typeid",3]]],[11,"to_owned","","",132,[[]]],[11,"clone_into","","",132,[[]]],[11,"from","","",132,[[]]],[11,"borrow","","",132,[[]]],[11,"borrow_mut","","",132,[[]]],[11,"try_from","","",132,[[],["result",4]]],[11,"into","","",132,[[]]],[11,"try_into","","",132,[[],["result",4]]],[11,"into_iter","","",132,[[]]],[11,"type_id","","",132,[[],["typeid",3]]],[11,"to_owned","","",133,[[]]],[11,"clone_into","","",133,[[]]],[11,"from","","",133,[[]]],[11,"borrow","","",133,[[]]],[11,"borrow_mut","","",133,[[]]],[11,"try_from","","",133,[[],["result",4]]],[11,"into","","",133,[[]]],[11,"try_into","","",133,[[],["result",4]]],[11,"into_iter","","",133,[[]]],[11,"type_id","","",133,[[],["typeid",3]]],[11,"to_owned","","",134,[[]]],[11,"clone_into","","",134,[[]]],[11,"from","","",134,[[]]],[11,"borrow","","",134,[[]]],[11,"borrow_mut","","",134,[[]]],[11,"try_from","","",134,[[],["result",4]]],[11,"into","","",134,[[]]],[11,"try_into","","",134,[[],["result",4]]],[11,"into_iter","","",134,[[]]],[11,"type_id","","",134,[[],["typeid",3]]],[11,"to_owned","","",135,[[]]],[11,"clone_into","","",135,[[]]],[11,"from","","",135,[[]]],[11,"borrow","","",135,[[]]],[11,"borrow_mut","","",135,[[]]],[11,"try_from","","",135,[[],["result",4]]],[11,"into","","",135,[[]]],[11,"try_into","","",135,[[],["result",4]]],[11,"into_iter","","",135,[[]]],[11,"type_id","","",135,[[],["typeid",3]]],[11,"to_owned","","",136,[[]]],[11,"clone_into","","",136,[[]]],[11,"from","","",136,[[]]],[11,"borrow","","",136,[[]]],[11,"borrow_mut","","",136,[[]]],[11,"try_from","","",136,[[],["result",4]]],[11,"into","","",136,[[]]],[11,"try_into","","",136,[[],["result",4]]],[11,"into_iter","","",136,[[]]],[11,"type_id","","",136,[[],["typeid",3]]],[11,"to_owned","","",137,[[]]],[11,"clone_into","","",137,[[]]],[11,"from","","",137,[[]]],[11,"borrow","","",137,[[]]],[11,"borrow_mut","","",137,[[]]],[11,"try_from","","",137,[[],["result",4]]],[11,"into","","",137,[[]]],[11,"try_into","","",137,[[],["result",4]]],[11,"into_iter","","",137,[[]]],[11,"type_id","","",137,[[],["typeid",3]]],[11,"to_owned","","",138,[[]]],[11,"clone_into","","",138,[[]]],[11,"from","","",138,[[]]],[11,"borrow","","",138,[[]]],[11,"borrow_mut","","",138,[[]]],[11,"try_from","","",138,[[],["result",4]]],[11,"into","","",138,[[]]],[11,"try_into","","",138,[[],["result",4]]],[11,"into_iter","","",138,[[]]],[11,"type_id","","",138,[[],["typeid",3]]],[11,"to_owned","","",139,[[]]],[11,"clone_into","","",139,[[]]],[11,"from","","",139,[[]]],[11,"borrow","","",139,[[]]],[11,"borrow_mut","","",139,[[]]],[11,"try_from","","",139,[[],["result",4]]],[11,"into","","",139,[[]]],[11,"try_into","","",139,[[],["result",4]]],[11,"into_iter","","",139,[[]]],[11,"type_id","","",139,[[],["typeid",3]]],[11,"to_owned","","",140,[[]]],[11,"clone_into","","",140,[[]]],[11,"from","","",140,[[]]],[11,"borrow","","",140,[[]]],[11,"borrow_mut","","",140,[[]]],[11,"try_from","","",140,[[],["result",4]]],[11,"into","","",140,[[]]],[11,"try_into","","",140,[[],["result",4]]],[11,"into_iter","","",140,[[]]],[11,"type_id","","",140,[[],["typeid",3]]],[11,"to_owned","","",141,[[]]],[11,"clone_into","","",141,[[]]],[11,"from","","",141,[[]]],[11,"borrow","","",141,[[]]],[11,"borrow_mut","","",141,[[]]],[11,"try_from","","",141,[[],["result",4]]],[11,"into","","",141,[[]]],[11,"try_into","","",141,[[],["result",4]]],[11,"into_iter","","",141,[[]]],[11,"type_id","","",141,[[],["typeid",3]]],[11,"to_owned","","",142,[[]]],[11,"clone_into","","",142,[[]]],[11,"from","","",142,[[]]],[11,"borrow","","",142,[[]]],[11,"borrow_mut","","",142,[[]]],[11,"try_from","","",142,[[],["result",4]]],[11,"into","","",142,[[]]],[11,"try_into","","",142,[[],["result",4]]],[11,"into_iter","","",142,[[]]],[11,"type_id","","",142,[[],["typeid",3]]],[11,"to_owned","","",143,[[]]],[11,"clone_into","","",143,[[]]],[11,"from","","",143,[[]]],[11,"borrow","","",143,[[]]],[11,"borrow_mut","","",143,[[]]],[11,"try_from","","",143,[[],["result",4]]],[11,"into","","",143,[[]]],[11,"try_into","","",143,[[],["result",4]]],[11,"into_iter","","",143,[[]]],[11,"type_id","","",143,[[],["typeid",3]]],[11,"to_owned","alloc::string","",37,[[]]],[11,"clone_into","","",37,[[]]],[11,"to_string","","",37,[[],["string",3]]],[11,"from","","",37,[[]]],[11,"borrow","","",37,[[]]],[11,"borrow_mut","","",37,[[]]],[11,"try_from","","",37,[[],["result",4]]],[11,"into","","",37,[[]]],[11,"try_into","","",37,[[],["result",4]]],[11,"type_id","","",37,[[],["typeid",3]]],[11,"to_owned","","",38,[[]]],[11,"clone_into","","",38,[[]]],[11,"to_string","","",38,[[],["string",3]]],[11,"from","","",38,[[]]],[11,"borrow","","",38,[[]]],[11,"borrow_mut","","",38,[[]]],[11,"try_from","","",38,[[],["result",4]]],[11,"into","","",38,[[]]],[11,"try_into","","",38,[[],["result",4]]],[11,"type_id","","",38,[[],["typeid",3]]],[11,"to_string","","",144,[[],["string",3]]],[11,"from","","",144,[[]]],[11,"borrow","","",144,[[]]],[11,"borrow_mut","","",144,[[]]],[11,"try_from","","",144,[[],["result",4]]],[11,"into","","",144,[[]]],[11,"try_into","","",144,[[],["result",4]]],[11,"type_id","","",144,[[],["typeid",3]]],[11,"from","","",40,[[]]],[11,"borrow","","",40,[[]]],[11,"borrow_mut","","",40,[[]]],[11,"try_from","","",40,[[],["result",4]]],[11,"into","","",40,[[]]],[11,"try_into","","",40,[[],["result",4]]],[11,"into_iter","","",40,[[]]],[11,"type_id","","",40,[[],["typeid",3]]],[11,"to_owned","alloc::sync","",41,[[]]],[11,"clone_into","","",41,[[]]],[11,"to_string","","",41,[[],["string",3]]],[11,"from","","",41,[[]]],[11,"from","","",41,[[]]],[11,"borrow","","",41,[[]]],[11,"borrow_mut","","",41,[[]]],[11,"try_from","","",41,[[],["result",4]]],[11,"into","","",41,[[]]],[11,"try_into","","",41,[[],["result",4]]],[11,"type_id","","",41,[[],["typeid",3]]],[11,"to_owned","","",42,[[]]],[11,"clone_into","","",42,[[]]],[11,"from","","",42,[[]]],[11,"borrow","","",42,[[]]],[11,"borrow_mut","","",42,[[]]],[11,"try_from","","",42,[[],["result",4]]],[11,"into","","",42,[[]]],[11,"try_into","","",42,[[],["result",4]]],[11,"type_id","","",42,[[],["typeid",3]]],[11,"from","alloc::vec","",145,[[]]],[11,"borrow","","",145,[[]]],[11,"borrow_mut","","",145,[[]]],[11,"try_from","","",145,[[],["result",4]]],[11,"into","","",145,[[]]],[11,"try_into","","",145,[[],["result",4]]],[11,"into_iter","","",145,[[]]],[11,"type_id","","",145,[[],["typeid",3]]],[11,"from","","",146,[[]]],[11,"borrow","","",146,[[]]],[11,"borrow_mut","","",146,[[]]],[11,"try_from","","",146,[[],["result",4]]],[11,"into","","",146,[[]]],[11,"try_into","","",146,[[],["result",4]]],[11,"into_iter","","",146,[[]]],[11,"type_id","","",146,[[],["typeid",3]]],[11,"from","","",147,[[]]],[11,"borrow","","",147,[[]]],[11,"borrow_mut","","",147,[[]]],[11,"try_from","","",147,[[],["result",4]]],[11,"into","","",147,[[]]],[11,"try_into","","",147,[[],["result",4]]],[11,"into_iter","","",147,[[]]],[11,"type_id","","",147,[[],["typeid",3]]],[11,"to_owned","","",148,[[]]],[11,"clone_into","","",148,[[]]],[11,"from","","",148,[[]]],[11,"borrow","","",148,[[]]],[11,"borrow_mut","","",148,[[]]],[11,"try_from","","",148,[[],["result",4]]],[11,"into","","",148,[[]]],[11,"try_into","","",148,[[],["result",4]]],[11,"into_iter","","",148,[[]]],[11,"type_id","","",148,[[],["typeid",3]]],[11,"to_owned","","",44,[[]]],[11,"clone_into","","",44,[[]]],[11,"from","","",44,[[]]],[11,"borrow","","",44,[[]]],[11,"borrow_mut","","",44,[[]]],[11,"try_from","","",44,[[],["result",4]]],[11,"into","","",44,[[]]],[11,"try_into","","",44,[[],["result",4]]],[11,"type_id","","",44,[[],["typeid",3]]],[11,"next","alloc::slice","",100,[[],["option",4]]],[11,"size_hint","","",100,[[]]],[11,"count","","",100,[[],["usize",15]]],[11,"nth","","",100,[[["usize",15]],["option",4]]],[11,"last","","",100,[[],["option",4]]],[11,"next","","",115,[[],["option",4]]],[11,"size_hint","","",115,[[]]],[11,"next","","",101,[[],["option",4]]],[11,"size_hint","","",101,[[]]],[11,"next","","",104,[[],["option",4]]],[11,"size_hint","","",104,[[]]],[11,"last","","",104,[[],["option",4]]],[11,"next","alloc::str","",129,[[],[["option",4],["char",15]]]],[11,"size_hint","","",129,[[]]],[11,"try_fold","","",129,[[]]],[11,"fold","","",129,[[]]],[11,"next","","",122,[[],[["option",4],["str",15]]]],[11,"size_hint","","",122,[[]]],[11,"last","","",122,[[],[["option",4],["str",15]]]],[11,"next","","",126,[[],[["option",4],["char",15]]]],[11,"count","","",126,[[],["usize",15]]],[11,"size_hint","","",126,[[]]],[11,"last","","",126,[[],[["option",4],["char",15]]]],[11,"next","","",137,[[],[["option",4],["str",15]]]],[11,"next","alloc::slice","",106,[[],["option",4]]],[11,"size_hint","","",106,[[]]],[11,"count","","",106,[[],["usize",15]]],[11,"nth","","",106,[[["usize",15]],["option",4]]],[11,"last","","",106,[[],["option",4]]],[11,"for_each","","",106,[[]]],[11,"all","","",106,[[],["bool",15]]],[11,"any","","",106,[[],["bool",15]]],[11,"find","","",106,[[],["option",4]]],[11,"find_map","","",106,[[],["option",4]]],[11,"position","","",106,[[],[["usize",15],["option",4]]]],[11,"rposition","","",106,[[],[["usize",15],["option",4]]]],[11,"next","alloc::str","",132,[[],[["option",4],["str",15]]]],[11,"size_hint","","",132,[[]]],[11,"last","","",132,[[],[["option",4],["str",15]]]],[11,"next","alloc::slice","",97,[[],["option",4]]],[11,"size_hint","","",97,[[]]],[11,"count","","",97,[[],["usize",15]]],[11,"nth","","",97,[[["usize",15]],["option",4]]],[11,"last","","",97,[[],["option",4]]],[11,"next","alloc::str","",138,[[],[["option",4],["str",15]]]],[11,"next","","",139,[[],[["option",4],["str",15]]]],[11,"next","alloc::slice","",109,[[],["option",4]]],[11,"size_hint","","",109,[[]]],[11,"count","","",109,[[],["usize",15]]],[11,"nth","","",109,[[["usize",15]],["option",4]]],[11,"last","","",109,[[],["option",4]]],[11,"next","alloc::str","",141,[[],[["option",4],["str",15]]]],[11,"next","","",128,[[],[["option",4],["char",15]]]],[11,"size_hint","","",128,[[]]],[11,"try_fold","","",128,[[]]],[11,"fold","","",128,[[]]],[11,"next","alloc::slice","",112,[[],["option",4]]],[11,"size_hint","","",112,[[]]],[11,"next","alloc::str","",140,[[],[["option",4],["str",15]]]],[11,"next","alloc::slice","",111,[[],["option",4]]],[11,"size_hint","","",111,[[]]],[11,"next","","",114,[[],["option",4]]],[11,"size_hint","","",114,[[]]],[11,"next","","",102,[[],["option",4]]],[11,"size_hint","","",102,[[]]],[11,"next","","",98,[[],["option",4]]],[11,"size_hint","","",98,[[]]],[11,"count","","",98,[[],["usize",15]]],[11,"nth","","",98,[[["usize",15]],["option",4]]],[11,"last","","",98,[[],["option",4]]],[11,"next","alloc::str","",133,[[],[["option",4],["str",15]]]],[11,"size_hint","","",133,[[]]],[11,"next","alloc::slice","",95,[[],["option",4]]],[11,"size_hint","","",95,[[]]],[11,"count","","",95,[[],["usize",15]]],[11,"nth","","",95,[[["usize",15]],["option",4]]],[11,"last","","",95,[[],["option",4]]],[11,"next","alloc::str","",130,[[],[["option",4],["char",15]]]],[11,"size_hint","","",130,[[]]],[11,"try_fold","","",130,[[]]],[11,"fold","","",130,[[]]],[11,"next","alloc::slice","",113,[[],["option",4]]],[11,"size_hint","","",113,[[]]],[11,"next","","",94,[[],["option",4]]],[11,"size_hint","","",94,[[]]],[11,"count","","",94,[[],["usize",15]]],[11,"nth","","",94,[[["usize",15]],["option",4]]],[11,"last","","",94,[[],["option",4]]],[11,"__iterator_get_unchecked","","",94,[[["usize",15]]]],[11,"next","","",110,[[],["option",4]]],[11,"size_hint","","",110,[[]]],[11,"count","","",110,[[],["usize",15]]],[11,"nth","","",110,[[["usize",15]],["option",4]]],[11,"last","","",110,[[],["option",4]]],[11,"next","alloc::str","",134,[[],["option",4]]],[11,"next","alloc::slice","",107,[[],["option",4]]],[11,"size_hint","","",107,[[]]],[11,"count","","",107,[[],["usize",15]]],[11,"nth","","",107,[[["usize",15]],["option",4]]],[11,"last","","",107,[[],["option",4]]],[11,"next","","",108,[[],["option",4]]],[11,"size_hint","","",108,[[]]],[11,"count","","",108,[[],["usize",15]]],[11,"nth","","",108,[[["usize",15]],["option",4]]],[11,"last","","",108,[[],["option",4]]],[11,"next","","",105,[[],["option",4]]],[11,"size_hint","","",105,[[]]],[11,"count","","",105,[[],["usize",15]]],[11,"nth","","",105,[[["usize",15]],["option",4]]],[11,"last","","",105,[[],["option",4]]],[11,"for_each","","",105,[[]]],[11,"all","","",105,[[],["bool",15]]],[11,"any","","",105,[[],["bool",15]]],[11,"find","","",105,[[],["option",4]]],[11,"find_map","","",105,[[],["option",4]]],[11,"position","","",105,[[],[["usize",15],["option",4]]]],[11,"rposition","","",105,[[],[["usize",15],["option",4]]]],[11,"is_sorted_by","","",105,[[],["bool",15]]],[11,"next","alloc::str","",135,[[],["option",4]]],[11,"next","","",136,[[],[["option",4],["str",15]]]],[11,"next","alloc::slice","",116,[[],["option",4]]],[11,"size_hint","","",116,[[]]],[11,"next","alloc::str","",123,[[],[["option",4],["str",15]]]],[11,"size_hint","","",123,[[]]],[11,"last","","",123,[[],[["option",4],["str",15]]]],[11,"next","alloc::slice","",93,[[],["option",4]]],[11,"size_hint","","",93,[[]]],[11,"count","","",93,[[],["usize",15]]],[11,"nth","","",93,[[["usize",15]],["option",4]]],[11,"last","","",93,[[],["option",4]]],[11,"__iterator_get_unchecked","","",93,[[["usize",15]]]],[11,"next","","",103,[[],["option",4]]],[11,"size_hint","","",103,[[]]],[11,"last","","",103,[[],["option",4]]],[11,"next","alloc::str","",125,[[],["option",4]]],[11,"count","","",125,[[],["usize",15]]],[11,"size_hint","","",125,[[]]],[11,"last","","",125,[[],["option",4]]],[11,"next","alloc::slice","",99,[[],["option",4]]],[11,"size_hint","","",99,[[]]],[11,"count","","",99,[[],["usize",15]]],[11,"nth","","",99,[[["usize",15]],["option",4]]],[11,"last","","",99,[[],["option",4]]],[11,"next","","",96,[[],["option",4]]],[11,"size_hint","","",96,[[]]],[11,"count","","",96,[[],["usize",15]]],[11,"nth","","",96,[[["usize",15]],["option",4]]],[11,"last","","",96,[[],["option",4]]],[11,"next","alloc::str","",121,[[],[["option",4],["u16",15]]]],[11,"size_hint","","",121,[[]]],[11,"next","","",142,[[],[["option",4],["str",15]]]],[11,"next","","",124,[[],[["option",4],["u8",15]]]],[11,"size_hint","","",124,[[]]],[11,"count","","",124,[[],["usize",15]]],[11,"last","","",124,[[],["option",4]]],[11,"nth","","",124,[[["usize",15]],["option",4]]],[11,"all","","",124,[[],["bool",15]]],[11,"any","","",124,[[],["bool",15]]],[11,"find","","",124,[[],["option",4]]],[11,"position","","",124,[[],[["usize",15],["option",4]]]],[11,"rposition","","",124,[[],[["usize",15],["option",4]]]],[11,"__iterator_get_unchecked","","",124,[[["usize",15]],["u8",15]]],[11,"next","","",143,[[],[["option",4],["str",15]]]],[11,"clone","alloc::fmt","",85,[[],["error",3]]],[11,"clone","alloc::str","",125,[[],["charindices",3]]],[11,"clone","","",141,[[],["splitn",3]]],[11,"clone","","",128,[[],["escapedebug",3]]],[11,"clone","","",136,[[],["matches",3]]],[11,"clone","","",132,[[],["lines",3]]],[11,"clone","","",122,[[],["splitasciiwhitespace",3]]],[11,"clone","","",126,[[],["chars",3]]],[11,"clone","","",121,[[],["encodeutf16",3]]],[11,"clone","alloc::slice","",101,[[],["split",3]]],[11,"clone","","",105,[[],["iter",3]]],[11,"clone","alloc::alloc","",46,[[],["layout",3]]],[11,"clone","alloc::slice","",108,[[],["rchunksexact",3]]],[11,"clone","","",97,[[],["windows",3]]],[11,"clone","alloc::str::pattern","",117,[[],["charsearcher",3]]],[11,"clone","alloc::str","",133,[[],["linesany",3]]],[11,"clone","alloc::slice","",96,[[],["chunks",3]]],[11,"clone","alloc::str","",129,[[],["escapedefault",3]]],[11,"clone","alloc::alloc","",47,[[],["layouterror",3]]],[11,"clone","alloc::slice","",107,[[],["rchunks",3]]],[11,"clone","alloc::str","",138,[[],["rsplit",3]]],[11,"clone","","",124,[[],["bytes",3]]],[11,"clone","alloc::slice","",111,[[],["rsplit",3]]],[11,"clone","alloc::str","",130,[[],["escapeunicode",3]]],[11,"clone","","",134,[[],["matchindices",3]]],[11,"clone","","",137,[[],["rmatches",3]]],[11,"clone","alloc::fmt","",86,[[],["arguments",3]]],[11,"clone","alloc::str::pattern","",119,[[],["charpredicatesearcher",3]]],[11,"clone","","",118,[[],["charslicesearcher",3]]],[11,"clone","alloc::slice","",98,[[],["chunksexact",3]]],[11,"clone","alloc::str::pattern","",120,[[],["strsearcher",3]]],[11,"clone","alloc::alloc","",45,[[],["allocerror",3]]],[11,"clone","alloc::slice","",93,[[],["arraychunks",3]]],[11,"clone","","",95,[[],["arraywindows",3]]],[11,"clone","alloc::str","",127,[[],["parseboolerror",3]]],[11,"clone","","",140,[[],["rsplitn",3]]],[11,"clone","","",131,[[],["utf8error",3]]],[11,"clone","alloc::str::pattern","",33,[[],["searchstep",4]]],[11,"clone","alloc::str","",143,[[],["splitterminator",3]]],[11,"clone","","",139,[[],["split",3]]],[11,"clone","","",142,[[],["rsplitterminator",3]]],[11,"clone","","",135,[[],["rmatchindices",3]]],[11,"clone","","",123,[[],["splitwhitespace",3]]],[11,"default","alloc::fmt","",85,[[],["error",3]]],[11,"next_back","alloc::str","",124,[[],[["option",4],["u8",15]]]],[11,"nth_back","","",124,[[["usize",15]],["option",4]]],[11,"rfind","","",124,[[],["option",4]]],[11,"next_back","alloc::slice","",109,[[],["option",4]]],[11,"nth_back","","",109,[[["usize",15]],["option",4]]],[11,"next_back","","",108,[[],["option",4]]],[11,"nth_back","","",108,[[["usize",15]],["option",4]]],[11,"next_back","alloc::str","",143,[[],[["option",4],["str",15]]]],[11,"next_back","","",132,[[],[["option",4],["str",15]]]],[11,"next_back","","",123,[[],[["option",4],["str",15]]]],[11,"next_back","alloc::slice","",107,[[],["option",4]]],[11,"nth_back","","",107,[[["usize",15]],["option",4]]],[11,"next_back","","",101,[[],["option",4]]],[11,"next_back","alloc::str","",139,[[],[["option",4],["str",15]]]],[11,"next_back","","",126,[[],[["option",4],["char",15]]]],[11,"next_back","alloc::slice","",110,[[],["option",4]]],[11,"nth_back","","",110,[[["usize",15]],["option",4]]],[11,"next_back","","",111,[[],["option",4]]],[11,"next_back","alloc::str","",138,[[],[["option",4],["str",15]]]],[11,"next_back","","",135,[[],["option",4]]],[11,"next_back","","",137,[[],[["option",4],["str",15]]]],[11,"next_back","","",134,[[],["option",4]]],[11,"next_back","alloc::slice","",99,[[],["option",4]]],[11,"nth_back","","",99,[[["usize",15]],["option",4]]],[11,"next_back","alloc::str","",122,[[],[["option",4],["str",15]]]],[11,"next_back","alloc::slice","",94,[[],["option",4]]],[11,"nth_back","","",94,[[["usize",15]],["option",4]]],[11,"next_back","","",95,[[],["option",4]]],[11,"nth_back","","",95,[[["usize",15]],["option",4]]],[11,"next_back","alloc::str","",142,[[],[["option",4],["str",15]]]],[11,"next_back","alloc::slice","",103,[[],["option",4]]],[11,"next_back","alloc::str","",136,[[],[["option",4],["str",15]]]],[11,"next_back","","",125,[[],["option",4]]],[11,"next_back","alloc::slice","",96,[[],["option",4]]],[11,"nth_back","","",96,[[["usize",15]],["option",4]]],[11,"next_back","","",93,[[],["option",4]]],[11,"nth_back","","",93,[[["usize",15]],["option",4]]],[11,"next_back","","",104,[[],["option",4]]],[11,"next_back","","",105,[[],["option",4]]],[11,"nth_back","","",105,[[["usize",15]],["option",4]]],[11,"next_back","alloc::str","",133,[[],[["option",4],["str",15]]]],[11,"next_back","alloc::slice","",100,[[],["option",4]]],[11,"nth_back","","",100,[[["usize",15]],["option",4]]],[11,"next_back","","",98,[[],["option",4]]],[11,"nth_back","","",98,[[["usize",15]],["option",4]]],[11,"next_back","","",106,[[],["option",4]]],[11,"nth_back","","",106,[[["usize",15]],["option",4]]],[11,"next_back","","",102,[[],["option",4]]],[11,"next_back","","",97,[[],["option",4]]],[11,"nth_back","","",97,[[["usize",15]],["option",4]]],[11,"next_back","","",112,[[],["option",4]]],[11,"fmt","alloc::fmt","",85,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",45,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",128,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",127,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",129,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",47,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",131,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",86,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",130,[[["formatter",3]],[["error",3],["result",4]]]],[11,"is_empty","alloc::slice","",108,[[],["bool",15]]],[11,"is_empty","","",98,[[],["bool",15]]],[11,"len","alloc::str","",124,[[],["usize",15]]],[11,"is_empty","","",124,[[],["bool",15]]],[11,"is_empty","alloc::slice","",99,[[],["bool",15]]],[11,"is_empty","","",109,[[],["bool",15]]],[11,"is_empty","","",95,[[],["bool",15]]],[11,"is_empty","","",94,[[],["bool",15]]],[11,"is_empty","","",93,[[],["bool",15]]],[11,"len","","",106,[[],["usize",15]]],[11,"is_empty","","",106,[[],["bool",15]]],[11,"len","","",105,[[],["usize",15]]],[11,"is_empty","","",105,[[],["bool",15]]],[11,"eq","alloc::str::pattern","",33,[[["searchstep",4]],["bool",15]]],[11,"ne","","",33,[[["searchstep",4]],["bool",15]]],[11,"eq","alloc::alloc","",47,[[["layouterror",3]],["bool",15]]],[11,"ne","","",47,[[["layouterror",3]],["bool",15]]],[11,"eq","alloc::str","",127,[[["parseboolerror",3]],["bool",15]]],[11,"ne","","",127,[[["parseboolerror",3]],["bool",15]]],[11,"eq","alloc::alloc","",45,[[["allocerror",3]],["bool",15]]],[11,"eq","alloc::str","",131,[[["utf8error",3]],["bool",15]]],[11,"ne","","",131,[[["utf8error",3]],["bool",15]]],[11,"eq","alloc::fmt","",85,[[["error",3]],["bool",15]]],[11,"eq","alloc::alloc","",46,[[["layout",3]],["bool",15]]],[11,"ne","","",46,[[["layout",3]],["bool",15]]],[11,"write_str","alloc::fmt","",92,[[["str",15]],[["error",3],["result",4]]]],[11,"write_char","","",92,[[["char",15]],[["error",3],["result",4]]]],[11,"write_fmt","","",92,[[["arguments",3]],[["error",3],["result",4]]]],[11,"partial_cmp","","",85,[[["error",3]],[["option",4],["ordering",4]]]],[11,"haystack","alloc::str::pattern","",117,[[],["str",15]]],[11,"next","","",117,[[],["searchstep",4]]],[11,"next_match","","",117,[[],["option",4]]],[11,"haystack","","",119,[[],["str",15]]],[11,"next","","",119,[[],["searchstep",4]]],[11,"next_match","","",119,[[],["option",4]]],[11,"next_reject","","",119,[[],["option",4]]],[11,"haystack","","",120,[[],["str",15]]],[11,"next","","",120,[[],["searchstep",4]]],[11,"next_match","","",120,[[],["option",4]]],[11,"haystack","","",118,[[],["str",15]]],[11,"next","","",118,[[],["searchstep",4]]],[11,"next_match","","",118,[[],["option",4]]],[11,"next_reject","","",118,[[],["option",4]]],[11,"cmp","alloc::fmt","",85,[[["error",3]],["ordering",4]]],[11,"hash","","",85,[[]]],[11,"as_ref","alloc::slice","",105,[[]]],[11,"fmt","alloc::str","",124,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",140,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",111,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",122,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",115,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",107,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",135,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",108,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",45,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",114,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",143,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",130,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",85,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",97,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",138,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",121,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",116,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",125,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",129,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",98,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",120,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",109,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",86,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",47,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",112,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",133,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",132,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",105,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",100,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",94,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",113,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",119,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",123,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",96,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",102,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",117,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",128,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",16,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",134,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",137,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",95,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",103,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",136,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",106,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",110,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",118,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",131,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",126,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",99,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",141,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",139,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",46,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",101,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",127,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",142,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",104,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",93,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",33,[[["formatter",3]],[["error",3],["result",4]]]],[11,"next_back","","",120,[[],["searchstep",4]]],[11,"next_match_back","","",120,[[],["option",4]]],[11,"next_back","","",117,[[],["searchstep",4]]],[11,"next_match_back","","",117,[[],["option",4]]],[11,"next_back","","",118,[[],["searchstep",4]]],[11,"next_match_back","","",118,[[],["option",4]]],[11,"next_reject_back","","",118,[[],["option",4]]],[11,"next_back","","",119,[[],["searchstep",4]]],[11,"next_match_back","","",119,[[],["option",4]]],[11,"next_reject_back","","",119,[[],["option",4]]],[11,"to_string","alloc::borrow","",6,[[],["string",3]]],[11,"to_string","alloc::string","",37,[[],["string",3]]],[11,"deref","alloc::boxed","",2,[[]]],[11,"deref","alloc::borrow","",6,[[]]],[11,"deref","alloc::collections::binary_heap","",7,[[]]],[11,"deref","alloc::rc","",27,[[]]],[11,"deref","alloc::string","",37,[[],["str",15]]],[11,"deref","alloc::sync","",41,[[]]],[11,"deref","alloc::vec","",44,[[]]],[11,"deref_mut","alloc::boxed","",2,[[]]],[11,"deref_mut","alloc::collections::binary_heap","",7,[[]]],[11,"deref_mut","alloc::string","",37,[[],["str",15]]],[11,"deref_mut","alloc::vec","",44,[[]]],[11,"from","alloc::boxed","Converts a generic type <code>T</code> into a <code>Box<T></code>",2,[[]]],[11,"from","","Converts a <code>&[T]</code> into a <code>Box<[T]></code>",2,[[],["box",3]]],[11,"from","","",2,[[["cow",4]],["box",3]]],[11,"from","","Converts a <code>&str</code> into a <code>Box<str></code>",2,[[["str",15]],[["box",3],["str",15]]]],[11,"from","","",2,[[["cow",4],["str",15]],[["box",3],["str",15]]]],[11,"from","","Converts a <code>Box<str></code> into a <code>Box<[u8]></code>",2,[[["box",3],["str",15]]]],[11,"from","","Converts a <code>[T; N]</code> into a <code>Box<[T]></code>",2,[[],["box",3]]],[11,"from","alloc::collections::binary_heap","Converts a <code>Vec<T></code> into a <code>BinaryHeap<T></code>.",8,[[["vec",3]],["binaryheap",3]]],[11,"from","alloc::vec","Converts a <code>BinaryHeap<T></code> into a <code>Vec<T></code>.",44,[[["binaryheap",3]],["vec",3]]],[11,"from","alloc::collections::vec_deque","Turn a <code>Vec<T></code> into a <code>VecDeque<T></code>.",12,[[["vec",3]]]],[11,"from","alloc::vec","Turn a <code>VecDeque<T></code> into a <code>Vec<T></code>.",44,[[["vecdeque",3]]]],[11,"from","alloc::collections","",14,[[["layouterror",3]]]],[11,"from","alloc::rc","",27,[[]]],[11,"from","","",27,[[],["rc",3]]],[11,"from","","",27,[[["str",15]],[["rc",3],["str",15]]]],[11,"from","","",27,[[["string",3]],[["rc",3],["str",15]]]],[11,"from","","",27,[[["box",3]],["rc",3]]],[11,"from","","",27,[[["vec",3]],["rc",3]]],[11,"from","","",27,[[["cow",4]],["rc",3]]],[11,"from","alloc::string","",37,[[["str",15]],["string",3]]],[11,"from","","Converts a <code>&mut str</code> into a <code>String</code>.",37,[[["str",15]],["string",3]]],[11,"from","","",37,[[["string",3]],["string",3]]],[11,"from","","Converts the given boxed <code>str</code> slice to a <code>String</code>. It is …",37,[[["box",3],["str",15]],["string",3]]],[11,"from","alloc::boxed","Converts the given <code>String</code> to a boxed <code>str</code> slice that is …",2,[[["string",3]],[["box",3],["str",15]]]],[11,"from","alloc::string","",37,[[["cow",4],["str",15]],["string",3]]],[11,"from","alloc::borrow","",6,[[["str",15]],[["cow",4],["str",15]]]],[11,"from","","",6,[[["string",3]],[["cow",4],["str",15]]]],[11,"from","","",6,[[["string",3]],[["cow",4],["str",15]]]],[11,"from","alloc::vec","Converts the given <code>String</code> to a vector <code>Vec</code> that holds …",44,[[["string",3]],[["vec",3],["u8",15]]]],[11,"from","alloc::string","",37,[[["char",15]]]],[11,"from","alloc::sync","",41,[[]]],[11,"from","","",41,[[],["arc",3]]],[11,"from","","",41,[[["str",15]],[["arc",3],["str",15]]]],[11,"from","","",41,[[["string",3]],[["arc",3],["str",15]]]],[11,"from","","",41,[[["box",3]],["arc",3]]],[11,"from","","",41,[[["vec",3]],["arc",3]]],[11,"from","","",41,[[["cow",4]],["arc",3]]],[11,"from","alloc::borrow","",6,[[],["cow",4]]],[11,"from","","",6,[[["vec",3]],["cow",4]]],[11,"from","","",6,[[["vec",3]],["cow",4]]],[11,"from","alloc::vec","",44,[[],["vec",3]]],[11,"from","","",44,[[],["vec",3]]],[11,"from","","",44,[[],["vec",3]]],[11,"from","","",44,[[["cow",4]],["vec",3]]],[11,"from","","",44,[[["box",3]]]],[11,"from","alloc::boxed","",2,[[["vec",3]]]],[11,"from","alloc::vec","",44,[[["str",15]],[["vec",3],["u8",15]]]],[11,"fmt","alloc::alloc","",48,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::boxed","",2,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::borrow","",6,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::binary_heap","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",49,[[["formatter",3]],["result",6]]],[11,"fmt","","",50,[[["formatter",3]],["result",6]]],[11,"fmt","","",51,[[["formatter",3]],["result",6]]],[11,"fmt","","",52,[[["formatter",3]],["result",6]]],[11,"fmt","","",53,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::btree_map","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",54,[[["formatter",3]],["result",6]]],[11,"fmt","","",55,[[["formatter",3]],["result",6]]],[11,"fmt","","",57,[[["formatter",3]],["result",6]]],[11,"fmt","","",58,[[["formatter",3]],["result",6]]],[11,"fmt","","",59,[[["formatter",3]],["result",6]]],[11,"fmt","","",60,[[["formatter",3]],["result",6]]],[11,"fmt","","",61,[[["formatter",3]],["result",6]]],[11,"fmt","","",62,[[["formatter",3]],["result",6]]],[11,"fmt","","",63,[[["formatter",3]],["result",6]]],[11,"fmt","","",64,[[["formatter",3]],["result",6]]],[11,"fmt","","",65,[[["formatter",3]],["result",6]]],[11,"fmt","","",66,[[["formatter",3]],["result",6]]],[11,"fmt","","",67,[[["formatter",3]],["result",6]]],[11,"fmt","","",56,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::btree_set","",69,[[["formatter",3]],["result",6]]],[11,"fmt","","",70,[[["formatter",3]],["result",6]]],[11,"fmt","","",71,[[["formatter",3]],["result",6]]],[11,"fmt","","",72,[[["formatter",3]],["result",6]]],[11,"fmt","","",73,[[["formatter",3]],["result",6]]],[11,"fmt","","",74,[[["formatter",3]],["result",6]]],[11,"fmt","","",75,[[["formatter",3]],["result",6]]],[11,"fmt","","",76,[[["formatter",3]],["result",6]]],[11,"fmt","","",68,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::linked_list","",77,[[["formatter",3]],["result",6]]],[11,"fmt","","",78,[[["formatter",3]],["result",6]]],[11,"fmt","","",79,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",80,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::vec_deque","",81,[[["formatter",3]],["result",6]]],[11,"fmt","","",82,[[["formatter",3]],["result",6]]],[11,"fmt","","",83,[[["formatter",3]],["result",6]]],[11,"fmt","","",84,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections","",14,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::rc","",27,[[["formatter",3]],["result",6]]],[11,"fmt","","",28,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::string","",38,[[["formatter",3]],["result",6]]],[11,"fmt","","",144,[[["formatter",3]],["result",6]]],[11,"fmt","","",37,[[["formatter",3]],["result",6]]],[11,"fmt","","",40,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::sync","",42,[[["formatter",3]],["result",6]]],[11,"fmt","","",41,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::vec","",145,[[["formatter",3]],["result",6]]],[11,"fmt","","",146,[[["formatter",3]],["result",6]]],[11,"fmt","","",147,[[["formatter",3]],["result",6]]],[11,"fmt","","",148,[[["formatter",3]],["result",6]]],[11,"fmt","","",44,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::boxed","",2,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::borrow","",6,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections","",14,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","alloc::rc","",27,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::string","",38,[[["formatter",3]],["result",6]]],[11,"fmt","","",144,[[["formatter",3]],["result",6]]],[11,"fmt","","",37,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::sync","",41,[[["formatter",3]],["result",6]]],[11,"eq","alloc::boxed","",2,[[],["bool",15]]],[11,"ne","","",2,[[],["bool",15]]],[11,"eq","alloc::borrow","",6,[[["cow",4]],["bool",15]]],[11,"eq","alloc::collections::btree_map","",56,[[["btreemap",3]],["bool",15]]],[11,"eq","alloc::collections::btree_set","",68,[[["btreeset",3]],["bool",15]]],[11,"ne","","",68,[[["btreeset",3]],["bool",15]]],[11,"eq","alloc::collections::linked_list","",9,[[],["bool",15]]],[11,"ne","","",9,[[],["bool",15]]],[11,"eq","alloc::collections::vec_deque","",12,[[["vecdeque",3]],["bool",15]]],[11,"eq","","",12,[[["vec",3]],["bool",15]]],[11,"eq","","",12,[[],["bool",15]]],[11,"eq","","",12,[[],["bool",15]]],[11,"eq","","",12,[[],["bool",15]]],[11,"eq","","",12,[[],["bool",15]]],[11,"eq","","",12,[[],["bool",15]]],[11,"eq","alloc::collections","",14,[[["tryreserveerror",4]],["bool",15]]],[11,"ne","","",14,[[["tryreserveerror",4]],["bool",15]]],[11,"eq","alloc::rc","Equality for two <code>Rc</code>s.",27,[[["rc",3]],["bool",15]]],[11,"ne","","Inequality for two <code>Rc</code>s.",27,[[["rc",3]],["bool",15]]],[11,"eq","alloc::string","",38,[[["fromutf8error",3]],["bool",15]]],[11,"ne","","",38,[[["fromutf8error",3]],["bool",15]]],[11,"eq","","",37,[[["string",3]],["bool",15]]],[11,"ne","","",37,[[["string",3]],["bool",15]]],[11,"eq","","",37,[[["str",15]],["bool",15]]],[11,"ne","","",37,[[["str",15]],["bool",15]]],[11,"eq","","",37,[[["str",15]],["bool",15]]],[11,"ne","","",37,[[["str",15]],["bool",15]]],[11,"eq","alloc::borrow","",6,[[["str",15]],["bool",15]]],[11,"ne","","",6,[[["str",15]],["bool",15]]],[11,"eq","","",6,[[["str",15]],["bool",15]]],[11,"ne","","",6,[[["str",15]],["bool",15]]],[11,"eq","","",6,[[["string",3]],["bool",15]]],[11,"ne","","",6,[[["string",3]],["bool",15]]],[11,"eq","alloc::string","",37,[[["cow",4]],["bool",15]]],[11,"ne","","",37,[[["cow",4]],["bool",15]]],[11,"eq","alloc::sync","Equality for two <code>Arc</code>s.",41,[[["arc",3]],["bool",15]]],[11,"ne","","Inequality for two <code>Arc</code>s.",41,[[["arc",3]],["bool",15]]],[11,"eq","alloc::vec","",44,[[["vec",3]],["bool",15]]],[11,"ne","","",44,[[["vec",3]],["bool",15]]],[11,"eq","","",44,[[],["bool",15]]],[11,"ne","","",44,[[],["bool",15]]],[11,"eq","","",44,[[],["bool",15]]],[11,"ne","","",44,[[],["bool",15]]],[11,"eq","","",44,[[],["bool",15]]],[11,"ne","","",44,[[],["bool",15]]],[11,"eq","alloc::borrow","",6,[[["vec",3]],["bool",15]]],[11,"ne","","",6,[[["vec",3]],["bool",15]]],[11,"eq","","",6,[[],["bool",15]]],[11,"ne","","",6,[[],["bool",15]]],[11,"eq","","",6,[[],["bool",15]]],[11,"ne","","",6,[[],["bool",15]]],[11,"eq","alloc::vec","",44,[[],["bool",15]]],[11,"ne","","",44,[[],["bool",15]]],[11,"eq","","",44,[[],["bool",15]]],[11,"ne","","",44,[[],["bool",15]]],[11,"cmp","alloc::boxed","",2,[[],["ordering",4]]],[11,"cmp","alloc::borrow","",6,[[],["ordering",4]]],[11,"cmp","alloc::collections::btree_map","",56,[[["btreemap",3]],["ordering",4]]],[11,"cmp","alloc::collections::btree_set","",68,[[["btreeset",3]],["ordering",4]]],[11,"cmp","alloc::collections::linked_list","",9,[[],["ordering",4]]],[11,"cmp","alloc::collections::vec_deque","",12,[[["vecdeque",3]],["ordering",4]]],[11,"cmp","alloc::rc","Comparison for two <code>Rc</code>s.",27,[[["rc",3]],["ordering",4]]],[11,"cmp","alloc::string","",37,[[["string",3]],["ordering",4]]],[11,"cmp","alloc::sync","Comparison for two <code>Arc</code>s.",41,[[["arc",3]],["ordering",4]]],[11,"cmp","alloc::vec","",44,[[],["ordering",4]]],[11,"partial_cmp","alloc::boxed","",2,[[],[["ordering",4],["option",4]]]],[11,"lt","","",2,[[],["bool",15]]],[11,"le","","",2,[[],["bool",15]]],[11,"ge","","",2,[[],["bool",15]]],[11,"gt","","",2,[[],["bool",15]]],[11,"partial_cmp","alloc::borrow","",6,[[["cow",4]],[["ordering",4],["option",4]]]],[11,"partial_cmp","alloc::collections::btree_map","",56,[[["btreemap",3]],[["ordering",4],["option",4]]]],[11,"partial_cmp","alloc::collections::btree_set","",68,[[["btreeset",3]],[["option",4],["ordering",4]]]],[11,"lt","","",68,[[["btreeset",3]],["bool",15]]],[11,"le","","",68,[[["btreeset",3]],["bool",15]]],[11,"gt","","",68,[[["btreeset",3]],["bool",15]]],[11,"ge","","",68,[[["btreeset",3]],["bool",15]]],[11,"partial_cmp","alloc::collections::linked_list","",9,[[],[["ordering",4],["option",4]]]],[11,"partial_cmp","alloc::collections::vec_deque","",12,[[["vecdeque",3]],[["ordering",4],["option",4]]]],[11,"partial_cmp","alloc::rc","Partial comparison for two <code>Rc</code>s.",27,[[["rc",3]],[["ordering",4],["option",4]]]],[11,"lt","","Less-than comparison for two <code>Rc</code>s.",27,[[["rc",3]],["bool",15]]],[11,"le","","\'Less than or equal to\' comparison for two <code>Rc</code>s.",27,[[["rc",3]],["bool",15]]],[11,"gt","","Greater-than comparison for two <code>Rc</code>s.",27,[[["rc",3]],["bool",15]]],[11,"ge","","\'Greater than or equal to\' comparison for two <code>Rc</code>s.",27,[[["rc",3]],["bool",15]]],[11,"partial_cmp","alloc::string","",37,[[["string",3]],[["option",4],["ordering",4]]]],[11,"lt","","",37,[[["string",3]],["bool",15]]],[11,"le","","",37,[[["string",3]],["bool",15]]],[11,"gt","","",37,[[["string",3]],["bool",15]]],[11,"ge","","",37,[[["string",3]],["bool",15]]],[11,"partial_cmp","alloc::sync","Partial comparison for two <code>Arc</code>s.",41,[[["arc",3]],[["ordering",4],["option",4]]]],[11,"lt","","Less-than comparison for two <code>Arc</code>s.",41,[[["arc",3]],["bool",15]]],[11,"le","","\'Less than or equal to\' comparison for two <code>Arc</code>s.",41,[[["arc",3]],["bool",15]]],[11,"gt","","Greater-than comparison for two <code>Arc</code>s.",41,[[["arc",3]],["bool",15]]],[11,"ge","","\'Greater than or equal to\' comparison for two <code>Arc</code>s.",41,[[["arc",3]],["bool",15]]],[11,"partial_cmp","alloc::vec","",44,[[],[["ordering",4],["option",4]]]],[11,"add","alloc::borrow","",6,[[["str",15]]]],[11,"add","","",6,[[["cow",4],["str",15]]]],[11,"add","alloc::string","",37,[[["str",15]],["string",3]]],[11,"add_assign","alloc::borrow","",6,[[["str",15]]]],[11,"add_assign","","",6,[[["cow",4],["str",15]]]],[11,"add_assign","alloc::string","",37,[[["str",15]]]],[11,"drop","alloc::boxed","",2,[[]]],[11,"drop","alloc::collections::binary_heap","",7,[[]]],[11,"drop","","Removes heap elements in heap order.",53,[[]]],[11,"drop","alloc::collections::btree_map","",56,[[]]],[11,"drop","","",59,[[]]],[11,"drop","","",67,[[]]],[11,"drop","alloc::collections::btree_set","",76,[[]]],[11,"drop","alloc::collections::linked_list","",9,[[]]],[11,"drop","","",80,[[]]],[11,"drop","alloc::collections::vec_deque","",81,[[]]],[11,"drop","","",12,[[]]],[11,"drop","alloc::rc","Drops the <code>Rc</code>.",27,[[]]],[11,"drop","","Drops the <code>Weak</code> pointer.",28,[[]]],[11,"drop","alloc::string","",40,[[]]],[11,"drop","alloc::sync","Drops the <code>Arc</code>.",41,[[]]],[11,"drop","","Drops the <code>Weak</code> pointer.",42,[[]]],[11,"drop","alloc::vec","",145,[[]]],[11,"drop","","",146,[[]]],[11,"drop","","",147,[[]]],[11,"drop","","",148,[[]]],[11,"drop","","",44,[[]]],[11,"call","alloc::boxed","",2,[[]]],[11,"call_mut","","",2,[[]]],[11,"call_once","","",2,[[]]],[11,"resume","","",2,[[["pin",3]],["generatorstate",4]]],[11,"index","alloc::collections::btree_map","Returns a reference to the value corresponding to the …",56,[[]]],[11,"index","alloc::collections::vec_deque","",12,[[["usize",15]]]],[11,"index","alloc::string","",37,[[["usize",15],["range",3]],["str",15]]],[11,"index","","",37,[[["usize",15],["rangeto",3]],["str",15]]],[11,"index","","",37,[[["usize",15],["rangefrom",3]],["str",15]]],[11,"index","","",37,[[["rangefull",3]],["str",15]]],[11,"index","","",37,[[["usize",15],["rangeinclusive",3]],["str",15]]],[11,"index","","",37,[[["usize",15],["rangetoinclusive",3]],["str",15]]],[11,"index","alloc::vec","",44,[[]]],[11,"index_mut","alloc::collections::vec_deque","",12,[[["usize",15]]]],[11,"index_mut","alloc::string","",37,[[["usize",15],["range",3]],["str",15]]],[11,"index_mut","","",37,[[["usize",15],["rangeto",3]],["str",15]]],[11,"index_mut","","",37,[[["usize",15],["rangefrom",3]],["str",15]]],[11,"index_mut","","",37,[[["rangefull",3]],["str",15]]],[11,"index_mut","","",37,[[["usize",15],["rangeinclusive",3]],["str",15]]],[11,"index_mut","","",37,[[["usize",15],["rangetoinclusive",3]],["str",15]]],[11,"index_mut","alloc::vec","",44,[[]]],[11,"hash","alloc::boxed","",2,[[]]],[11,"hash","alloc::borrow","",6,[[]]],[11,"hash","alloc::collections::btree_map","",56,[[]]],[11,"hash","alloc::collections::btree_set","",68,[[]]],[11,"hash","alloc::collections::linked_list","",9,[[]]],[11,"hash","alloc::collections::vec_deque","",12,[[]]],[11,"hash","alloc::rc","",27,[[]]],[11,"hash","alloc::string","",37,[[]]],[11,"hash","alloc::sync","",41,[[]]],[11,"hash","alloc::vec","",44,[[]]],[11,"len","alloc::boxed","",2,[[],["usize",15]]],[11,"is_empty","","",2,[[],["bool",15]]],[11,"is_empty","alloc::collections::binary_heap","",49,[[],["bool",15]]],[11,"is_empty","","",50,[[],["bool",15]]],[11,"is_empty","","",52,[[],["bool",15]]],[11,"len","alloc::collections::btree_map","",57,[[],["usize",15]]],[11,"len","","",58,[[],["usize",15]]],[11,"len","","",59,[[],["usize",15]]],[11,"len","","",60,[[],["usize",15]]],[11,"len","","",61,[[],["usize",15]]],[11,"len","","",62,[[],["usize",15]]],[11,"len","","",63,[[],["usize",15]]],[11,"len","","",64,[[],["usize",15]]],[11,"len","alloc::collections::btree_set","",69,[[],["usize",15]]],[11,"len","","",70,[[],["usize",15]]],[11,"is_empty","alloc::collections::vec_deque","",82,[[],["bool",15]]],[11,"is_empty","","",83,[[],["bool",15]]],[11,"is_empty","","",84,[[],["bool",15]]],[11,"is_empty","alloc::vec","",147,[[],["bool",15]]],[11,"is_empty","","",148,[[],["bool",15]]],[11,"borrow","alloc::boxed","",2,[[]]],[11,"borrow","alloc::borrow","",6,[[]]],[11,"borrow","alloc::rc","",27,[[]]],[11,"borrow","alloc::vec","",44,[[]]],[11,"borrow","alloc::string","",37,[[],["str",15]]],[11,"borrow","alloc::sync","",41,[[]]],[11,"borrow_mut","alloc::boxed","",2,[[]]],[11,"borrow_mut","alloc::vec","",44,[[]]],[11,"borrow_mut","alloc::string","",37,[[],["str",15]]],[11,"try_from","alloc::boxed","",2,[[["box",3]],["result",4]]],[11,"try_from","alloc::rc","",27,[[["rc",3]],["result",4]]],[11,"try_from","alloc::sync","",41,[[["arc",3]],["result",4]]],[11,"finish","alloc::boxed","",2,[[],["u64",15]]],[11,"write","","",2,[[]]],[11,"write_u8","","",2,[[["u8",15]]]],[11,"write_u16","","",2,[[["u16",15]]]],[11,"write_u32","","",2,[[["u32",15]]]],[11,"write_u64","","",2,[[["u64",15]]]],[11,"write_u128","","",2,[[["u128",15]]]],[11,"write_usize","","",2,[[["usize",15]]]],[11,"write_i8","","",2,[[["i8",15]]]],[11,"write_i16","","",2,[[["i16",15]]]],[11,"write_i32","","",2,[[["i32",15]]]],[11,"write_i64","","",2,[[["i64",15]]]],[11,"write_i128","","",2,[[["i128",15]]]],[11,"write_isize","","",2,[[["isize",15]]]],[11,"from_str","alloc::string","",37,[[["str",15]],[["result",4],["string",3]]]],[11,"write_str","","",37,[[["str",15]],["result",6]]],[11,"write_char","","",37,[[["char",15]],["result",6]]],[11,"from_iter","alloc::boxed","",2,[[["intoiterator",8]]]],[11,"from_iter","alloc::collections::binary_heap","",8,[[["intoiterator",8]],["binaryheap",3]]],[11,"from_iter","alloc::collections::btree_map","",56,[[["intoiterator",8]],["btreemap",3]]],[11,"from_iter","alloc::collections::btree_set","",68,[[["intoiterator",8]],["btreeset",3]]],[11,"from_iter","alloc::collections::linked_list","",9,[[["intoiterator",8]]]],[11,"from_iter","alloc::collections::vec_deque","",12,[[["intoiterator",8]],["vecdeque",3]]],[11,"from_iter","alloc::rc","Takes each element in the <code>Iterator</code> and collects it into …",27,[[["intoiterator",8]]]],[11,"from_iter","alloc::string","",37,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",37,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",37,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",37,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",37,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",37,[[["intoiterator",8]],["string",3]]],[11,"from_iter","alloc::borrow","",6,[[["intoiterator",8]],[["cow",4],["str",15]]]],[11,"from_iter","","",6,[[["intoiterator",8]],[["cow",4],["str",15]]]],[11,"from_iter","","",6,[[["intoiterator",8]],[["cow",4],["str",15]]]],[11,"from_iter","alloc::sync","Takes each element in the <code>Iterator</code> and collects it into …",41,[[["intoiterator",8]]]],[11,"from_iter","alloc::borrow","",6,[[["intoiterator",8]],["cow",4]]],[11,"from_iter","alloc::vec","",44,[[["intoiterator",8]],["vec",3]]],[11,"as_ref","alloc::boxed","",2,[[]]],[11,"as_ref","alloc::borrow","",6,[[]]],[11,"as_ref","alloc::rc","",27,[[]]],[11,"as_ref","alloc::string","",37,[[],["str",15]]],[11,"as_ref","","",37,[[]]],[11,"as_ref","alloc::sync","",41,[[]]],[11,"as_ref","alloc::vec","",147,[[]]],[11,"as_ref","","",148,[[]]],[11,"as_ref","","",44,[[],["vec",3]]],[11,"as_ref","","",44,[[]]],[11,"as_mut","alloc::boxed","",2,[[]]],[11,"as_mut","alloc::string","",37,[[],["str",15]]],[11,"as_mut","alloc::vec","",44,[[],["vec",3]]],[11,"as_mut","","",44,[[]]],[11,"fmt","alloc::boxed","",2,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::rc","",27,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::sync","",41,[[["formatter",3]],["result",6]]],[11,"next_back","alloc::boxed","",2,[[],["option",4]]],[11,"nth_back","","",2,[[["usize",15]],["option",4]]],[11,"next_back","alloc::collections::binary_heap","",49,[[],["option",4]]],[11,"next_back","","",50,[[],["option",4]]],[11,"next_back","","",52,[[],["option",4]]],[11,"next_back","alloc::collections::btree_map","",57,[[],["option",4]]],[11,"next_back","","",58,[[],["option",4]]],[11,"next_back","","",59,[[],["option",4]]],[11,"next_back","","",60,[[],["option",4]]],[11,"next_back","","",61,[[],["option",4]]],[11,"next_back","","",62,[[],["option",4]]],[11,"next_back","","",63,[[],["option",4]]],[11,"next_back","","",64,[[],["option",4]]],[11,"next_back","","",65,[[],["option",4]]],[11,"next_back","","",66,[[],["option",4]]],[11,"next_back","alloc::collections::btree_set","",69,[[],["option",4]]],[11,"next_back","","",70,[[],["option",4]]],[11,"next_back","","",71,[[],["option",4]]],[11,"next_back","alloc::collections::linked_list","",77,[[],["option",4]]],[11,"next_back","","",78,[[],["option",4]]],[11,"next_back","","",79,[[],["option",4]]],[11,"next_back","alloc::collections::vec_deque","",81,[[],["option",4]]],[11,"next_back","","",82,[[],["option",4]]],[11,"rfold","","",82,[[]]],[11,"next_back","","",83,[[],["option",4]]],[11,"next_back","","",84,[[],["option",4]]],[11,"rfold","","",84,[[]]],[11,"try_rfold","","",84,[[]]],[11,"next_back","alloc::string","",40,[[],[["option",4],["char",15]]]],[11,"next_back","alloc::vec","",146,[[],["option",4]]],[11,"next_back","","",147,[[],["option",4]]],[11,"next_back","","",148,[[],["option",4]]],[11,"next","alloc::boxed","",2,[[],["option",4]]],[11,"size_hint","","",2,[[]]],[11,"nth","","",2,[[["usize",15]],["option",4]]],[11,"last","","",2,[[],["option",4]]],[11,"next","alloc::collections::binary_heap","",49,[[],["option",4]]],[11,"size_hint","","",49,[[]]],[11,"last","","",49,[[],["option",4]]],[11,"next","","",50,[[],["option",4]]],[11,"size_hint","","",50,[[]]],[11,"next","","",51,[[],["option",4]]],[11,"size_hint","","",51,[[]]],[11,"next","","",52,[[],["option",4]]],[11,"size_hint","","",52,[[]]],[11,"next","","",53,[[],["option",4]]],[11,"size_hint","","",53,[[]]],[11,"next","alloc::collections::btree_map","",57,[[],["option",4]]],[11,"size_hint","","",57,[[]]],[11,"last","","",57,[[],["option",4]]],[11,"min","","",57,[[],["option",4]]],[11,"max","","",57,[[],["option",4]]],[11,"next","","",58,[[],["option",4]]],[11,"size_hint","","",58,[[]]],[11,"last","","",58,[[],["option",4]]],[11,"min","","",58,[[],["option",4]]],[11,"max","","",58,[[],["option",4]]],[11,"next","","",59,[[],["option",4]]],[11,"size_hint","","",59,[[]]],[11,"next","","",60,[[],["option",4]]],[11,"size_hint","","",60,[[]]],[11,"last","","",60,[[],["option",4]]],[11,"min","","",60,[[],["option",4]]],[11,"max","","",60,[[],["option",4]]],[11,"next","","",61,[[],["option",4]]],[11,"size_hint","","",61,[[]]],[11,"last","","",61,[[],["option",4]]],[11,"next","","",67,[[],["option",4]]],[11,"size_hint","","",67,[[]]],[11,"next","","",65,[[],["option",4]]],[11,"last","","",65,[[],["option",4]]],[11,"min","","",65,[[],["option",4]]],[11,"max","","",65,[[],["option",4]]],[11,"next","","",62,[[],["option",4]]],[11,"size_hint","","",62,[[]]],[11,"last","","",62,[[],["option",4]]],[11,"next","","",63,[[],["option",4]]],[11,"size_hint","","",63,[[]]],[11,"last","","",63,[[],["option",4]]],[11,"min","","",63,[[],["option",4]]],[11,"max","","",63,[[],["option",4]]],[11,"next","","",64,[[],["option",4]]],[11,"size_hint","","",64,[[]]],[11,"last","","",64,[[],["option",4]]],[11,"next","","",66,[[],["option",4]]],[11,"last","","",66,[[],["option",4]]],[11,"min","","",66,[[],["option",4]]],[11,"max","","",66,[[],["option",4]]],[11,"next","alloc::collections::btree_set","",76,[[],["option",4]]],[11,"size_hint","","",76,[[]]],[11,"next","","",69,[[],["option",4]]],[11,"size_hint","","",69,[[]]],[11,"last","","",69,[[],["option",4]]],[11,"min","","",69,[[],["option",4]]],[11,"max","","",69,[[],["option",4]]],[11,"next","","",70,[[],["option",4]]],[11,"size_hint","","",70,[[]]],[11,"next","","",71,[[],["option",4]]],[11,"last","","",71,[[],["option",4]]],[11,"min","","",71,[[],["option",4]]],[11,"max","","",71,[[],["option",4]]],[11,"next","","",72,[[],["option",4]]],[11,"size_hint","","",72,[[]]],[11,"min","","",72,[[],["option",4]]],[11,"next","","",73,[[],["option",4]]],[11,"size_hint","","",73,[[]]],[11,"min","","",73,[[],["option",4]]],[11,"next","","",74,[[],["option",4]]],[11,"size_hint","","",74,[[]]],[11,"min","","",74,[[],["option",4]]],[11,"next","","",75,[[],["option",4]]],[11,"size_hint","","",75,[[]]],[11,"min","","",75,[[],["option",4]]],[11,"next","alloc::collections::linked_list","",77,[[],["option",4]]],[11,"size_hint","","",77,[[]]],[11,"last","","",77,[[],["option",4]]],[11,"next","","",78,[[],["option",4]]],[11,"size_hint","","",78,[[]]],[11,"last","","",78,[[],["option",4]]],[11,"next","","",80,[[],["option",4]]],[11,"size_hint","","",80,[[]]],[11,"next","","",79,[[],["option",4]]],[11,"size_hint","","",79,[[]]],[11,"next","alloc::collections::vec_deque","",81,[[],["option",4]]],[11,"size_hint","","",81,[[]]],[11,"next","","",82,[[],["option",4]]],[11,"size_hint","","",82,[[]]],[11,"fold","","",82,[[]]],[11,"nth","","",82,[[["usize",15]],["option",4]]],[11,"last","","",82,[[],["option",4]]],[11,"next","","",83,[[],["option",4]]],[11,"size_hint","","",83,[[]]],[11,"next","","",84,[[],["option",4]]],[11,"size_hint","","",84,[[]]],[11,"fold","","",84,[[]]],[11,"try_fold","","",84,[[]]],[11,"nth","","",84,[[["usize",15]],["option",4]]],[11,"last","","",84,[[],["option",4]]],[11,"next","alloc::string","",40,[[],[["option",4],["char",15]]]],[11,"size_hint","","",40,[[]]],[11,"last","","",40,[[],[["option",4],["char",15]]]],[11,"next","alloc::vec","",145,[[],["option",4]]],[11,"size_hint","","",145,[[]]],[11,"next","","",146,[[],["option",4]]],[11,"size_hint","","",146,[[]]],[11,"next","","",147,[[],["option",4]]],[11,"size_hint","","",147,[[]]],[11,"next","","",148,[[],["option",4]]],[11,"size_hint","","",148,[[]]],[11,"count","","",148,[[],["usize",15]]],[11,"__iterator_get_unchecked","","",148,[[["usize",15]]]],[11,"as_inner","alloc::collections::binary_heap","",50,[[]]],[11,"as_inner","alloc::vec","",148,[[]]],[11,"into_iter","alloc::collections::binary_heap","Creates a consuming iterator, that is, one that moves …",8,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::btree_map","",56,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::btree_set","Gets an iterator for moving out the <code>BTreeSet</code>\'s contents.",68,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::linked_list","Consumes the list into an iterator yielding elements by …",9,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::vec_deque","Consumes the <code>VecDeque</code> into a front-to-back iterator …",12,[[],["intoiter",3]]],[11,"into_iter","alloc::vec","Creates a consuming iterator, that is, one that moves …",44,[[],["intoiter",3]]],[11,"extend","alloc::collections::binary_heap","",8,[[["intoiterator",8]]]],[11,"extend_one","","",8,[[]]],[11,"extend_reserve","","",8,[[["usize",15]]]],[11,"extend","","",8,[[["intoiterator",8]]]],[11,"extend_one","","",8,[[]]],[11,"extend_reserve","","",8,[[["usize",15]]]],[11,"extend","alloc::collections::btree_map","",56,[[["intoiterator",8]]]],[11,"extend_one","","",56,[[]]],[11,"extend","","",56,[[["intoiterator",8]]]],[11,"extend_one","","",56,[[]]],[11,"extend","alloc::collections::btree_set","",68,[[["intoiterator",8]]]],[11,"extend_one","","",68,[[]]],[11,"extend","","",68,[[["intoiterator",8]]]],[11,"extend_one","","",68,[[]]],[11,"extend","alloc::collections::linked_list","",9,[[["intoiterator",8]]]],[11,"extend_one","","",9,[[]]],[11,"extend","","",9,[[["intoiterator",8]]]],[11,"extend_one","","",9,[[]]],[11,"extend","alloc::collections::vec_deque","",12,[[["intoiterator",8]]]],[11,"extend_one","","",12,[[]]],[11,"extend_reserve","","",12,[[["usize",15]]]],[11,"extend","","",12,[[["intoiterator",8]]]],[11,"extend_one","","",12,[[]]],[11,"extend_reserve","","",12,[[["usize",15]]]],[11,"extend","alloc::string","",37,[[["intoiterator",8]]]],[11,"extend_one","","",37,[[["char",15]]]],[11,"extend_reserve","","",37,[[["usize",15]]]],[11,"extend","","",37,[[["intoiterator",8]]]],[11,"extend_one","","",37,[[["char",15]]]],[11,"extend_reserve","","",37,[[["usize",15]]]],[11,"extend","","",37,[[["intoiterator",8]]]],[11,"extend_one","","",37,[[["str",15]]]],[11,"extend","","",37,[[["intoiterator",8]]]],[11,"extend","","",37,[[["intoiterator",8]]]],[11,"extend_one","","",37,[[["string",3]]]],[11,"extend","","",37,[[["intoiterator",8]]]],[11,"extend_one","","",37,[[["cow",4],["str",15]]]],[11,"extend","alloc::vec","",44,[[["intoiterator",8]]]],[11,"extend_one","","",44,[[]]],[11,"extend_reserve","","",44,[[["usize",15]]]],[11,"extend","","",44,[[["intoiterator",8]]]],[11,"extend_one","","",44,[[]]],[11,"extend_reserve","","",44,[[["usize",15]]]],[11,"clone","alloc::alloc","",48,[[],["global",3]]],[11,"clone","alloc::boxed","Returns a new box with a <code>clone()</code> of this box\'s contents.",2,[[]]],[11,"clone_from","","Copies <code>source</code>\'s contents into <code>self</code> without creating a new …",2,[[]]],[11,"clone","","",2,[[]]],[11,"clone","","",2,[[]]],[11,"clone_from","","",2,[[]]],[11,"clone","alloc::borrow","",6,[[]]],[11,"clone_from","","",6,[[]]],[11,"clone","alloc::collections::binary_heap","",8,[[]]],[11,"clone_from","","",8,[[]]],[11,"clone","","",49,[[]]],[11,"clone","","",50,[[],["intoiter",3]]],[11,"clone","","",51,[[],["intoitersorted",3]]],[11,"clone","alloc::collections::btree_map","",56,[[],["btreemap",3]]],[11,"clone","","",57,[[]]],[11,"clone","","",60,[[]]],[11,"clone","","",61,[[]]],[11,"clone","","",65,[[]]],[11,"clone","alloc::collections::btree_set","",68,[[]]],[11,"clone_from","","",68,[[]]],[11,"clone","","",69,[[]]],[11,"clone","","",71,[[]]],[11,"clone","","",72,[[]]],[11,"clone","","",73,[[]]],[11,"clone","","",74,[[]]],[11,"clone","","",75,[[]]],[11,"clone","alloc::collections::linked_list","",77,[[]]],[11,"clone","","",79,[[],["intoiter",3]]],[11,"clone","","",10,[[]]],[11,"clone","","",9,[[]]],[11,"clone_from","","",9,[[]]],[11,"clone","alloc::collections::vec_deque","",83,[[],["intoiter",3]]],[11,"clone","","",84,[[]]],[11,"clone","","",12,[[],["vecdeque",3]]],[11,"clone_from","","",12,[[]]],[11,"clone","alloc::collections","",14,[[],["tryreserveerror",4]]],[11,"clone","alloc::rc","Makes a clone of the <code>Rc</code> pointer.",27,[[],["rc",3]]],[11,"clone","","Makes a clone of the <code>Weak</code> pointer that points to the same …",28,[[],["weak",3]]],[11,"clone","alloc::string","",38,[[],["fromutf8error",3]]],[11,"clone","","",37,[[]]],[11,"clone_from","","",37,[[]]],[11,"clone","alloc::sync","Makes a clone of the <code>Arc</code> pointer.",41,[[],["arc",3]]],[11,"clone","","Makes a clone of the <code>Weak</code> pointer that points to the same …",42,[[],["weak",3]]],[11,"clone","alloc::vec","",148,[[]]],[11,"clone","","",44,[[]]],[11,"clone_from","","",44,[[]]],[11,"default","alloc::alloc","",48,[[],["global",3]]],[11,"default","alloc::boxed","Creates a <code>Box<T></code>, with the <code>Default</code> value for T.",2,[[]]],[11,"default","","",2,[[]]],[11,"default","","",2,[[]]],[11,"default","alloc::borrow","Creates an owned Cow<\'a, B> with the default value for …",6,[[]]],[11,"default","alloc::collections::binary_heap","Creates an empty <code>BinaryHeap<T></code>.",8,[[],["binaryheap",3]]],[11,"default","alloc::collections::btree_map","Creates an empty <code>BTreeMap</code>.",56,[[],["btreemap",3]]],[11,"default","alloc::collections::btree_set","Creates an empty <code>BTreeSet</code>.",68,[[],["btreeset",3]]],[11,"default","alloc::collections::linked_list","Creates an empty <code>LinkedList<T></code>.",9,[[]]],[11,"default","alloc::collections::vec_deque","Creates an empty <code>VecDeque<T></code>.",12,[[],["vecdeque",3]]],[11,"default","alloc::rc","Creates a new <code>Rc<T></code>, with the <code>Default</code> value for <code>T</code>.",27,[[],["rc",3]]],[11,"default","","Constructs a new <code>Weak<T></code>, allocating memory for <code>T</code> without …",28,[[],["weak",3]]],[11,"default","alloc::string","Creates an empty <code>String</code>.",37,[[],["string",3]]],[11,"default","alloc::sync","Constructs a new <code>Weak<T></code>, without allocating memory. …",42,[[],["weak",3]]],[11,"default","","Creates a new <code>Arc<T></code>, with the <code>Default</code> value for <code>T</code>.",41,[[],["arc",3]]],[11,"default","alloc::vec","Creates an empty <code>Vec<T></code>.",44,[[],["vec",3]]],[11,"poll_next","alloc::boxed","",2,[[["pin",3],["context",3]],[["poll",4],["option",4]]]],[11,"size_hint","","",2,[[]]],[11,"poll","","",2,[[["pin",3],["context",3]],["poll",4]]],[11,"allocate","alloc::alloc","",48,[[["layout",3]],[["nonnull",3],["allocerror",3],["result",4]]]],[11,"allocate_zeroed","","",48,[[["layout",3]],[["nonnull",3],["allocerror",3],["result",4]]]],[11,"deallocate","","",48,[[["u8",15],["layout",3],["nonnull",3]]]],[11,"grow","","",48,[[["u8",15],["layout",3],["nonnull",3]],[["nonnull",3],["allocerror",3],["result",4]]]],[11,"grow_zeroed","","",48,[[["u8",15],["layout",3],["nonnull",3]],[["nonnull",3],["allocerror",3],["result",4]]]],[11,"shrink","","",48,[[["u8",15],["layout",3],["nonnull",3]],[["nonnull",3],["allocerror",3],["result",4]]]],[11,"from_size_align","","Constructs a <code>Layout</code> from a given <code>size</code> and <code>align</code>, or …",46,[[["usize",15]],[["result",4],["layouterror",3],["layout",3]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",46,[[["usize",15]],["layout",3]]],[11,"size","","The minimum size in bytes for a memory block of this …",46,[[],["usize",15]]],[11,"align","","The minimum byte alignment for a memory block of this …",46,[[],["usize",15]]],[11,"new","","Constructs a <code>Layout</code> suitable for holding a value of type <code>T</code>…",46,[[],["layout",3]]],[11,"for_value","","Produces layout describing a record that could be used to …",46,[[],["layout",3]]],[11,"for_value_raw","","Produces layout describing a record that could be used to …",46,[[],["layout",3]]],[11,"dangling","","Creates a <code>NonNull</code> that is dangling, but well-aligned for …",46,[[],[["u8",15],["nonnull",3]]]],[11,"align_to","","Creates a layout describing the record that can hold a …",46,[[["usize",15]],[["result",4],["layouterror",3],["layout",3]]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after <code>self</code> …",46,[[["usize",15]],["usize",15]]],[11,"pad_to_align","","Creates a layout by rounding the size of this layout up …",46,[[],["layout",3]]],[11,"repeat","","Creates a layout describing the record for <code>n</code> instances of …",46,[[["usize",15]],[["result",4],["layouterror",3]]]],[11,"extend","","Creates a layout describing the record for <code>self</code> followed …",46,[[["layout",3]],[["result",4],["layouterror",3]]]],[11,"repeat_packed","","Creates a layout describing the record for <code>n</code> instances of …",46,[[["usize",15]],[["result",4],["layouterror",3],["layout",3]]]],[11,"extend_packed","","Creates a layout describing the record for <code>self</code> followed …",46,[[["layout",3]],[["result",4],["layouterror",3],["layout",3]]]],[11,"array","","Creates a layout describing the record for a <code>[T; n]</code>.",46,[[["usize",15]],[["result",4],["layouterror",3],["layout",3]]]],[11,"or_insert","alloc::collections::btree_map","Ensures a value is in the entry by inserting the default …",13,[[]]],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result …",13,[[["fnonce",8]]]],[11,"or_insert_with_key","","Ensures a value is in the entry by inserting, if empty, …",13,[[["fnonce",8]]]],[11,"key","","Returns a reference to this entry\'s key.",13,[[]]],[11,"and_modify","","Provides in-place mutable access to an occupied entry …",13,[[]]],[11,"or_default","","Ensures a value is in the entry by inserting the default …",13,[[]]],[11,"key","","Gets a reference to the key that would be used when …",54,[[]]],[11,"into_key","","Take ownership of the key.",54,[[]]],[11,"insert","","Sets the value of the entry with the <code>VacantEntry</code>\'s key, …",54,[[]]],[11,"key","","Gets a reference to the key in the entry.",55,[[]]],[11,"remove_entry","","Take ownership of the key and value from the map.",55,[[]]],[11,"get","","Gets a reference to the value in the entry.",55,[[]]],[11,"get_mut","","Gets a mutable reference to the value in the entry.",55,[[]]],[11,"into_mut","","Converts the entry into a mutable reference to its value.",55,[[]]],[11,"insert","","Sets the value of the entry with the <code>OccupiedEntry</code>\'s key, …",55,[[]]],[11,"remove","","Takes the value of the entry out of the map, and returns …",55,[[]]],[11,"new","","Makes a new, empty <code>BTreeMap</code>.",56,[[],["btreemap",3]]],[11,"clear","","Clears the map, removing all elements.",56,[[]]],[11,"get","","Returns a reference to the value corresponding to the key.",56,[[],["option",4]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied …",56,[[],["option",4]]],[11,"first_key_value","","Returns the first key-value pair in the map. The key in …",56,[[],["option",4]]],[11,"first_entry","","Returns the first entry in the map for in-place …",56,[[],[["option",4],["occupiedentry",3]]]],[11,"pop_first","","Removes and returns the first element in the map. The key …",56,[[],["option",4]]],[11,"last_key_value","","Returns the last key-value pair in the map. The key in …",56,[[],["option",4]]],[11,"last_entry","","Returns the last entry in the map for in-place …",56,[[],[["option",4],["occupiedentry",3]]]],[11,"pop_last","","Removes and returns the last element in the map. The key …",56,[[],["option",4]]],[11,"contains_key","","Returns <code>true</code> if the map contains a value for the …",56,[[],["bool",15]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to …",56,[[],["option",4]]],[11,"insert","","Inserts a key-value pair into the map.",56,[[],["option",4]]],[11,"remove","","Removes a key from the map, returning the value at the …",56,[[],["option",4]]],[11,"remove_entry","","Removes a key from the map, returning the stored key and …",56,[[],["option",4]]],[11,"retain","","Retains only the elements specified by the predicate.",56,[[]]],[11,"append","","Moves all elements from <code>other</code> into <code>Self</code>, leaving <code>other</code> …",56,[[]]],[11,"range","","Constructs a double-ended iterator over a sub-range of …",56,[[],["range",3]]],[11,"range_mut","","Constructs a mutable double-ended iterator over a …",56,[[],["rangemut",3]]],[11,"entry","","Gets the given key\'s corresponding entry in the map for …",56,[[],["entry",4]]],[11,"split_off","","Splits the collection into two at the given key. Returns …",56,[[]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if …",56,[[],["drainfilter",3]]],[11,"into_keys","","Creates a consuming iterator visiting all the keys, in …",56,[[],["intokeys",3]]],[11,"into_values","","Creates a consuming iterator visiting all the values, in …",56,[[],["intovalues",3]]],[11,"iter","","Gets an iterator over the entries of the map, sorted by …",56,[[],["iter",3]]],[11,"iter_mut","","Gets a mutable iterator over the entries of the map, …",56,[[],["itermut",3]]],[11,"keys","","Gets an iterator over the keys of the map, in sorted …",56,[[],["keys",3]]],[11,"values","","Gets an iterator over the values of the map, in order by …",56,[[],["values",3]]],[11,"values_mut","","Gets a mutable iterator over the values of the map, in …",56,[[],["valuesmut",3]]],[11,"len","","Returns the number of elements in the map.",56,[[],["usize",15]]],[11,"is_empty","","Returns <code>true</code> if the map contains no elements.",56,[[],["bool",15]]],[11,"new","alloc::collections::btree_set","Makes a new, empty <code>BTreeSet</code>.",68,[[],["btreeset",3]]],[11,"range","","Constructs a double-ended iterator over a sub-range of …",68,[[],["range",3]]],[11,"difference","","Visits the values representing the difference, i.e., the …",68,[[["btreeset",3]],["difference",3]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference, …",68,[[["btreeset",3]],["symmetricdifference",3]]],[11,"intersection","","Visits the values representing the intersection, i.e., …",68,[[["btreeset",3]],["intersection",3]]],[11,"union","","Visits the values representing the union, i.e., all the …",68,[[["btreeset",3]],["union",3]]],[11,"clear","","Clears the set, removing all values.",68,[[]]],[11,"contains","","Returns <code>true</code> if the set contains a value.",68,[[],["bool",15]]],[11,"get","","Returns a reference to the value in the set, if any, that …",68,[[],["option",4]]],[11,"is_disjoint","","Returns <code>true</code> if <code>self</code> has no elements in common with <code>other</code>.…",68,[[["btreeset",3]],["bool",15]]],[11,"is_subset","","Returns <code>true</code> if the set is a subset of another, i.e., …",68,[[["btreeset",3]],["bool",15]]],[11,"is_superset","","Returns <code>true</code> if the set is a superset of another, i.e., …",68,[[["btreeset",3]],["bool",15]]],[11,"first","","Returns a reference to the first value in the set, if any.…",68,[[],["option",4]]],[11,"last","","Returns a reference to the last value in the set, if any. …",68,[[],["option",4]]],[11,"pop_first","","Removes the first value from the set and returns it, if …",68,[[],["option",4]]],[11,"pop_last","","Removes the last value from the set and returns it, if …",68,[[],["option",4]]],[11,"insert","","Adds a value to the set.",68,[[],["bool",15]]],[11,"replace","","Adds a value to the set, replacing the existing value, if …",68,[[],["option",4]]],[11,"remove","","Removes a value from the set. Returns whether the value …",68,[[],["bool",15]]],[11,"take","","Removes and returns the value in the set, if any, that is …",68,[[],["option",4]]],[11,"retain","","Retains only the elements specified by the predicate.",68,[[]]],[11,"append","","Moves all elements from <code>other</code> into <code>Self</code>, leaving <code>other</code> …",68,[[]]],[11,"split_off","","Splits the collection into two at the given key. Returns …",68,[[]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if …",68,[[],["drainfilter",3]]],[11,"iter","","Gets an iterator that visits the values in the <code>BTreeSet</code> …",68,[[],["iter",3]]],[11,"len","","Returns the number of elements in the set.",68,[[],["usize",15]]],[11,"is_empty","","Returns <code>true</code> if the set contains no elements.",68,[[],["bool",15]]],[11,"as_str","alloc::fmt","Get the formatted string, if it has no arguments to be …",86,[[],[["option",4],["str",15]]]],[11,"entry","","Adds a new entry to the list output.",87,[[["debug",8]],["debuglist",3]]],[11,"entries","","Adds the contents of an iterator of entries to the list …",87,[[],["debuglist",3]]],[11,"finish","","Finishes output and returns any error encountered.",87,[[],[["error",3],["result",4]]]],[11,"entry","","Adds a new entry to the map output.",88,[[["debug",8]],["debugmap",3]]],[11,"key","","Adds the key part of a new entry to the map output.",88,[[["debug",8]],["debugmap",3]]],[11,"value","","Adds the value part of a new entry to the map output.",88,[[["debug",8]],["debugmap",3]]],[11,"entries","","Adds the contents of an iterator of entries to the map …",88,[[],["debugmap",3]]],[11,"finish","","Finishes output and returns any error encountered.",88,[[],[["error",3],["result",4]]]],[11,"entry","","Adds a new entry to the set output.",89,[[["debug",8]],["debugset",3]]],[11,"entries","","Adds the contents of an iterator of entries to the set …",89,[[],["debugset",3]]],[11,"finish","","Finishes output and returns any error encountered.",89,[[],[["error",3],["result",4]]]],[11,"field","","Adds a new field to the generated struct output.",90,[[["str",15],["debug",8]],["debugstruct",3]]],[11,"finish_non_exhaustive","","Marks the struct as non-exhaustive, indicating to the …",90,[[],[["error",3],["result",4]]]],[11,"finish","","Finishes output and returns any error encountered.",90,[[],[["error",3],["result",4]]]],[11,"field","","Adds a new field to the generated tuple struct output.",91,[[["debug",8]],["debugtuple",3]]],[11,"finish","","Finishes output and returns any error encountered.",91,[[],[["error",3],["result",4]]]],[11,"pad_integral","","Performs the correct padding for an integer which has …",92,[[["str",15],["bool",15]],[["error",3],["result",4]]]],[11,"pad","","This function takes a string slice and emits it to the …",92,[[["str",15]],[["error",3],["result",4]]]],[11,"write_str","","Writes some data to the underlying buffer contained …",92,[[["str",15]],[["error",3],["result",4]]]],[11,"write_fmt","","Writes some formatted information into this instance.",92,[[["arguments",3]],[["error",3],["result",4]]]],[11,"flags","","Flags for formatting",92,[[],["u32",15]]],[11,"fill","","Character used as \'fill\' whenever there is alignment.",92,[[],["char",15]]],[11,"align","","Flag indicating what form of alignment was requested.",92,[[],[["option",4],["alignment",4]]]],[11,"width","","Optionally specified integer width that the output should …",92,[[],[["usize",15],["option",4]]]],[11,"precision","","Optionally specified precision for numeric types. …",92,[[],[["usize",15],["option",4]]]],[11,"sign_plus","","Determines if the <code>+</code> flag was specified.",92,[[],["bool",15]]],[11,"sign_minus","","Determines if the <code>-</code> flag was specified.",92,[[],["bool",15]]],[11,"alternate","","Determines if the <code>#</code> flag was specified.",92,[[],["bool",15]]],[11,"sign_aware_zero_pad","","Determines if the <code>0</code> flag was specified.",92,[[],["bool",15]]],[11,"debug_struct","","Creates a [<code>DebugStruct</code>] builder designed to assist with …",92,[[["str",15]],["debugstruct",3]]],[11,"debug_tuple","","Creates a <code>DebugTuple</code> builder designed to assist with …",92,[[["str",15]],["debugtuple",3]]],[11,"debug_list","","Creates a <code>DebugList</code> builder designed to assist with …",92,[[],["debuglist",3]]],[11,"debug_set","","Creates a <code>DebugSet</code> builder designed to assist with …",92,[[],["debugset",3]]],[11,"debug_map","","Creates a <code>DebugMap</code> builder designed to assist with …",92,[[],["debugmap",3]]],[11,"remainder","alloc::slice","Returns the remainder of the original slice that is not …",93,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not …",94,[[]]],[11,"remainder","","Returns the remainder of the original slice that is not …",98,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not …",99,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original …",105,[[]]],[11,"into_slice","","Views the underlying data as a subslice of the original …",106,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original …",106,[[]]],[11,"remainder","","Returns the remainder of the original slice that is not …",108,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not …",109,[[]]],[11,"as_str","alloc::str","Views the underlying data as a subslice of the original …",125,[[],["str",15]]],[11,"as_str","","Views the underlying data as a subslice of the original …",126,[[],["str",15]]],[11,"valid_up_to","","Returns the index in the given string up to which valid …",131,[[],["usize",15]]],[11,"error_len","","Provides more information about the failure:",131,[[],[["usize",15],["option",4]]]],[11,"as_str","","Returns remainder of the splitted string",138,[[],["str",15]]],[11,"as_str","","Returns remainder of the splitted string",139,[[],["str",15]]],[11,"as_str","","Returns remainder of the splitted string",140,[[],["str",15]]],[11,"as_str","","Returns remainder of the splitted string",141,[[],["str",15]]],[11,"as_str","","Returns remainder of the splitted string",142,[[],["str",15]]],[11,"as_str","","Returns remainder of the splitted string",143,[[],["str",15]]],[11,"allocator","alloc::vec","Returns a reference to the underlying allocator.",145,[[]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",147,[[]]],[11,"allocator","","Returns a reference to the underlying allocator.",147,[[]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",148,[[]]],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable …",148,[[]]],[11,"allocator","","Returns a reference to the underlying allocator.",148,[[]]]],"p":[[8,"Allocator"],[8,"GlobalAlloc"],[3,"Box"],[8,"Borrow"],[8,"BorrowMut"],[8,"ToOwned"],[4,"Cow"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"LinkedList"],[3,"Cursor"],[3,"CursorMut"],[3,"VecDeque"],[4,"Entry"],[4,"TryReserveError"],[13,"AllocError"],[4,"Alignment"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"Write"],[8,"LowerExp"],[8,"UpperExp"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[3,"Rc"],[3,"Weak"],[8,"SliceIndex"],[8,"Concat"],[8,"Join"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"FromStr"],[3,"String"],[3,"FromUtf8Error"],[8,"ToString"],[3,"Drain"],[3,"Arc"],[3,"Weak"],[8,"Wake"],[3,"Vec"],[3,"AllocError"],[3,"Layout"],[3,"LayoutError"],[3,"Global"],[3,"Iter"],[3,"IntoIter"],[3,"IntoIterSorted"],[3,"Drain"],[3,"DrainSorted"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"IntoKeys"],[3,"IntoValues"],[3,"Range"],[3,"RangeMut"],[3,"DrainFilter"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"DrainFilter"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"DrainFilter"],[3,"Drain"],[3,"IterMut"],[3,"IntoIter"],[3,"Iter"],[3,"Error"],[3,"Arguments"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"Formatter"],[3,"ArrayChunks"],[3,"ArrayChunksMut"],[3,"ArrayWindows"],[3,"Chunks"],[3,"Windows"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"ChunksMut"],[3,"Split"],[3,"SplitMut"],[3,"GroupBy"],[3,"GroupByMut"],[3,"Iter"],[3,"IterMut"],[3,"RChunks"],[3,"RChunksExact"],[3,"RChunksExactMut"],[3,"RChunksMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"RSplitN"],[3,"RSplitNMut"],[3,"SplitN"],[3,"SplitNMut"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"EncodeUtf16"],[3,"SplitAsciiWhitespace"],[3,"SplitWhitespace"],[3,"Bytes"],[3,"CharIndices"],[3,"Chars"],[3,"ParseBoolError"],[3,"EscapeDebug"],[3,"EscapeDefault"],[3,"EscapeUnicode"],[3,"Utf8Error"],[3,"Lines"],[3,"LinesAny"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"RSplit"],[3,"Split"],[3,"RSplitN"],[3,"SplitN"],[3,"RSplitTerminator"],[3,"SplitTerminator"],[3,"FromUtf16Error"],[3,"DrainFilter"],[3,"Splice"],[3,"Drain"],[3,"IntoIter"]],"a":{"alloc":[26,426,562],"calloc":[28],"delete":[2763,2799],"length":[96,120,181,454,550,2779,2806],"malloc":[26,426,517,562],"realloc":[525,526,527,528,529,530],"{:?}":[255],"{}":[258]}},\
"core":{"doc":"The Rust Core LibraryThe Rust Core Library is the …","i":[[0,"i128","core","Constants for the 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"i16","core","Constants for the 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"i32","core","Constants for the 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"i64","core","Constants for the 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"i8","core","Constants for the 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"isize","core","Constants for the pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"u128","core","Constants for the 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"u16","core","Constants for the 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"u32","core","Constants for the 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"u64","core","Constants for the 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"u8","core","Constants for the 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"usize","core","Constants for the pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this …",null,null],[17,"MAX","","The largest value that can be represented by this integer …",null,null],[0,"f32","core","Constants specific to the <code>f32</code> single-precision floating …",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes\' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler\'s number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of <code>f32</code>. …",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use …",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10. Use …",null,null],[17,"EPSILON","","Machine epsilon value for <code>f32</code>. Use <code>f32::EPSILON</code> instead.",null,null],[17,"MIN","","Smallest finite <code>f32</code> value. Use <code>f32::MIN</code> instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal <code>f32</code> value. Use <code>f32::MIN_POSITIVE</code> …",null,null],[17,"MAX","","Largest finite <code>f32</code> value. Use <code>f32::MAX</code> instead.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 …",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use <code>f32::MAX_EXP</code> …",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use …",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use <code>f32::MAX_10_EXP</code>…",null,null],[17,"NAN","","Not a Number (NaN). Use <code>f32::NAN</code> instead.",null,null],[17,"INFINITY","","Infinity (∞). Use <code>f32::INFINITY</code> instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use <code>f32::NEG_INFINITY</code> instead.",null,null],[0,"f64","core","Constants specific to the <code>f64</code> double-precision floating …",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes\' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler\'s number (e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of <code>f64</code>. …",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use …",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10. Use …",null,null],[17,"EPSILON","","Machine epsilon value for <code>f64</code>. Use <code>f64::EPSILON</code> instead.",null,null],[17,"MIN","","Smallest finite <code>f64</code> value. Use <code>f64::MIN</code> instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal <code>f64</code> value. Use <code>f64::MIN_POSITIVE</code> …",null,null],[17,"MAX","","Largest finite <code>f64</code> value. Use <code>f64::MAX</code> instead.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2 …",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use <code>f64::MAX_EXP</code> …",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use …",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use <code>f64::MAX_10_EXP</code>…",null,null],[17,"NAN","","Not a Number (NaN). Use <code>f64::NAN</code> instead.",null,null],[17,"INFINITY","","Infinity (∞). Use <code>f64::INFINITY</code> instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use <code>f64::NEG_INFINITY</code> instead.",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric …",null,null],[3,"Wrapping","core::num","Provides intentionally-wrapped arithmetic on <code>T</code>.",null,null],[12,"0","","",0,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"NonZeroU128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU8","","An integer that is known not to equal zero.",null,null],[3,"NonZeroUsize","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI8","","An integer that is known not to equal zero.",null,null],[3,"NonZeroIsize","","An integer that is known not to equal zero.",null,null],[3,"TryFromIntError","","The error type returned when a checked integral type …",null,null],[4,"IntErrorKind","","Enum to store the various types of errors that can cause …",null,null],[13,"Empty","","Value being parsed is empty.",1,null],[13,"InvalidDigit","","Contains an invalid digit in its context.",1,null],[13,"PosOverflow","","Integer is too large to store in target integer type.",1,null],[13,"NegOverflow","","Integer is too small to store in target integer type.",1,null],[13,"Zero","","Value was Zero",1,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\\\"Not a Number\\\", often obtained by dividing by zero.",2,null],[13,"Infinite","","Positive or negative infinity.",2,null],[13,"Zero","","Positive or negative zero.",2,null],[13,"Subnormal","","De-normalized floating point representation (less precise …",2,null],[13,"Normal","","A regular floating point number.",2,null],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"hint","core","Hints to compiler that affects how code should be emitted …",null,null],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not …",null,[[]]],[5,"spin_loop","","Emits a machine instruction to signal the processor that …",null,[[]]],[5,"black_box","","An identity function that <em><strong>hints</strong></em> to the compiler to be …",null,[[]]],[0,"intrinsics","core","Compiler intrinsics.",null,null],[5,"atomic_cxchg","core::intrinsics","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the <code>old</code>…",null,null],[5,"atomic_load","","Loads the current value of the pointer.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location, …",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location, …",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location, …",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location, …",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location, …",null,null],[5,"atomic_xadd","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_acq","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_rel","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_acqrel","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_relaxed","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous …",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous …",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous …",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous …",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous …",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the …",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the …",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the …",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the …",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the …",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the …",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the …",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the …",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the …",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the …",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous …",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous …",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous …",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous …",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous …",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the …",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the …",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the …",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the …",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the …",null,null],[5,"atomic_max","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_acq","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_rel","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_acqrel","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_relaxed","","Maximum with the current value.",null,null],[5,"atomic_min","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_acq","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_rel","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_acqrel","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_relaxed","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_umin","","Minimum with the current value using an unsigned …",null,null],[5,"atomic_umin_acq","","Minimum with the current value using an unsigned …",null,null],[5,"atomic_umin_rel","","Minimum with the current value using an unsigned …",null,null],[5,"atomic_umin_acqrel","","Minimum with the current value using an unsigned …",null,null],[5,"atomic_umin_relaxed","","Minimum with the current value using an unsigned …",null,null],[5,"atomic_umax","","Maximum with the current value using an unsigned …",null,null],[5,"atomic_umax_acq","","Maximum with the current value using an unsigned …",null,null],[5,"atomic_umax_rel","","Maximum with the current value using an unsigned …",null,null],[5,"atomic_umax_acqrel","","Maximum with the current value using an unsigned …",null,null],[5,"atomic_umax_relaxed","","Maximum with the current value using an unsigned …",null,null],[5,"prefetch_read_data","","The <code>prefetch</code> intrinsic is a hint to the code generator to …",null,null],[5,"prefetch_write_data","","The <code>prefetch</code> intrinsic is a hint to the code generator to …",null,null],[5,"prefetch_read_instruction","","The <code>prefetch</code> intrinsic is a hint to the code generator to …",null,null],[5,"prefetch_write_instruction","","The <code>prefetch</code> intrinsic is a hint to the code generator to …",null,null],[5,"atomic_fence","","An atomic fence.",null,null],[5,"atomic_fence_acq","","An atomic fence.",null,null],[5,"atomic_fence_rel","","An atomic fence.",null,null],[5,"atomic_fence_acqrel","","An atomic fence.",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_rel","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acqrel","","A compiler-only memory barrier.",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes …",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Informs the optimizer that this point in the code is not …",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If …",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to …",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to …",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"min_align_of","","The minimum alignment of a type.",null,null],[5,"pref_align_of","","The preferred alignment of a type.",null,null],[5,"size_of_val","","The size of the referenced value in bytes.",null,null],[5,"min_align_of_val","","The required alignment of the referenced value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the …",null,null],[5,"assert_inhabited","","A guard for unsafe functions that cannot ever be executed …",null,null],[5,"assert_zero_valid","","A guard for unsafe functions that cannot ever be executed …",null,null],[5,"assert_uninit_valid","","A guard for unsafe functions that cannot ever be executed …",null,null],[5,"caller_location","","Gets a reference to a static <code>Location</code> indicating where it …",null,null],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another …",null,null],[5,"needs_drop","","Returns <code>true</code> if the actual type given as <code>T</code> requires drop …",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially …",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate <code>llvm.memcpy.p0i8.0i8.*</code> …",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate <code>llvm.memmove.p0i8.0i8.*</code> …",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate <code>llvm.memset.p0i8.*</code> …",null,null],[5,"volatile_load","","Performs a volatile load from the <code>src</code> pointer.",null,null],[5,"volatile_store","","Performs a volatile store to the <code>dst</code> pointer.",null,null],[5,"unaligned_volatile_load","","Performs a volatile load from the <code>src</code> pointer The pointer …",null,null],[5,"unaligned_volatile_store","","Performs a volatile store to the <code>dst</code> pointer. The pointer …",null,null],[5,"sqrtf32","","Returns the square root of an <code>f32</code>",null,null],[5,"sqrtf64","","Returns the square root of an <code>f64</code>",null,null],[5,"powif32","","Raises an <code>f32</code> to an integer power.",null,null],[5,"powif64","","Raises an <code>f64</code> to an integer power.",null,null],[5,"sinf32","","Returns the sine of an <code>f32</code>.",null,null],[5,"sinf64","","Returns the sine of an <code>f64</code>.",null,null],[5,"cosf32","","Returns the cosine of an <code>f32</code>.",null,null],[5,"cosf64","","Returns the cosine of an <code>f64</code>.",null,null],[5,"powf32","","Raises an <code>f32</code> to an <code>f32</code> power.",null,null],[5,"powf64","","Raises an <code>f64</code> to an <code>f64</code> power.",null,null],[5,"expf32","","Returns the exponential of an <code>f32</code>.",null,null],[5,"expf64","","Returns the exponential of an <code>f64</code>.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an <code>f32</code>.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an <code>f64</code>.",null,null],[5,"logf32","","Returns the natural logarithm of an <code>f32</code>.",null,null],[5,"logf64","","Returns the natural logarithm of an <code>f64</code>.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an <code>f32</code>.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an <code>f64</code>.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an <code>f32</code>.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an <code>f64</code>.",null,null],[5,"fmaf32","","Returns <code>a * b + c</code> for <code>f32</code> values.",null,null],[5,"fmaf64","","Returns <code>a * b + c</code> for <code>f64</code> values.",null,null],[5,"fabsf32","","Returns the absolute value of an <code>f32</code>.",null,null],[5,"fabsf64","","Returns the absolute value of an <code>f64</code>.",null,null],[5,"minnumf32","","Returns the minimum of two <code>f32</code> values.",null,null],[5,"minnumf64","","Returns the minimum of two <code>f64</code> values.",null,null],[5,"maxnumf32","","Returns the maximum of two <code>f32</code> values.",null,null],[5,"maxnumf64","","Returns the maximum of two <code>f64</code> values.",null,null],[5,"copysignf32","","Copies the sign from <code>y</code> to <code>x</code> for <code>f32</code> values.",null,null],[5,"copysignf64","","Copies the sign from <code>y</code> to <code>x</code> for <code>f64</code> values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an <code>f32</code>.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an <code>f64</code>.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an …",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an …",null,null],[5,"truncf32","","Returns the integer part of an <code>f32</code>.",null,null],[5,"truncf64","","Returns the integer part of an <code>f64</code>.",null,null],[5,"rintf32","","Returns the nearest integer to an <code>f32</code>. May raise an …",null,null],[5,"rintf64","","Returns the nearest integer to an <code>f64</code>. May raise an …",null,null],[5,"nearbyintf32","","Returns the nearest integer to an <code>f32</code>.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an <code>f64</code>.",null,null],[5,"roundf32","","Returns the nearest integer to an <code>f32</code>. Rounds half-way …",null,null],[5,"roundf64","","Returns the nearest integer to an <code>f64</code>. Rounds half-way …",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on …",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on …",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on …",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on …",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on …",null,null],[5,"float_to_int_unchecked","","Convert with LLVM’s fptoui/fptosi, which may return …",null,null],[5,"ctpop","","Returns the number of bits set in an integer type <code>T</code>",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an …",null,null],[5,"ctlz_nonzero","","Like <code>ctlz</code>, but extra-unsafe as it returns <code>undef</code> when …",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an …",null,null],[5,"cttz_nonzero","","Like <code>cttz</code>, but extra-unsafe as it returns <code>undef</code> when …",null,null],[5,"bswap","","Reverses the bytes in an integer type <code>T</code>.",null,null],[5,"bitreverse","","Reverses the bits in an integer type <code>T</code>.",null,null],[5,"add_with_overflow","","Performs checked integer addition.",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication",null,null],[5,"exact_div","","Performs an exact division, resulting in undefined …",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined …",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting …",null,null],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined …",null,null],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined …",null,null],[5,"unchecked_add","","Returns the result of an unchecked addition, resulting in …",null,null],[5,"unchecked_sub","","Returns the result of an unchecked subtraction, resulting …",null,null],[5,"unchecked_mul","","Returns the result of an unchecked multiplication, …",null,null],[5,"rotate_left","","Performs rotate left.",null,null],[5,"rotate_right","","Performs rotate right.",null,null],[5,"wrapping_add","","Returns (a + b) mod 2N, where N is the width of T in bits.",null,null],[5,"wrapping_sub","","Returns (a - b) mod 2N, where N is the width of T in bits.",null,null],[5,"wrapping_mul","","Returns (a * b) mod 2N, where N is the width of T in bits.",null,null],[5,"saturating_add","","Computes <code>a + b</code>, saturating at numeric bounds.",null,null],[5,"saturating_sub","","Computes <code>a - b</code>, saturating at numeric bounds.",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in …",null,null],[5,"variant_count","","Returns the number of variants of the type <code>T</code> cast to a …",null,null],[5,"try","","Rust\'s \\\"try catch\\\" construct which invokes the function …",null,null],[5,"nontemporal_store","","Emits a <code>!nontemporal</code> store according to LLVM (see their …",null,null],[5,"ptr_offset_from","","See documentation of <code><*const T>::offset_from</code> for details.",null,null],[5,"ptr_guaranteed_eq","","See documentation of <code><*const T>::guaranteed_eq</code> for …",null,null],[5,"ptr_guaranteed_ne","","See documentation of <code><*const T>::guaranteed_ne</code> for …",null,null],[5,"const_allocate","","Allocate at compile time. Should not be called at runtime.",null,null],[5,"copy_nonoverlapping","","Copies <code>count * size_of::<T>()</code> bytes from <code>src</code> to <code>dst</code>. The …",null,[[["usize",15]]]],[5,"copy","","Copies <code>count * size_of::<T>()</code> bytes from <code>src</code> to <code>dst</code>. The …",null,[[["usize",15]]]],[5,"write_bytes","","Sets <code>count * size_of::<T>()</code> bytes of memory starting at …",null,[[["u8",15],["usize",15]]]],[0,"mem","core","Basic functions for dealing with memory.",null,null],[5,"transmute","core::mem","Reinterprets the bits of a value of one type as another …",null,null],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling <code>T</code>…",null,null],[19,"MaybeUninit","","A wrapper type to construct uninitialized instances of <code>T</code>.",null,null],[5,"forget","","Takes ownership and \\\"forgets\\\" about the value <strong>without …",null,[[]]],[5,"forget_unsized","","Like [<code>forget</code>], but also accepts unsized values.",null,[[["sized",8]]]],[5,"size_of","","Returns the size of a type in bytes.",null,[[],["usize",15]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,[[],["usize",15]]],[5,"size_of_val_raw","","Returns the size of the pointed-to value in bytes.",null,[[],["usize",15]]],[5,"min_align_of","","Returns the ABI-required minimum alignment of a type.",null,[[],["usize",15]]],[5,"min_align_of_val","","Returns the ABI-required minimum alignment of the type of …",null,[[],["usize",15]]],[5,"align_of","","Returns the ABI-required minimum alignment of a type.",null,[[],["usize",15]]],[5,"align_of_val","","Returns the ABI-required minimum alignment of the type of …",null,[[],["usize",15]]],[5,"align_of_val_raw","","Returns the ABI-required minimum alignment of the type of …",null,[[],["usize",15]]],[5,"needs_drop","","Returns <code>true</code> if dropping values of type <code>T</code> matters.",null,[[],["bool",15]]],[5,"zeroed","","Returns the value of type <code>T</code> represented by the all-zero …",null,[[]]],[5,"uninitialized","","Bypasses Rust\'s normal memory-initialization checks by …",null,[[]]],[5,"swap","","Swaps the values at two mutable locations, without …",null,[[]]],[5,"take","","Replaces <code>dest</code> with the default value of <code>T</code>, returning the …",null,[[],["default",8]]],[5,"replace","","Moves <code>src</code> into the referenced <code>dest</code>, returning the …",null,[[]]],[5,"drop","","Disposes of a value.",null,[[]]],[5,"transmute_copy","","Interprets <code>src</code> as having type <code>&U</code>, and then reads <code>src</code> …",null,[[]]],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[5,"discriminant","","Returns a value uniquely identifying the enum variant in <code>v</code>…",null,[[],["discriminant",3]]],[5,"variant_count","","Returns the number of variants in the enum type <code>T</code>.",null,[[],["usize",15]]],[0,"ptr","core","Manually manage memory through raw pointers.",null,null],[5,"copy_nonoverlapping","core::ptr","Copies <code>count * size_of::<T>()</code> bytes from <code>src</code> to <code>dst</code>. The …",null,[[["usize",15]]]],[5,"copy","","Copies <code>count * size_of::<T>()</code> bytes from <code>src</code> to <code>dst</code>. The …",null,[[["usize",15]]]],[5,"write_bytes","","Sets <code>count * size_of::<T>()</code> bytes of memory starting at …",null,[[["u8",15],["usize",15]]]],[3,"NonNull","","<code>*mut T</code> but non-zero and covariant.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,[[]]],[5,"null","","Creates a null raw pointer.",null,[[]]],[5,"null_mut","","Creates a null mutable raw pointer.",null,[[]]],[5,"slice_from_raw_parts","","Forms a raw slice from a pointer and a length.",null,[[["usize",15]]]],[5,"slice_from_raw_parts_mut","","Performs the same functionality as [<code>slice_from_raw_parts</code>]…",null,[[["usize",15]]]],[5,"swap","","Swaps the values at two mutable locations of the same …",null,[[]]],[5,"swap_nonoverlapping","","Swaps <code>count * size_of::<T>()</code> bytes between the two …",null,[[["usize",15]]]],[5,"replace","","Moves <code>src</code> into the pointed <code>dst</code>, returning the previous <code>dst</code>…",null,[[]]],[5,"read","","Reads the value from <code>src</code> without moving it. This leaves …",null,[[]]],[5,"read_unaligned","","Reads the value from <code>src</code> without moving it. This leaves …",null,[[]]],[5,"write","","Overwrites a memory location with the given value without …",null,[[]]],[5,"write_unaligned","","Overwrites a memory location with the given value without …",null,[[]]],[5,"read_volatile","","Performs a volatile read of the value from <code>src</code> without …",null,[[]]],[5,"write_volatile","","Performs a volatile write of a memory location with the …",null,[[]]],[5,"eq","","Compares raw pointers for equality.",null,[[],["bool",15]]],[5,"hash","","Hash a raw pointer.",null,[[]]],[14,"addr_of","","Create a <code>const</code> raw pointer to a place, without creating …",null,null],[14,"addr_of_mut","","Create a <code>mut</code> raw pointer to a place, without creating an …",null,null],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",3,[[]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",4,[[]]],[0,"clone","core","The <code>Clone</code> trait for types that cannot be \'implicitly …",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an …",null,null],[10,"clone","","Returns a copy of the value.",5,[[]]],[11,"clone_from","","Performs copy-assignment from <code>source</code>.",5,[[]]],[14,"Clone","","Derive macro generating an impl of the trait <code>Clone</code>.",null,null],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[8,"PartialEq","core::cmp","Trait for equality comparisons which are partial …",null,null],[10,"eq","","This method tests for <code>self</code> and <code>other</code> values to be equal, …",6,[[],["bool",15]]],[11,"ne","","This method tests for <code>!=</code>.",6,[[],["bool",15]]],[8,"Eq","","Trait for equality comparisons which are equivalence …",null,null],[4,"Ordering","","An <code>Ordering</code> is the result of a comparison between two …",null,null],[13,"Less","","An ordering where a compared value is less than another.",7,null],[13,"Equal","","An ordering where a compared value is equal to another.",7,null],[13,"Greater","","An ordering where a compared value is greater than …",7,null],[11,"is_eq","","Returns <code>true</code> if the ordering is the <code>Equal</code> variant.",7,[[],["bool",15]]],[11,"is_ne","","Returns <code>true</code> if the ordering is not the <code>Equal</code> variant.",7,[[],["bool",15]]],[11,"is_lt","","Returns <code>true</code> if the ordering is the <code>Less</code> variant.",7,[[],["bool",15]]],[11,"is_gt","","Returns <code>true</code> if the ordering is the <code>Greater</code> variant.",7,[[],["bool",15]]],[11,"is_le","","Returns <code>true</code> if the ordering is either the <code>Less</code> or <code>Equal</code> …",7,[[],["bool",15]]],[11,"is_ge","","Returns <code>true</code> if the ordering is either the <code>Greater</code> or …",7,[[],["bool",15]]],[11,"reverse","","Reverses the <code>Ordering</code>.",7,[[],["ordering",4]]],[11,"then","","Chains two orderings.",7,[[["ordering",4]],["ordering",4]]],[11,"then_with","","Chains the ordering with the given function.",7,[[["fnonce",8]],["ordering",4]]],[3,"Reverse","","A helper struct for reverse ordering.",null,null],[12,"0","","",8,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an [<code>Ordering</code>] between <code>self</code> and <code>other</code>.",9,[[],["ordering",4]]],[11,"max","","Compares and returns the maximum of two values.",9,[[]]],[11,"min","","Compares and returns the minimum of two values.",9,[[]]],[11,"clamp","","Restrict a value to a certain interval.",9,[[]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between <code>self</code> and <code>other</code> …",10,[[],[["ordering",4],["option",4]]]],[11,"lt","","This method tests less than (for <code>self</code> and <code>other</code>) and is …",10,[[],["bool",15]]],[11,"le","","This method tests less than or equal to (for <code>self</code> and …",10,[[],["bool",15]]],[11,"gt","","This method tests greater than (for <code>self</code> and <code>other</code>) and …",10,[[],["bool",15]]],[11,"ge","","This method tests greater than or equal to (for <code>self</code> and …",10,[[],["bool",15]]],[5,"min","","Compares and returns the minimum of two values.",null,[[["ord",8]],["ord",8]]],[5,"min_by","","Returns the minimum of two values with respect to the …",null,[[["fnonce",8]]]],[5,"min_by_key","","Returns the element that gives the minimum value from the …",null,[[["fnmut",8]]]],[5,"max","","Compares and returns the maximum of two values.",null,[[["ord",8]],["ord",8]]],[5,"max_by","","Returns the maximum of two values with respect to the …",null,[[["fnonce",8]]]],[5,"max_by_key","","Returns the element that gives the maximum value from the …",null,[[["fnmut",8]]]],[14,"PartialEq","","Derive macro generating an impl of the trait <code>PartialEq</code>.",null,null],[14,"Eq","","Derive macro generating an impl of the trait <code>Eq</code>.",null,null],[14,"Ord","","Derive macro generating an impl of the trait <code>Ord</code>.",null,null],[14,"PartialOrd","","Derive macro generating an impl of the trait <code>PartialOrd</code>.",null,null],[0,"convert","core","Traits for conversions between types.",null,null],[8,"FloatToInt","core::convert","Supporting trait for inherent methods of <code>f32</code> and <code>f64</code> such …",null,null],[5,"identity","","The identity function.",null,[[]]],[8,"AsRef","","Used to do a cheap reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",11,[[]]],[8,"AsMut","","Used to do a cheap mutable-to-mutable reference …",null,null],[10,"as_mut","","Performs the conversion.",12,[[]]],[8,"Into","","A value-to-value conversion that consumes the input …",null,null],[10,"into","","Performs the conversion.",13,[[]]],[8,"From","","Used to do value-to-value conversions while consuming the …",null,null],[10,"from","","Performs the conversion.",14,[[]]],[8,"TryInto","","An attempted conversion that consumes <code>self</code>, which may or …",null,null],[16,"Error","","The type returned in the event of a conversion error.",15,null],[10,"try_into","","Performs the conversion.",15,[[],["result",4]]],[8,"TryFrom","","Simple and safe type conversions that may fail in a …",null,null],[16,"Error","","The type returned in the event of a conversion error.",16,null],[10,"try_from","","Performs the conversion.",16,[[],["result",4]]],[4,"Infallible","","The error type for errors that can never happen.",null,null],[0,"default","core","The <code>Default</code> trait for types which may have meaningful …",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \\\"default value\\\" for a type.",17,[[]]],[5,"default","","Return the default value of a type according to the …",null,[[],["default",8]]],[14,"Default","","Derive macro generating an impl of the trait <code>Default</code>.",null,null],[0,"marker","core","Primitive traits and types representing basic properties …",null,null],[8,"Send","core::marker","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \\\"unsized\\\" to a dynamically-sized type.",null,null],[8,"StructuralPartialEq","","Required trait for constants used in pattern matches.",null,null],[8,"StructuralEq","","Required trait for constants used in pattern matches.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying …",null,null],[8,"Sync","","Types for which it is safe to share references between …",null,null],[3,"PhantomData","","Zero-sized type used to mark things that \\\"act like\\\" they …",null,null],[8,"DiscriminantKind","","Compiler-internal trait used to indicate the type of enum …",null,null],[16,"Discriminant","","The type of the discriminant, which must satisfy the trait…",18,null],[8,"Unpin","","Types that can be safely moved after being pinned.",null,null],[3,"PhantomPinned","","A marker type which does not implement <code>Unpin</code>.",null,null],[14,"Copy","","Derive macro generating an impl of the trait <code>Copy</code>.",null,null],[0,"ops","core","Overloadable operators.",null,null],[8,"Add","core::ops","The addition operator <code>+</code>.",null,null],[16,"Output","","The resulting type after applying the <code>+</code> operator.",19,null],[10,"add","","Performs the <code>+</code> operation.",19,[[]]],[8,"Div","","The division operator <code>/</code>.",null,null],[16,"Output","","The resulting type after applying the <code>/</code> operator.",20,null],[10,"div","","Performs the <code>/</code> operation.",20,[[]]],[8,"Mul","","The multiplication operator <code>*</code>.",null,null],[16,"Output","","The resulting type after applying the <code>*</code> operator.",21,null],[10,"mul","","Performs the <code>*</code> operation.",21,[[]]],[8,"Neg","","The unary negation operator <code>-</code>.",null,null],[16,"Output","","The resulting type after applying the <code>-</code> operator.",22,null],[10,"neg","","Performs the unary <code>-</code> operation.",22,[[]]],[8,"Rem","","The remainder operator <code>%</code>.",null,null],[16,"Output","","The resulting type after applying the <code>%</code> operator.",23,null],[10,"rem","","Performs the <code>%</code> operation.",23,[[]]],[8,"Sub","","The subtraction operator <code>-</code>.",null,null],[16,"Output","","The resulting type after applying the <code>-</code> operator.",24,null],[10,"sub","","Performs the <code>-</code> operation.",24,[[]]],[8,"AddAssign","","The addition assignment operator <code>+=</code>.",null,null],[10,"add_assign","","Performs the <code>+=</code> operation.",25,[[]]],[8,"DivAssign","","The division assignment operator <code>/=</code>.",null,null],[10,"div_assign","","Performs the <code>/=</code> operation.",26,[[]]],[8,"MulAssign","","The multiplication assignment operator <code>*=</code>.",null,null],[10,"mul_assign","","Performs the <code>*=</code> operation.",27,[[]]],[8,"RemAssign","","The remainder assignment operator <code>%=</code>.",null,null],[10,"rem_assign","","Performs the <code>%=</code> operation.",28,[[]]],[8,"SubAssign","","The subtraction assignment operator <code>-=</code>.",null,null],[10,"sub_assign","","Performs the <code>-=</code> operation.",29,[[]]],[8,"BitAnd","","The bitwise AND operator <code>&</code>.",null,null],[16,"Output","","The resulting type after applying the <code>&</code> operator.",30,null],[10,"bitand","","Performs the <code>&</code> operation.",30,[[]]],[8,"BitOr","","The bitwise OR operator <code>|</code>.",null,null],[16,"Output","","The resulting type after applying the <code>|</code> operator.",31,null],[10,"bitor","","Performs the <code>|</code> operation.",31,[[]]],[8,"BitXor","","The bitwise XOR operator <code>^</code>.",null,null],[16,"Output","","The resulting type after applying the <code>^</code> operator.",32,null],[10,"bitxor","","Performs the <code>^</code> operation.",32,[[]]],[8,"Not","","The unary logical negation operator <code>!</code>.",null,null],[16,"Output","","The resulting type after applying the <code>!</code> operator.",33,null],[10,"not","","Performs the unary <code>!</code> operation.",33,[[]]],[8,"Shl","","The left shift operator <code><<</code>. Note that because this trait …",null,null],[16,"Output","","The resulting type after applying the <code><<</code> operator.",34,null],[10,"shl","","Performs the <code><<</code> operation.",34,[[]]],[8,"Shr","","The right shift operator <code>>></code>. Note that because this trait …",null,null],[16,"Output","","The resulting type after applying the <code>>></code> operator.",35,null],[10,"shr","","Performs the <code>>></code> operation.",35,[[]]],[8,"BitAndAssign","","The bitwise AND assignment operator <code>&=</code>.",null,null],[10,"bitand_assign","","Performs the <code>&=</code> operation.",36,[[]]],[8,"BitOrAssign","","The bitwise OR assignment operator <code>|=</code>.",null,null],[10,"bitor_assign","","Performs the <code>|=</code> operation.",37,[[]]],[8,"BitXorAssign","","The bitwise XOR assignment operator <code>^=</code>.",null,null],[10,"bitxor_assign","","Performs the <code>^=</code> operation.",38,[[]]],[8,"ShlAssign","","The left shift assignment operator <code><<=</code>.",null,null],[10,"shl_assign","","Performs the <code><<=</code> operation.",39,[[]]],[8,"ShrAssign","","The right shift assignment operator <code>>>=</code>.",null,null],[10,"shr_assign","","Performs the <code>>>=</code> operation.",40,[[]]],[8,"Deref","","Used for immutable dereferencing operations, like <code>*v</code>.",null,null],[16,"Target","","The resulting type after dereferencing.",41,null],[10,"deref","","Dereferences the value.",41,[[]]],[8,"DerefMut","","Used for mutable dereferencing operations, like in <code>*v = 1;</code>…",null,null],[10,"deref_mut","","Mutably dereferences the value.",42,[[]]],[8,"Drop","","Custom code within the destructor.",null,null],[10,"drop","","Executes the destructor for this type.",43,[[]]],[8,"Fn","","The version of the call operator that takes an immutable …",null,null],[10,"call","","Performs the call operation.",44,[[]]],[8,"FnMut","","The version of the call operator that takes a mutable …",null,null],[10,"call_mut","","Performs the call operation.",45,[[]]],[8,"FnOnce","","The version of the call operator that takes a by-value …",null,null],[16,"Output","","The returned type after the call operator is used.",46,null],[10,"call_once","","Performs the call operation.",46,[[]]],[8,"Index","","Used for indexing operations (<code>container[index]</code>) in …",null,null],[16,"Output","","The returned type after indexing.",47,null],[10,"index","","Performs the indexing (<code>container[index]</code>) operation.",47,[[]]],[8,"IndexMut","","Used for indexing operations (<code>container[index]</code>) in …",null,null],[10,"index_mut","","Performs the mutable indexing (<code>container[index]</code>) …",48,[[]]],[3,"Range","","A (half-open) range bounded inclusively below and …",null,null],[12,"start","","The lower bound of the range (inclusive).",49,null],[12,"end","","The upper bound of the range (exclusive).",49,null],[3,"RangeFrom","","A range only bounded inclusively below (<code>start..</code>).",null,null],[12,"start","","The lower bound of the range (inclusive).",50,null],[3,"RangeFull","","An unbounded range (<code>..</code>).",null,null],[3,"RangeTo","","A range only bounded exclusively above (<code>..end</code>).",null,null],[12,"end","","The upper bound of the range (exclusive).",51,null],[4,"Bound","","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",52,null],[13,"Excluded","","An exclusive bound.",52,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in …",52,null],[8,"RangeBounds","","<code>RangeBounds</code> is implemented by Rust\'s built-in range …",null,null],[10,"start_bound","","Start index bound.",53,[[],["bound",4]]],[10,"end_bound","","End index bound.",53,[[],["bound",4]]],[11,"assert_len","","Performs bounds-checking of this range.",53,[[["usize",15]],[["usize",15],["range",3]]]],[11,"contains","","Returns <code>true</code> if <code>item</code> is contained in the range.",53,[[],["bool",15]]],[3,"RangeInclusive","","A range bounded inclusively below and above (<code>start..=end</code>).",null,null],[3,"RangeToInclusive","","A range only bounded inclusively above (<code>..=end</code>).",null,null],[12,"end","","The upper bound of the range (inclusive)",54,null],[8,"Try","","A trait for customizing the behavior of the <code>?</code> operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",55,null],[16,"Error","","The type of this value when viewed as failed.",55,null],[10,"into_result","","Applies the \\\"?\\\" operator. A return of <code>Ok(t)</code> means that the…",55,[[],["result",4]]],[10,"from_error","","Wrap an error value to construct the composite result. …",55,[[]]],[10,"from_ok","","Wrap an OK value to construct the composite result. For …",55,[[]]],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",56,null],[16,"Return","","The type of value this generator returns.",56,null],[10,"resume","","Resumes the execution of this generator.",56,[[["pin",3]],["generatorstate",4]]],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",57,null],[13,"Complete","","The generator completed with a return value.",57,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper …",null,null],[8,"DispatchFromDyn","","This is used for object safety, to check that a method\'s …",null,null],[4,"ControlFlow","","Used to make try_fold closures more like normal loops",null,null],[13,"Continue","","Continue in the loop, using the given value for the next …",58,null],[13,"Break","","Exit the loop, yielding the given value",58,null],[0,"any","core","This module implements the <code>Any</code> trait, which enables …",null,null],[8,"Any","core::any","A trait to emulate dynamic typing.",null,null],[10,"type_id","","Gets the <code>TypeId</code> of <code>self</code>.",59,[[],["typeid",3]]],[11,"is","","Returns <code>true</code> if the boxed type is the same as <code>T</code>.",59,[[],["bool",15]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of …",59,[[],["option",4]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it …",59,[[],["option",4]]],[11,"is","","Forwards to the method defined on the type <code>Any</code>.",59,[[],["bool",15]]],[11,"downcast_ref","","Forwards to the method defined on the type <code>Any</code>.",59,[[],["option",4]]],[11,"downcast_mut","","Forwards to the method defined on the type <code>Any</code>.",59,[[],["option",4]]],[11,"is","","Forwards to the method defined on the type <code>Any</code>.",59,[[],["bool",15]]],[11,"downcast_ref","","Forwards to the method defined on the type <code>Any</code>.",59,[[],["option",4]]],[11,"downcast_mut","","Forwards to the method defined on the type <code>Any</code>.",59,[[],["option",4]]],[3,"TypeId","","A <code>TypeId</code> represents a globally unique identifier for a …",null,null],[11,"of","","Returns the <code>TypeId</code> of the type this generic function has …",60,[[],["typeid",3]]],[5,"type_name","","Returns the name of a type as a string slice.",null,[[],["str",15]]],[5,"type_name_of_val","","Returns the name of the type of the pointed-to value as a …",null,[[],["str",15]]],[0,"array","core","Implementations of things like <code>Eq</code> for fixed-length arrays …",null,null],[3,"IntoIter","core::array","A by-value array iterator.",null,null],[5,"from_ref","","Converts a reference to <code>T</code> into a reference to an array of …",null,[[]]],[5,"from_mut","","Converts a mutable reference to <code>T</code> into a mutable …",null,[[]]],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",61,[[]]],[10,"as_mut_slice","","Converts the array to mutable slice",61,[[]]],[3,"TryFromSliceError","","The error type returned when a conversion from a slice to …",null,null],[0,"ascii","core","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a …",null,[[["u8",15]],["escapedefault",3]]],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[11,"new","","Creates a new <code>Cell</code> containing the given value.",62,[[],["cell",3]]],[11,"set","","Sets the contained value.",62,[[]]],[11,"swap","","Swaps the values of two Cells. Difference with …",62,[[]]],[11,"replace","","Replaces the contained value, and returns it.",62,[[]]],[11,"into_inner","","Unwraps the value.",62,[[]]],[11,"get","","Returns a copy of the contained value.",62,[[]]],[11,"update","","Updates the contained value using a function and returns …",62,[[]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",62,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",62,[[]]],[11,"from_mut","","Returns a <code>&Cell<T></code> from a <code>&mut T</code>",62,[[],["cell",3]]],[11,"take","","Takes the value of the cell, leaving <code>Default::default()</code> …",62,[[]]],[11,"as_slice_of_cells","","Returns a <code>&[Cell<T>]</code> from a <code>&Cell<[T]></code>",62,[[]]],[3,"RefCell","","A mutable memory location with dynamically checked borrow …",null,null],[3,"BorrowError","","An error returned by [<code>RefCell::try_borrow</code>].",null,null],[3,"BorrowMutError","","An error returned by [<code>RefCell::try_borrow_mut</code>].",null,null],[11,"new","","Creates a new <code>RefCell</code> containing <code>value</code>.",63,[[],["refcell",3]]],[11,"into_inner","","Consumes the <code>RefCell</code>, returning the wrapped value.",63,[[]]],[11,"replace","","Replaces the wrapped value with a new one, returning the …",63,[[]]],[11,"replace_with","","Replaces the wrapped value with a new one computed from <code>f</code>…",63,[[["fnonce",8]]]],[11,"swap","","Swaps the wrapped value of <code>self</code> with the wrapped value of …",63,[[]]],[11,"borrow","","Immutably borrows the wrapped value.",63,[[],["ref",3]]],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error …",63,[[],[["ref",3],["borrowerror",3],["result",4]]]],[11,"borrow_mut","","Mutably borrows the wrapped value.",63,[[],["refmut",3]]],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if …",63,[[],[["result",4],["borrowmuterror",3],["refmut",3]]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",63,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",63,[[]]],[11,"undo_leak","","Undo the effect of leaked guards on the borrow state of …",63,[[]]],[11,"try_borrow_unguarded","","Immutably borrows the wrapped value, returning an error …",63,[[],[["result",4],["borrowerror",3]]]],[11,"take","","Takes the wrapped value, leaving <code>Default::default()</code> in …",63,[[]]],[3,"Ref","","Wraps a borrowed reference to a value in a <code>RefCell</code> box. A …",null,null],[11,"clone","","Copies a <code>Ref</code>.",64,[[["ref",3]],["ref",3]]],[11,"map","","Makes a new <code>Ref</code> for a component of the borrowed data.",64,[[["ref",3]],[["sized",8],["ref",3]]]],[11,"filter_map","","Makes a new <code>Ref</code> for an optional component of the borrowed …",64,[[["ref",3]],[["result",4],["ref",3]]]],[11,"map_split","","Splits a <code>Ref</code> into multiple <code>Ref</code>s for different components …",64,[[["ref",3]]]],[11,"leak","","Convert into a reference to the underlying data.",64,[[["ref",3]]]],[3,"RefMut","","A wrapper type for a mutably borrowed value from a …",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[11,"new","","Constructs a new instance of <code>UnsafeCell</code> which will wrap …",65,[[],["unsafecell",3]]],[11,"into_inner","","Unwraps the value.",65,[[]]],[11,"get","","Gets a mutable pointer to the wrapped value.",65,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",65,[[]]],[11,"raw_get","","Gets a mutable pointer to the wrapped value. The …",65,[[]]],[0,"char","core","A character type.",null,null],[5,"from_u32_unchecked","core::char","Converts a <code>u32</code> to a <code>char</code>, ignoring validity.",null,[[["u32",15]],["char",15]]],[3,"CharTryFromError","","The error type returned when a conversion from u32 to …",null,null],[3,"ParseCharError","","An error which can be returned when parsing a char.",null,null],[5,"from_digit","","Converts a digit in the given radix to a <code>char</code>.",null,[[["u32",15]],[["option",4],["char",15]]]],[5,"from_u32","","Converts a <code>u32</code> to a <code>char</code>.",null,[[["u32",15]],[["option",4],["char",15]]]],[5,"decode_utf16","","Creates an iterator over the UTF-16 encoded code points …",null,[[["intoiterator",8]],["decodeutf16",3]]],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from …",null,null],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code …",null,null],[17,"MAX","","The highest valid code point a <code>char</code> can have.",null,null],[17,"REPLACEMENT_CHARACTER","","<code>U+FFFD REPLACEMENT CHARACTER</code> (�) is used in Unicode to …",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode …",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a <code>char</code>.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a <code>char</code>.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent …",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent …",null,null],[0,"ffi","core","Utilities related to foreign function interface (FFI) …",null,null],[4,"c_void","core::ffi","Equivalent to C\'s <code>void</code> type when used as a pointer.",null,null],[3,"VaListImpl","","Basic implementation of a <code>va_list</code>.",null,null],[3,"VaList","","A wrapper for a <code>va_list</code>",null,null],[11,"as_va_list","","Convert a <code>VaListImpl</code> into a <code>VaList</code> that is …",66,[[],["valist",3]]],[11,"arg","","Advance to the next arg.",66,[[],["vaargsafe",8]]],[11,"with_copy","","Copies the <code>va_list</code> at the current location.",66,[[]]],[0,"iter","core","Composable external iteration.",null,null],[8,"Iterator","core::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",67,null],[10,"next","","Advances the iterator and returns the next value.",67,[[],["option",4]]],[11,"size_hint","","Returns the bounds on the remaining length of the …",67,[[]]],[11,"count","","Consumes the iterator, counting the number of iterations …",67,[[],["usize",15]]],[11,"last","","Consumes the iterator, returning the last element.",67,[[],["option",4]]],[11,"advance_by","","Advances the iterator by <code>n</code> elements.",67,[[["usize",15]],[["usize",15],["result",4]]]],[11,"nth","","Returns the <code>n</code>th element of the iterator.",67,[[["usize",15]],["option",4]]],[11,"step_by","","Creates an iterator starting at the same point, but …",67,[[["usize",15]],["stepby",3]]],[11,"chain","","Takes two iterators and creates a new iterator over both …",67,[[],["chain",3]]],[11,"zip","","\'Zips up\' two iterators into a single iterator of pairs.",67,[[],["zip",3]]],[11,"intersperse","","Creates a new iterator which places a copy of <code>separator</code> …",67,[[],["intersperse",3]]],[11,"intersperse_with","","Creates a new iterator which places an item generated by …",67,[[],["interspersewith",3]]],[11,"map","","Takes a closure and creates an iterator which calls that …",67,[[],["map",3]]],[11,"for_each","","Calls a closure on each element of an iterator.",67,[[]]],[11,"filter","","Creates an iterator which uses a closure to determine if …",67,[[],["filter",3]]],[11,"filter_map","","Creates an iterator that both filters and maps.",67,[[],["filtermap",3]]],[11,"enumerate","","Creates an iterator which gives the current iteration …",67,[[],["enumerate",3]]],[11,"peekable","","Creates an iterator which can use <code>peek</code> to look at the …",67,[[],["peekable",3]]],[11,"skip_while","","Creates an iterator that <code>skip</code>s elements based on a …",67,[[],["skipwhile",3]]],[11,"take_while","","Creates an iterator that yields elements based on a …",67,[[],["takewhile",3]]],[11,"map_while","","Creates an iterator that both yields elements based on a …",67,[[],["mapwhile",3]]],[11,"skip","","Creates an iterator that skips the first <code>n</code> elements.",67,[[["usize",15]],["skip",3]]],[11,"take","","Creates an iterator that yields its first <code>n</code> elements.",67,[[["usize",15]],["take",3]]],[11,"scan","","An iterator adaptor similar to <code>fold</code> that holds internal …",67,[[],["scan",3]]],[11,"flat_map","","Creates an iterator that works like map, but flattens …",67,[[],["flatmap",3]]],[11,"flatten","","Creates an iterator that flattens nested structure.",67,[[],["flatten",3]]],[11,"fuse","","Creates an iterator which ends after the first [<code>None</code>].",67,[[],["fuse",3]]],[11,"inspect","","Does something with each element of an iterator, passing …",67,[[],["inspect",3]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",67,[[]]],[11,"collect","","Transforms an iterator into a collection.",67,[[],["fromiterator",8]]],[11,"partition","","Consumes an iterator, creating two collections from it.",67,[[]]],[11,"partition_in_place","","Reorders the elements of this iterator <em>in-place</em> according …",67,[[],["usize",15]]],[11,"is_partitioned","","Checks if the elements of this iterator are partitioned …",67,[[],["bool",15]]],[11,"try_fold","","An iterator method that applies a function as long as it …",67,[[]]],[11,"try_for_each","","An iterator method that applies a fallible function to …",67,[[]]],[11,"fold","","Folds every element into an accumulator by applying an …",67,[[]]],[11,"reduce","","Reduces the elements to a single one, by repeatedly …",67,[[],["option",4]]],[11,"all","","Tests if every element of the iterator matches a …",67,[[],["bool",15]]],[11,"any","","Tests if any element of the iterator matches a predicate.",67,[[],["bool",15]]],[11,"find","","Searches for an element of an iterator that satisfies a …",67,[[],["option",4]]],[11,"find_map","","Applies function to the elements of iterator and returns …",67,[[],["option",4]]],[11,"try_find","","Applies function to the elements of iterator and returns …",67,[[],[["option",4],["result",4]]]],[11,"position","","Searches for an element in an iterator, returning its …",67,[[],[["usize",15],["option",4]]]],[11,"rposition","","Searches for an element in an iterator from the right, …",67,[[],[["usize",15],["option",4]]]],[11,"max","","Returns the maximum element of an iterator.",67,[[],["option",4]]],[11,"min","","Returns the minimum element of an iterator.",67,[[],["option",4]]],[11,"max_by_key","","Returns the element that gives the maximum value from the …",67,[[],["option",4]]],[11,"max_by","","Returns the element that gives the maximum value with …",67,[[],["option",4]]],[11,"min_by_key","","Returns the element that gives the minimum value from the …",67,[[],["option",4]]],[11,"min_by","","Returns the element that gives the minimum value with …",67,[[],["option",4]]],[11,"rev","","Reverses an iterator\'s direction.",67,[[],["rev",3]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",67,[[]]],[11,"copied","","Creates an iterator which copies all of its elements.",67,[[],["copied",3]]],[11,"cloned","","Creates an iterator which <code>clone</code>s all of its elements.",67,[[],["cloned",3]]],[11,"cycle","","Repeats an iterator endlessly.",67,[[],["cycle",3]]],[11,"sum","","Sums the elements of an iterator.",67,[[]]],[11,"product","","Iterates over the entire iterator, multiplying all the …",67,[[]]],[11,"cmp","","Lexicographically compares the elements of this [<code>Iterator</code>]…",67,[[],["ordering",4]]],[11,"cmp_by","","Lexicographically compares the elements of this [<code>Iterator</code>]…",67,[[],["ordering",4]]],[11,"partial_cmp","","Lexicographically compares the elements of this [<code>Iterator</code>]…",67,[[],[["ordering",4],["option",4]]]],[11,"partial_cmp_by","","Lexicographically compares the elements of this [<code>Iterator</code>]…",67,[[],[["ordering",4],["option",4]]]],[11,"eq","","Determines if the elements of this [<code>Iterator</code>] are equal …",67,[[],["bool",15]]],[11,"eq_by","","Determines if the elements of this [<code>Iterator</code>] are equal …",67,[[],["bool",15]]],[11,"ne","","Determines if the elements of this [<code>Iterator</code>] are unequal …",67,[[],["bool",15]]],[11,"lt","","Determines if the elements of this [<code>Iterator</code>] are …",67,[[],["bool",15]]],[11,"le","","Determines if the elements of this [<code>Iterator</code>] are …",67,[[],["bool",15]]],[11,"gt","","Determines if the elements of this [<code>Iterator</code>] are …",67,[[],["bool",15]]],[11,"ge","","Determines if the elements of this [<code>Iterator</code>] are …",67,[[],["bool",15]]],[11,"is_sorted","","Checks if the elements of this iterator are sorted.",67,[[],["bool",15]]],[11,"is_sorted_by","","Checks if the elements of this iterator are sorted using …",67,[[],["bool",15]]],[11,"is_sorted_by_key","","Checks if the elements of this iterator are sorted using …",67,[[],["bool",15]]],[8,"Step","","Objects that have a notion of <em>successor</em> and <em>predecessor</em> …",null,null],[10,"steps_between","","Returns the number of <em>successor</em> steps required to get …",68,[[],[["usize",15],["option",4]]]],[10,"forward_checked","","Returns the value that would be obtained by taking the <em>…",68,[[["usize",15]],["option",4]]],[11,"forward","","Returns the value that would be obtained by taking the <em>…",68,[[["usize",15]]]],[11,"forward_unchecked","","Returns the value that would be obtained by taking the <em>…",68,[[["usize",15]]]],[10,"backward_checked","","Returns the value that would be obtained by taking the <em>…",68,[[["usize",15]],["option",4]]],[11,"backward","","Returns the value that would be obtained by taking the <em>…",68,[[["usize",15]]]],[11,"backward_unchecked","","Returns the value that would be obtained by taking the <em>…",68,[[["usize",15]]]],[5,"empty","","Creates an iterator that yields nothing.",null,[[],["empty",3]]],[3,"Empty","","An iterator that yields nothing.",null,null],[5,"from_fn","","Creates a new iterator where each iteration calls the …",null,[[],["fromfn",3]]],[3,"FromFn","","An iterator where each iteration calls the provided …",null,null],[5,"once","","Creates an iterator that yields an element exactly once.",null,[[],["once",3]]],[3,"Once","","An iterator that yields an element exactly once.",null,null],[5,"once_with","","Creates an iterator that lazily generates a value exactly …",null,[[["fnonce",8]],[["oncewith",3],["fnonce",8]]]],[3,"OnceWith","","An iterator that yields a single element of type <code>A</code> by …",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single …",null,[[["clone",8]],[["clone",8],["repeat",3]]]],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[5,"repeat_with","","Creates a new iterator that repeats elements of type <code>A</code> …",null,[[["fnmut",8]],[["repeatwith",3],["fnmut",8]]]],[3,"RepeatWith","","An iterator that repeats elements of type <code>A</code> endlessly by …",null,null],[5,"successors","","Creates a new iterator where each successive item is …",null,[[["option",4]],["successors",3]]],[3,"Successors","","An new iterator where each successive item is computed …",null,null],[8,"FusedIterator","","An iterator that always continues to yield <code>None</code> when …",null,null],[8,"InPlaceIterable","","An iterator that when yielding an item will have taken at …",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using …",null,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the …",69,[[],["option",4]]],[11,"advance_back_by","","Advances the iterator from the back by <code>n</code> elements.",69,[[["usize",15]],[["usize",15],["result",4]]]],[11,"nth_back","","Returns the <code>n</code>th element from the end of the iterator.",69,[[["usize",15]],["option",4]]],[11,"try_rfold","","This is the reverse version of [<code>Iterator::try_fold()</code>]: it …",69,[[]]],[11,"rfold","","An iterator method that reduces the iterator\'s elements …",69,[[]]],[11,"rfind","","Searches for an element of an iterator from the back that …",69,[[],["option",4]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact length of the iterator.",70,[[],["usize",15]]],[11,"is_empty","","Returns <code>true</code> if the iterator is empty.",70,[[],["bool",15]]],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",71,[[["intoiterator",8]]]],[11,"extend_one","","Extends a collection with exactly one element.",71,[[]]],[11,"extend_reserve","","Reserves capacity in a collection for the given number of …",71,[[["usize",15]]]],[8,"FromIterator","","Conversion from an [<code>Iterator</code>].",null,null],[10,"from_iter","","Creates a value from an iterator.",72,[[["intoiterator",8]]]],[8,"IntoIterator","","Conversion into an [<code>Iterator</code>].",null,null],[16,"Item","","The type of the elements being iterated over.",73,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",73,null],[10,"into_iter","","Creates an iterator from a value.",73,[[]]],[8,"Product","","Trait to represent types that can be created by …",null,null],[10,"product","","Method which takes an iterator and generates <code>Self</code> from …",74,[[["iterator",8]]]],[8,"Sum","","Trait to represent types that can be created by summing …",null,null],[10,"sum","","Method which takes an iterator and generates <code>Self</code> from …",75,[[["iterator",8]]]],[3,"Cloned","","An iterator that clones the elements of an underlying …",null,null],[3,"Copied","","An iterator that copies the elements of an underlying …",null,null],[3,"Flatten","","An iterator that flattens one level of nesting in an …",null,null],[3,"MapWhile","","An iterator that only accepts elements while <code>predicate</code> …",null,null],[8,"SourceIter","","This trait provides transitive access to source-stage in …",null,null],[16,"Source","","A source stage in an iterator pipeline.",76,null],[10,"as_inner","","Retrieve the source of an iterator pipeline.",76,[[]]],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that links two iterators together, in a chain.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element …",null,null],[3,"Filter","","An iterator that filters the elements of <code>iter</code> with …",null,null],[3,"FilterMap","","An iterator that uses <code>f</code> to both filter and map elements …",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and …",null,null],[3,"Fuse","","An iterator that yields <code>None</code> forever after the underlying …",null,null],[3,"Inspect","","An iterator that calls a function with a reference to …",null,null],[3,"Map","","An iterator that maps the values of <code>iter</code> with <code>f</code>.",null,null],[3,"Peekable","","An iterator with a <code>peek()</code> that returns an optional …",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Scan","","An iterator to maintain state while iterating another …",null,null],[3,"Skip","","An iterator that skips over <code>n</code> elements of <code>iter</code>.",null,null],[3,"SkipWhile","","An iterator that rejects elements while <code>predicate</code> returns …",null,null],[3,"Take","","An iterator that only iterates over the first <code>n</code> …",null,null],[3,"TakeWhile","","An iterator that only accepts elements while <code>predicate</code> …",null,null],[3,"Zip","","An iterator that iterates two other iterators …",null,null],[3,"Intersperse","","An iterator adapter that places a separator between all …",null,null],[3,"IntersperseWith","","An iterator adapter that places a separator between all …",null,null],[0,"lazy","core","Lazy values and one-time initialization of static data.",null,null],[3,"OnceCell","core::lazy","A cell which can be written to only once.",null,null],[11,"new","","Creates a new empty cell.",77,[[],["oncecell",3]]],[11,"get","","Gets the reference to the underlying value.",77,[[],["option",4]]],[11,"get_mut","","Gets the mutable reference to the underlying value.",77,[[],["option",4]]],[11,"set","","Sets the contents of the cell to <code>value</code>.",77,[[],["result",4]]],[11,"get_or_init","","Gets the contents of the cell, initializing it with <code>f</code> if …",77,[[]]],[11,"get_or_try_init","","Gets the contents of the cell, initializing it with <code>f</code> if …",77,[[],["result",4]]],[11,"into_inner","","Consumes the cell, returning the wrapped value.",77,[[],["option",4]]],[11,"take","","Takes the value out of this <code>OnceCell</code>, moving it back to …",77,[[],["option",4]]],[3,"Lazy","","A value which is initialized on the first access.",null,null],[11,"new","","Creates a new lazy value with the given initializing …",78,[[],["lazy",3]]],[11,"force","","Forces the evaluation of this lazy value and returns a …",78,[[["lazy",3]]]],[0,"option","core","Optional values.",null,null],[4,"Option","core::option","The <code>Option</code> type. See the module level documentation for …",null,null],[13,"None","","No value",79,null],[13,"Some","","Some value <code>T</code>",79,null],[11,"is_some","","Returns <code>true</code> if the option is a [<code>Some</code>] value.",79,[[],["bool",15]]],[11,"is_none","","Returns <code>true</code> if the option is a [<code>None</code>] value.",79,[[],["bool",15]]],[11,"contains","","Returns <code>true</code> if the option is a [<code>Some</code>] value containing …",79,[[],["bool",15]]],[11,"as_ref","","Converts from <code>&Option<T></code> to <code>Option<&T></code>.",79,[[],["option",4]]],[11,"as_mut","","Converts from <code>&mut Option<T></code> to <code>Option<&mut T></code>.",79,[[],["option",4]]],[11,"as_pin_ref","","Converts from [<code>Pin</code>]<code><&Option<T>></code> to <code>Option<</code>[<code>Pin</code>]<code><&T>></code>.",79,[[["pin",3]],[["option",4],["pin",3]]]],[11,"as_pin_mut","","Converts from [<code>Pin</code>]<code><&mut Option<T>></code> to <code>Option<</code>[<code>Pin</code>]…",79,[[["pin",3]],[["option",4],["pin",3]]]],[11,"expect","","Returns the contained [<code>Some</code>] value, consuming the <code>self</code> …",79,[[["str",15]]]],[11,"unwrap","","Returns the contained [<code>Some</code>] value, consuming the <code>self</code> …",79,[[]]],[11,"unwrap_or","","Returns the contained [<code>Some</code>] value or a provided default.",79,[[]]],[11,"unwrap_or_else","","Returns the contained [<code>Some</code>] value or computes it from a …",79,[[["fnonce",8]]]],[11,"unwrap_unchecked","","Returns the contained [<code>Some</code>] value, consuming the <code>self</code> …",79,[[]]],[11,"map","","Maps an <code>Option<T></code> to <code>Option<U></code> by applying a function to …",79,[[["fnonce",8]],["option",4]]],[11,"map_or","","Applies a function to the contained value (if any), or …",79,[[["fnonce",8]]]],[11,"map_or_else","","Applies a function to the contained value (if any), or …",79,[[["fnonce",8],["fnonce",8]]]],[11,"ok_or","","Transforms the <code>Option<T></code> into a [<code>Result<T, E></code>], mapping …",79,[[],["result",4]]],[11,"ok_or_else","","Transforms the <code>Option<T></code> into a [<code>Result<T, E></code>], mapping …",79,[[["fnonce",8]],["result",4]]],[11,"insert","","Inserts <code>value</code> into the option then returns a mutable …",79,[[]]],[11,"iter","","Returns an iterator over the possibly contained value.",79,[[],["iter",3]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained …",79,[[],["itermut",3]]],[11,"and","","Returns [<code>None</code>] if the option is [<code>None</code>], otherwise returns …",79,[[["option",4]],["option",4]]],[11,"and_then","","Returns [<code>None</code>] if the option is [<code>None</code>], otherwise calls <code>f</code> …",79,[[["fnonce",8]],["option",4]]],[11,"filter","","Returns [<code>None</code>] if the option is [<code>None</code>], otherwise calls …",79,[[["fnonce",8]]]],[11,"or","","Returns the option if it contains a value, otherwise …",79,[[["option",4]],["option",4]]],[11,"or_else","","Returns the option if it contains a value, otherwise …",79,[[["fnonce",8]],["option",4]]],[11,"xor","","Returns [<code>Some</code>] if exactly one of <code>self</code>, <code>optb</code> is [<code>Some</code>], …",79,[[["option",4]],["option",4]]],[11,"get_or_insert","","Inserts <code>value</code> into the option if it is [<code>None</code>], then …",79,[[]]],[11,"get_or_insert_with","","Inserts a value computed from <code>f</code> into the option if it is […",79,[[["fnonce",8]]]],[11,"take","","Takes the value out of the option, leaving a [<code>None</code>] in …",79,[[],["option",4]]],[11,"replace","","Replaces the actual value in the option by the value …",79,[[],["option",4]]],[11,"zip","","Zips <code>self</code> with another <code>Option</code>.",79,[[["option",4]],["option",4]]],[11,"zip_with","","Zips <code>self</code> and another <code>Option</code> with function <code>f</code>.",79,[[["option",4]],["option",4]]],[11,"copied","","Maps an <code>Option<&T></code> to an <code>Option<T></code> by copying the …",79,[[],["option",4]]],[11,"copied","","Maps an <code>Option<&mut T></code> to an <code>Option<T></code> by copying the …",79,[[],["option",4]]],[11,"cloned","","Maps an <code>Option<&T></code> to an <code>Option<T></code> by cloning the …",79,[[],["option",4]]],[11,"cloned","","Maps an <code>Option<&mut T></code> to an <code>Option<T></code> by cloning the …",79,[[],["option",4]]],[11,"expect_none","","Consumes <code>self</code> while expecting [<code>None</code>] and returning …",79,[[["str",15]]]],[11,"unwrap_none","","Consumes <code>self</code> while expecting [<code>None</code>] and returning …",79,[[]]],[11,"unwrap_or_default","","Returns the contained [<code>Some</code>] value or a default",79,[[]]],[11,"as_deref","","Converts from <code>Option<T></code> (or <code>&Option<T></code>) to …",79,[[],["option",4]]],[11,"as_deref_mut","","Converts from <code>Option<T></code> (or <code>&mut Option<T></code>) to …",79,[[],["option",4]]],[11,"transpose","","Transposes an <code>Option</code> of a [<code>Result</code>] into a [<code>Result</code>] of an …",79,[[],[["result",4],["option",4]]]],[3,"Iter","","An iterator over a reference to the [<code>Some</code>] variant of an […",null,null],[3,"IterMut","","An iterator over a mutable reference to the [<code>Some</code>] …",null,null],[3,"IntoIter","","An iterator over the value in [<code>Some</code>] variant of an [<code>Option</code>…",null,null],[3,"NoneError","","The error type that results from applying the try …",null,null],[11,"flatten","","Converts from <code>Option<Option<T>></code> to <code>Option<T></code>",79,[[],["option",4]]],[0,"panic","core","Panic support in the standard library.",null,null],[3,"PanicInfo","core::panic","A struct providing information about a panic.",null,null],[11,"payload","","Returns the payload associated with the panic.",80,[[],["any",8]]],[11,"message","","If the <code>panic!</code> macro from the <code>core</code> crate (not from <code>std</code>) …",80,[[],[["option",4],["arguments",3]]]],[11,"location","","Returns information about the location from which the …",80,[[],[["option",4],["location",3]]]],[3,"Location","","A struct containing information about the location of a …",null,null],[11,"caller","","Returns the source location of the caller of this …",81,[[],["location",3]]],[11,"file","","Returns the name of the source file from which the panic …",81,[[],["str",15]]],[11,"line","","Returns the line number from which the panic originated.",81,[[],["u32",15]]],[11,"column","","Returns the column from which the panic originated.",81,[[],["u32",15]]],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","The underlying implementation of libcore\'s <code>panic!</code> macro …",null,[[["str",15]]]],[5,"panic_str","","",null,[[["str",15]]]],[5,"panic_fmt","","The underlying implementation of libcore\'s <code>panic!</code> macro …",null,[[["arguments",3]]]],[0,"pin","core","Types that pin data to its location in memory.",null,null],[3,"Pin","core::pin","A pinned pointer.",null,null],[11,"new","","Construct a new <code>Pin<P></code> around a pointer to some data of a …",82,[[],["pin",3]]],[11,"into_inner","","Unwraps this <code>Pin<P></code> returning the underlying pointer.",82,[[["pin",3]]]],[11,"new_unchecked","","Construct a new <code>Pin<P></code> around a reference to some data of …",82,[[],["pin",3]]],[11,"as_ref","","Gets a pinned shared reference from this pinned pointer.",82,[[],["pin",3]]],[11,"into_inner_unchecked","","Unwraps this <code>Pin<P></code> returning the underlying pointer.",82,[[["pin",3]]]],[11,"as_mut","","Gets a pinned mutable reference from this pinned pointer.",82,[[],["pin",3]]],[11,"set","","Assigns a new value to the memory behind the pinned …",82,[[]]],[11,"map_unchecked","","Constructs a new pin by mapping the interior value.",82,[[],["pin",3]]],[11,"get_ref","","Gets a shared reference out of a pin.",82,[[]]],[11,"into_ref","","Converts this <code>Pin<&mut T></code> into a <code>Pin<&T></code> with the same …",82,[[],["pin",3]]],[11,"get_mut","","Gets a mutable reference to the data inside of this <code>Pin</code>.",82,[[]]],[11,"get_unchecked_mut","","Gets a mutable reference to the data inside of this <code>Pin</code>.",82,[[]]],[11,"map_unchecked_mut","","Construct a new pin by mapping the interior value.",82,[[],["pin",3]]],[11,"static_ref","","Get a pinned reference from a static reference.",82,[[],["pin",3]]],[11,"static_mut","","Get a pinned mutable reference from a static mutable …",82,[[],["pin",3]]],[0,"raw","core","Contains struct definitions for the layout of compiler …",null,null],[3,"TraitObject","core::raw","The representation of a trait object like <code>&dyn SomeTrait</code>.",null,null],[12,"data","","",83,null],[12,"vtable","","",83,null],[0,"result","core","Error handling with the <code>Result</code> type.",null,null],[4,"Result","core::result","<code>Result</code> is a type that represents either success ([<code>Ok</code>]) or …",null,null],[13,"Ok","","Contains the success value",84,null],[13,"Err","","Contains the error value",84,null],[11,"is_ok","","Returns <code>true</code> if the result is [<code>Ok</code>].",84,[[],["bool",15]]],[11,"is_err","","Returns <code>true</code> if the result is [<code>Err</code>].",84,[[],["bool",15]]],[11,"contains","","Returns <code>true</code> if the result is an [<code>Ok</code>] value containing …",84,[[],["bool",15]]],[11,"contains_err","","Returns <code>true</code> if the result is an [<code>Err</code>] value containing …",84,[[],["bool",15]]],[11,"ok","","Converts from <code>Result<T, E></code> to [<code>Option<T></code>].",84,[[],["option",4]]],[11,"err","","Converts from <code>Result<T, E></code> to [<code>Option<E></code>].",84,[[],["option",4]]],[11,"as_ref","","Converts from <code>&Result<T, E></code> to <code>Result<&T, &E></code>.",84,[[],["result",4]]],[11,"as_mut","","Converts from <code>&mut Result<T, E></code> to <code>Result<&mut T, &mut E></code>.",84,[[],["result",4]]],[11,"map","","Maps a <code>Result<T, E></code> to <code>Result<U, E></code> by applying a …",84,[[["fnonce",8]],["result",4]]],[11,"map_or","","Applies a function to the contained value (if [<code>Ok</code>]), or …",84,[[["fnonce",8]]]],[11,"map_or_else","","Maps a <code>Result<T, E></code> to <code>U</code> by applying a function to a …",84,[[["fnonce",8],["fnonce",8]]]],[11,"map_err","","Maps a <code>Result<T, E></code> to <code>Result<T, F></code> by applying a …",84,[[["fnonce",8]],["result",4]]],[11,"iter","","Returns an iterator over the possibly contained value.",84,[[],["iter",3]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained …",84,[[],["itermut",3]]],[11,"and","","Returns <code>res</code> if the result is [<code>Ok</code>], otherwise returns the […",84,[[["result",4]],["result",4]]],[11,"and_then","","Calls <code>op</code> if the result is [<code>Ok</code>], otherwise returns the [<code>Err</code>…",84,[[["fnonce",8]],["result",4]]],[11,"or","","Returns <code>res</code> if the result is [<code>Err</code>], otherwise returns the …",84,[[["result",4]],["result",4]]],[11,"or_else","","Calls <code>op</code> if the result is [<code>Err</code>], otherwise returns the [<code>Ok</code>…",84,[[["fnonce",8]],["result",4]]],[11,"unwrap_or","","Returns the contained [<code>Ok</code>] value or a provided default.",84,[[]]],[11,"unwrap_or_else","","Returns the contained [<code>Ok</code>] value or computes it from a …",84,[[["fnonce",8]]]],[11,"unwrap_unchecked","","Returns the contained [<code>Ok</code>] value, consuming the <code>self</code> …",84,[[]]],[11,"unwrap_err_unchecked","","Returns the contained [<code>Err</code>] value, consuming the <code>self</code> …",84,[[]]],[11,"copied","","Maps a <code>Result<&T, E></code> to a <code>Result<T, E></code> by copying the …",84,[[],["result",4]]],[11,"copied","","Maps a <code>Result<&mut T, E></code> to a <code>Result<T, E></code> by copying the …",84,[[],["result",4]]],[11,"cloned","","Maps a <code>Result<&T, E></code> to a <code>Result<T, E></code> by cloning the …",84,[[],["result",4]]],[11,"cloned","","Maps a <code>Result<&mut T, E></code> to a <code>Result<T, E></code> by cloning the …",84,[[],["result",4]]],[11,"expect","","Returns the contained [<code>Ok</code>] value, consuming the <code>self</code> …",84,[[["str",15]]]],[11,"unwrap","","Returns the contained [<code>Ok</code>] value, consuming the <code>self</code> …",84,[[]]],[11,"expect_err","","Returns the contained [<code>Err</code>] value, consuming the <code>self</code> …",84,[[["str",15]]]],[11,"unwrap_err","","Returns the contained [<code>Err</code>] value, consuming the <code>self</code> …",84,[[]]],[11,"unwrap_or_default","","Returns the contained [<code>Ok</code>] value or a default",84,[[]]],[11,"into_ok","","Returns the contained [<code>Ok</code>] value, but never panics.",84,[[]]],[11,"as_deref","","Converts from <code>Result<T, E></code> (or <code>&Result<T, E></code>) to …",84,[[],["result",4]]],[11,"as_deref_mut","","Converts from <code>Result<T, E></code> (or <code>&mut Result<T, E></code>) to …",84,[[],["result",4]]],[11,"transpose","","Transposes a <code>Result</code> of an <code>Option</code> into an <code>Option</code> of a …",84,[[],[["option",4],["result",4]]]],[11,"flatten","","Converts from <code>Result<Result<T, E>, E></code> to <code>Result<T, E></code>",84,[[],["result",4]]],[3,"Iter","","An iterator over a reference to the [<code>Ok</code>] variant of a […",null,null],[3,"IterMut","","An iterator over a mutable reference to the [<code>Ok</code>] variant …",null,null],[3,"IntoIter","","An iterator over the value in a [<code>Ok</code>] variant of a [<code>Result</code>]…",null,null],[0,"stream","core","Composable asynchronous iteration.",null,null],[8,"Stream","core::stream","An interface for dealing with asynchronous iterators.",null,null],[16,"Item","","The type of items yielded by the stream.",85,null],[10,"poll_next","","Attempt to pull out the next value of this stream, …",85,[[["context",3],["pin",3]],[["poll",4],["option",4]]]],[11,"size_hint","","Returns the bounds on the remaining length of the stream.",85,[[]]],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between …",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",86,null],[13,"Release","","When coupled with a store, all previous operations become …",86,null],[13,"Acquire","","When coupled with a load, if the loaded value was written …",86,null],[13,"AcqRel","","Has the effects of both [<code>Acquire</code>] and [<code>Release</code>] together: …",86,null],[13,"SeqCst","","Like [<code>Acquire</code>]/[<code>Release</code>]/[<code>AcqRel</code>] (for load, store, and …",86,null],[17,"ATOMIC_BOOL_INIT","","An [<code>AtomicBool</code>] initialized to <code>false</code>.",null,null],[11,"new","","Creates a new <code>AtomicBool</code>.",87,[[["bool",15]],["atomicbool",3]]],[11,"get_mut","","Returns a mutable reference to the underlying [<code>bool</code>].",87,[[],["bool",15]]],[11,"from_mut","","Get atomic access to a <code>&mut bool</code>.",87,[[["bool",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",87,[[],["bool",15]]],[11,"load","","Loads a value from the bool.",87,[[["ordering",4]],["bool",15]]],[11,"store","","Stores a value into the bool.",87,[[["ordering",4],["bool",15]]]],[11,"swap","","Stores a value into the bool, returning the previous …",87,[[["ordering",4],["bool",15]],["bool",15]]],[11,"compare_and_swap","","Stores a value into the [<code>bool</code>] if the current value is …",87,[[["ordering",4],["bool",15]],["bool",15]]],[11,"compare_exchange","","Stores a value into the [<code>bool</code>] if the current value is …",87,[[["ordering",4],["bool",15]],[["result",4],["bool",15]]]],[11,"compare_exchange_weak","","Stores a value into the [<code>bool</code>] if the current value is …",87,[[["ordering",4],["bool",15]],[["result",4],["bool",15]]]],[11,"fetch_and","","Logical \\\"and\\\" with a boolean value.",87,[[["ordering",4],["bool",15]],["bool",15]]],[11,"fetch_nand","","Logical \\\"nand\\\" with a boolean value.",87,[[["ordering",4],["bool",15]],["bool",15]]],[11,"fetch_or","","Logical \\\"or\\\" with a boolean value.",87,[[["ordering",4],["bool",15]],["bool",15]]],[11,"fetch_xor","","Logical \\\"xor\\\" with a boolean value.",87,[[["ordering",4],["bool",15]],["bool",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying [<code>bool</code>].",87,[[]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",87,[[["ordering",4]],[["result",4],["bool",15]]]],[11,"new","","Creates a new <code>AtomicPtr</code>.",88,[[],["atomicptr",3]]],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",88,[[]]],[11,"from_mut","","Get atomic access to a pointer.",88,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",88,[[]]],[11,"load","","Loads a value from the pointer.",88,[[["ordering",4]]]],[11,"store","","Stores a value into the pointer.",88,[[["ordering",4]]]],[11,"swap","","Stores a value into the pointer, returning the previous …",88,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the pointer if the current value is …",88,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the pointer if the current value is …",88,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is …",88,[[["ordering",4]],["result",4]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",88,[[["ordering",4]],["result",4]]],[3,"AtomicI8","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",89,[[["i8",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",89,[[],["i8",15]]],[11,"from_mut","","Get atomic access to a <code>&mut i8</code>.",89,[[["i8",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",89,[[],["i8",15]]],[11,"load","","Loads a value from the atomic integer.",89,[[["ordering",4]],["i8",15]]],[11,"store","","Stores a value into the atomic integer.",89,[[["ordering",4],["i8",15]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",89,[[["ordering",4],["i8",15]],[["result",4],["i8",15]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",89,[[["ordering",4],["i8",15]],[["result",4],["i8",15]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",89,[[["ordering",4]],[["result",4],["i8",15]]]],[11,"fetch_max","","Maximum with the current value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"fetch_min","","Minimum with the current value.",89,[[["ordering",4],["i8",15]],["i8",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",89,[[]]],[3,"AtomicU8","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",90,[[["u8",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",90,[[],["u8",15]]],[11,"from_mut","","Get atomic access to a <code>&mut u8</code>.",90,[[["u8",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",90,[[],["u8",15]]],[11,"load","","Loads a value from the atomic integer.",90,[[["ordering",4]],["u8",15]]],[11,"store","","Stores a value into the atomic integer.",90,[[["u8",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",90,[[["u8",15],["ordering",4]],[["result",4],["u8",15]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",90,[[["u8",15],["ordering",4]],[["result",4],["u8",15]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",90,[[["ordering",4]],[["result",4],["u8",15]]]],[11,"fetch_max","","Maximum with the current value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"fetch_min","","Minimum with the current value.",90,[[["u8",15],["ordering",4]],["u8",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",90,[[]]],[3,"AtomicI16","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",91,[[["i16",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",91,[[],["i16",15]]],[11,"from_mut","","Get atomic access to a <code>&mut i16</code>.",91,[[["i16",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",91,[[],["i16",15]]],[11,"load","","Loads a value from the atomic integer.",91,[[["ordering",4]],["i16",15]]],[11,"store","","Stores a value into the atomic integer.",91,[[["ordering",4],["i16",15]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",91,[[["ordering",4],["i16",15]],[["result",4],["i16",15]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",91,[[["ordering",4],["i16",15]],[["result",4],["i16",15]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",91,[[["ordering",4]],[["result",4],["i16",15]]]],[11,"fetch_max","","Maximum with the current value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"fetch_min","","Minimum with the current value.",91,[[["ordering",4],["i16",15]],["i16",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",91,[[]]],[3,"AtomicU16","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",92,[[["u16",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",92,[[],["u16",15]]],[11,"from_mut","","Get atomic access to a <code>&mut u16</code>.",92,[[["u16",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",92,[[],["u16",15]]],[11,"load","","Loads a value from the atomic integer.",92,[[["ordering",4]],["u16",15]]],[11,"store","","Stores a value into the atomic integer.",92,[[["u16",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",92,[[["u16",15],["ordering",4]],[["u16",15],["result",4]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",92,[[["u16",15],["ordering",4]],[["u16",15],["result",4]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",92,[[["ordering",4]],[["u16",15],["result",4]]]],[11,"fetch_max","","Maximum with the current value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"fetch_min","","Minimum with the current value.",92,[[["u16",15],["ordering",4]],["u16",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",92,[[]]],[3,"AtomicI32","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",93,[[["i32",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",93,[[],["i32",15]]],[11,"from_mut","","Get atomic access to a <code>&mut i32</code>.",93,[[["i32",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",93,[[],["i32",15]]],[11,"load","","Loads a value from the atomic integer.",93,[[["ordering",4]],["i32",15]]],[11,"store","","Stores a value into the atomic integer.",93,[[["i32",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",93,[[["i32",15],["ordering",4]],[["i32",15],["result",4]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",93,[[["i32",15],["ordering",4]],[["i32",15],["result",4]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",93,[[["ordering",4]],[["i32",15],["result",4]]]],[11,"fetch_max","","Maximum with the current value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"fetch_min","","Minimum with the current value.",93,[[["i32",15],["ordering",4]],["i32",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",93,[[]]],[3,"AtomicU32","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",94,[[["u32",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",94,[[],["u32",15]]],[11,"from_mut","","Get atomic access to a <code>&mut u32</code>.",94,[[["u32",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",94,[[],["u32",15]]],[11,"load","","Loads a value from the atomic integer.",94,[[["ordering",4]],["u32",15]]],[11,"store","","Stores a value into the atomic integer.",94,[[["u32",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",94,[[["u32",15],["ordering",4]],[["result",4],["u32",15]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",94,[[["u32",15],["ordering",4]],[["result",4],["u32",15]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",94,[[["ordering",4]],[["result",4],["u32",15]]]],[11,"fetch_max","","Maximum with the current value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"fetch_min","","Minimum with the current value.",94,[[["u32",15],["ordering",4]],["u32",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",94,[[]]],[3,"AtomicI64","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",95,[[["i64",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",95,[[],["i64",15]]],[11,"from_mut","","Get atomic access to a <code>&mut i64</code>.",95,[[["i64",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",95,[[],["i64",15]]],[11,"load","","Loads a value from the atomic integer.",95,[[["ordering",4]],["i64",15]]],[11,"store","","Stores a value into the atomic integer.",95,[[["i64",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",95,[[["i64",15],["ordering",4]],[["result",4],["i64",15]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",95,[[["i64",15],["ordering",4]],[["result",4],["i64",15]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",95,[[["ordering",4]],[["result",4],["i64",15]]]],[11,"fetch_max","","Maximum with the current value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"fetch_min","","Minimum with the current value.",95,[[["i64",15],["ordering",4]],["i64",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",95,[[]]],[3,"AtomicU64","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",96,[[["u64",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",96,[[],["u64",15]]],[11,"from_mut","","Get atomic access to a <code>&mut u64</code>.",96,[[["u64",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",96,[[],["u64",15]]],[11,"load","","Loads a value from the atomic integer.",96,[[["ordering",4]],["u64",15]]],[11,"store","","Stores a value into the atomic integer.",96,[[["u64",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",96,[[["u64",15],["ordering",4]],[["result",4],["u64",15]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",96,[[["u64",15],["ordering",4]],[["result",4],["u64",15]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",96,[[["ordering",4]],[["result",4],["u64",15]]]],[11,"fetch_max","","Maximum with the current value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"fetch_min","","Minimum with the current value.",96,[[["u64",15],["ordering",4]],["u64",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",96,[[]]],[3,"AtomicIsize","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",97,[[["isize",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",97,[[],["isize",15]]],[11,"from_mut","","Get atomic access to a <code>&mut isize</code>.",97,[[["isize",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",97,[[],["isize",15]]],[11,"load","","Loads a value from the atomic integer.",97,[[["ordering",4]],["isize",15]]],[11,"store","","Stores a value into the atomic integer.",97,[[["ordering",4],["isize",15]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",97,[[["ordering",4],["isize",15]],[["isize",15],["result",4]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",97,[[["ordering",4],["isize",15]],[["isize",15],["result",4]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",97,[[["ordering",4]],[["isize",15],["result",4]]]],[11,"fetch_max","","Maximum with the current value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"fetch_min","","Minimum with the current value.",97,[[["ordering",4],["isize",15]],["isize",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",97,[[]]],[3,"AtomicUsize","","An integer type which can be safely shared between …",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to <code>0</code>.",null,null],[11,"new","","Creates a new atomic integer.",98,[[["usize",15]]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",98,[[],["usize",15]]],[11,"from_mut","","Get atomic access to a <code>&mut usize</code>.",98,[[["usize",15]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",98,[[],["usize",15]]],[11,"load","","Loads a value from the atomic integer.",98,[[["ordering",4]],["usize",15]]],[11,"store","","Stores a value into the atomic integer.",98,[[["usize",15],["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the …",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current …",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current …",98,[[["usize",15],["ordering",4]],[["usize",15],["result",4]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current …",98,[[["usize",15],["ordering",4]],[["usize",15],["result",4]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous …",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_update","","Fetches the value, and applies a function to it that …",98,[[["ordering",4]],[["usize",15],["result",4]]]],[11,"fetch_max","","Maximum with the current value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"fetch_min","","Minimum with the current value.",98,[[["usize",15],["ordering",4]],["usize",15]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",98,[[]]],[5,"fence","","An atomic fence.",null,[[["ordering",4]]]],[5,"compiler_fence","","A compiler memory fence.",null,[[["ordering",4]]]],[5,"spin_loop_hint","","Signals the processor that it is inside a busy-wait …",null,[[]]],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[4,"Alignment","core::fmt","Possible alignments returned by <code>Formatter::align</code>",null,null],[13,"Left","","Indication that contents should be left-aligned.",99,null],[13,"Right","","Indication that contents should be right-aligned.",99,null],[13,"Center","","Indication that contents should be center-aligned.",99,null],[3,"DebugList","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugMap","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugSet","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugStruct","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[3,"DebugTuple","","A struct to help with <code>fmt::Debug</code> implementations.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[3,"Error","","The error type which is returned from formatting a …",null,null],[8,"Write","","A trait for writing or formatting into Unicode-accepting …",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether …",100,[[["str",15]],["result",6]]],[11,"write_char","","Writes a [<code>char</code>] into this writer, returning whether the …",100,[[["char",15]],["result",6]]],[11,"write_fmt","","Glue for usage of the [<code>write!</code>] macro with implementors of …",100,[[["arguments",3]],["result",6]]],[3,"Formatter","","Configuration for formatting.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of …",null,null],[11,"as_str","","Get the formatted string, if it has no arguments to be …",101,[[],[["str",15],["option",4]]]],[8,"Debug","","<code>?</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",102,[[["formatter",3]],["result",6]]],[8,"Display","","Format trait for an empty format, <code>{}</code>.",null,null],[10,"fmt","","Formats the value using the given formatter.",103,[[["formatter",3]],["result",6]]],[8,"Octal","","<code>o</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",104,[[["formatter",3]],["result",6]]],[8,"Binary","","<code>b</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",105,[[["formatter",3]],["result",6]]],[8,"LowerHex","","<code>x</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",106,[[["formatter",3]],["result",6]]],[8,"UpperHex","","<code>X</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",107,[[["formatter",3]],["result",6]]],[8,"Pointer","","<code>p</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",108,[[["formatter",3]],["result",6]]],[8,"LowerExp","","<code>e</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",109,[[["formatter",3]],["result",6]]],[8,"UpperExp","","<code>E</code> formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",110,[[["formatter",3]],["result",6]]],[5,"write","","The <code>write</code> function takes an output stream, and an …",null,[[["arguments",3],["write",8]],["result",6]]],[11,"pad_integral","","Performs the correct padding for an integer which has …",111,[[["str",15],["bool",15]],["result",6]]],[11,"pad","","This function takes a string slice and emits it to the …",111,[[["str",15]],["result",6]]],[11,"write_str","","Writes some data to the underlying buffer contained …",111,[[["str",15]],["result",6]]],[11,"write_fmt","","Writes some formatted information into this instance.",111,[[["arguments",3]],["result",6]]],[11,"flags","","Flags for formatting",111,[[],["u32",15]]],[11,"fill","","Character used as \'fill\' whenever there is alignment.",111,[[],["char",15]]],[11,"align","","Flag indicating what form of alignment was requested.",111,[[],[["alignment",4],["option",4]]]],[11,"width","","Optionally specified integer width that the output should …",111,[[],[["usize",15],["option",4]]]],[11,"precision","","Optionally specified precision for numeric types. …",111,[[],[["usize",15],["option",4]]]],[11,"sign_plus","","Determines if the <code>+</code> flag was specified.",111,[[],["bool",15]]],[11,"sign_minus","","Determines if the <code>-</code> flag was specified.",111,[[],["bool",15]]],[11,"alternate","","Determines if the <code>#</code> flag was specified.",111,[[],["bool",15]]],[11,"sign_aware_zero_pad","","Determines if the <code>0</code> flag was specified.",111,[[],["bool",15]]],[11,"debug_struct","","Creates a [<code>DebugStruct</code>] builder designed to assist with …",111,[[["str",15]],["debugstruct",3]]],[11,"debug_tuple","","Creates a <code>DebugTuple</code> builder designed to assist with …",111,[[["str",15]],["debugtuple",3]]],[11,"debug_list","","Creates a <code>DebugList</code> builder designed to assist with …",111,[[],["debuglist",3]]],[11,"debug_set","","Creates a <code>DebugSet</code> builder designed to assist with …",111,[[],["debugset",3]]],[11,"debug_map","","Creates a <code>DebugMap</code> builder designed to assist with …",111,[[],["debugmap",3]]],[14,"Debug","","Derive macro generating an impl of the trait <code>Debug</code>.",null,null],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [<code>Hasher</code>].",112,[[]]],[11,"hash_slice","","Feeds a slice of this type into the given [<code>Hasher</code>].",112,[[]]],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",113,[[],["u64",15]]],[10,"write","","Writes some data into this <code>Hasher</code>.",113,[[]]],[11,"write_u8","","Writes a single <code>u8</code> into this hasher.",113,[[["u8",15]]]],[11,"write_u16","","Writes a single <code>u16</code> into this hasher.",113,[[["u16",15]]]],[11,"write_u32","","Writes a single <code>u32</code> into this hasher.",113,[[["u32",15]]]],[11,"write_u64","","Writes a single <code>u64</code> into this hasher.",113,[[["u64",15]]]],[11,"write_u128","","Writes a single <code>u128</code> into this hasher.",113,[[["u128",15]]]],[11,"write_usize","","Writes a single <code>usize</code> into this hasher.",113,[[["usize",15]]]],[11,"write_i8","","Writes a single <code>i8</code> into this hasher.",113,[[["i8",15]]]],[11,"write_i16","","Writes a single <code>i16</code> into this hasher.",113,[[["i16",15]]]],[11,"write_i32","","Writes a single <code>i32</code> into this hasher.",113,[[["i32",15]]]],[11,"write_i64","","Writes a single <code>i64</code> into this hasher.",113,[[["i64",15]]]],[11,"write_i128","","Writes a single <code>i128</code> into this hasher.",113,[[["i128",15]]]],[11,"write_isize","","Writes a single <code>isize</code> into this hasher.",113,[[["isize",15]]]],[8,"BuildHasher","","A trait for creating instances of [<code>Hasher</code>].",null,null],[16,"Hasher","","Type of the hasher that will be created.",114,null],[10,"build_hasher","","Creates a new hasher.",114,[[]]],[3,"BuildHasherDefault","","Used to create a default [<code>BuildHasher</code>] instance for types …",null,null],[14,"Hash","","Derive macro generating an impl of the trait <code>Hash</code>.",null,null],[0,"slice","core","Slice management and manipulation.",null,null],[0,"memchr","core::slice","Pure rust memchr implementation, taken from rust-memchr",null,null],[5,"memchr","core::slice::memchr","Returns the first index matching the byte <code>x</code> in <code>text</code>.",null,[[["u8",15]],[["usize",15],["option",4]]]],[5,"memrchr","","Returns the last index matching the byte <code>x</code> in <code>text</code>.",null,[[["u8",15]],[["usize",15],["option",4]]]],[3,"Chunks","core::slice","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"Windows","","An iterator over overlapping subslices of length <code>size</code>.",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that …",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that …",null,null],[3,"Split","","An iterator over subslices separated by elements that …",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector …",null,null],[3,"SplitN","","An iterator over subslices separated by elements that …",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that …",null,null],[3,"RSplit","","An iterator over subslices separated by elements that …",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are …",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks (…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"ArrayChunks","","An iterator over a slice in (non-overlapping) chunks (<code>N</code> …",null,null],[3,"ArrayChunksMut","","An iterator over a slice in (non-overlapping) mutable …",null,null],[3,"ArrayWindows","","A windowed iterator over a slice in overlapping chunks (<code>N</code> …",null,null],[3,"GroupBy","","An iterator over slice in (non-overlapping) chunks …",null,null],[3,"GroupByMut","","An iterator over slice in (non-overlapping) mutable …",null,null],[3,"SplitInclusive","","An iterator over subslices separated by elements that …",null,null],[3,"SplitInclusiveMut","","An iterator over the mutable subslices of the vector …",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[["usize",15]]]],[5,"from_raw_parts_mut","","Performs the same functionality as [<code>from_raw_parts</code>], …",null,[[["usize",15]]]],[5,"from_mut","","Converts a reference to T into a slice of length 1 …",null,[[]]],[5,"from_ref","","Converts a reference to T into a slice of length 1 …",null,[[]]],[5,"heapsort","","Sorts <code>v</code> using heapsort, which guarantees <em>O</em>(<em>n</em> * log(<em>n</em>)) …",null,[[]]],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",115,null],[10,"get","","Returns a shared reference to the output at this …",115,[[],["option",4]]],[10,"get_mut","","Returns a mutable reference to the output at this …",115,[[],["option",4]]],[10,"get_unchecked","","Returns a shared reference to the output at this …",115,[[]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this …",115,[[]]],[10,"index","","Returns a shared reference to the output at this …",115,[[]]],[10,"index_mut","","Returns a mutable reference to the output at this …",115,[[]]],[8,"SlicePattern","","Patterns in slices - currently, only used by <code>strip_prefix</code> …",null,null],[16,"Item","","The element type of the slice being matched on.",116,null],[10,"as_slice","","Currently, the consumers of <code>SlicePattern</code> need a slice.",116,[[]]],[0,"str","core","String manipulation.",null,null],[0,"pattern","core::str","The string Pattern API.",null,null],[8,"Pattern","core::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",117,null],[10,"into_searcher","","Constructs the associated searcher from <code>self</code> and the …",117,[[["str",15]]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the …",117,[[["str",15]],["bool",15]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the …",117,[[["str",15]],["bool",15]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the …",117,[[["str",15]],["bool",15]]],[11,"strip_prefix_of","","Removes the pattern from the front of haystack, if it …",117,[[["str",15]],[["str",15],["option",4]]]],[11,"strip_suffix_of","","Removes the pattern from the back of haystack, if it …",117,[[["str",15]],[["str",15],["option",4]]]],[4,"SearchStep","","Result of calling [<code>Searcher::next()</code>] or […",null,null],[13,"Match","","Expresses that a match of the pattern has been found at …",118,null],[13,"Reject","","Expresses that <code>haystack[a..b]</code> has been rejected as a …",118,null],[13,"Done","","Expresses that every byte of the haystack has been …",118,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",119,[[],["str",15]]],[10,"next","","Performs the next search step starting from the front.",119,[[],["searchstep",4]]],[11,"next_match","","Finds the next [<code>Match</code>][SearchStep::Match] result. See […",119,[[],["option",4]]],[11,"next_reject","","Finds the next [<code>Reject</code>][SearchStep::Reject] result. See […",119,[[],["option",4]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",120,[[],["searchstep",4]]],[11,"next_match_back","","Finds the next [<code>Match</code>][SearchStep::Match] result. See […",120,[[],["option",4]]],[11,"next_reject_back","","Finds the next [<code>Reject</code>][SearchStep::Reject] result. See […",120,[[],["option",4]]],[8,"DoubleEndedSearcher","","A marker trait to express that a [<code>ReverseSearcher</code>] can be …",null,null],[3,"CharSearcher","","Associated type for <code><char as Pattern<\'a>>::Searcher</code>.",null,null],[3,"CharSliceSearcher","","Associated type for <code><&[char] as Pattern<\'a>>::Searcher</code>.",null,null],[3,"CharPredicateSearcher","","Associated type for <code><F as Pattern<\'a>>::Searcher</code>.",null,null],[3,"StrSearcher","","Associated type for <code><&str as Pattern<\'a>>::Searcher</code>.",null,null],[0,"lossy","core::str","",null,null],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",null,null],[11,"from_str","","",121,[[["str",15]],["utf8lossy",3]]],[11,"from_bytes","","",121,[[],["utf8lossy",3]]],[11,"chunks","","",121,[[],["utf8lossychunksiter",3]]],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",null,null],[3,"Utf8LossyChunk","","",null,null],[12,"valid","","Sequence of valid chars. Can be empty between broken …",122,null],[12,"broken","","Single broken char, empty if none. Empty iff iterator …",122,null],[5,"from_utf8","core::str","Converts a slice of bytes to a string slice.",null,[[],[["str",15],["result",4],["utf8error",3]]]],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without …",null,[[],["str",15]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string …",null,[[],[["result",4],["str",15],["utf8error",3]]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without …",null,[[],["str",15]]],[3,"ParseBoolError","","An error returned when parsing a <code>bool</code> using <code>from_str</code> fails",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a …",null,null],[8,"FromStr","","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",123,null],[10,"from_str","","Parses a string <code>s</code> to return a value of this type.",123,[[["str",15]],["result",4]]],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"CharIndices","","An iterator over the <code>char</code>s of a string slice, and their …",null,null],[3,"Chars","","An iterator over the <code>char</code>s of a string slice.",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a …",null,null],[3,"LinesAny","","Created with the method <code>lines_any</code>.",null,null],[3,"RSplit","","Created with the method <code>rsplit</code>.",null,null],[3,"RSplitTerminator","","Created with the method <code>rsplit_terminator</code>.",null,null],[3,"Split","","Created with the method <code>split</code>.",null,null],[3,"SplitTerminator","","Created with the method <code>split_terminator</code>.",null,null],[3,"RSplitN","","Created with the method <code>rsplitn</code>.",null,null],[3,"SplitN","","Created with the method <code>splitn</code>.",null,null],[3,"Matches","","Created with the method <code>matches</code>.",null,null],[3,"RMatches","","Created with the method <code>rmatches</code>.",null,null],[3,"MatchIndices","","Created with the method <code>match_indices</code>.",null,null],[3,"RMatchIndices","","Created with the method <code>rmatch_indices</code>.",null,null],[3,"EncodeUtf16","","An iterator of [<code>u16</code>] over the string encoded as UTF-16.",null,null],[3,"EscapeDebug","","The return type of [<code>str::escape_debug</code>].",null,null],[3,"EscapeDefault","","The return type of [<code>str::escape_default</code>].",null,null],[3,"EscapeUnicode","","The return type of [<code>str::escape_unicode</code>].",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a …",null,null],[3,"SplitInclusive","","An iterator over the substrings of a string, terminated …",null,null],[5,"next_code_point","","Reads the next code point out of a byte iterator …",null,[[],[["option",4],["u32",15]]]],[0,"time","core","Temporal quantification.",null,null],[3,"Duration","core::time","A <code>Duration</code> type to represent a span of time, typically …",null,null],[18,"SECOND","","The duration of one second.",124,null],[18,"MILLISECOND","","The duration of one millisecond.",124,null],[18,"MICROSECOND","","The duration of one microsecond.",124,null],[18,"NANOSECOND","","The duration of one nanosecond.",124,null],[18,"ZERO","","A duration of zero time.",124,null],[18,"MAX","","The maximum duration.",124,null],[11,"new","","Creates a new <code>Duration</code> from the specified number of whole …",124,[[["u32",15],["u64",15]],["duration",3]]],[11,"from_secs","","Creates a new <code>Duration</code> from the specified number of whole …",124,[[["u64",15]],["duration",3]]],[11,"from_millis","","Creates a new <code>Duration</code> from the specified number of …",124,[[["u64",15]],["duration",3]]],[11,"from_micros","","Creates a new <code>Duration</code> from the specified number of …",124,[[["u64",15]],["duration",3]]],[11,"from_nanos","","Creates a new <code>Duration</code> from the specified number of …",124,[[["u64",15]],["duration",3]]],[11,"is_zero","","Returns true if this <code>Duration</code> spans no time.",124,[[],["bool",15]]],[11,"as_secs","","Returns the number of <em>whole</em> seconds contained by this …",124,[[],["u64",15]]],[11,"subsec_millis","","Returns the fractional part of this <code>Duration</code>, in whole …",124,[[],["u32",15]]],[11,"subsec_micros","","Returns the fractional part of this <code>Duration</code>, in whole …",124,[[],["u32",15]]],[11,"subsec_nanos","","Returns the fractional part of this <code>Duration</code>, in …",124,[[],["u32",15]]],[11,"as_millis","","Returns the total number of whole milliseconds contained …",124,[[],["u128",15]]],[11,"as_micros","","Returns the total number of whole microseconds contained …",124,[[],["u128",15]]],[11,"as_nanos","","Returns the total number of nanoseconds contained by this …",124,[[],["u128",15]]],[11,"checked_add","","Checked <code>Duration</code> addition. Computes <code>self + other</code>, …",124,[[["duration",3]],[["option",4],["duration",3]]]],[11,"saturating_add","","Saturating <code>Duration</code> addition. Computes <code>self + other</code>, …",124,[[["duration",3]],["duration",3]]],[11,"checked_sub","","Checked <code>Duration</code> subtraction. Computes <code>self - other</code>, …",124,[[["duration",3]],[["option",4],["duration",3]]]],[11,"saturating_sub","","Saturating <code>Duration</code> subtraction. Computes <code>self - other</code>, …",124,[[["duration",3]],["duration",3]]],[11,"checked_mul","","Checked <code>Duration</code> multiplication. Computes <code>self * other</code>, …",124,[[["u32",15]],[["option",4],["duration",3]]]],[11,"saturating_mul","","Saturating <code>Duration</code> multiplication. Computes <code>self * other</code>…",124,[[["u32",15]],["duration",3]]],[11,"checked_div","","Checked <code>Duration</code> division. Computes <code>self / other</code>, …",124,[[["u32",15]],[["option",4],["duration",3]]]],[11,"as_secs_f64","","Returns the number of seconds contained by this <code>Duration</code> …",124,[[],["f64",15]]],[11,"as_secs_f32","","Returns the number of seconds contained by this <code>Duration</code> …",124,[[],["f32",15]]],[11,"from_secs_f64","","Creates a new <code>Duration</code> from the specified number of …",124,[[["f64",15]],["duration",3]]],[11,"from_secs_f32","","Creates a new <code>Duration</code> from the specified number of …",124,[[["f32",15]],["duration",3]]],[11,"mul_f64","","Multiplies <code>Duration</code> by <code>f64</code>.",124,[[["f64",15]],["duration",3]]],[11,"mul_f32","","Multiplies <code>Duration</code> by <code>f32</code>.",124,[[["f32",15]],["duration",3]]],[11,"div_f64","","Divide <code>Duration</code> by <code>f64</code>.",124,[[["f64",15]],["duration",3]]],[11,"div_f32","","Divide <code>Duration</code> by <code>f32</code>.",124,[[["f32",15]],["duration",3]]],[11,"div_duration_f64","","Divide <code>Duration</code> by <code>Duration</code> and return <code>f64</code>.",124,[[["duration",3]],["f64",15]]],[11,"div_duration_f32","","Divide <code>Duration</code> by <code>Duration</code> and return <code>f32</code>.",124,[[["duration",3]],["f32",15]]],[0,"unicode","core","",null,null],[0,"conversions","core::unicode","",null,null],[5,"to_lower","core::unicode::conversions","",null,[[["char",15]]]],[5,"to_upper","","",null,[[["char",15]]]],[17,"UNICODE_VERSION","core::unicode","The version of Unicode that the Unicode parts of <code>char</code> and …",null,null],[5,"Case_Ignorable","","",null,[[["char",15]],["bool",15]]],[5,"Cased","","",null,[[["char",15]],["bool",15]]],[0,"future","core","Asynchronous values.",null,null],[8,"Future","core::future","A future represents an asynchronous computation.",null,null],[16,"Output","","The type of value produced on completion.",125,null],[10,"poll","","Attempt to resolve the future to a final value, …",125,[[["context",3],["pin",3]],["poll",4]]],[8,"IntoFuture","","Conversion into a <code>Future</code>.",null,null],[16,"Output","","The output that the future will produce on completion.",126,null],[16,"Future","","Which kind of future are we turning this into?",126,null],[10,"into_future","","Creates a future from a value.",126,[[]]],[5,"pending","","Creates a future which never resolves, representing a …",null,[[],["pending",3]]],[3,"Pending","","Creates a future which never resolves, representing a …",null,null],[5,"ready","","Creates a future that is immediately ready with a value.",null,[[],["ready",3]]],[3,"Ready","","Creates a future that is immediately ready with a value.",null,null],[5,"poll_fn","","Creates a future that wraps a function returning [<code>Poll</code>].",null,[[],["pollfn",3]]],[3,"PollFn","","A Future that wraps a function returning [<code>Poll</code>].",null,null],[0,"task","core","Types and Traits for working with asynchronous tasks.",null,null],[4,"Poll","core::task","Indicates whether a value is available or if the current …",null,null],[13,"Ready","","Represents that a value is immediately ready.",127,null],[13,"Pending","","Represents that a value is not ready yet.",127,null],[3,"Context","","The <code>Context</code> of an asynchronous task.",null,null],[3,"RawWaker","","A <code>RawWaker</code> allows the implementor of a task executor to …",null,null],[3,"RawWakerVTable","","A virtual function pointer table (vtable) that specifies …",null,null],[3,"Waker","","A <code>Waker</code> is a handle for waking up a task by notifying its …",null,null],[14,"ready","","Extracts the successful type of a <code>Poll<T></code>.",null,null],[0,"alloc","core","Memory allocation APIs",null,null],[8,"GlobalAlloc","core::alloc","A memory allocator that can be registered as the standard …",null,null],[10,"alloc","","Allocate memory as described by the given <code>layout</code>.",128,[[["layout",3]]]],[10,"dealloc","","Deallocate the block of memory at the given <code>ptr</code> pointer …",128,[[["layout",3]]]],[11,"alloc_zeroed","","Behaves like <code>alloc</code>, but also ensures that the contents …",128,[[["layout",3]]]],[11,"realloc","","Shrink or grow a block of memory to the given <code>new_size</code>. …",128,[[["usize",15],["layout",3]]]],[3,"Layout","","Layout of a block of memory.",null,null],[6,"LayoutErr","","",null,null],[3,"LayoutError","","The parameters given to <code>Layout::from_size_align</code> or some …",null,null],[3,"AllocError","","The <code>AllocError</code> error indicates an allocation failure that …",null,null],[8,"Allocator","","An implementation of <code>Allocator</code> can allocate, grow, …",null,null],[10,"allocate","","Attempts to allocate a block of memory.",129,[[["layout",3]],[["allocerror",3],["nonnull",3],["result",4]]]],[11,"allocate_zeroed","","Behaves like <code>allocate</code>, but also ensures that the returned …",129,[[["layout",3]],[["allocerror",3],["nonnull",3],["result",4]]]],[10,"deallocate","","Deallocates the memory referenced by <code>ptr</code>.",129,[[["u8",15],["layout",3],["nonnull",3]]]],[11,"grow","","Attempts to extend the memory block.",129,[[["layout",3],["u8",15],["nonnull",3]],[["allocerror",3],["nonnull",3],["result",4]]]],[11,"grow_zeroed","","Behaves like <code>grow</code>, but also ensures that the new contents …",129,[[["layout",3],["u8",15],["nonnull",3]],[["allocerror",3],["nonnull",3],["result",4]]]],[11,"shrink","","Attempts to shrink the memory block.",129,[[["layout",3],["u8",15],["nonnull",3]],[["allocerror",3],["nonnull",3],["result",4]]]],[11,"by_ref","","Creates a \\\"by reference\\\" adaptor for this instance of …",129,[[]]],[0,"primitive","core","This module reexports the primitive types to allow usage …",null,null],[0,"arch","","SIMD and vendor intrinsics module.",null,null],[0,"x86","core::arch","Platform-specific intrinsics for the <code>x86</code> platform.",null,null],[3,"__m128i","core::arch::x86","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four <code>f32</code> types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two <code>f64</code> types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight <code>f32</code> types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four <code>f64</code> types, x86-specific",null,null],[3,"__m512i","","512-bit wide integer vector type, x86-specific",null,null],[3,"__m512","","512-bit wide set of sixteen <code>f32</code> types, x86-specific",null,null],[3,"__m512d","","512-bit wide set of eight <code>f64</code> types, x86-specific",null,null],[6,"__mmask64","","The <code>__mmask64</code> type used in AVX-512 intrinsics, a 64-bit …",null,null],[6,"__mmask32","","The <code>__mmask32</code> type used in AVX-512 intrinsics, a 32-bit …",null,null],[6,"__mmask16","","The <code>__mmask16</code> type used in AVX-512 intrinsics, a 16-bit …",null,null],[6,"__mmask8","","The <code>__mmask8</code> type used in AVX-512 intrinsics, a 8-bit …",null,null],[6,"_MM_CMPINT_ENUM","","The <code>_MM_CMPINT_ENUM</code> type used to specify comparison …",null,null],[6,"_MM_MANTISSA_NORM_ENUM","","The <code>MM_MANTISSA_NORM_ENUM</code> type used to specify mantissa …",null,null],[6,"_MM_MANTISSA_SIGN_ENUM","","The <code>MM_MANTISSA_SIGN_ENUM</code> type used to specify mantissa …",null,null],[6,"_MM_PERM_ENUM","","The <code>MM_PERM_ENUM</code> type used to specify shuffle operations …",null,null],[5,"_fxsave","","Saves the <code>x87</code> FPU, <code>MMX</code> technology, <code>XMM</code>, and <code>MXCSR</code> …",null,[[]]],[5,"_fxrstor","","Restores the <code>XMM</code>, <code>MMX</code>, <code>MXCSR</code>, and <code>x87</code> FPU registers from …",null,[[]]],[5,"_bswap","","Returns an integer with the reversed byte order of x",null,[[["i32",15]],["i32",15]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp …",null,[[],["u64",15]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp …",null,[[],["u64",15]]],[3,"CpuidResult","","Result of the <code>cpuid</code> instruction.",null,null],[12,"eax","","EAX register.",130,null],[12,"ebx","","EBX register.",130,null],[12,"ecx","","ECX register.",130,null],[12,"edx","","EDX register.",130,null],[5,"__cpuid_count","","Returns the result of the <code>cpuid</code> instruction for a given …",null,[[["u32",15]],["cpuidresult",3]]],[5,"__cpuid","","See <code>__cpuid_count</code>.",null,[[["u32",15]],["cpuidresult",3]]],[5,"has_cpuid","","Does the host support the <code>cpuid</code> instruction?",null,[[],["bool",15]]],[5,"__get_cpuid_max","","Returns the highest-supported <code>leaf</code> (<code>EAX</code>) and sub-leaf (<code>ECX</code>…",null,[[["u32",15]]]],[5,"_xsave","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xrstor","","Performs a full or partial restore of the enabled …",null,[[["u64",15]]]],[17,"_XCR_XFEATURE_ENABLED_MASK","","<code>XFEATURE_ENABLED_MASK</code> for <code>XCR</code>",null,null],[5,"_xsetbv","","Copies 64-bits from <code>val</code> to the extended control register (…",null,[[["u32",15],["u64",15]]]],[5,"_xgetbv","","Reads the contents of the extended control register <code>XCR</code> …",null,[[["u32",15]],["u64",15]]],[5,"_xsaveopt","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xsavec","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xsaves","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xrstors","","Performs a full or partial restore of the enabled …",null,[[["u64",15]]]],[5,"_mm_add_ss","","Adds the first component of <code>a</code> and <code>b</code>, the other components …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_add_ps","","Adds __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ss","","Subtracts the first component of <code>b</code> from <code>a</code>, the other …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ss","","Multiplies the first component of <code>a</code> and <code>b</code>, the other …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ss","","Divides the first component of <code>b</code> by <code>a</code>, the other …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ps","","Divides __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ss","","Returns the square root of the first single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ps","","Returns the square root of packed single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ss","","Returns the approximate reciprocal of the first …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ps","","Returns the approximate reciprocal of packed …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ss","","Returns the approximate reciprocal square root of the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ps","","Returns the approximate reciprocal square root of packed …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ss","","Compares the first single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ss","","Compares the first single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ss","","Compares the lowest <code>f32</code> of both inputs for equality. The …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ss","","Compares the lowest <code>f32</code> of both inputs for less than. The …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ss","","Compares the lowest <code>f32</code> of both inputs for less than or …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ss","","Compares the lowest <code>f32</code> of both inputs for greater than. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ss","","Compares the lowest <code>f32</code> of both inputs for greater than …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ss","","Compares the lowest <code>f32</code> of both inputs for inequality. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ss","","Compares the lowest <code>f32</code> of both inputs for not-less-than. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ss","","Compares the lowest <code>f32</code> of both inputs for …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ss","","Compares the lowest <code>f32</code> of both inputs for …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ss","","Compares the lowest <code>f32</code> of both inputs for …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ss","","Checks if the lowest <code>f32</code> of both inputs are ordered. The …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ss","","Checks if the lowest <code>f32</code> of both inputs are unordered. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_comieq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comilt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comile_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comigt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comige_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comineq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomieq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomilt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomile_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomigt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomige_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomineq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtss_si32","","Converts the lowest 32 bit float in the input vector to a …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvt_ss2si","","Alias for <code>_mm_cvtss_si32</code>.",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvttss_si32","","Converts the lowest 32 bit float in the input vector to a …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtt_ss2si","","Alias for <code>_mm_cvttss_si32</code>.",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtss_f32","","Extracts the lowest 32 bit float from the input vector.",null,[[["__m128",3]],["f32",15]]],[5,"_mm_cvtsi32_ss","","Converts a 32 bit integer to a 32 bit float. The result …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvt_si2ss","","Alias for <code>_mm_cvtsi32_ss</code>.",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_set_ss","","Construct a <code>__m128</code> with the lowest element set to <code>a</code> and …",null,[[["f32",15]],["__m128",3]]],[5,"_mm_set1_ps","","Construct a <code>__m128</code> with all element set to <code>a</code>.",null,[[["f32",15]],["__m128",3]]],[5,"_mm_set_ps1","","Alias for <code>_mm_set1_ps</code>",null,[[["f32",15]],["__m128",3]]],[5,"_mm_set_ps","","Construct a <code>__m128</code> from four floating point values …",null,[[["f32",15]],["__m128",3]]],[5,"_mm_setr_ps","","Construct a <code>__m128</code> from four floating point values lowest …",null,[[["f32",15]],["__m128",3]]],[5,"_mm_setzero_ps","","Construct a <code>__m128</code> with all elements initialized to zero.",null,[[],["__m128",3]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel …",null,[[["u32",15]],["i32",15]]],[5,"_mm_shuffle_ps","","Shuffles packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_unpackhi_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_unpacklo_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movehl_ps","","Combine higher half of <code>a</code> and <code>b</code>. The highwe half of <code>b</code> …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movelh_ps","","Combine lower half of <code>a</code> and <code>b</code>. The lower half of <code>b</code> …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movemask_ps","","Returns a mask of the most significant bit of each …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_load_ss","","Construct a <code>__m128</code> with the lowest element read from <code>p</code> …",null,[[],["__m128",3]]],[5,"_mm_load1_ps","","Construct a <code>__m128</code> by duplicating the value read from <code>p</code> …",null,[[],["__m128",3]]],[5,"_mm_load_ps1","","Alias for <code>_mm_load1_ps</code>",null,[[],["__m128",3]]],[5,"_mm_load_ps","","Loads four <code>f32</code> values from <em>aligned</em> memory into a <code>__m128</code>. …",null,[[],["__m128",3]]],[5,"_mm_loadu_ps","","Loads four <code>f32</code> values from memory into a <code>__m128</code>. There …",null,[[],["__m128",3]]],[5,"_mm_loadr_ps","","Loads four <code>f32</code> values from aligned memory into a <code>__m128</code> …",null,[[],["__m128",3]]],[5,"_mm_loadu_si64","","Loads unaligned 64-bits of integer data from memory into …",null,[[],["__m128i",3]]],[5,"_mm_store_ss","","Stores the lowest 32 bit float of <code>a</code> into memory.",null,[[["__m128",3]]]],[5,"_mm_store1_ps","","Stores the lowest 32 bit float of <code>a</code> repeated four times …",null,[[["__m128",3]]]],[5,"_mm_store_ps1","","Alias for <code>_mm_store1_ps</code>",null,[[["__m128",3]]]],[5,"_mm_store_ps","","Stores four 32-bit floats into <em>aligned</em> memory.",null,[[["__m128",3]]]],[5,"_mm_storeu_ps","","Stores four 32-bit floats into memory. There are no …",null,[[["__m128",3]]]],[5,"_mm_storer_ps","","Stores four 32-bit floats into <em>aligned</em> memory in reverse …",null,[[["__m128",3]]]],[5,"_mm_move_ss","","Returns a <code>__m128</code> with the first component from <code>b</code> and the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sfence","","Performs a serializing operation on all store-to-memory …",null,[[]]],[5,"_mm_getcsr","","Gets the unsigned 32-bit value of the MXCSR control and …",null,[[],["u32",15]]],[5,"_mm_setcsr","","Sets the MXCSR register with the 32-bit unsigned integer …",null,[[["u32",15]]]],[17,"_MM_EXCEPT_INVALID","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_DENORM","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_INEXACT","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_MASK","","See <code>_MM_GET_EXCEPTION_STATE</code>",null,null],[17,"_MM_MASK_INVALID","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_DENORM","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_DIV_ZERO","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_OVERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_UNDERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_INEXACT","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_MASK","","See <code>_MM_GET_EXCEPTION_MASK</code>",null,null],[17,"_MM_ROUND_NEAREST","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_DOWN","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_UP","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_MASK","","See <code>_MM_GET_ROUNDING_MODE</code>",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See <code>_MM_GET_FLUSH_ZERO_MODE</code>",null,null],[17,"_MM_FLUSH_ZERO_ON","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See <code>_mm_setcsr</code>",null,null],[5,"_MM_GET_EXCEPTION_MASK","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_GET_EXCEPTION_STATE","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_GET_ROUNDING_MODE","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_SET_EXCEPTION_MASK","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[5,"_MM_SET_EXCEPTION_STATE","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[5,"_MM_SET_ROUNDING_MODE","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[17,"_MM_HINT_T0","","See <code>_mm_prefetch</code>.",null,null],[17,"_MM_HINT_T1","","See <code>_mm_prefetch</code>.",null,null],[17,"_MM_HINT_T2","","See <code>_mm_prefetch</code>.",null,null],[17,"_MM_HINT_NTA","","See <code>_mm_prefetch</code>.",null,null],[5,"_mm_prefetch","","Fetch the cache line that contains address <code>p</code> using the …",null,[[["i32",15]]]],[5,"_mm_undefined_ps","","Returns vector of type __m128 with undefined elements.",null,[[],["__m128",3]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in …",null,[[["__m128",3]]]],[5,"_mm_stream_ps","","Stores <code>a</code> into the memory at <code>mem_addr</code> using a non-temporal …",null,[[["__m128",3]]]],[5,"_mm_pause","","Provides a hint to the processor that the code sequence …",null,[[]]],[5,"_mm_clflush","","Invalidates and flushes the cache line that contains <code>p</code> …",null,[[]]],[5,"_mm_lfence","","Performs a serializing operation on all load-from-memory …",null,[[]]],[5,"_mm_mfence","","Performs a serializing operation on all load-from-memory …",null,[[]]],[5,"_mm_add_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi32","","Adds packed 32-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi64","","Adds packed 64-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu8","","Adds packed unsigned 8-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu16","","Adds packed unsigned 16-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu8","","Averages packed unsigned 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu16","","Averages packed unsigned 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd_epi16","","Multiplies and then horizontally add signed 16 bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epu32","","Multiplies the low unsigned 32-bit integers from each …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi8","","Subtracts packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi16","","Subtracts packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in <code>b</code> from packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in <code>b</code> from packed 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in <code>b</code> from packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in <code>b</code> from packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_si128","","Shifts <code>a</code> left by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_bslli_si128","","Shifts <code>a</code> left by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_bsrli_si128","","Shifts <code>a</code> right by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_slli_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sll_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sll_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sll_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sra_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sra_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_si128","","Shifts <code>a</code> right by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srli_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srl_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srl_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srl_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_and_si128","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_andnot_si128","","Computes the bitwise NOT of 128 bits (representing …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_or_si128","","Computes the bitwise OR of 128 bits (representing integer …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_xor_si128","","Computes the bitwise XOR of 128 bits (representing …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_pd","","Converts the lower two packed 32-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_cvtsi32_sd","","Returns <code>a</code> with its lower element replaced by <code>b</code> after …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_cvtepi32_ps","","Converts packed 32-bit integers in <code>a</code> to packed …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_cvtsi32_si128","","Returns a vector whose lowest element is <code>a</code> and all higher …",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_cvtsi128_si32","","Returns the lowest element of <code>a</code>.",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_set_epi64x","","Sets packed 64-bit integers with the supplied values, …",null,[[["i64",15]],["__m128i",3]]],[5,"_mm_set_epi32","","Sets packed 32-bit integers with the supplied values.",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_set_epi16","","Sets packed 16-bit integers with the supplied values.",null,[[["i16",15]],["__m128i",3]]],[5,"_mm_set_epi8","","Sets packed 8-bit integers with the supplied values.",null,[[["i8",15]],["__m128i",3]]],[5,"_mm_set1_epi64x","","Broadcasts 64-bit integer <code>a</code> to all elements.",null,[[["i64",15]],["__m128i",3]]],[5,"_mm_set1_epi32","","Broadcasts 32-bit integer <code>a</code> to all elements.",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_set1_epi16","","Broadcasts 16-bit integer <code>a</code> to all elements.",null,[[["i16",15]],["__m128i",3]]],[5,"_mm_set1_epi8","","Broadcasts 8-bit integer <code>a</code> to all elements.",null,[[["i8",15]],["__m128i",3]]],[5,"_mm_setr_epi32","","Sets packed 32-bit integers with the supplied values in …",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_setr_epi16","","Sets packed 16-bit integers with the supplied values in …",null,[[["i16",15]],["__m128i",3]]],[5,"_mm_setr_epi8","","Sets packed 8-bit integers with the supplied values in …",null,[[["i8",15]],["__m128i",3]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,[[],["__m128i",3]]],[5,"_mm_loadl_epi64","","Loads 64-bit integer from memory into first element of …",null,[[],["__m128i",3]]],[5,"_mm_load_si128","","Loads 128-bits of integer data from memory into a new …",null,[[],["__m128i",3]]],[5,"_mm_loadu_si128","","Loads 128-bits of integer data from memory into a new …",null,[[],["__m128i",3]]],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from <code>a</code> into …",null,[[["__m128i",3]]]],[5,"_mm_store_si128","","Stores 128-bits of integer data from <code>a</code> into memory.",null,[[["__m128i",3]]]],[5,"_mm_storeu_si128","","Stores 128-bits of integer data from <code>a</code> into memory.",null,[[["__m128i",3]]]],[5,"_mm_storel_epi64","","Stores the lower 64-bit integer <code>a</code> to a memory location.",null,[[["__m128i",3]]]],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned …",null,[[["__m128i",3]]]],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory …",null,[[["i32",15]]]],[5,"_mm_move_epi64","","Returns a vector where the low element is extracted from <code>a</code>…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_extract_epi16","","Returns the <code>imm8</code> element of <code>a</code>.",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_insert_epi16","","Returns a new vector where the <code>imm8</code> element of <code>a</code> is …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_movemask_epi8","","Returns a mask of the most significant bit of each …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_shuffle_epi32","","Shuffles 32-bit integers in <code>a</code> using the control in <code>imm8</code>.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of <code>a</code> using …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of <code>a</code> using …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_add_pd","","Adds packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_pd","","Returns a new vector with the maximum values from …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_pd","","Returns a new vector with the minimum values from …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_pd","","Returns a new vector with the square root of each of the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_and_pd","","Computes the bitwise AND of packed double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_andnot_pd","","Computes the bitwise NOT of <code>a</code> and then AND with <code>b</code>.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_or_pd","","Computes the bitwise OR of <code>a</code> and <code>b</code>.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_xor_pd","","Computes the bitwise OR of <code>a</code> and <code>b</code>.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for equality.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> to see if …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> to see if …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for not-equal.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_comieq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for equality.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comilt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for less-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comile_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comigt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for greater-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comige_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comineq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for not-equal.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomieq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for equality.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomilt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for less-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomile_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomigt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for greater-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomige_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomineq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for not-equal.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_cvtps_pd","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvtsd_si32","","Converts the lower double-precision (64-bit) …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvtsd_ss","","Converts the lower double-precision (64-bit) …",null,[[["__m128d",3],["__m128",3]],["__m128",3]]],[5,"_mm_cvtsd_f64","","Returns the lower double-precision (64-bit) …",null,[[["__m128d",3]],["f64",15]]],[5,"_mm_cvtss_sd","","Converts the lower single-precision (32-bit) …",null,[[["__m128d",3],["__m128",3]],["__m128d",3]]],[5,"_mm_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvttsd_si32","","Converts the lower double-precision (64-bit) …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_set_sd","","Copies double-precision (64-bit) floating-point element <code>a</code> …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_set1_pd","","Broadcasts double-precision (64-bit) floating-point value …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_set_pd1","","Broadcasts double-precision (64-bit) floating-point value …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_set_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_setr_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point …",null,[[],["__m128d",3]]],[5,"_mm_movemask_pd","","Returns a mask of the most significant bit of each …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_load_pd","","Loads 128-bits (composed of 2 packed double-precision …",null,[[],["__m128d",3]]],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element …",null,[[],["__m128d",3]]],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of <code>[2 x double]</code> to …",null,[[["__m128d",3]]]],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of …",null,[[["__m128d",3]]]],[5,"_mm_store_pd","","Stores 128-bits (composed of 2 packed double-precision …",null,[[["__m128d",3]]]],[5,"_mm_storeu_pd","","Stores 128-bits (composed of 2 packed double-precision …",null,[[["__m128d",3]]]],[5,"_mm_store1_pd","","Stores the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]]]],[5,"_mm_store_pd1","","Stores the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]]]],[5,"_mm_storer_pd","","Stores 2 double-precision (64-bit) floating-point …",null,[[["__m128d",3]]]],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of …",null,[[["__m128d",3]]]],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of …",null,[[["__m128d",3]]]],[5,"_mm_load1_pd","","Loads a double-precision (64-bit) floating-point element …",null,[[],["__m128d",3]]],[5,"_mm_load_pd1","","Loads a double-precision (64-bit) floating-point element …",null,[[],["__m128d",3]]],[5,"_mm_loadr_pd","","Loads 2 double-precision (64-bit) floating-point elements …",null,[[],["__m128d",3]]],[5,"_mm_loadu_pd","","Loads 128-bits (composed of 2 packed double-precision …",null,[[],["__m128d",3]]],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of <code>[2 x double]</code>…",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of <code>[2 x double]</code>…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of <code>[2 x double]</code> …",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of <code>[2 x double]</code> …",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of <code>[4 x float]</code> into …",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of <code>[4 x float]</code> into …",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit …",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_undefined_pd","","Returns vector of type __m128d with undefined elements.",null,[[],["__m128d",3]]],[5,"_mm_undefined_si128","","Returns vector of type __m128i with undefined elements.",null,[[],["__m128i",3]]],[5,"_mm_unpackhi_pd","","The resulting <code>__m128d</code> element is composed by the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_unpacklo_pd","","The resulting <code>__m128d</code> element is composed by the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_pd","","Horizontally adds adjacent pairs of double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_ps","","Horizontally adds adjacent pairs of single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hsub_ps","","Horizontally adds adjacent pairs of single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_lddqu_si128","","Loads 128-bits of integer data from unaligned memory. …",null,[[],["__m128i",3]]],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loaddup_pd","","Loads a double-precision (64-bit) floating-point element …",null,[[],["__m128d",3]]],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_abs_epi8","","Computes the absolute value of packed 8-bit signed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi16","","Computes the absolute value of each of the packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi32","","Computes the absolute value of each of the packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shuffle_epi8","","Shuffles bytes from <code>a</code> according to the content of <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in <code>a</code> and <code>b</code> into a 32-byte …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_hadd_epi16","","Horizontally adds the adjacent pairs of values contained …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadds_epi16","","Horizontally adds the adjacent pairs of values contained …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadd_epi32","","Horizontally adds the adjacent pairs of values contained …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maddubs_epi16","","Multiplies corresponding pairs of packed 8-bit unsigned …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhrs_epi16","","Multiplies packed 16-bit signed integer values, truncate …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi8","","Negates packed 8-bit integers in <code>a</code> when the corresponding …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi16","","Negates packed 16-bit integers in <code>a</code> when the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi32","","Negates packed 32-bit integers in <code>a</code> when the …",null,[[["__m128i",3]],["__m128i",3]]],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see <code>vendor::_MM_SET_ROUNDING_MODE</code>",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see …",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see …",null,null],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from <code>a</code> and <code>b</code> using <code>mask</code>",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from <code>a</code> and <code>b</code> using the mask …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_extract_ps","","Extracts a single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_extract_epi8","","Extracts an 8-bit integer from <code>a</code>, selected with <code>imm8</code>. …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_extract_epi32","","Extracts an 32-bit integer from <code>a</code> selected with <code>imm8</code>",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_insert_ps","","Select a single value in <code>a</code> to store at some position in <code>b</code>,…",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_insert_epi8","","Returns a copy of <code>a</code> with the 8-bit integer from <code>i</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_insert_epi32","","Returns a copy of <code>a</code> with the 32-bit integer from <code>i</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_max_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for equality",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in <code>a</code> to packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in <code>a</code> to packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of <code>a</code> …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in <code>a</code> to packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in <code>a</code> to packed 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in <code>a</code> to packed 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi16","","Zeroes extend packed unsigned 8-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi32","","Zeroes extend packed unsigned 8-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi64","","Zeroes extend packed unsigned 8-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi64","","Zeroes extend packed unsigned 16-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu32_epi64","","Zeroes extend packed unsigned 32-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit _…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi32","","Multiplies the packed 32-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in <code>a</code> 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters <em>(Default)</em>",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in <code>a</code>, find if it is in <code>b</code> <em>(Default)</em>",null,null],[17,"_SIDD_CMP_RANGES","","For each character in <code>a</code>, determine if …",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by <code>a</code> and <code>b</code> are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results <em>(Default)</em>",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negates results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negates results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","<strong>Index only</strong>: return the least significant bit <em>(Default)</em>",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","<strong>Index only</strong>: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","<strong>Mask only</strong>: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","<strong>Mask only</strong>: return the byte mask",null,null],[5,"_mm_cmpistrm","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_cmpistri","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistrz","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistrc","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistrs","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistro","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistra","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrm","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_cmpestri","","Compares packed strings <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrz","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrc","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrs","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestro","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestra","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_crc32_u8","","Starting with the initial value in <code>crc</code>, return the …",null,[[["u8",15],["u32",15]],["u32",15]]],[5,"_mm_crc32_u16","","Starting with the initial value in <code>crc</code>, return the …",null,[[["u32",15],["u16",15]],["u32",15]]],[5,"_mm_crc32_u32","","Starting with the initial value in <code>crc</code>, return the …",null,[[["u32",15]],["u32",15]]],[5,"_mm_cmpgt_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_add_pd","","Adds packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_add_ps","","Adds packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_and_pd","","Computes the bitwise AND of a packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_and_ps","","Computes the bitwise AND of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_or_pd","","Computes the bitwise OR packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_or_ps","","Computes the bitwise OR packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_shuffle_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_shuffle_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_andnot_pd","","Computes the bitwise NOT of packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_andnot_ps","","Computes the bitwise NOT of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_max_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_max_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_min_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_min_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_mul_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_mul_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_addsub_pd","","Alternatively adds and subtracts packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_addsub_ps","","Alternatively adds and subtracts packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sub_pd","","Subtracts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_sub_ps","","Subtracts packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_ps","","Computes the division of each of the 8 packed 32-bit …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_pd","","Computes the division of each of the 4 packed 64-bit …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_pd","","Rounds packed double-precision (64-bit) floating point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_ceil_pd","","Rounds packed double-precision (64-bit) floating point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_floor_pd","","Rounds packed double-precision (64-bit) floating point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_ps","","Rounds packed single-precision (32-bit) floating point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_ceil_ps","","Rounds packed single-precision (32-bit) floating point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_floor_ps","","Rounds packed single-precision (32-bit) floating point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_ps","","Returns the square root of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_pd","","Returns the square root of packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_pd","","Blends packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_ps","","Blends packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_blendv_pd","","Blends packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blendv_ps","","Blends packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_dp_ps","","Conditionally multiplies the packed single-precision …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_xor_pd","","Computes the bitwise XOR of packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_xor_ps","","Computes the bitwise XOR of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[5,"_mm_cmp_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm256_cmp_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm_cmp_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm256_cmp_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm_cmp_sd","","Compares the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_cmp_ss","","Compares the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm256_cvtepi32_pd","","Converts packed 32-bit integers in <code>a</code> to packed …",null,[[["__m128i",3]],["__m256d",3]]],[5,"_mm256_cvtepi32_ps","","Converts packed 32-bit integers in <code>a</code> to packed …",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m128",3]]],[5,"_mm256_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_cvtps_pd","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m256d",3]]],[5,"_mm256_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_extractf128_ps","","Extracts 128 bits (composed of 4 packed single-precision …",null,[[["i32",15],["__m256",3]],["__m128",3]]],[5,"_mm256_extractf128_pd","","Extracts 128 bits (composed of 2 packed double-precision …",null,[[["i32",15],["__m256d",3]],["__m128d",3]]],[5,"_mm256_extractf128_si256","","Extracts 128 bits (composed of integer data) from <code>a</code>, …",null,[[["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_zeroall","","Zeroes the contents of all XMM or YMM registers.",null,[[]]],[5,"_mm256_zeroupper","","Zeroes the upper 128 bits of all YMM registers; the lower …",null,[[]]],[5,"_mm256_permutevar_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm_permutevar_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["__m128i",3],["__m128",3]],["__m128",3]]],[5,"_mm256_permute_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm_permute_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm256_permutevar_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm_permutevar_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_permute_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm_permute_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm256_permute2f128_ps","","Shuffles 256 bits (composed of 8 packed single-precision …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_permute2f128_pd","","Shuffles 256 bits (composed of 4 packed double-precision …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_permute2f128_si256","","Shuffles 128-bits (composed of integer data) selected by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m256",3]]],[5,"_mm_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m128",3]]],[5,"_mm256_broadcast_sd","","Broadcasts a double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_broadcast_ps","","Broadcasts 128 bits from memory (composed of 4 packed …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_broadcast_pd","","Broadcasts 128 bits from memory (composed of 2 packed …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_insertf128_ps","","Copies <code>a</code> to result, then inserts 128 bits (composed of 4 …",null,[[["i32",15],["__m256",3],["__m128",3]],["__m256",3]]],[5,"_mm256_insertf128_pd","","Copies <code>a</code> to result, then inserts 128 bits (composed of 2 …",null,[[["__m128d",3],["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_insertf128_si256","","Copies <code>a</code> to result, then inserts 128 bits from <code>b</code> into …",null,[[["__m256i",3],["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_insert_epi8","","Copies <code>a</code> to result, and inserts the 8-bit integer <code>i</code> into …",null,[[["__m256i",3],["i32",15],["i8",15]],["__m256i",3]]],[5,"_mm256_insert_epi16","","Copies <code>a</code> to result, and inserts the 16-bit integer <code>i</code> into …",null,[[["__m256i",3],["i32",15],["i16",15]],["__m256i",3]]],[5,"_mm256_insert_epi32","","Copies <code>a</code> to result, and inserts the 32-bit integer <code>i</code> into …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_load_pd","","Loads 256-bits (composed of 4 packed double-precision …",null,[[],["__m256d",3]]],[5,"_mm256_store_pd","","Stores 256-bits (composed of 4 packed double-precision …",null,[[["__m256d",3]]]],[5,"_mm256_load_ps","","Loads 256-bits (composed of 8 packed single-precision …",null,[[],["__m256",3]]],[5,"_mm256_store_ps","","Stores 256-bits (composed of 8 packed single-precision …",null,[[["__m256",3]]]],[5,"_mm256_loadu_pd","","Loads 256-bits (composed of 4 packed double-precision …",null,[[],["__m256d",3]]],[5,"_mm256_storeu_pd","","Stores 256-bits (composed of 4 packed double-precision …",null,[[["__m256d",3]]]],[5,"_mm256_loadu_ps","","Loads 256-bits (composed of 8 packed single-precision …",null,[[],["__m256",3]]],[5,"_mm256_storeu_ps","","Stores 256-bits (composed of 8 packed single-precision …",null,[[["__m256",3]]]],[5,"_mm256_load_si256","","Loads 256-bits of integer data from memory into result. …",null,[[],["__m256i",3]]],[5,"_mm256_store_si256","","Stores 256-bits of integer data from <code>a</code> into memory. …",null,[[["__m256i",3]]]],[5,"_mm256_loadu_si256","","Loads 256-bits of integer data from memory into result. …",null,[[],["__m256i",3]]],[5,"_mm256_storeu_si256","","Stores 256-bits of integer data from <code>a</code> into memory. …",null,[[["__m256i",3]]]],[5,"_mm256_maskload_pd","","Loads packed double-precision (64-bit) floating-point …",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_maskstore_pd","","Stores packed double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__m256d",3]]]],[5,"_mm_maskload_pd","","Loads packed double-precision (64-bit) floating-point …",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_maskstore_pd","","Stores packed double-precision (64-bit) floating-point …",null,[[["__m128i",3],["__m128d",3]]]],[5,"_mm256_maskload_ps","","Loads packed single-precision (32-bit) floating-point …",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_maskstore_ps","","Stores packed single-precision (32-bit) floating-point …",null,[[["__m256i",3],["__m256",3]]]],[5,"_mm_maskload_ps","","Loads packed single-precision (32-bit) floating-point …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_maskstore_ps","","Stores packed single-precision (32-bit) floating-point …",null,[[["__m128i",3],["__m128",3]]]],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_lddqu_si256","","Loads 256-bits of integer data from unaligned memory into …",null,[[],["__m256i",3]]],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a …",null,[[["__m256i",3]]]],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of …",null,[[["__m256d",3]]]],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a …",null,[[["__m256",3]]]],[5,"_mm256_rcp_ps","","Computes the approximate reciprocal of packed …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_rsqrt_ps","","Computes the approximate reciprocal square root of packed …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpackhi_pd","","Unpacks and interleave double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpackhi_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpacklo_pd","","Unpacks and interleave double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpacklo_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_testz_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_testc_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_testnzc_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_testz_pd","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm256_testc_pd","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm256_testnzc_pd","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm_testz_pd","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_testc_pd","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_testnzc_pd","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm256_testz_ps","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256",3]],["i32",15]]],[5,"_mm256_testc_ps","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256",3]],["i32",15]]],[5,"_mm256_testnzc_ps","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256",3]],["i32",15]]],[5,"_mm_testz_ps","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_testc_ps","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_testnzc_ps","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128",3]],["i32",15]]],[5,"_mm256_movemask_pd","","Sets each bit of the returned mask based on the most …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm256_movemask_ps","","Sets each bit of the returned mask based on the most …",null,[[["__m256",3]],["i32",15]]],[5,"_mm256_setzero_pd","","Returns vector of type __m256d with all elements set to …",null,[[],["__m256d",3]]],[5,"_mm256_setzero_ps","","Returns vector of type __m256 with all elements set to …",null,[[],["__m256",3]]],[5,"_mm256_setzero_si256","","Returns vector of type __m256i with all elements set to …",null,[[],["__m256i",3]]],[5,"_mm256_set_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_set_ps","","Sets packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m256",3]]],[5,"_mm256_set_epi8","","Sets packed 8-bit integers in returned vector with the …",null,[[["i8",15]],["__m256i",3]]],[5,"_mm256_set_epi16","","Sets packed 16-bit integers in returned vector with the …",null,[[["i16",15]],["__m256i",3]]],[5,"_mm256_set_epi32","","Sets packed 32-bit integers in returned vector with the …",null,[[["i32",15]],["__m256i",3]]],[5,"_mm256_set_epi64x","","Sets packed 64-bit integers in returned vector with the …",null,[[["i64",15]],["__m256i",3]]],[5,"_mm256_setr_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_setr_ps","","Sets packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m256",3]]],[5,"_mm256_setr_epi8","","Sets packed 8-bit integers in returned vector with the …",null,[[["i8",15]],["__m256i",3]]],[5,"_mm256_setr_epi16","","Sets packed 16-bit integers in returned vector with the …",null,[[["i16",15]],["__m256i",3]]],[5,"_mm256_setr_epi32","","Sets packed 32-bit integers in returned vector with the …",null,[[["i32",15]],["__m256i",3]]],[5,"_mm256_setr_epi64x","","Sets packed 64-bit integers in returned vector with the …",null,[[["i64",15]],["__m256i",3]]],[5,"_mm256_set1_pd","","Broadcasts double-precision (64-bit) floating-point value …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_set1_ps","","Broadcasts single-precision (32-bit) floating-point value …",null,[[["f32",15]],["__m256",3]]],[5,"_mm256_set1_epi8","","Broadcasts 8-bit integer <code>a</code> to all elements of returned …",null,[[["i8",15]],["__m256i",3]]],[5,"_mm256_set1_epi16","","Broadcasts 16-bit integer <code>a</code> to all all elements of …",null,[[["i16",15]],["__m256i",3]]],[5,"_mm256_set1_epi32","","Broadcasts 32-bit integer <code>a</code> to all elements of returned …",null,[[["i32",15]],["__m256i",3]]],[5,"_mm256_set1_epi64x","","Broadcasts 64-bit integer <code>a</code> to all elements of returned …",null,[[["i64",15]],["__m256i",3]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,[[["__m256d",3]],["__m256",3]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,[[["__m256",3]],["__m256d",3]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,[[["__m256d",3]],["__m256i",3]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,[[["__m256",3]],["__m128",3]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,[[["__m256d",3]],["__m128d",3]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of <code>[8 x float]</code> …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of <code>[4 x double]</code>…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_undefined_ps","","Returns vector of type <code>__m256</code> with undefined elements.",null,[[],["__m256",3]]],[5,"_mm256_undefined_pd","","Returns vector of type <code>__m256d</code> with undefined elements.",null,[[],["__m256d",3]]],[5,"_mm256_undefined_si256","","Returns vector of type __m256i with undefined elements.",null,[[],["__m256i",3]]],[5,"_mm256_set_m128","","Sets packed __m256 returned vector with the supplied …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_set_m128d","","Sets packed __m256d returned vector with the supplied …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_set_m128i","","Sets packed __m256i returned vector with the supplied …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_setr_m128","","Sets packed __m256 returned vector with the supplied …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_setr_m128d","","Sets packed __m256d returned vector with the supplied …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_setr_m128i","","Sets packed __m256i returned vector with the supplied …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_loadu2_m128","","Loads two 128-bit values (composed of 4 packed …",null,[[],["__m256",3]]],[5,"_mm256_loadu2_m128d","","Loads two 128-bit values (composed of 2 packed …",null,[[],["__m256d",3]]],[5,"_mm256_loadu2_m128i","","Loads two 128-bit values (composed of integer data) from …",null,[[],["__m256i",3]]],[5,"_mm256_storeu2_m128","","Stores the high and low 128-bit halves (each composed of …",null,[[["__m256",3]]]],[5,"_mm256_storeu2_m128d","","Stores the high and low 128-bit halves (each composed of …",null,[[["__m256d",3]]]],[5,"_mm256_storeu2_m128i","","Stores the high and low 128-bit halves (each composed of …",null,[[["__m256i",3]]]],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of …",null,[[["__m256",3]],["f32",15]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in <code>a</code>…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi64","","Adds packed 64-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi32","","Adds packed 32-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu8","","Adds packed unsigned 8-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu16","","Adds packed unsigned 16-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_alignr_epi8","","Concatenates pairs of 16-byte blocks in <code>a</code> and <code>b</code> into a …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_and_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_andnot_si256","","Computes the bitwise NOT of 256 bits (representing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu16","","Averages packed unsigned 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu8","","Averages packed unsigned 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_blend_epi32","","Blends packed 32-bit integers from <code>a</code> and <code>b</code> using control …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_blend_epi32","","Blends packed 32-bit integers from <code>a</code> and <code>b</code> using control …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_blend_epi16","","Blends packed 16-bit integers from <code>a</code> and <code>b</code> using control …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_blendv_epi8","","Blends packed 8-bit integers from <code>a</code> and <code>b</code> using <code>mask</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastsd_pd","","Broadcasts the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_broadcastsd_pd","","Broadcasts the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_broadcastsi128_si256","","Broadcasts 128 bits of integer data from a to all 128-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastss_ps","","Broadcasts the low single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_broadcastss_ps","","Broadcasts the low single-precision (32-bit) …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in <code>a</code> …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in <code>a</code> to 64-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in <code>a</code> to 16-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in <code>a</code> …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in <code>a</code> …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_extracti128_si256","","Extracts 128 bits (of integer data) from <code>a</code> selected with …",null,[[["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_hadd_epi16","","Horizontally adds adjacent pairs of 16-bit integers in <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadd_epi32","","Horizontally adds adjacent pairs of 32-bit integers in <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadds_epi16","","Horizontally adds adjacent pairs of 16-bit integers in <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm_mask_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128",3],["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm256_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256",3]]],[5,"_mm256_mask_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["__m256",3],["i32",15]],["__m256",3]]],[5,"_mm_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128d",3],["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm256_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m256d",3]]],[5,"_mm256_mask_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256d",3],["__m128i",3],["i32",15]],["__m256d",3]]],[5,"_mm_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_mask_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm_mask_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128",3],["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm256_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m128",3]]],[5,"_mm256_mask_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128",3],["__m256i",3],["i32",15]],["__m128",3]]],[5,"_mm_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mask_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128d",3],["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm256_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256d",3]]],[5,"_mm256_mask_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256d",3],["__m256i",3],["i32",15]],["__m256d",3]]],[5,"_mm256_inserti128_si256","","Copies <code>a</code> to <code>dst</code>, then insert 128 bits (of integer data) …",null,[[["__m256i",3],["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_madd_epi16","","Multiplies packed signed 16-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maddubs_epi16","","Vertically multiplies each unsigned 8-bit integer from <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi32","","Loads packed 32-bit integers from memory pointed by …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi32","","Loads packed 32-bit integers from memory pointed by …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi64","","Loads packed 64-bit integers from memory pointed by …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi64","","Loads packed 64-bit integers from memory pointed by …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskstore_epi32","","Stores packed 32-bit integers from <code>a</code> into memory pointed …",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi32","","Stores packed 32-bit integers from <code>a</code> into memory pointed …",null,[[["__m256i",3]]]],[5,"_mm_maskstore_epi64","","Stores packed 64-bit integers from <code>a</code> into memory pointed …",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi64","","Stores packed 64-bit integers from <code>a</code> into memory pointed …",null,[[["__m256i",3]]]],[5,"_mm256_max_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_movemask_epi8","","Creates mask from the most significant bit of each 8-bit …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_mpsadbw_epu8","","Computes the sum of absolute differences (SADs) of …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mul_epi32","","Multiplies the low 32-bit integers from each packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mul_epu32","","Multiplies the low unsigned 32-bit integers from each …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in <code>a</code> and <code>b</code>…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi32","","Multiplies the packed 32-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhrs_epi16","","Multiplies packed 16-bit integers in <code>a</code> and <code>b</code>, producing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_or_si256","","Computes the bitwise OR of 256 bits (representing integer …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from <code>a</code> according to the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from <code>a</code> using control mask <code>imm8</code>.",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_permute2x128_si256","","Shuffles 128-bits of integer data selected by <code>imm8</code> from <code>a</code> …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_permute4x64_pd","","Shuffles 64-bit floating-point elements in <code>a</code> across lanes …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_permutevar8x32_ps","","Shuffles eight 32-bit foating-point elements in <code>a</code> across …",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm256_sad_epu8","","Computes the absolute differences of packed unsigned …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi8","","Shuffles bytes from <code>a</code> according to the content of <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi32","","Shuffles 32-bit integers in 128-bit lanes of <code>a</code> using the …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of 128-bit …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of 128-bit …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_sign_epi16","","Negates packed 16-bit integers in <code>a</code> when the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi32","","Negates packed 32-bit integers in <code>a</code> when the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi8","","Negates packed 8-bit integers in <code>a</code> when the corresponding …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_sll_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_sll_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_slli_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_slli_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_slli_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_slli_si256","","Shifts 128-bit lanes in <code>a</code> left by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_bslli_epi128","","Shifts 128-bit lanes in <code>a</code> left by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_sllv_epi32","","Shifts packed 32-bit integers in <code>a</code> left by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi32","","Shifts packed 32-bit integers in <code>a</code> left by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_sllv_epi64","","Shifts packed 64-bit integers in <code>a</code> left by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi64","","Shifts packed 64-bit integers in <code>a</code> left by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sra_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_sra_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srai_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srai_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_srav_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srav_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_si256","","Shifts 128-bit lanes in <code>a</code> right by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_bsrli_epi128","","Shifts 128-bit lanes in <code>a</code> right by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srl_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srl_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srl_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srli_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srli_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srli_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_srlv_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srlv_epi64","","Shifts packed 64-bit integers in <code>a</code> right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi64","","Shifts packed 64-bit integers in <code>a</code> right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in <code>b</code> from packed 32-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in <code>b</code> from packed 64-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in <code>b</code> from packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in <code>b</code> from packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_xor_si256","","Computes the bitwise XOR of 256 bits (representing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_extract_epi8","","Extracts an 8-bit integer from <code>a</code>, selected with <code>imm8</code>. …",null,[[["__m256i",3],["i32",15]],["i32",15]]],[5,"_mm256_extract_epi16","","Extracts a 16-bit integer from <code>a</code>, selected with <code>imm8</code>. …",null,[[["__m256i",3],["i32",15]],["i32",15]]],[5,"_mm256_extract_epi32","","Extracts a 32-bit integer from <code>a</code>, selected with <code>imm8</code>.",null,[[["__m256i",3],["i32",15]],["i32",15]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of …",null,[[["__m256d",3]],["f64",15]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of <code>[8 x i32]</code>…",null,[[["__m256i",3]],["i32",15]]],[5,"_mm_fmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmadd_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmadd_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmaddsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmaddsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmaddsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmaddsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmsub_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmsubadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsubadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsubadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsubadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmadd_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fnmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmsub_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmsub_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,[[["u32",15]],["u32",15]]],[5,"_popcnt32","","Counts the bits that are set.",null,[[["i32",15]],["i32",15]]],[5,"_bextr_u32","","Extracts bits in range [<code>start</code>, <code>start</code> + <code>length</code>) from <code>a</code> into…",null,[[["u32",15]],["u32",15]]],[5,"_bextr2_u32","","Extracts bits of <code>a</code> specified by <code>control</code> into the least …",null,[[["u32",15]],["u32",15]]],[5,"_andn_u32","","Bitwise logical <code>AND</code> of inverted <code>a</code> with <code>b</code>.",null,[[["u32",15]],["u32",15]]],[5,"_blsi_u32","","Extracts lowest set isolated bit.",null,[[["u32",15]],["u32",15]]],[5,"_blsmsk_u32","","Gets mask up to lowest set bit.",null,[[["u32",15]],["u32",15]]],[5,"_blsr_u32","","Resets the lowest set bit of <code>x</code>.",null,[[["u32",15]],["u32",15]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,[[["u32",15]],["u32",15]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,[[["u32",15]],["i32",15]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,[[["u32",15],["u32",15]],["u32",15]]],[5,"_bzhi_u32","","Zeroes higher bits of <code>a</code> >= <code>index</code>.",null,[[["u32",15]],["u32",15]]],[5,"_pdep_u32","","Scatter contiguous low order bits of <code>a</code> to the result at …",null,[[["u32",15]],["u32",15]]],[5,"_pext_u32","","Gathers the bits of <code>x</code> specified by the <code>mask</code> into the …",null,[[["u32",15]],["u32",15]]],[5,"_mm_extract_si64","","Extracts the bit range specified by <code>y</code> from the lower 64 …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_insert_si64","","Inserts the <code>[length:0]</code> bits of <code>y</code> into <code>x</code> at <code>index</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_stream_sd","","Non-temporal store of <code>a.0</code> into <code>p</code>.",null,[[["__m128d",3]]]],[5,"_mm_stream_ss","","Non-temporal store of <code>a.0</code> into <code>p</code>.",null,[[["__m128",3]]]],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of <code>x</code>.",null,[[["u32",15]],["u32",15]]],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of <code>x</code>.",null,[[["u64",15]],["u64",15]]],[5,"_blci_u32","","Sets all bits of <code>x</code> to 1 except for the least significant …",null,[[["u32",15]],["u32",15]]],[5,"_blci_u64","","Sets all bits of <code>x</code> to 1 except for the least significant …",null,[[["u64",15]],["u64",15]]],[5,"_blcic_u32","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u32",15]],["u32",15]]],[5,"_blcic_u64","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u64",15]],["u64",15]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u32",15]],["u32",15]]],[5,"_blcmsk_u64","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u64",15]],["u64",15]]],[5,"_blcs_u32","","Sets the least significant zero bit of <code>x</code>.",null,[[["u32",15]],["u32",15]]],[5,"_blcs_u64","","Sets the least significant zero bit of <code>x</code>.",null,[[["u64",15]],["u64",15]]],[5,"_blsfill_u32","","Sets all bits of <code>x</code> below the least significant one.",null,[[["u32",15]],["u32",15]]],[5,"_blsfill_u64","","Sets all bits of <code>x</code> below the least significant one.",null,[[["u64",15]],["u64",15]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,[[["u32",15]],["u32",15]]],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,[[["u64",15]],["u64",15]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of <code>x</code> and …",null,[[["u32",15]],["u32",15]]],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of <code>x</code> and …",null,[[["u64",15]],["u64",15]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of <code>x</code> and …",null,[[["u32",15]],["u32",15]]],[5,"_tzmsk_u64","","Sets all bits below the least significant one of <code>x</code> and …",null,[[["u64",15]],["u64",15]]],[5,"_mm_clmulepi64_si128","","Performs a carry-less multiplication of two 64-bit …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_aesdec_si128","","Performs one round of an AES decryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesdeclast_si128","","Performs the last round of an AES decryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenc_si128","","Performs one round of an AES encryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenclast_si128","","Performs the last round of an AES encryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesimc_si128","","Performs the <code>InvMixColumns</code> transformation on <code>a</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store …",null,[[["u16",15]],["i32",15]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store …",null,[[["u32",15]],["i32",15]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant …",null,[[["u16",15]],["i32",15]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant …",null,[[["u32",15]],["i32",15]]],[5,"_mm_sha1msg1_epu32","","Performs an intermediate calculation for the next four …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1msg2_epu32","","Performs the final calculation for the next four SHA1 …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1rnds4_epu32","","Performs four rounds of SHA1 operation using an initial …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sha256msg1_epu32","","Performs an intermediate calculation for the next four …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256msg2_epu32","","Performs the final calculation for the next four SHA256 …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256rnds2_epu32","","Performs 2 rounds of SHA256 operation using an initial …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_addcarry_u32","","Adds unsigned 32-bit integers <code>a</code> and <code>b</code> with unsigned 8-bit …",null,[[["u8",15],["u32",15],["u32",15]],["u8",15]]],[5,"_addcarryx_u32","","Adds unsigned 32-bit integers <code>a</code> and <code>b</code> with unsigned 8-bit …",null,[[["u8",15],["u32",15],["u32",15]],["u8",15]]],[5,"_subborrow_u32","","Adds unsigned 32-bit integers <code>a</code> and <code>b</code> with unsigned 8-bit …",null,[[["u8",15],["u32",15],["u32",15]],["u8",15]]],[5,"ud2","","Generates the trap instruction <code>UD2</code>",null,[[]]],[5,"_mm512_abs_epi32","","Computes the absolute values of packed 32-bit integers in …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi32","","Computes the absolute value of packed 32-bit integers in <code>a</code>…",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi32","","Computes the absolute value of packed 32-bit integers in <code>a</code>…",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_abs_epi64","","Compute the absolute value of packed signed 64-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi64","","Compute the absolute value of packed signed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi64","","Compute the absolute value of packed signed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_abs_ps","","Finds the absolute value of each packed single-precision …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_abs_ps","","Finds the absolute value of each packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_abs_pd","","Finds the absolute value of each packed double-precision …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_abs_pd","","Finds the absolute value of each packed double-precision …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_mask_mov_epi32","","Move packed 32-bit integers from a to dst using writemask …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mov_epi32","","Move packed 32-bit integers from a into dst using …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mov_epi64","","Move packed 64-bit integers from a to dst using writemask …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mov_epi64","","Move packed 64-bit integers from a into dst using …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mov_ps","","Move packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_mov_ps","","Move packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_mov_pd","","Move packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_mov_pd","","Move packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_add_epi32","","Add packed 32-bit integers in a and b, and store the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_add_epi32","","Add packed 32-bit integers in a and b, and store the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_add_epi32","","Add packed 32-bit integers in a and b, and store the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_add_epi64","","Add packed 64-bit integers in a and b, and store the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_add_epi64","","Add packed 64-bit integers in a and b, and store the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_add_epi64","","Add packed 64-bit integers in a and b, and store the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_add_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_add_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_add_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_add_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_add_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_add_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_sub_epi32","","Subtract packed 32-bit integers in b from packed 32-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sub_epi32","","Subtract packed 32-bit integers in b from packed 32-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sub_epi32","","Subtract packed 32-bit integers in b from packed 32-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sub_epi64","","Subtract packed 64-bit integers in b from packed 64-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sub_epi64","","Subtract packed 64-bit integers in b from packed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sub_epi64","","Subtract packed 64-bit integers in b from packed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sub_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sub_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sub_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mul_epi32","","Multiply the low signed 32-bit integers from each packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mul_epi32","","Multiply the low signed 32-bit integers from each packed …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mul_epi32","","Multiply the low signed 32-bit integers from each packed …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mullo_epi32","","Multiply the packed 32-bit integers in a and b, producing …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mullo_epi32","","Multiply the packed 32-bit integers in a and b, producing …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mullo_epi32","","Multiply the packed 32-bit integers in a and b, producing …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mullox_epi64","","Multiplies elements in packed 64-bit integer vectors a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mullox_epi64","","Multiplies elements in packed 64-bit integer vectors a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mul_epu32","","Multiply the low unsigned 32-bit integers from each …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mul_epu32","","Multiply the low unsigned 32-bit integers from each …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mul_epu32","","Multiply the low unsigned 32-bit integers from each …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mul_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_mul_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_mul_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mul_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_mul_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_mul_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_div_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_div_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_div_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_max_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_max_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_max_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_max_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_max_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_max_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_max_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_max_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_max_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_max_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_min_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_min_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_min_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_min_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_min_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_min_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sqrt_ps","","Compute the square root of packed single-precision …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sqrt_ps","","Compute the square root of packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sqrt_ps","","Compute the square root of packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sqrt_pd","","Compute the square root of packed double-precision …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sqrt_pd","","Compute the square root of packed double-precision …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sqrt_pd","","Compute the square root of packed double-precision …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmaddsub_pd","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_rcp14_ps","","Compute the approximate reciprocal of packed …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_rcp14_ps","","Compute the approximate reciprocal of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_rcp14_ps","","Compute the approximate reciprocal of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_rcp14_pd","","Compute the approximate reciprocal of packed …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_rcp14_pd","","Compute the approximate reciprocal of packed …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_rcp14_pd","","Compute the approximate reciprocal of packed …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_rsqrt14_ps","","Compute the approximate reciprocal square root of packed …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_rsqrt14_ps","","Compute the approximate reciprocal square root of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_rsqrt14_ps","","Compute the approximate reciprocal square root of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_rsqrt14_pd","","Compute the approximate reciprocal square root of packed …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_rsqrt14_pd","","Compute the approximate reciprocal square root of packed …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_rsqrt14_pd","","Compute the approximate reciprocal square root of packed …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_getexp_ps","","Convert the exponent of each packed single-precision …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_getexp_ps","","Convert the exponent of each packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_getexp_ps","","Convert the exponent of each packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_getexp_pd","","Convert the exponent of each packed double-precision …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_getexp_pd","","Convert the exponent of each packed double-precision …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getexp_pd","","Convert the exponent of each packed double-precision …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_roundscale_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_roundscale_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_roundscale_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_roundscale_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_roundscale_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_roundscale_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_scalef_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_scalef_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_scalef_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_scalef_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_scalef_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_scalef_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fixupimm_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_fixupimm_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_fixupimm_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_fixupimm_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_fixupimm_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_fixupimm_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_ternarylogic_epi32","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ternarylogic_epi32","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ternarylogic_epi32","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_ternarylogic_epi64","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ternarylogic_epi64","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ternarylogic_epi64","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_getmant_ps","","Normalize the mantissas of packed single-precision …",null,[[["_mm_mantissa_sign_enum",6],["__m512",3],["_mm_mantissa_norm_enum",6]],["__m512",3]]],[5,"_mm512_mask_getmant_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6]],["__m512",3]]],[5,"_mm512_maskz_getmant_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6]],["__m512",3]]],[5,"_mm512_getmant_pd","","Normalize the mantissas of packed double-precision …",null,[[["_mm_mantissa_sign_enum",6],["__m512d",3],["_mm_mantissa_norm_enum",6]],["__m512d",3]]],[5,"_mm512_mask_getmant_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getmant_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_add_round_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_add_round_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_add_round_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_add_round_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_add_round_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_add_round_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_sub_round_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sub_round_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sub_round_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sub_round_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sub_round_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sub_round_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mul_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_mul_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_mul_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mul_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_mul_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_mul_round_pd","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_div_round_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_div_round_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_div_round_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_div_round_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_div_round_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_div_round_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_sqrt_round_ps","","Compute the square root of packed single-precision …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sqrt_round_ps","","Compute the square root of packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sqrt_round_ps","","Compute the square root of packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sqrt_round_pd","","Compute the square root of packed double-precision …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sqrt_round_pd","","Compute the square root of packed double-precision …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sqrt_round_pd","","Compute the square root of packed double-precision …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmaddsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmaddsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmaddsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmaddsub_round_pd","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_max_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_max_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_max_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_max_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_max_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_max_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_min_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_min_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_min_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_min_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_min_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_min_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_getexp_round_ps","","Convert the exponent of each packed single-precision …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_getexp_round_ps","","Convert the exponent of each packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_getexp_round_ps","","Convert the exponent of each packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_getexp_round_pd","","Convert the exponent of each packed double-precision …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_getexp_round_pd","","Convert the exponent of each packed double-precision …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getexp_round_pd","","Convert the exponent of each packed double-precision …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_roundscale_round_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_roundscale_round_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_roundscale_round_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15]],["__m512",3]]],[5,"_mm512_roundscale_round_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_roundscale_round_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_roundscale_round_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_scalef_round_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_scalef_round_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_scalef_round_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_scalef_round_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_scalef_round_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_scalef_round_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fixupimm_round_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_fixupimm_round_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_fixupimm_round_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_fixupimm_round_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_fixupimm_round_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_fixupimm_round_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_getmant_round_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512",3]]],[5,"_mm512_mask_getmant_round_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_getmant_round_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512",3]]],[5,"_mm512_getmant_round_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512d",3]]],[5,"_mm512_mask_getmant_round_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getmant_round_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m512d",3]]],[5,"_mm512_mask_cvtps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m256",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvtps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m256",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtpslo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512",3]],["__m512d",3]]],[5,"_mm512_mask_cvtpslo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m256",3]]],[5,"_mm512_mask_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m256",3],["__mmask8",6],["__m512d",3]],["__m256",3]]],[5,"_mm512_maskz_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m256",3]]],[5,"_mm512_cvtpd_pslo","","Performs an element-by-element conversion of packed …",null,[[["__m512d",3]],["__m512",3]]],[5,"_mm512_mask_cvtpd_pslo","","Performs an element-by-element conversion of packed …",null,[[["__m512",3],["__mmask8",6],["__m512d",3]],["__m512",3]]],[5,"_mm512_cvtepi8_epi32","","Sign extend packed 8-bit integers in a to packed 32-bit …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi8_epi32","","Sign extend packed 8-bit integers in a to packed 32-bit …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi8_epi32","","Sign extend packed 8-bit integers in a to packed 32-bit …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of a …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of a …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of a …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in the low 8 …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in the low 8 …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in the low 8 …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepi16_epi32","","Sign extend packed 16-bit integers in a to packed 32-bit …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi16_epi32","","Sign extend packed 16-bit integers in a to packed 32-bit …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi16_epi32","","Sign extend packed 16-bit integers in a to packed 32-bit …",null,[[["__m256i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepi16_epi64","","Sign extend packed 16-bit integers in a to packed 64-bit …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi16_epi64","","Sign extend packed 16-bit integers in a to packed 64-bit …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi16_epi64","","Sign extend packed 16-bit integers in a to packed 64-bit …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m256i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepi32_epi64","","Sign extend packed 32-bit integers in a to packed 64-bit …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi32_epi64","","Sign extend packed 32-bit integers in a to packed 64-bit …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi32_epi64","","Sign extend packed 32-bit integers in a to packed 64-bit …",null,[[["__m256i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in a to …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in a to …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in a to …",null,[[["__m256i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvtepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvtepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvtepi32_pd","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepi32_pd","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvtepi32_pd","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvtepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvtepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvtepu32_pd","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepu32_pd","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvtepu32_pd","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepi32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepi32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepu32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepu32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepi32_epi16","","Convert packed 32-bit integers in a to packed 16-bit …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtepi32_epi16","","Convert packed 32-bit integers in a to packed 16-bit …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtepi32_epi16","","Convert packed 32-bit integers in a to packed 16-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtepi32_epi8","","Convert packed 32-bit integers in a to packed 8-bit …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtepi32_epi8","","Convert packed 32-bit integers in a to packed 8-bit …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtepi32_epi8","","Convert packed 32-bit integers in a to packed 8-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtepi64_epi32","","Convert packed 64-bit integers in a to packed 32-bit …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtepi64_epi32","","Convert packed 64-bit integers in a to packed 32-bit …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtepi64_epi32","","Convert packed 64-bit integers in a to packed 32-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtepi64_epi16","","Convert packed 64-bit integers in a to packed 16-bit …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtepi64_epi16","","Convert packed 64-bit integers in a to packed 16-bit …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtepi64_epi16","","Convert packed 64-bit integers in a to packed 16-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtepi64_epi8","","Convert packed 64-bit integers in a to packed 8-bit …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtepi64_epi8","","Convert packed 64-bit integers in a to packed 8-bit …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtepi64_epi8","","Convert packed 64-bit integers in a to packed 8-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtsepi32_epi16","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtsepi32_epi16","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtsepi32_epi16","","Convert packed signed 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtsepi32_epi8","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtsepi32_epi8","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtsepi32_epi8","","Convert packed signed 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtsepi64_epi32","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtsepi64_epi32","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtsepi64_epi32","","Convert packed signed 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtsepi64_epi16","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtsepi64_epi16","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtsepi64_epi16","","Convert packed signed 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtsepi64_epi8","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtsepi64_epi8","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtsepi64_epi8","","Convert packed signed 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtusepi32_epi16","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtusepi32_epi16","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtusepi32_epi16","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtusepi32_epi8","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtusepi32_epi8","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtusepi32_epi8","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtusepi64_epi32","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtusepi64_epi32","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtusepi64_epi32","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtusepi64_epi16","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtusepi64_epi16","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtusepi64_epi16","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtusepi64_epi8","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtusepi64_epi8","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtusepi64_epi8","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvt_roundps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m512d",3]]],[5,"_mm512_mask_cvt_roundps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__m256",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvt_roundps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_maskz_cvt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_maskz_cvt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvt_roundpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256",3]]],[5,"_mm512_mask_cvt_roundpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__m256",3],["__mmask8",6]],["__m256",3]]],[5,"_mm512_maskz_cvt_roundpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256",3]]],[5,"_mm512_cvt_roundepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvt_roundepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvt_roundepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvt_roundepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvt_roundepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvt_roundepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvt_roundps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m256i",3]]],[5,"_mm512_mask_cvt_roundps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm512_maskz_cvt_roundps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm512_cvtps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m256i",3]]],[5,"_mm512_mask_cvtps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm512_maskz_cvtps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm512_cvt_roundph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["i32",15]],["__m512",3]]],[5,"_mm512_mask_cvt_roundph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m256i",3],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_cvt_roundph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["i32",15],["__mmask16",6]],["__m512",3]]],[5,"_mm512_cvtph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3]],["__m512",3]]],[5,"_mm512_mask_cvtph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_cvtph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_cvtt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvtt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_maskz_cvtt_roundpd_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvtt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvtt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvttps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvttps_epu32","","Convert packed double-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvttps_epu32","","Convert packed double-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_maskz_cvtt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_maskz_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvttpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvttpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_maskz_cvttpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_setzero_pd","","Returns vector of type <code>__m512d</code> with all elements set to …",null,[[],["__m512d",3]]],[5,"_mm512_setzero_ps","","Returns vector of type <code>__m512d</code> with all elements set to …",null,[[],["__m512",3]]],[5,"_mm512_setzero","","Return vector of type __m512 with all elements set to …",null,[[],["__m512",3]]],[5,"_mm512_setzero_si512","","Returns vector of type <code>__m512i</code> with all elements set to …",null,[[],["__m512i",3]]],[5,"_mm512_setzero_epi32","","Return vector of type __m512i with all elements set to …",null,[[],["__m512i",3]]],[5,"_mm512_setr_epi32","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_set_epi8","","Set packed 8-bit integers in dst with the supplied values.",null,[[["i8",15]],["__m512i",3]]],[5,"_mm512_set_epi16","","Set packed 16-bit integers in dst with the supplied …",null,[[["i16",15]],["__m512i",3]]],[5,"_mm512_set4_epi32","","Set packed 32-bit integers in dst with the repeated 4 …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_set4_ps","","Set packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_set4_pd","","Set packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_setr4_epi32","","Set packed 32-bit integers in dst with the repeated 4 …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_setr4_ps","","Set packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_setr4_pd","","Set packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_set_epi64","","Set packed 64-bit integers in dst with the supplied …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_setr_epi64","","Set packed 64-bit integers in dst with the supplied …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_i32gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["__m256i",3],["i32",15]],["__m512d",3]]],[5,"_mm512_mask_i32gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_i64gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_i64gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_i64gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512i",3]],["__m256",3]]],[5,"_mm512_mask_i64gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m256",3],["__mmask8",6],["__m512i",3]],["__m256",3]]],[5,"_mm512_i32gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_i32gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_i32gather_epi32","","Gather 32-bit integers from memory using 32-bit indices. …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_i32gather_epi32","","Gather 32-bit integers from memory using 32-bit indices. …",null,[[["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_i32gather_epi64","","Gather 64-bit integers from memory using 32-bit indices. …",null,[[["__m256i",3],["i32",15]],["__m512i",3]]],[5,"_mm512_mask_i32gather_epi64","","Gather 64-bit integers from memory using 32-bit indices. …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_i64gather_epi64","","Gather 64-bit integers from memory using 64-bit indices. …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_i64gather_epi64","","Gather 64-bit integers from memory using 64-bit indices. …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_i64gather_epi32","","Gather 32-bit integers from memory using 64-bit indices. …",null,[[["i32",15],["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_i64gather_epi32","","Gather 32-bit integers from memory using 64-bit indices. …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_i32scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m256i",3],["i32",15]]]],[5,"_mm512_mask_i32scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m256i",3],["__mmask8",6],["i32",15]]]],[5,"_mm512_i64scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i32scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i32scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]]]],[5,"_mm512_i64scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m256",3],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["__m256",3],["i32",15],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i32scatter_epi64","","Scatter 64-bit integers from a into memory using 32-bit …",null,[[["__m256i",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i32scatter_epi64","","Scatter 64-bit integers from a into memory using 32-bit …",null,[[["i32",15],["__m256i",3],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i64scatter_epi64","","Scatter 64-bit integers from a into memory using 64-bit …",null,[[["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_epi64","","Scatter 64-bit integers from a into memory using 64-bit …",null,[[["i32",15],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i32scatter_epi32","","Scatter 32-bit integers from a into memory using 32-bit …",null,[[["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i32scatter_epi32","","Scatter 32-bit integers from a into memory using 32-bit …",null,[[["__mmask16",6],["i32",15],["__m512i",3]]]],[5,"_mm512_i64scatter_epi32","","Scatter 32-bit integers from a into memory using 64-bit …",null,[[["__m256i",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_epi32","","Scatter 32-bit integers from a into memory using 64-bit …",null,[[["i32",15],["__m256i",3],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_mask_compress_epi32","","Contiguously store the active 32-bit integers in a (those …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_compress_epi32","","Contiguously store the active 32-bit integers in a (those …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_compress_epi64","","Contiguously store the active 64-bit integers in a (those …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_compress_epi64","","Contiguously store the active 64-bit integers in a (those …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_compress_ps","","Contiguously store the active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_compress_ps","","Contiguously store the active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_compress_pd","","Contiguously store the active double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_compress_pd","","Contiguously store the active double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_expand_epi32","","Load contiguous active 32-bit integers from a (those with …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_expand_epi32","","Load contiguous active 32-bit integers from a (those with …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_expand_epi64","","Load contiguous active 64-bit integers from a (those with …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_expand_epi64","","Load contiguous active 64-bit integers from a (those with …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_expand_ps","","Load contiguous active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_expand_ps","","Load contiguous active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_expand_pd","","Load contiguous active double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_expand_pd","","Load contiguous active double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_rol_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rol_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rol_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_ror_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ror_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ror_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rol_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rol_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rol_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_ror_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ror_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ror_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_slli_epi32","","Shift packed 32-bit integers in a left by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_slli_epi32","","Shift packed 32-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_slli_epi32","","Shift packed 32-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srli_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srli_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srli_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_slli_epi64","","Shift packed 64-bit integers in a left by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_slli_epi64","","Shift packed 64-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_slli_epi64","","Shift packed 64-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srli_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srli_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srli_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sll_epi32","","Shift packed 32-bit integers in a left by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sll_epi32","","Shift packed 32-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sll_epi32","","Shift packed 32-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srl_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srl_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srl_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sll_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sll_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sll_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srl_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srl_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srl_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sra_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sra_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sra_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sra_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sra_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sra_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srai_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srai_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srai_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srai_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srai_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srai_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srav_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srav_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srav_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srav_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srav_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srav_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rolv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rolv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rolv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rorv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rorv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rorv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rolv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rolv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rolv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rorv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rorv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rorv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sllv_epi32","","Shift packed 32-bit integers in a left by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sllv_epi32","","Shift packed 32-bit integers in a left by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sllv_epi32","","Shift packed 32-bit integers in a left by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srlv_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srlv_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srlv_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sllv_epi64","","Shift packed 64-bit integers in a left by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sllv_epi64","","Shift packed 64-bit integers in a left by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sllv_epi64","","Shift packed 64-bit integers in a left by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srlv_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srlv_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srlv_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permute_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_permute_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_permute_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_permute_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_permute_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_permute_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_permutex_epi64","","Shuffle 64-bit integers in a within 256-bit lanes using …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex_epi64","","Shuffle 64-bit integers in a within 256-bit lanes using …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex_epi64","","Shuffle 64-bit integers in a within 256-bit lanes using …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutex_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_permutex_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_permutex_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_permutevar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutevar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512i",3],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_permutexvar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutexvar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutexvar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutexvar_epi64","","Shuffle 64-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutexvar_epi64","","Shuffle 64-bit integers in a across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutexvar_epi64","","Shuffle 64-bit integers in a across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutexvar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_permutexvar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_permutexvar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_permutexvar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_permutexvar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_permutexvar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask2_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask2_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask2_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask2_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_shuffle_epi32","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["_mm_perm_enum",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_epi32","","Shuffle 32-bit integers in a within 128-bit lanes using …",null,[[["_mm_perm_enum",6],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_epi32","","Shuffle 32-bit integers in a within 128-bit lanes using …",null,[[["_mm_perm_enum",6],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_shuffle_i32x4","","Shuffle 128-bits (composed of 4 32-bit integers) selected …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_i32x4","","Shuffle 128-bits (composed of 4 32-bit integers) selected …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_i32x4","","Shuffle 128-bits (composed of 4 32-bit integers) selected …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_i64x2","","Shuffle 128-bits (composed of 2 64-bit integers) selected …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_i64x2","","Shuffle 128-bits (composed of 2 64-bit integers) selected …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_i64x2","","Shuffle 128-bits (composed of 2 64-bit integers) selected …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_f32x4","","Shuffle 128-bits (composed of 4 single-precision (32-bit) …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_shuffle_f32x4","","Shuffle 128-bits (composed of 4 single-precision (32-bit) …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_shuffle_f32x4","","Shuffle 128-bits (composed of 4 single-precision (32-bit) …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_shuffle_f64x2","","Shuffle 128-bits (composed of 2 double-precision (64-bit) …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_shuffle_f64x2","","Shuffle 128-bits (composed of 2 double-precision (64-bit) …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_shuffle_f64x2","","Shuffle 128-bits (composed of 2 double-precision (64-bit) …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_extractf32x4_ps","","Extract 128 bits (composed of 4 packed single-precision …",null,[[["i32",15],["__m512",3]],["__m128",3]]],[5,"_mm512_mask_extractf32x4_ps","","Extract 128 bits (composed of 4 packed single-precision …",null,[[["__m512",3],["__m128",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm512_maskz_extractf32x4_ps","","Extract 128 bits (composed of 4 packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask8",6]],["__m128",3]]],[5,"_mm512_extracti64x4_epi64","","Extract 256 bits (composed of 4 packed 64-bit integers) …",null,[[["i32",15],["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_extracti64x4_epi64","","Extract 256 bits (composed of 4 packed 64-bit integers) …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_extracti64x4_epi64","","Extract 256 bits (composed of 4 packed 64-bit integers) …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_extractf64x4_pd","","Extract 256 bits (composed of 4 packed double-precision …",null,[[["i32",15],["__m512d",3]],["__m256d",3]]],[5,"_mm512_mask_extractf64x4_pd","","Extract 256 bits (composed of 4 packed double-precision …",null,[[["__m512d",3],["__m256d",3],["i32",15],["__mmask8",6]],["__m256d",3]]],[5,"_mm512_maskz_extractf64x4_pd","","Extract 256 bits (composed of 4 packed double-precision …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256d",3]]],[5,"_mm512_extracti32x4_epi32","","Extract 128 bits (composed of 4 packed 32-bit integers) …",null,[[["i32",15],["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_extracti32x4_epi32","","Extract 128 bits (composed of 4 packed 32-bit integers) …",null,[[["__m128i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_extracti32x4_epi32","","Extract 128 bits (composed of 4 packed 32-bit integers) …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_inserti32x4","","Copy a to dst, then insert 128 bits (composed of 4 packed …",null,[[["__m128i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_inserti32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__mmask16",6],["__m128i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_inserti32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__mmask16",6],["__m128i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_inserti64x4","","Copy a to dst, then insert 256 bits (composed of 4 packed …",null,[[["__m256i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_inserti64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_inserti64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_insertf32x4","","Copy a to dst, then insert 128 bits (composed of 4 packed …",null,[[["i32",15],["__m512",3],["__m128",3]],["__m512",3]]],[5,"_mm512_mask_insertf32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__m512",3],["__mmask16",6],["__m128",3],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_insertf32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__m512",3],["__mmask16",6],["__m128",3],["i32",15]],["__m512",3]]],[5,"_mm512_insertf64x4","","Copy a to dst, then insert 256 bits (composed of 4 packed …",null,[[["i32",15],["__m512d",3],["__m256d",3]],["__m512d",3]]],[5,"_mm512_mask_insertf64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m512d",3],["__m256d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_insertf64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m512d",3],["__m256d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpackhi_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_unpackhi_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_unpackhi_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_unpackhi_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_unpackhi_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_unpackhi_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpacklo_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_unpacklo_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_unpacklo_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_unpacklo_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_unpacklo_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_unpacklo_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_castps128_ps512","","Cast vector of type __m128 to type __m512; the upper 384 …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_castps256_ps512","","Cast vector of type __m256 to type __m512; the upper 256 …",null,[[["__m256",3]],["__m512",3]]],[5,"_mm512_zextps128_ps512","","Cast vector of type __m128 to type __m512; the upper 384 …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_zextps256_ps512","","Cast vector of type __m256 to type __m512; the upper 256 …",null,[[["__m256",3]],["__m512",3]]],[5,"_mm512_castps512_ps128","","Cast vector of type __m512 to type __m128. This intrinsic …",null,[[["__m512",3]],["__m128",3]]],[5,"_mm512_castps512_ps256","","Cast vector of type __m512 to type __m256. This intrinsic …",null,[[["__m512",3]],["__m256",3]]],[5,"_mm512_castps_pd","","Cast vector of type __m512 to type __m512d. This …",null,[[["__m512",3]],["__m512d",3]]],[5,"_mm512_castps_si512","","Cast vector of type __m512 to type __m512i. This …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_castpd128_pd512","","Cast vector of type __m128d to type __m512d; the upper …",null,[[["__m128d",3]],["__m512d",3]]],[5,"_mm512_castpd256_pd512","","Cast vector of type __m256d to type __m512d; the upper …",null,[[["__m256d",3]],["__m512d",3]]],[5,"_mm512_zextpd128_pd512","","Cast vector of type __m128d to type __m512d; the upper …",null,[[["__m128d",3]],["__m512d",3]]],[5,"_mm512_zextpd256_pd512","","Cast vector of type __m256d to type __m512d; the upper …",null,[[["__m256d",3]],["__m512d",3]]],[5,"_mm512_castpd512_pd128","","Cast vector of type __m512d to type __m128d. This …",null,[[["__m512d",3]],["__m128d",3]]],[5,"_mm512_castpd512_pd256","","Cast vector of type __m512d to type __m256d. This …",null,[[["__m512d",3]],["__m256d",3]]],[5,"_mm512_castpd_ps","","Cast vector of type __m512d to type __m512. This …",null,[[["__m512d",3]],["__m512",3]]],[5,"_mm512_castpd_si512","","Cast vector of type __m512d to type __m512i. This …",null,[[["__m512d",3]],["__m512i",3]]],[5,"_mm512_castsi128_si512","","Cast vector of type __m128i to type __m512i; the upper …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_castsi256_si512","","Cast vector of type __m256i to type __m512i; the upper …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_zextsi128_si512","","Cast vector of type __m128i to type __m512i; the upper …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_zextsi256_si512","","Cast vector of type __m256i to type __m512i; the upper …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_castsi512_si128","","Cast vector of type __m512i to type __m128i. This …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_castsi512_si256","","Cast vector of type __m512i to type __m256i. This …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_castsi512_ps","","Cast vector of type __m512i to type __m512. This …",null,[[["__m512i",3]],["__m512",3]]],[5,"_mm512_castsi512_pd","","Cast vector of type __m512i to type __m512d. This …",null,[[["__m512i",3]],["__m512d",3]]],[5,"_mm512_broadcastd_epi32","","Broadcast the low packed 32-bit integer from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcastd_epi32","","Broadcast the low packed 32-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcastd_epi32","","Broadcast the low packed 32-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_broadcastq_epi64","","Broadcast the low packed 64-bit integer from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcastq_epi64","","Broadcast the low packed 64-bit integer from a to all …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcastq_epi64","","Broadcast the low packed 64-bit integer from a to all …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_broadcastss_ps","","Broadcast the low single-precision (32-bit) …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_mask_broadcastss_ps","","Broadcast the low single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_maskz_broadcastss_ps","","Broadcast the low single-precision (32-bit) …",null,[[["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_broadcastsd_pd","","Broadcast the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m512d",3]]],[5,"_mm512_mask_broadcastsd_pd","","Broadcast the low double-precision (64-bit) …",null,[[["__m128d",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_broadcastsd_pd","","Broadcast the low double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_broadcast_i32x4","","Broadcast the 4 packed 32-bit integers from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcast_i32x4","","Broadcast the 4 packed 32-bit integers from a to all …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcast_i32x4","","Broadcast the 4 packed 32-bit integers from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_broadcast_i64x4","","Broadcast the 4 packed 64-bit integers from a to all …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcast_i64x4","","Broadcast the 4 packed 64-bit integers from a to all …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcast_i64x4","","Broadcast the 4 packed 64-bit integers from a to all …",null,[[["__m256i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_broadcast_f32x4","","Broadcast the 4 packed single-precision (32-bit) …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_mask_broadcast_f32x4","","Broadcast the 4 packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_maskz_broadcast_f32x4","","Broadcast the 4 packed single-precision (32-bit) …",null,[[["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_broadcast_f64x4","","Broadcast the 4 packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m512d",3]]],[5,"_mm512_mask_broadcast_f64x4","","Broadcast the 4 packed double-precision (64-bit) …",null,[[["__m256d",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_broadcast_f64x4","","Broadcast the 4 packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m256d",3]],["__m512d",3]]],[5,"_mm512_mask_blend_epi32","","Blend packed 32-bit integers from a and b using control …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_blend_epi64","","Blend packed 64-bit integers from a and b using control …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_blend_ps","","Blend packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_blend_pd","","Blend packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_alignr_epi32","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_alignr_epi32","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_alignr_epi32","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_alignr_epi64","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_alignr_epi64","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_alignr_epi64","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_and_epi32","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_and_epi32","","Performs element-by-element bitwise AND between packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_and_epi32","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_and_epi64","","Compute the bitwise AND of 512 bits (composed of packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_and_epi64","","Compute the bitwise AND of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_and_epi64","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_and_si512","","Compute the bitwise AND of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_or_epi32","","Compute the bitwise OR of packed 32-bit integers in a and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_or_epi32","","Compute the bitwise OR of packed 32-bit integers in a and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_or_epi32","","Compute the bitwise OR of packed 32-bit integers in a and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_or_epi64","","Compute the bitwise OR of packed 64-bit integers in a and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_or_epi64","","Compute the bitwise OR of packed 64-bit integers in a and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_or_epi64","","Compute the bitwise OR of packed 64-bit integers in a and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_or_si512","","Compute the bitwise OR of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_xor_epi32","","Compute the bitwise XOR of packed 32-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_xor_epi32","","Compute the bitwise XOR of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_xor_epi32","","Compute the bitwise XOR of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_xor_epi64","","Compute the bitwise XOR of packed 64-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_xor_epi64","","Compute the bitwise XOR of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_xor_epi64","","Compute the bitwise XOR of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_xor_si512","","Compute the bitwise XOR of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_andnot_epi32","","Compute the bitwise NOT of packed 32-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_andnot_epi32","","Compute the bitwise NOT of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_andnot_epi32","","Compute the bitwise NOT of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_andnot_epi64","","Compute the bitwise NOT of 512 bits (composed of packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_andnot_epi64","","Compute the bitwise NOT of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_andnot_epi64","","Compute the bitwise NOT of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_andnot_si512","","Compute the bitwise NOT of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_kand_mask16","","Compute the bitwise AND of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kand","","Compute the bitwise AND of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kor_mask16","","Compute the bitwise OR of 16-bit masks a and b, and store …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kor","","Compute the bitwise OR of 16-bit masks a and b, and store …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kxor_mask16","","Compute the bitwise XOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kxor","","Compute the bitwise XOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_knot_mask16","","Compute the bitwise NOT of 16-bit mask a, and store the …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_knot","","Compute the bitwise NOT of 16-bit mask a, and store the …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kandn_mask16","","Compute the bitwise NOT of 16-bit masks a and then AND …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kandn","","Compute the bitwise NOT of 16-bit masks a and then AND …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kxnor_mask16","","Compute the bitwise XNOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kxnor","","Compute the bitwise XNOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kmov","","Copy 16-bit mask a to k.",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_int2mask","","Converts integer mask into bitmask, storing the result in …",null,[[["i32",15]],["__mmask16",6]]],[5,"_mm512_mask2int","","Converts bit mask k1 into an integer value, storing the …",null,[[["__mmask16",6]],["i32",15]]],[5,"_mm512_kunpackb","","Unpack and interleave 8 bits from masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kortestc","","Performs bitwise OR between k1 and k2, storing the result …",null,[[["__mmask16",6]],["i32",15]]],[5,"_mm512_test_epi32_mask","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_test_epi32_mask","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_test_epi64_mask","","Compute the bitwise AND of packed 64-bit integers in a …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_test_epi64_mask","","Compute the bitwise AND of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_testn_epi32_mask","","Compute the bitwise NAND of packed 32-bit integers in a …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_testn_epi32_mask","","Compute the bitwise NAND of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_testn_epi64_mask","","Compute the bitwise NAND of packed 64-bit integers in a …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_testn_epi64_mask","","Compute the bitwise NAND of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_stream_ps","","Store 512-bits (composed of 16 packed single-precision …",null,[[["__m512",3]]]],[5,"_mm512_stream_pd","","Store 512-bits (composed of 8 packed double-precision …",null,[[["__m512d",3]]]],[5,"_mm512_stream_si512","","Store 512-bits of integer data from a into memory using a …",null,[[["__m512i",3]]]],[5,"_mm512_set_ps","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_setr_ps","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_set1_pd","","Broadcast 64-bit float <code>a</code> to all elements of <code>dst</code>.",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_set1_ps","","Broadcast 32-bit float <code>a</code> to all elements of <code>dst</code>.",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_set_epi32","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_set1_epi8","","Broadcast 8-bit integer a to all elements of dst.",null,[[["i8",15]],["__m512i",3]]],[5,"_mm512_set1_epi16","","Broadcast the low packed 16-bit integer from a to all all …",null,[[["i16",15]],["__m512i",3]]],[5,"_mm512_set1_epi32","","Broadcast 32-bit integer <code>a</code> to all elements of <code>dst</code>.",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_mask_set1_epi32","","Broadcast 32-bit integer a to all elements of dst using …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_set1_epi32","","Broadcast 32-bit integer a to all elements of dst using …",null,[[["i32",15],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_set1_epi64","","Broadcast 64-bit integer <code>a</code> to all elements of <code>dst</code>.",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_mask_set1_epi64","","Broadcast 64-bit integer a to all elements of dst using …",null,[[["i64",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_set1_epi64","","Broadcast 64-bit integer a to all elements of dst using …",null,[[["i64",15],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_set4_epi64","","Set packed 64-bit integers in dst with the repeated 4 …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_setr4_epi64","","Set packed 64-bit integers in dst with the repeated 4 …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_cmplt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmplt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpnlt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpnlt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmple_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmple_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpnle_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpnle_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpeq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpeq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpneq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpneq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmp_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmp_round_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_round_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15]],["__mmask16",6]]],[5,"_mm512_cmpord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpunord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpunord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmplt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpnlt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpnlt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmple_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpnle_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpnle_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpeq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpneq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpneq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmp_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmp_round_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_round_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpunord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpunord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm_cmp_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__mmask8",6]]],[5,"_mm_mask_cmp_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__mmask8",6]]],[5,"_mm_cmp_round_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__mmask8",6]]],[5,"_mm_mask_cmp_round_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["__m128",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm_cmp_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__mmask8",6]]],[5,"_mm_mask_cmp_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm_cmp_round_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__mmask8",6]]],[5,"_mm_mask_cmp_round_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmplt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmplt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpgt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpgt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmple_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmple_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpge_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpge_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpeq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpeq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpneq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpneq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmp_epu32_mask","","Compare packed unsigned 32-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_epu32_mask","","Compare packed unsigned 32-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmplt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmplt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpgt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpgt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmple_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmple_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpge_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpge_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpeq_epi32_mask","","Compare packed 32-bit integers in a and b for equality, …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpeq_epi32_mask","","Compare packed 32-bit integers in a and b for equality, …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpneq_epi32_mask","","Compare packed 32-bit integers in a and b for not-equal, …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpneq_epi32_mask","","Compare packed 32-bit integers in a and b for not-equal, …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmp_epi32_mask","","Compare packed signed 32-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_epi32_mask","","Compare packed signed 32-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpneq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpneq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmp_epu64_mask","","Compare packed unsigned 64-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_epu64_mask","","Compare packed unsigned 64-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmplt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpgt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmple_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpge_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpeq_epi64_mask","","Compare packed 64-bit integers in a and b for equality, …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epi64_mask","","Compare packed 64-bit integers in a and b for equality, …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpneq_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpneq_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmp_epi64_mask","","Compare packed signed 64-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_epi64_mask","","Compare packed signed 64-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_reduce_add_epi32","","Reduce the packed 32-bit integers in a by addition. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_add_epi32","","Reduce the packed 32-bit integers in a by addition using …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_add_epi64","","Reduce the packed 64-bit integers in a by addition. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_add_epi64","","Reduce the packed 64-bit integers in a by addition using …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_add_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_add_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_add_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_add_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_mul_epi32","","Reduce the packed 32-bit integers in a by multiplication. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_mul_epi32","","Reduce the packed 32-bit integers in a by multiplication …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_mul_epi64","","Reduce the packed 64-bit integers in a by multiplication. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_mul_epi64","","Reduce the packed 64-bit integers in a by multiplication …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_mul_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_mul_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_mul_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_mul_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_max_epi32","","Reduce the packed signed 32-bit integers in a by maximum. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_max_epi32","","Reduce the packed signed 32-bit integers in a by maximum …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_max_epi64","","Reduce the packed signed 64-bit integers in a by maximum. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_max_epi64","","Reduce the packed signed 64-bit integers in a by maximum …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_max_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__m512i",3]],["u32",15]]],[5,"_mm512_mask_reduce_max_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__mmask16",6],["__m512i",3]],["u32",15]]],[5,"_mm512_reduce_max_epu64","","Reduce the packed unsigned 64-bit integers in a by …",null,[[["__m512i",3]],["u64",15]]],[5,"_mm512_mask_reduce_max_epu64","","Reduce the packed unsigned 64-bit integers in a by …",null,[[["__mmask8",6],["__m512i",3]],["u64",15]]],[5,"_mm512_reduce_max_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_max_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_max_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_max_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_min_epi32","","Reduce the packed signed 32-bit integers in a by minimum. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_min_epi32","","Reduce the packed signed 32-bit integers in a by maximum …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_min_epi64","","Reduce the packed signed 64-bit integers in a by minimum. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_min_epi64","","Reduce the packed signed 64-bit integers in a by maximum …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_min_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__m512i",3]],["u32",15]]],[5,"_mm512_mask_reduce_min_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__mmask16",6],["__m512i",3]],["u32",15]]],[5,"_mm512_reduce_min_epu64","","Reduce the packed unsigned 64-bit integers in a by …",null,[[["__m512i",3]],["u64",15]]],[5,"_mm512_mask_reduce_min_epu64","","Reduce the packed signed 64-bit integers in a by maximum …",null,[[["__mmask8",6],["__m512i",3]],["u64",15]]],[5,"_mm512_reduce_min_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_min_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_min_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_min_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_and_epi32","","Reduce the packed 32-bit integers in a by bitwise AND. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_and_epi32","","Reduce the packed 32-bit integers in a by bitwise AND …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_and_epi64","","Reduce the packed 64-bit integers in a by bitwise AND. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_and_epi64","","Reduce the packed 64-bit integers in a by addition using …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_or_epi32","","Reduce the packed 32-bit integers in a by bitwise OR. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_or_epi32","","Reduce the packed 32-bit integers in a by bitwise OR …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_or_epi64","","Reduce the packed 64-bit integers in a by bitwise OR. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_or_epi64","","Reduce the packed 64-bit integers in a by bitwise OR …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_undefined_pd","","Returns vector of type <code>__m512d</code> with undefined elements.",null,[[],["__m512d",3]]],[5,"_mm512_undefined_ps","","Returns vector of type <code>__m512</code> with undefined elements.",null,[[],["__m512",3]]],[5,"_mm512_undefined_epi32","","Return vector of type __m512i with undefined elements.",null,[[],["__m512i",3]]],[5,"_mm512_undefined","","Return vector of type __m512 with undefined elements.",null,[[],["__m512",3]]],[5,"_mm512_loadu_epi32","","Load 512-bits (composed of 16 packed 32-bit integers) …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_epi32","","Store 512-bits (composed of 16 packed 32-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_loadu_epi64","","Load 512-bits (composed of 8 packed 64-bit integers) from …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_epi64","","Store 512-bits (composed of 8 packed 64-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_loadu_si512","","Load 512-bits of integer data from memory into dst. …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_si512","","Store 512-bits of integer data from a into memory. …",null,[[["__m512i",3]]]],[5,"_mm512_loadu_pd","","Loads 512-bits (composed of 8 packed double-precision …",null,[[],["__m512d",3]]],[5,"_mm512_storeu_pd","","Stores 512-bits (composed of 8 packed double-precision …",null,[[["__m512d",3]]]],[5,"_mm512_loadu_ps","","Loads 512-bits (composed of 16 packed single-precision …",null,[[],["__m512",3]]],[5,"_mm512_storeu_ps","","Stores 512-bits (composed of 16 packed single-precision …",null,[[["__m512",3]]]],[5,"_mm512_load_si512","","Load 512-bits of integer data from memory into dst. …",null,[[],["__m512i",3]]],[5,"_mm512_store_si512","","Store 512-bits of integer data from a into memory. …",null,[[["__m512i",3]]]],[5,"_mm512_load_epi32","","Load 512-bits (composed of 16 packed 32-bit integers) …",null,[[],["__m512i",3]]],[5,"_mm512_store_epi32","","Store 512-bits (composed of 16 packed 32-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_load_epi64","","Load 512-bits (composed of 8 packed 64-bit integers) from …",null,[[],["__m512i",3]]],[5,"_mm512_store_epi64","","Store 512-bits (composed of 8 packed 64-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_load_ps","","Load 512-bits (composed of 16 packed single-precision …",null,[[],["__m512",3]]],[5,"_mm512_store_ps","","Store 512-bits of integer data from a into memory. …",null,[[["__m512",3]]]],[5,"_mm512_load_pd","","Load 512-bits (composed of 8 packed double-precision …",null,[[],["__m512d",3]]],[5,"_mm512_store_pd","","Store 512-bits (composed of 8 packed double-precision …",null,[[["__m512d",3]]]],[5,"_mm512_setr_pd","","Set packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_set_pd","","Set packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m512d",3]]],[5,"_mm_mask_move_ss","","Move the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_move_ss","","Move the lower single-precision (32-bit) floating-point …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_move_sd","","Move the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_move_sd","","Move the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_add_ss","","Add the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_add_ss","","Add the lower single-precision (32-bit) floating-point …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_add_sd","","Add the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_add_sd","","Add the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_sub_ss","","Subtract the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_sub_ss","","Subtract the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_sub_sd","","Subtract the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_sub_sd","","Subtract the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_mul_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_mul_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_mul_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_mul_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_div_ss","","Divide the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_div_ss","","Divide the lower single-precision (32-bit) floating-point …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_div_sd","","Divide the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_div_sd","","Divide the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_max_ss","","Compare the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_max_ss","","Compare the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_max_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_max_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_min_ss","","Compare the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_min_ss","","Compare the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_min_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_min_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_sqrt_ss","","Compute the square root of the lower single-precision …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_sqrt_ss","","Compute the square root of the lower single-precision …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask_sqrt_sd","","Compute the square root of the lower double-precision …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_sqrt_sd","","Compute the square root of the lower double-precision …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_rsqrt14_ss","","Compute the approximate reciprocal square root of the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mask_rsqrt14_ss","","Compute the approximate reciprocal square root of the …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_rsqrt14_ss","","Compute the approximate reciprocal square root of the …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt14_sd","","Compute the approximate reciprocal square root of the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mask_rsqrt14_sd","","Compute the approximate reciprocal square root of the …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_rsqrt14_sd","","Compute the approximate reciprocal square root of the …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_rcp14_ss","","Compute the approximate reciprocal of the lower …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mask_rcp14_ss","","Compute the approximate reciprocal of the lower …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_rcp14_ss","","Compute the approximate reciprocal of the lower …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_rcp14_sd","","Compute the approximate reciprocal of the lower …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mask_rcp14_sd","","Compute the approximate reciprocal of the lower …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_rcp14_sd","","Compute the approximate reciprocal of the lower …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_getexp_ss","","Convert the exponent of the lower single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mask_getexp_ss","","Convert the exponent of the lower single-precision …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_getexp_ss","","Convert the exponent of the lower single-precision …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_getexp_sd","","Convert the exponent of the lower double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mask_getexp_sd","","Convert the exponent of the lower double-precision …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_getexp_sd","","Convert the exponent of the lower double-precision …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_getmant_ss","","Normalize the mantissas of the lower single-precision …",null,[[["_mm_mantissa_sign_enum",6],["__m128",3],["_mm_mantissa_norm_enum",6]],["__m128",3]]],[5,"_mm_mask_getmant_ss","","Normalize the mantissas of the lower single-precision …",null,[[["__m128",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_getmant_ss","","Normalize the mantissas of the lower single-precision …",null,[[["__m128",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m128",3]]],[5,"_mm_getmant_sd","","Normalize the mantissas of the lower double-precision …",null,[[["__m128d",3],["_mm_mantissa_sign_enum",6],["_mm_mantissa_norm_enum",6]],["__m128d",3]]],[5,"_mm_mask_getmant_sd","","Normalize the mantissas of the lower double-precision …",null,[[["_mm_mantissa_norm_enum",6],["__m128d",3],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_getmant_sd","","Normalize the mantissas of the lower double-precision …",null,[[["_mm_mantissa_norm_enum",6],["__m128d",3],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m128d",3]]],[5,"_mm_roundscale_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_roundscale_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_roundscale_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_roundscale_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_roundscale_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_roundscale_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_scalef_ss","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mask_scalef_ss","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_scalef_ss","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_scalef_sd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mask_scalef_sd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_scalef_sd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_fmadd_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fmadd_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fmadd_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_mask_fmadd_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fmadd_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fmadd_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_fmsub_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fmsub_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fmsub_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_mask_fmsub_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fmsub_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fmsub_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_fnmadd_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fnmadd_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fnmadd_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_mask_fnmadd_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fnmadd_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fnmadd_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask_fnmsub_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fnmsub_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fnmsub_ss","","Multiply the lower single-precision (32-bit) …",null,[[["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_mask_fnmsub_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fnmsub_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fnmsub_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m128d",3]]],[5,"_mm_add_round_ss","","Add the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_add_round_ss","","Add the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_add_round_ss","","Add the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_add_round_sd","","Add the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_add_round_sd","","Add the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_add_round_sd","","Add the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_sub_round_ss","","Subtract the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_sub_round_ss","","Subtract the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_sub_round_ss","","Subtract the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_sub_round_sd","","Subtract the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_sub_round_sd","","Subtract the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_sub_round_sd","","Subtract the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mul_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_mul_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_mul_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mul_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_mul_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_mul_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_div_round_ss","","Divide the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_div_round_ss","","Divide the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_div_round_ss","","Divide the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_div_round_sd","","Divide the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_div_round_sd","","Divide the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_div_round_sd","","Divide the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_max_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_max_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_max_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_max_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_max_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_max_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_min_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_min_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_min_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_min_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_min_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_min_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_sqrt_round_ss","","Compute the square root of the lower single-precision …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_sqrt_round_ss","","Compute the square root of the lower single-precision …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_sqrt_round_ss","","Compute the square root of the lower single-precision …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_round_sd","","Compute the square root of the lower double-precision …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_sqrt_round_sd","","Compute the square root of the lower double-precision …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_sqrt_round_sd","","Compute the square root of the lower double-precision …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_getexp_round_ss","","Convert the exponent of the lower single-precision …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_getexp_round_ss","","Convert the exponent of the lower single-precision …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_getexp_round_ss","","Convert the exponent of the lower single-precision …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_getexp_round_sd","","Convert the exponent of the lower double-precision …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_getexp_round_sd","","Convert the exponent of the lower double-precision …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_getexp_round_sd","","Convert the exponent of the lower double-precision …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_getmant_round_ss","","Normalize the mantissas of the lower single-precision …",null,[[["__m128",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m128",3]]],[5,"_mm_mask_getmant_round_ss","","Normalize the mantissas of the lower single-precision …",null,[[["__m128",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_getmant_round_ss","","Normalize the mantissas of the lower single-precision …",null,[[["__m128",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_getmant_round_sd","","Normalize the mantissas of the lower double-precision …",null,[[["_mm_mantissa_norm_enum",6],["__m128d",3],["_mm_mantissa_sign_enum",6],["i32",15]],["__m128d",3]]],[5,"_mm_mask_getmant_round_sd","","Normalize the mantissas of the lower double-precision …",null,[[["_mm_mantissa_norm_enum",6],["__m128d",3],["_mm_mantissa_sign_enum",6],["__mmask8",6],["i32",15]],["__m128d",3]]],[5,"_mm_maskz_getmant_round_sd","","Normalize the mantissas of the lower double-precision …",null,[[["_mm_mantissa_norm_enum",6],["__m128d",3],["_mm_mantissa_sign_enum",6],["__mmask8",6],["i32",15]],["__m128d",3]]],[5,"_mm_roundscale_round_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_roundscale_round_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_roundscale_round_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_roundscale_round_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_roundscale_round_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_roundscale_round_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_scalef_round_ss","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_scalef_round_ss","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_scalef_round_ss","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_scalef_round_sd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_scalef_round_sd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_scalef_round_sd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_fmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_fmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_fmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_fmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_fmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_fmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_fmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_fmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_fnmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_fnmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fnmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fnmadd_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_fnmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_fnmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fnmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fnmadd_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_fnmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_fnmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fnmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_mask3_fnmsub_round_ss","","Multiply the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_fnmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_fnmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_fnmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_mask3_fnmsub_round_sd","","Multiply the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_fixupimm_ss","","Fix up the lower single-precision (32-bit) floating-point …",null,[[["__m128i",3],["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_fixupimm_ss","","Fix up the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__m128i",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fixupimm_ss","","Fix up the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__m128i",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_fixupimm_sd","","Fix up the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_fixupimm_sd","","Fix up the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3],["__mmask8",6],["i32",15]],["__m128d",3]]],[5,"_mm_maskz_fixupimm_sd","","Fix up the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3],["__mmask8",6],["i32",15]],["__m128d",3]]],[5,"_mm_fixupimm_round_ss","","Fix up the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm_mask_fixupimm_round_ss","","Fix up the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__m128i",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_fixupimm_round_ss","","Fix up the lower single-precision (32-bit) floating-point …",null,[[["__m128",3],["__m128i",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_fixupimm_round_sd","","Fix up the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_fixupimm_round_sd","","Fix up the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3],["__mmask8",6],["i32",15]],["__m128d",3]]],[5,"_mm_maskz_fixupimm_round_sd","","Fix up the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3],["__mmask8",6],["i32",15]],["__m128d",3]]],[5,"_mm_mask_cvtss_sd","","Convert the lower single-precision (32-bit) …",null,[[["__m128d",3],["__mmask8",6],["__m128",3]],["__m128d",3]]],[5,"_mm_maskz_cvtss_sd","","Convert the lower single-precision (32-bit) …",null,[[["__m128d",3],["__mmask8",6],["__m128",3]],["__m128d",3]]],[5,"_mm_mask_cvtsd_ss","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["__m128",3],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_cvtsd_ss","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6],["__m128",3]],["__m128",3]]],[5,"_mm_cvt_roundss_sd","","Convert the lower single-precision (32-bit) …",null,[[["__m128d",3],["i32",15],["__m128",3]],["__m128d",3]]],[5,"_mm_mask_cvt_roundss_sd","","Convert the lower single-precision (32-bit) …",null,[[["__m128",3],["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_maskz_cvt_roundss_sd","","Convert the lower single-precision (32-bit) …",null,[[["__m128",3],["__m128d",3],["i32",15],["__mmask8",6]],["__m128d",3]]],[5,"_mm_cvt_roundsd_ss","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_mask_cvt_roundsd_ss","","Convert the lower double-precision (64-bit) …",null,[[["__m128",3],["__m128d",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_maskz_cvt_roundsd_ss","","Convert the lower double-precision (64-bit) …",null,[[["__m128",3],["__m128d",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm_cvt_roundss_si32","","Convert the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_cvt_roundss_i32","","Convert the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_cvt_roundss_u32","","Convert the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["u32",15]]],[5,"_mm_cvtss_i32","","Convert the lower single-precision (32-bit) …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtss_u32","","Convert the lower single-precision (32-bit) …",null,[[["__m128",3]],["u32",15]]],[5,"_mm_cvt_roundsd_si32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["i32",15]]],[5,"_mm_cvt_roundsd_i32","","Convert the lower single-precision (32-bit) …",null,[[["__m128d",3],["i32",15]],["i32",15]]],[5,"_mm_cvt_roundsd_u32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["u32",15]]],[5,"_mm_cvtsd_i32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvtsd_u32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3]],["u32",15]]],[5,"_mm_cvt_roundi32_ss","","Convert the signed 32-bit integer b to a single-precision …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvt_roundsi32_ss","","Convert the signed 32-bit integer b to a single-precision …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvt_roundu32_ss","","Convert the unsigned 32-bit integer b to a …",null,[[["i32",15],["u32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvti32_ss","","Convert the signed 32-bit integer b to a single-precision …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvti32_sd","","Convert the signed 32-bit integer b to a double-precision …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_cvtt_roundss_si32","","Convert the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_cvtt_roundss_i32","","Convert the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_cvtt_roundss_u32","","Convert the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["u32",15]]],[5,"_mm_cvttss_i32","","Convert the lower single-precision (32-bit) …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvttss_u32","","Convert the lower single-precision (32-bit) …",null,[[["__m128",3]],["u32",15]]],[5,"_mm_cvtt_roundsd_si32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["i32",15]]],[5,"_mm_cvtt_roundsd_i32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["i32",15]]],[5,"_mm_cvtt_roundsd_u32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["u32",15]]],[5,"_mm_cvttsd_i32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvttsd_u32","","Convert the lower double-precision (64-bit) …",null,[[["__m128d",3]],["u32",15]]],[5,"_mm_cvtu32_ss","","Convert the unsigned 32-bit integer b to a …",null,[[["u32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvtu32_sd","","Convert the unsigned 32-bit integer b to a …",null,[[["__m128d",3],["u32",15]],["__m128d",3]]],[5,"_mm_cvtu64_ss","","Convert the unsigned 64-bit integer b to a …",null,[[["__m128",3],["u64",15]],["__m128",3]]],[5,"_mm_cvtu64_sd","","Convert the unsigned 64-bit integer b to a …",null,[[["__m128d",3],["u64",15]],["__m128d",3]]],[5,"_mm_comi_round_ss","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_comi_round_sd","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["i32",15]]],[17,"_MM_CMPINT_EQ","","Equal",null,null],[17,"_MM_CMPINT_LT","","Less-than",null,null],[17,"_MM_CMPINT_LE","","Less-than-or-equal",null,null],[17,"_MM_CMPINT_FALSE","","False",null,null],[17,"_MM_CMPINT_NE","","Not-equal",null,null],[17,"_MM_CMPINT_NLT","","Not less-than",null,null],[17,"_MM_CMPINT_NLE","","Not less-than-or-equal",null,null],[17,"_MM_CMPINT_TRUE","","True",null,null],[17,"_MM_MANT_NORM_1_2","","interval [1, 2)",null,null],[17,"_MM_MANT_NORM_P5_2","","interval [0.5, 2)",null,null],[17,"_MM_MANT_NORM_P5_1","","interval [0.5, 1)",null,null],[17,"_MM_MANT_NORM_P75_1P5","","interval [0.75, 1.5)",null,null],[17,"_MM_MANT_SIGN_SRC","","sign = sign(SRC)",null,null],[17,"_MM_MANT_SIGN_ZERO","","sign = 0",null,null],[17,"_MM_MANT_SIGN_NAN","","DEST = NaN if sign(SRC) = 1",null,null],[17,"_MM_PERM_AAAA","","",null,null],[17,"_MM_PERM_AAAB","","",null,null],[17,"_MM_PERM_AAAC","","",null,null],[17,"_MM_PERM_AAAD","","",null,null],[17,"_MM_PERM_AABA","","",null,null],[17,"_MM_PERM_AABB","","",null,null],[17,"_MM_PERM_AABC","","",null,null],[17,"_MM_PERM_AABD","","",null,null],[17,"_MM_PERM_AACA","","",null,null],[17,"_MM_PERM_AACB","","",null,null],[17,"_MM_PERM_AACC","","",null,null],[17,"_MM_PERM_AACD","","",null,null],[17,"_MM_PERM_AADA","","",null,null],[17,"_MM_PERM_AADB","","",null,null],[17,"_MM_PERM_AADC","","",null,null],[17,"_MM_PERM_AADD","","",null,null],[17,"_MM_PERM_ABAA","","",null,null],[17,"_MM_PERM_ABAB","","",null,null],[17,"_MM_PERM_ABAC","","",null,null],[17,"_MM_PERM_ABAD","","",null,null],[17,"_MM_PERM_ABBA","","",null,null],[17,"_MM_PERM_ABBB","","",null,null],[17,"_MM_PERM_ABBC","","",null,null],[17,"_MM_PERM_ABBD","","",null,null],[17,"_MM_PERM_ABCA","","",null,null],[17,"_MM_PERM_ABCB","","",null,null],[17,"_MM_PERM_ABCC","","",null,null],[17,"_MM_PERM_ABCD","","",null,null],[17,"_MM_PERM_ABDA","","",null,null],[17,"_MM_PERM_ABDB","","",null,null],[17,"_MM_PERM_ABDC","","",null,null],[17,"_MM_PERM_ABDD","","",null,null],[17,"_MM_PERM_ACAA","","",null,null],[17,"_MM_PERM_ACAB","","",null,null],[17,"_MM_PERM_ACAC","","",null,null],[17,"_MM_PERM_ACAD","","",null,null],[17,"_MM_PERM_ACBA","","",null,null],[17,"_MM_PERM_ACBB","","",null,null],[17,"_MM_PERM_ACBC","","",null,null],[17,"_MM_PERM_ACBD","","",null,null],[17,"_MM_PERM_ACCA","","",null,null],[17,"_MM_PERM_ACCB","","",null,null],[17,"_MM_PERM_ACCC","","",null,null],[17,"_MM_PERM_ACCD","","",null,null],[17,"_MM_PERM_ACDA","","",null,null],[17,"_MM_PERM_ACDB","","",null,null],[17,"_MM_PERM_ACDC","","",null,null],[17,"_MM_PERM_ACDD","","",null,null],[17,"_MM_PERM_ADAA","","",null,null],[17,"_MM_PERM_ADAB","","",null,null],[17,"_MM_PERM_ADAC","","",null,null],[17,"_MM_PERM_ADAD","","",null,null],[17,"_MM_PERM_ADBA","","",null,null],[17,"_MM_PERM_ADBB","","",null,null],[17,"_MM_PERM_ADBC","","",null,null],[17,"_MM_PERM_ADBD","","",null,null],[17,"_MM_PERM_ADCA","","",null,null],[17,"_MM_PERM_ADCB","","",null,null],[17,"_MM_PERM_ADCC","","",null,null],[17,"_MM_PERM_ADCD","","",null,null],[17,"_MM_PERM_ADDA","","",null,null],[17,"_MM_PERM_ADDB","","",null,null],[17,"_MM_PERM_ADDC","","",null,null],[17,"_MM_PERM_ADDD","","",null,null],[17,"_MM_PERM_BAAA","","",null,null],[17,"_MM_PERM_BAAB","","",null,null],[17,"_MM_PERM_BAAC","","",null,null],[17,"_MM_PERM_BAAD","","",null,null],[17,"_MM_PERM_BABA","","",null,null],[17,"_MM_PERM_BABB","","",null,null],[17,"_MM_PERM_BABC","","",null,null],[17,"_MM_PERM_BABD","","",null,null],[17,"_MM_PERM_BACA","","",null,null],[17,"_MM_PERM_BACB","","",null,null],[17,"_MM_PERM_BACC","","",null,null],[17,"_MM_PERM_BACD","","",null,null],[17,"_MM_PERM_BADA","","",null,null],[17,"_MM_PERM_BADB","","",null,null],[17,"_MM_PERM_BADC","","",null,null],[17,"_MM_PERM_BADD","","",null,null],[17,"_MM_PERM_BBAA","","",null,null],[17,"_MM_PERM_BBAB","","",null,null],[17,"_MM_PERM_BBAC","","",null,null],[17,"_MM_PERM_BBAD","","",null,null],[17,"_MM_PERM_BBBA","","",null,null],[17,"_MM_PERM_BBBB","","",null,null],[17,"_MM_PERM_BBBC","","",null,null],[17,"_MM_PERM_BBBD","","",null,null],[17,"_MM_PERM_BBCA","","",null,null],[17,"_MM_PERM_BBCB","","",null,null],[17,"_MM_PERM_BBCC","","",null,null],[17,"_MM_PERM_BBCD","","",null,null],[17,"_MM_PERM_BBDA","","",null,null],[17,"_MM_PERM_BBDB","","",null,null],[17,"_MM_PERM_BBDC","","",null,null],[17,"_MM_PERM_BBDD","","",null,null],[17,"_MM_PERM_BCAA","","",null,null],[17,"_MM_PERM_BCAB","","",null,null],[17,"_MM_PERM_BCAC","","",null,null],[17,"_MM_PERM_BCAD","","",null,null],[17,"_MM_PERM_BCBA","","",null,null],[17,"_MM_PERM_BCBB","","",null,null],[17,"_MM_PERM_BCBC","","",null,null],[17,"_MM_PERM_BCBD","","",null,null],[17,"_MM_PERM_BCCA","","",null,null],[17,"_MM_PERM_BCCB","","",null,null],[17,"_MM_PERM_BCCC","","",null,null],[17,"_MM_PERM_BCCD","","",null,null],[17,"_MM_PERM_BCDA","","",null,null],[17,"_MM_PERM_BCDB","","",null,null],[17,"_MM_PERM_BCDC","","",null,null],[17,"_MM_PERM_BCDD","","",null,null],[17,"_MM_PERM_BDAA","","",null,null],[17,"_MM_PERM_BDAB","","",null,null],[17,"_MM_PERM_BDAC","","",null,null],[17,"_MM_PERM_BDAD","","",null,null],[17,"_MM_PERM_BDBA","","",null,null],[17,"_MM_PERM_BDBB","","",null,null],[17,"_MM_PERM_BDBC","","",null,null],[17,"_MM_PERM_BDBD","","",null,null],[17,"_MM_PERM_BDCA","","",null,null],[17,"_MM_PERM_BDCB","","",null,null],[17,"_MM_PERM_BDCC","","",null,null],[17,"_MM_PERM_BDCD","","",null,null],[17,"_MM_PERM_BDDA","","",null,null],[17,"_MM_PERM_BDDB","","",null,null],[17,"_MM_PERM_BDDC","","",null,null],[17,"_MM_PERM_BDDD","","",null,null],[17,"_MM_PERM_CAAA","","",null,null],[17,"_MM_PERM_CAAB","","",null,null],[17,"_MM_PERM_CAAC","","",null,null],[17,"_MM_PERM_CAAD","","",null,null],[17,"_MM_PERM_CABA","","",null,null],[17,"_MM_PERM_CABB","","",null,null],[17,"_MM_PERM_CABC","","",null,null],[17,"_MM_PERM_CABD","","",null,null],[17,"_MM_PERM_CACA","","",null,null],[17,"_MM_PERM_CACB","","",null,null],[17,"_MM_PERM_CACC","","",null,null],[17,"_MM_PERM_CACD","","",null,null],[17,"_MM_PERM_CADA","","",null,null],[17,"_MM_PERM_CADB","","",null,null],[17,"_MM_PERM_CADC","","",null,null],[17,"_MM_PERM_CADD","","",null,null],[17,"_MM_PERM_CBAA","","",null,null],[17,"_MM_PERM_CBAB","","",null,null],[17,"_MM_PERM_CBAC","","",null,null],[17,"_MM_PERM_CBAD","","",null,null],[17,"_MM_PERM_CBBA","","",null,null],[17,"_MM_PERM_CBBB","","",null,null],[17,"_MM_PERM_CBBC","","",null,null],[17,"_MM_PERM_CBBD","","",null,null],[17,"_MM_PERM_CBCA","","",null,null],[17,"_MM_PERM_CBCB","","",null,null],[17,"_MM_PERM_CBCC","","",null,null],[17,"_MM_PERM_CBCD","","",null,null],[17,"_MM_PERM_CBDA","","",null,null],[17,"_MM_PERM_CBDB","","",null,null],[17,"_MM_PERM_CBDC","","",null,null],[17,"_MM_PERM_CBDD","","",null,null],[17,"_MM_PERM_CCAA","","",null,null],[17,"_MM_PERM_CCAB","","",null,null],[17,"_MM_PERM_CCAC","","",null,null],[17,"_MM_PERM_CCAD","","",null,null],[17,"_MM_PERM_CCBA","","",null,null],[17,"_MM_PERM_CCBB","","",null,null],[17,"_MM_PERM_CCBC","","",null,null],[17,"_MM_PERM_CCBD","","",null,null],[17,"_MM_PERM_CCCA","","",null,null],[17,"_MM_PERM_CCCB","","",null,null],[17,"_MM_PERM_CCCC","","",null,null],[17,"_MM_PERM_CCCD","","",null,null],[17,"_MM_PERM_CCDA","","",null,null],[17,"_MM_PERM_CCDB","","",null,null],[17,"_MM_PERM_CCDC","","",null,null],[17,"_MM_PERM_CCDD","","",null,null],[17,"_MM_PERM_CDAA","","",null,null],[17,"_MM_PERM_CDAB","","",null,null],[17,"_MM_PERM_CDAC","","",null,null],[17,"_MM_PERM_CDAD","","",null,null],[17,"_MM_PERM_CDBA","","",null,null],[17,"_MM_PERM_CDBB","","",null,null],[17,"_MM_PERM_CDBC","","",null,null],[17,"_MM_PERM_CDBD","","",null,null],[17,"_MM_PERM_CDCA","","",null,null],[17,"_MM_PERM_CDCB","","",null,null],[17,"_MM_PERM_CDCC","","",null,null],[17,"_MM_PERM_CDCD","","",null,null],[17,"_MM_PERM_CDDA","","",null,null],[17,"_MM_PERM_CDDB","","",null,null],[17,"_MM_PERM_CDDC","","",null,null],[17,"_MM_PERM_CDDD","","",null,null],[17,"_MM_PERM_DAAA","","",null,null],[17,"_MM_PERM_DAAB","","",null,null],[17,"_MM_PERM_DAAC","","",null,null],[17,"_MM_PERM_DAAD","","",null,null],[17,"_MM_PERM_DABA","","",null,null],[17,"_MM_PERM_DABB","","",null,null],[17,"_MM_PERM_DABC","","",null,null],[17,"_MM_PERM_DABD","","",null,null],[17,"_MM_PERM_DACA","","",null,null],[17,"_MM_PERM_DACB","","",null,null],[17,"_MM_PERM_DACC","","",null,null],[17,"_MM_PERM_DACD","","",null,null],[17,"_MM_PERM_DADA","","",null,null],[17,"_MM_PERM_DADB","","",null,null],[17,"_MM_PERM_DADC","","",null,null],[17,"_MM_PERM_DADD","","",null,null],[17,"_MM_PERM_DBAA","","",null,null],[17,"_MM_PERM_DBAB","","",null,null],[17,"_MM_PERM_DBAC","","",null,null],[17,"_MM_PERM_DBAD","","",null,null],[17,"_MM_PERM_DBBA","","",null,null],[17,"_MM_PERM_DBBB","","",null,null],[17,"_MM_PERM_DBBC","","",null,null],[17,"_MM_PERM_DBBD","","",null,null],[17,"_MM_PERM_DBCA","","",null,null],[17,"_MM_PERM_DBCB","","",null,null],[17,"_MM_PERM_DBCC","","",null,null],[17,"_MM_PERM_DBCD","","",null,null],[17,"_MM_PERM_DBDA","","",null,null],[17,"_MM_PERM_DBDB","","",null,null],[17,"_MM_PERM_DBDC","","",null,null],[17,"_MM_PERM_DBDD","","",null,null],[17,"_MM_PERM_DCAA","","",null,null],[17,"_MM_PERM_DCAB","","",null,null],[17,"_MM_PERM_DCAC","","",null,null],[17,"_MM_PERM_DCAD","","",null,null],[17,"_MM_PERM_DCBA","","",null,null],[17,"_MM_PERM_DCBB","","",null,null],[17,"_MM_PERM_DCBC","","",null,null],[17,"_MM_PERM_DCBD","","",null,null],[17,"_MM_PERM_DCCA","","",null,null],[17,"_MM_PERM_DCCB","","",null,null],[17,"_MM_PERM_DCCC","","",null,null],[17,"_MM_PERM_DCCD","","",null,null],[17,"_MM_PERM_DCDA","","",null,null],[17,"_MM_PERM_DCDB","","",null,null],[17,"_MM_PERM_DCDC","","",null,null],[17,"_MM_PERM_DCDD","","",null,null],[17,"_MM_PERM_DDAA","","",null,null],[17,"_MM_PERM_DDAB","","",null,null],[17,"_MM_PERM_DDAC","","",null,null],[17,"_MM_PERM_DDAD","","",null,null],[17,"_MM_PERM_DDBA","","",null,null],[17,"_MM_PERM_DDBB","","",null,null],[17,"_MM_PERM_DDBC","","",null,null],[17,"_MM_PERM_DDBD","","",null,null],[17,"_MM_PERM_DDCA","","",null,null],[17,"_MM_PERM_DDCB","","",null,null],[17,"_MM_PERM_DDCC","","",null,null],[17,"_MM_PERM_DDCD","","",null,null],[17,"_MM_PERM_DDDA","","",null,null],[17,"_MM_PERM_DDDB","","",null,null],[17,"_MM_PERM_DDDC","","",null,null],[17,"_MM_PERM_DDDD","","",null,null],[5,"_mm512_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_abs_epi16","","Compute the absolute value of packed signed 16-bit …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_abs_epi8","","Compute the absolute value of packed signed 8-bit …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_add_epi16","","Add packed 16-bit integers in a and b, and store the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_add_epi8","","Add packed 8-bit integers in a and b, and store the …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_adds_epu16","","Add packed unsigned 16-bit integers in a and b using …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_adds_epu8","","Add packed unsigned 8-bit integers in a and b using …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_adds_epi16","","Add packed signed 16-bit integers in a and b using …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_adds_epi8","","Add packed signed 8-bit integers in a and b using …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_sub_epi16","","Subtract packed 16-bit integers in b from packed 16-bit …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_sub_epi8","","Subtract packed 8-bit integers in b from packed 8-bit …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_subs_epu16","","Subtract packed unsigned 16-bit integers in b from packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_subs_epu8","","Subtract packed unsigned 8-bit integers in b from packed …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_subs_epi16","","Subtract packed signed 16-bit integers in b from packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_subs_epi8","","Subtract packed signed 8-bit integers in b from packed …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_mulhi_epu16","","Multiply the packed unsigned 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_mulhi_epi16","","Multiply the packed signed 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_mulhrs_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_mullo_epi16","","Multiply the packed 16-bit integers in a and b, producing …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_max_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_max_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_max_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_max_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_min_epu16","","Compare packed unsigned 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_min_epu8","","Compare packed unsigned 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_min_epi16","","Compare packed signed 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_min_epi8","","Compare packed signed 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_cmplt_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmplt_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmplt_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmplt_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmplt_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmplt_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmplt_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmplt_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpgt_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpgt_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpgt_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpgt_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpgt_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpgt_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpgt_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpgt_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmple_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmple_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmple_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmple_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmple_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmple_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmple_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmple_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpge_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpge_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpge_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpge_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpge_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpge_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpge_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpge_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpeq_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpeq_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpeq_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpeq_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpeq_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpeq_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpeq_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpeq_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpneq_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpneq_epu16_mask","","Compare packed unsigned 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpneq_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpneq_epu8_mask","","Compare packed unsigned 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmpneq_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmpneq_epi16_mask","","Compare packed signed 16-bit integers in a and b for …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmpneq_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmpneq_epi8_mask","","Compare packed signed 8-bit integers in a and b for …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmp_epu16_mask","","Compare packed unsigned 16-bit integers in a and b based …",null,[[["i32",15],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmp_epu16_mask","","Compare packed unsigned 16-bit integers in a and b based …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmp_epu8_mask","","Compare packed unsigned 8-bit integers in a and b based …",null,[[["i32",15],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmp_epu8_mask","","Compare packed unsigned 8-bit integers in a and b based …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_cmp_epi16_mask","","Compare packed signed 16-bit integers in a and b based on …",null,[[["i32",15],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_cmp_epi16_mask","","Compare packed signed 16-bit integers in a and b based on …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_cmp_epi8_mask","","Compare packed signed 8-bit integers in a and b based on …",null,[[["i32",15],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_cmp_epi8_mask","","Compare packed signed 8-bit integers in a and b based on …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_loadu_epi16","","Load 512-bits (composed of 32 packed 16-bit integers) …",null,[[],["__m512i",3]]],[5,"_mm512_loadu_epi8","","Load 512-bits (composed of 64 packed 8-bit integers) from …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_epi16","","Store 512-bits (composed of 32 packed 16-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_storeu_epi8","","Store 512-bits (composed of 64 packed 8-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_maskz_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_mask_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_madd_epi16","","Multiply packed signed 16-bit integers in a and b, …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_maddubs_epi16","","Vertically multiply each unsigned 8-bit integer from a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_maddubs_epi16","","Multiply packed unsigned 8-bit integers in a by packed …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_maddubs_epi16","","Multiply packed unsigned 8-bit integers in a by packed …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_maddubs_epi16","","Multiply packed unsigned 8-bit integers in a by packed …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_maddubs_epi16","","Multiply packed unsigned 8-bit integers in a by packed …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_maddubs_epi16","","Multiply packed unsigned 8-bit integers in a by packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_maddubs_epi16","","Multiply packed unsigned 8-bit integers in a by packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_packs_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_packs_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_packus_epi32","","Convert packed signed 32-bit integers from a and b to …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_packus_epi16","","Convert packed signed 16-bit integers from a and b to …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_avg_epu16","","Average packed unsigned 16-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_avg_epu8","","Average packed unsigned 8-bit integers in a and b, and …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_sll_epi16","","Shift packed 16-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["__m256i",3],["u32",15],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["__m256i",3],["u32",15],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["__m128i",3],["u32",15],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_slli_epi16","","Shift packed 16-bit integers in a left by imm8 while …",null,[[["__m128i",3],["u32",15],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_sllv_epi16","","Shift packed 16-bit integers in a left by the amount …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_srl_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m256i",3],["i32",15],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m256i",3],["i32",15],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m128i",3],["i32",15],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_srli_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m128i",3],["i32",15],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_srlv_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_sra_epi16","","Shift packed 16-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m256i",3],["u32",15],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m256i",3],["u32",15],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m128i",3],["u32",15],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_srai_epi16","","Shift packed 16-bit integers in a right by imm8 while …",null,[[["__m128i",3],["u32",15],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_srav_epi16","","Shift packed 16-bit integers in a right by the amount …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask2_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_mask2_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_mask2_permutex2var_epi16","","Shuffle 16-bit integers in a and b across lanes using the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_permutexvar_epi16","","Shuffle 16-bit integers in a across lanes using the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_mask_blend_epi16","","Blend packed 16-bit integers from a and b using control …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_blend_epi16","","Blend packed 16-bit integers from a and b using control …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_blend_epi16","","Blend packed 16-bit integers from a and b using control …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_mask_blend_epi8","","Blend packed 8-bit integers from a and b using control …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_blend_epi8","","Blend packed 8-bit integers from a and b using control …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_blend_epi8","","Blend packed 8-bit integers from a and b using control …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m128i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m128i",3],["__mmask32",6]],["__m512i",3]]],[5,"_mm256_mask_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m256i",3],["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_broadcastw_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m128i",3],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m128i",3],["__mmask64",6]],["__m512i",3]]],[5,"_mm256_mask_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m256i",3],["__m128i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m128i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_broadcastb_epi8","","Broadcast the low packed 8-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_unpackhi_epi16","","Unpack and interleave 16-bit integers from the high half …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_unpackhi_epi8","","Unpack and interleave 8-bit integers from the high half …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_unpacklo_epi16","","Unpack and interleave 16-bit integers from the low half …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_unpacklo_epi8","","Unpack and interleave 8-bit integers from the low half of …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_mask_mov_epi16","","Move packed 16-bit integers from a into dst using …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mov_epi16","","Move packed 16-bit integers from a into dst using …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_mov_epi16","","Move packed 16-bit integers from a into dst using …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_maskz_mov_epi16","","Move packed 16-bit integers from a into dst using …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_mask_mov_epi16","","Move packed 16-bit integers from a into dst using …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_mov_epi16","","Move packed 16-bit integers from a into dst using …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_mask_mov_epi8","","Move packed 8-bit integers from a into dst using …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mov_epi8","","Move packed 8-bit integers from a into dst using zeromask …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_mask_mov_epi8","","Move packed 8-bit integers from a into dst using …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_mov_epi8","","Move packed 8-bit integers from a into dst using zeromask …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_mask_mov_epi8","","Move packed 8-bit integers from a into dst using …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_mov_epi8","","Move packed 8-bit integers from a into dst using zeromask …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_mask_set1_epi16","","Broadcast 16-bit integer a to all elements of dst using …",null,[[["i16",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_set1_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__mmask32",6],["i16",15]],["__m512i",3]]],[5,"_mm256_mask_set1_epi16","","Broadcast 16-bit integer a to all elements of dst using …",null,[[["__m256i",3],["__mmask16",6],["i16",15]],["__m256i",3]]],[5,"_mm256_maskz_set1_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__mmask16",6],["i16",15]],["__m256i",3]]],[5,"_mm_mask_set1_epi16","","Broadcast 16-bit integer a to all elements of dst using …",null,[[["__m128i",3],["__mmask8",6],["i16",15]],["__m128i",3]]],[5,"_mm_maskz_set1_epi16","","Broadcast the low packed 16-bit integer from a to all …",null,[[["__mmask8",6],["i16",15]],["__m128i",3]]],[5,"_mm512_mask_set1_epi8","","Broadcast 8-bit integer a to all elements of dst using …",null,[[["i8",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_set1_epi8","","Broadcast 8-bit integer a to all elements of dst using …",null,[[["__mmask64",6],["i8",15]],["__m512i",3]]],[5,"_mm256_mask_set1_epi8","","Broadcast 8-bit integer a to all elements of dst using …",null,[[["__m256i",3],["__mmask32",6],["i8",15]],["__m256i",3]]],[5,"_mm256_maskz_set1_epi8","","Broadcast 8-bit integer a to all elements of dst using …",null,[[["__mmask32",6],["i8",15]],["__m256i",3]]],[5,"_mm_mask_set1_epi8","","Broadcast 8-bit integer a to all elements of dst using …",null,[[["__m128i",3],["__mmask16",6],["i8",15]],["__m128i",3]]],[5,"_mm_maskz_set1_epi8","","Broadcast 8-bit integer a to all elements of dst using …",null,[[["__mmask16",6],["i8",15]],["__m128i",3]]],[5,"_mm512_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shufflelo_epi16","","Shuffle 16-bit integers in the low 64 bits of 128-bit …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shufflehi_epi16","","Shuffle 16-bit integers in the high 64 bits of 128-bit …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_epi8","","Shuffle packed 8-bit integers in a according to shuffle …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_epi8","","Shuffle 8-bit integers in a within 128-bit lanes using …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_epi8","","Shuffle packed 8-bit integers in a according to shuffle …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_test_epi16_mask","","Compute the bitwise AND of packed 16-bit integers in a …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_test_epi16_mask","","Compute the bitwise AND of packed 16-bit integers in a …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_test_epi8_mask","","Compute the bitwise AND of packed 8-bit integers in a and …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_test_epi8_mask","","Compute the bitwise AND of packed 8-bit integers in a and …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm512_testn_epi16_mask","","Compute the bitwise NAND of packed 16-bit integers in a …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_mask_testn_epi16_mask","","Compute the bitwise NAND of packed 16-bit integers in a …",null,[[["__mmask32",6],["__m512i",3]],["__mmask32",6]]],[5,"_mm512_testn_epi8_mask","","Compute the bitwise NAND of packed 8-bit integers in a …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_testn_epi8_mask","","Compute the bitwise NAND of packed 8-bit integers in a …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_store_mask64","","Store 64-bit mask from a into memory.",null,[[["__mmask64",6]]]],[5,"_store_mask32","","Store 32-bit mask from a into memory.",null,[[["__mmask32",6]]]],[5,"_load_mask64","","Load 64-bit mask from memory into k.",null,[[],["__mmask64",6]]],[5,"_load_mask32","","Load 32-bit mask from memory into k.",null,[[],["__mmask32",6]]],[5,"_mm512_sad_epu8","","Compute the absolute differences of packed unsigned 8-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_dbsad_epu8","","Compute the sum of absolute differences (SADs) of …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_dbsad_epu8","","Compute the sum of absolute differences (SADs) of …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_dbsad_epu8","","Compute the sum of absolute differences (SADs) of …",null,[[["i32",15],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_movepi16_mask","","Set each bit of mask register k based on the most …",null,[[["__m512i",3]],["__mmask32",6]]],[5,"_mm512_movepi8_mask","","Set each bit of mask register k based on the most …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_movm_epi16","","Set each packed 16-bit integer in dst to all ones or all …",null,[[["__mmask32",6]],["__m512i",3]]],[5,"_mm512_movm_epi8","","Set each packed 8-bit integer in dst to all ones or all …",null,[[["__mmask64",6]],["__m512i",3]]],[5,"_kadd_mask32","","Add 32-bit masks in a and b, and store the result in k.",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_kadd_mask64","","Add 64-bit masks in a and b, and store the result in k.",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_kand_mask32","","Compute the bitwise AND of 32-bit masks a and b, and …",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_kand_mask64","","Compute the bitwise AND of 64-bit masks a and b, and …",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_knot_mask32","","Compute the bitwise NOT of 32-bit mask a, and store the …",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_knot_mask64","","Compute the bitwise NOT of 64-bit mask a, and store the …",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_kandn_mask32","","Compute the bitwise NOT of 32-bit masks a and then AND …",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_kandn_mask64","","Compute the bitwise NOT of 64-bit masks a and then AND …",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_kor_mask32","","Compute the bitwise OR of 32-bit masks a and b, and store …",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_kor_mask64","","Compute the bitwise OR of 64-bit masks a and b, and store …",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_kxor_mask32","","Compute the bitwise XOR of 32-bit masks a and b, and …",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_kxor_mask64","","Compute the bitwise XOR of 64-bit masks a and b, and …",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_kxnor_mask32","","Compute the bitwise XNOR of 32-bit masks a and b, and …",null,[[["__mmask32",6]],["__mmask32",6]]],[5,"_kxnor_mask64","","Compute the bitwise XNOR of 64-bit masks a and b, and …",null,[[["__mmask64",6]],["__mmask64",6]]],[5,"_mm512_cvtepi16_epi8","","Convert packed 16-bit integers in a to packed 8-bit …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtepi16_epi8","","Convert packed 16-bit integers in a to packed 8-bit …",null,[[["__m256i",3],["__mmask32",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtepi16_epi8","","Convert packed 16-bit integers in a to packed 8-bit …",null,[[["__mmask32",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtsepi16_epi8","","Convert packed signed 16-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtsepi16_epi8","","Convert packed signed 16-bit integers in a to packed …",null,[[["__m256i",3],["__mmask32",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtsepi16_epi8","","Convert packed signed 16-bit integers in a to packed …",null,[[["__mmask32",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtusepi16_epi8","","Convert packed unsigned 16-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtusepi16_epi8","","Convert packed unsigned 16-bit integers in a to packed …",null,[[["__m256i",3],["__mmask32",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtusepi16_epi8","","Convert packed unsigned 16-bit integers in a to packed …",null,[[["__mmask32",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtepi8_epi16","","Sign extend packed 8-bit integers in a to packed 16-bit …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi8_epi16","","Sign extend packed 8-bit integers in a to packed 16-bit …",null,[[["__m256i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi8_epi16","","Sign extend packed 8-bit integers in a to packed 16-bit …",null,[[["__m256i",3],["__mmask32",6]],["__m512i",3]]],[5,"_mm512_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m256i",3],["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu8_epi16","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m256i",3],["__mmask32",6]],["__m512i",3]]],[5,"_mm512_bslli_epi128","","Shift 128-bit lanes in a left by imm8 bytes while …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_bsrli_epi128","","Shift 128-bit lanes in a right by imm8 bytes while …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_alignr_epi8","","Concatenate pairs of 16-byte blocks in a and b into a …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_alignr_epi8","","Concatenate pairs of 16-byte blocks in a and b into a …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_alignr_epi8","","Concatenate pairs of 16-byte blocks in a and b into a …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_broadcastmw_epi32","","Broadcast the low 16-bits from input mask k to all 32-bit …",null,[[["__mmask16",6]],["__m512i",3]]],[5,"_mm256_broadcastmw_epi32","","Broadcast the low 16-bits from input mask k to all 32-bit …",null,[[["__mmask16",6]],["__m256i",3]]],[5,"_mm_broadcastmw_epi32","","Broadcast the low 16-bits from input mask k to all 32-bit …",null,[[["__mmask16",6]],["__m128i",3]]],[5,"_mm512_broadcastmb_epi64","","Broadcast the low 8-bits from input mask k to all 64-bit …",null,[[["__mmask8",6]],["__m512i",3]]],[5,"_mm256_broadcastmb_epi64","","Broadcast the low 8-bits from input mask k to all 64-bit …",null,[[["__mmask8",6]],["__m256i",3]]],[5,"_mm_broadcastmb_epi64","","Broadcast the low 8-bits from input mask k to all 64-bit …",null,[[["__mmask8",6]],["__m128i",3]]],[5,"_mm512_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_maskz_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_conflict_epi32","","Test each 32-bit element of a for equality with all other …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_maskz_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_conflict_epi64","","Test each 64-bit element of a for equality with all other …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_maskz_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_lzcnt_epi32","","Counts the number of leading zero bits in each packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_maskz_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_maskz_lzcnt_epi64","","Counts the number of leading zero bits in each packed …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm256_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm512_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__mmask32",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maskz_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm256_mask_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maskz_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_mask_popcnt_epi16","","For each packed 16-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maskz_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_mask_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maskz_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_mask_popcnt_epi8","","For each packed 8-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_bitshuffle_epi64_mask","","Considers the input <code>b</code> as packed 64-bit integers and <code>c</code> as …",null,[[["__m512i",3]],["__mmask64",6]]],[5,"_mm512_mask_bitshuffle_epi64_mask","","Considers the input <code>b</code> as packed 64-bit integers and <code>c</code> as …",null,[[["__mmask64",6],["__m512i",3]],["__mmask64",6]]],[5,"_mm256_bitshuffle_epi64_mask","","Considers the input <code>b</code> as packed 64-bit integers and <code>c</code> as …",null,[[["__m256i",3]],["__mmask32",6]]],[5,"_mm256_mask_bitshuffle_epi64_mask","","Considers the input <code>b</code> as packed 64-bit integers and <code>c</code> as …",null,[[["__m256i",3],["__mmask32",6]],["__mmask32",6]]],[5,"_mm_bitshuffle_epi64_mask","","Considers the input <code>b</code> as packed 64-bit integers and <code>c</code> as …",null,[[["__m128i",3]],["__mmask16",6]]],[5,"_mm_mask_bitshuffle_epi64_mask","","Considers the input <code>b</code> as packed 64-bit integers and <code>c</code> as …",null,[[["__m128i",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_maskz_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m256i",3],["__mmask32",6]],["__m256i",3]]],[5,"_mm_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm_maskz_gf2p8mul_epi8","","Performs a multiplication in GF(2^8) on the packed bytes. …",null,[[["__m128i",3],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_maskz_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["__m256i",3],["i32",15],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_mask_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["__m256i",3],["i32",15],["__mmask32",6]],["__m256i",3]]],[5,"_mm_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_maskz_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["__m128i",3],["i32",15],["__mmask16",6]],["__m128i",3]]],[5,"_mm_mask_gf2p8affine_epi64_epi8","","Performs an affine transformation on the packed bytes in …",null,[[["__m128i",3],["i32",15],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["i32",15],["__mmask64",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_maskz_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["__m256i",3],["i32",15],["__mmask32",6]],["__m256i",3]]],[5,"_mm256_mask_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["__m256i",3],["i32",15],["__mmask32",6]],["__m256i",3]]],[5,"_mm_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_maskz_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["__m128i",3],["i32",15],["__mmask16",6]],["__m128i",3]]],[5,"_mm_mask_gf2p8affineinv_epi64_epi8","","Performs an affine transformation on the inverted packed …",null,[[["__m128i",3],["i32",15],["__mmask16",6]],["__m128i",3]]],[5,"_mm512_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maskz_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_mask_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maskz_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_mask_popcnt_epi32","","For each packed 32-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm512_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm256_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maskz_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm256_mask_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m256i",3],["__mmask8",6]],["__m256i",3]]],[5,"_mm_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maskz_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm_mask_popcnt_epi64","","For each packed 64-bit integer maps the value to the …",null,[[["__m128i",3],["__mmask8",6]],["__m128i",3]]],[5,"_mm256_aesenc_epi128","","Performs one round of an AES encryption flow on each …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_aesenclast_epi128","","Performs the last round of an AES encryption flow on each …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_aesdec_epi128","","Performs one round of an AES decryption flow on each …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_aesdeclast_epi128","","Performs the last round of an AES decryption flow on each …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm512_aesenc_epi128","","Performs one round of an AES encryption flow on each …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_aesenclast_epi128","","Performs the last round of an AES encryption flow on each …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_aesdec_epi128","","Performs one round of an AES decryption flow on each …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_aesdeclast_epi128","","Performs the last round of an AES decryption flow on each …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_clmulepi64_epi128","","Performs a carry-less multiplication of two 64-bit …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm256_clmulepi64_epi128","","Performs a carry-less multiplication of two 64-bit …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_bittest","","Returns the bit in position <code>b</code> of the memory addressed by <code>p</code>…",null,[[["i32",15]],["u8",15]]],[5,"_bittestandset","","Returns the bit in position <code>b</code> of the memory addressed by <code>p</code>…",null,[[["i32",15]],["u8",15]]],[5,"_bittestandreset","","Returns the bit in position <code>b</code> of the memory addressed by <code>p</code>…",null,[[["i32",15]],["u8",15]]],[5,"_bittestandcomplement","","Returns the bit in position <code>b</code> of the memory addressed by <code>p</code>…",null,[[["i32",15]],["u8",15]]],[17,"_XBEGIN_STARTED","","Transaction successfully started.",null,null],[17,"_XABORT_EXPLICIT","","Transaction explicitly aborted with xabort. The parameter …",null,null],[17,"_XABORT_RETRY","","Transaction retry is possible.",null,null],[17,"_XABORT_CONFLICT","","Transaction abort due to a memory conflict with another …",null,null],[17,"_XABORT_CAPACITY","","Transaction abort due to the transaction using too much …",null,null],[17,"_XABORT_DEBUG","","Transaction abort due to a debug trap.",null,null],[17,"_XABORT_NESTED","","Transaction abort in a inner nested transaction.",null,null],[5,"_xbegin","","Specifies the start of a restricted transactional memory …",null,[[],["u32",15]]],[5,"_xend","","Specifies the end of a restricted transactional memory …",null,[[]]],[5,"_xabort","","Forces a restricted transactional memory (RTM) region to …",null,[[["u32",15]]]],[5,"_xtest","","Queries whether the processor is executing in a …",null,[[],["u8",15]]],[5,"_xabort_code","","Retrieves the parameter passed to [<code>_xabort</code>] when [<code>_xbegin</code>]…",null,[[["u32",15]],["u32",15]]],[5,"_mm_cvtph_ps","","Converts the 4 x 16-bit half-precision float values in …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm256_cvtph_ps","","Converts the 8 x 16-bit half-precision float values in …",null,[[["__m128i",3]],["__m256",3]]],[5,"_mm_cvtps_ph","","Converts the 4 x 32-bit float values in the 128-bit …",null,[[["i32",15],["__m128",3]],["__m128i",3]]],[5,"_mm256_cvtps_ph","","Converts the 8 x 32-bit float values in the 256-bit …",null,[[["i32",15],["__m256",3]],["__m128i",3]]],[0,"x86_64","core::arch","Platform-specific intrinsics for the <code>x86_64</code> platform.",null,null],[3,"__m128i","core::arch::x86_64","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four <code>f32</code> types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two <code>f64</code> types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight <code>f32</code> types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four <code>f64</code> types, x86-specific",null,null],[3,"__m512i","","512-bit wide integer vector type, x86-specific",null,null],[3,"__m512","","512-bit wide set of sixteen <code>f32</code> types, x86-specific",null,null],[3,"__m512d","","512-bit wide set of eight <code>f64</code> types, x86-specific",null,null],[6,"__mmask64","","The <code>__mmask64</code> type used in AVX-512 intrinsics, a 64-bit …",null,null],[6,"__mmask32","","The <code>__mmask32</code> type used in AVX-512 intrinsics, a 32-bit …",null,null],[6,"__mmask16","","The <code>__mmask16</code> type used in AVX-512 intrinsics, a 16-bit …",null,null],[6,"__mmask8","","The <code>__mmask8</code> type used in AVX-512 intrinsics, a 8-bit …",null,null],[6,"_MM_CMPINT_ENUM","","The <code>_MM_CMPINT_ENUM</code> type used to specify comparison …",null,null],[6,"_MM_MANTISSA_NORM_ENUM","","The <code>MM_MANTISSA_NORM_ENUM</code> type used to specify mantissa …",null,null],[6,"_MM_MANTISSA_SIGN_ENUM","","The <code>MM_MANTISSA_SIGN_ENUM</code> type used to specify mantissa …",null,null],[6,"_MM_PERM_ENUM","","The <code>MM_PERM_ENUM</code> type used to specify shuffle operations …",null,null],[5,"_fxsave","","Saves the <code>x87</code> FPU, <code>MMX</code> technology, <code>XMM</code>, and <code>MXCSR</code> …",null,[[]]],[5,"_fxrstor","","Restores the <code>XMM</code>, <code>MMX</code>, <code>MXCSR</code>, and <code>x87</code> FPU registers from …",null,[[]]],[5,"_bswap","","Returns an integer with the reversed byte order of x",null,[[["i32",15]],["i32",15]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp …",null,[[],["u64",15]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp …",null,[[],["u64",15]]],[3,"CpuidResult","","Result of the <code>cpuid</code> instruction.",null,null],[12,"eax","","EAX register.",130,null],[12,"ebx","","EBX register.",130,null],[12,"ecx","","ECX register.",130,null],[12,"edx","","EDX register.",130,null],[5,"__cpuid_count","","Returns the result of the <code>cpuid</code> instruction for a given …",null,[[["u32",15]],["cpuidresult",3]]],[5,"__cpuid","","See <code>__cpuid_count</code>.",null,[[["u32",15]],["cpuidresult",3]]],[5,"has_cpuid","","Does the host support the <code>cpuid</code> instruction?",null,[[],["bool",15]]],[5,"__get_cpuid_max","","Returns the highest-supported <code>leaf</code> (<code>EAX</code>) and sub-leaf (<code>ECX</code>…",null,[[["u32",15]]]],[5,"_xsave","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xrstor","","Performs a full or partial restore of the enabled …",null,[[["u64",15]]]],[17,"_XCR_XFEATURE_ENABLED_MASK","","<code>XFEATURE_ENABLED_MASK</code> for <code>XCR</code>",null,null],[5,"_xsetbv","","Copies 64-bits from <code>val</code> to the extended control register (…",null,[[["u32",15],["u64",15]]]],[5,"_xgetbv","","Reads the contents of the extended control register <code>XCR</code> …",null,[[["u32",15]],["u64",15]]],[5,"_xsaveopt","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xsavec","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xsaves","","Performs a full or partial save of the enabled processor …",null,[[["u64",15]]]],[5,"_xrstors","","Performs a full or partial restore of the enabled …",null,[[["u64",15]]]],[5,"_mm_add_ss","","Adds the first component of <code>a</code> and <code>b</code>, the other components …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_add_ps","","Adds __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ss","","Subtracts the first component of <code>b</code> from <code>a</code>, the other …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ss","","Multiplies the first component of <code>a</code> and <code>b</code>, the other …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ss","","Divides the first component of <code>b</code> by <code>a</code>, the other …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ps","","Divides __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ss","","Returns the square root of the first single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ps","","Returns the square root of packed single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ss","","Returns the approximate reciprocal of the first …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ps","","Returns the approximate reciprocal of packed …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ss","","Returns the approximate reciprocal square root of the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ps","","Returns the approximate reciprocal square root of packed …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ss","","Compares the first single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ss","","Compares the first single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ss","","Compares the lowest <code>f32</code> of both inputs for equality. The …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ss","","Compares the lowest <code>f32</code> of both inputs for less than. The …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ss","","Compares the lowest <code>f32</code> of both inputs for less than or …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ss","","Compares the lowest <code>f32</code> of both inputs for greater than. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ss","","Compares the lowest <code>f32</code> of both inputs for greater than …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ss","","Compares the lowest <code>f32</code> of both inputs for inequality. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ss","","Compares the lowest <code>f32</code> of both inputs for not-less-than. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ss","","Compares the lowest <code>f32</code> of both inputs for …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ss","","Compares the lowest <code>f32</code> of both inputs for …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ss","","Compares the lowest <code>f32</code> of both inputs for …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ss","","Checks if the lowest <code>f32</code> of both inputs are ordered. The …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ss","","Checks if the lowest <code>f32</code> of both inputs are unordered. …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ps","","Compares each of the four floats in <code>a</code> to the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_comieq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comilt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comile_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comigt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comige_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_comineq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomieq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomilt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomile_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomigt_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomige_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_ucomineq_ss","","Compares two 32-bit floats from the low-order bits of <code>a</code> …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtss_si32","","Converts the lowest 32 bit float in the input vector to a …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvt_ss2si","","Alias for <code>_mm_cvtss_si32</code>.",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvttss_si32","","Converts the lowest 32 bit float in the input vector to a …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtt_ss2si","","Alias for <code>_mm_cvttss_si32</code>.",null,[[["__m128",3]],["i32",15]]],[5,"_mm_cvtss_f32","","Extracts the lowest 32 bit float from the input vector.",null,[[["__m128",3]],["f32",15]]],[5,"_mm_cvtsi32_ss","","Converts a 32 bit integer to a 32 bit float. The result …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_cvt_si2ss","","Alias for <code>_mm_cvtsi32_ss</code>.",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_set_ss","","Construct a <code>__m128</code> with the lowest element set to <code>a</code> and …",null,[[["f32",15]],["__m128",3]]],[5,"_mm_set1_ps","","Construct a <code>__m128</code> with all element set to <code>a</code>.",null,[[["f32",15]],["__m128",3]]],[5,"_mm_set_ps1","","Alias for <code>_mm_set1_ps</code>",null,[[["f32",15]],["__m128",3]]],[5,"_mm_set_ps","","Construct a <code>__m128</code> from four floating point values …",null,[[["f32",15]],["__m128",3]]],[5,"_mm_setr_ps","","Construct a <code>__m128</code> from four floating point values lowest …",null,[[["f32",15]],["__m128",3]]],[5,"_mm_setzero_ps","","Construct a <code>__m128</code> with all elements initialized to zero.",null,[[],["__m128",3]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel …",null,[[["u32",15]],["i32",15]]],[5,"_mm_shuffle_ps","","Shuffles packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_unpackhi_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_unpacklo_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movehl_ps","","Combine higher half of <code>a</code> and <code>b</code>. The highwe half of <code>b</code> …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movelh_ps","","Combine lower half of <code>a</code> and <code>b</code>. The lower half of <code>b</code> …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movemask_ps","","Returns a mask of the most significant bit of each …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_load_ss","","Construct a <code>__m128</code> with the lowest element read from <code>p</code> …",null,[[],["__m128",3]]],[5,"_mm_load1_ps","","Construct a <code>__m128</code> by duplicating the value read from <code>p</code> …",null,[[],["__m128",3]]],[5,"_mm_load_ps1","","Alias for <code>_mm_load1_ps</code>",null,[[],["__m128",3]]],[5,"_mm_load_ps","","Loads four <code>f32</code> values from <em>aligned</em> memory into a <code>__m128</code>. …",null,[[],["__m128",3]]],[5,"_mm_loadu_ps","","Loads four <code>f32</code> values from memory into a <code>__m128</code>. There …",null,[[],["__m128",3]]],[5,"_mm_loadr_ps","","Loads four <code>f32</code> values from aligned memory into a <code>__m128</code> …",null,[[],["__m128",3]]],[5,"_mm_loadu_si64","","Loads unaligned 64-bits of integer data from memory into …",null,[[],["__m128i",3]]],[5,"_mm_store_ss","","Stores the lowest 32 bit float of <code>a</code> into memory.",null,[[["__m128",3]]]],[5,"_mm_store1_ps","","Stores the lowest 32 bit float of <code>a</code> repeated four times …",null,[[["__m128",3]]]],[5,"_mm_store_ps1","","Alias for <code>_mm_store1_ps</code>",null,[[["__m128",3]]]],[5,"_mm_store_ps","","Stores four 32-bit floats into <em>aligned</em> memory.",null,[[["__m128",3]]]],[5,"_mm_storeu_ps","","Stores four 32-bit floats into memory. There are no …",null,[[["__m128",3]]]],[5,"_mm_storer_ps","","Stores four 32-bit floats into <em>aligned</em> memory in reverse …",null,[[["__m128",3]]]],[5,"_mm_move_ss","","Returns a <code>__m128</code> with the first component from <code>b</code> and the …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sfence","","Performs a serializing operation on all store-to-memory …",null,[[]]],[5,"_mm_getcsr","","Gets the unsigned 32-bit value of the MXCSR control and …",null,[[],["u32",15]]],[5,"_mm_setcsr","","Sets the MXCSR register with the 32-bit unsigned integer …",null,[[["u32",15]]]],[17,"_MM_EXCEPT_INVALID","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_DENORM","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_INEXACT","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_EXCEPT_MASK","","See <code>_MM_GET_EXCEPTION_STATE</code>",null,null],[17,"_MM_MASK_INVALID","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_DENORM","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_DIV_ZERO","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_OVERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_UNDERFLOW","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_INEXACT","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_MASK_MASK","","See <code>_MM_GET_EXCEPTION_MASK</code>",null,null],[17,"_MM_ROUND_NEAREST","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_DOWN","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_UP","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_ROUND_MASK","","See <code>_MM_GET_ROUNDING_MODE</code>",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See <code>_MM_GET_FLUSH_ZERO_MODE</code>",null,null],[17,"_MM_FLUSH_ZERO_ON","","See <code>_mm_setcsr</code>",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See <code>_mm_setcsr</code>",null,null],[5,"_MM_GET_EXCEPTION_MASK","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_GET_EXCEPTION_STATE","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_GET_ROUNDING_MODE","","See <code>_mm_setcsr</code>",null,[[],["u32",15]]],[5,"_MM_SET_EXCEPTION_MASK","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[5,"_MM_SET_EXCEPTION_STATE","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[5,"_MM_SET_ROUNDING_MODE","","See <code>_mm_setcsr</code>",null,[[["u32",15]]]],[17,"_MM_HINT_T0","","See <code>_mm_prefetch</code>.",null,null],[17,"_MM_HINT_T1","","See <code>_mm_prefetch</code>.",null,null],[17,"_MM_HINT_T2","","See <code>_mm_prefetch</code>.",null,null],[17,"_MM_HINT_NTA","","See <code>_mm_prefetch</code>.",null,null],[5,"_mm_prefetch","","Fetch the cache line that contains address <code>p</code> using the …",null,[[["i32",15]]]],[5,"_mm_undefined_ps","","Returns vector of type __m128 with undefined elements.",null,[[],["__m128",3]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in …",null,[[["__m128",3]]]],[5,"_mm_stream_ps","","Stores <code>a</code> into the memory at <code>mem_addr</code> using a non-temporal …",null,[[["__m128",3]]]],[5,"_mm_pause","","Provides a hint to the processor that the code sequence …",null,[[]]],[5,"_mm_clflush","","Invalidates and flushes the cache line that contains <code>p</code> …",null,[[]]],[5,"_mm_lfence","","Performs a serializing operation on all load-from-memory …",null,[[]]],[5,"_mm_mfence","","Performs a serializing operation on all load-from-memory …",null,[[]]],[5,"_mm_add_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi32","","Adds packed 32-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi64","","Adds packed 64-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu8","","Adds packed unsigned 8-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu16","","Adds packed unsigned 16-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu8","","Averages packed unsigned 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu16","","Averages packed unsigned 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd_epi16","","Multiplies and then horizontally add signed 16 bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epu32","","Multiplies the low unsigned 32-bit integers from each …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi8","","Subtracts packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi16","","Subtracts packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in <code>b</code> from packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in <code>b</code> from packed 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in <code>b</code> from packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in <code>b</code> from packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_si128","","Shifts <code>a</code> left by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_bslli_si128","","Shifts <code>a</code> left by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_bsrli_si128","","Shifts <code>a</code> right by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_slli_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sll_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sll_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sll_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sra_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sra_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_si128","","Shifts <code>a</code> right by <code>imm8</code> bytes while shifting in zeros.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srli_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srl_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srl_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_srl_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_and_si128","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_andnot_si128","","Computes the bitwise NOT of 128 bits (representing …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_or_si128","","Computes the bitwise OR of 128 bits (representing integer …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_xor_si128","","Computes the bitwise XOR of 128 bits (representing …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_pd","","Converts the lower two packed 32-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_cvtsi32_sd","","Returns <code>a</code> with its lower element replaced by <code>b</code> after …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_cvtepi32_ps","","Converts packed 32-bit integers in <code>a</code> to packed …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_cvtsi32_si128","","Returns a vector whose lowest element is <code>a</code> and all higher …",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_cvtsi128_si32","","Returns the lowest element of <code>a</code>.",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_set_epi64x","","Sets packed 64-bit integers with the supplied values, …",null,[[["i64",15]],["__m128i",3]]],[5,"_mm_set_epi32","","Sets packed 32-bit integers with the supplied values.",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_set_epi16","","Sets packed 16-bit integers with the supplied values.",null,[[["i16",15]],["__m128i",3]]],[5,"_mm_set_epi8","","Sets packed 8-bit integers with the supplied values.",null,[[["i8",15]],["__m128i",3]]],[5,"_mm_set1_epi64x","","Broadcasts 64-bit integer <code>a</code> to all elements.",null,[[["i64",15]],["__m128i",3]]],[5,"_mm_set1_epi32","","Broadcasts 32-bit integer <code>a</code> to all elements.",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_set1_epi16","","Broadcasts 16-bit integer <code>a</code> to all elements.",null,[[["i16",15]],["__m128i",3]]],[5,"_mm_set1_epi8","","Broadcasts 8-bit integer <code>a</code> to all elements.",null,[[["i8",15]],["__m128i",3]]],[5,"_mm_setr_epi32","","Sets packed 32-bit integers with the supplied values in …",null,[[["i32",15]],["__m128i",3]]],[5,"_mm_setr_epi16","","Sets packed 16-bit integers with the supplied values in …",null,[[["i16",15]],["__m128i",3]]],[5,"_mm_setr_epi8","","Sets packed 8-bit integers with the supplied values in …",null,[[["i8",15]],["__m128i",3]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,[[],["__m128i",3]]],[5,"_mm_loadl_epi64","","Loads 64-bit integer from memory into first element of …",null,[[],["__m128i",3]]],[5,"_mm_load_si128","","Loads 128-bits of integer data from memory into a new …",null,[[],["__m128i",3]]],[5,"_mm_loadu_si128","","Loads 128-bits of integer data from memory into a new …",null,[[],["__m128i",3]]],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from <code>a</code> into …",null,[[["__m128i",3]]]],[5,"_mm_store_si128","","Stores 128-bits of integer data from <code>a</code> into memory.",null,[[["__m128i",3]]]],[5,"_mm_storeu_si128","","Stores 128-bits of integer data from <code>a</code> into memory.",null,[[["__m128i",3]]]],[5,"_mm_storel_epi64","","Stores the lower 64-bit integer <code>a</code> to a memory location.",null,[[["__m128i",3]]]],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned …",null,[[["__m128i",3]]]],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory …",null,[[["i32",15]]]],[5,"_mm_move_epi64","","Returns a vector where the low element is extracted from <code>a</code>…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_extract_epi16","","Returns the <code>imm8</code> element of <code>a</code>.",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_insert_epi16","","Returns a new vector where the <code>imm8</code> element of <code>a</code> is …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_movemask_epi8","","Returns a mask of the most significant bit of each …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_shuffle_epi32","","Shuffles 32-bit integers in <code>a</code> using the control in <code>imm8</code>.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of <code>a</code> using …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of <code>a</code> using …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_add_pd","","Adds packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_pd","","Returns a new vector with the maximum values from …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_pd","","Returns a new vector with the minimum values from …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_pd","","Returns a new vector with the square root of each of the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_and_pd","","Computes the bitwise AND of packed double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_andnot_pd","","Computes the bitwise NOT of <code>a</code> and then AND with <code>b</code>.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_or_pd","","Computes the bitwise OR of <code>a</code> and <code>b</code>.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_xor_pd","","Computes the bitwise OR of <code>a</code> and <code>b</code>.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_sd","","Returns a new vector with the low element of <code>a</code> replaced …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for equality.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for less-than.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> to see if …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> to see if …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for not-equal.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_pd","","Compares corresponding elements in <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_comieq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for equality.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comilt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for less-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comile_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comigt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for greater-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comige_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_comineq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for not-equal.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomieq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for equality.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomilt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for less-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomile_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomigt_sd","","Compares the lower element of <code>a</code> and <code>b</code> for greater-than.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomige_sd","","Compares the lower element of <code>a</code> and <code>b</code> for …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_ucomineq_sd","","Compares the lower element of <code>a</code> and <code>b</code> for not-equal.",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_cvtps_pd","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvtsd_si32","","Converts the lower double-precision (64-bit) …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvtsd_ss","","Converts the lower double-precision (64-bit) …",null,[[["__m128d",3],["__m128",3]],["__m128",3]]],[5,"_mm_cvtsd_f64","","Returns the lower double-precision (64-bit) …",null,[[["__m128d",3]],["f64",15]]],[5,"_mm_cvtss_sd","","Converts the lower single-precision (32-bit) …",null,[[["__m128d",3],["__m128",3]],["__m128d",3]]],[5,"_mm_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvttsd_si32","","Converts the lower double-precision (64-bit) …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_set_sd","","Copies double-precision (64-bit) floating-point element <code>a</code> …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_set1_pd","","Broadcasts double-precision (64-bit) floating-point value …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_set_pd1","","Broadcasts double-precision (64-bit) floating-point value …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_set_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_setr_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m128d",3]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point …",null,[[],["__m128d",3]]],[5,"_mm_movemask_pd","","Returns a mask of the most significant bit of each …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_load_pd","","Loads 128-bits (composed of 2 packed double-precision …",null,[[],["__m128d",3]]],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element …",null,[[],["__m128d",3]]],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of <code>[2 x double]</code> to …",null,[[["__m128d",3]]]],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of …",null,[[["__m128d",3]]]],[5,"_mm_store_pd","","Stores 128-bits (composed of 2 packed double-precision …",null,[[["__m128d",3]]]],[5,"_mm_storeu_pd","","Stores 128-bits (composed of 2 packed double-precision …",null,[[["__m128d",3]]]],[5,"_mm_store1_pd","","Stores the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]]]],[5,"_mm_store_pd1","","Stores the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]]]],[5,"_mm_storer_pd","","Stores 2 double-precision (64-bit) floating-point …",null,[[["__m128d",3]]]],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of …",null,[[["__m128d",3]]]],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of …",null,[[["__m128d",3]]]],[5,"_mm_load1_pd","","Loads a double-precision (64-bit) floating-point element …",null,[[],["__m128d",3]]],[5,"_mm_load_pd1","","Loads a double-precision (64-bit) floating-point element …",null,[[],["__m128d",3]]],[5,"_mm_loadr_pd","","Loads 2 double-precision (64-bit) floating-point elements …",null,[[],["__m128d",3]]],[5,"_mm_loadu_pd","","Loads 128-bits (composed of 2 packed double-precision …",null,[[],["__m128d",3]]],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of <code>[2 x double]</code>…",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of <code>[2 x double]</code>…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of <code>[2 x double]</code> …",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of <code>[2 x double]</code> …",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of <code>[4 x float]</code> into …",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of <code>[4 x float]</code> into …",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit …",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_undefined_pd","","Returns vector of type __m128d with undefined elements.",null,[[],["__m128d",3]]],[5,"_mm_undefined_si128","","Returns vector of type __m128i with undefined elements.",null,[[],["__m128i",3]]],[5,"_mm_unpackhi_pd","","The resulting <code>__m128d</code> element is composed by the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_unpacklo_pd","","The resulting <code>__m128d</code> element is composed by the …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_pd","","Horizontally adds adjacent pairs of double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_ps","","Horizontally adds adjacent pairs of single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hsub_ps","","Horizontally adds adjacent pairs of single-precision …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_lddqu_si128","","Loads 128-bits of integer data from unaligned memory. …",null,[[],["__m128i",3]]],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loaddup_pd","","Loads a double-precision (64-bit) floating-point element …",null,[[],["__m128d",3]]],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_abs_epi8","","Computes the absolute value of packed 8-bit signed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi16","","Computes the absolute value of each of the packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi32","","Computes the absolute value of each of the packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shuffle_epi8","","Shuffles bytes from <code>a</code> according to the content of <code>b</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in <code>a</code> and <code>b</code> into a 32-byte …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_hadd_epi16","","Horizontally adds the adjacent pairs of values contained …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadds_epi16","","Horizontally adds the adjacent pairs of values contained …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadd_epi32","","Horizontally adds the adjacent pairs of values contained …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maddubs_epi16","","Multiplies corresponding pairs of packed 8-bit unsigned …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhrs_epi16","","Multiplies packed 16-bit signed integer values, truncate …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi8","","Negates packed 8-bit integers in <code>a</code> when the corresponding …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi16","","Negates packed 16-bit integers in <code>a</code> when the …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi32","","Negates packed 32-bit integers in <code>a</code> when the …",null,[[["__m128i",3]],["__m128i",3]]],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see <code>vendor::_MM_SET_ROUNDING_MODE</code>",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see …",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see …",null,null],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from <code>a</code> and <code>b</code> using <code>mask</code>",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from <code>a</code> and <code>b</code> using the mask …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_extract_ps","","Extracts a single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["i32",15]]],[5,"_mm_extract_epi8","","Extracts an 8-bit integer from <code>a</code>, selected with <code>imm8</code>. …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_extract_epi32","","Extracts an 32-bit integer from <code>a</code> selected with <code>imm8</code>",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_insert_ps","","Select a single value in <code>a</code> to store at some position in <code>b</code>,…",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_insert_epi8","","Returns a copy of <code>a</code> with the 8-bit integer from <code>i</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_insert_epi32","","Returns a copy of <code>a</code> with the 32-bit integer from <code>i</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_max_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for equality",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in <code>a</code> to packed 16-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in <code>a</code> to packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of <code>a</code> …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in <code>a</code> to packed 32-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in <code>a</code> to packed 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in <code>a</code> to packed 64-bit …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi16","","Zeroes extend packed unsigned 8-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi32","","Zeroes extend packed unsigned 8-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi64","","Zeroes extend packed unsigned 8-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi64","","Zeroes extend packed unsigned 16-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu32_epi64","","Zeroes extend packed unsigned 32-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit _…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi32","","Multiplies the packed 32-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in <code>a</code> 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer …",null,[[["__m128i",3]],["i32",15]]],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters <em>(Default)</em>",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in <code>a</code>, find if it is in <code>b</code> <em>(Default)</em>",null,null],[17,"_SIDD_CMP_RANGES","","For each character in <code>a</code>, determine if …",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by <code>a</code> and <code>b</code> are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results <em>(Default)</em>",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negates results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negates results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","<strong>Index only</strong>: return the least significant bit <em>(Default)</em>",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","<strong>Index only</strong>: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","<strong>Mask only</strong>: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","<strong>Mask only</strong>: return the byte mask",null,null],[5,"_mm_cmpistrm","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_cmpistri","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistrz","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistrc","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistrs","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistro","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpistra","","Compares packed strings with implicit lengths in <code>a</code> and <code>b</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrm","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_cmpestri","","Compares packed strings <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrz","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrc","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestrs","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestro","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_cmpestra","","Compares packed strings in <code>a</code> and <code>b</code> with lengths <code>la</code> and <code>lb</code> …",null,[[["__m128i",3],["i32",15]],["i32",15]]],[5,"_mm_crc32_u8","","Starting with the initial value in <code>crc</code>, return the …",null,[[["u8",15],["u32",15]],["u32",15]]],[5,"_mm_crc32_u16","","Starting with the initial value in <code>crc</code>, return the …",null,[[["u32",15],["u16",15]],["u32",15]]],[5,"_mm_crc32_u32","","Starting with the initial value in <code>crc</code>, return the …",null,[[["u32",15]],["u32",15]]],[5,"_mm_cmpgt_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_add_pd","","Adds packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_add_ps","","Adds packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_and_pd","","Computes the bitwise AND of a packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_and_ps","","Computes the bitwise AND of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_or_pd","","Computes the bitwise OR packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_or_ps","","Computes the bitwise OR packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_shuffle_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_shuffle_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_andnot_pd","","Computes the bitwise NOT of packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_andnot_ps","","Computes the bitwise NOT of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_max_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_max_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_min_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_min_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_mul_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_mul_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_addsub_pd","","Alternatively adds and subtracts packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_addsub_ps","","Alternatively adds and subtracts packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sub_pd","","Subtracts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_sub_ps","","Subtracts packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_ps","","Computes the division of each of the 8 packed 32-bit …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_pd","","Computes the division of each of the 4 packed 64-bit …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_pd","","Rounds packed double-precision (64-bit) floating point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_ceil_pd","","Rounds packed double-precision (64-bit) floating point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_floor_pd","","Rounds packed double-precision (64-bit) floating point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_ps","","Rounds packed single-precision (32-bit) floating point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_ceil_ps","","Rounds packed single-precision (32-bit) floating point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_floor_ps","","Rounds packed single-precision (32-bit) floating point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_ps","","Returns the square root of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_pd","","Returns the square root of packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_pd","","Blends packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_ps","","Blends packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_blendv_pd","","Blends packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blendv_ps","","Blends packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_dp_ps","","Conditionally multiplies the packed single-precision …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_xor_pd","","Computes the bitwise XOR of packed double-precision …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_xor_ps","","Computes the bitwise XOR of packed single-precision …",null,[[["__m256",3]],["__m256",3]]],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[5,"_mm_cmp_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm256_cmp_pd","","Compares packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm_cmp_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm256_cmp_ps","","Compares packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm_cmp_sd","","Compares the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm_cmp_ss","","Compares the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm256_cvtepi32_pd","","Converts packed 32-bit integers in <code>a</code> to packed …",null,[[["__m128i",3]],["__m256d",3]]],[5,"_mm256_cvtepi32_ps","","Converts packed 32-bit integers in <code>a</code> to packed …",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m128",3]]],[5,"_mm256_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_cvtps_pd","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m128",3]],["__m256d",3]]],[5,"_mm256_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point …",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_extractf128_ps","","Extracts 128 bits (composed of 4 packed single-precision …",null,[[["i32",15],["__m256",3]],["__m128",3]]],[5,"_mm256_extractf128_pd","","Extracts 128 bits (composed of 2 packed double-precision …",null,[[["i32",15],["__m256d",3]],["__m128d",3]]],[5,"_mm256_extractf128_si256","","Extracts 128 bits (composed of integer data) from <code>a</code>, …",null,[[["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_zeroall","","Zeroes the contents of all XMM or YMM registers.",null,[[]]],[5,"_mm256_zeroupper","","Zeroes the upper 128 bits of all YMM registers; the lower …",null,[[]]],[5,"_mm256_permutevar_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm_permutevar_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["__m128i",3],["__m128",3]],["__m128",3]]],[5,"_mm256_permute_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm_permute_ps","","Shuffles single-precision (32-bit) floating-point …",null,[[["i32",15],["__m128",3]],["__m128",3]]],[5,"_mm256_permutevar_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm_permutevar_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_permute_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm_permute_pd","","Shuffles double-precision (64-bit) floating-point …",null,[[["__m128d",3],["i32",15]],["__m128d",3]]],[5,"_mm256_permute2f128_ps","","Shuffles 256 bits (composed of 8 packed single-precision …",null,[[["i32",15],["__m256",3]],["__m256",3]]],[5,"_mm256_permute2f128_pd","","Shuffles 256 bits (composed of 4 packed double-precision …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_permute2f128_si256","","Shuffles 128-bits (composed of integer data) selected by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m256",3]]],[5,"_mm_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m128",3]]],[5,"_mm256_broadcast_sd","","Broadcasts a double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_broadcast_ps","","Broadcasts 128 bits from memory (composed of 4 packed …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_broadcast_pd","","Broadcasts 128 bits from memory (composed of 2 packed …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_insertf128_ps","","Copies <code>a</code> to result, then inserts 128 bits (composed of 4 …",null,[[["i32",15],["__m256",3],["__m128",3]],["__m256",3]]],[5,"_mm256_insertf128_pd","","Copies <code>a</code> to result, then inserts 128 bits (composed of 2 …",null,[[["__m128d",3],["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_insertf128_si256","","Copies <code>a</code> to result, then inserts 128 bits from <code>b</code> into …",null,[[["__m256i",3],["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_insert_epi8","","Copies <code>a</code> to result, and inserts the 8-bit integer <code>i</code> into …",null,[[["__m256i",3],["i32",15],["i8",15]],["__m256i",3]]],[5,"_mm256_insert_epi16","","Copies <code>a</code> to result, and inserts the 16-bit integer <code>i</code> into …",null,[[["__m256i",3],["i32",15],["i16",15]],["__m256i",3]]],[5,"_mm256_insert_epi32","","Copies <code>a</code> to result, and inserts the 32-bit integer <code>i</code> into …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_load_pd","","Loads 256-bits (composed of 4 packed double-precision …",null,[[],["__m256d",3]]],[5,"_mm256_store_pd","","Stores 256-bits (composed of 4 packed double-precision …",null,[[["__m256d",3]]]],[5,"_mm256_load_ps","","Loads 256-bits (composed of 8 packed single-precision …",null,[[],["__m256",3]]],[5,"_mm256_store_ps","","Stores 256-bits (composed of 8 packed single-precision …",null,[[["__m256",3]]]],[5,"_mm256_loadu_pd","","Loads 256-bits (composed of 4 packed double-precision …",null,[[],["__m256d",3]]],[5,"_mm256_storeu_pd","","Stores 256-bits (composed of 4 packed double-precision …",null,[[["__m256d",3]]]],[5,"_mm256_loadu_ps","","Loads 256-bits (composed of 8 packed single-precision …",null,[[],["__m256",3]]],[5,"_mm256_storeu_ps","","Stores 256-bits (composed of 8 packed single-precision …",null,[[["__m256",3]]]],[5,"_mm256_load_si256","","Loads 256-bits of integer data from memory into result. …",null,[[],["__m256i",3]]],[5,"_mm256_store_si256","","Stores 256-bits of integer data from <code>a</code> into memory. …",null,[[["__m256i",3]]]],[5,"_mm256_loadu_si256","","Loads 256-bits of integer data from memory into result. …",null,[[],["__m256i",3]]],[5,"_mm256_storeu_si256","","Stores 256-bits of integer data from <code>a</code> into memory. …",null,[[["__m256i",3]]]],[5,"_mm256_maskload_pd","","Loads packed double-precision (64-bit) floating-point …",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_maskstore_pd","","Stores packed double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__m256d",3]]]],[5,"_mm_maskload_pd","","Loads packed double-precision (64-bit) floating-point …",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_maskstore_pd","","Stores packed double-precision (64-bit) floating-point …",null,[[["__m128i",3],["__m128d",3]]]],[5,"_mm256_maskload_ps","","Loads packed single-precision (32-bit) floating-point …",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_maskstore_ps","","Stores packed single-precision (32-bit) floating-point …",null,[[["__m256i",3],["__m256",3]]]],[5,"_mm_maskload_ps","","Loads packed single-precision (32-bit) floating-point …",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_maskstore_ps","","Stores packed single-precision (32-bit) floating-point …",null,[[["__m128i",3],["__m128",3]]]],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_lddqu_si256","","Loads 256-bits of integer data from unaligned memory into …",null,[[],["__m256i",3]]],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a …",null,[[["__m256i",3]]]],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of …",null,[[["__m256d",3]]]],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a …",null,[[["__m256",3]]]],[5,"_mm256_rcp_ps","","Computes the approximate reciprocal of packed …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_rsqrt_ps","","Computes the approximate reciprocal square root of packed …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpackhi_pd","","Unpacks and interleave double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpackhi_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpacklo_pd","","Unpacks and interleave double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpacklo_ps","","Unpacks and interleave single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_testz_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_testc_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_testnzc_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_testz_pd","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm256_testc_pd","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm256_testnzc_pd","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm_testz_pd","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_testc_pd","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm_testnzc_pd","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128d",3]],["i32",15]]],[5,"_mm256_testz_ps","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256",3]],["i32",15]]],[5,"_mm256_testc_ps","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256",3]],["i32",15]]],[5,"_mm256_testnzc_ps","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256",3]],["i32",15]]],[5,"_mm_testz_ps","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_testc_ps","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128",3]],["i32",15]]],[5,"_mm_testnzc_ps","","Computes the bitwise AND of 128 bits (representing …",null,[[["__m128",3]],["i32",15]]],[5,"_mm256_movemask_pd","","Sets each bit of the returned mask based on the most …",null,[[["__m256d",3]],["i32",15]]],[5,"_mm256_movemask_ps","","Sets each bit of the returned mask based on the most …",null,[[["__m256",3]],["i32",15]]],[5,"_mm256_setzero_pd","","Returns vector of type __m256d with all elements set to …",null,[[],["__m256d",3]]],[5,"_mm256_setzero_ps","","Returns vector of type __m256 with all elements set to …",null,[[],["__m256",3]]],[5,"_mm256_setzero_si256","","Returns vector of type __m256i with all elements set to …",null,[[],["__m256i",3]]],[5,"_mm256_set_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_set_ps","","Sets packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m256",3]]],[5,"_mm256_set_epi8","","Sets packed 8-bit integers in returned vector with the …",null,[[["i8",15]],["__m256i",3]]],[5,"_mm256_set_epi16","","Sets packed 16-bit integers in returned vector with the …",null,[[["i16",15]],["__m256i",3]]],[5,"_mm256_set_epi32","","Sets packed 32-bit integers in returned vector with the …",null,[[["i32",15]],["__m256i",3]]],[5,"_mm256_set_epi64x","","Sets packed 64-bit integers in returned vector with the …",null,[[["i64",15]],["__m256i",3]]],[5,"_mm256_setr_pd","","Sets packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_setr_ps","","Sets packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m256",3]]],[5,"_mm256_setr_epi8","","Sets packed 8-bit integers in returned vector with the …",null,[[["i8",15]],["__m256i",3]]],[5,"_mm256_setr_epi16","","Sets packed 16-bit integers in returned vector with the …",null,[[["i16",15]],["__m256i",3]]],[5,"_mm256_setr_epi32","","Sets packed 32-bit integers in returned vector with the …",null,[[["i32",15]],["__m256i",3]]],[5,"_mm256_setr_epi64x","","Sets packed 64-bit integers in returned vector with the …",null,[[["i64",15]],["__m256i",3]]],[5,"_mm256_set1_pd","","Broadcasts double-precision (64-bit) floating-point value …",null,[[["f64",15]],["__m256d",3]]],[5,"_mm256_set1_ps","","Broadcasts single-precision (32-bit) floating-point value …",null,[[["f32",15]],["__m256",3]]],[5,"_mm256_set1_epi8","","Broadcasts 8-bit integer <code>a</code> to all elements of returned …",null,[[["i8",15]],["__m256i",3]]],[5,"_mm256_set1_epi16","","Broadcasts 16-bit integer <code>a</code> to all all elements of …",null,[[["i16",15]],["__m256i",3]]],[5,"_mm256_set1_epi32","","Broadcasts 32-bit integer <code>a</code> to all elements of returned …",null,[[["i32",15]],["__m256i",3]]],[5,"_mm256_set1_epi64x","","Broadcasts 64-bit integer <code>a</code> to all elements of returned …",null,[[["i64",15]],["__m256i",3]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,[[["__m256d",3]],["__m256",3]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,[[["__m256",3]],["__m256d",3]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,[[["__m256d",3]],["__m256i",3]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,[[["__m256",3]],["__m128",3]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,[[["__m256d",3]],["__m128d",3]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128 …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of <code>[8 x float]</code> …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of <code>[4 x double]</code>…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_undefined_ps","","Returns vector of type <code>__m256</code> with undefined elements.",null,[[],["__m256",3]]],[5,"_mm256_undefined_pd","","Returns vector of type <code>__m256d</code> with undefined elements.",null,[[],["__m256d",3]]],[5,"_mm256_undefined_si256","","Returns vector of type __m256i with undefined elements.",null,[[],["__m256i",3]]],[5,"_mm256_set_m128","","Sets packed __m256 returned vector with the supplied …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_set_m128d","","Sets packed __m256d returned vector with the supplied …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_set_m128i","","Sets packed __m256i returned vector with the supplied …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_setr_m128","","Sets packed __m256 returned vector with the supplied …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_setr_m128d","","Sets packed __m256d returned vector with the supplied …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_setr_m128i","","Sets packed __m256i returned vector with the supplied …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_loadu2_m128","","Loads two 128-bit values (composed of 4 packed …",null,[[],["__m256",3]]],[5,"_mm256_loadu2_m128d","","Loads two 128-bit values (composed of 2 packed …",null,[[],["__m256d",3]]],[5,"_mm256_loadu2_m128i","","Loads two 128-bit values (composed of integer data) from …",null,[[],["__m256i",3]]],[5,"_mm256_storeu2_m128","","Stores the high and low 128-bit halves (each composed of …",null,[[["__m256",3]]]],[5,"_mm256_storeu2_m128d","","Stores the high and low 128-bit halves (each composed of …",null,[[["__m256d",3]]]],[5,"_mm256_storeu2_m128i","","Stores the high and low 128-bit halves (each composed of …",null,[[["__m256i",3]]]],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of …",null,[[["__m256",3]],["f32",15]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in <code>a</code>…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi64","","Adds packed 64-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi32","","Adds packed 32-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi8","","Adds packed 8-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi16","","Adds packed 16-bit integers in <code>a</code> and <code>b</code> using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu8","","Adds packed unsigned 8-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu16","","Adds packed unsigned 16-bit integers in <code>a</code> and <code>b</code> using …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_alignr_epi8","","Concatenates pairs of 16-byte blocks in <code>a</code> and <code>b</code> into a …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_and_si256","","Computes the bitwise AND of 256 bits (representing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_andnot_si256","","Computes the bitwise NOT of 256 bits (representing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu16","","Averages packed unsigned 16-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu8","","Averages packed unsigned 8-bit integers in <code>a</code> and <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_blend_epi32","","Blends packed 32-bit integers from <code>a</code> and <code>b</code> using control …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_blend_epi32","","Blends packed 32-bit integers from <code>a</code> and <code>b</code> using control …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_blend_epi16","","Blends packed 16-bit integers from <code>a</code> and <code>b</code> using control …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_blendv_epi8","","Blends packed 8-bit integers from <code>a</code> and <code>b</code> using <code>mask</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from <code>a</code> to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastsd_pd","","Broadcasts the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_broadcastsd_pd","","Broadcasts the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_broadcastsi128_si256","","Broadcasts 128 bits of integer data from a to all 128-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastss_ps","","Broadcasts the low single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_broadcastss_ps","","Broadcasts the low single-precision (32-bit) …",null,[[["__m128",3]],["__m256",3]]],[5,"_mm_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi64","","Compares packed 64-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code> for …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in <code>a</code> to …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in <code>a</code> …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in <code>a</code> to 64-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in <code>a</code> to 16-bit …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in <code>a</code> …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in <code>a</code> …",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_extracti128_si256","","Extracts 128 bits (of integer data) from <code>a</code> selected with …",null,[[["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_hadd_epi16","","Horizontally adds adjacent pairs of 16-bit integers in <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadd_epi32","","Horizontally adds adjacent pairs of 32-bit integers in <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadds_epi16","","Horizontally adds adjacent pairs of 16-bit integers in <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm_mask_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128",3],["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm256_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256",3]]],[5,"_mm256_mask_i32gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["__m256",3],["i32",15]],["__m256",3]]],[5,"_mm_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128d",3],["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm256_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m256d",3]]],[5,"_mm256_mask_i32gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256d",3],["__m128i",3],["i32",15]],["__m256d",3]]],[5,"_mm_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_mask_i64gather_epi32","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["__m256i",3],["i32",15]],["__m128i",3]]],[5,"_mm_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm_mask_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128",3],["__m128i",3],["i32",15]],["__m128",3]]],[5,"_mm256_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m128",3]]],[5,"_mm256_mask_i64gather_ps","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128",3],["__m256i",3],["i32",15]],["__m128",3]]],[5,"_mm_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm256_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mask_i64gather_epi64","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm_mask_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m128d",3],["__m128i",3],["i32",15]],["__m128d",3]]],[5,"_mm256_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256i",3],["i32",15]],["__m256d",3]]],[5,"_mm256_mask_i64gather_pd","","Returns values from <code>slice</code> at offsets determined by …",null,[[["__m256d",3],["__m256i",3],["i32",15]],["__m256d",3]]],[5,"_mm256_inserti128_si256","","Copies <code>a</code> to <code>dst</code>, then insert 128 bits (of integer data) …",null,[[["__m256i",3],["__m128i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_madd_epi16","","Multiplies packed signed 16-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maddubs_epi16","","Vertically multiplies each unsigned 8-bit integer from <code>a</code> …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi32","","Loads packed 32-bit integers from memory pointed by …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi32","","Loads packed 32-bit integers from memory pointed by …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi64","","Loads packed 64-bit integers from memory pointed by …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi64","","Loads packed 64-bit integers from memory pointed by …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskstore_epi32","","Stores packed 32-bit integers from <code>a</code> into memory pointed …",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi32","","Stores packed 32-bit integers from <code>a</code> into memory pointed …",null,[[["__m256i",3]]]],[5,"_mm_maskstore_epi64","","Stores packed 64-bit integers from <code>a</code> into memory pointed …",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi64","","Stores packed 64-bit integers from <code>a</code> into memory pointed …",null,[[["__m256i",3]]]],[5,"_mm256_max_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi16","","Compares packed 16-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi32","","Compares packed 32-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi8","","Compares packed 8-bit integers in <code>a</code> and <code>b</code>, and returns …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu16","","Compares packed unsigned 16-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu32","","Compares packed unsigned 32-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu8","","Compares packed unsigned 8-bit integers in <code>a</code> and <code>b</code>, and …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_movemask_epi8","","Creates mask from the most significant bit of each 8-bit …",null,[[["__m256i",3]],["i32",15]]],[5,"_mm256_mpsadbw_epu8","","Computes the sum of absolute differences (SADs) of …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_mul_epi32","","Multiplies the low 32-bit integers from each packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mul_epu32","","Multiplies the low unsigned 32-bit integers from each …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in <code>a</code> and <code>b</code>…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi16","","Multiplies the packed 16-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi32","","Multiplies the packed 32-bit integers in <code>a</code> and <code>b</code>, …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhrs_epi16","","Multiplies packed 16-bit integers in <code>a</code> and <code>b</code>, producing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_or_si256","","Computes the bitwise OR of 256 bits (representing integer …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi16","","Converts packed 16-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi32","","Converts packed 32-bit integers from <code>a</code> and <code>b</code> to packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from <code>a</code> according to the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from <code>a</code> using control mask <code>imm8</code>.",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_permute2x128_si256","","Shuffles 128-bits of integer data selected by <code>imm8</code> from <code>a</code> …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_permute4x64_pd","","Shuffles 64-bit floating-point elements in <code>a</code> across lanes …",null,[[["i32",15],["__m256d",3]],["__m256d",3]]],[5,"_mm256_permutevar8x32_ps","","Shuffles eight 32-bit foating-point elements in <code>a</code> across …",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm256_sad_epu8","","Computes the absolute differences of packed unsigned …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi8","","Shuffles bytes from <code>a</code> according to the content of <code>b</code>.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi32","","Shuffles 32-bit integers in 128-bit lanes of <code>a</code> using the …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of 128-bit …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of 128-bit …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_sign_epi16","","Negates packed 16-bit integers in <code>a</code> when the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi32","","Negates packed 32-bit integers in <code>a</code> when the …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi8","","Negates packed 8-bit integers in <code>a</code> when the corresponding …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_sll_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_sll_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_slli_epi16","","Shifts packed 16-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_slli_epi32","","Shifts packed 32-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_slli_epi64","","Shifts packed 64-bit integers in <code>a</code> left by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_slli_si256","","Shifts 128-bit lanes in <code>a</code> left by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_bslli_epi128","","Shifts 128-bit lanes in <code>a</code> left by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_sllv_epi32","","Shifts packed 32-bit integers in <code>a</code> left by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi32","","Shifts packed 32-bit integers in <code>a</code> left by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_sllv_epi64","","Shifts packed 64-bit integers in <code>a</code> left by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi64","","Shifts packed 64-bit integers in <code>a</code> left by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sra_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_sra_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srai_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srai_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_srav_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srav_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_si256","","Shifts 128-bit lanes in <code>a</code> right by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_bsrli_epi128","","Shifts 128-bit lanes in <code>a</code> right by <code>imm8</code> bytes while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srl_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srl_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srl_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>count</code> while …",null,[[["__m256i",3],["__m128i",3]],["__m256i",3]]],[5,"_mm256_srli_epi16","","Shifts packed 16-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srli_epi32","","Shifts packed 32-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm256_srli_epi64","","Shifts packed 64-bit integers in <code>a</code> right by <code>imm8</code> while …",null,[[["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm_srlv_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi32","","Shifts packed 32-bit integers in <code>a</code> right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srlv_epi64","","Shifts packed 64-bit integers in <code>a</code> right by the amount …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi64","","Shifts packed 64-bit integers in <code>a</code> right by the amount …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in <code>b</code> from packed 32-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in <code>b</code> from packed 64-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in <code>b</code> from packed 16-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in <code>b</code> from packed 8-bit …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in <code>b</code> from packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in <code>b</code> from packed …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_xor_si256","","Computes the bitwise XOR of 256 bits (representing …",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_extract_epi8","","Extracts an 8-bit integer from <code>a</code>, selected with <code>imm8</code>. …",null,[[["__m256i",3],["i32",15]],["i32",15]]],[5,"_mm256_extract_epi16","","Extracts a 16-bit integer from <code>a</code>, selected with <code>imm8</code>. …",null,[[["__m256i",3],["i32",15]],["i32",15]]],[5,"_mm256_extract_epi32","","Extracts a 32-bit integer from <code>a</code>, selected with <code>imm8</code>.",null,[[["__m256i",3],["i32",15]],["i32",15]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of …",null,[[["__m256d",3]],["f64",15]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of <code>[8 x i32]</code>…",null,[[["__m256i",3]],["i32",15]]],[5,"_mm_fmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmadd_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmadd_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmaddsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmaddsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmaddsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmaddsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmsub_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmsubadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsubadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsubadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsubadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmadd_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmadd_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmadd_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fnmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmsub_pd","","Multiplies packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmsub_ps","","Multiplies packed single-precision (32-bit) …",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmsub_sd","","Multiplies the lower double-precision (64-bit) …",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmsub_ss","","Multiplies the lower single-precision (32-bit) …",null,[[["__m128",3]],["__m128",3]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,[[["u32",15]],["u32",15]]],[5,"_popcnt32","","Counts the bits that are set.",null,[[["i32",15]],["i32",15]]],[5,"_bextr_u32","","Extracts bits in range [<code>start</code>, <code>start</code> + <code>length</code>) from <code>a</code> into…",null,[[["u32",15]],["u32",15]]],[5,"_bextr2_u32","","Extracts bits of <code>a</code> specified by <code>control</code> into the least …",null,[[["u32",15]],["u32",15]]],[5,"_andn_u32","","Bitwise logical <code>AND</code> of inverted <code>a</code> with <code>b</code>.",null,[[["u32",15]],["u32",15]]],[5,"_blsi_u32","","Extracts lowest set isolated bit.",null,[[["u32",15]],["u32",15]]],[5,"_blsmsk_u32","","Gets mask up to lowest set bit.",null,[[["u32",15]],["u32",15]]],[5,"_blsr_u32","","Resets the lowest set bit of <code>x</code>.",null,[[["u32",15]],["u32",15]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,[[["u32",15]],["u32",15]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,[[["u32",15]],["i32",15]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,[[["u32",15],["u32",15]],["u32",15]]],[5,"_bzhi_u32","","Zeroes higher bits of <code>a</code> >= <code>index</code>.",null,[[["u32",15]],["u32",15]]],[5,"_pdep_u32","","Scatter contiguous low order bits of <code>a</code> to the result at …",null,[[["u32",15]],["u32",15]]],[5,"_pext_u32","","Gathers the bits of <code>x</code> specified by the <code>mask</code> into the …",null,[[["u32",15]],["u32",15]]],[5,"_mm_extract_si64","","Extracts the bit range specified by <code>y</code> from the lower 64 …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_insert_si64","","Inserts the <code>[length:0]</code> bits of <code>y</code> into <code>x</code> at <code>index</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_stream_sd","","Non-temporal store of <code>a.0</code> into <code>p</code>.",null,[[["__m128d",3]]]],[5,"_mm_stream_ss","","Non-temporal store of <code>a.0</code> into <code>p</code>.",null,[[["__m128",3]]]],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of <code>x</code>.",null,[[["u32",15]],["u32",15]]],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of <code>x</code>.",null,[[["u64",15]],["u64",15]]],[5,"_blci_u32","","Sets all bits of <code>x</code> to 1 except for the least significant …",null,[[["u32",15]],["u32",15]]],[5,"_blci_u64","","Sets all bits of <code>x</code> to 1 except for the least significant …",null,[[["u64",15]],["u64",15]]],[5,"_blcic_u32","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u32",15]],["u32",15]]],[5,"_blcic_u64","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u64",15]],["u64",15]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u32",15]],["u32",15]]],[5,"_blcmsk_u64","","Sets the least significant zero bit of <code>x</code> and clears all …",null,[[["u64",15]],["u64",15]]],[5,"_blcs_u32","","Sets the least significant zero bit of <code>x</code>.",null,[[["u32",15]],["u32",15]]],[5,"_blcs_u64","","Sets the least significant zero bit of <code>x</code>.",null,[[["u64",15]],["u64",15]]],[5,"_blsfill_u32","","Sets all bits of <code>x</code> below the least significant one.",null,[[["u32",15]],["u32",15]]],[5,"_blsfill_u64","","Sets all bits of <code>x</code> below the least significant one.",null,[[["u64",15]],["u64",15]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,[[["u32",15]],["u32",15]]],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,[[["u64",15]],["u64",15]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of <code>x</code> and …",null,[[["u32",15]],["u32",15]]],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of <code>x</code> and …",null,[[["u64",15]],["u64",15]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of <code>x</code> and …",null,[[["u32",15]],["u32",15]]],[5,"_tzmsk_u64","","Sets all bits below the least significant one of <code>x</code> and …",null,[[["u64",15]],["u64",15]]],[5,"_mm_clmulepi64_si128","","Performs a carry-less multiplication of two 64-bit …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_aesdec_si128","","Performs one round of an AES decryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesdeclast_si128","","Performs the last round of an AES decryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenc_si128","","Performs one round of an AES encryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenclast_si128","","Performs the last round of an AES encryption flow on data …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesimc_si128","","Performs the <code>InvMixColumns</code> transformation on <code>a</code>.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store …",null,[[["u16",15]],["i32",15]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store …",null,[[["u32",15]],["i32",15]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant …",null,[[["u16",15]],["i32",15]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant …",null,[[["u32",15]],["i32",15]]],[5,"_mm_sha1msg1_epu32","","Performs an intermediate calculation for the next four …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1msg2_epu32","","Performs the final calculation for the next four SHA1 …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1rnds4_epu32","","Performs four rounds of SHA1 operation using an initial …",null,[[["__m128i",3],["i32",15]],["__m128i",3]]],[5,"_mm_sha256msg1_epu32","","Performs an intermediate calculation for the next four …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256msg2_epu32","","Performs the final calculation for the next four SHA256 …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256rnds2_epu32","","Performs 2 rounds of SHA256 operation using an initial …",null,[[["__m128i",3]],["__m128i",3]]],[5,"_addcarry_u32","","Adds unsigned 32-bit integers <code>a</code> and <code>b</code> with unsigned 8-bit …",null,[[["u8",15],["u32",15],["u32",15]],["u8",15]]],[5,"_addcarryx_u32","","Adds unsigned 32-bit integers <code>a</code> and <code>b</code> with unsigned 8-bit …",null,[[["u8",15],["u32",15],["u32",15]],["u8",15]]],[5,"_subborrow_u32","","Adds unsigned 32-bit integers <code>a</code> and <code>b</code> with unsigned 8-bit …",null,[[["u8",15],["u32",15],["u32",15]],["u8",15]]],[5,"ud2","","Generates the trap instruction <code>UD2</code>",null,[[]]],[5,"_mm512_abs_epi32","","Computes the absolute values of packed 32-bit integers in …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi32","","Computes the absolute value of packed 32-bit integers in <code>a</code>…",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi32","","Computes the absolute value of packed 32-bit integers in <code>a</code>…",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_abs_epi64","","Compute the absolute value of packed signed 64-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi64","","Compute the absolute value of packed signed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi64","","Compute the absolute value of packed signed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_abs_ps","","Finds the absolute value of each packed single-precision …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_abs_ps","","Finds the absolute value of each packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_abs_pd","","Finds the absolute value of each packed double-precision …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_abs_pd","","Finds the absolute value of each packed double-precision …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_mask_mov_epi32","","Move packed 32-bit integers from a to dst using writemask …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mov_epi32","","Move packed 32-bit integers from a into dst using …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mov_epi64","","Move packed 64-bit integers from a to dst using writemask …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mov_epi64","","Move packed 64-bit integers from a into dst using …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mov_ps","","Move packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_mov_ps","","Move packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_mov_pd","","Move packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_mov_pd","","Move packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_add_epi32","","Add packed 32-bit integers in a and b, and store the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_add_epi32","","Add packed 32-bit integers in a and b, and store the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_add_epi32","","Add packed 32-bit integers in a and b, and store the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_add_epi64","","Add packed 64-bit integers in a and b, and store the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_add_epi64","","Add packed 64-bit integers in a and b, and store the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_add_epi64","","Add packed 64-bit integers in a and b, and store the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_add_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_add_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_add_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_add_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_add_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_add_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_sub_epi32","","Subtract packed 32-bit integers in b from packed 32-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sub_epi32","","Subtract packed 32-bit integers in b from packed 32-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sub_epi32","","Subtract packed 32-bit integers in b from packed 32-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sub_epi64","","Subtract packed 64-bit integers in b from packed 64-bit …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sub_epi64","","Subtract packed 64-bit integers in b from packed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sub_epi64","","Subtract packed 64-bit integers in b from packed 64-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sub_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sub_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sub_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sub_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mul_epi32","","Multiply the low signed 32-bit integers from each packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mul_epi32","","Multiply the low signed 32-bit integers from each packed …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mul_epi32","","Multiply the low signed 32-bit integers from each packed …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mullo_epi32","","Multiply the packed 32-bit integers in a and b, producing …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mullo_epi32","","Multiply the packed 32-bit integers in a and b, producing …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mullo_epi32","","Multiply the packed 32-bit integers in a and b, producing …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mullox_epi64","","Multiplies elements in packed 64-bit integer vectors a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mullox_epi64","","Multiplies elements in packed 64-bit integer vectors a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mul_epu32","","Multiply the low unsigned 32-bit integers from each …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_mul_epu32","","Multiply the low unsigned 32-bit integers from each …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_mul_epu32","","Multiply the low unsigned 32-bit integers from each …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mul_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_mul_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_mul_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mul_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_mul_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_mul_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_div_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_div_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_div_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_div_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_max_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_max_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_max_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_max_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_max_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_max_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_max_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_max_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_max_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_max_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_max_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_max_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epi32","","Compare packed signed 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epi64","","Compare packed signed 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_min_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_min_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_min_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_min_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_min_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_min_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epu32","","Compare packed unsigned 32-bit integers in a and b, and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_min_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_min_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_min_epu64","","Compare packed unsigned 64-bit integers in a and b, and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sqrt_ps","","Compute the square root of packed single-precision …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sqrt_ps","","Compute the square root of packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sqrt_ps","","Compute the square root of packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sqrt_pd","","Compute the square root of packed double-precision …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sqrt_pd","","Compute the square root of packed double-precision …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sqrt_pd","","Compute the square root of packed double-precision …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmaddsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmaddsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmaddsub_pd","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsubadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsubadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmadd_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmadd_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmsub_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmsub_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_rcp14_ps","","Compute the approximate reciprocal of packed …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_rcp14_ps","","Compute the approximate reciprocal of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_rcp14_ps","","Compute the approximate reciprocal of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_rcp14_pd","","Compute the approximate reciprocal of packed …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_rcp14_pd","","Compute the approximate reciprocal of packed …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_rcp14_pd","","Compute the approximate reciprocal of packed …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_rsqrt14_ps","","Compute the approximate reciprocal square root of packed …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_rsqrt14_ps","","Compute the approximate reciprocal square root of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_rsqrt14_ps","","Compute the approximate reciprocal square root of packed …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_rsqrt14_pd","","Compute the approximate reciprocal square root of packed …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_rsqrt14_pd","","Compute the approximate reciprocal square root of packed …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_rsqrt14_pd","","Compute the approximate reciprocal square root of packed …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_getexp_ps","","Convert the exponent of each packed single-precision …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_getexp_ps","","Convert the exponent of each packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_getexp_ps","","Convert the exponent of each packed single-precision …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_getexp_pd","","Convert the exponent of each packed double-precision …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_getexp_pd","","Convert the exponent of each packed double-precision …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getexp_pd","","Convert the exponent of each packed double-precision …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_roundscale_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_roundscale_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_roundscale_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_roundscale_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_roundscale_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_roundscale_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_scalef_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_scalef_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_scalef_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_scalef_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_scalef_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_scalef_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fixupimm_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_fixupimm_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_fixupimm_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_fixupimm_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_fixupimm_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_fixupimm_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_ternarylogic_epi32","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ternarylogic_epi32","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ternarylogic_epi32","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_ternarylogic_epi64","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ternarylogic_epi64","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ternarylogic_epi64","","Bitwise ternary logic that provides the capability to …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_getmant_ps","","Normalize the mantissas of packed single-precision …",null,[[["_mm_mantissa_sign_enum",6],["__m512",3],["_mm_mantissa_norm_enum",6]],["__m512",3]]],[5,"_mm512_mask_getmant_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6]],["__m512",3]]],[5,"_mm512_maskz_getmant_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6]],["__m512",3]]],[5,"_mm512_getmant_pd","","Normalize the mantissas of packed double-precision …",null,[[["_mm_mantissa_sign_enum",6],["__m512d",3],["_mm_mantissa_norm_enum",6]],["__m512d",3]]],[5,"_mm512_mask_getmant_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getmant_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_add_round_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_add_round_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_add_round_ps","","Add packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_add_round_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_add_round_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_add_round_pd","","Add packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_sub_round_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sub_round_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sub_round_ps","","Subtract packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sub_round_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sub_round_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sub_round_pd","","Subtract packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mul_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_mul_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_mul_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mul_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_mul_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_mul_round_pd","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_div_round_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_div_round_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_div_round_ps","","Divide packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_div_round_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_div_round_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_div_round_pd","","Divide packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_sqrt_round_ps","","Compute the square root of packed single-precision …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_sqrt_round_ps","","Compute the square root of packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_sqrt_round_ps","","Compute the square root of packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_sqrt_round_pd","","Compute the square root of packed double-precision …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_sqrt_round_pd","","Compute the square root of packed double-precision …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_sqrt_round_pd","","Compute the square root of packed double-precision …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmaddsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmaddsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmaddsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmaddsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmaddsub_round_pd","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fmsubadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fmsubadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmadd_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmadd_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask3_fnmsub_round_ps","","Multiply packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask3_fnmsub_round_pd","","Multiply packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_max_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_max_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_max_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_max_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_max_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_max_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_min_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_min_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_min_round_ps","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_min_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_min_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_min_round_pd","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_getexp_round_ps","","Convert the exponent of each packed single-precision …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_getexp_round_ps","","Convert the exponent of each packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_getexp_round_ps","","Convert the exponent of each packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_getexp_round_pd","","Convert the exponent of each packed double-precision …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_getexp_round_pd","","Convert the exponent of each packed double-precision …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getexp_round_pd","","Convert the exponent of each packed double-precision …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_roundscale_round_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_roundscale_round_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_roundscale_round_ps","","Round packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15]],["__m512",3]]],[5,"_mm512_roundscale_round_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_roundscale_round_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_roundscale_round_pd","","Round packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_scalef_round_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_scalef_round_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_scalef_round_ps","","Scale the packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_scalef_round_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_scalef_round_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_scalef_round_pd","","Scale the packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_fixupimm_round_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_fixupimm_round_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_fixupimm_round_ps","","Fix up packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_fixupimm_round_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_fixupimm_round_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_fixupimm_round_pd","","Fix up packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_getmant_round_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512",3]]],[5,"_mm512_mask_getmant_round_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_getmant_round_ps","","Normalize the mantissas of packed single-precision …",null,[[["__m512",3],["__mmask16",6],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512",3]]],[5,"_mm512_getmant_round_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15]],["__m512d",3]]],[5,"_mm512_mask_getmant_round_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_getmant_round_pd","","Normalize the mantissas of packed double-precision …",null,[[["__m512d",3],["_mm_mantissa_norm_enum",6],["_mm_mantissa_sign_enum",6],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m256",3]],["__m512d",3]]],[5,"_mm512_mask_cvtps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m256",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvtps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m256",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtpslo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512",3]],["__m512d",3]]],[5,"_mm512_mask_cvtpslo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m256",3]]],[5,"_mm512_mask_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m256",3],["__mmask8",6],["__m512d",3]],["__m256",3]]],[5,"_mm512_maskz_cvtpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m256",3]]],[5,"_mm512_cvtpd_pslo","","Performs an element-by-element conversion of packed …",null,[[["__m512d",3]],["__m512",3]]],[5,"_mm512_mask_cvtpd_pslo","","Performs an element-by-element conversion of packed …",null,[[["__m512",3],["__mmask8",6],["__m512d",3]],["__m512",3]]],[5,"_mm512_cvtepi8_epi32","","Sign extend packed 8-bit integers in a to packed 32-bit …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi8_epi32","","Sign extend packed 8-bit integers in a to packed 32-bit …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi8_epi32","","Sign extend packed 8-bit integers in a to packed 32-bit …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of a …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of a …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of a …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu8_epi32","","Zero extend packed unsigned 8-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in the low 8 …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in the low 8 …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu8_epi64","","Zero extend packed unsigned 8-bit integers in the low 8 …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepi16_epi32","","Sign extend packed 16-bit integers in a to packed 32-bit …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi16_epi32","","Sign extend packed 16-bit integers in a to packed 32-bit …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi16_epi32","","Sign extend packed 16-bit integers in a to packed 32-bit …",null,[[["__m256i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepi16_epi64","","Sign extend packed 16-bit integers in a to packed 64-bit …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi16_epi64","","Sign extend packed 16-bit integers in a to packed 64-bit …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi16_epi64","","Sign extend packed 16-bit integers in a to packed 64-bit …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu16_epi32","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m256i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu16_epi64","","Zero extend packed unsigned 16-bit integers in a to …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepi32_epi64","","Sign extend packed 32-bit integers in a to packed 64-bit …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepi32_epi64","","Sign extend packed 32-bit integers in a to packed 64-bit …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepi32_epi64","","Sign extend packed 32-bit integers in a to packed 64-bit …",null,[[["__m256i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in a to …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in a to …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtepu32_epi64","","Zero extend packed unsigned 32-bit integers in a to …",null,[[["__m256i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_cvtepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvtepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvtepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvtepi32_pd","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepi32_pd","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvtepi32_pd","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvtepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvtepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvtepu32_pd","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepu32_pd","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvtepu32_pd","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepi32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepi32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepu32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_cvtepu32lo_pd","","Performs element-by-element conversion of the lower half …",null,[[["__m512i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvtepi32_epi16","","Convert packed 32-bit integers in a to packed 16-bit …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtepi32_epi16","","Convert packed 32-bit integers in a to packed 16-bit …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtepi32_epi16","","Convert packed 32-bit integers in a to packed 16-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtepi32_epi8","","Convert packed 32-bit integers in a to packed 8-bit …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtepi32_epi8","","Convert packed 32-bit integers in a to packed 8-bit …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtepi32_epi8","","Convert packed 32-bit integers in a to packed 8-bit …",null,[[["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtepi64_epi32","","Convert packed 64-bit integers in a to packed 32-bit …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtepi64_epi32","","Convert packed 64-bit integers in a to packed 32-bit …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtepi64_epi32","","Convert packed 64-bit integers in a to packed 32-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtepi64_epi16","","Convert packed 64-bit integers in a to packed 16-bit …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtepi64_epi16","","Convert packed 64-bit integers in a to packed 16-bit …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtepi64_epi16","","Convert packed 64-bit integers in a to packed 16-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtepi64_epi8","","Convert packed 64-bit integers in a to packed 8-bit …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtepi64_epi8","","Convert packed 64-bit integers in a to packed 8-bit …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtepi64_epi8","","Convert packed 64-bit integers in a to packed 8-bit …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtsepi32_epi16","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtsepi32_epi16","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtsepi32_epi16","","Convert packed signed 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtsepi32_epi8","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtsepi32_epi8","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtsepi32_epi8","","Convert packed signed 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtsepi64_epi32","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtsepi64_epi32","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtsepi64_epi32","","Convert packed signed 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtsepi64_epi16","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtsepi64_epi16","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtsepi64_epi16","","Convert packed signed 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtsepi64_epi8","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtsepi64_epi8","","Convert packed signed 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtsepi64_epi8","","Convert packed signed 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtusepi32_epi16","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtusepi32_epi16","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m256i",3],["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtusepi32_epi16","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtusepi32_epi8","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtusepi32_epi8","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtusepi32_epi8","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__mmask16",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtusepi64_epi32","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_cvtusepi64_epi32","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_cvtusepi64_epi32","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_cvtusepi64_epi16","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtusepi64_epi16","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtusepi64_epi16","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvtusepi64_epi8","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_cvtusepi64_epi8","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_cvtusepi64_epi8","","Convert packed unsigned 64-bit integers in a to packed …",null,[[["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_cvt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvt_roundps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3]],["__m512d",3]]],[5,"_mm512_mask_cvt_roundps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__m256",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_cvt_roundps_pd","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m256",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_cvt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_maskz_cvt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_maskz_cvt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvt_roundpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256",3]]],[5,"_mm512_mask_cvt_roundpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__m256",3],["__mmask8",6]],["__m256",3]]],[5,"_mm512_maskz_cvt_roundpd_ps","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256",3]]],[5,"_mm512_cvt_roundepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvt_roundepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvt_roundepi32_ps","","Convert packed signed 32-bit integers in a to packed …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvt_roundepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_cvt_roundepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_cvt_roundepu32_ps","","Convert packed unsigned 32-bit integers in a to packed …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_cvt_roundps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m256i",3]]],[5,"_mm512_mask_cvt_roundps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm512_maskz_cvt_roundps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm512_cvtps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m256i",3]]],[5,"_mm512_mask_cvtps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m256i",3],["i32",15]],["__m256i",3]]],[5,"_mm512_maskz_cvtps_ph","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m256i",3]]],[5,"_mm512_cvt_roundph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["i32",15]],["__m512",3]]],[5,"_mm512_mask_cvt_roundph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m256i",3],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_cvt_roundph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["i32",15],["__mmask16",6]],["__m512",3]]],[5,"_mm512_cvtph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3]],["__m512",3]]],[5,"_mm512_mask_cvtph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_cvtph_ps","","Convert packed half-precision (16-bit) floating-point …",null,[[["__m256i",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_cvtt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtt_roundps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvtt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvtt_roundps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvtt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvtt_roundpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_maskz_cvtt_roundpd_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvtt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvtt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m256i",3]]],[5,"_mm512_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvttps_epi32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_cvttps_epu32","","Convert packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_mask_cvttps_epu32","","Convert packed double-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_cvttps_epu32","","Convert packed double-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_maskz_cvtt_roundpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_maskz_cvttpd_epi32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_cvttpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__m256i",3]]],[5,"_mm512_mask_cvttpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__m256i",3],["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_maskz_cvttpd_epu32","","Convert packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m256i",3]]],[5,"_mm512_setzero_pd","","Returns vector of type <code>__m512d</code> with all elements set to …",null,[[],["__m512d",3]]],[5,"_mm512_setzero_ps","","Returns vector of type <code>__m512d</code> with all elements set to …",null,[[],["__m512",3]]],[5,"_mm512_setzero","","Return vector of type __m512 with all elements set to …",null,[[],["__m512",3]]],[5,"_mm512_setzero_si512","","Returns vector of type <code>__m512i</code> with all elements set to …",null,[[],["__m512i",3]]],[5,"_mm512_setzero_epi32","","Return vector of type __m512i with all elements set to …",null,[[],["__m512i",3]]],[5,"_mm512_setr_epi32","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_set_epi8","","Set packed 8-bit integers in dst with the supplied values.",null,[[["i8",15]],["__m512i",3]]],[5,"_mm512_set_epi16","","Set packed 16-bit integers in dst with the supplied …",null,[[["i16",15]],["__m512i",3]]],[5,"_mm512_set4_epi32","","Set packed 32-bit integers in dst with the repeated 4 …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_set4_ps","","Set packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_set4_pd","","Set packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_setr4_epi32","","Set packed 32-bit integers in dst with the repeated 4 …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_setr4_ps","","Set packed single-precision (32-bit) floating-point …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_setr4_pd","","Set packed double-precision (64-bit) floating-point …",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_set_epi64","","Set packed 64-bit integers in dst with the supplied …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_setr_epi64","","Set packed 64-bit integers in dst with the supplied …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_i32gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["__m256i",3],["i32",15]],["__m512d",3]]],[5,"_mm512_mask_i32gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m256i",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_i64gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_i64gather_pd","","Gather double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_i64gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512i",3]],["__m256",3]]],[5,"_mm512_mask_i64gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m256",3],["__mmask8",6],["__m512i",3]],["__m256",3]]],[5,"_mm512_i32gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_i32gather_ps","","Gather single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]],["__m512",3]]],[5,"_mm512_i32gather_epi32","","Gather 32-bit integers from memory using 32-bit indices. …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_i32gather_epi32","","Gather 32-bit integers from memory using 32-bit indices. …",null,[[["__mmask16",6],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_i32gather_epi64","","Gather 64-bit integers from memory using 32-bit indices. …",null,[[["__m256i",3],["i32",15]],["__m512i",3]]],[5,"_mm512_mask_i32gather_epi64","","Gather 64-bit integers from memory using 32-bit indices. …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_i64gather_epi64","","Gather 64-bit integers from memory using 64-bit indices. …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_i64gather_epi64","","Gather 64-bit integers from memory using 64-bit indices. …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_i64gather_epi32","","Gather 32-bit integers from memory using 64-bit indices. …",null,[[["i32",15],["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_i64gather_epi32","","Gather 32-bit integers from memory using 64-bit indices. …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_i32scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m256i",3],["i32",15]]]],[5,"_mm512_mask_i32scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m256i",3],["__mmask8",6],["i32",15]]]],[5,"_mm512_i64scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_pd","","Scatter double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["i32",15],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i32scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i32scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["i32",15],["__m512i",3]]]],[5,"_mm512_i64scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m256",3],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_ps","","Scatter single-precision (32-bit) floating-point elements …",null,[[["__m256",3],["i32",15],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i32scatter_epi64","","Scatter 64-bit integers from a into memory using 32-bit …",null,[[["__m256i",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i32scatter_epi64","","Scatter 64-bit integers from a into memory using 32-bit …",null,[[["i32",15],["__m256i",3],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i64scatter_epi64","","Scatter 64-bit integers from a into memory using 64-bit …",null,[[["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_epi64","","Scatter 64-bit integers from a into memory using 64-bit …",null,[[["i32",15],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_i32scatter_epi32","","Scatter 32-bit integers from a into memory using 32-bit …",null,[[["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i32scatter_epi32","","Scatter 32-bit integers from a into memory using 32-bit …",null,[[["__mmask16",6],["i32",15],["__m512i",3]]]],[5,"_mm512_i64scatter_epi32","","Scatter 32-bit integers from a into memory using 64-bit …",null,[[["__m256i",3],["i32",15],["__m512i",3]]]],[5,"_mm512_mask_i64scatter_epi32","","Scatter 32-bit integers from a into memory using 64-bit …",null,[[["i32",15],["__m256i",3],["__mmask8",6],["__m512i",3]]]],[5,"_mm512_mask_compress_epi32","","Contiguously store the active 32-bit integers in a (those …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_compress_epi32","","Contiguously store the active 32-bit integers in a (those …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_compress_epi64","","Contiguously store the active 64-bit integers in a (those …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_compress_epi64","","Contiguously store the active 64-bit integers in a (those …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_compress_ps","","Contiguously store the active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_compress_ps","","Contiguously store the active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_compress_pd","","Contiguously store the active double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_compress_pd","","Contiguously store the active double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_expand_epi32","","Load contiguous active 32-bit integers from a (those with …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_expand_epi32","","Load contiguous active 32-bit integers from a (those with …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_expand_epi64","","Load contiguous active 64-bit integers from a (those with …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_expand_epi64","","Load contiguous active 64-bit integers from a (those with …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_expand_ps","","Load contiguous active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_expand_ps","","Load contiguous active single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_expand_pd","","Load contiguous active double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_expand_pd","","Load contiguous active double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_rol_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rol_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rol_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_ror_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ror_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ror_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rol_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rol_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rol_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_ror_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_ror_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_ror_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_slli_epi32","","Shift packed 32-bit integers in a left by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_slli_epi32","","Shift packed 32-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_slli_epi32","","Shift packed 32-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srli_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srli_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srli_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_slli_epi64","","Shift packed 64-bit integers in a left by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_slli_epi64","","Shift packed 64-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_slli_epi64","","Shift packed 64-bit integers in a left by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srli_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srli_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srli_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sll_epi32","","Shift packed 32-bit integers in a left by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sll_epi32","","Shift packed 32-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sll_epi32","","Shift packed 32-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srl_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srl_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srl_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sll_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sll_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sll_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srl_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srl_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srl_epi64","","Shift packed 64-bit integers in a left by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sra_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sra_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sra_epi32","","Shift packed 32-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sra_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sra_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sra_epi64","","Shift packed 64-bit integers in a right by count while …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srai_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srai_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srai_epi32","","Shift packed 32-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srai_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srai_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srai_epi64","","Shift packed 64-bit integers in a right by imm8 while …",null,[[["u32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srav_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srav_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srav_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srav_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srav_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srav_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rolv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rolv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rolv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rorv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rorv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rorv_epi32","","Rotate the bits in each packed 32-bit integer in a to the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rolv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rolv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rolv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_rorv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_rorv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_rorv_epi64","","Rotate the bits in each packed 64-bit integer in a to the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sllv_epi32","","Shift packed 32-bit integers in a left by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sllv_epi32","","Shift packed 32-bit integers in a left by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sllv_epi32","","Shift packed 32-bit integers in a left by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srlv_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srlv_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srlv_epi32","","Shift packed 32-bit integers in a right by the amount …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_sllv_epi64","","Shift packed 64-bit integers in a left by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_sllv_epi64","","Shift packed 64-bit integers in a left by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_sllv_epi64","","Shift packed 64-bit integers in a left by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_srlv_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_srlv_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_srlv_epi64","","Shift packed 64-bit integers in a right by the amount …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permute_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_permute_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_permute_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_permute_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_permute_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_permute_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_permutex_epi64","","Shuffle 64-bit integers in a within 256-bit lanes using …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex_epi64","","Shuffle 64-bit integers in a within 256-bit lanes using …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex_epi64","","Shuffle 64-bit integers in a within 256-bit lanes using …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutex_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_permutex_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_permutex_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_permutevar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutevar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_permutevar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512i",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_permutevar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512i",3],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_permutexvar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutexvar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutexvar_epi32","","Shuffle 32-bit integers in a across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutexvar_epi64","","Shuffle 64-bit integers in a across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutexvar_epi64","","Shuffle 64-bit integers in a across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutexvar_epi64","","Shuffle 64-bit integers in a across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutexvar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_permutexvar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_permutexvar_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_permutexvar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_permutexvar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_permutexvar_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask2_permutex2var_epi32","","Shuffle 32-bit integers in a and b across lanes using the …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask2_permutex2var_epi64","","Shuffle 64-bit integers in a and b across lanes using the …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_maskz_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_mask2_permutex2var_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["__m512",3],["__mmask16",6],["__m512i",3]],["__m512",3]]],[5,"_mm512_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_maskz_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_mask2_permutex2var_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["__m512d",3],["__mmask8",6],["__m512i",3]],["__m512d",3]]],[5,"_mm512_shuffle_epi32","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["_mm_perm_enum",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_epi32","","Shuffle 32-bit integers in a within 128-bit lanes using …",null,[[["_mm_perm_enum",6],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_epi32","","Shuffle 32-bit integers in a within 128-bit lanes using …",null,[[["_mm_perm_enum",6],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_shuffle_ps","","Shuffle single-precision (32-bit) floating-point elements …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_shuffle_pd","","Shuffle double-precision (64-bit) floating-point elements …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_shuffle_i32x4","","Shuffle 128-bits (composed of 4 32-bit integers) selected …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_i32x4","","Shuffle 128-bits (composed of 4 32-bit integers) selected …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_i32x4","","Shuffle 128-bits (composed of 4 32-bit integers) selected …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_i64x2","","Shuffle 128-bits (composed of 2 64-bit integers) selected …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_shuffle_i64x2","","Shuffle 128-bits (composed of 2 64-bit integers) selected …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_shuffle_i64x2","","Shuffle 128-bits (composed of 2 64-bit integers) selected …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_shuffle_f32x4","","Shuffle 128-bits (composed of 4 single-precision (32-bit) …",null,[[["i32",15],["__m512",3]],["__m512",3]]],[5,"_mm512_mask_shuffle_f32x4","","Shuffle 128-bits (composed of 4 single-precision (32-bit) …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_shuffle_f32x4","","Shuffle 128-bits (composed of 4 single-precision (32-bit) …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_shuffle_f64x2","","Shuffle 128-bits (composed of 2 double-precision (64-bit) …",null,[[["i32",15],["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_shuffle_f64x2","","Shuffle 128-bits (composed of 2 double-precision (64-bit) …",null,[[["i32",15],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_shuffle_f64x2","","Shuffle 128-bits (composed of 2 double-precision (64-bit) …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_extractf32x4_ps","","Extract 128 bits (composed of 4 packed single-precision …",null,[[["i32",15],["__m512",3]],["__m128",3]]],[5,"_mm512_mask_extractf32x4_ps","","Extract 128 bits (composed of 4 packed single-precision …",null,[[["__m512",3],["__m128",3],["i32",15],["__mmask8",6]],["__m128",3]]],[5,"_mm512_maskz_extractf32x4_ps","","Extract 128 bits (composed of 4 packed single-precision …",null,[[["i32",15],["__m512",3],["__mmask8",6]],["__m128",3]]],[5,"_mm512_extracti64x4_epi64","","Extract 256 bits (composed of 4 packed 64-bit integers) …",null,[[["i32",15],["__m512i",3]],["__m256i",3]]],[5,"_mm512_mask_extracti64x4_epi64","","Extract 256 bits (composed of 4 packed 64-bit integers) …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_maskz_extracti64x4_epi64","","Extract 256 bits (composed of 4 packed 64-bit integers) …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m256i",3]]],[5,"_mm512_extractf64x4_pd","","Extract 256 bits (composed of 4 packed double-precision …",null,[[["i32",15],["__m512d",3]],["__m256d",3]]],[5,"_mm512_mask_extractf64x4_pd","","Extract 256 bits (composed of 4 packed double-precision …",null,[[["__m512d",3],["__m256d",3],["i32",15],["__mmask8",6]],["__m256d",3]]],[5,"_mm512_maskz_extractf64x4_pd","","Extract 256 bits (composed of 4 packed double-precision …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__m256d",3]]],[5,"_mm512_extracti32x4_epi32","","Extract 128 bits (composed of 4 packed 32-bit integers) …",null,[[["i32",15],["__m512i",3]],["__m128i",3]]],[5,"_mm512_mask_extracti32x4_epi32","","Extract 128 bits (composed of 4 packed 32-bit integers) …",null,[[["__m128i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_maskz_extracti32x4_epi32","","Extract 128 bits (composed of 4 packed 32-bit integers) …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m128i",3]]],[5,"_mm512_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_moveldup_ps","","Duplicate even-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_movedup_pd","","Duplicate even-indexed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_inserti32x4","","Copy a to dst, then insert 128 bits (composed of 4 packed …",null,[[["__m128i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_inserti32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__mmask16",6],["__m128i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_inserti32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__mmask16",6],["__m128i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_inserti64x4","","Copy a to dst, then insert 256 bits (composed of 4 packed …",null,[[["__m256i",3],["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_inserti64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_inserti64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m256i",3],["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_insertf32x4","","Copy a to dst, then insert 128 bits (composed of 4 packed …",null,[[["i32",15],["__m512",3],["__m128",3]],["__m512",3]]],[5,"_mm512_mask_insertf32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__m512",3],["__mmask16",6],["__m128",3],["i32",15]],["__m512",3]]],[5,"_mm512_maskz_insertf32x4","","Copy a to tmp, then insert 128 bits (composed of 4 packed …",null,[[["__m512",3],["__mmask16",6],["__m128",3],["i32",15]],["__m512",3]]],[5,"_mm512_insertf64x4","","Copy a to dst, then insert 256 bits (composed of 4 packed …",null,[[["i32",15],["__m512d",3],["__m256d",3]],["__m512d",3]]],[5,"_mm512_mask_insertf64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m512d",3],["__m256d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_insertf64x4","","Copy a to tmp, then insert 256 bits (composed of 4 packed …",null,[[["__m512d",3],["__m256d",3],["i32",15],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpackhi_epi32","","Unpack and interleave 32-bit integers from the high half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpackhi_epi64","","Unpack and interleave 64-bit integers from the high half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpackhi_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_unpackhi_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_unpackhi_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_unpackhi_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_unpackhi_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_unpackhi_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpacklo_epi32","","Unpack and interleave 32-bit integers from the low half …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_unpacklo_epi64","","Unpack and interleave 64-bit integers from the low half …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_unpacklo_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3]],["__m512",3]]],[5,"_mm512_mask_unpacklo_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_maskz_unpacklo_ps","","Unpack and interleave single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_unpacklo_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3]],["__m512d",3]]],[5,"_mm512_mask_unpacklo_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_unpacklo_pd","","Unpack and interleave double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_castps128_ps512","","Cast vector of type __m128 to type __m512; the upper 384 …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_castps256_ps512","","Cast vector of type __m256 to type __m512; the upper 256 …",null,[[["__m256",3]],["__m512",3]]],[5,"_mm512_zextps128_ps512","","Cast vector of type __m128 to type __m512; the upper 384 …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_zextps256_ps512","","Cast vector of type __m256 to type __m512; the upper 256 …",null,[[["__m256",3]],["__m512",3]]],[5,"_mm512_castps512_ps128","","Cast vector of type __m512 to type __m128. This intrinsic …",null,[[["__m512",3]],["__m128",3]]],[5,"_mm512_castps512_ps256","","Cast vector of type __m512 to type __m256. This intrinsic …",null,[[["__m512",3]],["__m256",3]]],[5,"_mm512_castps_pd","","Cast vector of type __m512 to type __m512d. This …",null,[[["__m512",3]],["__m512d",3]]],[5,"_mm512_castps_si512","","Cast vector of type __m512 to type __m512i. This …",null,[[["__m512",3]],["__m512i",3]]],[5,"_mm512_castpd128_pd512","","Cast vector of type __m128d to type __m512d; the upper …",null,[[["__m128d",3]],["__m512d",3]]],[5,"_mm512_castpd256_pd512","","Cast vector of type __m256d to type __m512d; the upper …",null,[[["__m256d",3]],["__m512d",3]]],[5,"_mm512_zextpd128_pd512","","Cast vector of type __m128d to type __m512d; the upper …",null,[[["__m128d",3]],["__m512d",3]]],[5,"_mm512_zextpd256_pd512","","Cast vector of type __m256d to type __m512d; the upper …",null,[[["__m256d",3]],["__m512d",3]]],[5,"_mm512_castpd512_pd128","","Cast vector of type __m512d to type __m128d. This …",null,[[["__m512d",3]],["__m128d",3]]],[5,"_mm512_castpd512_pd256","","Cast vector of type __m512d to type __m256d. This …",null,[[["__m512d",3]],["__m256d",3]]],[5,"_mm512_castpd_ps","","Cast vector of type __m512d to type __m512. This …",null,[[["__m512d",3]],["__m512",3]]],[5,"_mm512_castpd_si512","","Cast vector of type __m512d to type __m512i. This …",null,[[["__m512d",3]],["__m512i",3]]],[5,"_mm512_castsi128_si512","","Cast vector of type __m128i to type __m512i; the upper …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_castsi256_si512","","Cast vector of type __m256i to type __m512i; the upper …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_zextsi128_si512","","Cast vector of type __m128i to type __m512i; the upper …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_zextsi256_si512","","Cast vector of type __m256i to type __m512i; the upper …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_castsi512_si128","","Cast vector of type __m512i to type __m128i. This …",null,[[["__m512i",3]],["__m128i",3]]],[5,"_mm512_castsi512_si256","","Cast vector of type __m512i to type __m256i. This …",null,[[["__m512i",3]],["__m256i",3]]],[5,"_mm512_castsi512_ps","","Cast vector of type __m512i to type __m512. This …",null,[[["__m512i",3]],["__m512",3]]],[5,"_mm512_castsi512_pd","","Cast vector of type __m512i to type __m512d. This …",null,[[["__m512i",3]],["__m512d",3]]],[5,"_mm512_broadcastd_epi32","","Broadcast the low packed 32-bit integer from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcastd_epi32","","Broadcast the low packed 32-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcastd_epi32","","Broadcast the low packed 32-bit integer from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_broadcastq_epi64","","Broadcast the low packed 64-bit integer from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcastq_epi64","","Broadcast the low packed 64-bit integer from a to all …",null,[[["__m128i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcastq_epi64","","Broadcast the low packed 64-bit integer from a to all …",null,[[["__m128i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_broadcastss_ps","","Broadcast the low single-precision (32-bit) …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_mask_broadcastss_ps","","Broadcast the low single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_maskz_broadcastss_ps","","Broadcast the low single-precision (32-bit) …",null,[[["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_broadcastsd_pd","","Broadcast the low double-precision (64-bit) …",null,[[["__m128d",3]],["__m512d",3]]],[5,"_mm512_mask_broadcastsd_pd","","Broadcast the low double-precision (64-bit) …",null,[[["__m128d",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_broadcastsd_pd","","Broadcast the low double-precision (64-bit) …",null,[[["__m128d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_broadcast_i32x4","","Broadcast the 4 packed 32-bit integers from a to all …",null,[[["__m128i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcast_i32x4","","Broadcast the 4 packed 32-bit integers from a to all …",null,[[["__m128i",3],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcast_i32x4","","Broadcast the 4 packed 32-bit integers from a to all …",null,[[["__m128i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_broadcast_i64x4","","Broadcast the 4 packed 64-bit integers from a to all …",null,[[["__m256i",3]],["__m512i",3]]],[5,"_mm512_mask_broadcast_i64x4","","Broadcast the 4 packed 64-bit integers from a to all …",null,[[["__m256i",3],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_broadcast_i64x4","","Broadcast the 4 packed 64-bit integers from a to all …",null,[[["__m256i",3],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_broadcast_f32x4","","Broadcast the 4 packed single-precision (32-bit) …",null,[[["__m128",3]],["__m512",3]]],[5,"_mm512_mask_broadcast_f32x4","","Broadcast the 4 packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_maskz_broadcast_f32x4","","Broadcast the 4 packed single-precision (32-bit) …",null,[[["__mmask16",6],["__m128",3]],["__m512",3]]],[5,"_mm512_broadcast_f64x4","","Broadcast the 4 packed double-precision (64-bit) …",null,[[["__m256d",3]],["__m512d",3]]],[5,"_mm512_mask_broadcast_f64x4","","Broadcast the 4 packed double-precision (64-bit) …",null,[[["__m256d",3],["__m512d",3],["__mmask8",6]],["__m512d",3]]],[5,"_mm512_maskz_broadcast_f64x4","","Broadcast the 4 packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m256d",3]],["__m512d",3]]],[5,"_mm512_mask_blend_epi32","","Blend packed 32-bit integers from a and b using control …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_blend_epi64","","Blend packed 64-bit integers from a and b using control …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_blend_ps","","Blend packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__m512",3]]],[5,"_mm512_mask_blend_pd","","Blend packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__m512d",3]]],[5,"_mm512_alignr_epi32","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_alignr_epi32","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_alignr_epi32","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_alignr_epi64","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_alignr_epi64","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_alignr_epi64","","Concatenate a and b into a 128-byte immediate result, …",null,[[["i32",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_and_epi32","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_and_epi32","","Performs element-by-element bitwise AND between packed …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_and_epi32","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_and_epi64","","Compute the bitwise AND of 512 bits (composed of packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_and_epi64","","Compute the bitwise AND of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_and_epi64","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_and_si512","","Compute the bitwise AND of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_or_epi32","","Compute the bitwise OR of packed 32-bit integers in a and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_or_epi32","","Compute the bitwise OR of packed 32-bit integers in a and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_or_epi32","","Compute the bitwise OR of packed 32-bit integers in a and …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_or_epi64","","Compute the bitwise OR of packed 64-bit integers in a and …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_or_epi64","","Compute the bitwise OR of packed 64-bit integers in a and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_or_epi64","","Compute the bitwise OR of packed 64-bit integers in a and …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_or_si512","","Compute the bitwise OR of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_xor_epi32","","Compute the bitwise XOR of packed 32-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_xor_epi32","","Compute the bitwise XOR of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_xor_epi32","","Compute the bitwise XOR of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_xor_epi64","","Compute the bitwise XOR of packed 64-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_xor_epi64","","Compute the bitwise XOR of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_xor_epi64","","Compute the bitwise XOR of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_xor_si512","","Compute the bitwise XOR of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_andnot_epi32","","Compute the bitwise NOT of packed 32-bit integers in a …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_andnot_epi32","","Compute the bitwise NOT of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_andnot_epi32","","Compute the bitwise NOT of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_andnot_epi64","","Compute the bitwise NOT of 512 bits (composed of packed …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_andnot_epi64","","Compute the bitwise NOT of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_andnot_epi64","","Compute the bitwise NOT of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_andnot_si512","","Compute the bitwise NOT of 512 bits (representing integer …",null,[[["__m512i",3]],["__m512i",3]]],[5,"_kand_mask16","","Compute the bitwise AND of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kand","","Compute the bitwise AND of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kor_mask16","","Compute the bitwise OR of 16-bit masks a and b, and store …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kor","","Compute the bitwise OR of 16-bit masks a and b, and store …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kxor_mask16","","Compute the bitwise XOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kxor","","Compute the bitwise XOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_knot_mask16","","Compute the bitwise NOT of 16-bit mask a, and store the …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_knot","","Compute the bitwise NOT of 16-bit mask a, and store the …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kandn_mask16","","Compute the bitwise NOT of 16-bit masks a and then AND …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kandn","","Compute the bitwise NOT of 16-bit masks a and then AND …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_kxnor_mask16","","Compute the bitwise XNOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kxnor","","Compute the bitwise XNOR of 16-bit masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kmov","","Copy 16-bit mask a to k.",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_int2mask","","Converts integer mask into bitmask, storing the result in …",null,[[["i32",15]],["__mmask16",6]]],[5,"_mm512_mask2int","","Converts bit mask k1 into an integer value, storing the …",null,[[["__mmask16",6]],["i32",15]]],[5,"_mm512_kunpackb","","Unpack and interleave 8 bits from masks a and b, and …",null,[[["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_kortestc","","Performs bitwise OR between k1 and k2, storing the result …",null,[[["__mmask16",6]],["i32",15]]],[5,"_mm512_test_epi32_mask","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_test_epi32_mask","","Compute the bitwise AND of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_test_epi64_mask","","Compute the bitwise AND of packed 64-bit integers in a …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_test_epi64_mask","","Compute the bitwise AND of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_testn_epi32_mask","","Compute the bitwise NAND of packed 32-bit integers in a …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_testn_epi32_mask","","Compute the bitwise NAND of packed 32-bit integers in a …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_testn_epi64_mask","","Compute the bitwise NAND of packed 64-bit integers in a …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_testn_epi64_mask","","Compute the bitwise NAND of packed 64-bit integers in a …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_stream_ps","","Store 512-bits (composed of 16 packed single-precision …",null,[[["__m512",3]]]],[5,"_mm512_stream_pd","","Store 512-bits (composed of 8 packed double-precision …",null,[[["__m512d",3]]]],[5,"_mm512_stream_si512","","Store 512-bits of integer data from a into memory using a …",null,[[["__m512i",3]]]],[5,"_mm512_set_ps","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_setr_ps","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_set1_pd","","Broadcast 64-bit float <code>a</code> to all elements of <code>dst</code>.",null,[[["f64",15]],["__m512d",3]]],[5,"_mm512_set1_ps","","Broadcast 32-bit float <code>a</code> to all elements of <code>dst</code>.",null,[[["f32",15]],["__m512",3]]],[5,"_mm512_set_epi32","","Sets packed 32-bit integers in <code>dst</code> with the supplied …",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_set1_epi8","","Broadcast 8-bit integer a to all elements of dst.",null,[[["i8",15]],["__m512i",3]]],[5,"_mm512_set1_epi16","","Broadcast the low packed 16-bit integer from a to all all …",null,[[["i16",15]],["__m512i",3]]],[5,"_mm512_set1_epi32","","Broadcast 32-bit integer <code>a</code> to all elements of <code>dst</code>.",null,[[["i32",15]],["__m512i",3]]],[5,"_mm512_mask_set1_epi32","","Broadcast 32-bit integer a to all elements of dst using …",null,[[["i32",15],["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_set1_epi32","","Broadcast 32-bit integer a to all elements of dst using …",null,[[["i32",15],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_set1_epi64","","Broadcast 64-bit integer <code>a</code> to all elements of <code>dst</code>.",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_mask_set1_epi64","","Broadcast 64-bit integer a to all elements of dst using …",null,[[["i64",15],["__mmask8",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_set1_epi64","","Broadcast 64-bit integer a to all elements of dst using …",null,[[["i64",15],["__mmask8",6]],["__m512i",3]]],[5,"_mm512_set4_epi64","","Set packed 64-bit integers in dst with the repeated 4 …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_setr4_epi64","","Set packed 64-bit integers in dst with the repeated 4 …",null,[[["i64",15]],["__m512i",3]]],[5,"_mm512_cmplt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmplt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpnlt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpnlt_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmple_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmple_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpnle_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpnle_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpeq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpeq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpneq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpneq_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmp_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmp_round_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["i32",15],["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_round_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6],["i32",15]],["__mmask16",6]]],[5,"_mm512_cmpord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmpunord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpunord_ps_mask","","Compare packed single-precision (32-bit) floating-point …",null,[[["__m512",3],["__mmask16",6]],["__mmask16",6]]],[5,"_mm512_cmplt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpnlt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpnlt_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmple_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpnle_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpnle_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpeq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpneq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpneq_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmp_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmp_round_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["i32",15],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_round_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm512_cmpunord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__m512d",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpunord_pd_mask","","Compare packed double-precision (64-bit) floating-point …",null,[[["__mmask8",6],["__m512d",3]],["__mmask8",6]]],[5,"_mm_cmp_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__mmask8",6]]],[5,"_mm_mask_cmp_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__mmask8",6],["__m128",3]],["__mmask8",6]]],[5,"_mm_cmp_round_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["i32",15],["__m128",3]],["__mmask8",6]]],[5,"_mm_mask_cmp_round_ss_mask","","Compare the lower single-precision (32-bit) …",null,[[["__m128",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm_cmp_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__mmask8",6]]],[5,"_mm_mask_cmp_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm_cmp_round_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15]],["__mmask8",6]]],[5,"_mm_mask_cmp_round_sd_mask","","Compare the lower double-precision (64-bit) …",null,[[["__m128d",3],["i32",15],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmplt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmplt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpgt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpgt_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmple_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmple_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpge_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpge_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpeq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpeq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpneq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpneq_epu32_mask","","Compare packed unsigned 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmp_epu32_mask","","Compare packed unsigned 32-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_epu32_mask","","Compare packed unsigned 32-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmplt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmplt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpgt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpgt_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmple_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmple_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpge_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpge_epi32_mask","","Compare packed signed 32-bit integers in a and b for …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpeq_epi32_mask","","Compare packed 32-bit integers in a and b for equality, …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpeq_epi32_mask","","Compare packed 32-bit integers in a and b for equality, …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmpneq_epi32_mask","","Compare packed 32-bit integers in a and b for not-equal, …",null,[[["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmpneq_epi32_mask","","Compare packed 32-bit integers in a and b for not-equal, …",null,[[["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmp_epi32_mask","","Compare packed signed 32-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_mask_cmp_epi32_mask","","Compare packed signed 32-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__mmask16",6],["__m512i",3]],["__mmask16",6]]],[5,"_mm512_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpneq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpneq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmp_epu64_mask","","Compare packed unsigned 64-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_epu64_mask","","Compare packed unsigned 64-bit integers in a and b based …",null,[[["_mm_cmpint_enum",6],["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmplt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpgt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmple_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpge_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpeq_epi64_mask","","Compare packed 64-bit integers in a and b for equality, …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epi64_mask","","Compare packed 64-bit integers in a and b for equality, …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmpneq_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpneq_epi64_mask","","Compare packed signed 64-bit integers in a and b for …",null,[[["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_cmp_epi64_mask","","Compare packed signed 64-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmp_epi64_mask","","Compare packed signed 64-bit integers in a and b based on …",null,[[["_mm_cmpint_enum",6],["__mmask8",6],["__m512i",3]],["__mmask8",6]]],[5,"_mm512_reduce_add_epi32","","Reduce the packed 32-bit integers in a by addition. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_add_epi32","","Reduce the packed 32-bit integers in a by addition using …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_add_epi64","","Reduce the packed 64-bit integers in a by addition. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_add_epi64","","Reduce the packed 64-bit integers in a by addition using …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_add_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_add_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_add_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_add_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_mul_epi32","","Reduce the packed 32-bit integers in a by multiplication. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_mul_epi32","","Reduce the packed 32-bit integers in a by multiplication …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_mul_epi64","","Reduce the packed 64-bit integers in a by multiplication. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_mul_epi64","","Reduce the packed 64-bit integers in a by multiplication …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_mul_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_mul_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_mul_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_mul_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_max_epi32","","Reduce the packed signed 32-bit integers in a by maximum. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_max_epi32","","Reduce the packed signed 32-bit integers in a by maximum …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_max_epi64","","Reduce the packed signed 64-bit integers in a by maximum. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_max_epi64","","Reduce the packed signed 64-bit integers in a by maximum …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_max_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__m512i",3]],["u32",15]]],[5,"_mm512_mask_reduce_max_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__mmask16",6],["__m512i",3]],["u32",15]]],[5,"_mm512_reduce_max_epu64","","Reduce the packed unsigned 64-bit integers in a by …",null,[[["__m512i",3]],["u64",15]]],[5,"_mm512_mask_reduce_max_epu64","","Reduce the packed unsigned 64-bit integers in a by …",null,[[["__mmask8",6],["__m512i",3]],["u64",15]]],[5,"_mm512_reduce_max_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_max_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_max_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_max_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_min_epi32","","Reduce the packed signed 32-bit integers in a by minimum. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_min_epi32","","Reduce the packed signed 32-bit integers in a by maximum …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_min_epi64","","Reduce the packed signed 64-bit integers in a by minimum. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_min_epi64","","Reduce the packed signed 64-bit integers in a by maximum …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_min_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__m512i",3]],["u32",15]]],[5,"_mm512_mask_reduce_min_epu32","","Reduce the packed unsigned 32-bit integers in a by …",null,[[["__mmask16",6],["__m512i",3]],["u32",15]]],[5,"_mm512_reduce_min_epu64","","Reduce the packed unsigned 64-bit integers in a by …",null,[[["__m512i",3]],["u64",15]]],[5,"_mm512_mask_reduce_min_epu64","","Reduce the packed signed 64-bit integers in a by maximum …",null,[[["__mmask8",6],["__m512i",3]],["u64",15]]],[5,"_mm512_reduce_min_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3]],["f32",15]]],[5,"_mm512_mask_reduce_min_ps","","Reduce the packed single-precision (32-bit) …",null,[[["__m512",3],["__mmask16",6]],["f32",15]]],[5,"_mm512_reduce_min_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__m512d",3]],["f64",15]]],[5,"_mm512_mask_reduce_min_pd","","Reduce the packed double-precision (64-bit) …",null,[[["__mmask8",6],["__m512d",3]],["f64",15]]],[5,"_mm512_reduce_and_epi32","","Reduce the packed 32-bit integers in a by bitwise AND. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_and_epi32","","Reduce the packed 32-bit integers in a by bitwise AND …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_and_epi64","","Reduce the packed 64-bit integers in a by bitwise AND. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_and_epi64","","Reduce the packed 64-bit integers in a by addition using …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_reduce_or_epi32","","Reduce the packed 32-bit integers in a by bitwise OR. …",null,[[["__m512i",3]],["i32",15]]],[5,"_mm512_mask_reduce_or_epi32","","Reduce the packed 32-bit integers in a by bitwise OR …",null,[[["__mmask16",6],["__m512i",3]],["i32",15]]],[5,"_mm512_reduce_or_epi64","","Reduce the packed 64-bit integers in a by bitwise OR. …",null,[[["__m512i",3]],["i64",15]]],[5,"_mm512_mask_reduce_or_epi64","","Reduce the packed 64-bit integers in a by bitwise OR …",null,[[["__mmask8",6],["__m512i",3]],["i64",15]]],[5,"_mm512_undefined_pd","","Returns vector of type <code>__m512d</code> with undefined elements.",null,[[],["__m512d",3]]],[5,"_mm512_undefined_ps","","Returns vector of type <code>__m512</code> with undefined elements.",null,[[],["__m512",3]]],[5,"_mm512_undefined_epi32","","Return vector of type __m512i with undefined elements.",null,[[],["__m512i",3]]],[5,"_mm512_undefined","","Return vector of type __m512 with undefined elements.",null,[[],["__m512",3]]],[5,"_mm512_loadu_epi32","","Load 512-bits (composed of 16 packed 32-bit integers) …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_epi32","","Store 512-bits (composed of 16 packed 32-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_loadu_epi64","","Load 512-bits (composed of 8 packed 64-bit integers) from …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_epi64","","Store 512-bits (composed of 8 packed 64-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_loadu_si512","","Load 512-bits of integer data from memory into dst. …",null,[[],["__m512i",3]]],[5,"_mm512_storeu_si512","","Store 512-bits of integer data from a into memory. …",null,[[["__m512i",3]]]],[5,"_mm512_loadu_pd","","Loads 512-bits (composed of 8 packed double-precision …",null,[[],["__m512d",3]]],[5,"_mm512_storeu_pd","","Stores 512-bits (composed of 8 packed double-precision …",null,[[["__m512d",3]]]],[5,"_mm512_loadu_ps","","Loads 512-bits (composed of 16 packed single-precision …",null,[[],["__m512",3]]],[5,"_mm512_storeu_ps","","Stores 512-bits (composed of 16 packed single-precision …",null,[[["__m512",3]]]],[5,"_mm512_load_si512","","Load 512-bits of integer data from memory into dst. …",null,[[],["__m512i",3]]],[5,"_mm512_store_si512","","Store 512-bits of integer data from a into memory. …",null,[[["__m512i",3]]]],[5,"_mm512_load_epi32","","Load 512-bits (composed of 16 packed 32-bit integers) …",null,[[],["__m512i",3]]],[5,"_mm512_store_epi32","","Store 512-bits (composed of 16 packed 32-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_load_epi64","","Load 512-bits (composed of 8 packed 64-bit integers) from …",null,[[],["__m512i",3]]],[5,"_mm512_store_epi64","","Store 512-bits (composed of 8 packed 64-bit integers) …",null,[[["__m512i",3]]]],[5,"_mm512_load_ps","","Load 512-bits (composed of 16 packed single-precision …",null,[[],["__m512",3]]],[5,"_mm512_store_ps","","Store 512-bits of integer data from a into memory. …",null,[[["__m512",3]]]],[5,"_mm512_load_pd","","Load 512-bits (composed of 8 packed double-precision …",null,[[],["