/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.codecs;
import org.python.expose.ExposedType;
import org.python.modules._codecs$EncodingMap$PyExposer;

public class _codecs {
    public static void register(PyObject search_function) {
        codecs.register(search_function);
    }

    private static String _castString(PyString pystr) {
        if (pystr == null) {
            return null;
        }
        String s = pystr.toString();
        if (pystr instanceof PyUnicode) {
            return s;
        }
        return codecs.PyUnicode_EncodeASCII(s, s.length(), null);
    }

    public static PyTuple lookup(PyString encoding) {
        return codecs.lookup(_codecs._castString(encoding));
    }

    public static PyObject lookup_error(PyString handlerName) {
        return codecs.lookup_error(_codecs._castString(handlerName));
    }

    public static void register_error(String name, PyObject errorHandler) {
        codecs.register_error(name, errorHandler);
    }

    public static PyObject decode(PyString bytes) {
        return _codecs.decode(bytes, null, null);
    }

    public static PyObject decode(PyString bytes, PyString encoding) {
        return _codecs.decode(bytes, encoding, null);
    }

    public static PyObject decode(PyString bytes, PyString encoding, PyString errors) {
        return codecs.decode(bytes, _codecs._castString(encoding), _codecs._castString(errors));
    }

    public static PyString encode(PyUnicode unicode) {
        return _codecs.encode(unicode, null, null);
    }

    public static PyString encode(PyUnicode unicode, PyString encoding) {
        return _codecs.encode(unicode, encoding, null);
    }

    public static PyString encode(PyUnicode unicode, PyString encoding, PyString errors) {
        return Py.newString(codecs.encode(unicode, _codecs._castString(encoding), _codecs._castString(errors)));
    }

    public static PyObject charmap_build(PyUnicode map) {
        return EncodingMap.buildEncodingMap(map);
    }

    private static PyTuple decode_tuple(String u, int bytesConsumed) {
        return new PyTuple(new PyUnicode(u), Py.newInteger(bytesConsumed));
    }

    private static PyTuple decode_tuple(String u, int[] consumed, int defConsumed) {
        return _codecs.decode_tuple(u, consumed != null ? consumed[0] : defConsumed);
    }

    private static PyTuple decode_tuple(String u, int bytesConsumed, ByteOrder order) {
        int bo = order.code();
        return new PyTuple(new PyUnicode(u), Py.newInteger(bytesConsumed), Py.newInteger(bo));
    }

    private static PyTuple decode_tuple_str(String s, int len) {
        return new PyTuple(new PyString(s), Py.newInteger(len));
    }

    private static PyTuple encode_tuple(String s, int len) {
        return new PyTuple(new PyString(s), Py.newInteger(len));
    }

    public static PyTuple utf_8_decode(String str) {
        return _codecs.utf_8_decode(str, null);
    }

    public static PyTuple utf_8_decode(String str, String errors) {
        return _codecs.utf_8_decode(str, errors, false);
    }

    public static PyTuple utf_8_decode(String str, String errors, PyObject final_) {
        return _codecs.utf_8_decode(str, errors, final_.__nonzero__());
    }

    public static PyTuple utf_8_decode(String str, String errors, boolean final_) {
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF8Stateful(str, errors, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_8_encode(String str) {
        return _codecs.utf_8_encode(str, null);
    }

    public static PyTuple utf_8_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF8(str, errors), size);
    }

    public static PyTuple utf_7_decode(String bytes) {
        return _codecs.utf_7_decode(bytes, null);
    }

    public static PyTuple utf_7_decode(String bytes, String errors) {
        return _codecs.utf_7_decode(bytes, null, false);
    }

    public static PyTuple utf_7_decode(String bytes, String errors, boolean finalFlag) {
        int[] consumed = finalFlag ? null : new int[1];
        String decoded = codecs.PyUnicode_DecodeUTF7Stateful(bytes, errors, consumed);
        return _codecs.decode_tuple(decoded, consumed, bytes.length());
    }

    public static PyTuple utf_7_encode(String str) {
        return _codecs.utf_7_encode(str, null);
    }

    public static PyTuple utf_7_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF7(str, false, false, errors), size);
    }

    public static PyTuple escape_decode(String str) {
        return _codecs.escape_decode(str, null);
    }

    public static PyTuple escape_decode(String str, String errors) {
        return _codecs.decode_tuple_str(PyString.decode_UnicodeEscape(str, 0, str.length(), errors, true), str.length());
    }

    public static PyTuple escape_encode(String str) {
        return _codecs.escape_encode(str, null);
    }

    public static PyTuple escape_encode(String str, String errors) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple charmap_decode(String bytes) {
        return _codecs.charmap_decode(bytes, null, null);
    }

    public static PyTuple charmap_decode(String bytes, String errors) {
        return _codecs.charmap_decode(bytes, errors, null);
    }

    public static PyTuple charmap_decode(String bytes, String errors, PyObject mapping) {
        if (mapping == null || mapping == Py.None) {
            return _codecs.latin_1_decode(bytes, errors);
        }
        return _codecs.charmap_decode(bytes, errors, mapping, false);
    }

    public static PyTuple charmap_decode(String bytes, String errors, PyObject mapping, boolean ignoreUnmapped) {
        int size = bytes.length();
        StringBuilder v = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char b = bytes.charAt(i);
            if (b > '\u00ff') {
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", bytes, i, i + 1, "ordinal not in range(255)") - 1;
                continue;
            }
            PyInteger w = Py.newInteger(b);
            PyObject x = mapping.__finditem__(w);
            if (x == null) {
                if (ignoreUnmapped) {
                    v.appendCodePoint(b);
                    continue;
                }
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", bytes, i, i + 1, "no mapping found") - 1;
                continue;
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError("character mapping must return integer greater than 0 and less than sys.maxunicode");
                }
                v.appendCodePoint(value);
                continue;
            }
            if (x == Py.None) {
                i = codecs.insertReplacementAndGetResume(v, errors, "charmap", bytes, i, i + 1, "character maps to <undefined>") - 1;
                continue;
            }
            if (x instanceof PyString) {
                String s = x.toString();
                if (s.charAt(0) == '\ufffe') {
                    i = codecs.insertReplacementAndGetResume(v, errors, "charmap", bytes, i, i + 1, "character maps to <undefined>") - 1;
                    continue;
                }
                v.append(s);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.decode_tuple(v.toString(), size);
    }

    public static PyObject translateCharmap(PyUnicode str, String errors, PyObject mapping) {
        StringBuilder buf = new StringBuilder(str.toString().length());
        Iterator<Integer> iter = str.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            PyObject result = mapping.__finditem__(Py.newInteger(codePoint));
            if (result == null) {
                buf.appendCodePoint(codePoint);
                continue;
            }
            if (result == Py.None) continue;
            if (result instanceof PyInteger) {
                int value = result.asInt();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError(String.format("character mapping must be in range(0x%x)", 0x110000));
                }
                buf.appendCodePoint(value);
                continue;
            }
            if (result instanceof PyUnicode) {
                buf.append(result.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return new PyUnicode(buf.toString());
    }

    public static PyTuple charmap_encode(String str) {
        return _codecs.charmap_encode(str, null, null);
    }

    public static PyTuple charmap_encode(String str, String errors) {
        return _codecs.charmap_encode(str, errors, null);
    }

    public static PyTuple charmap_encode(String str, String errors, PyObject mapping) {
        if (mapping == null || mapping == Py.None) {
            return _codecs.latin_1_encode(str, errors);
        }
        return _codecs.charmap_encode_internal(str, errors, mapping, new StringBuilder(str.length()), true);
    }

    private static PyTuple charmap_encode_internal(String str, String errors, PyObject mapping, StringBuilder v, boolean letLookupHandleError) {
        EncodingMap encodingMap = mapping instanceof EncodingMap ? (EncodingMap)mapping : null;
        int size = str.length();
        for (int i = 0; i < size; ++i) {
            int result;
            char ch = str.charAt(i);
            PyObject x = encodingMap != null ? ((result = encodingMap.lookup(ch)) == -1 ? null : Py.newInteger(result)) : mapping.__finditem__(Py.newInteger(ch));
            if (x == null) {
                if (letLookupHandleError) {
                    i = _codecs.handleBadMapping(str, errors, mapping, v, size, i);
                    continue;
                }
                throw Py.UnicodeEncodeError("charmap", str, i, i + 1, "character maps to <undefined>");
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                if (value < 0 || value > 255) {
                    throw Py.TypeError("character mapping must be in range(256)");
                }
                v.append((char)value);
                continue;
            }
            if (x instanceof PyString && !(x instanceof PyUnicode)) {
                v.append(x.toString());
                continue;
            }
            if (x instanceof PyNone) {
                i = _codecs.handleBadMapping(str, errors, mapping, v, size, i);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.encode_tuple(v.toString(), size);
    }

    private static int handleBadMapping(String str, String errors, PyObject mapping, StringBuilder v, int size, int i) {
        if (errors != null) {
            if (errors.equals("ignore")) {
                return i;
            }
            if (errors.equals("replace")) {
                String replStr = "?";
                _codecs.charmap_encode_internal(replStr, errors, mapping, v, false);
                return i;
            }
            if (errors.equals("xmlcharrefreplace")) {
                String replStr = codecs.xmlcharrefreplace(i, i + 1, str).toString();
                _codecs.charmap_encode_internal(replStr, errors, mapping, v, false);
                return i;
            }
            if (errors.equals("backslashreplace")) {
                String replStr = codecs.backslashreplace(i, i + 1, str).toString();
                _codecs.charmap_encode_internal(replStr, errors, mapping, v, false);
                return i;
            }
        }
        String msg2 = "character maps to <undefined>";
        PyObject replacement = codecs.encoding_error(errors, "charmap", str, i, i + 1, msg2);
        String replStr = replacement.__getitem__(0).toString();
        _codecs.charmap_encode_internal(replStr, errors, mapping, v, false);
        return codecs.calcNewPosition(size, replacement) - 1;
    }

    public static PyTuple ascii_decode(String str) {
        return _codecs.ascii_decode(str, null);
    }

    public static PyTuple ascii_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeASCII(str, size, errors), size);
    }

    public static PyTuple ascii_encode(String str) {
        return _codecs.ascii_encode(str, null);
    }

    public static PyTuple ascii_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeASCII(str, size, errors), size);
    }

    public static PyTuple latin_1_decode(String str) {
        return _codecs.latin_1_decode(str, null);
    }

    public static PyTuple latin_1_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeLatin1(str, size, errors), size);
    }

    public static PyTuple latin_1_encode(String str) {
        return _codecs.latin_1_encode(str, null);
    }

    public static PyTuple latin_1_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeLatin1(str, size, errors), size);
    }

    public static PyTuple utf_16_encode(String str) {
        return _codecs.utf_16_encode(str, null);
    }

    public static PyTuple utf_16_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, 0), str.length());
    }

    public static PyTuple utf_16_encode(String str, String errors, int byteorder) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, byteorder), str.length());
    }

    public static PyTuple utf_16_le_encode(String str) {
        return _codecs.utf_16_le_encode(str, null);
    }

    public static PyTuple utf_16_le_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, -1), str.length());
    }

    public static PyTuple utf_16_be_encode(String str) {
        return _codecs.utf_16_be_encode(str, null);
    }

    public static PyTuple utf_16_be_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, 1), str.length());
    }

    public static String encode_UTF16(String str, String errors, int byteorder) {
        Charset utf16 = byteorder == 0 ? Charset.forName("UTF-16") : (byteorder == -1 ? Charset.forName("UTF-16LE") : Charset.forName("UTF-16BE"));
        ByteBuffer bbuf = utf16.encode(str);
        StringBuilder v = new StringBuilder(bbuf.limit());
        while (bbuf.remaining() > 0) {
            int val = bbuf.get();
            if (val < 0) {
                val = 256 + val;
            }
            v.appendCodePoint(val);
        }
        return v.toString();
    }

    public static PyTuple utf_16_decode(String str) {
        return _codecs.utf_16_decode(str, null);
    }

    public static PyTuple utf_16_decode(String str, String errors) {
        return _codecs.utf_16_decode(str, errors, false);
    }

    public static PyTuple utf_16_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_le_decode(String str) {
        return _codecs.utf_16_le_decode(str, null);
    }

    public static PyTuple utf_16_le_decode(String str, String errors) {
        return _codecs.utf_16_le_decode(str, errors, false);
    }

    public static PyTuple utf_16_le_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{-1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_be_decode(String str) {
        return _codecs.utf_16_be_decode(str, null);
    }

    public static PyTuple utf_16_be_decode(String str, String errors) {
        return _codecs.utf_16_be_decode(str, errors, false);
    }

    public static PyTuple utf_16_be_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_ex_decode(String str) {
        return _codecs.utf_16_ex_decode(str, null);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors) {
        return _codecs.utf_16_ex_decode(str, errors, 0);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors, int byteorder) {
        return _codecs.utf_16_ex_decode(str, errors, byteorder, false);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors, int byteorder, boolean final_) {
        int[] bo = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        String decoded = _codecs.decode_UTF16(str, errors, bo, consumed);
        return new PyTuple(new PyUnicode(decoded), Py.newInteger(final_ ? str.length() : consumed[0]), Py.newInteger(bo[0]));
    }

    private static String decode_UTF16(String str, String errors, int[] byteorder) {
        return _codecs.decode_UTF16(str, errors, byteorder, null);
    }

    private static String decode_UTF16(String str, String errors, int[] byteorder, int[] consumed) {
        int i;
        int bo = 0;
        if (byteorder != null) {
            bo = byteorder[0];
        }
        int size = str.length();
        StringBuilder v = new StringBuilder(size / 2);
        for (i = 0; i < size; i += 2) {
            char ch1 = str.charAt(i);
            if (i + 1 == size) {
                if (consumed != null) break;
                i = codecs.insertReplacementAndGetResume(v, errors, "utf-16", str, i, i + 1, "truncated data");
                continue;
            }
            char ch2 = str.charAt(i + 1);
            if (ch1 == '\u00fe' && ch2 == '\u00ff') {
                bo = 1;
                continue;
            }
            if (ch1 == '\u00ff' && ch2 == '\u00fe') {
                bo = -1;
                continue;
            }
            int W1 = bo == -1 ? ch2 << 8 | ch1 : ch1 << 8 | ch2;
            if (W1 < 55296 || W1 > 57343) {
                v.appendCodePoint(W1);
                continue;
            }
            if (W1 >= 55296 && W1 <= 56319 && i < size - 1) {
                char ch3 = str.charAt(i += 2);
                char ch4 = str.charAt(i + 1);
                int W2 = bo == -1 ? ch4 << 8 | ch3 : ch3 << 8 | ch4;
                if (W2 >= 56320 && W2 <= 57343) {
                    int U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                    v.appendCodePoint(U);
                    continue;
                }
                i = codecs.insertReplacementAndGetResume(v, errors, "utf-16", str, i, i + 1, "illegal UTF-16 surrogate");
                continue;
            }
            i = codecs.insertReplacementAndGetResume(v, errors, "utf-16", str, i, i + 1, "illegal encoding");
        }
        if (byteorder != null) {
            byteorder[0] = bo;
        }
        if (consumed != null) {
            consumed[0] = i;
        }
        return v.toString();
    }

    public static PyTuple utf_32_encode(String unicode) {
        return _codecs.utf_32_encode(unicode, null);
    }

    public static PyTuple utf_32_encode(String unicode, String errors) {
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, ByteOrder.UNDEFINED);
    }

    public static PyTuple utf_32_encode(String unicode, String errors, int byteorder) {
        ByteOrder order = ByteOrder.fromInt(byteorder);
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, order);
    }

    public static PyTuple utf_32_le_encode(String unicode) {
        return _codecs.utf_32_le_encode(unicode, null);
    }

    public static PyTuple utf_32_le_encode(String unicode, String errors) {
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, ByteOrder.LE);
    }

    public static PyTuple utf_32_be_encode(String unicode) {
        return _codecs.utf_32_be_encode(unicode, null);
    }

    public static PyTuple utf_32_be_encode(String unicode, String errors) {
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, ByteOrder.BE);
    }

    private static PyTuple PyUnicode_EncodeUTF32(String unicode, String errors, ByteOrder order) {
        StringBuilder v = new StringBuilder(4 * (unicode.length() + 1));
        int uptr = 0;
        if (order == ByteOrder.UNDEFINED) {
            v.append("\u0000\u0000\u00fe\u00ff");
            order = ByteOrder.BE;
        }
        uptr = order != ByteOrder.LE ? _codecs.PyUnicode_EncodeUTF32BELoop(v, unicode, errors) : _codecs.PyUnicode_EncodeUTF32LELoop(v, unicode, errors);
        return _codecs.encode_tuple(v.toString(), uptr);
    }

    private static int PyUnicode_EncodeUTF32BELoop(StringBuilder v, String unicode, String errors) {
        int len = unicode.length();
        int uptr = 0;
        char[] buf = new char[6];
        while (uptr < len) {
            int ch;
            if (((ch = unicode.charAt(uptr++)) & 0xF800) == 55296) {
                if ((ch & 0x400) == 0) {
                    if (uptr < len) {
                        char ch2;
                        if (((ch2 = unicode.charAt(uptr++)) & 0xFC00) == 56320) {
                            ch = ((ch & 0x3FF) << 10) + (ch2 & 0x3FF) + 65536;
                            buf[3] = (char)(ch >> 16 & 0xFF);
                            buf[4] = (char)(ch >> 8 & 0xFF);
                            buf[5] = (char)(ch & 0xFF);
                            v.append(buf, 2, 4);
                            continue;
                        }
                        uptr = _codecs.PyUnicode_EncodeUTF32Error(v, errors, ByteOrder.BE, unicode, uptr - 2, uptr - 1, "second surrogate missing");
                        continue;
                    }
                    uptr = _codecs.PyUnicode_EncodeUTF32Error(v, errors, ByteOrder.BE, unicode, uptr - 1, len, "truncated data");
                    continue;
                }
                uptr = _codecs.PyUnicode_EncodeUTF32Error(v, errors, ByteOrder.BE, unicode, uptr - 2, uptr - 1, "unexpected second surrogate");
                continue;
            }
            if (ch > 255) {
                buf[3] = (char)(ch >> 8 & 0xFF);
                buf[4] = (char)(ch & 0xFF);
                v.append(buf, 1, 4);
                continue;
            }
            buf[3] = (char)(ch & 0xFF);
            v.append(buf, 0, 4);
        }
        return uptr;
    }

    private static int PyUnicode_EncodeUTF32LELoop(StringBuilder v, String unicode, String errors) {
        int len = unicode.length();
        int uptr = 0;
        char[] buf = new char[6];
        while (uptr < len) {
            int ch;
            if (((ch = unicode.charAt(uptr++)) & 0xF800) == 55296) {
                if ((ch & 0x400) == 0) {
                    if (uptr < len) {
                        char ch2;
                        if (((ch2 = unicode.charAt(uptr++)) & 0xFC00) == 56320) {
                            ch = ((ch & 0x3FF) << 10) + (ch2 & 0x3FF) + 65536;
                            buf[0] = (char)(ch & 0xFF);
                            buf[1] = (char)(ch >> 8 & 0xFF);
                            buf[2] = (char)(ch >> 16 & 0xFF);
                            v.append(buf, 0, 4);
                            continue;
                        }
                        uptr = _codecs.PyUnicode_EncodeUTF32Error(v, errors, ByteOrder.LE, unicode, uptr - 2, uptr - 1, "second surrogate missing");
                        continue;
                    }
                    uptr = _codecs.PyUnicode_EncodeUTF32Error(v, errors, ByteOrder.LE, unicode, uptr - 1, len, "truncated data");
                    continue;
                }
                uptr = _codecs.PyUnicode_EncodeUTF32Error(v, errors, ByteOrder.LE, unicode, uptr - 2, uptr - 1, "unexpected second surrogate");
                continue;
            }
            if (ch > 255) {
                buf[1] = (char)(ch & 0xFF);
                buf[2] = (char)(ch >> 8 & 0xFF);
                v.append(buf, 1, 4);
                continue;
            }
            buf[2] = (char)(ch & 0xFF);
            v.append(buf, 2, 4);
        }
        return uptr;
    }

    private static int PyUnicode_EncodeUTF32Error(StringBuilder v, String errors, ByteOrder order, String toEncode, int start, int end, String reason) {
        if (errors != null) {
            if (errors.equals("ignore")) {
                return end;
            }
            if (errors.equals("replace")) {
                for (int i = start; i < end; ++i) {
                    if (order != ByteOrder.LE) {
                        v.append("\u0000\u0000\u0000?");
                        continue;
                    }
                    v.append("?\u0000\u0000\u0000");
                }
                return end;
            }
        }
        PyObject replacementSpec = codecs.encoding_error(errors, "utf-32", toEncode, start, end, reason);
        String u = replacementSpec.__getitem__(0).toString();
        _codecs.PyUnicode_EncodeUTF32BELoop(v, u, errors);
        return codecs.calcNewPosition(toEncode.length(), replacementSpec);
    }

    public static PyTuple utf_32_decode(String bytes) {
        return _codecs.utf_32_decode(bytes, null);
    }

    public static PyTuple utf_32_decode(String bytes, String errors) {
        return _codecs.utf_32_decode(bytes, errors, false);
    }

    public static PyTuple utf_32_decode(String bytes, String errors, boolean isFinal) {
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, ByteOrder.UNDEFINED, isFinal, false);
    }

    public static PyTuple utf_32_le_decode(String bytes) {
        return _codecs.utf_32_le_decode(bytes, null);
    }

    public static PyTuple utf_32_le_decode(String bytes, String errors) {
        return _codecs.utf_32_le_decode(bytes, errors, false);
    }

    public static PyTuple utf_32_le_decode(String bytes, String errors, boolean isFinal) {
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, ByteOrder.LE, isFinal, false);
    }

    public static PyTuple utf_32_be_decode(String bytes) {
        return _codecs.utf_32_be_decode(bytes, null);
    }

    public static PyTuple utf_32_be_decode(String bytes, String errors) {
        return _codecs.utf_32_be_decode(bytes, errors, false);
    }

    public static PyTuple utf_32_be_decode(String bytes, String errors, boolean isFinal) {
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, ByteOrder.BE, isFinal, false);
    }

    public static PyTuple utf_32_ex_decode(String bytes, String errors, int byteorder) {
        return _codecs.utf_32_ex_decode(bytes, errors, byteorder, false);
    }

    public static PyTuple utf_32_ex_decode(String bytes, String errors, int byteorder, boolean isFinal) {
        ByteOrder order = ByteOrder.fromInt(byteorder);
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, order, isFinal, true);
    }

    private static PyTuple PyUnicode_DecodeUTF32Stateful(String bytes, String errors, ByteOrder order, boolean isFinal, boolean findOrder) {
        int size = bytes.length();
        int limit = size & 0xFFFFFFFC;
        StringBuilder unicode = new StringBuilder(1 + limit / 4);
        int q = 0;
        if (limit > 0) {
            if (order == ByteOrder.UNDEFINED) {
                char a = bytes.charAt(q);
                if (a == '\u00ff') {
                    if (bytes.charAt(q + 1) == '\u00fe' && bytes.charAt(q + 2) == '\u0000' && bytes.charAt(q + 3) == '\u0000') {
                        order = ByteOrder.LE;
                        q += 4;
                    }
                } else if (a == '\u0000' && bytes.charAt(q + 1) == '\u0000' && bytes.charAt(q + 2) == '\u00fe' && bytes.charAt(q + 3) == '\u00ff') {
                    order = ByteOrder.BE;
                    q += 4;
                }
            }
            q = order != ByteOrder.LE ? _codecs.PyUnicode_DecodeUTF32BELoop(unicode, bytes, q, limit, errors) : _codecs.PyUnicode_DecodeUTF32LELoop(unicode, bytes, q, limit, errors);
        }
        if (isFinal && q < size) {
            q = codecs.insertReplacementAndGetResume(unicode, errors, "utf-32", bytes, q, size, "truncated data");
        }
        if (findOrder) {
            return _codecs.decode_tuple(unicode.toString(), q, order);
        }
        return _codecs.decode_tuple(unicode.toString(), q);
    }

    private static int PyUnicode_DecodeUTF32BELoop(StringBuilder unicode, String bytes, int q, int limit, String errors) {
        while (q < limit) {
            int hi = bytes.charAt(q) << 8 | bytes.charAt(q + 1);
            int lo = bytes.charAt(q + 2) << 8 | bytes.charAt(q + 3);
            if (hi == 0) {
                unicode.append((char)lo);
                q += 4;
                continue;
            }
            try {
                unicode.appendCodePoint((hi << 16) + lo);
                q += 4;
            }
            catch (IllegalArgumentException e) {
                q = codecs.insertReplacementAndGetResume(unicode, errors, "utf-32", bytes, q, q + 4, "codepoint not in range(0x110000)");
            }
        }
        return q;
    }

    private static int PyUnicode_DecodeUTF32LELoop(StringBuilder unicode, String bytes, int q, int limit, String errors) {
        while (q < limit) {
            int hi = bytes.charAt(q + 3) << 8 | bytes.charAt(q + 2);
            int lo = bytes.charAt(q + 1) << 8 | bytes.charAt(q);
            if (hi == 0) {
                unicode.append((char)lo);
                q += 4;
                continue;
            }
            try {
                unicode.appendCodePoint((hi << 16) + lo);
                q += 4;
            }
            catch (IllegalArgumentException e) {
                q = codecs.insertReplacementAndGetResume(unicode, errors, "utf-32", bytes, q, q + 4, "codepoint not in range(0x110000)");
            }
        }
        return q;
    }

    public static PyTuple raw_unicode_escape_encode(String str) {
        return _codecs.raw_unicode_escape_encode(str, null);
    }

    public static PyTuple raw_unicode_escape_encode(String str, String errors) {
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeRawUnicodeEscape(str, errors, false), str.length());
    }

    public static PyTuple raw_unicode_escape_decode(String str) {
        return _codecs.raw_unicode_escape_decode(str, null);
    }

    public static PyTuple raw_unicode_escape_decode(String str, String errors) {
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeRawUnicodeEscape(str, errors), str.length());
    }

    public static PyTuple unicode_escape_encode(String str) {
        return _codecs.unicode_escape_encode(str, null);
    }

    public static PyTuple unicode_escape_encode(String str, String errors) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple unicode_escape_decode(String str) {
        return _codecs.unicode_escape_decode(str, null);
    }

    public static PyTuple unicode_escape_decode(String str, String errors) {
        int n = str.length();
        return _codecs.decode_tuple(PyString.decode_UnicodeEscape(str, 0, n, errors, true), n);
    }

    @Deprecated
    public static PyTuple unicode_internal_encode(String unicode) {
        return _codecs.utf_32_be_encode(unicode, null);
    }

    @Deprecated
    public static PyTuple unicode_internal_encode(String unicode, String errors) {
        return _codecs.utf_32_be_encode(unicode, errors);
    }

    @Deprecated
    public static PyTuple unicode_internal_decode(String bytes) {
        return _codecs.utf_32_be_decode(bytes, null, true);
    }

    @Deprecated
    public static PyTuple unicode_internal_decode(String bytes, String errors) {
        return _codecs.utf_32_be_decode(bytes, errors, true);
    }

    @Untraversable
    @ExposedType(name="EncodingMap", isBaseType=false)
    public static class EncodingMap
    extends PyObject {
        char[] level1;
        char[] level23;
        int count2;
        int count3;

        private EncodingMap(char[] level1, char[] level23, int count2, int count3) {
            this.level1 = level1;
            this.level23 = level23;
            this.count2 = count2;
            this.count3 = count3;
        }

        public static PyObject buildEncodingMap(PyObject string) {
            int i;
            if (!(string instanceof PyUnicode) || string.__len__() != 256) {
                throw Py.TypeError("bad argument type for built-in operation");
            }
            boolean needDict = false;
            char[] level1 = new char[32];
            char[] level23 = new char[512];
            int count2 = 0;
            int count3 = 0;
            String decode = string.toString();
            for (i = 0; i < level1.length; ++i) {
                level1[i] = 255;
            }
            for (i = 0; i < level23.length; ++i) {
                level23[i] = 255;
            }
            if (decode.charAt(0) != '\u0000') {
                needDict = true;
            }
            for (i = 1; i < 256; ++i) {
                char charAt = decode.charAt(i);
                if (charAt == '\u0000') {
                    needDict = true;
                }
                if (charAt == '\ufffe') continue;
                int l1 = charAt >> 11;
                int l2 = charAt >> 7;
                if (level1[l1] == '\u00ff') {
                    level1[l1] = (char)count2++;
                }
                if (level23[l2] != '\u00ff') continue;
                level23[l2] = (char)count3++;
            }
            if (count2 > 255 || count3 > 255) {
                needDict = true;
            }
            if (needDict) {
                PyDictionary result = new PyDictionary();
                for (i = 0; i < 256; ++i) {
                    ((PyObject)result).__setitem__(Py.newInteger(decode.charAt(i)), (PyObject)Py.newInteger(i));
                }
                return result;
            }
            int length2 = 16 * count2;
            int length3 = 128 * count3;
            level23 = new char[length2 + length3];
            EncodingMap result = new EncodingMap(level1, level23, count2, count3);
            for (i = 0; i < length2; ++i) {
                level23[i] = 255;
            }
            for (i = length2; i < length2 + length3; ++i) {
                level23[i] = '\u0000';
            }
            count3 = 0;
            for (i = 1; i < 256; ++i) {
                char charAt = decode.charAt(i);
                if (charAt == '\ufffe') continue;
                int o1 = charAt >> 11;
                int o2 = charAt >> 7 & 0xF;
                int i2 = 16 * level1[o1] + o2;
                if (level23[i2] == '\u00ff') {
                    level23[i2] = (char)count3++;
                }
                int o3 = charAt & 0x7F;
                int i3 = 128 * level23[i2] + o3;
                level23[length2 + i3] = (char)i;
            }
            return result;
        }

        public int lookup(char c) {
            int l1 = c >> 11;
            int l2 = c >> 7 & 0xF;
            int l3 = c & 0x7F;
            if (c == '\u0000') {
                return 0;
            }
            char i = this.level1[l1];
            if (i == '\u00ff') {
                return -1;
            }
            if ((i = this.level23[16 * i + l2]) == '\u00ff') {
                return -1;
            }
            if ((i = this.level23[16 * this.count2 + 128 * i + l3]) == '\u0000') {
                return -1;
            }
            return i;
        }

        static {
            PyType.addBuilder(EncodingMap.class, new _codecs$EncodingMap$PyExposer());
        }
    }

    static enum ByteOrder {
        LE,
        UNDEFINED,
        BE;


        int code() {
            return this.ordinal() - 1;
        }

        static ByteOrder fromInt(int byteorder) {
            switch (byteorder) {
                case -1: {
                    return LE;
                }
                case 1: {
                    return BE;
                }
            }
            return UNDEFINED;
        }
    }
}

