/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class ScreenLineManager {
    private final JEditBuffer buffer;
    private char[] screenLines;

    ScreenLineManager(JEditBuffer jEditBuffer) {
        this.buffer = jEditBuffer;
        if (!jEditBuffer.isLoading()) {
            this.reset();
        }
    }

    boolean isScreenLineCountValid(int n) {
        if (this.screenLines == null || n < 0 || n >= this.screenLines.length) {
            return false;
        }
        return this.screenLines[n] > '\u0000';
    }

    int getScreenLineCount(int n) {
        assert (this.isScreenLineCountValid(n));
        return this.screenLines[n];
    }

    void setScreenLineCount(int n, int n2) {
        assert (n2 > 0) : "New line count is bogus!";
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
            Log.log(9, this, new Exception("Max screen line count hit!"));
        }
        if (Debug.SCREEN_LINES_DEBUG) {
            Log.log(1, this, "setScreenLineCount(" + n + "," + n2 + ")");
        }
        if (this.screenLines == null) {
            this.reset();
        }
        this.screenLines[n] = (char)n2;
    }

    void invalidateScreenLineCounts() {
        this.invalidateScreenLineCountRange(0, this.buffer.getLineCount());
    }

    private void invalidateScreenLineCount(int n) {
        this.screenLines[n] = '\u0000';
    }

    private void invalidateScreenLineCountRange(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.screenLines[i] = '\u0000';
        }
    }

    void reset() {
        this.screenLines = new char[this.buffer.getLineCount()];
    }

    public void contentInserted(int n, int n2) {
        int n3 = this.buffer.getLineCount();
        if (n2 > 0) {
            int n4 = n3 - n2;
            if (this.screenLines.length <= n3) {
                int n5;
                char[] cArray = new char[n3 + 1 << 1];
                if (n != 0) {
                    System.arraycopy(this.screenLines, 0, cArray, 0, n);
                }
                if ((n5 = n4 - n - 1) > 0) {
                    System.arraycopy(this.screenLines, n + 1, cArray, n + n2 + 1, n5);
                }
                this.screenLines = cArray;
            } else {
                int n6 = n4 - n - 1;
                if (n6 > 0) {
                    System.arraycopy(this.screenLines, n + 1, this.screenLines, n + n2 + 1, n6);
                }
                this.invalidateScreenLineCountRange(n, n + n2 + 1);
            }
        } else {
            this.invalidateScreenLineCount(n);
        }
    }

    public void contentRemoved(int n, int n2) {
        int n3 = n + n2;
        this.invalidateScreenLineCount(n);
        if (n2 > 0 && n3 != this.screenLines.length) {
            System.arraycopy(this.screenLines, n3 + 1, this.screenLines, n + 1, this.screenLines.length - n3 - 1);
        }
    }
}

