/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskManager;

public class ThreadUtilities {
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new JEditThreadFactory());
    private static final int CORE_POOL_SIZE = 4;

    public static void runInDispatchThread(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void runInDispatchThreadAndWait(Runnable runnable) {
        boolean bl = false;
        CountDownLatchRunnable countDownLatchRunnable = new CountDownLatchRunnable(runnable);
        ThreadUtilities.runInDispatchThread(countDownLatchRunnable);
        while (countDownLatchRunnable.done.getCount() > 0L) {
            try {
                countDownLatchRunnable.done.await();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public static void runInDispatchThreadNow(Runnable runnable) {
        boolean bl = false;
        CountDownLatchRunnable countDownLatchRunnable = new CountDownLatchRunnable(runnable);
        try {
            EventQueue.invokeAndWait(countDownLatchRunnable);
        }
        catch (InterruptedException interruptedException) {
            bl = true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            Log.log(9, ThreadUtilities.class, "Invocation Target Exception:");
            Log.log(9, runnable.getClass(), throwable);
        }
        while (countDownLatchRunnable.done.getCount() > 0L) {
            try {
                countDownLatchRunnable.done.await();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public static void runInBackground(Runnable runnable) {
        Task task = runnable instanceof Task ? (Task)runnable : TaskManager.decorate(runnable);
        TaskManager.instance.fireWaiting(task);
        threadPool.execute(task);
    }

    public static void runInBackground(Task task) {
        TaskManager.instance.fireWaiting(task);
        threadPool.execute(task);
    }

    private ThreadUtilities() {
    }

    static {
        ((ThreadPoolExecutor)threadPool).setCorePoolSize(4);
    }

    private static class CountDownLatchRunnable
    implements Runnable {
        private final Runnable runnable;
        private final CountDownLatch done = new CountDownLatch(1);

        private CountDownLatchRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
            this.done.countDown();
        }
    }

    private static class JEditThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadIDs = new AtomicInteger(0);
        private final ThreadGroup threadGroup = new ThreadGroup("jEdit Workers");

        private JEditThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.threadGroup, runnable);
            thread.setName("jEdit Worker #" + this.threadIDs.getAndIncrement());
            return thread;
        }
    }
}

