/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.BS;
import javajs.util.PT;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

public abstract class ForceField {
    static final int ENERGY = 1;
    static final int EBOND = 2;
    static final int EANGLE = 4;
    static final int ESTRBND = 8;
    static final int ETORSION = 16;
    static final int EOOP = 32;
    static final int EVDW = 64;
    static final int EELECTROSTATIC = 128;
    public static final int ABI_IJ = 3;
    public static final int ABI_JK = 4;
    public static final int TBI_AB = 4;
    public static final int TBI_BC = 5;
    public static final int TBI_CD = 6;
    public static final int R3 = 0;
    public static final int R4 = 1;
    public static final int R5 = 2;
    public static final int Raromatic = 3;
    public String name;
    Calculations calc;
    private double criterion;
    private double e0;
    private double dE;
    int currentStep;
    private int stepMax;
    private double[][] coordSaved;
    int minAtomCount;
    int minBondCount;
    MinAtom[] minAtoms;
    MinBond[] minBonds;
    MinAngle[] minAngles;
    MinTorsion[] minTorsions;
    MinPosition[] minPositions;
    BS bsFixed;
    Minimizer minimizer;

    public abstract void clear();

    public abstract boolean setModel(BS var1, int var2) throws JmolAsyncException;

    protected void setModelFields() {
        this.minAtoms = this.minimizer.minAtoms;
        this.minBonds = this.minimizer.minBonds;
        this.minAngles = this.minimizer.minAngles;
        this.minTorsions = this.minimizer.minTorsions;
        this.bsFixed = this.minimizer.bsMinFixed;
        this.minAtomCount = this.minAtoms.length;
        this.minBondCount = this.minBonds.length;
    }

    public void setConstraints(Minimizer m) {
        this.bsFixed = m.bsMinFixed;
        this.calc.setConstraints(m.constraints);
        this.coordSaved = null;
    }

    public void steepestDescentInitialize(int stepMax, double criterion) {
        this.stepMax = stepMax;
        this.criterion = criterion / (double)this.toUserUnits(1.0);
        this.currentStep = 0;
        this.clearForces();
        this.calc.setLoggingEnabled(true);
        this.calc.setLoggingEnabled(stepMax == 0 || Logger.isActiveLevel(6));
        String s = this.name + " " + this.calc.getDebugHeader(-1) + "Jmol Minimization Version " + Viewer.getJmolVersion() + "\n";
        this.calc.appendLogData(s);
        Logger.info(s);
        this.calc.getConstraintList();
        if (this.calc.loggingEnabled) {
            this.calc.appendLogData(this.calc.getAtomList("S T E E P E S T   D E S C E N T"));
        }
        this.dE = 0.0;
        this.calc.setPreliminary(stepMax > 0);
        this.e0 = this.energyFull(false, false);
        s = PT.sprintf(" Initial " + this.name + " E = %10.3f " + this.minimizer.units + "/mol criterion = %8.6f max steps = " + stepMax, "ff", new Object[]{Float.valueOf(this.toUserUnits(this.e0)), Float.valueOf(this.toUserUnits(criterion))});
        this.minimizer.report(s, false);
        this.calc.appendLogData(s);
    }

    private void clearForces() {
        for (int i = 0; i < this.minAtomCount; ++i) {
            this.minAtoms[i].force[2] = 0.0;
            this.minAtoms[i].force[1] = 0.0;
            this.minAtoms[i].force[0] = 0.0;
        }
    }

    public boolean steepestDescentTakeNSteps(int n) {
        if (this.stepMax == 0) {
            return false;
        }
        boolean isPreliminary = true;
        for (int iStep = 1; iStep <= n; ++iStep) {
            String s;
            ++this.currentStep;
            this.calc.setSilent(true);
            for (int i = 0; i < this.minAtomCount; ++i) {
                if (this.bsFixed != null && this.bsFixed.get(i)) continue;
                this.setForcesUsingNumericalDerivative(this.minAtoms[i], 1);
            }
            this.linearSearch();
            this.calc.setSilent(false);
            if (this.calc.loggingEnabled) {
                this.calc.appendLogData(this.calc.getAtomList("S T E P    " + this.currentStep));
            }
            double e1 = this.energyFull(false, false);
            this.dE = e1 - this.e0;
            boolean done = Util.isNear3(e1, this.e0, this.criterion);
            if (done || this.currentStep % 10 == 0 || this.stepMax <= this.currentStep) {
                s = PT.sprintf(this.name + " Step %-4d E = %10.6f    dE = %8.6f ", "Fi", new Object[]{new float[]{this.toUserUnits(e1), this.toUserUnits(this.dE)}, this.currentStep});
                this.minimizer.report(s, false);
                this.calc.appendLogData(s);
            }
            this.e0 = e1;
            if (done || this.stepMax <= this.currentStep) {
                if (this.calc.loggingEnabled) {
                    this.calc.appendLogData(this.calc.getAtomList("F I N A L  G E O M E T R Y"));
                }
                if (done) {
                    s = PT.formatStringF("\n    " + this.name + " STEEPEST DESCENT HAS CONVERGED: E = %8.5f " + this.minimizer.units + "/mol after " + this.currentStep + " steps", "f", this.toUserUnits(e1));
                    this.calc.appendLogData(s);
                    this.minimizer.report(s, true);
                    Logger.info(s);
                }
                return false;
            }
            if (!isPreliminary || !(this.getNormalizedDE() >= 2.0)) continue;
            isPreliminary = false;
            this.calc.setPreliminary(false);
            this.e0 = this.energyFull(false, false);
        }
        return true;
    }

    private double getEnergies(int terms, boolean gradients) {
        if ((terms & 1) != 0) {
            return this.energyFull(gradients, true);
        }
        double e = 0.0;
        if ((terms & 2) != 0) {
            e += this.energyBond(gradients);
        }
        if ((terms & 4) != 0) {
            e += this.energyAngle(gradients);
        }
        if ((terms & 8) != 0) {
            e += this.energyStretchBend(gradients);
        }
        if ((terms & 0x20) != 0) {
            e += this.energyOOP(gradients);
        }
        if ((terms & 0x10) != 0) {
            e += this.energyTorsion(gradients);
        }
        if ((terms & 0x40) != 0) {
            e += this.energyVDW(gradients);
        }
        if ((terms & 0x80) != 0) {
            e += this.energyES(gradients);
        }
        return e;
    }

    private void setForcesUsingNumericalDerivative(MinAtom atom, int terms) {
        double delta = 1.0E-5;
        atom.force[0] = -this.getDE(atom, terms, 0, delta);
        atom.force[1] = -this.getDE(atom, terms, 1, delta);
        atom.force[2] = -this.getDE(atom, terms, 2, delta);
    }

    private double getDE(MinAtom atom, int terms, int i, double delta) {
        int n = i;
        atom.coord[n] = atom.coord[n] + delta;
        double e = this.getEnergies(terms, false);
        int n2 = i;
        atom.coord[n2] = atom.coord[n2] - delta;
        return (e - this.e0) / delta;
    }

    public double energyFull(boolean gradients, boolean isSilent) {
        if (gradients) {
            this.clearForces();
        }
        double energy = this.energyBond(gradients) + this.energyAngle(gradients) + this.energyTorsion(gradients) + this.energyStretchBend(gradients) + this.energyOOP(gradients) + this.energyVDW(gradients) + this.energyES(gradients);
        if (!isSilent && this.calc.loggingEnabled) {
            this.calc.appendLogData(PT.sprintf("\nTOTAL %s ENERGY = %8.3f %s/mol\n", "sfs", new Object[]{this.name, Float.valueOf(this.toUserUnits(energy)), this.minimizer.units}));
        }
        return energy;
    }

    double energyStretchBend(boolean gradients) {
        return this.calc.energyStretchBend(gradients);
    }

    double energyBond(boolean gradients) {
        return this.calc.energyBond(gradients);
    }

    double energyAngle(boolean gradients) {
        return this.calc.energyAngle(gradients);
    }

    double energyTorsion(boolean gradients) {
        return this.calc.energyTorsion(gradients);
    }

    double energyOOP(boolean gradients) {
        return this.calc.energyOOP(gradients);
    }

    double energyVDW(boolean gradients) {
        return this.calc.energyVDW(gradients);
    }

    double energyES(boolean gradients) {
        return this.calc.energyES(gradients);
    }

    private void linearSearch() {
        double step = 0.23;
        double trustRadius = 0.3;
        double trustRadius2 = trustRadius * trustRadius;
        double e1 = this.energyFull(false, true);
        for (int iStep = 0; iStep < 10; ++iStep) {
            this.saveCoordinates();
            for (int i = 0; i < this.minAtomCount; ++i) {
                if (this.bsFixed != null && this.bsFixed.get(i)) continue;
                double[] force = this.minAtoms[i].force;
                double[] coord = this.minAtoms[i].coord;
                double f2 = force[0] * force[0] + force[1] * force[1] + force[2] * force[2];
                if (f2 > trustRadius2 / step / step) {
                    f2 = trustRadius / Math.sqrt(f2) / step;
                    force[0] = force[0] * f2;
                    force[1] = force[1] * f2;
                    force[2] = force[2] * f2;
                }
                for (int j = 0; j < 3; ++j) {
                    if (!Util.isFinite(force[j])) continue;
                    double tempStep = force[j] * step;
                    if (tempStep > trustRadius) {
                        int n = j;
                        coord[n] = coord[n] + trustRadius;
                        continue;
                    }
                    if (tempStep < -trustRadius) {
                        int n = j;
                        coord[n] = coord[n] - trustRadius;
                        continue;
                    }
                    int n = j;
                    coord[n] = coord[n] + tempStep;
                }
            }
            double e2 = this.energyFull(false, true);
            if (Util.isNear3(e2, e1, 0.001)) break;
            if (e2 > e1) {
                step *= 0.1;
                this.restoreCoordinates();
                continue;
            }
            if (!(e2 < e1)) continue;
            e1 = e2;
            if (!((step *= 2.15) > 1.0)) continue;
            step = 1.0;
        }
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.minAtomCount][3];
        }
        for (int i = 0; i < this.minAtomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        for (int i = 0; i < this.minAtomCount; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
    }

    public boolean detectExplosion() {
        int i;
        for (i = 0; i < this.minAtomCount; ++i) {
            MinAtom atom = this.minAtoms[i];
            for (int j = 0; j < 3; ++j) {
                if (Util.isFinite(atom.coord[j])) continue;
                return true;
            }
        }
        for (i = 0; i < this.minBondCount; ++i) {
            MinBond bond = this.minBonds[i];
            if (!(Util.distance2(this.minAtoms[bond.data[0]].coord, this.minAtoms[bond.data[1]].coord) > 900.0)) continue;
            return true;
        }
        return false;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public double getEnergy() {
        return this.e0;
    }

    public String getAtomList(String title) {
        return this.calc.getAtomList(title);
    }

    public double getEnergyDiff() {
        return this.dE;
    }

    public String getLogData() {
        return this.calc.getLogData();
    }

    double getNormalizedDE() {
        return Math.abs(this.dE / this.criterion);
    }

    public float toUserUnits(double energy) {
        return this.toUnits(energy, this.calc.getUnits());
    }

    private float toUnits(double energy, String units) {
        return (float)(units.equalsIgnoreCase(this.minimizer.units) ? energy : energy * (this.minimizer.units.equals("kJ") ? 4.1868 : 0.23884589662749595));
    }

    public void log(String s) {
        this.calc.appendLogData(s);
    }

    protected BufferedReader getBufferedReader(String resourceName) throws IOException {
        return FileManager.getBufferedReaderForResource(this.minimizer.vwr, this, "org/jmol/minimize/forcefield/", "data/" + resourceName);
    }
}

