/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary;

import java.util.Properties;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.OptionConverter;
import org.apache.commons.jcs3.utils.config.PropertySetter;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class AuxiliaryCacheConfigurator {
    private static final Log log = LogManager.getLog(AuxiliaryCacheConfigurator.class);
    public static final String ATTRIBUTE_PREFIX = ".attributes";
    public static final String CACHE_EVENT_LOGGER_PREFIX = ".cacheeventlogger";
    public static final String SERIALIZER_PREFIX = ".serializer";

    public static ICacheEventLogger parseCacheEventLogger(Properties props, String auxPrefix) {
        ICacheEventLogger cacheEventLogger = null;
        String eventLoggerClassName = auxPrefix + CACHE_EVENT_LOGGER_PREFIX;
        cacheEventLogger = OptionConverter.instantiateByKey(props, eventLoggerClassName, null);
        if (cacheEventLogger != null) {
            String cacheEventLoggerAttributePrefix = auxPrefix + CACHE_EVENT_LOGGER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(cacheEventLogger, props, cacheEventLoggerAttributePrefix + ".");
            log.info("Using custom cache event logger [{0}] for auxiliary [{1}]", cacheEventLogger, auxPrefix);
        } else {
            log.info("No cache event logger defined for auxiliary [{0}]", auxPrefix);
        }
        return cacheEventLogger;
    }

    public static IElementSerializer parseElementSerializer(Properties props, String auxPrefix) {
        IElementSerializer elementSerializer = null;
        String elementSerializerClassName = auxPrefix + SERIALIZER_PREFIX;
        elementSerializer = OptionConverter.instantiateByKey(props, elementSerializerClassName, null);
        if (elementSerializer != null) {
            String attributePrefix = auxPrefix + SERIALIZER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(elementSerializer, props, attributePrefix + ".");
            log.info("Using custom element serializer [{0}] for auxiliary [{1}]", elementSerializer, auxPrefix);
        } else {
            elementSerializer = new StandardSerializer();
            log.info("Using standard serializer [{0}] for auxiliary [{1}]", elementSerializer, auxPrefix);
        }
        return elementSerializer;
    }
}

