/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.inputmap.InputMap;
import impl.org.controlsfx.tools.rectangle.CoordinatePosition;
import impl.org.controlsfx.tools.rectangle.CoordinatePositions;
import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import impl.org.controlsfx.tools.rectangle.change.MoveChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.NewChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.Rectangle2DChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToEastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNortheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSoutheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToWestChangeStrategy;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewBehavior
extends BehaviorBase<SnapshotView> {
    private static final double RELATIVE_EDGE_TOLERANCE = 0.015;
    private SelectionChange selectionChange;
    private final Consumer<Boolean> setSelectionChanging;
    private final InputMap<SnapshotView> inputMap = this.createInputMap();

    public SnapshotViewBehavior(SnapshotView snapshotView) {
        super(snapshotView);
        this.setSelectionChanging = this.createSetSelectionChanging();
    }

    @Override
    public InputMap<SnapshotView> getInputMap() {
        return this.inputMap;
    }

    private Consumer<Boolean> createSetSelectionChanging() {
        return changing -> ((SnapshotView)this.getNode()).getProperties().put(SnapshotView.SELECTION_CHANGING_PROPERTY_KEY, changing);
    }

    public Cursor handleMouseEvent(MouseEvent mouseEvent) {
        Objects.requireNonNull(mouseEvent, "The argument 'mouseEvent' must not be null.");
        EventType<? extends MouseEvent> eventType = mouseEvent.getEventType();
        SelectionEvent selectionEvent = this.createSelectionEvent(mouseEvent);
        if (eventType == MouseEvent.MOUSE_MOVED) {
            return this.getCursor(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            return this.handleMousePressedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_DRAGGED) {
            return this.handleMouseDraggedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            return this.handleMouseReleasedEvent(selectionEvent);
        }
        return Cursor.DEFAULT;
    }

    private SelectionEvent createSelectionEvent(MouseEvent mouseEvent) {
        Point2D point = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        Rectangle2D selectionBounds = this.createBoundsForCurrentBoundary();
        CoordinatePosition position = this.computePosition(point);
        return new SelectionEvent(mouseEvent, point, selectionBounds, position);
    }

    private Rectangle2D createBoundsForCurrentBoundary() {
        SnapshotView.Boundary boundary = ((SnapshotView)this.getNode()).getSelectionAreaBoundary();
        switch (boundary) {
            case CONTROL: {
                return new Rectangle2D(0.0, 0.0, this.getControlWidth(), this.getControlHeight());
            }
            case NODE: {
                boolean nodeExists;
                boolean bl = nodeExists = this.getSnapshotNode() != null;
                if (nodeExists) {
                    Bounds nodeBounds = this.getSnapshotNode().getBoundsInParent();
                    return Rectangles2D.fromBounds(nodeBounds);
                }
                return Rectangle2D.EMPTY;
            }
        }
        throw new IllegalArgumentException("The boundary " + boundary + " is not fully implemented.");
    }

    private CoordinatePosition computePosition(Point2D point) {
        boolean controlHasNoSpace;
        boolean noSelection = !((SnapshotView)this.getNode()).hasSelection() || !((SnapshotView)this.getNode()).isSelectionActive();
        boolean bl = controlHasNoSpace = this.getControlWidth() == 0.0 || this.getControlHeight() == 0.0;
        if (noSelection || controlHasNoSpace) {
            return CoordinatePosition.OUT_OF_RECTANGLE;
        }
        double tolerance = this.computeTolerance();
        return SnapshotViewBehavior.computePosition(this.getSelection(), point, tolerance);
    }

    private double computeTolerance() {
        double controlMeanLength = Math.sqrt(this.getControlWidth() * this.getControlHeight());
        return 0.015 * controlMeanLength;
    }

    private static CoordinatePosition computePosition(Rectangle2D selection, Point2D point, double tolerance) {
        CoordinatePosition onEdge = CoordinatePositions.onEdges(selection, point, tolerance);
        if (onEdge != null) {
            return onEdge;
        }
        return CoordinatePositions.inRectangle(selection, point);
    }

    private Cursor handleMousePressedEvent(SelectionEvent selectionEvent) {
        if (selectionEvent.isPointInSelectionBounds()) {
            Cursor cursor = this.getCursor(selectionEvent);
            Rectangle2DChangeStrategy selectionChangeStrategy = this.getChangeStrategy(selectionEvent);
            boolean deactivateSelectionIfClick = SnapshotViewBehavior.willDeactivateSelectionIfClick(selectionEvent);
            this.selectionChange = new SelectionChangeByStrategy((SnapshotView)this.getNode(), this.setSelectionChanging, selectionChangeStrategy, cursor, deactivateSelectionIfClick);
            this.selectionChange.beginSelectionChange(selectionEvent.getPoint());
        } else {
            this.selectionChange = NoSelectionChange.INSTANCE;
        }
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseDraggedEvent(SelectionEvent selectionEvent) {
        this.selectionChange.continueSelectionChange(selectionEvent.getPoint());
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseReleasedEvent(SelectionEvent selectionEvent) {
        this.selectionChange.endSelectionChange(selectionEvent.getPoint());
        this.selectionChange = null;
        return this.getCursor(selectionEvent);
    }

    private Cursor getCursor(SelectionEvent selectionEvent) {
        if (!selectionEvent.isPointInSelectionBounds()) {
            return this.getRegularCursor();
        }
        switch (selectionEvent.getPosition()) {
            case IN_RECTANGLE: {
                return Cursor.MOVE;
            }
            case OUT_OF_RECTANGLE: {
                return this.getRegularCursor();
            }
            case NORTH_EDGE: {
                return Cursor.N_RESIZE;
            }
            case NORTHEAST_EDGE: {
                return Cursor.NE_RESIZE;
            }
            case EAST_EDGE: {
                return Cursor.E_RESIZE;
            }
            case SOUTHEAST_EDGE: {
                return Cursor.SE_RESIZE;
            }
            case SOUTH_EDGE: {
                return Cursor.S_RESIZE;
            }
            case SOUTHWEST_EDGE: {
                return Cursor.SW_RESIZE;
            }
            case WEST_EDGE: {
                return Cursor.W_RESIZE;
            }
            case NORTHWEST_EDGE: {
                return Cursor.NW_RESIZE;
            }
        }
        throw new IllegalArgumentException("The position " + selectionEvent.getPosition() + " is not fully implemented.");
    }

    private Cursor getRegularCursor() {
        return ((SnapshotView)this.getNode()).getCursor();
    }

    private Rectangle2DChangeStrategy getChangeStrategy(SelectionEvent selectionEvent) {
        boolean mousePressed;
        boolean bl = mousePressed = selectionEvent.getMouseEvent().getEventType() == MouseEvent.MOUSE_PRESSED;
        if (!mousePressed) {
            throw new IllegalArgumentException();
        }
        Rectangle2D selectionBounds = selectionEvent.getSelectionBounds();
        switch (selectionEvent.getPosition()) {
            case IN_RECTANGLE: {
                return new MoveChangeStrategy(this.getSelection(), selectionBounds);
            }
            case OUT_OF_RECTANGLE: {
                return new NewChangeStrategy(this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case NORTH_EDGE: {
                return new ToNorthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case NORTHEAST_EDGE: {
                return new ToNortheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case EAST_EDGE: {
                return new ToEastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case SOUTHEAST_EDGE: {
                return new ToSoutheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case SOUTH_EDGE: {
                return new ToSouthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case SOUTHWEST_EDGE: {
                return new ToSouthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case WEST_EDGE: {
                return new ToWestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
            case NORTHWEST_EDGE: {
                return new ToNorthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), selectionBounds);
            }
        }
        throw new IllegalArgumentException("The position " + selectionEvent.getPosition() + " is not fully implemented.");
    }

    private static boolean willDeactivateSelectionIfClick(SelectionEvent selectionEvent) {
        boolean rightClick = selectionEvent.getMouseEvent().getButton() == MouseButton.SECONDARY;
        boolean outOfAreaClick = selectionEvent.getPosition() == CoordinatePosition.OUT_OF_RECTANGLE;
        return rightClick || outOfAreaClick;
    }

    private double getControlWidth() {
        return ((SnapshotView)this.getNode()).getWidth();
    }

    private double getControlHeight() {
        return ((SnapshotView)this.getNode()).getHeight();
    }

    private Node getSnapshotNode() {
        return ((SnapshotView)this.getNode()).getNode();
    }

    private Rectangle2D getSelection() {
        return ((SnapshotView)this.getNode()).getSelection();
    }

    private boolean isSelectionRatioFixed() {
        return ((SnapshotView)this.getNode()).isSelectionRatioFixed();
    }

    private double getSelectionRatio() {
        return ((SnapshotView)this.getNode()).getFixedSelectionRatio();
    }

    private static class SelectionChangeByStrategy
    implements SelectionChange {
        private final SnapshotView snapshotView;
        private final Consumer<Boolean> setSelectionChanging;
        private final Rectangle2DChangeStrategy selectionChangeStrategy;
        private final Cursor cursor;
        private final boolean deactivateSelectionIfClick;
        private Point2D startingPoint;
        private boolean mouseMoved;

        public SelectionChangeByStrategy(SnapshotView snapshotView, Consumer<Boolean> setSelectionChanging, Rectangle2DChangeStrategy selectionChangeStrategy, Cursor cursor, boolean deactivateSelectionIfClick) {
            this.snapshotView = snapshotView;
            this.setSelectionChanging = setSelectionChanging;
            this.selectionChangeStrategy = selectionChangeStrategy;
            this.cursor = cursor;
            this.deactivateSelectionIfClick = deactivateSelectionIfClick;
        }

        @Override
        public void beginSelectionChange(Point2D point) {
            this.startingPoint = point;
            this.setSelectionChanging.accept(true);
            Rectangle2D newSelection = this.selectionChangeStrategy.beginChange(point);
            this.snapshotView.setSelection(newSelection);
        }

        @Override
        public void continueSelectionChange(Point2D point) {
            this.updateMouseMoved(point);
            Rectangle2D newSelection = this.selectionChangeStrategy.continueChange(point);
            this.snapshotView.setSelection(newSelection);
        }

        @Override
        public void endSelectionChange(Point2D point) {
            boolean deactivateSelection;
            this.updateMouseMoved(point);
            Rectangle2D newSelection = this.selectionChangeStrategy.endChange(point);
            this.snapshotView.setSelection(newSelection);
            boolean bl = deactivateSelection = this.deactivateSelectionIfClick && !this.mouseMoved;
            if (deactivateSelection) {
                this.snapshotView.setSelection(null);
            }
            this.setSelectionChanging.accept(false);
        }

        private void updateMouseMoved(Point2D point) {
            boolean mouseMovedNow;
            if (this.mouseMoved) {
                return;
            }
            this.mouseMoved = mouseMovedNow = !this.startingPoint.equals(point);
        }

        @Override
        public Cursor getCursor() {
            return this.cursor;
        }
    }

    private static class NoSelectionChange
    implements SelectionChange {
        public static final NoSelectionChange INSTANCE = new NoSelectionChange();

        private NoSelectionChange() {
        }

        @Override
        public void beginSelectionChange(Point2D point) {
        }

        @Override
        public void continueSelectionChange(Point2D point) {
        }

        @Override
        public void endSelectionChange(Point2D point) {
        }

        @Override
        public Cursor getCursor() {
            return Cursor.DEFAULT;
        }
    }

    private static interface SelectionChange {
        public void beginSelectionChange(Point2D var1);

        public void continueSelectionChange(Point2D var1);

        public void endSelectionChange(Point2D var1);

        public Cursor getCursor();
    }

    private static class SelectionEvent {
        private final MouseEvent mouseEvent;
        private final Point2D point;
        private final Rectangle2D selectionBounds;
        private final CoordinatePosition position;

        public SelectionEvent(MouseEvent mouseEvent, Point2D point, Rectangle2D selectionBounds, CoordinatePosition position) {
            this.mouseEvent = mouseEvent;
            this.point = point;
            this.selectionBounds = selectionBounds;
            this.position = position;
        }

        public MouseEvent getMouseEvent() {
            return this.mouseEvent;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public Rectangle2D getSelectionBounds() {
            return this.selectionBounds;
        }

        public boolean isPointInSelectionBounds() {
            return this.selectionBounds.contains(this.point);
        }

        public CoordinatePosition getPosition() {
            return this.position;
        }
    }
}

