/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.text.MessageFormat;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.util.Algorithms;

public class RouteDataObject {
    static final int RESTRICTION_SHIFT = 3;
    static final int RESTRICTION_MASK = 7;
    public final BinaryMapRouteReaderAdapter.RouteRegion region;
    public int[] types;
    public int[] pointsX;
    public int[] pointsY;
    public long[] restrictions;
    public int[][] pointTypes;
    public String[][] pointNames;
    public int[][] pointNameTypes;
    public long id;
    public TIntObjectHashMap<String> names;
    public static final float NONE_MAX_SPEED = 40.0f;
    public int[] nameIds;

    public RouteDataObject(BinaryMapRouteReaderAdapter.RouteRegion region) {
        this.region = region;
    }

    public RouteDataObject(BinaryMapRouteReaderAdapter.RouteRegion region, int[] nameIds, String[] nameValues) {
        this.region = region;
        this.nameIds = nameIds;
        if (nameIds.length > 0) {
            this.names = new TIntObjectHashMap();
        }
        for (int i = 0; i < nameIds.length; ++i) {
            this.names.put(nameIds[i], (Object)nameValues[i]);
        }
    }

    public RouteDataObject(RouteDataObject copy) {
        this.region = copy.region;
        this.pointsX = copy.pointsX;
        this.pointsY = copy.pointsY;
        this.types = copy.types;
        this.names = copy.names;
        this.restrictions = copy.restrictions;
        this.pointTypes = copy.pointTypes;
        this.pointNames = copy.pointNames;
        this.pointNameTypes = copy.pointNameTypes;
        this.id = copy.id;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        if (this.names != null) {
            return (String)this.names.get(this.region.nameTypeRule);
        }
        return null;
    }

    public String getName(String lang) {
        if (this.names != null) {
            if (Algorithms.isEmpty(lang)) {
                return (String)this.names.get(this.region.nameTypeRule);
            }
            int[] kt = this.names.keys();
            for (int i = 0; i < kt.length; ++i) {
                int k = kt[i];
                if (this.region.routeEncodingRules.size() <= k || !("name:" + lang).equals(this.region.routeEncodingRules.get(k).getTag())) continue;
                return (String)this.names.get(k);
            }
            return (String)this.names.get(this.region.nameTypeRule);
        }
        return null;
    }

    public int[] getNameIds() {
        return this.nameIds;
    }

    public TIntObjectHashMap<String> getNames() {
        return this.names;
    }

    public String getRef() {
        if (this.names != null) {
            String ref = (String)this.names.get(this.region.destinationRefTypeRule);
            if (ref != null) {
                return ref;
            }
            return (String)this.names.get(this.region.refTypeRule);
        }
        return null;
    }

    public String getDestinationName(String lang) {
        if (this.names != null) {
            if (Algorithms.isEmpty(lang)) {
                return (String)this.names.get(this.region.destinationTypeRule);
            }
            int[] kt = this.names.keys();
            for (int i = 0; i < kt.length; ++i) {
                int k = kt[i];
                if (this.region.routeEncodingRules.size() <= k || !("destination:" + lang).equals(this.region.routeEncodingRules.get(k).getTag())) continue;
                return (String)this.names.get(k);
            }
            return (String)this.names.get(this.region.destinationTypeRule);
        }
        return null;
    }

    public int getPoint31XTile(int i) {
        return this.pointsX[i];
    }

    public int getPoint31YTile(int i) {
        return this.pointsY[i];
    }

    public int getPointsLength() {
        return this.pointsX.length;
    }

    public int getRestrictionLength() {
        return this.restrictions == null ? 0 : this.restrictions.length;
    }

    public int getRestrictionType(int i) {
        return (int)(this.restrictions[i] & 7L);
    }

    public long getRestrictionId(int i) {
        return this.restrictions[i] >> 3;
    }

    public void insert(int pos, int x31, int y31) {
        int i;
        boolean insTypes;
        int[] opointsX = this.pointsX;
        int[] opointsY = this.pointsY;
        int[][] opointTypes = this.pointTypes;
        this.pointsX = new int[this.pointsX.length + 1];
        this.pointsY = new int[this.pointsY.length + 1];
        boolean bl = insTypes = this.pointTypes != null && this.pointTypes.length > pos;
        if (insTypes) {
            this.pointTypes = new int[opointTypes.length + 1][];
        }
        for (i = 0; i < pos; ++i) {
            this.pointsX[i] = opointsX[i];
            this.pointsY[i] = opointsY[i];
            if (!insTypes) continue;
            this.pointTypes[i] = opointTypes[i];
        }
        this.pointsX[i] = x31;
        this.pointsY[i] = y31;
        if (insTypes) {
            this.pointTypes[i] = null;
        }
        ++i;
        while (i < this.pointsX.length) {
            this.pointsX[i] = opointsX[i - 1];
            this.pointsY[i] = opointsY[i - 1];
            if (insTypes && i < this.pointTypes.length) {
                this.pointTypes[i] = opointTypes[i - 1];
            }
            ++i;
        }
    }

    public String[] getPointNames(int ind) {
        if (this.pointNames == null || ind >= this.pointNames.length) {
            return null;
        }
        return this.pointNames[ind];
    }

    public int[] getPointNameTypes(int ind) {
        if (this.pointNameTypes == null || ind >= this.pointNameTypes.length) {
            return null;
        }
        return this.pointNameTypes[ind];
    }

    public int[] getPointTypes(int ind) {
        if (this.pointTypes == null || ind >= this.pointTypes.length) {
            return null;
        }
        return this.pointTypes[ind];
    }

    public int[] getTypes() {
        return this.types;
    }

    public float getMaximumSpeed(boolean direction) {
        int sz = this.types.length;
        float maxSpeed = 0.0f;
        for (int i = 0; i < sz; ++i) {
            float mx;
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.isForward() != 0 && r.isForward() > 1 != direction || !((mx = r.maxSpeed()) > 0.0f)) continue;
            maxSpeed = mx;
            if (r.conditional()) break;
        }
        return maxSpeed;
    }

    public static float parseSpeed(String v, float def) {
        if (v.equals("none")) {
            return 40.0f;
        }
        int i = Algorithms.findFirstNumberEndIndex(v);
        if (i > 0) {
            float f = Float.parseFloat(v.substring(0, i));
            f = (float)((double)f / 3.6);
            if (v.contains("mph")) {
                f = (float)((double)f * 1.6);
            }
            return f;
        }
        return def;
    }

    public static float parseLength(String v, float def) {
        float f = 0.0f;
        int i = Algorithms.findFirstNumberEndIndex(v);
        if (i > 0) {
            f += Float.parseFloat(v.substring(0, i));
            String pref = v.substring(i, v.length()).trim();
            float add = 0.0f;
            for (int ik = 0; ik < pref.length(); ++ik) {
                if (!Algorithms.isDigit(pref.charAt(ik)) && pref.charAt(ik) != '.' && pref.charAt(ik) != '-') continue;
                int first = Algorithms.findFirstNumberEndIndex(pref.substring(ik));
                if (first == -1) break;
                add = RouteDataObject.parseLength(pref.substring(ik), 0.0f);
                pref = pref.substring(0, ik);
                break;
            }
            if (pref.contains("km")) {
                f *= 1000.0f;
            }
            if (pref.contains("\"")) {
                f = (float)((double)f * 0.0254);
            } else if (pref.contains("'") || pref.contains("ft")) {
                f = (float)((double)f * 0.3048);
            }
            return f + add;
        }
        return def;
    }

    public static float parseWeightInTon(String v, float def) {
        int i = Algorithms.findFirstNumberEndIndex(v);
        if (i > 0) {
            float f = Float.parseFloat(v.substring(0, i));
            if (v.contains("\"") || v.contains("lbs")) {
                f = f * 0.4535f / 1000.0f;
            }
            return f;
        }
        return def;
    }

    public boolean loop() {
        return this.pointsX[0] == this.pointsX[this.pointsX.length - 1] && this.pointsY[0] == this.pointsY[this.pointsY.length - 1];
    }

    public boolean roundabout() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.roundabout()) {
                return true;
            }
            if (r.onewayDirection() == 0 || !this.loop()) continue;
            return true;
        }
        return false;
    }

    public boolean tunnel() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.getTag().equals("tunnel") && r.getValue().equals("yes")) {
                return true;
            }
            if (!r.getTag().equals("layer") || !r.getValue().equals("-1")) continue;
            return true;
        }
        return false;
    }

    public int getOneway() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.onewayDirection() != 0) {
                return r.onewayDirection();
            }
            if (!r.roundabout()) continue;
            return 1;
        }
        return 0;
    }

    public String getRoute() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (!"route".equals(r.getTag())) continue;
            return r.getValue();
        }
        return null;
    }

    public String getHighway() {
        return RouteDataObject.getHighway(this.types, this.region);
    }

    public String getValue(String tag) {
        for (int i = 0; i < this.types.length; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (!r.getTag().equals(tag)) continue;
            return r.getValue();
        }
        return null;
    }

    public static String getHighway(int[] types, BinaryMapRouteReaderAdapter.RouteRegion region) {
        BinaryMapRouteReaderAdapter.RouteTypeRule r;
        String highway = null;
        int sz = types.length;
        for (int i = 0; i < sz && (highway = (r = region.quickGetEncodingRule(types[i])).highwayRoad()) == null; ++i) {
        }
        return highway;
    }

    public int getLanes() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            int ln = r.lanes();
            if (ln <= 0) continue;
            return ln;
        }
        return -1;
    }

    public double directionRoute(int startPoint, boolean plus) {
        return this.directionRoute(startPoint, plus, 5.0f);
    }

    public double distance(int startPoint, int endPoint) {
        if (startPoint > endPoint) {
            int k = endPoint;
            endPoint = startPoint;
            startPoint = k;
        }
        double d = 0.0;
        for (int k = startPoint; k < endPoint && k < this.getPointsLength() - 1; ++k) {
            int x = this.getPoint31XTile(k);
            int y = this.getPoint31YTile(k);
            int kx = this.getPoint31XTile(k + 1);
            int ky = this.getPoint31YTile(k + 1);
            d += this.simplifyDistance(kx, ky, x, y);
        }
        return d;
    }

    public double directionRoute(int startPoint, boolean plus, float dist) {
        int x = this.getPoint31XTile(startPoint);
        int y = this.getPoint31YTile(startPoint);
        int nx = startPoint;
        int px = x;
        int py = y;
        double total = 0.0;
        while (!(!plus ? --nx < 0 : ++nx >= this.getPointsLength()) && (total += this.simplifyDistance(x, y, px = this.getPoint31XTile(nx), py = this.getPoint31YTile(nx))) < (double)dist) {
        }
        return -Math.atan2(x - px, y - py);
    }

    private double simplifyDistance(int x, int y, int px, int py) {
        return (double)Math.abs(px - x) * 0.011 + (double)Math.abs(py - y) * 0.01863;
    }

    private static void assertTrueLength(String vl, float exp) {
        float dest = RouteDataObject.parseLength(vl, 0.0f);
        if (exp != dest) {
            System.err.println("FAIL " + vl + " " + dest);
        } else {
            System.out.println("OK " + vl);
        }
    }

    public static void main(String[] args) {
        RouteDataObject.assertTrueLength("10 km", 10000.0f);
        RouteDataObject.assertTrueLength("0.01 km", 10.0f);
        RouteDataObject.assertTrueLength("0.01 km 10 m", 20.0f);
        RouteDataObject.assertTrueLength("10 m", 10.0f);
        RouteDataObject.assertTrueLength("10m", 10.0f);
        RouteDataObject.assertTrueLength("3.4 m", 3.4f);
        RouteDataObject.assertTrueLength("14'10\"", 4.5212f);
        RouteDataObject.assertTrueLength("14.5'", 4.4196f);
        RouteDataObject.assertTrueLength("15ft", 4.572f);
    }

    public String toString() {
        String name = this.getName();
        String rf = this.getRef();
        return MessageFormat.format("Road id {0} name {1} ref {2}", this.getId() + "", name == null ? "" : name, rf == null ? "" : rf);
    }
}

