/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.Paint;
import org.apache.commons.logging.Log;

public class CursorDistanceLayer
extends OsmandMapLayer
implements DirectOffroadLayer,
IContextMenuProvider {
    private static final Log LOG = PlatformUtil.getLog(CursorDistanceLayer.class);
    protected static final int RADIUS = 7;
    protected static final float HEADING_ANGLE = 60.0f;
    private Paint area;
    private Paint aroundArea;
    private OsmBitmapPanel view;
    private ApplicationMode appMode;
    private boolean nm;

    private void initUI() {
        this.area = new Paint();
        this.area.setColor(this.view.getResources().getColor(R.color.pos_area));
        this.aroundArea = new Paint();
        this.aroundArea.setColor(this.view.getResources().getColor(R.color.pos_around));
        this.aroundArea.setStyle(Paint.Style.STROKE);
        this.aroundArea.setStrokeWidth(7.0f);
        this.aroundArea.setAntiAlias(true);
        this.updateIcons(this.view.getSettings().getApplicationMode(), false);
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.initUI();
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox box, OsmandMapLayer.DrawSettings nightMode) {
        if (!this.view.isCursorRadiusEnabled()) {
            return;
        }
        if (box.getZoom() < 3) {
            return;
        }
        boolean nm = nightMode != null && nightMode.isNightMode();
        this.updateIcons(this.view.getSettings().getApplicationMode(), nm);
        LatLon cursorLocation = this.view.getCursorPosition();
        if (cursorLocation == null || this.view == null) {
            return;
        }
        int locationX = (int)box.getPixXFromLatLon(cursorLocation);
        int locationY = (int)box.getPixYFromLatLon(cursorLocation);
        double dist = box.getDistance(0, box.getPixHeight() / 2, box.getPixWidth(), box.getPixHeight() / 2);
        int radius = (int)((double)box.getPixWidth() / dist * this.view.getCursorRadiusSizeInMeters());
        if ((float)radius > 7.0f * box.getDensity()) {
            this.area.updateGraphics(canvas);
            canvas.fillOval(locationX - radius, locationY - radius, 2 * radius, 2 * radius);
            this.aroundArea.updateGraphics(canvas);
            canvas.drawOval(locationX - radius, locationY - radius, 2 * radius, 2 * radius);
        }
    }

    @Override
    public void destroyLayer() {
    }

    public void updateIcons(ApplicationMode appMode, boolean nighMode) {
        if (appMode != this.appMode || this.nm != nighMode) {
            this.appMode = appMode;
            this.nm = nighMode;
            this.area.setColor(this.view.getResources().getColor(!this.nm ? R.color.pos_area : R.color.pos_area_night));
        }
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    @Override
    public void collectObjectsFromPoint(Point2D point, RotatedTileBox tileBox, List<Object> o) {
        if (this.view.isCursorRadiusEnabled()) {
            this.getMyLocationFromPoint(tileBox, point, o);
        }
    }

    @Override
    public LatLon getObjectLocation(Object o) {
        return this.getMyLocation();
    }

    @Override
    public String getObjectDescription(Object o) {
        return this.view.getResources().getString(1635);
    }

    @Override
    public PointDescription getObjectName(Object o) {
        return new PointDescription("my_location", this.view.getContext().getString(1635), "");
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public boolean isObjectClickable(Object o) {
        return false;
    }

    private LatLon getMyLocation() {
        return this.view.getCursorPosition();
    }

    private void getMyLocationFromPoint(RotatedTileBox tb, Point2D point, List<? super LatLon> myLocation) {
        LatLon location = this.getMyLocation();
        if (location != null && this.view != null) {
            int ex = (int)point.getX();
            int ey = (int)point.getY();
            int x = (int)tb.getPixXFromLatLon(location.getLatitude(), location.getLongitude());
            int y = (int)tb.getPixYFromLatLon(location.getLatitude(), location.getLongitude());
            int rad = (int)(18.0f * tb.getDensity());
            if (Math.abs(x - ex) <= rad && ey - y <= rad && (double)(y - ey) <= 2.5 * (double)rad) {
                myLocation.add(location);
            }
        }
    }
}

