/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class Member
implements CharSequence {
    private final String display;
    private final CharSequence raw;
    private final boolean staticModifier;
    private final boolean abstractModifier;
    private final Url url;
    private final boolean hasUrl;
    private final VisibilityModifier visibilityModifier;

    @Override
    public String toString() {
        return this.raw.toString();
    }

    @Override
    public char charAt(int index) {
        return this.raw.charAt(index);
    }

    @Override
    public int length() {
        return this.raw.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.raw.subSequence(start, end);
    }

    public static Member method(CharSequence tmpDisplay) {
        return new Member(true, tmpDisplay, true);
    }

    public static Member field(CharSequence tmpDisplay) {
        return new Member(true, tmpDisplay, false);
    }

    public static Member method(CharSequence tmpDisplay, boolean manageModifier) {
        return new Member(manageModifier, tmpDisplay, true);
    }

    public static Member field(CharSequence tmpDisplay, boolean manageModifier) {
        return new Member(manageModifier, tmpDisplay, false);
    }

    private Member(boolean manageModifier, CharSequence tmpDisplay, boolean isMethod) {
        this.raw = tmpDisplay;
        tmpDisplay = tmpDisplay.toString().replaceAll("(?i)\\{(method|field)\\}\\s*", "");
        if (manageModifier) {
            Pattern2 finalUrl = MyPattern.cmpile("^(.*?)(?:\\[(" + UrlBuilder.getRegexp() + ")\\])?$");
            Matcher2 matcher = finalUrl.matcher(tmpDisplay);
            if (!matcher.matches()) {
                throw new IllegalStateException();
            }
            tmpDisplay = matcher.group(1);
            String urlString = matcher.group(2);
            this.url = urlString == null ? null : new UrlBuilder(null, UrlBuilder.ModeUrl.STRICT).getUrl(urlString);
        } else {
            this.url = null;
        }
        this.hasUrl = this.url != null;
        String lower = StringUtils.goLowerCase(tmpDisplay.toString());
        if (manageModifier) {
            this.staticModifier = lower.contains("{static}") || lower.contains("{classifier}");
            this.abstractModifier = lower.contains("{abstract}");
            String displayClean = tmpDisplay.toString().replaceAll("(?i)\\{(static|classifier|abstract)\\}\\s*", "").trim();
            if (displayClean.length() == 0) {
                displayClean = " ";
            }
            if (VisibilityModifier.isVisibilityCharacter(displayClean)) {
                this.visibilityModifier = VisibilityModifier.getVisibilityModifier(displayClean, !isMethod);
                this.display = StringUtils.trin(Guillemet.GUILLEMET.manageGuillemet(displayClean.substring(1)));
            } else {
                this.display = Guillemet.GUILLEMET.manageGuillemet(displayClean);
                this.visibilityModifier = null;
            }
        } else {
            this.staticModifier = false;
            this.visibilityModifier = null;
            this.abstractModifier = false;
            this.display = (tmpDisplay = StringUtils.trin(tmpDisplay.toString())).length() == 0 ? " " : Guillemet.GUILLEMET.manageGuillemet(StringUtils.trin(tmpDisplay.toString()));
        }
    }

    public String getDisplay(boolean withVisibilityChar) {
        if (withVisibilityChar) {
            return this.getDisplayWithVisibilityChar();
        }
        return this.getDisplayWithoutVisibilityChar();
    }

    private String getDisplayWithoutVisibilityChar() {
        return this.display;
    }

    private String getDisplayWithVisibilityChar() {
        if (this.isPrivate()) {
            return "-" + this.display;
        }
        if (this.isPublic()) {
            return "+" + this.display;
        }
        if (this.isPackagePrivate()) {
            return "~" + this.display;
        }
        if (this.isProtected()) {
            return "#" + this.display;
        }
        if (this.isIEMandatory()) {
            return "*" + this.display;
        }
        return this.display;
    }

    public boolean equals(Object obj) {
        Member other = (Member)obj;
        return this.display.equals(other.display);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public final boolean isStatic() {
        return this.staticModifier;
    }

    public final boolean isAbstract() {
        return this.abstractModifier;
    }

    private boolean isPrivate() {
        return this.visibilityModifier == VisibilityModifier.PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PRIVATE_METHOD;
    }

    private boolean isProtected() {
        return this.visibilityModifier == VisibilityModifier.PROTECTED_FIELD || this.visibilityModifier == VisibilityModifier.PROTECTED_METHOD;
    }

    private boolean isPublic() {
        return this.visibilityModifier == VisibilityModifier.PUBLIC_FIELD || this.visibilityModifier == VisibilityModifier.PUBLIC_METHOD;
    }

    private boolean isPackagePrivate() {
        return this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_METHOD;
    }

    private boolean isIEMandatory() {
        return this.visibilityModifier == VisibilityModifier.IE_MANDATORY;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public final Url getUrl() {
        return this.url;
    }

    public boolean hasUrl() {
        return this.hasUrl;
    }
}

