/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.DelimiterFactory;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.OverUnderBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class OverUnderDelimiter
extends Atom {
    private final Atom base;
    private Atom script;
    private final SymbolAtom symbol;
    private final SpaceAtom kern;
    private final boolean over;

    public OverUnderDelimiter(Atom base, Atom script, SymbolAtom s, int kernUnit, float kern, boolean over) throws InvalidUnitException {
        this.type = 7;
        this.base = base;
        this.script = script;
        this.symbol = s;
        this.kern = new SpaceAtom(kernUnit, 0.0f, kern, 0.0f);
        this.over = over;
    }

    public void addScript(Atom script) {
        this.script = script;
    }

    public boolean isOver() {
        return this.over;
    }

    public Box createBox(TeXEnvironment env) {
        float max;
        Box b = this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(env);
        Box del = DelimiterFactory.create(this.symbol.getName(), env, b.getWidth());
        Box scriptBox = null;
        if (this.script != null) {
            scriptBox = this.script.createBox(this.over ? env.supStyle() : env.subStyle());
        }
        if ((max = OverUnderDelimiter.getMaxWidth(b, del, scriptBox)) - b.getWidth() > 1.0E-7f) {
            b = new HorizontalBox(b, max, 2);
        }
        del = new VerticalBox(del, max, 2);
        if (scriptBox != null && max - scriptBox.getWidth() > 1.0E-7f) {
            scriptBox = new HorizontalBox(scriptBox, max, 2);
        }
        return new OverUnderBox(b, del, scriptBox, this.kern.createBox(env).getHeight(), this.over);
    }

    private static float getMaxWidth(Box b, Box del, Box script) {
        float max = Math.max(b.getWidth(), del.getHeight() + del.getDepth());
        if (script != null) {
            max = Math.max(max, script.getWidth());
        }
        return max;
    }
}

