/*
 * This declarations of the PIC16LF1786 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:18 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1786_H__
#define __PIC16LF1786_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CM2CON0_ADDR            0x0113
#define CM2CON1_ADDR            0x0114
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DACCON0_ADDR            0x0118
#define DACCON1_ADDR            0x0119
#define CM4CON0_ADDR            0x011A
#define CM4CON1_ADDR            0x011B
#define APFCON2_ADDR            0x011C
#define APFCON_ADDR             0x011D
#define APFCON0_ADDR            0x011D
#define APFCON1_ADDR            0x011D
#define CM3CON0_ADDR            0x011E
#define CM3CON1_ADDR            0x011F
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define EEADR_ADDR              0x0191
#define EEADRL_ADDR             0x0191
#define EEADRH_ADDR             0x0192
#define EEDAT_ADDR              0x0193
#define EEDATL_ADDR             0x0193
#define EEDATH_ADDR             0x0194
#define EECON1_ADDR             0x0195
#define EECON2_ADDR             0x0196
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRG1_ADDR             0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define BAUDCTL_ADDR            0x019F
#define BAUDCTL1_ADDR           0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define WPUC_ADDR               0x020E
#define WPUE_ADDR               0x0210
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define ODCONA_ADDR             0x028C
#define ODCONB_ADDR             0x028D
#define ODCONC_ADDR             0x028E
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define SLRCONA_ADDR            0x030C
#define SLRCONB_ADDR            0x030D
#define SLRCONC_ADDR            0x030E
#define CCPR3_ADDR              0x0311
#define CCPR3L_ADDR             0x0311
#define CCPR3H_ADDR             0x0312
#define CCP3CON_ADDR            0x0313
#define INLVLA_ADDR             0x038C
#define INLVLB_ADDR             0x038D
#define INLVLC_ADDR             0x038E
#define INLVLE_ADDR             0x0390
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define IOCEP_ADDR              0x039D
#define IOCEN_ADDR              0x039E
#define IOCEF_ADDR              0x039F
#define OPA1CON_ADDR            0x0511
#define OPA2CON_ADDR            0x0513
#define CLKRCON_ADDR            0x051A
#define PSMC1CON_ADDR           0x0811
#define PSMC1MDL_ADDR           0x0812
#define PSMC1SYNC_ADDR          0x0813
#define PSMC1CLK_ADDR           0x0814
#define PSMC1OEN_ADDR           0x0815
#define PSMC1POL_ADDR           0x0816
#define PSMC1BLNK_ADDR          0x0817
#define PSMC1REBS_ADDR          0x0818
#define PSMC1FEBS_ADDR          0x0819
#define PSMC1PHS_ADDR           0x081A
#define PSMC1DCS_ADDR           0x081B
#define PSMC1PRS_ADDR           0x081C
#define PSMC1ASDC_ADDR          0x081D
#define PSMC1ASDL_ADDR          0x081E
#define PSMC1ASDS_ADDR          0x081F
#define PSMC1INT_ADDR           0x0820
#define PSMC1PH_ADDR            0x0821
#define PSMC1PHL_ADDR           0x0821
#define PSMC1PHH_ADDR           0x0822
#define PSMC1DC_ADDR            0x0823
#define PSMC1DCL_ADDR           0x0823
#define PSMC1DCH_ADDR           0x0824
#define PSMC1PR_ADDR            0x0825
#define PSMC1PRL_ADDR           0x0825
#define PSMC1PRH_ADDR           0x0826
#define PSMC1TMR_ADDR           0x0827
#define PSMC1TMRL_ADDR          0x0827
#define PSMC1TMRH_ADDR          0x0828
#define PSMC1DBR_ADDR           0x0829
#define PSMC1DBF_ADDR           0x082A
#define PSMC1BLKR_ADDR          0x082B
#define PSMC1BLKF_ADDR          0x082C
#define PSMC1FFA_ADDR           0x082D
#define PSMC1STR0_ADDR          0x082E
#define PSMC1STR1_ADDR          0x082F
#define PSMC2CON_ADDR           0x0831
#define PSMC2MDL_ADDR           0x0832
#define PSMC2SYNC_ADDR          0x0833
#define PSMC2CLK_ADDR           0x0834
#define PSMC2OEN_ADDR           0x0835
#define PSMC2POL_ADDR           0x0836
#define PSMC2BLNK_ADDR          0x0837
#define PSMC2REBS_ADDR          0x0838
#define PSMC2FEBS_ADDR          0x0839
#define PSMC2PHS_ADDR           0x083A
#define PSMC2DCS_ADDR           0x083B
#define PSMC2PRS_ADDR           0x083C
#define PSMC2ASDC_ADDR          0x083D
#define PSMC2ASDL_ADDR          0x083E
#define PSMC2ASDS_ADDR          0x083F
#define PSMC2INT_ADDR           0x0840
#define PSMC2PH_ADDR            0x0841
#define PSMC2PHL_ADDR           0x0841
#define PSMC2PHH_ADDR           0x0842
#define PSMC2DC_ADDR            0x0843
#define PSMC2DCL_ADDR           0x0843
#define PSMC2DCH_ADDR           0x0844
#define PSMC2PR_ADDR            0x0845
#define PSMC2PRL_ADDR           0x0845
#define PSMC2PRH_ADDR           0x0846
#define PSMC2TMR_ADDR           0x0847
#define PSMC2TMRL_ADDR          0x0847
#define PSMC2TMRH_ADDR          0x0848
#define PSMC2DBR_ADDR           0x0849
#define PSMC2DBF_ADDR           0x084A
#define PSMC2BLKR_ADDR          0x084B
#define PSMC2BLKF_ADDR          0x084C
#define PSMC2FFA_ADDR           0x084D
#define PSMC2STR0_ADDR          0x084E
#define PSMC2STR1_ADDR          0x084F
#define PSMC3CON_ADDR           0x0851
#define PSMC3MDL_ADDR           0x0852
#define PSMC3SYNC_ADDR          0x0853
#define PSMC3CLK_ADDR           0x0854
#define PSMC3OEN_ADDR           0x0855
#define PSMC3POL_ADDR           0x0856
#define PSMC3BLNK_ADDR          0x0857
#define PSMC3REBS_ADDR          0x0858
#define PSMC3FEBS_ADDR          0x0859
#define PSMC3PHS_ADDR           0x085A
#define PSMC3DCS_ADDR           0x085B
#define PSMC3PRS_ADDR           0x085C
#define PSMC3ASDC_ADDR          0x085D
#define PSMC3ASDL_ADDR          0x085E
#define PSMC3ASDS_ADDR          0x085F
#define PSMC3INT_ADDR           0x0860
#define PSMC3PH_ADDR            0x0861
#define PSMC3PHL_ADDR           0x0861
#define PSMC3PHH_ADDR           0x0862
#define PSMC3DC_ADDR            0x0863
#define PSMC3DCL_ADDR           0x0863
#define PSMC3DCH_ADDR           0x0864
#define PSMC3PR_ADDR            0x0865
#define PSMC3PRL_ADDR           0x0865
#define PSMC3PRH_ADDR           0x0866
#define PSMC3TMR_ADDR           0x0867
#define PSMC3TMRL_ADDR          0x0867
#define PSMC3TMRH_ADDR          0x0868
#define PSMC3DBR_ADDR           0x0869
#define PSMC3DBF_ADDR           0x086A
#define PSMC3BLKR_ADDR          0x086B
#define PSMC3BLKF_ADDR          0x086C
#define PSMC3FFA_ADDR           0x086D
#define PSMC3STR0_ADDR          0x086E
#define PSMC3STR1_ADDR          0x086F
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RE3                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSP1IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned C3IF                 : 1;
  unsigned C4IF                 : 1;
  unsigned BCL1IF               : 1;
  unsigned EEIF                 : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _C3IF                   0x02
#define _C4IF                   0x04
#define _BCL1IF                 0x08
#define _EEIF                   0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CCP3IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _CCP3IF                 0x10

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned PSMC1SIF             : 1;
  unsigned PSMC2SIF             : 1;
  unsigned PSMC3SIF             : 1;
  unsigned                      : 1;
  unsigned PSMC1TIF             : 1;
  unsigned PSMC2TIF             : 1;
  unsigned PSMC3TIF             : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _PSMC1SIF               0x01
#define _PSMC2SIF               0x02
#define _PSMC3SIF               0x04
#define _PSMC1TIF               0x10
#define _PSMC2TIF               0x20
#define _PSMC3TIF               0x40

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO              : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0090) __sfr TRISE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISE3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISEbits_t;

extern __at(0x0090) volatile __TRISEbits_t TRISEbits;

#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSP1IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned C3IE                 : 1;
  unsigned C4IE                 : 1;
  unsigned BCL1IE               : 1;
  unsigned EEIE                 : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _C3IE                   0x02
#define _C4IE                   0x04
#define _BCL1IE                 0x08
#define _EEIE                   0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned CCP3IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _CCP3IE                 0x10

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef union
  {
  struct
    {
    unsigned PSMC1SIE           : 1;
    unsigned PSMC2SIE           : 1;
    unsigned PSMC3SIE           : 1;
    unsigned                    : 1;
    unsigned PSMC1TIE           : 1;
    unsigned PSMC2TIE           : 1;
    unsigned PSMC3TIE           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PMSC3TIE           : 1;
    unsigned                    : 1;
    };
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _PSMC1SIE               0x01
#define _PSMC2SIE               0x02
#define _PSMC3SIE               0x04
#define _PSMC1TIE               0x10
#define _PSMC2TIE               0x20
#define _PSMC3TIE               0x40
#define _PMSC3TIE               0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned T1OSCR               : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _T1OSCR                 0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned ADRMD              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _DONE                   0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40
#define _ADRMD                  0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned CHSN0              : 1;
    unsigned CHSN1              : 1;
    unsigned CHSN2              : 1;
    unsigned CHSN3              : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned CHSN               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _CHSN0                  0x01
#define _CHSN1                  0x02
#define _CHSN2                  0x04
#define _CHSN3                  0x08
#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned C1ZLF                : 1;
  unsigned C1POL                : 1;
  unsigned C1OE                 : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1ZLF                  0x08
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C1PCH              : 3;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x08
#define _C1PCH1                 0x10
#define _C1PCH2                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0113) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned C2ZLF                : 1;
  unsigned C2POL                : 1;
  unsigned C2OE                 : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x0113) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2ZLF                  0x08
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0114) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2PCH              : 3;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x0114) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2NCH2                 0x04
#define _C2PCH0                 0x08
#define _C2PCH1                 0x10
#define _C2PCH2                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC3OUT               : 1;
  unsigned MC4OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02
#define _MC3OUT                 0x04
#define _MC4OUT                 0x08

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DACCON0 Bits

extern __at(0x0118) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0118) volatile __DACCON0bits_t DACCON0bits;

#define _DACNSS                 0x01
#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE2                 0x10
#define _DACOE1                 0x20
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0119) __sfr DACCON1;

typedef struct
  {
  unsigned DACR0                : 1;
  unsigned DACR1                : 1;
  unsigned DACR2                : 1;
  unsigned DACR3                : 1;
  unsigned DACR4                : 1;
  unsigned DACR5                : 1;
  unsigned DACR6                : 1;
  unsigned DACR7                : 1;
  } __DACCON1bits_t;

extern __at(0x0119) volatile __DACCON1bits_t DACCON1bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10
#define _DACR5                  0x20
#define _DACR6                  0x40
#define _DACR7                  0x80

//==============================================================================


//==============================================================================
//        CM4CON0 Bits

extern __at(0x011A) __sfr CM4CON0;

typedef struct
  {
  unsigned C4SYNC               : 1;
  unsigned C4HYS                : 1;
  unsigned C4SP                 : 1;
  unsigned C4ZLF                : 1;
  unsigned C4POL                : 1;
  unsigned C4OE                 : 1;
  unsigned C4OUT                : 1;
  unsigned C4ON                 : 1;
  } __CM4CON0bits_t;

extern __at(0x011A) volatile __CM4CON0bits_t CM4CON0bits;

#define _C4SYNC                 0x01
#define _C4HYS                  0x02
#define _C4SP                   0x04
#define _C4ZLF                  0x08
#define _C4POL                  0x10
#define _C4OE                   0x20
#define _C4OUT                  0x40
#define _C4ON                   0x80

//==============================================================================


//==============================================================================
//        CM4CON1 Bits

extern __at(0x011B) __sfr CM4CON1;

typedef union
  {
  struct
    {
    unsigned C4NCH0             : 1;
    unsigned C4NCH1             : 1;
    unsigned C4NCH2             : 1;
    unsigned C4PCH0             : 1;
    unsigned C4PCH1             : 1;
    unsigned C4PCH2             : 1;
    unsigned C4INTN             : 1;
    unsigned C4INTP             : 1;
    };

  struct
    {
    unsigned C4NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C4PCH              : 3;
    unsigned                    : 2;
    };
  } __CM4CON1bits_t;

extern __at(0x011B) volatile __CM4CON1bits_t CM4CON1bits;

#define _C4NCH0                 0x01
#define _C4NCH1                 0x02
#define _C4NCH2                 0x04
#define _C4PCH0                 0x08
#define _C4PCH1                 0x10
#define _C4PCH2                 0x20
#define _C4INTN                 0x40
#define _C4INTP                 0x80

//==============================================================================


//==============================================================================
//        APFCON2 Bits

extern __at(0x011C) __sfr APFCON2;

typedef struct
  {
  unsigned CCP3SEL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCON2bits_t;

extern __at(0x011C) volatile __APFCON2bits_t APFCON2bits;

#define _CCP3SEL                0x01

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned CCP2SEL              : 1;
  unsigned RXSEL                : 1;
  unsigned TXSEL                : 1;
  unsigned SDISEL               : 1;
  unsigned SCKSEL               : 1;
  unsigned SDOSEL               : 1;
  unsigned CCP1SEL              : 1;
  unsigned C2OUTSEL             : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _CCP2SEL                0x01
#define _RXSEL                  0x02
#define _TXSEL                  0x04
#define _SDISEL                 0x08
#define _SCKSEL                 0x10
#define _SDOSEL                 0x20
#define _CCP1SEL                0x40
#define _C2OUTSEL               0x80

//==============================================================================


//==============================================================================
//        APFCON0 Bits

extern __at(0x011D) __sfr APFCON0;

typedef struct
  {
  unsigned CCP2SEL              : 1;
  unsigned RXSEL                : 1;
  unsigned TXSEL                : 1;
  unsigned SDISEL               : 1;
  unsigned SCKSEL               : 1;
  unsigned SDOSEL               : 1;
  unsigned CCP1SEL              : 1;
  unsigned C2OUTSEL             : 1;
  } __APFCON0bits_t;

extern __at(0x011D) volatile __APFCON0bits_t APFCON0bits;

#define _APFCON0_CCP2SEL        0x01
#define _APFCON0_RXSEL          0x02
#define _APFCON0_TXSEL          0x04
#define _APFCON0_SDISEL         0x08
#define _APFCON0_SCKSEL         0x10
#define _APFCON0_SDOSEL         0x20
#define _APFCON0_CCP1SEL        0x40
#define _APFCON0_C2OUTSEL       0x80

//==============================================================================


//==============================================================================
//        APFCON1 Bits

extern __at(0x011D) __sfr APFCON1;

typedef struct
  {
  unsigned CCP2SEL              : 1;
  unsigned RXSEL                : 1;
  unsigned TXSEL                : 1;
  unsigned SDISEL               : 1;
  unsigned SCKSEL               : 1;
  unsigned SDOSEL               : 1;
  unsigned CCP1SEL              : 1;
  unsigned C2OUTSEL             : 1;
  } __APFCON1bits_t;

extern __at(0x011D) volatile __APFCON1bits_t APFCON1bits;

#define _APFCON1_CCP2SEL        0x01
#define _APFCON1_RXSEL          0x02
#define _APFCON1_TXSEL          0x04
#define _APFCON1_SDISEL         0x08
#define _APFCON1_SCKSEL         0x10
#define _APFCON1_SDOSEL         0x20
#define _APFCON1_CCP1SEL        0x40
#define _APFCON1_C2OUTSEL       0x80

//==============================================================================


//==============================================================================
//        CM3CON0 Bits

extern __at(0x011E) __sfr CM3CON0;

typedef struct
  {
  unsigned C3SYNC               : 1;
  unsigned C3HYS                : 1;
  unsigned C3SP                 : 1;
  unsigned C3ZLF                : 1;
  unsigned C3POL                : 1;
  unsigned C3OE                 : 1;
  unsigned C3OUT                : 1;
  unsigned C3ON                 : 1;
  } __CM3CON0bits_t;

extern __at(0x011E) volatile __CM3CON0bits_t CM3CON0bits;

#define _C3SYNC                 0x01
#define _C3HYS                  0x02
#define _C3SP                   0x04
#define _C3ZLF                  0x08
#define _C3POL                  0x10
#define _C3OE                   0x20
#define _C3OUT                  0x40
#define _C3ON                   0x80

//==============================================================================


//==============================================================================
//        CM3CON1 Bits

extern __at(0x011F) __sfr CM3CON1;

typedef union
  {
  struct
    {
    unsigned C3NCH0             : 1;
    unsigned C3NCH1             : 1;
    unsigned C3NCH2             : 1;
    unsigned C3PCH0             : 1;
    unsigned C3PCH1             : 1;
    unsigned C3PCH2             : 1;
    unsigned C3INTN             : 1;
    unsigned C3INTP             : 1;
    };

  struct
    {
    unsigned C3NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C3PCH              : 3;
    unsigned                    : 2;
    };
  } __CM3CON1bits_t;

extern __at(0x011F) volatile __CM3CON1bits_t CM3CON1bits;

#define _C3NCH0                 0x01
#define _C3NCH1                 0x02
#define _C3NCH2                 0x04
#define _C3PCH0                 0x08
#define _C3PCH1                 0x10
#define _C3PCH2                 0x20
#define _C3INTN                 0x40
#define _C3INTP                 0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned ANSA4                : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned ANSA7                : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA4                  0x10
#define _ANSA5                  0x20
#define _ANSA7                  0x80

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned ANSB6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 7;
    unsigned                    : 1;
    };
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40

//==============================================================================

extern __at(0x0191) __sfr EEADR;
extern __at(0x0191) __sfr EEADRL;
extern __at(0x0192) __sfr EEADRH;
extern __at(0x0193) __sfr EEDAT;
extern __at(0x0193) __sfr EEDATL;
extern __at(0x0194) __sfr EEDATH;

//==============================================================================
//        EECON1 Bits

extern __at(0x0195) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0195) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0196) __sfr EECON2;
extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRG1;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x019F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x019F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x019F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x019F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef struct
  {
  unsigned WPUA0                : 1;
  unsigned WPUA1                : 1;
  unsigned WPUA2                : 1;
  unsigned WPUA3                : 1;
  unsigned WPUA4                : 1;
  unsigned WPUA5                : 1;
  unsigned WPUA6                : 1;
  unsigned WPUA7                : 1;
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20
#define _WPUA6                  0x40
#define _WPUA7                  0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0210) __sfr WPUE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUE3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUEbits_t;

extern __at(0x0210) volatile __WPUEbits_t WPUEbits;

#define _WPUE3                  0x08

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODCONA0              : 1;
  unsigned ODCONA1              : 1;
  unsigned ODCONA2              : 1;
  unsigned ODCONA3              : 1;
  unsigned ODCONA4              : 1;
  unsigned ODCONA5              : 1;
  unsigned ODCONA6              : 1;
  unsigned ODCONA7              : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODCONA0                0x01
#define _ODCONA1                0x02
#define _ODCONA2                0x04
#define _ODCONA3                0x08
#define _ODCONA4                0x10
#define _ODCONA5                0x20
#define _ODCONA6                0x40
#define _ODCONA7                0x80

//==============================================================================


//==============================================================================
//        ODCONB Bits

extern __at(0x028D) __sfr ODCONB;

typedef struct
  {
  unsigned ODCONB0              : 1;
  unsigned ODCONB1              : 1;
  unsigned ODCONB2              : 1;
  unsigned ODCONB3              : 1;
  unsigned ODCONB4              : 1;
  unsigned ODCONB5              : 1;
  unsigned ODCONB6              : 1;
  unsigned ODCONB7              : 1;
  } __ODCONBbits_t;

extern __at(0x028D) volatile __ODCONBbits_t ODCONBbits;

#define _ODCONB0                0x01
#define _ODCONB1                0x02
#define _ODCONB2                0x04
#define _ODCONB3                0x08
#define _ODCONB4                0x10
#define _ODCONB5                0x20
#define _ODCONB6                0x40
#define _ODCONB7                0x80

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef struct
  {
  unsigned ODCONC0              : 1;
  unsigned ODCONC1              : 1;
  unsigned ODCONC2              : 1;
  unsigned ODCONC3              : 1;
  unsigned ODCONC4              : 1;
  unsigned ODCONC5              : 1;
  unsigned ODCONC6              : 1;
  unsigned ODCONC7              : 1;
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODCONC0                0x01
#define _ODCONC1                0x02
#define _ODCONC2                0x04
#define _ODCONC3                0x08
#define _ODCONC4                0x10
#define _ODCONC5                0x20
#define _ODCONC6                0x40
#define _ODCONC7                0x80

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRCONA0             : 1;
  unsigned SLRCONA1             : 1;
  unsigned SLRCONA2             : 1;
  unsigned SLRCONA3             : 1;
  unsigned SLRCONA4             : 1;
  unsigned SLRCONA5             : 1;
  unsigned SLRCONA6             : 1;
  unsigned SLRCONA7             : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRCONA0               0x01
#define _SLRCONA1               0x02
#define _SLRCONA2               0x04
#define _SLRCONA3               0x08
#define _SLRCONA4               0x10
#define _SLRCONA5               0x20
#define _SLRCONA6               0x40
#define _SLRCONA7               0x80

//==============================================================================


//==============================================================================
//        SLRCONB Bits

extern __at(0x030D) __sfr SLRCONB;

typedef struct
  {
  unsigned SLRCONB0             : 1;
  unsigned SLRCONB1             : 1;
  unsigned SLRCONB2             : 1;
  unsigned SLRCONB3             : 1;
  unsigned SLRCONB4             : 1;
  unsigned SLRCONB5             : 1;
  unsigned SLRCONB6             : 1;
  unsigned SLRCONB7             : 1;
  } __SLRCONBbits_t;

extern __at(0x030D) volatile __SLRCONBbits_t SLRCONBbits;

#define _SLRCONB0               0x01
#define _SLRCONB1               0x02
#define _SLRCONB2               0x04
#define _SLRCONB3               0x08
#define _SLRCONB4               0x10
#define _SLRCONB5               0x20
#define _SLRCONB6               0x40
#define _SLRCONB7               0x80

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef struct
  {
  unsigned SLRCONC0             : 1;
  unsigned SLRCONC1             : 1;
  unsigned SLRCONC2             : 1;
  unsigned SLRCONC3             : 1;
  unsigned SLRCONC4             : 1;
  unsigned SLRCONC5             : 1;
  unsigned SLRCONC6             : 1;
  unsigned SLRCONC7             : 1;
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRCONC0               0x01
#define _SLRCONC1               0x02
#define _SLRCONC2               0x04
#define _SLRCONC3               0x08
#define _SLRCONC4               0x10
#define _SLRCONC5               0x20
#define _SLRCONC6               0x40
#define _SLRCONC7               0x80

//==============================================================================

extern __at(0x0311) __sfr CCPR3;
extern __at(0x0311) __sfr CCPR3L;
extern __at(0x0312) __sfr CCPR3H;

//==============================================================================
//        CCP3CON Bits

extern __at(0x0313) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0313) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _DC3B1                  0x20

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef struct
  {
  unsigned INLVLA0              : 1;
  unsigned INLVLA1              : 1;
  unsigned INLVLA2              : 1;
  unsigned INLVLA3              : 1;
  unsigned INLVLA4              : 1;
  unsigned INLVLA5              : 1;
  unsigned INLVLA6              : 1;
  unsigned INLVLA7              : 1;
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20
#define _INLVLA6                0x40
#define _INLVLA7                0x80

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x038D) __sfr INLVLB;

typedef struct
  {
  unsigned INLVLB0              : 1;
  unsigned INLVLB1              : 1;
  unsigned INLVLB2              : 1;
  unsigned INLVLB3              : 1;
  unsigned INLVLB4              : 1;
  unsigned INLVLB5              : 1;
  unsigned INLVLB6              : 1;
  unsigned INLVLB7              : 1;
  } __INLVLBbits_t;

extern __at(0x038D) volatile __INLVLBbits_t INLVLBbits;

#define _INLVLB0                0x01
#define _INLVLB1                0x02
#define _INLVLB2                0x04
#define _INLVLB3                0x08
#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        INLVLE Bits

extern __at(0x0390) __sfr INLVLE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned INLVLE3              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __INLVLEbits_t;

extern __at(0x0390) volatile __INLVLEbits_t INLVLEbits;

#define _INLVLE3                0x08

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef struct
  {
  unsigned IOCAP0               : 1;
  unsigned IOCAP1               : 1;
  unsigned IOCAP2               : 1;
  unsigned IOCAP3               : 1;
  unsigned IOCAP4               : 1;
  unsigned IOCAP5               : 1;
  unsigned IOCAP6               : 1;
  unsigned IOCAP7               : 1;
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20
#define _IOCAP6                 0x40
#define _IOCAP7                 0x80

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef struct
  {
  unsigned IOCAN0               : 1;
  unsigned IOCAN1               : 1;
  unsigned IOCAN2               : 1;
  unsigned IOCAN3               : 1;
  unsigned IOCAN4               : 1;
  unsigned IOCAN5               : 1;
  unsigned IOCAN6               : 1;
  unsigned IOCAN7               : 1;
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20
#define _IOCAN6                 0x40
#define _IOCAN7                 0x80

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef struct
  {
  unsigned IOCAF0               : 1;
  unsigned IOCAF1               : 1;
  unsigned IOCAF2               : 1;
  unsigned IOCAF3               : 1;
  unsigned IOCAF4               : 1;
  unsigned IOCAF5               : 1;
  unsigned IOCAF6               : 1;
  unsigned IOCAF7               : 1;
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20
#define _IOCAF6                 0x40
#define _IOCAF7                 0x80

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef struct
  {
  unsigned IOCCP0               : 1;
  unsigned IOCCP1               : 1;
  unsigned IOCCP2               : 1;
  unsigned IOCCP3               : 1;
  unsigned IOCCP4               : 1;
  unsigned IOCCP5               : 1;
  unsigned IOCCP6               : 1;
  unsigned IOCCP7               : 1;
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20
#define _IOCCP6                 0x40
#define _IOCCP7                 0x80

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef struct
  {
  unsigned IOCCN0               : 1;
  unsigned IOCCN1               : 1;
  unsigned IOCCN2               : 1;
  unsigned IOCCN3               : 1;
  unsigned IOCCN4               : 1;
  unsigned IOCCN5               : 1;
  unsigned IOCCN6               : 1;
  unsigned IOCCN7               : 1;
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20
#define _IOCCN6                 0x40
#define _IOCCN7                 0x80

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef struct
  {
  unsigned IOCCF0               : 1;
  unsigned IOCCF1               : 1;
  unsigned IOCCF2               : 1;
  unsigned IOCCF3               : 1;
  unsigned IOCCF4               : 1;
  unsigned IOCCF5               : 1;
  unsigned IOCCF6               : 1;
  unsigned IOCCF7               : 1;
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20
#define _IOCCF6                 0x40
#define _IOCCF7                 0x80

//==============================================================================


//==============================================================================
//        IOCEP Bits

extern __at(0x039D) __sfr IOCEP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEP3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEPbits_t;

extern __at(0x039D) volatile __IOCEPbits_t IOCEPbits;

#define _IOCEP3                 0x08

//==============================================================================


//==============================================================================
//        IOCEN Bits

extern __at(0x039E) __sfr IOCEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEN3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCENbits_t;

extern __at(0x039E) volatile __IOCENbits_t IOCENbits;

#define _IOCEN3                 0x08

//==============================================================================


//==============================================================================
//        IOCEF Bits

extern __at(0x039F) __sfr IOCEF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEF3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEFbits_t;

extern __at(0x039F) volatile __IOCEFbits_t IOCEFbits;

#define _IOCEF3                 0x08

//==============================================================================


//==============================================================================
//        OPA1CON Bits

extern __at(0x0511) __sfr OPA1CON;

typedef union
  {
  struct
    {
    unsigned OPA1PCH0           : 1;
    unsigned OPA1PCH1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA1SP             : 1;
    unsigned OPA1EN             : 1;
    };

  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SP                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned OPA1PCH            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PCH                : 2;
    unsigned                    : 6;
    };
  } __OPA1CONbits_t;

extern __at(0x0511) volatile __OPA1CONbits_t OPA1CONbits;

#define _OPA1PCH0               0x01
#define _PCH0                   0x01
#define _OPA1PCH1               0x02
#define _PCH1                   0x02
#define _OPA1SP                 0x40
#define _SP                     0x40
#define _OPA1EN                 0x80
#define _EN                     0x80

//==============================================================================


//==============================================================================
//        OPA2CON Bits

extern __at(0x0513) __sfr OPA2CON;

typedef union
  {
  struct
    {
    unsigned OPA2PCH0           : 1;
    unsigned OPA2PCH1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA2SP             : 1;
    unsigned OPA2EN             : 1;
    };

  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SP                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned PCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned OPA2PCH            : 2;
    unsigned                    : 6;
    };
  } __OPA2CONbits_t;

extern __at(0x0513) volatile __OPA2CONbits_t OPA2CONbits;

#define _OPA2CON_OPA2PCH0       0x01
#define _OPA2CON_PCH0           0x01
#define _OPA2CON_OPA2PCH1       0x02
#define _OPA2CON_PCH1           0x02
#define _OPA2CON_OPA2SP         0x40
#define _OPA2CON_SP             0x40
#define _OPA2CON_OPA2EN         0x80
#define _OPA2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLKRCON Bits

extern __at(0x051A) __sfr CLKRCON;

typedef union
  {
  struct
    {
    unsigned CLKRDIV0           : 1;
    unsigned CLKRDIV1           : 1;
    unsigned CLKRDIV2           : 1;
    unsigned CLKRDC0            : 1;
    unsigned CLKRDC1            : 1;
    unsigned CLKRSLR            : 1;
    unsigned CLKROE             : 1;
    unsigned CLKREN             : 1;
    };

  struct
    {
    unsigned CLKRDIV            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CLKRDC             : 2;
    unsigned                    : 3;
    };
  } __CLKRCONbits_t;

extern __at(0x051A) volatile __CLKRCONbits_t CLKRCONbits;

#define _CLKRDIV0               0x01
#define _CLKRDIV1               0x02
#define _CLKRDIV2               0x04
#define _CLKRDC0                0x08
#define _CLKRDC1                0x10
#define _CLKRSLR                0x20
#define _CLKROE                 0x40
#define _CLKREN                 0x80

//==============================================================================


//==============================================================================
//        PSMC1CON Bits

extern __at(0x0811) __sfr PSMC1CON;

typedef union
  {
  struct
    {
    unsigned P1MODE0            : 1;
    unsigned P1MODE1            : 1;
    unsigned P1MODE2            : 1;
    unsigned P1MODE3            : 1;
    unsigned P1DBRE             : 1;
    unsigned P1DBFE             : 1;
    unsigned PSMC1LD            : 1;
    unsigned PSMC1EN            : 1;
    };

  struct
    {
    unsigned P1MODE             : 4;
    unsigned                    : 4;
    };
  } __PSMC1CONbits_t;

extern __at(0x0811) volatile __PSMC1CONbits_t PSMC1CONbits;

#define _P1MODE0                0x01
#define _P1MODE1                0x02
#define _P1MODE2                0x04
#define _P1MODE3                0x08
#define _P1DBRE                 0x10
#define _P1DBFE                 0x20
#define _PSMC1LD                0x40
#define _PSMC1EN                0x80

//==============================================================================


//==============================================================================
//        PSMC1MDL Bits

extern __at(0x0812) __sfr PSMC1MDL;

typedef union
  {
  struct
    {
    unsigned P1MSRC0            : 1;
    unsigned P1MSRC1            : 1;
    unsigned P1MSRC2            : 1;
    unsigned P1MSRC3            : 1;
    unsigned                    : 1;
    unsigned P1MDLBIT           : 1;
    unsigned P1MDLPOL           : 1;
    unsigned P1MDLEN            : 1;
    };

  struct
    {
    unsigned P1MSRC             : 4;
    unsigned                    : 4;
    };
  } __PSMC1MDLbits_t;

extern __at(0x0812) volatile __PSMC1MDLbits_t PSMC1MDLbits;

#define _P1MSRC0                0x01
#define _P1MSRC1                0x02
#define _P1MSRC2                0x04
#define _P1MSRC3                0x08
#define _P1MDLBIT               0x20
#define _P1MDLPOL               0x40
#define _P1MDLEN                0x80

//==============================================================================


//==============================================================================
//        PSMC1SYNC Bits

extern __at(0x0813) __sfr PSMC1SYNC;

typedef union
  {
  struct
    {
    unsigned P1SYNC0            : 1;
    unsigned P1SYNC1            : 1;
    unsigned P1SYNC2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P1DCPOL            : 1;
    unsigned P1PRPOL            : 1;
    unsigned P1POFST            : 1;
    };

  struct
    {
    unsigned P1SYNC             : 3;
    unsigned                    : 5;
    };
  } __PSMC1SYNCbits_t;

extern __at(0x0813) volatile __PSMC1SYNCbits_t PSMC1SYNCbits;

#define _P1SYNC0                0x01
#define _P1SYNC1                0x02
#define _P1SYNC2                0x04
#define _P1DCPOL                0x20
#define _P1PRPOL                0x40
#define _P1POFST                0x80

//==============================================================================


//==============================================================================
//        PSMC1CLK Bits

extern __at(0x0814) __sfr PSMC1CLK;

typedef union
  {
  struct
    {
    unsigned P1CSRC0            : 1;
    unsigned P1CSRC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P1CPRE0            : 1;
    unsigned P1CPRE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P1CSRC             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P1CPRE             : 2;
    unsigned                    : 2;
    };
  } __PSMC1CLKbits_t;

extern __at(0x0814) volatile __PSMC1CLKbits_t PSMC1CLKbits;

#define _P1CSRC0                0x01
#define _P1CSRC1                0x02
#define _P1CPRE0                0x10
#define _P1CPRE1                0x20

//==============================================================================


//==============================================================================
//        PSMC1OEN Bits

extern __at(0x0815) __sfr PSMC1OEN;

typedef struct
  {
  unsigned P1OEA                : 1;
  unsigned P1OEB                : 1;
  unsigned P1OEC                : 1;
  unsigned P1OED                : 1;
  unsigned P1OEE                : 1;
  unsigned P1OEF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC1OENbits_t;

extern __at(0x0815) volatile __PSMC1OENbits_t PSMC1OENbits;

#define _P1OEA                  0x01
#define _P1OEB                  0x02
#define _P1OEC                  0x04
#define _P1OED                  0x08
#define _P1OEE                  0x10
#define _P1OEF                  0x20

//==============================================================================


//==============================================================================
//        PSMC1POL Bits

extern __at(0x0816) __sfr PSMC1POL;

typedef struct
  {
  unsigned P1POLA               : 1;
  unsigned P1POLB               : 1;
  unsigned P1POLC               : 1;
  unsigned P1POLD               : 1;
  unsigned P1POLE               : 1;
  unsigned P1POLF               : 1;
  unsigned P1INPOL              : 1;
  unsigned                      : 1;
  } __PSMC1POLbits_t;

extern __at(0x0816) volatile __PSMC1POLbits_t PSMC1POLbits;

#define _P1POLA                 0x01
#define _P1POLB                 0x02
#define _P1POLC                 0x04
#define _P1POLD                 0x08
#define _P1POLE                 0x10
#define _P1POLF                 0x20
#define _P1INPOL                0x40

//==============================================================================


//==============================================================================
//        PSMC1BLNK Bits

extern __at(0x0817) __sfr PSMC1BLNK;

typedef union
  {
  struct
    {
    unsigned P1REBM0            : 1;
    unsigned P1REBM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P1FEBM0            : 1;
    unsigned P1FEBM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P1REBM             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P1FEBM             : 2;
    unsigned                    : 2;
    };
  } __PSMC1BLNKbits_t;

extern __at(0x0817) volatile __PSMC1BLNKbits_t PSMC1BLNKbits;

#define _P1REBM0                0x01
#define _P1REBM1                0x02
#define _P1FEBM0                0x10
#define _P1FEBM1                0x20

//==============================================================================


//==============================================================================
//        PSMC1REBS Bits

extern __at(0x0818) __sfr PSMC1REBS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P1REBSC1             : 1;
  unsigned P1REBSC2             : 1;
  unsigned P1REBSC3             : 1;
  unsigned P1REBSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1REBSIN             : 1;
  } __PSMC1REBSbits_t;

extern __at(0x0818) volatile __PSMC1REBSbits_t PSMC1REBSbits;

#define _P1REBSC1               0x02
#define _P1REBSC2               0x04
#define _P1REBSC3               0x08
#define _P1REBSC4               0x10
#define _P1REBSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC1FEBS Bits

extern __at(0x0819) __sfr PSMC1FEBS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P1FEBSC1             : 1;
  unsigned P1FEBSC2             : 1;
  unsigned P1FEBSC3             : 1;
  unsigned P1FEBSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1FEBSIN             : 1;
  } __PSMC1FEBSbits_t;

extern __at(0x0819) volatile __PSMC1FEBSbits_t PSMC1FEBSbits;

#define _P1FEBSC1               0x02
#define _P1FEBSC2               0x04
#define _P1FEBSC3               0x08
#define _P1FEBSC4               0x10
#define _P1FEBSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC1PHS Bits

extern __at(0x081A) __sfr PSMC1PHS;

typedef struct
  {
  unsigned P1PHST               : 1;
  unsigned P1PHSC1              : 1;
  unsigned P1PHSC2              : 1;
  unsigned P1PHSC3              : 1;
  unsigned P1PHSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1PHSIN              : 1;
  } __PSMC1PHSbits_t;

extern __at(0x081A) volatile __PSMC1PHSbits_t PSMC1PHSbits;

#define _P1PHST                 0x01
#define _P1PHSC1                0x02
#define _P1PHSC2                0x04
#define _P1PHSC3                0x08
#define _P1PHSC4                0x10
#define _P1PHSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC1DCS Bits

extern __at(0x081B) __sfr PSMC1DCS;

typedef struct
  {
  unsigned P1DCST               : 1;
  unsigned P1DCSC1              : 1;
  unsigned P1DCSC2              : 1;
  unsigned P1DCSC3              : 1;
  unsigned P1DCSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1DCSIN              : 1;
  } __PSMC1DCSbits_t;

extern __at(0x081B) volatile __PSMC1DCSbits_t PSMC1DCSbits;

#define _P1DCST                 0x01
#define _P1DCSC1                0x02
#define _P1DCSC2                0x04
#define _P1DCSC3                0x08
#define _P1DCSC4                0x10
#define _P1DCSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC1PRS Bits

extern __at(0x081C) __sfr PSMC1PRS;

typedef struct
  {
  unsigned P1PRST               : 1;
  unsigned P1PRSC1              : 1;
  unsigned P1PRSC2              : 1;
  unsigned P1PRSC3              : 1;
  unsigned P1PRSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1PRSIN              : 1;
  } __PSMC1PRSbits_t;

extern __at(0x081C) volatile __PSMC1PRSbits_t PSMC1PRSbits;

#define _P1PRST                 0x01
#define _P1PRSC1                0x02
#define _P1PRSC2                0x04
#define _P1PRSC3                0x08
#define _P1PRSC4                0x10
#define _P1PRSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC1ASDC Bits

extern __at(0x081D) __sfr PSMC1ASDC;

typedef struct
  {
  unsigned P1ASDOV              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1ARSEN              : 1;
  unsigned P1ASDEN              : 1;
  unsigned P1ASE                : 1;
  } __PSMC1ASDCbits_t;

extern __at(0x081D) volatile __PSMC1ASDCbits_t PSMC1ASDCbits;

#define _P1ASDOV                0x01
#define _P1ARSEN                0x20
#define _P1ASDEN                0x40
#define _P1ASE                  0x80

//==============================================================================


//==============================================================================
//        PSMC1ASDL Bits

extern __at(0x081E) __sfr PSMC1ASDL;

typedef struct
  {
  unsigned P1ASDLA              : 1;
  unsigned P1ASDLB              : 1;
  unsigned P1ASDLC              : 1;
  unsigned P1ASDLD              : 1;
  unsigned P1ASDLE              : 1;
  unsigned P1ASDLF              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC1ASDLbits_t;

extern __at(0x081E) volatile __PSMC1ASDLbits_t PSMC1ASDLbits;

#define _P1ASDLA                0x01
#define _P1ASDLB                0x02
#define _P1ASDLC                0x04
#define _P1ASDLD                0x08
#define _P1ASDLE                0x10
#define _P1ASDLF                0x20

//==============================================================================


//==============================================================================
//        PSMC1ASDS Bits

extern __at(0x081F) __sfr PSMC1ASDS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P1ASDSC1             : 1;
  unsigned P1ASDSC2             : 1;
  unsigned P1ASDSC3             : 1;
  unsigned P1ASDSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1ASDSIN             : 1;
  } __PSMC1ASDSbits_t;

extern __at(0x081F) volatile __PSMC1ASDSbits_t PSMC1ASDSbits;

#define _P1ASDSC1               0x02
#define _P1ASDSC2               0x04
#define _P1ASDSC3               0x08
#define _P1ASDSC4               0x10
#define _P1ASDSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC1INT Bits

extern __at(0x0820) __sfr PSMC1INT;

typedef struct
  {
  unsigned P1TPRIF              : 1;
  unsigned P1TDCIF              : 1;
  unsigned P1TPHIF              : 1;
  unsigned P1TOVIF              : 1;
  unsigned P1TPRIE              : 1;
  unsigned P1TDCIE              : 1;
  unsigned P1TPHIE              : 1;
  unsigned P1TOVIE              : 1;
  } __PSMC1INTbits_t;

extern __at(0x0820) volatile __PSMC1INTbits_t PSMC1INTbits;

#define _P1TPRIF                0x01
#define _P1TDCIF                0x02
#define _P1TPHIF                0x04
#define _P1TOVIF                0x08
#define _P1TPRIE                0x10
#define _P1TDCIE                0x20
#define _P1TPHIE                0x40
#define _P1TOVIE                0x80

//==============================================================================

extern __at(0x0821) __sfr PSMC1PH;

//==============================================================================
//        PSMC1PHL Bits

extern __at(0x0821) __sfr PSMC1PHL;

typedef struct
  {
  unsigned PSMC1PH0             : 1;
  unsigned PSMC1PH1             : 1;
  unsigned PSMC1PH2             : 1;
  unsigned PSMC1PH3             : 1;
  unsigned PSMC1PH4             : 1;
  unsigned PSMC1PH5             : 1;
  unsigned PSMC1PH6             : 1;
  unsigned PSMC1PH7             : 1;
  } __PSMC1PHLbits_t;

extern __at(0x0821) volatile __PSMC1PHLbits_t PSMC1PHLbits;

#define _PSMC1PH0               0x01
#define _PSMC1PH1               0x02
#define _PSMC1PH2               0x04
#define _PSMC1PH3               0x08
#define _PSMC1PH4               0x10
#define _PSMC1PH5               0x20
#define _PSMC1PH6               0x40
#define _PSMC1PH7               0x80

//==============================================================================


//==============================================================================
//        PSMC1PHH Bits

extern __at(0x0822) __sfr PSMC1PHH;

typedef struct
  {
  unsigned PSMC1PH8             : 1;
  unsigned PSMC1PH9             : 1;
  unsigned PSMC1PH10            : 1;
  unsigned PSMC1PH11            : 1;
  unsigned PSMC1PH12            : 1;
  unsigned PSMC1PH13            : 1;
  unsigned PSMC1PH14            : 1;
  unsigned PSMC1PH15            : 1;
  } __PSMC1PHHbits_t;

extern __at(0x0822) volatile __PSMC1PHHbits_t PSMC1PHHbits;

#define _PSMC1PH8               0x01
#define _PSMC1PH9               0x02
#define _PSMC1PH10              0x04
#define _PSMC1PH11              0x08
#define _PSMC1PH12              0x10
#define _PSMC1PH13              0x20
#define _PSMC1PH14              0x40
#define _PSMC1PH15              0x80

//==============================================================================

extern __at(0x0823) __sfr PSMC1DC;

//==============================================================================
//        PSMC1DCL Bits

extern __at(0x0823) __sfr PSMC1DCL;

typedef struct
  {
  unsigned PSMC1DC0             : 1;
  unsigned PSMC1DC1             : 1;
  unsigned PSMC1DC2             : 1;
  unsigned PSMC1DC3             : 1;
  unsigned PSMC1DC4             : 1;
  unsigned PSMC1DC5             : 1;
  unsigned PSMC1DC6             : 1;
  unsigned PSMC1DC7             : 1;
  } __PSMC1DCLbits_t;

extern __at(0x0823) volatile __PSMC1DCLbits_t PSMC1DCLbits;

#define _PSMC1DC0               0x01
#define _PSMC1DC1               0x02
#define _PSMC1DC2               0x04
#define _PSMC1DC3               0x08
#define _PSMC1DC4               0x10
#define _PSMC1DC5               0x20
#define _PSMC1DC6               0x40
#define _PSMC1DC7               0x80

//==============================================================================


//==============================================================================
//        PSMC1DCH Bits

extern __at(0x0824) __sfr PSMC1DCH;

typedef struct
  {
  unsigned PSMC1DC8             : 1;
  unsigned PSMC1DC9             : 1;
  unsigned PSMC1DC10            : 1;
  unsigned PSMC1DC11            : 1;
  unsigned PSMC1DC12            : 1;
  unsigned PSMC1DC13            : 1;
  unsigned PSMC1DC14            : 1;
  unsigned PSMC1DC15            : 1;
  } __PSMC1DCHbits_t;

extern __at(0x0824) volatile __PSMC1DCHbits_t PSMC1DCHbits;

#define _PSMC1DC8               0x01
#define _PSMC1DC9               0x02
#define _PSMC1DC10              0x04
#define _PSMC1DC11              0x08
#define _PSMC1DC12              0x10
#define _PSMC1DC13              0x20
#define _PSMC1DC14              0x40
#define _PSMC1DC15              0x80

//==============================================================================

extern __at(0x0825) __sfr PSMC1PR;

//==============================================================================
//        PSMC1PRL Bits

extern __at(0x0825) __sfr PSMC1PRL;

typedef struct
  {
  unsigned PSMC1PR0             : 1;
  unsigned PSMC1PR1             : 1;
  unsigned PSMC1PR2             : 1;
  unsigned PSMC1PR3             : 1;
  unsigned PSMC1PR4             : 1;
  unsigned PSMC1PR5             : 1;
  unsigned PSMC1PR6             : 1;
  unsigned PSMC1PR7             : 1;
  } __PSMC1PRLbits_t;

extern __at(0x0825) volatile __PSMC1PRLbits_t PSMC1PRLbits;

#define _PSMC1PR0               0x01
#define _PSMC1PR1               0x02
#define _PSMC1PR2               0x04
#define _PSMC1PR3               0x08
#define _PSMC1PR4               0x10
#define _PSMC1PR5               0x20
#define _PSMC1PR6               0x40
#define _PSMC1PR7               0x80

//==============================================================================


//==============================================================================
//        PSMC1PRH Bits

extern __at(0x0826) __sfr PSMC1PRH;

typedef struct
  {
  unsigned PSMC1PR8             : 1;
  unsigned PSMC1PR9             : 1;
  unsigned PSMC1PR10            : 1;
  unsigned PSMC1PR11            : 1;
  unsigned PSMC1PR12            : 1;
  unsigned PSMC1PR13            : 1;
  unsigned PSMC1PR14            : 1;
  unsigned PSMC1PR15            : 1;
  } __PSMC1PRHbits_t;

extern __at(0x0826) volatile __PSMC1PRHbits_t PSMC1PRHbits;

#define _PSMC1PR8               0x01
#define _PSMC1PR9               0x02
#define _PSMC1PR10              0x04
#define _PSMC1PR11              0x08
#define _PSMC1PR12              0x10
#define _PSMC1PR13              0x20
#define _PSMC1PR14              0x40
#define _PSMC1PR15              0x80

//==============================================================================

extern __at(0x0827) __sfr PSMC1TMR;

//==============================================================================
//        PSMC1TMRL Bits

extern __at(0x0827) __sfr PSMC1TMRL;

typedef struct
  {
  unsigned PSMC1TMR0            : 1;
  unsigned PSMC1TMR1            : 1;
  unsigned PSMC1TMR2            : 1;
  unsigned PSMC1TMR3            : 1;
  unsigned PSMC1TMR4            : 1;
  unsigned PSMC1TMR5            : 1;
  unsigned PSMC1TMR6            : 1;
  unsigned PSMC1TMR7            : 1;
  } __PSMC1TMRLbits_t;

extern __at(0x0827) volatile __PSMC1TMRLbits_t PSMC1TMRLbits;

#define _PSMC1TMR0              0x01
#define _PSMC1TMR1              0x02
#define _PSMC1TMR2              0x04
#define _PSMC1TMR3              0x08
#define _PSMC1TMR4              0x10
#define _PSMC1TMR5              0x20
#define _PSMC1TMR6              0x40
#define _PSMC1TMR7              0x80

//==============================================================================


//==============================================================================
//        PSMC1TMRH Bits

extern __at(0x0828) __sfr PSMC1TMRH;

typedef struct
  {
  unsigned PSMC1TMR8            : 1;
  unsigned PSMC1TMR9            : 1;
  unsigned PSMC1TMR10           : 1;
  unsigned PSMC1TMR11           : 1;
  unsigned PSMC1TMR12           : 1;
  unsigned PSMC1TMR13           : 1;
  unsigned PSMC1TMR14           : 1;
  unsigned PSMC1TMR15           : 1;
  } __PSMC1TMRHbits_t;

extern __at(0x0828) volatile __PSMC1TMRHbits_t PSMC1TMRHbits;

#define _PSMC1TMR8              0x01
#define _PSMC1TMR9              0x02
#define _PSMC1TMR10             0x04
#define _PSMC1TMR11             0x08
#define _PSMC1TMR12             0x10
#define _PSMC1TMR13             0x20
#define _PSMC1TMR14             0x40
#define _PSMC1TMR15             0x80

//==============================================================================


//==============================================================================
//        PSMC1DBR Bits

extern __at(0x0829) __sfr PSMC1DBR;

typedef struct
  {
  unsigned PSMC1DBR0            : 1;
  unsigned PSMC1DBR1            : 1;
  unsigned PSMC1DBR2            : 1;
  unsigned PSMC1DBR3            : 1;
  unsigned PSMC1DBR4            : 1;
  unsigned PSMC1DBR5            : 1;
  unsigned PSMC1DBR6            : 1;
  unsigned PSMC1DBR7            : 1;
  } __PSMC1DBRbits_t;

extern __at(0x0829) volatile __PSMC1DBRbits_t PSMC1DBRbits;

#define _PSMC1DBR0              0x01
#define _PSMC1DBR1              0x02
#define _PSMC1DBR2              0x04
#define _PSMC1DBR3              0x08
#define _PSMC1DBR4              0x10
#define _PSMC1DBR5              0x20
#define _PSMC1DBR6              0x40
#define _PSMC1DBR7              0x80

//==============================================================================


//==============================================================================
//        PSMC1DBF Bits

extern __at(0x082A) __sfr PSMC1DBF;

typedef struct
  {
  unsigned PSMC1DBF0            : 1;
  unsigned PSMC1DBF1            : 1;
  unsigned PSMC1DBF2            : 1;
  unsigned PSMC1DBF3            : 1;
  unsigned PSMC1DBF4            : 1;
  unsigned PSMC1DBF5            : 1;
  unsigned PSMC1DBF6            : 1;
  unsigned PSMC1DBF7            : 1;
  } __PSMC1DBFbits_t;

extern __at(0x082A) volatile __PSMC1DBFbits_t PSMC1DBFbits;

#define _PSMC1DBF0              0x01
#define _PSMC1DBF1              0x02
#define _PSMC1DBF2              0x04
#define _PSMC1DBF3              0x08
#define _PSMC1DBF4              0x10
#define _PSMC1DBF5              0x20
#define _PSMC1DBF6              0x40
#define _PSMC1DBF7              0x80

//==============================================================================


//==============================================================================
//        PSMC1BLKR Bits

extern __at(0x082B) __sfr PSMC1BLKR;

typedef struct
  {
  unsigned PSMC1BLKR0           : 1;
  unsigned PSMC1BLKR1           : 1;
  unsigned PSMC1BLKR2           : 1;
  unsigned PSMC1BLKR3           : 1;
  unsigned PSMC1BLKR4           : 1;
  unsigned PSMC1BLKR5           : 1;
  unsigned PSMC1BLKR6           : 1;
  unsigned PSMC1BLKR7           : 1;
  } __PSMC1BLKRbits_t;

extern __at(0x082B) volatile __PSMC1BLKRbits_t PSMC1BLKRbits;

#define _PSMC1BLKR0             0x01
#define _PSMC1BLKR1             0x02
#define _PSMC1BLKR2             0x04
#define _PSMC1BLKR3             0x08
#define _PSMC1BLKR4             0x10
#define _PSMC1BLKR5             0x20
#define _PSMC1BLKR6             0x40
#define _PSMC1BLKR7             0x80

//==============================================================================


//==============================================================================
//        PSMC1BLKF Bits

extern __at(0x082C) __sfr PSMC1BLKF;

typedef struct
  {
  unsigned PSMC1BLKF0           : 1;
  unsigned PSMC1BLKF1           : 1;
  unsigned PSMC1BLKF2           : 1;
  unsigned PSMC1BLKF3           : 1;
  unsigned PSMC1BLKF4           : 1;
  unsigned PSMC1BLKF5           : 1;
  unsigned PSMC1BLKF6           : 1;
  unsigned PSMC1BLKF7           : 1;
  } __PSMC1BLKFbits_t;

extern __at(0x082C) volatile __PSMC1BLKFbits_t PSMC1BLKFbits;

#define _PSMC1BLKF0             0x01
#define _PSMC1BLKF1             0x02
#define _PSMC1BLKF2             0x04
#define _PSMC1BLKF3             0x08
#define _PSMC1BLKF4             0x10
#define _PSMC1BLKF5             0x20
#define _PSMC1BLKF6             0x40
#define _PSMC1BLKF7             0x80

//==============================================================================


//==============================================================================
//        PSMC1FFA Bits

extern __at(0x082D) __sfr PSMC1FFA;

typedef union
  {
  struct
    {
    unsigned PSMC1FFA0          : 1;
    unsigned PSMC1FFA1          : 1;
    unsigned PSMC1FFA2          : 1;
    unsigned PSMC1FFA3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSMC1FFA           : 4;
    unsigned                    : 4;
    };
  } __PSMC1FFAbits_t;

extern __at(0x082D) volatile __PSMC1FFAbits_t PSMC1FFAbits;

#define _PSMC1FFA0              0x01
#define _PSMC1FFA1              0x02
#define _PSMC1FFA2              0x04
#define _PSMC1FFA3              0x08

//==============================================================================


//==============================================================================
//        PSMC1STR0 Bits

extern __at(0x082E) __sfr PSMC1STR0;

typedef struct
  {
  unsigned P1STRA               : 1;
  unsigned P1STRB               : 1;
  unsigned P1STRC               : 1;
  unsigned P1STRD               : 1;
  unsigned P1STRE               : 1;
  unsigned P1STRF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC1STR0bits_t;

extern __at(0x082E) volatile __PSMC1STR0bits_t PSMC1STR0bits;

#define _P1STRA                 0x01
#define _P1STRB                 0x02
#define _P1STRC                 0x04
#define _P1STRD                 0x08
#define _P1STRE                 0x10
#define _P1STRF                 0x20

//==============================================================================


//==============================================================================
//        PSMC1STR1 Bits

extern __at(0x082F) __sfr PSMC1STR1;

typedef struct
  {
  unsigned P1HSMEN              : 1;
  unsigned P1LSMEN              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P1SSYNC              : 1;
  } __PSMC1STR1bits_t;

extern __at(0x082F) volatile __PSMC1STR1bits_t PSMC1STR1bits;

#define _P1HSMEN                0x01
#define _P1LSMEN                0x02
#define _P1SSYNC                0x80

//==============================================================================


//==============================================================================
//        PSMC2CON Bits

extern __at(0x0831) __sfr PSMC2CON;

typedef union
  {
  struct
    {
    unsigned P2MODE0            : 1;
    unsigned P2MODE1            : 1;
    unsigned P2MODE2            : 1;
    unsigned P2MODE3            : 1;
    unsigned P2DBRE             : 1;
    unsigned P2DBFE             : 1;
    unsigned PSMC2LD            : 1;
    unsigned PSMC2EN            : 1;
    };

  struct
    {
    unsigned P2MODE             : 4;
    unsigned                    : 4;
    };
  } __PSMC2CONbits_t;

extern __at(0x0831) volatile __PSMC2CONbits_t PSMC2CONbits;

#define _P2MODE0                0x01
#define _P2MODE1                0x02
#define _P2MODE2                0x04
#define _P2MODE3                0x08
#define _P2DBRE                 0x10
#define _P2DBFE                 0x20
#define _PSMC2LD                0x40
#define _PSMC2EN                0x80

//==============================================================================


//==============================================================================
//        PSMC2MDL Bits

extern __at(0x0832) __sfr PSMC2MDL;

typedef union
  {
  struct
    {
    unsigned P2MSRC0            : 1;
    unsigned P2MSRC1            : 1;
    unsigned P2MSRC2            : 1;
    unsigned P2MSRC3            : 1;
    unsigned                    : 1;
    unsigned P2MDLBIT           : 1;
    unsigned P2MDLPOL           : 1;
    unsigned P2MDLEN            : 1;
    };

  struct
    {
    unsigned P2MSRC             : 4;
    unsigned                    : 4;
    };
  } __PSMC2MDLbits_t;

extern __at(0x0832) volatile __PSMC2MDLbits_t PSMC2MDLbits;

#define _P2MSRC0                0x01
#define _P2MSRC1                0x02
#define _P2MSRC2                0x04
#define _P2MSRC3                0x08
#define _P2MDLBIT               0x20
#define _P2MDLPOL               0x40
#define _P2MDLEN                0x80

//==============================================================================


//==============================================================================
//        PSMC2SYNC Bits

extern __at(0x0833) __sfr PSMC2SYNC;

typedef union
  {
  struct
    {
    unsigned P2SYNC0            : 1;
    unsigned P2SYNC1            : 1;
    unsigned P2SYNC2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P2DCPOL            : 1;
    unsigned P2PRPOL            : 1;
    unsigned P2POFST            : 1;
    };

  struct
    {
    unsigned P2SYNC             : 3;
    unsigned                    : 5;
    };
  } __PSMC2SYNCbits_t;

extern __at(0x0833) volatile __PSMC2SYNCbits_t PSMC2SYNCbits;

#define _P2SYNC0                0x01
#define _P2SYNC1                0x02
#define _P2SYNC2                0x04
#define _P2DCPOL                0x20
#define _P2PRPOL                0x40
#define _P2POFST                0x80

//==============================================================================


//==============================================================================
//        PSMC2CLK Bits

extern __at(0x0834) __sfr PSMC2CLK;

typedef union
  {
  struct
    {
    unsigned P2CSRC0            : 1;
    unsigned P2CSRC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P2CPRE0            : 1;
    unsigned P2CPRE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P2CSRC             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P2CPRE             : 2;
    unsigned                    : 2;
    };
  } __PSMC2CLKbits_t;

extern __at(0x0834) volatile __PSMC2CLKbits_t PSMC2CLKbits;

#define _P2CSRC0                0x01
#define _P2CSRC1                0x02
#define _P2CPRE0                0x10
#define _P2CPRE1                0x20

//==============================================================================


//==============================================================================
//        PSMC2OEN Bits

extern __at(0x0835) __sfr PSMC2OEN;

typedef struct
  {
  unsigned P2OEA                : 1;
  unsigned P2OEB                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC2OENbits_t;

extern __at(0x0835) volatile __PSMC2OENbits_t PSMC2OENbits;

#define _P2OEA                  0x01
#define _P2OEB                  0x02

//==============================================================================


//==============================================================================
//        PSMC2POL Bits

extern __at(0x0836) __sfr PSMC2POL;

typedef struct
  {
  unsigned P2POLA               : 1;
  unsigned P2POLB               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2INPOL              : 1;
  unsigned                      : 1;
  } __PSMC2POLbits_t;

extern __at(0x0836) volatile __PSMC2POLbits_t PSMC2POLbits;

#define _P2POLA                 0x01
#define _P2POLB                 0x02
#define _P2INPOL                0x40

//==============================================================================


//==============================================================================
//        PSMC2BLNK Bits

extern __at(0x0837) __sfr PSMC2BLNK;

typedef union
  {
  struct
    {
    unsigned P2REBM0            : 1;
    unsigned P2REBM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P2FEBM0            : 1;
    unsigned P2FEBM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P2REBM             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P2FEBM             : 2;
    unsigned                    : 2;
    };
  } __PSMC2BLNKbits_t;

extern __at(0x0837) volatile __PSMC2BLNKbits_t PSMC2BLNKbits;

#define _P2REBM0                0x01
#define _P2REBM1                0x02
#define _P2FEBM0                0x10
#define _P2FEBM1                0x20

//==============================================================================


//==============================================================================
//        PSMC2REBS Bits

extern __at(0x0838) __sfr PSMC2REBS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P2REBSC1             : 1;
  unsigned P2REBSC2             : 1;
  unsigned P2REBSC3             : 1;
  unsigned P2REBSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2REBSIN             : 1;
  } __PSMC2REBSbits_t;

extern __at(0x0838) volatile __PSMC2REBSbits_t PSMC2REBSbits;

#define _P2REBSC1               0x02
#define _P2REBSC2               0x04
#define _P2REBSC3               0x08
#define _P2REBSC4               0x10
#define _P2REBSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC2FEBS Bits

extern __at(0x0839) __sfr PSMC2FEBS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P2FEBSC1             : 1;
  unsigned P2FEBSC2             : 1;
  unsigned P2FEBSC3             : 1;
  unsigned P2FEBSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2FEBSIN             : 1;
  } __PSMC2FEBSbits_t;

extern __at(0x0839) volatile __PSMC2FEBSbits_t PSMC2FEBSbits;

#define _P2FEBSC1               0x02
#define _P2FEBSC2               0x04
#define _P2FEBSC3               0x08
#define _P2FEBSC4               0x10
#define _P2FEBSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC2PHS Bits

extern __at(0x083A) __sfr PSMC2PHS;

typedef struct
  {
  unsigned P2PHST               : 1;
  unsigned P2PHSC1              : 1;
  unsigned P2PHSC2              : 1;
  unsigned P2PHSC3              : 1;
  unsigned P2PHSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2PHSIN              : 1;
  } __PSMC2PHSbits_t;

extern __at(0x083A) volatile __PSMC2PHSbits_t PSMC2PHSbits;

#define _P2PHST                 0x01
#define _P2PHSC1                0x02
#define _P2PHSC2                0x04
#define _P2PHSC3                0x08
#define _P2PHSC4                0x10
#define _P2PHSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC2DCS Bits

extern __at(0x083B) __sfr PSMC2DCS;

typedef struct
  {
  unsigned P2DCST               : 1;
  unsigned P2DCSC1              : 1;
  unsigned P2DCSC2              : 1;
  unsigned P2DCSC3              : 1;
  unsigned P2DCSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2DCSIN              : 1;
  } __PSMC2DCSbits_t;

extern __at(0x083B) volatile __PSMC2DCSbits_t PSMC2DCSbits;

#define _P2DCST                 0x01
#define _P2DCSC1                0x02
#define _P2DCSC2                0x04
#define _P2DCSC3                0x08
#define _P2DCSC4                0x10
#define _P2DCSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC2PRS Bits

extern __at(0x083C) __sfr PSMC2PRS;

typedef struct
  {
  unsigned P2PRST               : 1;
  unsigned P2PRSC1              : 1;
  unsigned P2PRSC2              : 1;
  unsigned P2PRSC3              : 1;
  unsigned P2PRSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2PRSIN              : 1;
  } __PSMC2PRSbits_t;

extern __at(0x083C) volatile __PSMC2PRSbits_t PSMC2PRSbits;

#define _P2PRST                 0x01
#define _P2PRSC1                0x02
#define _P2PRSC2                0x04
#define _P2PRSC3                0x08
#define _P2PRSC4                0x10
#define _P2PRSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC2ASDC Bits

extern __at(0x083D) __sfr PSMC2ASDC;

typedef struct
  {
  unsigned P2ASDOV              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2ARSEN              : 1;
  unsigned P2ASDEN              : 1;
  unsigned P2ASE                : 1;
  } __PSMC2ASDCbits_t;

extern __at(0x083D) volatile __PSMC2ASDCbits_t PSMC2ASDCbits;

#define _P2ASDOV                0x01
#define _P2ARSEN                0x20
#define _P2ASDEN                0x40
#define _P2ASE                  0x80

//==============================================================================


//==============================================================================
//        PSMC2ASDL Bits

extern __at(0x083E) __sfr PSMC2ASDL;

typedef struct
  {
  unsigned P2ASDLA              : 1;
  unsigned P2ASDLB              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC2ASDLbits_t;

extern __at(0x083E) volatile __PSMC2ASDLbits_t PSMC2ASDLbits;

#define _P2ASDLA                0x01
#define _P2ASDLB                0x02

//==============================================================================


//==============================================================================
//        PSMC2ASDS Bits

extern __at(0x083F) __sfr PSMC2ASDS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P2ASDSC1             : 1;
  unsigned P2ASDSC2             : 1;
  unsigned P2ASDSC3             : 1;
  unsigned P2ASDSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2ASDSIN             : 1;
  } __PSMC2ASDSbits_t;

extern __at(0x083F) volatile __PSMC2ASDSbits_t PSMC2ASDSbits;

#define _P2ASDSC1               0x02
#define _P2ASDSC2               0x04
#define _P2ASDSC3               0x08
#define _P2ASDSC4               0x10
#define _P2ASDSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC2INT Bits

extern __at(0x0840) __sfr PSMC2INT;

typedef struct
  {
  unsigned P2TPRIF              : 1;
  unsigned P2TDCIF              : 1;
  unsigned P2TPHIF              : 1;
  unsigned P2TOVIF              : 1;
  unsigned P2TPRIE              : 1;
  unsigned P2TDCIE              : 1;
  unsigned P2TPHIE              : 1;
  unsigned P2TOVIE              : 1;
  } __PSMC2INTbits_t;

extern __at(0x0840) volatile __PSMC2INTbits_t PSMC2INTbits;

#define _P2TPRIF                0x01
#define _P2TDCIF                0x02
#define _P2TPHIF                0x04
#define _P2TOVIF                0x08
#define _P2TPRIE                0x10
#define _P2TDCIE                0x20
#define _P2TPHIE                0x40
#define _P2TOVIE                0x80

//==============================================================================

extern __at(0x0841) __sfr PSMC2PH;

//==============================================================================
//        PSMC2PHL Bits

extern __at(0x0841) __sfr PSMC2PHL;

typedef struct
  {
  unsigned PSMC2PH0             : 1;
  unsigned PSMC2PH1             : 1;
  unsigned PSMC2PH2             : 1;
  unsigned PSMC2PH3             : 1;
  unsigned PSMC2PH4             : 1;
  unsigned PSMC2PH5             : 1;
  unsigned PSMC2PH6             : 1;
  unsigned PSMC2PH7             : 1;
  } __PSMC2PHLbits_t;

extern __at(0x0841) volatile __PSMC2PHLbits_t PSMC2PHLbits;

#define _PSMC2PH0               0x01
#define _PSMC2PH1               0x02
#define _PSMC2PH2               0x04
#define _PSMC2PH3               0x08
#define _PSMC2PH4               0x10
#define _PSMC2PH5               0x20
#define _PSMC2PH6               0x40
#define _PSMC2PH7               0x80

//==============================================================================


//==============================================================================
//        PSMC2PHH Bits

extern __at(0x0842) __sfr PSMC2PHH;

typedef struct
  {
  unsigned PSMC2PH8             : 1;
  unsigned PSMC2PH9             : 1;
  unsigned PSMC2PH10            : 1;
  unsigned PSMC2PH11            : 1;
  unsigned PSMC2PH12            : 1;
  unsigned PSMC2PH13            : 1;
  unsigned PSMC2PH14            : 1;
  unsigned PSMC2PH15            : 1;
  } __PSMC2PHHbits_t;

extern __at(0x0842) volatile __PSMC2PHHbits_t PSMC2PHHbits;

#define _PSMC2PH8               0x01
#define _PSMC2PH9               0x02
#define _PSMC2PH10              0x04
#define _PSMC2PH11              0x08
#define _PSMC2PH12              0x10
#define _PSMC2PH13              0x20
#define _PSMC2PH14              0x40
#define _PSMC2PH15              0x80

//==============================================================================

extern __at(0x0843) __sfr PSMC2DC;

//==============================================================================
//        PSMC2DCL Bits

extern __at(0x0843) __sfr PSMC2DCL;

typedef struct
  {
  unsigned PSMC2DC0             : 1;
  unsigned PSMC2DC1             : 1;
  unsigned PSMC2DC2             : 1;
  unsigned PSMC2DC3             : 1;
  unsigned PSMC2DC4             : 1;
  unsigned PSMC2DC5             : 1;
  unsigned PSMC2DC6             : 1;
  unsigned PSMC2DC7             : 1;
  } __PSMC2DCLbits_t;

extern __at(0x0843) volatile __PSMC2DCLbits_t PSMC2DCLbits;

#define _PSMC2DC0               0x01
#define _PSMC2DC1               0x02
#define _PSMC2DC2               0x04
#define _PSMC2DC3               0x08
#define _PSMC2DC4               0x10
#define _PSMC2DC5               0x20
#define _PSMC2DC6               0x40
#define _PSMC2DC7               0x80

//==============================================================================


//==============================================================================
//        PSMC2DCH Bits

extern __at(0x0844) __sfr PSMC2DCH;

typedef struct
  {
  unsigned PSMC2DC8             : 1;
  unsigned PSMC2DC9             : 1;
  unsigned PSMC2DC10            : 1;
  unsigned PSMC2DC11            : 1;
  unsigned PSMC2DC12            : 1;
  unsigned PSMC2DC13            : 1;
  unsigned PSMC2DC14            : 1;
  unsigned PSMC2DC15            : 1;
  } __PSMC2DCHbits_t;

extern __at(0x0844) volatile __PSMC2DCHbits_t PSMC2DCHbits;

#define _PSMC2DC8               0x01
#define _PSMC2DC9               0x02
#define _PSMC2DC10              0x04
#define _PSMC2DC11              0x08
#define _PSMC2DC12              0x10
#define _PSMC2DC13              0x20
#define _PSMC2DC14              0x40
#define _PSMC2DC15              0x80

//==============================================================================

extern __at(0x0845) __sfr PSMC2PR;

//==============================================================================
//        PSMC2PRL Bits

extern __at(0x0845) __sfr PSMC2PRL;

typedef struct
  {
  unsigned PSMC2PR0             : 1;
  unsigned PSMC2PR1             : 1;
  unsigned PSMC2PR2             : 1;
  unsigned PSMC2PR3             : 1;
  unsigned PSMC2PR4             : 1;
  unsigned PSMC2PR5             : 1;
  unsigned PSMC2PR6             : 1;
  unsigned PSMC2PR7             : 1;
  } __PSMC2PRLbits_t;

extern __at(0x0845) volatile __PSMC2PRLbits_t PSMC2PRLbits;

#define _PSMC2PR0               0x01
#define _PSMC2PR1               0x02
#define _PSMC2PR2               0x04
#define _PSMC2PR3               0x08
#define _PSMC2PR4               0x10
#define _PSMC2PR5               0x20
#define _PSMC2PR6               0x40
#define _PSMC2PR7               0x80

//==============================================================================


//==============================================================================
//        PSMC2PRH Bits

extern __at(0x0846) __sfr PSMC2PRH;

typedef struct
  {
  unsigned PSMC2PR8             : 1;
  unsigned PSMC2PR9             : 1;
  unsigned PSMC2PR10            : 1;
  unsigned PSMC2PR11            : 1;
  unsigned PSMC2PR12            : 1;
  unsigned PSMC2PR13            : 1;
  unsigned PSMC2PR14            : 1;
  unsigned PSMC2PR15            : 1;
  } __PSMC2PRHbits_t;

extern __at(0x0846) volatile __PSMC2PRHbits_t PSMC2PRHbits;

#define _PSMC2PR8               0x01
#define _PSMC2PR9               0x02
#define _PSMC2PR10              0x04
#define _PSMC2PR11              0x08
#define _PSMC2PR12              0x10
#define _PSMC2PR13              0x20
#define _PSMC2PR14              0x40
#define _PSMC2PR15              0x80

//==============================================================================

extern __at(0x0847) __sfr PSMC2TMR;

//==============================================================================
//        PSMC2TMRL Bits

extern __at(0x0847) __sfr PSMC2TMRL;

typedef struct
  {
  unsigned PSMC2TMR0            : 1;
  unsigned PSMC2TMR1            : 1;
  unsigned PSMC2TMR2            : 1;
  unsigned PSMC2TMR3            : 1;
  unsigned PSMC2TMR4            : 1;
  unsigned PSMC2TMR5            : 1;
  unsigned PSMC2TMR6            : 1;
  unsigned PSMC2TMR7            : 1;
  } __PSMC2TMRLbits_t;

extern __at(0x0847) volatile __PSMC2TMRLbits_t PSMC2TMRLbits;

#define _PSMC2TMR0              0x01
#define _PSMC2TMR1              0x02
#define _PSMC2TMR2              0x04
#define _PSMC2TMR3              0x08
#define _PSMC2TMR4              0x10
#define _PSMC2TMR5              0x20
#define _PSMC2TMR6              0x40
#define _PSMC2TMR7              0x80

//==============================================================================


//==============================================================================
//        PSMC2TMRH Bits

extern __at(0x0848) __sfr PSMC2TMRH;

typedef struct
  {
  unsigned PSMC2TMR8            : 1;
  unsigned PSMC2TMR9            : 1;
  unsigned PSMC2TMR10           : 1;
  unsigned PSMC2TMR11           : 1;
  unsigned PSMC2TMR12           : 1;
  unsigned PSMC2TMR13           : 1;
  unsigned PSMC2TMR14           : 1;
  unsigned PSMC2TMR15           : 1;
  } __PSMC2TMRHbits_t;

extern __at(0x0848) volatile __PSMC2TMRHbits_t PSMC2TMRHbits;

#define _PSMC2TMR8              0x01
#define _PSMC2TMR9              0x02
#define _PSMC2TMR10             0x04
#define _PSMC2TMR11             0x08
#define _PSMC2TMR12             0x10
#define _PSMC2TMR13             0x20
#define _PSMC2TMR14             0x40
#define _PSMC2TMR15             0x80

//==============================================================================


//==============================================================================
//        PSMC2DBR Bits

extern __at(0x0849) __sfr PSMC2DBR;

typedef struct
  {
  unsigned PSMC2DBR0            : 1;
  unsigned PSMC2DBR1            : 1;
  unsigned PSMC2DBR2            : 1;
  unsigned PSMC2DBR3            : 1;
  unsigned PSMC2DBR4            : 1;
  unsigned PSMC2DBR5            : 1;
  unsigned PSMC2DBR6            : 1;
  unsigned PSMC2DBR7            : 1;
  } __PSMC2DBRbits_t;

extern __at(0x0849) volatile __PSMC2DBRbits_t PSMC2DBRbits;

#define _PSMC2DBR0              0x01
#define _PSMC2DBR1              0x02
#define _PSMC2DBR2              0x04
#define _PSMC2DBR3              0x08
#define _PSMC2DBR4              0x10
#define _PSMC2DBR5              0x20
#define _PSMC2DBR6              0x40
#define _PSMC2DBR7              0x80

//==============================================================================


//==============================================================================
//        PSMC2DBF Bits

extern __at(0x084A) __sfr PSMC2DBF;

typedef struct
  {
  unsigned PSMC2DBF0            : 1;
  unsigned PSMC2DBF1            : 1;
  unsigned PSMC2DBF2            : 1;
  unsigned PSMC2DBF3            : 1;
  unsigned PSMC2DBF4            : 1;
  unsigned PSMC2DBF5            : 1;
  unsigned PSMC2DBF6            : 1;
  unsigned PSMC2DBF7            : 1;
  } __PSMC2DBFbits_t;

extern __at(0x084A) volatile __PSMC2DBFbits_t PSMC2DBFbits;

#define _PSMC2DBF0              0x01
#define _PSMC2DBF1              0x02
#define _PSMC2DBF2              0x04
#define _PSMC2DBF3              0x08
#define _PSMC2DBF4              0x10
#define _PSMC2DBF5              0x20
#define _PSMC2DBF6              0x40
#define _PSMC2DBF7              0x80

//==============================================================================


//==============================================================================
//        PSMC2BLKR Bits

extern __at(0x084B) __sfr PSMC2BLKR;

typedef struct
  {
  unsigned PSMC2BLKR0           : 1;
  unsigned PSMC2BLKR1           : 1;
  unsigned PSMC2BLKR2           : 1;
  unsigned PSMC2BLKR3           : 1;
  unsigned PSMC2BLKR4           : 1;
  unsigned PSMC2BLKR5           : 1;
  unsigned PSMC2BLKR6           : 1;
  unsigned PSMC2BLKR7           : 1;
  } __PSMC2BLKRbits_t;

extern __at(0x084B) volatile __PSMC2BLKRbits_t PSMC2BLKRbits;

#define _PSMC2BLKR0             0x01
#define _PSMC2BLKR1             0x02
#define _PSMC2BLKR2             0x04
#define _PSMC2BLKR3             0x08
#define _PSMC2BLKR4             0x10
#define _PSMC2BLKR5             0x20
#define _PSMC2BLKR6             0x40
#define _PSMC2BLKR7             0x80

//==============================================================================


//==============================================================================
//        PSMC2BLKF Bits

extern __at(0x084C) __sfr PSMC2BLKF;

typedef struct
  {
  unsigned PSMC2BLKF0           : 1;
  unsigned PSMC2BLKF1           : 1;
  unsigned PSMC2BLKF2           : 1;
  unsigned PSMC2BLKF3           : 1;
  unsigned PSMC2BLKF4           : 1;
  unsigned PSMC2BLKF5           : 1;
  unsigned PSMC2BLKF6           : 1;
  unsigned PSMC2BLKF7           : 1;
  } __PSMC2BLKFbits_t;

extern __at(0x084C) volatile __PSMC2BLKFbits_t PSMC2BLKFbits;

#define _PSMC2BLKF0             0x01
#define _PSMC2BLKF1             0x02
#define _PSMC2BLKF2             0x04
#define _PSMC2BLKF3             0x08
#define _PSMC2BLKF4             0x10
#define _PSMC2BLKF5             0x20
#define _PSMC2BLKF6             0x40
#define _PSMC2BLKF7             0x80

//==============================================================================


//==============================================================================
//        PSMC2FFA Bits

extern __at(0x084D) __sfr PSMC2FFA;

typedef union
  {
  struct
    {
    unsigned PSMC2FFA0          : 1;
    unsigned PSMC2FFA1          : 1;
    unsigned PSMC2FFA2          : 1;
    unsigned PSMC2FFA3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSMC2FFA           : 4;
    unsigned                    : 4;
    };
  } __PSMC2FFAbits_t;

extern __at(0x084D) volatile __PSMC2FFAbits_t PSMC2FFAbits;

#define _PSMC2FFA0              0x01
#define _PSMC2FFA1              0x02
#define _PSMC2FFA2              0x04
#define _PSMC2FFA3              0x08

//==============================================================================


//==============================================================================
//        PSMC2STR0 Bits

extern __at(0x084E) __sfr PSMC2STR0;

typedef struct
  {
  unsigned P2STRA               : 1;
  unsigned P2STRB               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC2STR0bits_t;

extern __at(0x084E) volatile __PSMC2STR0bits_t PSMC2STR0bits;

#define _P2STRA                 0x01
#define _P2STRB                 0x02

//==============================================================================


//==============================================================================
//        PSMC2STR1 Bits

extern __at(0x084F) __sfr PSMC2STR1;

typedef struct
  {
  unsigned P2HSMEN              : 1;
  unsigned P2LSMEN              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P2SSYNC              : 1;
  } __PSMC2STR1bits_t;

extern __at(0x084F) volatile __PSMC2STR1bits_t PSMC2STR1bits;

#define _P2HSMEN                0x01
#define _P2LSMEN                0x02
#define _P2SSYNC                0x80

//==============================================================================


//==============================================================================
//        PSMC3CON Bits

extern __at(0x0851) __sfr PSMC3CON;

typedef union
  {
  struct
    {
    unsigned P3MODE0            : 1;
    unsigned P3MODE1            : 1;
    unsigned P3MODE2            : 1;
    unsigned P3MODE3            : 1;
    unsigned P3DBRE             : 1;
    unsigned P3DBFE             : 1;
    unsigned PSMC3LD            : 1;
    unsigned PSMC3EN            : 1;
    };

  struct
    {
    unsigned P3MODE             : 4;
    unsigned                    : 4;
    };
  } __PSMC3CONbits_t;

extern __at(0x0851) volatile __PSMC3CONbits_t PSMC3CONbits;

#define _P3MODE0                0x01
#define _P3MODE1                0x02
#define _P3MODE2                0x04
#define _P3MODE3                0x08
#define _P3DBRE                 0x10
#define _P3DBFE                 0x20
#define _PSMC3LD                0x40
#define _PSMC3EN                0x80

//==============================================================================


//==============================================================================
//        PSMC3MDL Bits

extern __at(0x0852) __sfr PSMC3MDL;

typedef union
  {
  struct
    {
    unsigned P3MSRC0            : 1;
    unsigned P3MSRC1            : 1;
    unsigned P3MSRC2            : 1;
    unsigned P3MSRC3            : 1;
    unsigned                    : 1;
    unsigned P3MDLBIT           : 1;
    unsigned P3MDLPOL           : 1;
    unsigned P3MDLEN            : 1;
    };

  struct
    {
    unsigned P3MSRC             : 4;
    unsigned                    : 4;
    };
  } __PSMC3MDLbits_t;

extern __at(0x0852) volatile __PSMC3MDLbits_t PSMC3MDLbits;

#define _P3MSRC0                0x01
#define _P3MSRC1                0x02
#define _P3MSRC2                0x04
#define _P3MSRC3                0x08
#define _P3MDLBIT               0x20
#define _P3MDLPOL               0x40
#define _P3MDLEN                0x80

//==============================================================================


//==============================================================================
//        PSMC3SYNC Bits

extern __at(0x0853) __sfr PSMC3SYNC;

typedef union
  {
  struct
    {
    unsigned P3SYNC0            : 1;
    unsigned P3SYNC1            : 1;
    unsigned P3SYNC2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P3DCPOL            : 1;
    unsigned P3PRPOL            : 1;
    unsigned P3POFST            : 1;
    };

  struct
    {
    unsigned P3SYNC             : 3;
    unsigned                    : 5;
    };
  } __PSMC3SYNCbits_t;

extern __at(0x0853) volatile __PSMC3SYNCbits_t PSMC3SYNCbits;

#define _P3SYNC0                0x01
#define _P3SYNC1                0x02
#define _P3SYNC2                0x04
#define _P3DCPOL                0x20
#define _P3PRPOL                0x40
#define _P3POFST                0x80

//==============================================================================


//==============================================================================
//        PSMC3CLK Bits

extern __at(0x0854) __sfr PSMC3CLK;

typedef union
  {
  struct
    {
    unsigned P3CSRC0            : 1;
    unsigned P3CSRC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P3CPRE0            : 1;
    unsigned P3CPRE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P3CSRC             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P3CPRE             : 2;
    unsigned                    : 2;
    };
  } __PSMC3CLKbits_t;

extern __at(0x0854) volatile __PSMC3CLKbits_t PSMC3CLKbits;

#define _P3CSRC0                0x01
#define _P3CSRC1                0x02
#define _P3CPRE0                0x10
#define _P3CPRE1                0x20

//==============================================================================


//==============================================================================
//        PSMC3OEN Bits

extern __at(0x0855) __sfr PSMC3OEN;

typedef struct
  {
  unsigned P3OEA                : 1;
  unsigned P3OEB                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC3OENbits_t;

extern __at(0x0855) volatile __PSMC3OENbits_t PSMC3OENbits;

#define _P3OEA                  0x01
#define _P3OEB                  0x02

//==============================================================================


//==============================================================================
//        PSMC3POL Bits

extern __at(0x0856) __sfr PSMC3POL;

typedef struct
  {
  unsigned P3POLA               : 1;
  unsigned P3POLB               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3INPOL              : 1;
  unsigned                      : 1;
  } __PSMC3POLbits_t;

extern __at(0x0856) volatile __PSMC3POLbits_t PSMC3POLbits;

#define _P3POLA                 0x01
#define _P3POLB                 0x02
#define _P3INPOL                0x40

//==============================================================================


//==============================================================================
//        PSMC3BLNK Bits

extern __at(0x0857) __sfr PSMC3BLNK;

typedef union
  {
  struct
    {
    unsigned P3REBM0            : 1;
    unsigned P3REBM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P3FEBM0            : 1;
    unsigned P3FEBM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P3REBM             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P3FEBM             : 2;
    unsigned                    : 2;
    };
  } __PSMC3BLNKbits_t;

extern __at(0x0857) volatile __PSMC3BLNKbits_t PSMC3BLNKbits;

#define _P3REBM0                0x01
#define _P3REBM1                0x02
#define _P3FEBM0                0x10
#define _P3FEBM1                0x20

//==============================================================================


//==============================================================================
//        PSMC3REBS Bits

extern __at(0x0858) __sfr PSMC3REBS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P3REBSC1             : 1;
  unsigned P3REBSC2             : 1;
  unsigned P3REBSC3             : 1;
  unsigned P3REBSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3REBSIN             : 1;
  } __PSMC3REBSbits_t;

extern __at(0x0858) volatile __PSMC3REBSbits_t PSMC3REBSbits;

#define _P3REBSC1               0x02
#define _P3REBSC2               0x04
#define _P3REBSC3               0x08
#define _P3REBSC4               0x10
#define _P3REBSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC3FEBS Bits

extern __at(0x0859) __sfr PSMC3FEBS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P3FEBSC1             : 1;
  unsigned P3FEBSC2             : 1;
  unsigned P3FEBSC3             : 1;
  unsigned P3FEBSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3FEBSIN             : 1;
  } __PSMC3FEBSbits_t;

extern __at(0x0859) volatile __PSMC3FEBSbits_t PSMC3FEBSbits;

#define _P3FEBSC1               0x02
#define _P3FEBSC2               0x04
#define _P3FEBSC3               0x08
#define _P3FEBSC4               0x10
#define _P3FEBSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC3PHS Bits

extern __at(0x085A) __sfr PSMC3PHS;

typedef struct
  {
  unsigned P3PHST               : 1;
  unsigned P3PHSC1              : 1;
  unsigned P3PHSC2              : 1;
  unsigned P3PHSC3              : 1;
  unsigned P3PHSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3PHSIN              : 1;
  } __PSMC3PHSbits_t;

extern __at(0x085A) volatile __PSMC3PHSbits_t PSMC3PHSbits;

#define _P3PHST                 0x01
#define _P3PHSC1                0x02
#define _P3PHSC2                0x04
#define _P3PHSC3                0x08
#define _P3PHSC4                0x10
#define _P3PHSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC3DCS Bits

extern __at(0x085B) __sfr PSMC3DCS;

typedef struct
  {
  unsigned P3DCST               : 1;
  unsigned P3DCSC1              : 1;
  unsigned P3DCSC2              : 1;
  unsigned P3DCSC3              : 1;
  unsigned P3DCSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3DCSIN              : 1;
  } __PSMC3DCSbits_t;

extern __at(0x085B) volatile __PSMC3DCSbits_t PSMC3DCSbits;

#define _P3DCST                 0x01
#define _P3DCSC1                0x02
#define _P3DCSC2                0x04
#define _P3DCSC3                0x08
#define _P3DCSC4                0x10
#define _P3DCSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC3PRS Bits

extern __at(0x085C) __sfr PSMC3PRS;

typedef struct
  {
  unsigned P3PRST               : 1;
  unsigned P3PRSC1              : 1;
  unsigned P3PRSC2              : 1;
  unsigned P3PRSC3              : 1;
  unsigned P3PRSC4              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3PRSIN              : 1;
  } __PSMC3PRSbits_t;

extern __at(0x085C) volatile __PSMC3PRSbits_t PSMC3PRSbits;

#define _P3PRST                 0x01
#define _P3PRSC1                0x02
#define _P3PRSC2                0x04
#define _P3PRSC3                0x08
#define _P3PRSC4                0x10
#define _P3PRSIN                0x80

//==============================================================================


//==============================================================================
//        PSMC3ASDC Bits

extern __at(0x085D) __sfr PSMC3ASDC;

typedef struct
  {
  unsigned P3ASDOV              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3ARSEN              : 1;
  unsigned P3ASDEN              : 1;
  unsigned P3ASE                : 1;
  } __PSMC3ASDCbits_t;

extern __at(0x085D) volatile __PSMC3ASDCbits_t PSMC3ASDCbits;

#define _P3ASDOV                0x01
#define _P3ARSEN                0x20
#define _P3ASDEN                0x40
#define _P3ASE                  0x80

//==============================================================================


//==============================================================================
//        PSMC3ASDL Bits

extern __at(0x085E) __sfr PSMC3ASDL;

typedef struct
  {
  unsigned P3ASDLA              : 1;
  unsigned P3ASDLB              : 1;
  unsigned P3ASDLC              : 1;
  unsigned P3ASDLD              : 1;
  unsigned P3ASDLE              : 1;
  unsigned P3ASDLF              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC3ASDLbits_t;

extern __at(0x085E) volatile __PSMC3ASDLbits_t PSMC3ASDLbits;

#define _P3ASDLA                0x01
#define _P3ASDLB                0x02
#define _P3ASDLC                0x04
#define _P3ASDLD                0x08
#define _P3ASDLE                0x10
#define _P3ASDLF                0x20

//==============================================================================


//==============================================================================
//        PSMC3ASDS Bits

extern __at(0x085F) __sfr PSMC3ASDS;

typedef struct
  {
  unsigned                      : 1;
  unsigned P3ASDSC1             : 1;
  unsigned P3ASDSC2             : 1;
  unsigned P3ASDSC3             : 1;
  unsigned P3ASDSC4             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3ASDSIN             : 1;
  } __PSMC3ASDSbits_t;

extern __at(0x085F) volatile __PSMC3ASDSbits_t PSMC3ASDSbits;

#define _P3ASDSC1               0x02
#define _P3ASDSC2               0x04
#define _P3ASDSC3               0x08
#define _P3ASDSC4               0x10
#define _P3ASDSIN               0x80

//==============================================================================


//==============================================================================
//        PSMC3INT Bits

extern __at(0x0860) __sfr PSMC3INT;

typedef struct
  {
  unsigned P3TPRIF              : 1;
  unsigned P3TDCIF              : 1;
  unsigned P3TPHIF              : 1;
  unsigned P3TOVIF              : 1;
  unsigned P3TPRIE              : 1;
  unsigned P3TDCIE              : 1;
  unsigned P3TPHIE              : 1;
  unsigned P3TOVIE              : 1;
  } __PSMC3INTbits_t;

extern __at(0x0860) volatile __PSMC3INTbits_t PSMC3INTbits;

#define _P3TPRIF                0x01
#define _P3TDCIF                0x02
#define _P3TPHIF                0x04
#define _P3TOVIF                0x08
#define _P3TPRIE                0x10
#define _P3TDCIE                0x20
#define _P3TPHIE                0x40
#define _P3TOVIE                0x80

//==============================================================================

extern __at(0x0861) __sfr PSMC3PH;

//==============================================================================
//        PSMC3PHL Bits

extern __at(0x0861) __sfr PSMC3PHL;

typedef struct
  {
  unsigned PSMC3PH0             : 1;
  unsigned PSMC3PH1             : 1;
  unsigned PSMC3PH2             : 1;
  unsigned PSMC3PH3             : 1;
  unsigned PSMC3PH4             : 1;
  unsigned PSMC3PH5             : 1;
  unsigned PSMC3PH6             : 1;
  unsigned PSMC3PH7             : 1;
  } __PSMC3PHLbits_t;

extern __at(0x0861) volatile __PSMC3PHLbits_t PSMC3PHLbits;

#define _PSMC3PH0               0x01
#define _PSMC3PH1               0x02
#define _PSMC3PH2               0x04
#define _PSMC3PH3               0x08
#define _PSMC3PH4               0x10
#define _PSMC3PH5               0x20
#define _PSMC3PH6               0x40
#define _PSMC3PH7               0x80

//==============================================================================


//==============================================================================
//        PSMC3PHH Bits

extern __at(0x0862) __sfr PSMC3PHH;

typedef struct
  {
  unsigned PSMC3PH8             : 1;
  unsigned PSMC3PH9             : 1;
  unsigned PSMC3PH10            : 1;
  unsigned PSMC3PH11            : 1;
  unsigned PSMC3PH12            : 1;
  unsigned PSMC3PH13            : 1;
  unsigned PSMC3PH14            : 1;
  unsigned PSMC3PH15            : 1;
  } __PSMC3PHHbits_t;

extern __at(0x0862) volatile __PSMC3PHHbits_t PSMC3PHHbits;

#define _PSMC3PH8               0x01
#define _PSMC3PH9               0x02
#define _PSMC3PH10              0x04
#define _PSMC3PH11              0x08
#define _PSMC3PH12              0x10
#define _PSMC3PH13              0x20
#define _PSMC3PH14              0x40
#define _PSMC3PH15              0x80

//==============================================================================

extern __at(0x0863) __sfr PSMC3DC;

//==============================================================================
//        PSMC3DCL Bits

extern __at(0x0863) __sfr PSMC3DCL;

typedef struct
  {
  unsigned PSMC3DC0             : 1;
  unsigned PSMC3DC1             : 1;
  unsigned PSMC3DC2             : 1;
  unsigned PSMC3DC3             : 1;
  unsigned PSMC3DC4             : 1;
  unsigned PSMC3DC5             : 1;
  unsigned PSMC3DC6             : 1;
  unsigned PSMC3DC7             : 1;
  } __PSMC3DCLbits_t;

extern __at(0x0863) volatile __PSMC3DCLbits_t PSMC3DCLbits;

#define _PSMC3DC0               0x01
#define _PSMC3DC1               0x02
#define _PSMC3DC2               0x04
#define _PSMC3DC3               0x08
#define _PSMC3DC4               0x10
#define _PSMC3DC5               0x20
#define _PSMC3DC6               0x40
#define _PSMC3DC7               0x80

//==============================================================================


//==============================================================================
//        PSMC3DCH Bits

extern __at(0x0864) __sfr PSMC3DCH;

typedef struct
  {
  unsigned PSMC3DC8             : 1;
  unsigned PSMC3DC9             : 1;
  unsigned PSMC3DC10            : 1;
  unsigned PSMC3DC11            : 1;
  unsigned PSMC3DC12            : 1;
  unsigned PSMC3DC13            : 1;
  unsigned PSMC3DC14            : 1;
  unsigned PSMC3DC15            : 1;
  } __PSMC3DCHbits_t;

extern __at(0x0864) volatile __PSMC3DCHbits_t PSMC3DCHbits;

#define _PSMC3DC8               0x01
#define _PSMC3DC9               0x02
#define _PSMC3DC10              0x04
#define _PSMC3DC11              0x08
#define _PSMC3DC12              0x10
#define _PSMC3DC13              0x20
#define _PSMC3DC14              0x40
#define _PSMC3DC15              0x80

//==============================================================================

extern __at(0x0865) __sfr PSMC3PR;

//==============================================================================
//        PSMC3PRL Bits

extern __at(0x0865) __sfr PSMC3PRL;

typedef struct
  {
  unsigned PSMC3PR0             : 1;
  unsigned PSMC3PR1             : 1;
  unsigned PSMC3PR2             : 1;
  unsigned PSMC3PR3             : 1;
  unsigned PSMC3PR4             : 1;
  unsigned PSMC3PR5             : 1;
  unsigned PSMC3PR6             : 1;
  unsigned PSMC3PR7             : 1;
  } __PSMC3PRLbits_t;

extern __at(0x0865) volatile __PSMC3PRLbits_t PSMC3PRLbits;

#define _PSMC3PR0               0x01
#define _PSMC3PR1               0x02
#define _PSMC3PR2               0x04
#define _PSMC3PR3               0x08
#define _PSMC3PR4               0x10
#define _PSMC3PR5               0x20
#define _PSMC3PR6               0x40
#define _PSMC3PR7               0x80

//==============================================================================


//==============================================================================
//        PSMC3PRH Bits

extern __at(0x0866) __sfr PSMC3PRH;

typedef struct
  {
  unsigned PSMC3PR8             : 1;
  unsigned PSMC3PR9             : 1;
  unsigned PSMC3PR10            : 1;
  unsigned PSMC3PR11            : 1;
  unsigned PSMC3PR12            : 1;
  unsigned PSMC3PR13            : 1;
  unsigned PSMC3PR14            : 1;
  unsigned PSMC3PR15            : 1;
  } __PSMC3PRHbits_t;

extern __at(0x0866) volatile __PSMC3PRHbits_t PSMC3PRHbits;

#define _PSMC3PR8               0x01
#define _PSMC3PR9               0x02
#define _PSMC3PR10              0x04
#define _PSMC3PR11              0x08
#define _PSMC3PR12              0x10
#define _PSMC3PR13              0x20
#define _PSMC3PR14              0x40
#define _PSMC3PR15              0x80

//==============================================================================

extern __at(0x0867) __sfr PSMC3TMR;

//==============================================================================
//        PSMC3TMRL Bits

extern __at(0x0867) __sfr PSMC3TMRL;

typedef struct
  {
  unsigned PSMC3TMR0            : 1;
  unsigned PSMC3TMR1            : 1;
  unsigned PSMC3TMR2            : 1;
  unsigned PSMC3TMR3            : 1;
  unsigned PSMC3TMR4            : 1;
  unsigned PSMC3TMR5            : 1;
  unsigned PSMC3TMR6            : 1;
  unsigned PSMC3TMR7            : 1;
  } __PSMC3TMRLbits_t;

extern __at(0x0867) volatile __PSMC3TMRLbits_t PSMC3TMRLbits;

#define _PSMC3TMR0              0x01
#define _PSMC3TMR1              0x02
#define _PSMC3TMR2              0x04
#define _PSMC3TMR3              0x08
#define _PSMC3TMR4              0x10
#define _PSMC3TMR5              0x20
#define _PSMC3TMR6              0x40
#define _PSMC3TMR7              0x80

//==============================================================================


//==============================================================================
//        PSMC3TMRH Bits

extern __at(0x0868) __sfr PSMC3TMRH;

typedef struct
  {
  unsigned PSMC3TMR8            : 1;
  unsigned PSMC3TMR9            : 1;
  unsigned PSMC3TMR10           : 1;
  unsigned PSMC3TMR11           : 1;
  unsigned PSMC3TMR12           : 1;
  unsigned PSMC3TMR13           : 1;
  unsigned PSMC3TMR14           : 1;
  unsigned PSMC3TMR15           : 1;
  } __PSMC3TMRHbits_t;

extern __at(0x0868) volatile __PSMC3TMRHbits_t PSMC3TMRHbits;

#define _PSMC3TMR8              0x01
#define _PSMC3TMR9              0x02
#define _PSMC3TMR10             0x04
#define _PSMC3TMR11             0x08
#define _PSMC3TMR12             0x10
#define _PSMC3TMR13             0x20
#define _PSMC3TMR14             0x40
#define _PSMC3TMR15             0x80

//==============================================================================


//==============================================================================
//        PSMC3DBR Bits

extern __at(0x0869) __sfr PSMC3DBR;

typedef struct
  {
  unsigned PSMC3DBR0            : 1;
  unsigned PSMC3DBR1            : 1;
  unsigned PSMC3DBR2            : 1;
  unsigned PSMC3DBR3            : 1;
  unsigned PSMC3DBR4            : 1;
  unsigned PSMC3DBR5            : 1;
  unsigned PSMC3DBR6            : 1;
  unsigned PSMC3DBR7            : 1;
  } __PSMC3DBRbits_t;

extern __at(0x0869) volatile __PSMC3DBRbits_t PSMC3DBRbits;

#define _PSMC3DBR0              0x01
#define _PSMC3DBR1              0x02
#define _PSMC3DBR2              0x04
#define _PSMC3DBR3              0x08
#define _PSMC3DBR4              0x10
#define _PSMC3DBR5              0x20
#define _PSMC3DBR6              0x40
#define _PSMC3DBR7              0x80

//==============================================================================


//==============================================================================
//        PSMC3DBF Bits

extern __at(0x086A) __sfr PSMC3DBF;

typedef struct
  {
  unsigned PSMC3DBF0            : 1;
  unsigned PSMC3DBF1            : 1;
  unsigned PSMC3DBF2            : 1;
  unsigned PSMC3DBF3            : 1;
  unsigned PSMC3DBF4            : 1;
  unsigned PSMC3DBF5            : 1;
  unsigned PSMC3DBF6            : 1;
  unsigned PSMC3DBF7            : 1;
  } __PSMC3DBFbits_t;

extern __at(0x086A) volatile __PSMC3DBFbits_t PSMC3DBFbits;

#define _PSMC3DBF0              0x01
#define _PSMC3DBF1              0x02
#define _PSMC3DBF2              0x04
#define _PSMC3DBF3              0x08
#define _PSMC3DBF4              0x10
#define _PSMC3DBF5              0x20
#define _PSMC3DBF6              0x40
#define _PSMC3DBF7              0x80

//==============================================================================


//==============================================================================
//        PSMC3BLKR Bits

extern __at(0x086B) __sfr PSMC3BLKR;

typedef struct
  {
  unsigned PSMC3BLKR0           : 1;
  unsigned PSMC3BLKR1           : 1;
  unsigned PSMC3BLKR2           : 1;
  unsigned PSMC3BLKR3           : 1;
  unsigned PSMC3BLKR4           : 1;
  unsigned PSMC3BLKR5           : 1;
  unsigned PSMC3BLKR6           : 1;
  unsigned PSMC3BLKR7           : 1;
  } __PSMC3BLKRbits_t;

extern __at(0x086B) volatile __PSMC3BLKRbits_t PSMC3BLKRbits;

#define _PSMC3BLKR0             0x01
#define _PSMC3BLKR1             0x02
#define _PSMC3BLKR2             0x04
#define _PSMC3BLKR3             0x08
#define _PSMC3BLKR4             0x10
#define _PSMC3BLKR5             0x20
#define _PSMC3BLKR6             0x40
#define _PSMC3BLKR7             0x80

//==============================================================================


//==============================================================================
//        PSMC3BLKF Bits

extern __at(0x086C) __sfr PSMC3BLKF;

typedef struct
  {
  unsigned PSMC3BLKF0           : 1;
  unsigned PSMC3BLKF1           : 1;
  unsigned PSMC3BLKF2           : 1;
  unsigned PSMC3BLKF3           : 1;
  unsigned PSMC3BLKF4           : 1;
  unsigned PSMC3BLKF5           : 1;
  unsigned PSMC3BLKF6           : 1;
  unsigned PSMC3BLKF7           : 1;
  } __PSMC3BLKFbits_t;

extern __at(0x086C) volatile __PSMC3BLKFbits_t PSMC3BLKFbits;

#define _PSMC3BLKF0             0x01
#define _PSMC3BLKF1             0x02
#define _PSMC3BLKF2             0x04
#define _PSMC3BLKF3             0x08
#define _PSMC3BLKF4             0x10
#define _PSMC3BLKF5             0x20
#define _PSMC3BLKF6             0x40
#define _PSMC3BLKF7             0x80

//==============================================================================


//==============================================================================
//        PSMC3FFA Bits

extern __at(0x086D) __sfr PSMC3FFA;

typedef union
  {
  struct
    {
    unsigned PSMC3FFA0          : 1;
    unsigned PSMC3FFA1          : 1;
    unsigned PSMC3FFA2          : 1;
    unsigned PSMC3FFA3          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSMC3FFA           : 4;
    unsigned                    : 4;
    };
  } __PSMC3FFAbits_t;

extern __at(0x086D) volatile __PSMC3FFAbits_t PSMC3FFAbits;

#define _PSMC3FFA0              0x01
#define _PSMC3FFA1              0x02
#define _PSMC3FFA2              0x04
#define _PSMC3FFA3              0x08

//==============================================================================


//==============================================================================
//        PSMC3STR0 Bits

extern __at(0x086E) __sfr PSMC3STR0;

typedef struct
  {
  unsigned P3STRA               : 1;
  unsigned P3STRB               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSMC3STR0bits_t;

extern __at(0x086E) volatile __PSMC3STR0bits_t PSMC3STR0bits;

#define _P3STRA                 0x01
#define _P3STRB                 0x02

//==============================================================================


//==============================================================================
//        PSMC3STR1 Bits

extern __at(0x086F) __sfr PSMC3STR1;

typedef struct
  {
  unsigned P3HSMEN              : 1;
  unsigned P3LSMEN              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned P3SSYNC              : 1;
  } __PSMC3STR1bits_t;

extern __at(0x086F) volatile __PSMC3STR1bits_t PSMC3STR1bits;

#define _P3HSMEN                0x01
#define _P3LSMEN                0x02
#define _P3SSYNC                0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0x3FF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0x3FFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0x3FFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-32 MHz): device clock supplied to CLKIN pin.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _CPD_ON                 0x3EFF  // Data memory code protection is enabled.
#define _CPD_OFF                0x3FFF  // Data memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0x2FFF  // Internal/External Switchover mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover mode is enabled.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PLLEN_OFF              0x3EFF  // 4x PLL disabled.
#define _PLLEN_ON               0x3FFF  // 4x PLL enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low power brown-out is enabled.
#define _LPBOR_OFF              0x3FFF  // Low power brown-out is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define DONE                    ADCON0bits.DONE                 // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6
#define ADRMD                   ADCON0bits.ADRMD                // bit 7

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define CHSN0                   ADCON2bits.CHSN0                // bit 0
#define CHSN1                   ADCON2bits.CHSN1                // bit 1
#define CHSN2                   ADCON2bits.CHSN2                // bit 2
#define CHSN3                   ADCON2bits.CHSN3                // bit 3
#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5
#define ANSA7                   ANSELAbits.ANSA7                // bit 7

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6

#define CCP2SEL                 APFCONbits.CCP2SEL              // bit 0
#define RXSEL                   APFCONbits.RXSEL                // bit 1
#define TXSEL                   APFCONbits.TXSEL                // bit 2
#define SDISEL                  APFCONbits.SDISEL               // bit 3
#define SCKSEL                  APFCONbits.SCKSEL               // bit 4
#define SDOSEL                  APFCONbits.SDOSEL               // bit 5
#define CCP1SEL                 APFCONbits.CCP1SEL              // bit 6
#define C2OUTSEL                APFCONbits.C2OUTSEL             // bit 7

#define CCP3SEL                 APFCON2bits.CCP3SEL             // bit 0

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5

#define CCP3M0                  CCP3CONbits.CCP3M0              // bit 0
#define CCP3M1                  CCP3CONbits.CCP3M1              // bit 1
#define CCP3M2                  CCP3CONbits.CCP3M2              // bit 2
#define CCP3M3                  CCP3CONbits.CCP3M3              // bit 3
#define DC3B0                   CCP3CONbits.DC3B0               // bit 4
#define DC3B1                   CCP3CONbits.DC3B1               // bit 5

#define CLKRDIV0                CLKRCONbits.CLKRDIV0            // bit 0
#define CLKRDIV1                CLKRCONbits.CLKRDIV1            // bit 1
#define CLKRDIV2                CLKRCONbits.CLKRDIV2            // bit 2
#define CLKRDC0                 CLKRCONbits.CLKRDC0             // bit 3
#define CLKRDC1                 CLKRCONbits.CLKRDC1             // bit 4
#define CLKRSLR                 CLKRCONbits.CLKRSLR             // bit 5
#define CLKROE                  CLKRCONbits.CLKROE              // bit 6
#define CLKREN                  CLKRCONbits.CLKREN              // bit 7

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1ZLF                   CM1CON0bits.C1ZLF               // bit 3
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OE                    CM1CON0bits.C1OE                // bit 5
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1NCH2                  CM1CON1bits.C1NCH2              // bit 2
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 3
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 4
#define C1PCH2                  CM1CON1bits.C1PCH2              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define C2SYNC                  CM2CON0bits.C2SYNC              // bit 0
#define C2HYS                   CM2CON0bits.C2HYS               // bit 1
#define C2SP                    CM2CON0bits.C2SP                // bit 2
#define C2ZLF                   CM2CON0bits.C2ZLF               // bit 3
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OE                    CM2CON0bits.C2OE                // bit 5
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2NCH0                  CM2CON1bits.C2NCH0              // bit 0
#define C2NCH1                  CM2CON1bits.C2NCH1              // bit 1
#define C2NCH2                  CM2CON1bits.C2NCH2              // bit 2
#define C2PCH0                  CM2CON1bits.C2PCH0              // bit 3
#define C2PCH1                  CM2CON1bits.C2PCH1              // bit 4
#define C2PCH2                  CM2CON1bits.C2PCH2              // bit 5
#define C2INTN                  CM2CON1bits.C2INTN              // bit 6
#define C2INTP                  CM2CON1bits.C2INTP              // bit 7

#define C3SYNC                  CM3CON0bits.C3SYNC              // bit 0
#define C3HYS                   CM3CON0bits.C3HYS               // bit 1
#define C3SP                    CM3CON0bits.C3SP                // bit 2
#define C3ZLF                   CM3CON0bits.C3ZLF               // bit 3
#define C3POL                   CM3CON0bits.C3POL               // bit 4
#define C3OE                    CM3CON0bits.C3OE                // bit 5
#define C3OUT                   CM3CON0bits.C3OUT               // bit 6
#define C3ON                    CM3CON0bits.C3ON                // bit 7

#define C3NCH0                  CM3CON1bits.C3NCH0              // bit 0
#define C3NCH1                  CM3CON1bits.C3NCH1              // bit 1
#define C3NCH2                  CM3CON1bits.C3NCH2              // bit 2
#define C3PCH0                  CM3CON1bits.C3PCH0              // bit 3
#define C3PCH1                  CM3CON1bits.C3PCH1              // bit 4
#define C3PCH2                  CM3CON1bits.C3PCH2              // bit 5
#define C3INTN                  CM3CON1bits.C3INTN              // bit 6
#define C3INTP                  CM3CON1bits.C3INTP              // bit 7

#define C4SYNC                  CM4CON0bits.C4SYNC              // bit 0
#define C4HYS                   CM4CON0bits.C4HYS               // bit 1
#define C4SP                    CM4CON0bits.C4SP                // bit 2
#define C4ZLF                   CM4CON0bits.C4ZLF               // bit 3
#define C4POL                   CM4CON0bits.C4POL               // bit 4
#define C4OE                    CM4CON0bits.C4OE                // bit 5
#define C4OUT                   CM4CON0bits.C4OUT               // bit 6
#define C4ON                    CM4CON0bits.C4ON                // bit 7

#define C4NCH0                  CM4CON1bits.C4NCH0              // bit 0
#define C4NCH1                  CM4CON1bits.C4NCH1              // bit 1
#define C4NCH2                  CM4CON1bits.C4NCH2              // bit 2
#define C4PCH0                  CM4CON1bits.C4PCH0              // bit 3
#define C4PCH1                  CM4CON1bits.C4PCH1              // bit 4
#define C4PCH2                  CM4CON1bits.C4PCH2              // bit 5
#define C4INTN                  CM4CON1bits.C4INTN              // bit 6
#define C4INTP                  CM4CON1bits.C4INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1
#define MC3OUT                  CMOUTbits.MC3OUT                // bit 2
#define MC4OUT                  CMOUTbits.MC4OUT                // bit 3

#define DACNSS                  DACCON0bits.DACNSS              // bit 0
#define DACPSS0                 DACCON0bits.DACPSS0             // bit 2
#define DACPSS1                 DACCON0bits.DACPSS1             // bit 3
#define DACOE2                  DACCON0bits.DACOE2              // bit 4
#define DACOE1                  DACCON0bits.DACOE1              // bit 5
#define DACEN                   DACCON0bits.DACEN               // bit 7

#define DACR0                   DACCON1bits.DACR0               // bit 0
#define DACR1                   DACCON1bits.DACR1               // bit 1
#define DACR2                   DACCON1bits.DACR2               // bit 2
#define DACR3                   DACCON1bits.DACR3               // bit 3
#define DACR4                   DACCON1bits.DACR4               // bit 4
#define DACR5                   DACCON1bits.DACR5               // bit 5
#define DACR6                   DACCON1bits.DACR6               // bit 6
#define DACR7                   DACCON1bits.DACR7               // bit 7

#define RD                      EECON1bits.RD                   // bit 0
#define WR                      EECON1bits.WR                   // bit 1
#define WREN                    EECON1bits.WREN                 // bit 2
#define WRERR                   EECON1bits.WRERR                // bit 3
#define FREE                    EECON1bits.FREE                 // bit 4
#define LWLO                    EECON1bits.LWLO                 // bit 5
#define CFGS                    EECON1bits.CFGS                 // bit 6
#define EEPGD                   EECON1bits.EEPGD                // bit 7

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5
#define INLVLA6                 INLVLAbits.INLVLA6              // bit 6
#define INLVLA7                 INLVLAbits.INLVLA7              // bit 7

#define INLVLB0                 INLVLBbits.INLVLB0              // bit 0
#define INLVLB1                 INLVLBbits.INLVLB1              // bit 1
#define INLVLB2                 INLVLBbits.INLVLB2              // bit 2
#define INLVLB3                 INLVLBbits.INLVLB3              // bit 3
#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define INLVLE3                 INLVLEbits.INLVLE3              // bit 3

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5
#define IOCAF6                  IOCAFbits.IOCAF6                // bit 6
#define IOCAF7                  IOCAFbits.IOCAF7                // bit 7

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5
#define IOCAN6                  IOCANbits.IOCAN6                // bit 6
#define IOCAN7                  IOCANbits.IOCAN7                // bit 7

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5
#define IOCAP6                  IOCAPbits.IOCAP6                // bit 6
#define IOCAP7                  IOCAPbits.IOCAP7                // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5
#define IOCCF6                  IOCCFbits.IOCCF6                // bit 6
#define IOCCF7                  IOCCFbits.IOCCF7                // bit 7

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5
#define IOCCN6                  IOCCNbits.IOCCN6                // bit 6
#define IOCCN7                  IOCCNbits.IOCCN7                // bit 7

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5
#define IOCCP6                  IOCCPbits.IOCCP6                // bit 6
#define IOCCP7                  IOCCPbits.IOCCP7                // bit 7

#define IOCEF3                  IOCEFbits.IOCEF3                // bit 3

#define IOCEN3                  IOCENbits.IOCEN3                // bit 3

#define IOCEP3                  IOCEPbits.IOCEP3                // bit 3

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define ODCONA0                 ODCONAbits.ODCONA0              // bit 0
#define ODCONA1                 ODCONAbits.ODCONA1              // bit 1
#define ODCONA2                 ODCONAbits.ODCONA2              // bit 2
#define ODCONA3                 ODCONAbits.ODCONA3              // bit 3
#define ODCONA4                 ODCONAbits.ODCONA4              // bit 4
#define ODCONA5                 ODCONAbits.ODCONA5              // bit 5
#define ODCONA6                 ODCONAbits.ODCONA6              // bit 6
#define ODCONA7                 ODCONAbits.ODCONA7              // bit 7

#define ODCONB0                 ODCONBbits.ODCONB0              // bit 0
#define ODCONB1                 ODCONBbits.ODCONB1              // bit 1
#define ODCONB2                 ODCONBbits.ODCONB2              // bit 2
#define ODCONB3                 ODCONBbits.ODCONB3              // bit 3
#define ODCONB4                 ODCONBbits.ODCONB4              // bit 4
#define ODCONB5                 ODCONBbits.ODCONB5              // bit 5
#define ODCONB6                 ODCONBbits.ODCONB6              // bit 6
#define ODCONB7                 ODCONBbits.ODCONB7              // bit 7

#define ODCONC0                 ODCONCbits.ODCONC0              // bit 0
#define ODCONC1                 ODCONCbits.ODCONC1              // bit 1
#define ODCONC2                 ODCONCbits.ODCONC2              // bit 2
#define ODCONC3                 ODCONCbits.ODCONC3              // bit 3
#define ODCONC4                 ODCONCbits.ODCONC4              // bit 4
#define ODCONC5                 ODCONCbits.ODCONC5              // bit 5
#define ODCONC6                 ODCONCbits.ODCONC6              // bit 6
#define ODCONC7                 ODCONCbits.ODCONC7              // bit 7

#define OPA1PCH0                OPA1CONbits.OPA1PCH0            // bit 0, shadows bit in OPA1CONbits
#define PCH0                    OPA1CONbits.PCH0                // bit 0, shadows bit in OPA1CONbits
#define OPA1PCH1                OPA1CONbits.OPA1PCH1            // bit 1, shadows bit in OPA1CONbits
#define PCH1                    OPA1CONbits.PCH1                // bit 1, shadows bit in OPA1CONbits
#define OPA1SP                  OPA1CONbits.OPA1SP              // bit 6, shadows bit in OPA1CONbits
#define SP                      OPA1CONbits.SP                  // bit 6, shadows bit in OPA1CONbits
#define OPA1EN                  OPA1CONbits.OPA1EN              // bit 7, shadows bit in OPA1CONbits
#define EN                      OPA1CONbits.EN                  // bit 7, shadows bit in OPA1CONbits

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define T1OSCR                  OSCSTATbits.T1OSCR              // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define C3IE                    PIE2bits.C3IE                   // bit 1
#define C4IE                    PIE2bits.C4IE                   // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define EEIE                    PIE2bits.EEIE                   // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define CCP3IE                  PIE3bits.CCP3IE                 // bit 4

#define PSMC1SIE                PIE4bits.PSMC1SIE               // bit 0
#define PSMC2SIE                PIE4bits.PSMC2SIE               // bit 1
#define PSMC3SIE                PIE4bits.PSMC3SIE               // bit 2
#define PSMC1TIE                PIE4bits.PSMC1TIE               // bit 4
#define PSMC2TIE                PIE4bits.PSMC2TIE               // bit 5
#define PSMC3TIE                PIE4bits.PSMC3TIE               // bit 6, shadows bit in PIE4bits
#define PMSC3TIE                PIE4bits.PMSC3TIE               // bit 6, shadows bit in PIE4bits

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define C3IF                    PIR2bits.C3IF                   // bit 1
#define C4IF                    PIR2bits.C4IF                   // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define EEIF                    PIR2bits.EEIF                   // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define CCP3IF                  PIR3bits.CCP3IF                 // bit 4

#define PSMC1SIF                PIR4bits.PSMC1SIF               // bit 0
#define PSMC2SIF                PIR4bits.PSMC2SIF               // bit 1
#define PSMC3SIF                PIR4bits.PSMC3SIF               // bit 2
#define PSMC1TIF                PIR4bits.PSMC1TIF               // bit 4
#define PSMC2TIF                PIR4bits.PSMC2TIF               // bit 5
#define PSMC3TIF                PIR4bits.PSMC3TIF               // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RE3                     PORTEbits.RE3                   // bit 3

#define P1ASDOV                 PSMC1ASDCbits.P1ASDOV           // bit 0
#define P1ARSEN                 PSMC1ASDCbits.P1ARSEN           // bit 5
#define P1ASDEN                 PSMC1ASDCbits.P1ASDEN           // bit 6
#define P1ASE                   PSMC1ASDCbits.P1ASE             // bit 7

#define P1ASDLA                 PSMC1ASDLbits.P1ASDLA           // bit 0
#define P1ASDLB                 PSMC1ASDLbits.P1ASDLB           // bit 1
#define P1ASDLC                 PSMC1ASDLbits.P1ASDLC           // bit 2
#define P1ASDLD                 PSMC1ASDLbits.P1ASDLD           // bit 3
#define P1ASDLE                 PSMC1ASDLbits.P1ASDLE           // bit 4
#define P1ASDLF                 PSMC1ASDLbits.P1ASDLF           // bit 5

#define P1ASDSC1                PSMC1ASDSbits.P1ASDSC1          // bit 1
#define P1ASDSC2                PSMC1ASDSbits.P1ASDSC2          // bit 2
#define P1ASDSC3                PSMC1ASDSbits.P1ASDSC3          // bit 3
#define P1ASDSC4                PSMC1ASDSbits.P1ASDSC4          // bit 4
#define P1ASDSIN                PSMC1ASDSbits.P1ASDSIN          // bit 7

#define PSMC1BLKF0              PSMC1BLKFbits.PSMC1BLKF0        // bit 0
#define PSMC1BLKF1              PSMC1BLKFbits.PSMC1BLKF1        // bit 1
#define PSMC1BLKF2              PSMC1BLKFbits.PSMC1BLKF2        // bit 2
#define PSMC1BLKF3              PSMC1BLKFbits.PSMC1BLKF3        // bit 3
#define PSMC1BLKF4              PSMC1BLKFbits.PSMC1BLKF4        // bit 4
#define PSMC1BLKF5              PSMC1BLKFbits.PSMC1BLKF5        // bit 5
#define PSMC1BLKF6              PSMC1BLKFbits.PSMC1BLKF6        // bit 6
#define PSMC1BLKF7              PSMC1BLKFbits.PSMC1BLKF7        // bit 7

#define PSMC1BLKR0              PSMC1BLKRbits.PSMC1BLKR0        // bit 0
#define PSMC1BLKR1              PSMC1BLKRbits.PSMC1BLKR1        // bit 1
#define PSMC1BLKR2              PSMC1BLKRbits.PSMC1BLKR2        // bit 2
#define PSMC1BLKR3              PSMC1BLKRbits.PSMC1BLKR3        // bit 3
#define PSMC1BLKR4              PSMC1BLKRbits.PSMC1BLKR4        // bit 4
#define PSMC1BLKR5              PSMC1BLKRbits.PSMC1BLKR5        // bit 5
#define PSMC1BLKR6              PSMC1BLKRbits.PSMC1BLKR6        // bit 6
#define PSMC1BLKR7              PSMC1BLKRbits.PSMC1BLKR7        // bit 7

#define P1REBM0                 PSMC1BLNKbits.P1REBM0           // bit 0
#define P1REBM1                 PSMC1BLNKbits.P1REBM1           // bit 1
#define P1FEBM0                 PSMC1BLNKbits.P1FEBM0           // bit 4
#define P1FEBM1                 PSMC1BLNKbits.P1FEBM1           // bit 5

#define P1CSRC0                 PSMC1CLKbits.P1CSRC0            // bit 0
#define P1CSRC1                 PSMC1CLKbits.P1CSRC1            // bit 1
#define P1CPRE0                 PSMC1CLKbits.P1CPRE0            // bit 4
#define P1CPRE1                 PSMC1CLKbits.P1CPRE1            // bit 5

#define P1MODE0                 PSMC1CONbits.P1MODE0            // bit 0
#define P1MODE1                 PSMC1CONbits.P1MODE1            // bit 1
#define P1MODE2                 PSMC1CONbits.P1MODE2            // bit 2
#define P1MODE3                 PSMC1CONbits.P1MODE3            // bit 3
#define P1DBRE                  PSMC1CONbits.P1DBRE             // bit 4
#define P1DBFE                  PSMC1CONbits.P1DBFE             // bit 5
#define PSMC1LD                 PSMC1CONbits.PSMC1LD            // bit 6
#define PSMC1EN                 PSMC1CONbits.PSMC1EN            // bit 7

#define PSMC1DBF0               PSMC1DBFbits.PSMC1DBF0          // bit 0
#define PSMC1DBF1               PSMC1DBFbits.PSMC1DBF1          // bit 1
#define PSMC1DBF2               PSMC1DBFbits.PSMC1DBF2          // bit 2
#define PSMC1DBF3               PSMC1DBFbits.PSMC1DBF3          // bit 3
#define PSMC1DBF4               PSMC1DBFbits.PSMC1DBF4          // bit 4
#define PSMC1DBF5               PSMC1DBFbits.PSMC1DBF5          // bit 5
#define PSMC1DBF6               PSMC1DBFbits.PSMC1DBF6          // bit 6
#define PSMC1DBF7               PSMC1DBFbits.PSMC1DBF7          // bit 7

#define PSMC1DBR0               PSMC1DBRbits.PSMC1DBR0          // bit 0
#define PSMC1DBR1               PSMC1DBRbits.PSMC1DBR1          // bit 1
#define PSMC1DBR2               PSMC1DBRbits.PSMC1DBR2          // bit 2
#define PSMC1DBR3               PSMC1DBRbits.PSMC1DBR3          // bit 3
#define PSMC1DBR4               PSMC1DBRbits.PSMC1DBR4          // bit 4
#define PSMC1DBR5               PSMC1DBRbits.PSMC1DBR5          // bit 5
#define PSMC1DBR6               PSMC1DBRbits.PSMC1DBR6          // bit 6
#define PSMC1DBR7               PSMC1DBRbits.PSMC1DBR7          // bit 7

#define PSMC1DC8                PSMC1DCHbits.PSMC1DC8           // bit 0
#define PSMC1DC9                PSMC1DCHbits.PSMC1DC9           // bit 1
#define PSMC1DC10               PSMC1DCHbits.PSMC1DC10          // bit 2
#define PSMC1DC11               PSMC1DCHbits.PSMC1DC11          // bit 3
#define PSMC1DC12               PSMC1DCHbits.PSMC1DC12          // bit 4
#define PSMC1DC13               PSMC1DCHbits.PSMC1DC13          // bit 5
#define PSMC1DC14               PSMC1DCHbits.PSMC1DC14          // bit 6
#define PSMC1DC15               PSMC1DCHbits.PSMC1DC15          // bit 7

#define PSMC1DC0                PSMC1DCLbits.PSMC1DC0           // bit 0
#define PSMC1DC1                PSMC1DCLbits.PSMC1DC1           // bit 1
#define PSMC1DC2                PSMC1DCLbits.PSMC1DC2           // bit 2
#define PSMC1DC3                PSMC1DCLbits.PSMC1DC3           // bit 3
#define PSMC1DC4                PSMC1DCLbits.PSMC1DC4           // bit 4
#define PSMC1DC5                PSMC1DCLbits.PSMC1DC5           // bit 5
#define PSMC1DC6                PSMC1DCLbits.PSMC1DC6           // bit 6
#define PSMC1DC7                PSMC1DCLbits.PSMC1DC7           // bit 7

#define P1DCST                  PSMC1DCSbits.P1DCST             // bit 0
#define P1DCSC1                 PSMC1DCSbits.P1DCSC1            // bit 1
#define P1DCSC2                 PSMC1DCSbits.P1DCSC2            // bit 2
#define P1DCSC3                 PSMC1DCSbits.P1DCSC3            // bit 3
#define P1DCSC4                 PSMC1DCSbits.P1DCSC4            // bit 4
#define P1DCSIN                 PSMC1DCSbits.P1DCSIN            // bit 7

#define P1FEBSC1                PSMC1FEBSbits.P1FEBSC1          // bit 1
#define P1FEBSC2                PSMC1FEBSbits.P1FEBSC2          // bit 2
#define P1FEBSC3                PSMC1FEBSbits.P1FEBSC3          // bit 3
#define P1FEBSC4                PSMC1FEBSbits.P1FEBSC4          // bit 4
#define P1FEBSIN                PSMC1FEBSbits.P1FEBSIN          // bit 7

#define PSMC1FFA0               PSMC1FFAbits.PSMC1FFA0          // bit 0
#define PSMC1FFA1               PSMC1FFAbits.PSMC1FFA1          // bit 1
#define PSMC1FFA2               PSMC1FFAbits.PSMC1FFA2          // bit 2
#define PSMC1FFA3               PSMC1FFAbits.PSMC1FFA3          // bit 3

#define P1TPRIF                 PSMC1INTbits.P1TPRIF            // bit 0
#define P1TDCIF                 PSMC1INTbits.P1TDCIF            // bit 1
#define P1TPHIF                 PSMC1INTbits.P1TPHIF            // bit 2
#define P1TOVIF                 PSMC1INTbits.P1TOVIF            // bit 3
#define P1TPRIE                 PSMC1INTbits.P1TPRIE            // bit 4
#define P1TDCIE                 PSMC1INTbits.P1TDCIE            // bit 5
#define P1TPHIE                 PSMC1INTbits.P1TPHIE            // bit 6
#define P1TOVIE                 PSMC1INTbits.P1TOVIE            // bit 7

#define P1MSRC0                 PSMC1MDLbits.P1MSRC0            // bit 0
#define P1MSRC1                 PSMC1MDLbits.P1MSRC1            // bit 1
#define P1MSRC2                 PSMC1MDLbits.P1MSRC2            // bit 2
#define P1MSRC3                 PSMC1MDLbits.P1MSRC3            // bit 3
#define P1MDLBIT                PSMC1MDLbits.P1MDLBIT           // bit 5
#define P1MDLPOL                PSMC1MDLbits.P1MDLPOL           // bit 6
#define P1MDLEN                 PSMC1MDLbits.P1MDLEN            // bit 7

#define P1OEA                   PSMC1OENbits.P1OEA              // bit 0
#define P1OEB                   PSMC1OENbits.P1OEB              // bit 1
#define P1OEC                   PSMC1OENbits.P1OEC              // bit 2
#define P1OED                   PSMC1OENbits.P1OED              // bit 3
#define P1OEE                   PSMC1OENbits.P1OEE              // bit 4
#define P1OEF                   PSMC1OENbits.P1OEF              // bit 5

#define PSMC1PH8                PSMC1PHHbits.PSMC1PH8           // bit 0
#define PSMC1PH9                PSMC1PHHbits.PSMC1PH9           // bit 1
#define PSMC1PH10               PSMC1PHHbits.PSMC1PH10          // bit 2
#define PSMC1PH11               PSMC1PHHbits.PSMC1PH11          // bit 3
#define PSMC1PH12               PSMC1PHHbits.PSMC1PH12          // bit 4
#define PSMC1PH13               PSMC1PHHbits.PSMC1PH13          // bit 5
#define PSMC1PH14               PSMC1PHHbits.PSMC1PH14          // bit 6
#define PSMC1PH15               PSMC1PHHbits.PSMC1PH15          // bit 7

#define PSMC1PH0                PSMC1PHLbits.PSMC1PH0           // bit 0
#define PSMC1PH1                PSMC1PHLbits.PSMC1PH1           // bit 1
#define PSMC1PH2                PSMC1PHLbits.PSMC1PH2           // bit 2
#define PSMC1PH3                PSMC1PHLbits.PSMC1PH3           // bit 3
#define PSMC1PH4                PSMC1PHLbits.PSMC1PH4           // bit 4
#define PSMC1PH5                PSMC1PHLbits.PSMC1PH5           // bit 5
#define PSMC1PH6                PSMC1PHLbits.PSMC1PH6           // bit 6
#define PSMC1PH7                PSMC1PHLbits.PSMC1PH7           // bit 7

#define P1PHST                  PSMC1PHSbits.P1PHST             // bit 0
#define P1PHSC1                 PSMC1PHSbits.P1PHSC1            // bit 1
#define P1PHSC2                 PSMC1PHSbits.P1PHSC2            // bit 2
#define P1PHSC3                 PSMC1PHSbits.P1PHSC3            // bit 3
#define P1PHSC4                 PSMC1PHSbits.P1PHSC4            // bit 4
#define P1PHSIN                 PSMC1PHSbits.P1PHSIN            // bit 7

#define P1POLA                  PSMC1POLbits.P1POLA             // bit 0
#define P1POLB                  PSMC1POLbits.P1POLB             // bit 1
#define P1POLC                  PSMC1POLbits.P1POLC             // bit 2
#define P1POLD                  PSMC1POLbits.P1POLD             // bit 3
#define P1POLE                  PSMC1POLbits.P1POLE             // bit 4
#define P1POLF                  PSMC1POLbits.P1POLF             // bit 5
#define P1INPOL                 PSMC1POLbits.P1INPOL            // bit 6

#define PSMC1PR8                PSMC1PRHbits.PSMC1PR8           // bit 0
#define PSMC1PR9                PSMC1PRHbits.PSMC1PR9           // bit 1
#define PSMC1PR10               PSMC1PRHbits.PSMC1PR10          // bit 2
#define PSMC1PR11               PSMC1PRHbits.PSMC1PR11          // bit 3
#define PSMC1PR12               PSMC1PRHbits.PSMC1PR12          // bit 4
#define PSMC1PR13               PSMC1PRHbits.PSMC1PR13          // bit 5
#define PSMC1PR14               PSMC1PRHbits.PSMC1PR14          // bit 6
#define PSMC1PR15               PSMC1PRHbits.PSMC1PR15          // bit 7

#define PSMC1PR0                PSMC1PRLbits.PSMC1PR0           // bit 0
#define PSMC1PR1                PSMC1PRLbits.PSMC1PR1           // bit 1
#define PSMC1PR2                PSMC1PRLbits.PSMC1PR2           // bit 2
#define PSMC1PR3                PSMC1PRLbits.PSMC1PR3           // bit 3
#define PSMC1PR4                PSMC1PRLbits.PSMC1PR4           // bit 4
#define PSMC1PR5                PSMC1PRLbits.PSMC1PR5           // bit 5
#define PSMC1PR6                PSMC1PRLbits.PSMC1PR6           // bit 6
#define PSMC1PR7                PSMC1PRLbits.PSMC1PR7           // bit 7

#define P1PRST                  PSMC1PRSbits.P1PRST             // bit 0
#define P1PRSC1                 PSMC1PRSbits.P1PRSC1            // bit 1
#define P1PRSC2                 PSMC1PRSbits.P1PRSC2            // bit 2
#define P1PRSC3                 PSMC1PRSbits.P1PRSC3            // bit 3
#define P1PRSC4                 PSMC1PRSbits.P1PRSC4            // bit 4
#define P1PRSIN                 PSMC1PRSbits.P1PRSIN            // bit 7

#define P1REBSC1                PSMC1REBSbits.P1REBSC1          // bit 1
#define P1REBSC2                PSMC1REBSbits.P1REBSC2          // bit 2
#define P1REBSC3                PSMC1REBSbits.P1REBSC3          // bit 3
#define P1REBSC4                PSMC1REBSbits.P1REBSC4          // bit 4
#define P1REBSIN                PSMC1REBSbits.P1REBSIN          // bit 7

#define P1STRA                  PSMC1STR0bits.P1STRA            // bit 0
#define P1STRB                  PSMC1STR0bits.P1STRB            // bit 1
#define P1STRC                  PSMC1STR0bits.P1STRC            // bit 2
#define P1STRD                  PSMC1STR0bits.P1STRD            // bit 3
#define P1STRE                  PSMC1STR0bits.P1STRE            // bit 4
#define P1STRF                  PSMC1STR0bits.P1STRF            // bit 5

#define P1HSMEN                 PSMC1STR1bits.P1HSMEN           // bit 0
#define P1LSMEN                 PSMC1STR1bits.P1LSMEN           // bit 1
#define P1SSYNC                 PSMC1STR1bits.P1SSYNC           // bit 7

#define P1SYNC0                 PSMC1SYNCbits.P1SYNC0           // bit 0
#define P1SYNC1                 PSMC1SYNCbits.P1SYNC1           // bit 1
#define P1SYNC2                 PSMC1SYNCbits.P1SYNC2           // bit 2
#define P1DCPOL                 PSMC1SYNCbits.P1DCPOL           // bit 5
#define P1PRPOL                 PSMC1SYNCbits.P1PRPOL           // bit 6
#define P1POFST                 PSMC1SYNCbits.P1POFST           // bit 7

#define PSMC1TMR8               PSMC1TMRHbits.PSMC1TMR8         // bit 0
#define PSMC1TMR9               PSMC1TMRHbits.PSMC1TMR9         // bit 1
#define PSMC1TMR10              PSMC1TMRHbits.PSMC1TMR10        // bit 2
#define PSMC1TMR11              PSMC1TMRHbits.PSMC1TMR11        // bit 3
#define PSMC1TMR12              PSMC1TMRHbits.PSMC1TMR12        // bit 4
#define PSMC1TMR13              PSMC1TMRHbits.PSMC1TMR13        // bit 5
#define PSMC1TMR14              PSMC1TMRHbits.PSMC1TMR14        // bit 6
#define PSMC1TMR15              PSMC1TMRHbits.PSMC1TMR15        // bit 7

#define PSMC1TMR0               PSMC1TMRLbits.PSMC1TMR0         // bit 0
#define PSMC1TMR1               PSMC1TMRLbits.PSMC1TMR1         // bit 1
#define PSMC1TMR2               PSMC1TMRLbits.PSMC1TMR2         // bit 2
#define PSMC1TMR3               PSMC1TMRLbits.PSMC1TMR3         // bit 3
#define PSMC1TMR4               PSMC1TMRLbits.PSMC1TMR4         // bit 4
#define PSMC1TMR5               PSMC1TMRLbits.PSMC1TMR5         // bit 5
#define PSMC1TMR6               PSMC1TMRLbits.PSMC1TMR6         // bit 6
#define PSMC1TMR7               PSMC1TMRLbits.PSMC1TMR7         // bit 7

#define P2ASDOV                 PSMC2ASDCbits.P2ASDOV           // bit 0
#define P2ARSEN                 PSMC2ASDCbits.P2ARSEN           // bit 5
#define P2ASDEN                 PSMC2ASDCbits.P2ASDEN           // bit 6
#define P2ASE                   PSMC2ASDCbits.P2ASE             // bit 7

#define P2ASDLA                 PSMC2ASDLbits.P2ASDLA           // bit 0
#define P2ASDLB                 PSMC2ASDLbits.P2ASDLB           // bit 1

#define P2ASDSC1                PSMC2ASDSbits.P2ASDSC1          // bit 1
#define P2ASDSC2                PSMC2ASDSbits.P2ASDSC2          // bit 2
#define P2ASDSC3                PSMC2ASDSbits.P2ASDSC3          // bit 3
#define P2ASDSC4                PSMC2ASDSbits.P2ASDSC4          // bit 4
#define P2ASDSIN                PSMC2ASDSbits.P2ASDSIN          // bit 7

#define PSMC2BLKF0              PSMC2BLKFbits.PSMC2BLKF0        // bit 0
#define PSMC2BLKF1              PSMC2BLKFbits.PSMC2BLKF1        // bit 1
#define PSMC2BLKF2              PSMC2BLKFbits.PSMC2BLKF2        // bit 2
#define PSMC2BLKF3              PSMC2BLKFbits.PSMC2BLKF3        // bit 3
#define PSMC2BLKF4              PSMC2BLKFbits.PSMC2BLKF4        // bit 4
#define PSMC2BLKF5              PSMC2BLKFbits.PSMC2BLKF5        // bit 5
#define PSMC2BLKF6              PSMC2BLKFbits.PSMC2BLKF6        // bit 6
#define PSMC2BLKF7              PSMC2BLKFbits.PSMC2BLKF7        // bit 7

#define PSMC2BLKR0              PSMC2BLKRbits.PSMC2BLKR0        // bit 0
#define PSMC2BLKR1              PSMC2BLKRbits.PSMC2BLKR1        // bit 1
#define PSMC2BLKR2              PSMC2BLKRbits.PSMC2BLKR2        // bit 2
#define PSMC2BLKR3              PSMC2BLKRbits.PSMC2BLKR3        // bit 3
#define PSMC2BLKR4              PSMC2BLKRbits.PSMC2BLKR4        // bit 4
#define PSMC2BLKR5              PSMC2BLKRbits.PSMC2BLKR5        // bit 5
#define PSMC2BLKR6              PSMC2BLKRbits.PSMC2BLKR6        // bit 6
#define PSMC2BLKR7              PSMC2BLKRbits.PSMC2BLKR7        // bit 7

#define P2REBM0                 PSMC2BLNKbits.P2REBM0           // bit 0
#define P2REBM1                 PSMC2BLNKbits.P2REBM1           // bit 1
#define P2FEBM0                 PSMC2BLNKbits.P2FEBM0           // bit 4
#define P2FEBM1                 PSMC2BLNKbits.P2FEBM1           // bit 5

#define P2CSRC0                 PSMC2CLKbits.P2CSRC0            // bit 0
#define P2CSRC1                 PSMC2CLKbits.P2CSRC1            // bit 1
#define P2CPRE0                 PSMC2CLKbits.P2CPRE0            // bit 4
#define P2CPRE1                 PSMC2CLKbits.P2CPRE1            // bit 5

#define P2MODE0                 PSMC2CONbits.P2MODE0            // bit 0
#define P2MODE1                 PSMC2CONbits.P2MODE1            // bit 1
#define P2MODE2                 PSMC2CONbits.P2MODE2            // bit 2
#define P2MODE3                 PSMC2CONbits.P2MODE3            // bit 3
#define P2DBRE                  PSMC2CONbits.P2DBRE             // bit 4
#define P2DBFE                  PSMC2CONbits.P2DBFE             // bit 5
#define PSMC2LD                 PSMC2CONbits.PSMC2LD            // bit 6
#define PSMC2EN                 PSMC2CONbits.PSMC2EN            // bit 7

#define PSMC2DBF0               PSMC2DBFbits.PSMC2DBF0          // bit 0
#define PSMC2DBF1               PSMC2DBFbits.PSMC2DBF1          // bit 1
#define PSMC2DBF2               PSMC2DBFbits.PSMC2DBF2          // bit 2
#define PSMC2DBF3               PSMC2DBFbits.PSMC2DBF3          // bit 3
#define PSMC2DBF4               PSMC2DBFbits.PSMC2DBF4          // bit 4
#define PSMC2DBF5               PSMC2DBFbits.PSMC2DBF5          // bit 5
#define PSMC2DBF6               PSMC2DBFbits.PSMC2DBF6          // bit 6
#define PSMC2DBF7               PSMC2DBFbits.PSMC2DBF7          // bit 7

#define PSMC2DBR0               PSMC2DBRbits.PSMC2DBR0          // bit 0
#define PSMC2DBR1               PSMC2DBRbits.PSMC2DBR1          // bit 1
#define PSMC2DBR2               PSMC2DBRbits.PSMC2DBR2          // bit 2
#define PSMC2DBR3               PSMC2DBRbits.PSMC2DBR3          // bit 3
#define PSMC2DBR4               PSMC2DBRbits.PSMC2DBR4          // bit 4
#define PSMC2DBR5               PSMC2DBRbits.PSMC2DBR5          // bit 5
#define PSMC2DBR6               PSMC2DBRbits.PSMC2DBR6          // bit 6
#define PSMC2DBR7               PSMC2DBRbits.PSMC2DBR7          // bit 7

#define PSMC2DC8                PSMC2DCHbits.PSMC2DC8           // bit 0
#define PSMC2DC9                PSMC2DCHbits.PSMC2DC9           // bit 1
#define PSMC2DC10               PSMC2DCHbits.PSMC2DC10          // bit 2
#define PSMC2DC11               PSMC2DCHbits.PSMC2DC11          // bit 3
#define PSMC2DC12               PSMC2DCHbits.PSMC2DC12          // bit 4
#define PSMC2DC13               PSMC2DCHbits.PSMC2DC13          // bit 5
#define PSMC2DC14               PSMC2DCHbits.PSMC2DC14          // bit 6
#define PSMC2DC15               PSMC2DCHbits.PSMC2DC15          // bit 7

#define PSMC2DC0                PSMC2DCLbits.PSMC2DC0           // bit 0
#define PSMC2DC1                PSMC2DCLbits.PSMC2DC1           // bit 1
#define PSMC2DC2                PSMC2DCLbits.PSMC2DC2           // bit 2
#define PSMC2DC3                PSMC2DCLbits.PSMC2DC3           // bit 3
#define PSMC2DC4                PSMC2DCLbits.PSMC2DC4           // bit 4
#define PSMC2DC5                PSMC2DCLbits.PSMC2DC5           // bit 5
#define PSMC2DC6                PSMC2DCLbits.PSMC2DC6           // bit 6
#define PSMC2DC7                PSMC2DCLbits.PSMC2DC7           // bit 7

#define P2DCST                  PSMC2DCSbits.P2DCST             // bit 0
#define P2DCSC1                 PSMC2DCSbits.P2DCSC1            // bit 1
#define P2DCSC2                 PSMC2DCSbits.P2DCSC2            // bit 2
#define P2DCSC3                 PSMC2DCSbits.P2DCSC3            // bit 3
#define P2DCSC4                 PSMC2DCSbits.P2DCSC4            // bit 4
#define P2DCSIN                 PSMC2DCSbits.P2DCSIN            // bit 7

#define P2FEBSC1                PSMC2FEBSbits.P2FEBSC1          // bit 1
#define P2FEBSC2                PSMC2FEBSbits.P2FEBSC2          // bit 2
#define P2FEBSC3                PSMC2FEBSbits.P2FEBSC3          // bit 3
#define P2FEBSC4                PSMC2FEBSbits.P2FEBSC4          // bit 4
#define P2FEBSIN                PSMC2FEBSbits.P2FEBSIN          // bit 7

#define PSMC2FFA0               PSMC2FFAbits.PSMC2FFA0          // bit 0
#define PSMC2FFA1               PSMC2FFAbits.PSMC2FFA1          // bit 1
#define PSMC2FFA2               PSMC2FFAbits.PSMC2FFA2          // bit 2
#define PSMC2FFA3               PSMC2FFAbits.PSMC2FFA3          // bit 3

#define P2TPRIF                 PSMC2INTbits.P2TPRIF            // bit 0
#define P2TDCIF                 PSMC2INTbits.P2TDCIF            // bit 1
#define P2TPHIF                 PSMC2INTbits.P2TPHIF            // bit 2
#define P2TOVIF                 PSMC2INTbits.P2TOVIF            // bit 3
#define P2TPRIE                 PSMC2INTbits.P2TPRIE            // bit 4
#define P2TDCIE                 PSMC2INTbits.P2TDCIE            // bit 5
#define P2TPHIE                 PSMC2INTbits.P2TPHIE            // bit 6
#define P2TOVIE                 PSMC2INTbits.P2TOVIE            // bit 7

#define P2MSRC0                 PSMC2MDLbits.P2MSRC0            // bit 0
#define P2MSRC1                 PSMC2MDLbits.P2MSRC1            // bit 1
#define P2MSRC2                 PSMC2MDLbits.P2MSRC2            // bit 2
#define P2MSRC3                 PSMC2MDLbits.P2MSRC3            // bit 3
#define P2MDLBIT                PSMC2MDLbits.P2MDLBIT           // bit 5
#define P2MDLPOL                PSMC2MDLbits.P2MDLPOL           // bit 6
#define P2MDLEN                 PSMC2MDLbits.P2MDLEN            // bit 7

#define P2OEA                   PSMC2OENbits.P2OEA              // bit 0
#define P2OEB                   PSMC2OENbits.P2OEB              // bit 1

#define PSMC2PH8                PSMC2PHHbits.PSMC2PH8           // bit 0
#define PSMC2PH9                PSMC2PHHbits.PSMC2PH9           // bit 1
#define PSMC2PH10               PSMC2PHHbits.PSMC2PH10          // bit 2
#define PSMC2PH11               PSMC2PHHbits.PSMC2PH11          // bit 3
#define PSMC2PH12               PSMC2PHHbits.PSMC2PH12          // bit 4
#define PSMC2PH13               PSMC2PHHbits.PSMC2PH13          // bit 5
#define PSMC2PH14               PSMC2PHHbits.PSMC2PH14          // bit 6
#define PSMC2PH15               PSMC2PHHbits.PSMC2PH15          // bit 7

#define PSMC2PH0                PSMC2PHLbits.PSMC2PH0           // bit 0
#define PSMC2PH1                PSMC2PHLbits.PSMC2PH1           // bit 1
#define PSMC2PH2                PSMC2PHLbits.PSMC2PH2           // bit 2
#define PSMC2PH3                PSMC2PHLbits.PSMC2PH3           // bit 3
#define PSMC2PH4                PSMC2PHLbits.PSMC2PH4           // bit 4
#define PSMC2PH5                PSMC2PHLbits.PSMC2PH5           // bit 5
#define PSMC2PH6                PSMC2PHLbits.PSMC2PH6           // bit 6
#define PSMC2PH7                PSMC2PHLbits.PSMC2PH7           // bit 7

#define P2PHST                  PSMC2PHSbits.P2PHST             // bit 0
#define P2PHSC1                 PSMC2PHSbits.P2PHSC1            // bit 1
#define P2PHSC2                 PSMC2PHSbits.P2PHSC2            // bit 2
#define P2PHSC3                 PSMC2PHSbits.P2PHSC3            // bit 3
#define P2PHSC4                 PSMC2PHSbits.P2PHSC4            // bit 4
#define P2PHSIN                 PSMC2PHSbits.P2PHSIN            // bit 7

#define P2POLA                  PSMC2POLbits.P2POLA             // bit 0
#define P2POLB                  PSMC2POLbits.P2POLB             // bit 1
#define P2INPOL                 PSMC2POLbits.P2INPOL            // bit 6

#define PSMC2PR8                PSMC2PRHbits.PSMC2PR8           // bit 0
#define PSMC2PR9                PSMC2PRHbits.PSMC2PR9           // bit 1
#define PSMC2PR10               PSMC2PRHbits.PSMC2PR10          // bit 2
#define PSMC2PR11               PSMC2PRHbits.PSMC2PR11          // bit 3
#define PSMC2PR12               PSMC2PRHbits.PSMC2PR12          // bit 4
#define PSMC2PR13               PSMC2PRHbits.PSMC2PR13          // bit 5
#define PSMC2PR14               PSMC2PRHbits.PSMC2PR14          // bit 6
#define PSMC2PR15               PSMC2PRHbits.PSMC2PR15          // bit 7

#define PSMC2PR0                PSMC2PRLbits.PSMC2PR0           // bit 0
#define PSMC2PR1                PSMC2PRLbits.PSMC2PR1           // bit 1
#define PSMC2PR2                PSMC2PRLbits.PSMC2PR2           // bit 2
#define PSMC2PR3                PSMC2PRLbits.PSMC2PR3           // bit 3
#define PSMC2PR4                PSMC2PRLbits.PSMC2PR4           // bit 4
#define PSMC2PR5                PSMC2PRLbits.PSMC2PR5           // bit 5
#define PSMC2PR6                PSMC2PRLbits.PSMC2PR6           // bit 6
#define PSMC2PR7                PSMC2PRLbits.PSMC2PR7           // bit 7

#define P2PRST                  PSMC2PRSbits.P2PRST             // bit 0
#define P2PRSC1                 PSMC2PRSbits.P2PRSC1            // bit 1
#define P2PRSC2                 PSMC2PRSbits.P2PRSC2            // bit 2
#define P2PRSC3                 PSMC2PRSbits.P2PRSC3            // bit 3
#define P2PRSC4                 PSMC2PRSbits.P2PRSC4            // bit 4
#define P2PRSIN                 PSMC2PRSbits.P2PRSIN            // bit 7

#define P2REBSC1                PSMC2REBSbits.P2REBSC1          // bit 1
#define P2REBSC2                PSMC2REBSbits.P2REBSC2          // bit 2
#define P2REBSC3                PSMC2REBSbits.P2REBSC3          // bit 3
#define P2REBSC4                PSMC2REBSbits.P2REBSC4          // bit 4
#define P2REBSIN                PSMC2REBSbits.P2REBSIN          // bit 7

#define P2STRA                  PSMC2STR0bits.P2STRA            // bit 0
#define P2STRB                  PSMC2STR0bits.P2STRB            // bit 1

#define P2HSMEN                 PSMC2STR1bits.P2HSMEN           // bit 0
#define P2LSMEN                 PSMC2STR1bits.P2LSMEN           // bit 1
#define P2SSYNC                 PSMC2STR1bits.P2SSYNC           // bit 7

#define P2SYNC0                 PSMC2SYNCbits.P2SYNC0           // bit 0
#define P2SYNC1                 PSMC2SYNCbits.P2SYNC1           // bit 1
#define P2SYNC2                 PSMC2SYNCbits.P2SYNC2           // bit 2
#define P2DCPOL                 PSMC2SYNCbits.P2DCPOL           // bit 5
#define P2PRPOL                 PSMC2SYNCbits.P2PRPOL           // bit 6
#define P2POFST                 PSMC2SYNCbits.P2POFST           // bit 7

#define PSMC2TMR8               PSMC2TMRHbits.PSMC2TMR8         // bit 0
#define PSMC2TMR9               PSMC2TMRHbits.PSMC2TMR9         // bit 1
#define PSMC2TMR10              PSMC2TMRHbits.PSMC2TMR10        // bit 2
#define PSMC2TMR11              PSMC2TMRHbits.PSMC2TMR11        // bit 3
#define PSMC2TMR12              PSMC2TMRHbits.PSMC2TMR12        // bit 4
#define PSMC2TMR13              PSMC2TMRHbits.PSMC2TMR13        // bit 5
#define PSMC2TMR14              PSMC2TMRHbits.PSMC2TMR14        // bit 6
#define PSMC2TMR15              PSMC2TMRHbits.PSMC2TMR15        // bit 7

#define PSMC2TMR0               PSMC2TMRLbits.PSMC2TMR0         // bit 0
#define PSMC2TMR1               PSMC2TMRLbits.PSMC2TMR1         // bit 1
#define PSMC2TMR2               PSMC2TMRLbits.PSMC2TMR2         // bit 2
#define PSMC2TMR3               PSMC2TMRLbits.PSMC2TMR3         // bit 3
#define PSMC2TMR4               PSMC2TMRLbits.PSMC2TMR4         // bit 4
#define PSMC2TMR5               PSMC2TMRLbits.PSMC2TMR5         // bit 5
#define PSMC2TMR6               PSMC2TMRLbits.PSMC2TMR6         // bit 6
#define PSMC2TMR7               PSMC2TMRLbits.PSMC2TMR7         // bit 7

#define P3ASDOV                 PSMC3ASDCbits.P3ASDOV           // bit 0
#define P3ARSEN                 PSMC3ASDCbits.P3ARSEN           // bit 5
#define P3ASDEN                 PSMC3ASDCbits.P3ASDEN           // bit 6
#define P3ASE                   PSMC3ASDCbits.P3ASE             // bit 7

#define P3ASDLA                 PSMC3ASDLbits.P3ASDLA           // bit 0
#define P3ASDLB                 PSMC3ASDLbits.P3ASDLB           // bit 1
#define P3ASDLC                 PSMC3ASDLbits.P3ASDLC           // bit 2
#define P3ASDLD                 PSMC3ASDLbits.P3ASDLD           // bit 3
#define P3ASDLE                 PSMC3ASDLbits.P3ASDLE           // bit 4
#define P3ASDLF                 PSMC3ASDLbits.P3ASDLF           // bit 5

#define P3ASDSC1                PSMC3ASDSbits.P3ASDSC1          // bit 1
#define P3ASDSC2                PSMC3ASDSbits.P3ASDSC2          // bit 2
#define P3ASDSC3                PSMC3ASDSbits.P3ASDSC3          // bit 3
#define P3ASDSC4                PSMC3ASDSbits.P3ASDSC4          // bit 4
#define P3ASDSIN                PSMC3ASDSbits.P3ASDSIN          // bit 7

#define PSMC3BLKF0              PSMC3BLKFbits.PSMC3BLKF0        // bit 0
#define PSMC3BLKF1              PSMC3BLKFbits.PSMC3BLKF1        // bit 1
#define PSMC3BLKF2              PSMC3BLKFbits.PSMC3BLKF2        // bit 2
#define PSMC3BLKF3              PSMC3BLKFbits.PSMC3BLKF3        // bit 3
#define PSMC3BLKF4              PSMC3BLKFbits.PSMC3BLKF4        // bit 4
#define PSMC3BLKF5              PSMC3BLKFbits.PSMC3BLKF5        // bit 5
#define PSMC3BLKF6              PSMC3BLKFbits.PSMC3BLKF6        // bit 6
#define PSMC3BLKF7              PSMC3BLKFbits.PSMC3BLKF7        // bit 7

#define PSMC3BLKR0              PSMC3BLKRbits.PSMC3BLKR0        // bit 0
#define PSMC3BLKR1              PSMC3BLKRbits.PSMC3BLKR1        // bit 1
#define PSMC3BLKR2              PSMC3BLKRbits.PSMC3BLKR2        // bit 2
#define PSMC3BLKR3              PSMC3BLKRbits.PSMC3BLKR3        // bit 3
#define PSMC3BLKR4              PSMC3BLKRbits.PSMC3BLKR4        // bit 4
#define PSMC3BLKR5              PSMC3BLKRbits.PSMC3BLKR5        // bit 5
#define PSMC3BLKR6              PSMC3BLKRbits.PSMC3BLKR6        // bit 6
#define PSMC3BLKR7              PSMC3BLKRbits.PSMC3BLKR7        // bit 7

#define P3REBM0                 PSMC3BLNKbits.P3REBM0           // bit 0
#define P3REBM1                 PSMC3BLNKbits.P3REBM1           // bit 1
#define P3FEBM0                 PSMC3BLNKbits.P3FEBM0           // bit 4
#define P3FEBM1                 PSMC3BLNKbits.P3FEBM1           // bit 5

#define P3CSRC0                 PSMC3CLKbits.P3CSRC0            // bit 0
#define P3CSRC1                 PSMC3CLKbits.P3CSRC1            // bit 1
#define P3CPRE0                 PSMC3CLKbits.P3CPRE0            // bit 4
#define P3CPRE1                 PSMC3CLKbits.P3CPRE1            // bit 5

#define P3MODE0                 PSMC3CONbits.P3MODE0            // bit 0
#define P3MODE1                 PSMC3CONbits.P3MODE1            // bit 1
#define P3MODE2                 PSMC3CONbits.P3MODE2            // bit 2
#define P3MODE3                 PSMC3CONbits.P3MODE3            // bit 3
#define P3DBRE                  PSMC3CONbits.P3DBRE             // bit 4
#define P3DBFE                  PSMC3CONbits.P3DBFE             // bit 5
#define PSMC3LD                 PSMC3CONbits.PSMC3LD            // bit 6
#define PSMC3EN                 PSMC3CONbits.PSMC3EN            // bit 7

#define PSMC3DBF0               PSMC3DBFbits.PSMC3DBF0          // bit 0
#define PSMC3DBF1               PSMC3DBFbits.PSMC3DBF1          // bit 1
#define PSMC3DBF2               PSMC3DBFbits.PSMC3DBF2          // bit 2
#define PSMC3DBF3               PSMC3DBFbits.PSMC3DBF3          // bit 3
#define PSMC3DBF4               PSMC3DBFbits.PSMC3DBF4          // bit 4
#define PSMC3DBF5               PSMC3DBFbits.PSMC3DBF5          // bit 5
#define PSMC3DBF6               PSMC3DBFbits.PSMC3DBF6          // bit 6
#define PSMC3DBF7               PSMC3DBFbits.PSMC3DBF7          // bit 7

#define PSMC3DBR0               PSMC3DBRbits.PSMC3DBR0          // bit 0
#define PSMC3DBR1               PSMC3DBRbits.PSMC3DBR1          // bit 1
#define PSMC3DBR2               PSMC3DBRbits.PSMC3DBR2          // bit 2
#define PSMC3DBR3               PSMC3DBRbits.PSMC3DBR3          // bit 3
#define PSMC3DBR4               PSMC3DBRbits.PSMC3DBR4          // bit 4
#define PSMC3DBR5               PSMC3DBRbits.PSMC3DBR5          // bit 5
#define PSMC3DBR6               PSMC3DBRbits.PSMC3DBR6          // bit 6
#define PSMC3DBR7               PSMC3DBRbits.PSMC3DBR7          // bit 7

#define PSMC3DC8                PSMC3DCHbits.PSMC3DC8           // bit 0
#define PSMC3DC9                PSMC3DCHbits.PSMC3DC9           // bit 1
#define PSMC3DC10               PSMC3DCHbits.PSMC3DC10          // bit 2
#define PSMC3DC11               PSMC3DCHbits.PSMC3DC11          // bit 3
#define PSMC3DC12               PSMC3DCHbits.PSMC3DC12          // bit 4
#define PSMC3DC13               PSMC3DCHbits.PSMC3DC13          // bit 5
#define PSMC3DC14               PSMC3DCHbits.PSMC3DC14          // bit 6
#define PSMC3DC15               PSMC3DCHbits.PSMC3DC15          // bit 7

#define PSMC3DC0                PSMC3DCLbits.PSMC3DC0           // bit 0
#define PSMC3DC1                PSMC3DCLbits.PSMC3DC1           // bit 1
#define PSMC3DC2                PSMC3DCLbits.PSMC3DC2           // bit 2
#define PSMC3DC3                PSMC3DCLbits.PSMC3DC3           // bit 3
#define PSMC3DC4                PSMC3DCLbits.PSMC3DC4           // bit 4
#define PSMC3DC5                PSMC3DCLbits.PSMC3DC5           // bit 5
#define PSMC3DC6                PSMC3DCLbits.PSMC3DC6           // bit 6
#define PSMC3DC7                PSMC3DCLbits.PSMC3DC7           // bit 7

#define P3DCST                  PSMC3DCSbits.P3DCST             // bit 0
#define P3DCSC1                 PSMC3DCSbits.P3DCSC1            // bit 1
#define P3DCSC2                 PSMC3DCSbits.P3DCSC2            // bit 2
#define P3DCSC3                 PSMC3DCSbits.P3DCSC3            // bit 3
#define P3DCSC4                 PSMC3DCSbits.P3DCSC4            // bit 4
#define P3DCSIN                 PSMC3DCSbits.P3DCSIN            // bit 7

#define P3FEBSC1                PSMC3FEBSbits.P3FEBSC1          // bit 1
#define P3FEBSC2                PSMC3FEBSbits.P3FEBSC2          // bit 2
#define P3FEBSC3                PSMC3FEBSbits.P3FEBSC3          // bit 3
#define P3FEBSC4                PSMC3FEBSbits.P3FEBSC4          // bit 4
#define P3FEBSIN                PSMC3FEBSbits.P3FEBSIN          // bit 7

#define PSMC3FFA0               PSMC3FFAbits.PSMC3FFA0          // bit 0
#define PSMC3FFA1               PSMC3FFAbits.PSMC3FFA1          // bit 1
#define PSMC3FFA2               PSMC3FFAbits.PSMC3FFA2          // bit 2
#define PSMC3FFA3               PSMC3FFAbits.PSMC3FFA3          // bit 3

#define P3TPRIF                 PSMC3INTbits.P3TPRIF            // bit 0
#define P3TDCIF                 PSMC3INTbits.P3TDCIF            // bit 1
#define P3TPHIF                 PSMC3INTbits.P3TPHIF            // bit 2
#define P3TOVIF                 PSMC3INTbits.P3TOVIF            // bit 3
#define P3TPRIE                 PSMC3INTbits.P3TPRIE            // bit 4
#define P3TDCIE                 PSMC3INTbits.P3TDCIE            // bit 5
#define P3TPHIE                 PSMC3INTbits.P3TPHIE            // bit 6
#define P3TOVIE                 PSMC3INTbits.P3TOVIE            // bit 7

#define P3MSRC0                 PSMC3MDLbits.P3MSRC0            // bit 0
#define P3MSRC1                 PSMC3MDLbits.P3MSRC1            // bit 1
#define P3MSRC2                 PSMC3MDLbits.P3MSRC2            // bit 2
#define P3MSRC3                 PSMC3MDLbits.P3MSRC3            // bit 3
#define P3MDLBIT                PSMC3MDLbits.P3MDLBIT           // bit 5
#define P3MDLPOL                PSMC3MDLbits.P3MDLPOL           // bit 6
#define P3MDLEN                 PSMC3MDLbits.P3MDLEN            // bit 7

#define P3OEA                   PSMC3OENbits.P3OEA              // bit 0
#define P3OEB                   PSMC3OENbits.P3OEB              // bit 1

#define PSMC3PH8                PSMC3PHHbits.PSMC3PH8           // bit 0
#define PSMC3PH9                PSMC3PHHbits.PSMC3PH9           // bit 1
#define PSMC3PH10               PSMC3PHHbits.PSMC3PH10          // bit 2
#define PSMC3PH11               PSMC3PHHbits.PSMC3PH11          // bit 3
#define PSMC3PH12               PSMC3PHHbits.PSMC3PH12          // bit 4
#define PSMC3PH13               PSMC3PHHbits.PSMC3PH13          // bit 5
#define PSMC3PH14               PSMC3PHHbits.PSMC3PH14          // bit 6
#define PSMC3PH15               PSMC3PHHbits.PSMC3PH15          // bit 7

#define PSMC3PH0                PSMC3PHLbits.PSMC3PH0           // bit 0
#define PSMC3PH1                PSMC3PHLbits.PSMC3PH1           // bit 1
#define PSMC3PH2                PSMC3PHLbits.PSMC3PH2           // bit 2
#define PSMC3PH3                PSMC3PHLbits.PSMC3PH3           // bit 3
#define PSMC3PH4                PSMC3PHLbits.PSMC3PH4           // bit 4
#define PSMC3PH5                PSMC3PHLbits.PSMC3PH5           // bit 5
#define PSMC3PH6                PSMC3PHLbits.PSMC3PH6           // bit 6
#define PSMC3PH7                PSMC3PHLbits.PSMC3PH7           // bit 7

#define P3PHST                  PSMC3PHSbits.P3PHST             // bit 0
#define P3PHSC1                 PSMC3PHSbits.P3PHSC1            // bit 1
#define P3PHSC2                 PSMC3PHSbits.P3PHSC2            // bit 2
#define P3PHSC3                 PSMC3PHSbits.P3PHSC3            // bit 3
#define P3PHSC4                 PSMC3PHSbits.P3PHSC4            // bit 4
#define P3PHSIN                 PSMC3PHSbits.P3PHSIN            // bit 7

#define P3POLA                  PSMC3POLbits.P3POLA             // bit 0
#define P3POLB                  PSMC3POLbits.P3POLB             // bit 1
#define P3INPOL                 PSMC3POLbits.P3INPOL            // bit 6

#define PSMC3PR8                PSMC3PRHbits.PSMC3PR8           // bit 0
#define PSMC3PR9                PSMC3PRHbits.PSMC3PR9           // bit 1
#define PSMC3PR10               PSMC3PRHbits.PSMC3PR10          // bit 2
#define PSMC3PR11               PSMC3PRHbits.PSMC3PR11          // bit 3
#define PSMC3PR12               PSMC3PRHbits.PSMC3PR12          // bit 4
#define PSMC3PR13               PSMC3PRHbits.PSMC3PR13          // bit 5
#define PSMC3PR14               PSMC3PRHbits.PSMC3PR14          // bit 6
#define PSMC3PR15               PSMC3PRHbits.PSMC3PR15          // bit 7

#define PSMC3PR0                PSMC3PRLbits.PSMC3PR0           // bit 0
#define PSMC3PR1                PSMC3PRLbits.PSMC3PR1           // bit 1
#define PSMC3PR2                PSMC3PRLbits.PSMC3PR2           // bit 2
#define PSMC3PR3                PSMC3PRLbits.PSMC3PR3           // bit 3
#define PSMC3PR4                PSMC3PRLbits.PSMC3PR4           // bit 4
#define PSMC3PR5                PSMC3PRLbits.PSMC3PR5           // bit 5
#define PSMC3PR6                PSMC3PRLbits.PSMC3PR6           // bit 6
#define PSMC3PR7                PSMC3PRLbits.PSMC3PR7           // bit 7

#define P3PRST                  PSMC3PRSbits.P3PRST             // bit 0
#define P3PRSC1                 PSMC3PRSbits.P3PRSC1            // bit 1
#define P3PRSC2                 PSMC3PRSbits.P3PRSC2            // bit 2
#define P3PRSC3                 PSMC3PRSbits.P3PRSC3            // bit 3
#define P3PRSC4                 PSMC3PRSbits.P3PRSC4            // bit 4
#define P3PRSIN                 PSMC3PRSbits.P3PRSIN            // bit 7

#define P3REBSC1                PSMC3REBSbits.P3REBSC1          // bit 1
#define P3REBSC2                PSMC3REBSbits.P3REBSC2          // bit 2
#define P3REBSC3                PSMC3REBSbits.P3REBSC3          // bit 3
#define P3REBSC4                PSMC3REBSbits.P3REBSC4          // bit 4
#define P3REBSIN                PSMC3REBSbits.P3REBSIN          // bit 7

#define P3STRA                  PSMC3STR0bits.P3STRA            // bit 0
#define P3STRB                  PSMC3STR0bits.P3STRB            // bit 1

#define P3HSMEN                 PSMC3STR1bits.P3HSMEN           // bit 0
#define P3LSMEN                 PSMC3STR1bits.P3LSMEN           // bit 1
#define P3SSYNC                 PSMC3STR1bits.P3SSYNC           // bit 7

#define P3SYNC0                 PSMC3SYNCbits.P3SYNC0           // bit 0
#define P3SYNC1                 PSMC3SYNCbits.P3SYNC1           // bit 1
#define P3SYNC2                 PSMC3SYNCbits.P3SYNC2           // bit 2
#define P3DCPOL                 PSMC3SYNCbits.P3DCPOL           // bit 5
#define P3PRPOL                 PSMC3SYNCbits.P3PRPOL           // bit 6
#define P3POFST                 PSMC3SYNCbits.P3POFST           // bit 7

#define PSMC3TMR8               PSMC3TMRHbits.PSMC3TMR8         // bit 0
#define PSMC3TMR9               PSMC3TMRHbits.PSMC3TMR9         // bit 1
#define PSMC3TMR10              PSMC3TMRHbits.PSMC3TMR10        // bit 2
#define PSMC3TMR11              PSMC3TMRHbits.PSMC3TMR11        // bit 3
#define PSMC3TMR12              PSMC3TMRHbits.PSMC3TMR12        // bit 4
#define PSMC3TMR13              PSMC3TMRHbits.PSMC3TMR13        // bit 5
#define PSMC3TMR14              PSMC3TMRHbits.PSMC3TMR14        // bit 6
#define PSMC3TMR15              PSMC3TMRHbits.PSMC3TMR15        // bit 7

#define PSMC3TMR0               PSMC3TMRLbits.PSMC3TMR0         // bit 0
#define PSMC3TMR1               PSMC3TMRLbits.PSMC3TMR1         // bit 1
#define PSMC3TMR2               PSMC3TMRLbits.PSMC3TMR2         // bit 2
#define PSMC3TMR3               PSMC3TMRLbits.PSMC3TMR3         // bit 3
#define PSMC3TMR4               PSMC3TMRLbits.PSMC3TMR4         // bit 4
#define PSMC3TMR5               PSMC3TMRLbits.PSMC3TMR5         // bit 5
#define PSMC3TMR6               PSMC3TMRLbits.PSMC3TMR6         // bit 6
#define PSMC3TMR7               PSMC3TMRLbits.PSMC3TMR7         // bit 7

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define SLRCONA0                SLRCONAbits.SLRCONA0            // bit 0
#define SLRCONA1                SLRCONAbits.SLRCONA1            // bit 1
#define SLRCONA2                SLRCONAbits.SLRCONA2            // bit 2
#define SLRCONA3                SLRCONAbits.SLRCONA3            // bit 3
#define SLRCONA4                SLRCONAbits.SLRCONA4            // bit 4
#define SLRCONA5                SLRCONAbits.SLRCONA5            // bit 5
#define SLRCONA6                SLRCONAbits.SLRCONA6            // bit 6
#define SLRCONA7                SLRCONAbits.SLRCONA7            // bit 7

#define SLRCONB0                SLRCONBbits.SLRCONB0            // bit 0
#define SLRCONB1                SLRCONBbits.SLRCONB1            // bit 1
#define SLRCONB2                SLRCONBbits.SLRCONB2            // bit 2
#define SLRCONB3                SLRCONBbits.SLRCONB3            // bit 3
#define SLRCONB4                SLRCONBbits.SLRCONB4            // bit 4
#define SLRCONB5                SLRCONBbits.SLRCONB5            // bit 5
#define SLRCONB6                SLRCONBbits.SLRCONB6            // bit 6
#define SLRCONB7                SLRCONBbits.SLRCONB7            // bit 7

#define SLRCONC0                SLRCONCbits.SLRCONC0            // bit 0
#define SLRCONC1                SLRCONCbits.SLRCONC1            // bit 1
#define SLRCONC2                SLRCONCbits.SLRCONC2            // bit 2
#define SLRCONC3                SLRCONCbits.SLRCONC3            // bit 3
#define SLRCONC4                SLRCONCbits.SLRCONC4            // bit 4
#define SLRCONC5                SLRCONCbits.SLRCONC5            // bit 5
#define SLRCONC6                SLRCONCbits.SLRCONC6            // bit 6
#define SLRCONC7                SLRCONCbits.SLRCONC7            // bit 7

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO                   T1GCONbits.T1GGO                // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5
#define WPUA6                   WPUAbits.WPUA6                  // bit 6
#define WPUA7                   WPUAbits.WPUA7                  // bit 7

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#define WPUE3                   WPUEbits.WPUE3                  // bit 3

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1786_H__
