/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.Action;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.ActionSet;
import org.freehep.util.io.ByteCountInputStream;
import org.freehep.util.io.IncompleteActionException;
import org.freehep.util.io.IncompleteTagException;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TagSet;

public abstract class TaggedInputStream
extends ByteCountInputStream {
    protected TagSet tagSet;
    protected ActionSet actionSet;
    private TagHeader tagHeader;

    public TaggedInputStream(InputStream in, TagSet tagSet, ActionSet actionSet) {
        this(in, tagSet, actionSet, false);
    }

    public TaggedInputStream(InputStream in, TagSet tagSet, ActionSet actionSet, boolean littleEndian) {
        super(in, littleEndian, 8);
        this.tagSet = tagSet;
        this.actionSet = actionSet;
    }

    public void addTag(Tag tag) {
        this.tagSet.addTag(tag);
    }

    protected abstract TagHeader readTagHeader() throws IOException;

    public Tag readTag() throws IOException {
        this.tagHeader = this.readTagHeader();
        if (this.tagHeader == null) {
            return null;
        }
        int size = (int)this.tagHeader.getLength();
        Tag tag = this.tagSet.get(this.tagHeader.getTag());
        this.pushBuffer(size);
        tag = tag.read(this.tagHeader.getTag(), this, size);
        byte[] rest = this.popBuffer();
        if (rest != null) {
            throw new IncompleteTagException(tag, rest);
        }
        return tag;
    }

    public TagHeader getTagHeader() {
        return this.tagHeader;
    }

    public void addAction(Action action) {
        this.actionSet.addAction(action);
    }

    protected abstract ActionHeader readActionHeader() throws IOException;

    public Action readAction() throws IOException {
        ActionHeader header = this.readActionHeader();
        if (header == null) {
            return null;
        }
        int size = (int)header.getLength();
        Action action = this.actionSet.get(header.getAction());
        this.pushBuffer(size);
        action = action.read(header.getAction(), this, size);
        byte[] rest = this.popBuffer();
        if (rest != null) {
            throw new IncompleteActionException(action, rest);
        }
        return action;
    }
}

