/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.DoubleArrayReservation;
import org.apache.solr.analytics.stream.reservation.FloatArrayReservation;
import org.apache.solr.analytics.stream.reservation.IntArrayReservation;
import org.apache.solr.analytics.stream.reservation.LongArrayReservation;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.stream.reservation.StringArrayReservation;
import org.apache.solr.analytics.util.OrdinalCalculator;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;

public abstract class SortedListCollector<T extends Comparable<T>>
extends ReductionDataCollector<SortedListData<T>> {
    public static final String name = "sorted";
    private final String exprStr;
    private List<T> list;
    private boolean calcMedian;
    private Set<Double> calcPercs;
    private Set<Integer> calcOrds;
    ArrayList<T> tempList;
    Iterator<T> iter;

    protected SortedListCollector(AnalyticsValueStream param, String specificationName) {
        this.exprStr = AnalyticsValueStream.createExpressionString("sorted_" + specificationName, param);
        this.tempList = new ArrayList();
        this.calcMedian = false;
        this.calcPercs = new HashSet<Double>();
        this.calcOrds = new HashSet<Integer>();
    }

    public int size() {
        return this.list.size();
    }

    public void calcMedian() {
        this.calcMedian = true;
    }

    public void calcPercentile(double percentile) {
        this.calcPercs.add(percentile);
    }

    public void calcOrdinal(int ordinal) {
        this.calcOrds.add(ordinal);
    }

    public T get(int index) {
        return (T)((Comparable)this.list.get(index));
    }

    @Override
    public SortedListData<T> newData() {
        SortedListData data = new SortedListData();
        data.list = new ArrayList();
        data.exists = false;
        return data;
    }

    @Override
    protected void apply(SortedListData<T> data) {
        data.list.addAll(this.tempList);
    }

    protected void startImport(int size) {
        ((SortedListData)this.ioData).list.ensureCapacity(((SortedListData)this.ioData).list.size() + size);
    }

    protected void importNext(T value) {
        ((SortedListData)this.ioData).list.add(value);
    }

    public int startExport() {
        this.iter = ((SortedListData)this.ioData).list.iterator();
        return ((SortedListData)this.ioData).list.size();
    }

    public T exportNext() {
        return (T)((Comparable)this.iter.next());
    }

    @Override
    public void setMergedData(ReductionData data) {
        this.setData(data);
    }

    @Override
    public void setData(ReductionData data) {
        this.list = ((SortedListData)data).list;
        int size = this.list.size();
        if (size <= 1) {
            return;
        }
        HashSet<Integer> ordinals = new HashSet<Integer>();
        Iterator<Number> iterator = this.calcPercs.iterator();
        while (iterator.hasNext()) {
            double percentile = iterator.next();
            ordinals.add((int)Math.round(percentile * (double)size - 0.5));
        }
        iterator = this.calcOrds.iterator();
        while (iterator.hasNext()) {
            int ordinal = (Integer)iterator.next();
            if (ordinal > 0) {
                ordinals.add(ordinal - 1);
                continue;
            }
            if (ordinal >= 0) continue;
            ordinals.add(size + ordinal);
        }
        if (this.calcMedian) {
            int mid = this.list.size() / 2;
            ordinals.add(mid);
            if (this.list.size() % 2 == 0) {
                ordinals.add(mid - 1);
            }
        }
        OrdinalCalculator.putOrdinalsInPosition(this.list, ordinals);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    public static class SortedListData<D extends Comparable<D>>
    extends ReductionData {
        ArrayList<D> list;
    }

    public static class SortedStringListCollector
    extends SortedListCollector<String> {
        private StringValueStream param;

        public SortedStringListCollector(StringValueStream param) {
            super(param, "string");
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempList.clear();
            this.param.streamStrings(val -> this.tempList.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new StringArrayReservation(value -> this.importNext(value), importSize -> this.startImport(importSize), () -> (String)this.exportNext(), () -> this.startExport()));
        }
    }

    public static class SortedDoubleListCollector
    extends SortedListCollector<Double> {
        private DoubleValueStream param;

        public SortedDoubleListCollector(DoubleValueStream param) {
            super(param, "double");
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempList.clear();
            this.param.streamDoubles(val -> this.tempList.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new DoubleArrayReservation(value -> this.importNext(value), importSize -> this.startImport(importSize), () -> (Double)this.exportNext(), () -> this.startExport()));
        }
    }

    public static class SortedFloatListCollector
    extends SortedListCollector<Float> {
        private FloatValueStream param;

        public SortedFloatListCollector(FloatValueStream param) {
            super(param, "float");
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempList.clear();
            this.param.streamFloats(val -> this.tempList.add(Float.valueOf(val)));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new FloatArrayReservation(value -> this.importNext(Float.valueOf(value)), importSize -> this.startImport(importSize), () -> ((Float)this.exportNext()).floatValue(), () -> this.startExport()));
        }
    }

    public static class SortedLongListCollector
    extends SortedListCollector<Long> {
        private LongValueStream param;

        public SortedLongListCollector(LongValueStream param) {
            super(param, "long");
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempList.clear();
            this.param.streamLongs(val -> this.tempList.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new LongArrayReservation(value -> this.importNext(value), importSize -> this.startImport(importSize), () -> (Long)this.exportNext(), () -> this.startExport()));
        }
    }

    public static class SortedIntListCollector
    extends SortedListCollector<Integer> {
        private IntValueStream param;

        public SortedIntListCollector(IntValueStream param) {
            super(param, "int");
            this.param = param;
        }

        @Override
        public void collect() {
            this.tempList.clear();
            this.param.streamInts(val -> this.tempList.add(val));
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new IntArrayReservation(value -> this.importNext(value), importSize -> this.startImport(importSize), () -> (Integer)this.exportNext(), () -> this.startExport()));
        }
    }
}

