/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class DirectoryBlockCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 12;
    int[] tableIds;
    int[] bitmapAddress;
    char[] freeSpace;
    char[] freeSpaceBlock;

    public DirectoryBlockCachedObject(int n) {
        this.tableIds = new int[n];
        this.bitmapAddress = new int[n];
        this.freeSpace = new char[n];
        this.freeSpaceBlock = new char[n];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        int n;
        this.position = rowInputInterface.getFilePosition();
        int n2 = this.tableIds.length;
        for (n = 0; n < n2; ++n) {
            this.tableIds[n] = rowInputInterface.readInt();
        }
        for (n = 0; n < n2; ++n) {
            this.bitmapAddress[n] = rowInputInterface.readInt();
        }
        for (n = 0; n < n2; ++n) {
            this.freeSpace[n] = rowInputInterface.readChar();
        }
        for (n = 0; n < n2; ++n) {
            this.freeSpaceBlock[n] = rowInputInterface.readChar();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.tableIds.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.tableIds.length * 12;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n;
        int n2 = this.tableIds.length;
        rowOutputInterface.setStorageSize(this.storageSize);
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(this.tableIds[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeInt(this.bitmapAddress[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeChar(this.freeSpace[n]);
        }
        for (n = 0; n < n2; ++n) {
            rowOutputInterface.writeChar(this.freeSpaceBlock[n]);
        }
        rowOutputInterface.writeEnd();
    }

    public int[] getTableIdArray() {
        return this.tableIds;
    }

    public int[] getBitmapAddressArray() {
        return this.bitmapAddress;
    }

    public char[] getFreeSpaceArray() {
        return this.freeSpace;
    }

    public char[] getFreeBlockArray() {
        return this.freeSpaceBlock;
    }
}

