/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexChanger;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class IndexSetChanger {
    IndexRowGenerator[] irgs;
    long[] indexCIDS;
    private DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private StaticCompiledOpenConglomInfo[] indexSCOCIs;
    String[] indexNames;
    ConglomerateController baseCC;
    FormatableBitSet baseRowReadMap;
    TransactionController tc;
    TemporaryRowHolderImpl rowHolder;
    IndexChanger[] indexChangers;
    private int lockMode;
    boolean[] fixOnUpdate;
    boolean isOpen = false;
    private static final int NO_INDEXES = 0;
    private static final int UPDATE_INDEXES = 1;
    private static final int ALL_INDEXES = 2;
    private int whatIsOpen = 0;
    private int isolationLevel;
    private final Activation activation;

    public IndexSetChanger(IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, DynamicCompiledOpenConglomInfo[] dynamicCompiledOpenConglomInfoArray, String[] stringArray, ConglomerateController conglomerateController, TransactionController transactionController, int n, FormatableBitSet formatableBitSet, int n2, Activation activation) throws StandardException {
        this.irgs = indexRowGeneratorArray;
        this.indexCIDS = lArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.indexDCOCIs = dynamicCompiledOpenConglomInfoArray;
        this.indexNames = stringArray;
        this.baseCC = conglomerateController;
        this.tc = transactionController;
        this.lockMode = n;
        this.baseRowReadMap = formatableBitSet;
        this.isolationLevel = n2;
        this.activation = activation;
        this.indexChangers = new IndexChanger[indexRowGeneratorArray.length];
    }

    public void open(boolean[] blArray) throws StandardException {
        this.fixOnUpdate = blArray;
        this.isOpen = true;
    }

    public void setRowHolder(TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.rowHolder = temporaryRowHolderImpl;
    }

    private void openIndexes(int n) throws StandardException {
        if (this.whatIsOpen >= n) {
            return;
        }
        for (int i = 0; i < this.indexChangers.length; ++i) {
            if (n == 1 && !this.fixOnUpdate[i]) continue;
            if (this.indexChangers[i] == null) {
                this.indexChangers[i] = new IndexChanger(this.irgs[i], this.indexCIDS[i], this.indexSCOCIs == null ? (StaticCompiledOpenConglomInfo)null : this.indexSCOCIs[i], this.indexDCOCIs == null ? (DynamicCompiledOpenConglomInfo)null : this.indexDCOCIs[i], this.indexNames == null ? null : this.indexNames[i], this.baseCC, this.tc, this.lockMode, this.baseRowReadMap, this.isolationLevel, this.activation);
                this.indexChangers[i].setRowHolder(this.rowHolder);
            } else {
                this.indexChangers[i].setBaseCC(this.baseCC);
            }
            this.indexChangers[i].open();
        }
        this.whatIsOpen = n;
    }

    public void delete(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.openIndexes(2);
        for (int i = 0; i < this.indexChangers.length; ++i) {
            this.indexChangers[i].delete(execRow, rowLocation);
        }
    }

    public void insert(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.openIndexes(2);
        for (int i = 0; i < this.indexChangers.length; ++i) {
            this.indexChangers[i].insert(execRow, rowLocation);
        }
    }

    public void update(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        this.openIndexes(1);
        for (int i = 0; i < this.indexChangers.length; ++i) {
            if (!this.fixOnUpdate[i]) continue;
            this.indexChangers[i].update(execRow, execRow2, rowLocation);
        }
    }

    public void setBaseCC(ConglomerateController conglomerateController) {
        for (int i = 0; i < this.indexChangers.length; ++i) {
            if (this.indexChangers[i] == null) continue;
            this.indexChangers[i].setBaseCC(conglomerateController);
        }
        this.baseCC = conglomerateController;
    }

    public void finish() throws StandardException {
        for (int i = 0; i < this.indexChangers.length; ++i) {
            if (this.indexChangers[i] == null) continue;
            this.indexChangers[i].finish();
        }
    }

    public void close() throws StandardException {
        this.whatIsOpen = 0;
        for (int i = 0; i < this.indexChangers.length; ++i) {
            if (this.indexChangers[i] == null) continue;
            this.indexChangers[i].close();
        }
        this.fixOnUpdate = null;
        this.isOpen = false;
        this.rowHolder = null;
    }

    public String toString() {
        return null;
    }
}

