/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.classification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.classification.ClassificationResult;
import org.apache.lucene.classification.Classifier;
import org.apache.lucene.classification.utils.NearestFuzzyQuery;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;

public class KNearestFuzzyClassifier
implements Classifier<BytesRef> {
    private final String[] textFieldNames;
    private final String classFieldName;
    private final IndexSearcher indexSearcher;
    private final int k;
    private final Query query;
    private final Analyzer analyzer;

    public KNearestFuzzyClassifier(IndexReader indexReader, Similarity similarity, Analyzer analyzer, Query query, int k, String classFieldName, String ... textFieldNames) {
        this.textFieldNames = textFieldNames;
        this.classFieldName = classFieldName;
        this.analyzer = analyzer;
        this.indexSearcher = new IndexSearcher(indexReader);
        if (similarity != null) {
            this.indexSearcher.setSimilarity(similarity);
        } else {
            this.indexSearcher.setSimilarity((Similarity)new BM25Similarity());
        }
        this.query = query;
        this.k = k;
    }

    @Override
    public ClassificationResult<BytesRef> assignClass(String text) throws IOException {
        TopDocs knnResults = this.knnSearch(text);
        List<ClassificationResult<BytesRef>> assignedClasses = this.buildListFromTopDocs(knnResults);
        ClassificationResult<BytesRef> assignedClass = null;
        double maxscore = -1.7976931348623157E308;
        for (ClassificationResult<BytesRef> cl : assignedClasses) {
            if (!(cl.getScore() > maxscore)) continue;
            assignedClass = cl;
            maxscore = cl.getScore();
        }
        return assignedClass;
    }

    @Override
    public List<ClassificationResult<BytesRef>> getClasses(String text) throws IOException {
        TopDocs knnResults = this.knnSearch(text);
        List<ClassificationResult<BytesRef>> assignedClasses = this.buildListFromTopDocs(knnResults);
        Collections.sort(assignedClasses);
        return assignedClasses;
    }

    @Override
    public List<ClassificationResult<BytesRef>> getClasses(String text, int max) throws IOException {
        TopDocs knnResults = this.knnSearch(text);
        List<ClassificationResult<BytesRef>> assignedClasses = this.buildListFromTopDocs(knnResults);
        Collections.sort(assignedClasses);
        return assignedClasses.subList(0, max);
    }

    private TopDocs knnSearch(String text) throws IOException {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        NearestFuzzyQuery nearestFuzzyQuery = new NearestFuzzyQuery(this.analyzer);
        for (String fieldName : this.textFieldNames) {
            nearestFuzzyQuery.addTerms(text, fieldName);
        }
        bq.add((Query)nearestFuzzyQuery, BooleanClause.Occur.MUST);
        WildcardQuery classFieldQuery = new WildcardQuery(new Term(this.classFieldName, "*"));
        bq.add(new BooleanClause((Query)classFieldQuery, BooleanClause.Occur.MUST));
        if (this.query != null) {
            bq.add(this.query, BooleanClause.Occur.MUST);
        }
        return this.indexSearcher.search((Query)bq.build(), this.k);
    }

    private List<ClassificationResult<BytesRef>> buildListFromTopDocs(TopDocs topDocs) throws IOException {
        HashMap<BytesRef, Integer> classCounts = new HashMap<BytesRef, Integer>();
        HashMap<BytesRef, Double> classBoosts = new HashMap<BytesRef, Double>();
        float maxScore = topDocs.totalHits.value == 0L ? Float.NaN : topDocs.scoreDocs[0].score;
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            IndexableField indexableField = this.indexSearcher.doc(scoreDoc.doc).getField(this.classFieldName);
            if (indexableField == null) continue;
            BytesRef cl = new BytesRef((CharSequence)indexableField.stringValue());
            classCounts.merge(cl, 1, (a, b) -> a + b);
            Double totalBoost = (Double)classBoosts.get(cl);
            double singleBoost = scoreDoc.score / maxScore;
            if (totalBoost != null) {
                classBoosts.put(cl, totalBoost + singleBoost);
                continue;
            }
            classBoosts.put(cl, singleBoost);
        }
        ArrayList<ClassificationResult<BytesRef>> returnList = new ArrayList<ClassificationResult<BytesRef>>();
        ArrayList<ClassificationResult<BytesRef>> temporaryList = new ArrayList<ClassificationResult<BytesRef>>();
        int sumdoc = 0;
        for (Map.Entry entry : classCounts.entrySet()) {
            Integer count = (Integer)entry.getValue();
            Double normBoost = (Double)classBoosts.get(entry.getKey()) / (double)count.intValue();
            temporaryList.add(new ClassificationResult<BytesRef>(((BytesRef)entry.getKey()).clone(), (double)count.intValue() * normBoost / (double)this.k));
            sumdoc += count.intValue();
        }
        if (sumdoc < this.k) {
            for (ClassificationResult classificationResult : temporaryList) {
                returnList.add(new ClassificationResult<BytesRef>((BytesRef)classificationResult.getAssignedClass(), classificationResult.getScore() * (double)this.k / (double)sumdoc));
            }
        } else {
            returnList = temporaryList;
        }
        return returnList;
    }

    public String toString() {
        return "KNearestFuzzyClassifier{textFieldNames=" + Arrays.toString(this.textFieldNames) + ", classFieldName='" + this.classFieldName + '\'' + ", k=" + this.k + ", query=" + this.query + ", similarity=" + this.indexSearcher.getSimilarity() + '}';
    }
}

