/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class SingleValueSortDoc
extends SortDoc {
    protected SortValue value1;

    @Override
    public SortValue getSortValue(String field) {
        if (this.value1.getField().equals(field)) {
            return this.value1;
        }
        return null;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.ord = context.ord;
        this.docBase = context.docBase;
        this.value1.setNextReader(context);
    }

    @Override
    public void reset() {
        this.docId = -1;
        this.docBase = -1;
        this.ord = -1;
        this.value1.reset();
    }

    @Override
    public void setValues(int docId) throws IOException {
        this.docId = docId;
        this.value1.setCurrentValue(docId);
    }

    @Override
    public void setValues(SortDoc sortDoc) {
        this.docId = sortDoc.docId;
        this.ord = sortDoc.ord;
        this.docBase = sortDoc.docBase;
        this.value1.setCurrentValue(((SingleValueSortDoc)sortDoc).value1);
    }

    public SingleValueSortDoc(SortValue value1) {
        this.value1 = value1;
    }

    @Override
    public SortDoc copy() {
        return new SingleValueSortDoc(this.value1.copy());
    }

    @Override
    public boolean lessThan(Object o) {
        SingleValueSortDoc sd = (SingleValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        return this.docId + this.docBase > sd.docId + sd.docBase;
    }

    @Override
    public int compareTo(Object o) {
        SingleValueSortDoc sd = (SingleValueSortDoc)o;
        return this.value1.compareTo(sd.value1);
    }

    @Override
    public String toString() {
        return this.ord + ":" + this.docBase + ":" + this.docId + ":val=" + this.value1.toString();
    }
}

