/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.api;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.solr.common.MapWriter;

public interface SimpleMap<T>
extends MapWriter {
    public T get(String var1);

    default public T get(String key, T def) {
        T val = this.get(key);
        return val == null ? def : val;
    }

    public void forEachEntry(BiConsumer<String, ? super T> var1);

    default public void forEachKey(Consumer<String> fun) {
        this.forEachEntry((k, t) -> fun.accept((String)k));
    }

    public int size();

    default public void abortableForEachKey(Function<String, Boolean> fun) {
        this.abortableForEach((key, t) -> (Boolean)fun.apply((String)key));
    }

    default public void abortableForEach(final BiFunction<String, ? super T, Boolean> fun) {
        this.forEachEntry(new BiConsumer<String, T>(){
            boolean end = false;

            @Override
            public void accept(String k, T v) {
                if (this.end) {
                    return;
                }
                this.end = (Boolean)fun.apply(k, v);
            }
        });
    }

    @Override
    default public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.forEachEntry(ew::putNoEx);
    }
}

