// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9CN12.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,at91sam9cn12

// Atmel AT91SAM9CN12 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, Secure BootROM, Crypto engine, LCD, USB, LPDDR/DDR2/MLC NAND support, 217 Pins (refer to http://www.atmel.com/devices/SAM9CN12.aspx for more)
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "AT91SAM9CN12"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Debug Unit
	IRQ_DBGU = 1

	// Parallel Input/Output Controller A
	IRQ_PIOA = 2

	// Parallel Input/Output Controller C
	IRQ_PIOC = 3

	// Fuse Controller
	IRQ_FUSE = 4

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 5

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 6

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 7

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_USART3 = 8

	// Two-wire Interface 0
	IRQ_TWI0 = 9

	// Two-wire Interface 1
	IRQ_TWI1 = 10

	// High Speed MultiMedia Card Interface
	IRQ_HSMCI = 12

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 13

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 14

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 15

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 16

	// Timer Counter 0
	IRQ_TC0 = 17

	// Pulse Width Modulation Controller
	IRQ_PWM = 18

	// Analog-to-Digital Converter
	IRQ_ADC = 19

	// DMA Controller
	IRQ_DMAC = 20

	// USB Device Port
	IRQ_UDP = 23

	// LCD Controller
	IRQ_LCDC = 25

	// Secure Hash Algorithm
	IRQ_SHA = 27

	// Synchronous Serial Controller
	IRQ_SSC = 28

	// Advanced Encryption Standard
	IRQ_AES = 29

	// True Random Number Generator
	IRQ_TRNG = 30

	// Advanced Interrupt Controller
	IRQ_IRQ = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_FIQ, "FIQ_IRQHandler")
	_ = interrupt.Register(IRQ_DBGU, "DBGU_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOC, "PIOC_IRQHandler")
	_ = interrupt.Register(IRQ_FUSE, "FUSE_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_HSMCI, "HSMCI_IRQHandler")
	_ = interrupt.Register(IRQ_SPI0, "SPI0_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC, "DMAC_IRQHandler")
	_ = interrupt.Register(IRQ_UDP, "UDP_IRQHandler")
	_ = interrupt.Register(IRQ_LCDC, "LCDC_IRQHandler")
	_ = interrupt.Register(IRQ_SHA, "SHA_IRQHandler")
	_ = interrupt.Register(IRQ_SSC, "SSC_IRQHandler")
	_ = interrupt.Register(IRQ_AES, "AES_IRQHandler")
	_ = interrupt.Register(IRQ_TRNG, "TRNG_IRQHandler")
	_ = interrupt.Register(IRQ_IRQ, "IRQ_IRQHandler")
)

// Peripherals.
var (
	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0000000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xf0004000)))

	// High Speed MultiMedia Card Interface
	HSMCI = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xf0008000)))

	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0xf000c000)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0xf0010000)))

	// Secure Hash Algorithm
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0xf0014000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xf8008000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0xf800c000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8010000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0xf8014000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xf801c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8024000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0xf8028000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0xf8034000)))

	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0xf8038000)))

	// USB Device Port
	UDP = (*UDP_Type)(unsafe.Pointer(uintptr(0xf803c000)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8040000)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0xf8044000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0xf8048000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0xf804c000)))

	// Fuse Controller
	FUSE = (*FUSE_Type)(unsafe.Pointer(uintptr(0xffffdc00)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffde00)))

	// Programmable Multibit Error Corrected Code Controller
	PMECC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe000)))

	// Programmable Multibit ECC Error Location
	PMERRLOC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe600)))

	// DDR_SDR SDRAM Controller
	DDRSDRC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe800)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Parallel Input/Output Controller D
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe10)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe40)))

	// Slow Clock Controller
	SCKC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe50)))

	// Boot Sequence Controller
	BSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe54)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffe60)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0xfffffeb0)))
)

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// High Speed MultiMedia Card Interface
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [276]byte
	FIFO  [256]volatile.Register32 // 0x200
}

// Advanced Encryption Standard
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	_      [8]byte
	IER    volatile.Register32    // 0x10
	IDR    volatile.Register32    // 0x14
	IMR    volatile.Register32    // 0x18
	ISR    volatile.Register32    // 0x1C
	KEYWR  [8]volatile.Register32 // 0x20
	IDATAR [4]volatile.Register32 // 0x40
	ODATAR [4]volatile.Register32 // 0x50
	IVR    [4]volatile.Register32 // 0x60
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// Secure Hash Algorithm
type SHA_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	_      [8]byte
	IER    volatile.Register32 // 0x10
	IDR    volatile.Register32 // 0x14
	IMR    volatile.Register32 // 0x18
	ISR    volatile.Register32 // 0x1C
	_      [32]byte
	IDATAR [16]volatile.Register32 // 0x40
	ODATAR [8]volatile.Register32  // 0x80
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [4]byte
	RAB0 volatile.Register32 // 0xC
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [4]byte
	RAB1 volatile.Register32 // 0x4C
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [4]byte
	RAB2 volatile.Register32 // 0x8C
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR           volatile.Register32 // 0x0
	MMR          volatile.Register32 // 0x4
	SMR          volatile.Register32 // 0x8
	IADR         volatile.Register32 // 0xC
	CWGR         volatile.Register32 // 0x10
	_            [12]byte
	SR           volatile.Register32 // 0x20
	IER          volatile.Register32 // 0x24
	IDR          volatile.Register32 // 0x28
	IMR          volatile.Register32 // 0x2C
	RHR          volatile.Register32 // 0x30
	THR          volatile.Register32 // 0x34
	_            [172]byte
	WPROT_MODE   volatile.Register32 // 0xE4
	WPROT_STATUS volatile.Register32 // 0xE8
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	IER   volatile.Register32 // 0x8
	IDR   volatile.Register32 // 0xC
	IMR   volatile.Register32 // 0x10
	CSR   volatile.Register32 // 0x14
	RHR   volatile.Register32 // 0x18
	THR   volatile.Register32 // 0x1C
	BRGR  volatile.Register32 // 0x20
	RTOR  volatile.Register32 // 0x24
	TTGR  volatile.Register32 // 0x28
	_     [20]byte
	FIDI  volatile.Register32 // 0x40
	NER   volatile.Register32 // 0x44
	_     [4]byte
	IF    volatile.Register32 // 0x4C
	MAN   volatile.Register32 // 0x50
	LINMR volatile.Register32 // 0x54
	LINIR volatile.Register32 // 0x58
	_     [136]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// LCD Controller
type LCDC_Type struct {
	LCDCFG0  volatile.Register32 // 0x0
	LCDCFG1  volatile.Register32 // 0x4
	LCDCFG2  volatile.Register32 // 0x8
	LCDCFG3  volatile.Register32 // 0xC
	LCDCFG4  volatile.Register32 // 0x10
	LCDCFG5  volatile.Register32 // 0x14
	LCDCFG6  volatile.Register32 // 0x18
	_        [4]byte
	LCDEN    volatile.Register32 // 0x20
	LCDDIS   volatile.Register32 // 0x24
	LCDSR    volatile.Register32 // 0x28
	LCDIER   volatile.Register32 // 0x2C
	LCDIDR   volatile.Register32 // 0x30
	LCDIMR   volatile.Register32 // 0x34
	LCDISR   volatile.Register32 // 0x38
	_        [4]byte
	BASECHER volatile.Register32 // 0x40
	BASECHDR volatile.Register32 // 0x44
	BASECHSR volatile.Register32 // 0x48
	BASEIER  volatile.Register32 // 0x4C
	BASEIDR  volatile.Register32 // 0x50
	BASEIMR  volatile.Register32 // 0x54
	BASEISR  volatile.Register32 // 0x58
	BASEHEAD volatile.Register32 // 0x5C
	BASEADDR volatile.Register32 // 0x60
	BASECTRL volatile.Register32 // 0x64
	BASENEXT volatile.Register32 // 0x68
	BASECFG0 volatile.Register32 // 0x6C
	BASECFG1 volatile.Register32 // 0x70
	BASECFG2 volatile.Register32 // 0x74
	BASECFG3 volatile.Register32 // 0x78
	BASECFG4 volatile.Register32 // 0x7C
	_        [896]byte
	BASECLUT [256]volatile.Register32 // 0x400
	_        [6124]byte
	ADDRSIZE volatile.Register32    // 0x1FEC
	IPNAME   [2]volatile.Register32 // 0x1FF0
	FEATURES volatile.Register32    // 0x1FF8
	VERSION  volatile.Register32    // 0x1FFC
}

// USB Device Port
type UDP_Type struct {
	FRM_NUM  volatile.Register32 // 0x0
	GLB_STAT volatile.Register32 // 0x4
	FADDR    volatile.Register32 // 0x8
	_        [4]byte
	IER      volatile.Register32 // 0x10
	IDR      volatile.Register32 // 0x14
	IMR      volatile.Register32 // 0x18
	ISR      volatile.Register32 // 0x1C
	ICR      volatile.Register32 // 0x20
	_        [4]byte
	RST_EP   volatile.Register32 // 0x28
	_        [4]byte
	CSR      [6]volatile.Register32 // 0x30
	_        [8]byte
	FDR      [6]volatile.Register32 // 0x50
	_        [12]byte
	TXVC     volatile.Register32 // 0x74
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	SEQR1  volatile.Register32 // 0x8
	SEQR2  volatile.Register32 // 0xC
	CHER   volatile.Register32 // 0x10
	CHDR   volatile.Register32 // 0x14
	CHSR   volatile.Register32 // 0x18
	_      [4]byte
	LCDR   volatile.Register32 // 0x20
	IER    volatile.Register32 // 0x24
	IDR    volatile.Register32 // 0x28
	IMR    volatile.Register32 // 0x2C
	ISR    volatile.Register32 // 0x30
	_      [8]byte
	OVER   volatile.Register32 // 0x3C
	EMR    volatile.Register32 // 0x40
	CWR    volatile.Register32 // 0x44
	_      [8]byte
	CDR    [12]volatile.Register32 // 0x50
	_      [20]byte
	ACR    volatile.Register32 // 0x94
	_      [24]byte
	TSMR   volatile.Register32 // 0xB0
	XPOSR  volatile.Register32 // 0xB4
	YPOSR  volatile.Register32 // 0xB8
	PRESSR volatile.Register32 // 0xBC
	TRGR   volatile.Register32 // 0xC0
	_      [32]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// Fuse Controller
type FUSE_Type struct {
	CR volatile.Register32     // 0x0
	MR volatile.Register32     // 0x4
	IR volatile.Register32     // 0x8
	DR volatile.Register32     // 0xC
	SR [10]volatile.Register32 // 0x10
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [6]volatile.Register32 // 0x0
	_     [40]byte
	SCFG  [5]volatile.Register32 // 0x40
	_     [44]byte
	PRAS0 volatile.Register32 // 0x80
	_     [4]byte
	PRAS1 volatile.Register32 // 0x88
	_     [4]byte
	PRAS2 volatile.Register32 // 0x90
	_     [4]byte
	PRAS3 volatile.Register32 // 0x98
	_     [4]byte
	PRAS4 volatile.Register32 // 0xA0
	_     [92]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// Programmable Multibit Error Corrected Code Controller
type EBI_Type struct {
	CFG     volatile.Register32 // 0x0
	SAREA   volatile.Register32 // 0x4
	SADDR   volatile.Register32 // 0x8
	EADDR   volatile.Register32 // 0xC
	CLK     volatile.Register32 // 0x10
	CTRL    volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	IER     volatile.Register32 // 0x1C
	IDR     volatile.Register32 // 0x20
	IMR     volatile.Register32 // 0x24
	ISR     volatile.Register32 // 0x28
	_       [20]byte
	ECC0_0  volatile.Register32 // 0x40
	ECC1_0  volatile.Register32 // 0x44
	ECC2_0  volatile.Register32 // 0x48
	ECC3_0  volatile.Register32 // 0x4C
	ECC4_0  volatile.Register32 // 0x50
	ECC5_0  volatile.Register32 // 0x54
	ECC6_0  volatile.Register32 // 0x58
	ECC7_0  volatile.Register32 // 0x5C
	ECC8_0  volatile.Register32 // 0x60
	ECC9_0  volatile.Register32 // 0x64
	ECC10_0 volatile.Register32 // 0x68
	_       [20]byte
	ECC0_1  volatile.Register32 // 0x80
	ECC1_1  volatile.Register32 // 0x84
	ECC2_1  volatile.Register32 // 0x88
	ECC3_1  volatile.Register32 // 0x8C
	ECC4_1  volatile.Register32 // 0x90
	ECC5_1  volatile.Register32 // 0x94
	ECC6_1  volatile.Register32 // 0x98
	ECC7_1  volatile.Register32 // 0x9C
	ECC8_1  volatile.Register32 // 0xA0
	ECC9_1  volatile.Register32 // 0xA4
	ECC10_1 volatile.Register32 // 0xA8
	_       [20]byte
	ECC0_2  volatile.Register32 // 0xC0
	ECC1_2  volatile.Register32 // 0xC4
	ECC2_2  volatile.Register32 // 0xC8
	ECC3_2  volatile.Register32 // 0xCC
	ECC4_2  volatile.Register32 // 0xD0
	ECC5_2  volatile.Register32 // 0xD4
	ECC6_2  volatile.Register32 // 0xD8
	ECC7_2  volatile.Register32 // 0xDC
	ECC8_2  volatile.Register32 // 0xE0
	ECC9_2  volatile.Register32 // 0xE4
	ECC10_2 volatile.Register32 // 0xE8
	_       [20]byte
	ECC0_3  volatile.Register32 // 0x100
	ECC1_3  volatile.Register32 // 0x104
	ECC2_3  volatile.Register32 // 0x108
	ECC3_3  volatile.Register32 // 0x10C
	ECC4_3  volatile.Register32 // 0x110
	ECC5_3  volatile.Register32 // 0x114
	ECC6_3  volatile.Register32 // 0x118
	ECC7_3  volatile.Register32 // 0x11C
	ECC8_3  volatile.Register32 // 0x120
	ECC9_3  volatile.Register32 // 0x124
	ECC10_3 volatile.Register32 // 0x128
	_       [20]byte
	ECC0_4  volatile.Register32 // 0x140
	ECC1_4  volatile.Register32 // 0x144
	ECC2_4  volatile.Register32 // 0x148
	ECC3_4  volatile.Register32 // 0x14C
	ECC4_4  volatile.Register32 // 0x150
	ECC5_4  volatile.Register32 // 0x154
	ECC6_4  volatile.Register32 // 0x158
	ECC7_4  volatile.Register32 // 0x15C
	ECC8_4  volatile.Register32 // 0x160
	ECC9_4  volatile.Register32 // 0x164
	ECC10_4 volatile.Register32 // 0x168
	_       [20]byte
	ECC0_5  volatile.Register32 // 0x180
	ECC1_5  volatile.Register32 // 0x184
	ECC2_5  volatile.Register32 // 0x188
	ECC3_5  volatile.Register32 // 0x18C
	ECC4_5  volatile.Register32 // 0x190
	ECC5_5  volatile.Register32 // 0x194
	ECC6_5  volatile.Register32 // 0x198
	ECC7_5  volatile.Register32 // 0x19C
	ECC8_5  volatile.Register32 // 0x1A0
	ECC9_5  volatile.Register32 // 0x1A4
	ECC10_5 volatile.Register32 // 0x1A8
	_       [20]byte
	ECC0_6  volatile.Register32 // 0x1C0
	ECC1_6  volatile.Register32 // 0x1C4
	ECC2_6  volatile.Register32 // 0x1C8
	ECC3_6  volatile.Register32 // 0x1CC
	ECC4_6  volatile.Register32 // 0x1D0
	ECC5_6  volatile.Register32 // 0x1D4
	ECC6_6  volatile.Register32 // 0x1D8
	ECC7_6  volatile.Register32 // 0x1DC
	ECC8_6  volatile.Register32 // 0x1E0
	ECC9_6  volatile.Register32 // 0x1E4
	ECC10_6 volatile.Register32 // 0x1E8
	_       [20]byte
	ECC0_7  volatile.Register32 // 0x200
	ECC1_7  volatile.Register32 // 0x204
	ECC2_7  volatile.Register32 // 0x208
	ECC3_7  volatile.Register32 // 0x20C
	ECC4_7  volatile.Register32 // 0x210
	ECC5_7  volatile.Register32 // 0x214
	ECC6_7  volatile.Register32 // 0x218
	ECC7_7  volatile.Register32 // 0x21C
	ECC8_7  volatile.Register32 // 0x220
	ECC9_7  volatile.Register32 // 0x224
	ECC10_7 volatile.Register32 // 0x228
	_       [20]byte
	REM0_0  volatile.Register32 // 0x240
	REM1_0  volatile.Register32 // 0x244
	REM2_0  volatile.Register32 // 0x248
	REM3_0  volatile.Register32 // 0x24C
	REM4_0  volatile.Register32 // 0x250
	REM5_0  volatile.Register32 // 0x254
	REM6_0  volatile.Register32 // 0x258
	REM7_0  volatile.Register32 // 0x25C
	REM8_0  volatile.Register32 // 0x260
	REM9_0  volatile.Register32 // 0x264
	REM10_0 volatile.Register32 // 0x268
	REM11_0 volatile.Register32 // 0x26C
	_       [16]byte
	REM0_1  volatile.Register32 // 0x280
	REM1_1  volatile.Register32 // 0x284
	REM2_1  volatile.Register32 // 0x288
	REM3_1  volatile.Register32 // 0x28C
	REM4_1  volatile.Register32 // 0x290
	REM5_1  volatile.Register32 // 0x294
	REM6_1  volatile.Register32 // 0x298
	REM7_1  volatile.Register32 // 0x29C
	REM8_1  volatile.Register32 // 0x2A0
	REM9_1  volatile.Register32 // 0x2A4
	REM10_1 volatile.Register32 // 0x2A8
	REM11_1 volatile.Register32 // 0x2AC
	_       [16]byte
	REM0_2  volatile.Register32 // 0x2C0
	REM1_2  volatile.Register32 // 0x2C4
	REM2_2  volatile.Register32 // 0x2C8
	REM3_2  volatile.Register32 // 0x2CC
	REM4_2  volatile.Register32 // 0x2D0
	REM5_2  volatile.Register32 // 0x2D4
	REM6_2  volatile.Register32 // 0x2D8
	REM7_2  volatile.Register32 // 0x2DC
	REM8_2  volatile.Register32 // 0x2E0
	REM9_2  volatile.Register32 // 0x2E4
	REM10_2 volatile.Register32 // 0x2E8
	REM11_2 volatile.Register32 // 0x2EC
	_       [16]byte
	REM0_3  volatile.Register32 // 0x300
	REM1_3  volatile.Register32 // 0x304
	REM2_3  volatile.Register32 // 0x308
	REM3_3  volatile.Register32 // 0x30C
	REM4_3  volatile.Register32 // 0x310
	REM5_3  volatile.Register32 // 0x314
	REM6_3  volatile.Register32 // 0x318
	REM7_3  volatile.Register32 // 0x31C
	REM8_3  volatile.Register32 // 0x320
	REM9_3  volatile.Register32 // 0x324
	REM10_3 volatile.Register32 // 0x328
	REM11_3 volatile.Register32 // 0x32C
	_       [16]byte
	REM0_4  volatile.Register32 // 0x340
	REM1_4  volatile.Register32 // 0x344
	REM2_4  volatile.Register32 // 0x348
	REM3_4  volatile.Register32 // 0x34C
	REM4_4  volatile.Register32 // 0x350
	REM5_4  volatile.Register32 // 0x354
	REM6_4  volatile.Register32 // 0x358
	REM7_4  volatile.Register32 // 0x35C
	REM8_4  volatile.Register32 // 0x360
	REM9_4  volatile.Register32 // 0x364
	REM10_4 volatile.Register32 // 0x368
	REM11_4 volatile.Register32 // 0x36C
	_       [16]byte
	REM0_5  volatile.Register32 // 0x380
	REM1_5  volatile.Register32 // 0x384
	REM2_5  volatile.Register32 // 0x388
	REM3_5  volatile.Register32 // 0x38C
	REM4_5  volatile.Register32 // 0x390
	REM5_5  volatile.Register32 // 0x394
	REM6_5  volatile.Register32 // 0x398
	REM7_5  volatile.Register32 // 0x39C
	REM8_5  volatile.Register32 // 0x3A0
	REM9_5  volatile.Register32 // 0x3A4
	REM10_5 volatile.Register32 // 0x3A8
	REM11_5 volatile.Register32 // 0x3AC
	_       [16]byte
	REM0_6  volatile.Register32 // 0x3C0
	REM1_6  volatile.Register32 // 0x3C4
	REM2_6  volatile.Register32 // 0x3C8
	REM3_6  volatile.Register32 // 0x3CC
	REM4_6  volatile.Register32 // 0x3D0
	REM5_6  volatile.Register32 // 0x3D4
	REM6_6  volatile.Register32 // 0x3D8
	REM7_6  volatile.Register32 // 0x3DC
	REM8_6  volatile.Register32 // 0x3E0
	REM9_6  volatile.Register32 // 0x3E4
	REM10_6 volatile.Register32 // 0x3E8
	REM11_6 volatile.Register32 // 0x3EC
	_       [16]byte
	REM0_7  volatile.Register32 // 0x400
	REM1_7  volatile.Register32 // 0x404
	REM2_7  volatile.Register32 // 0x408
	REM3_7  volatile.Register32 // 0x40C
	REM4_7  volatile.Register32 // 0x410
	REM5_7  volatile.Register32 // 0x414
	REM6_7  volatile.Register32 // 0x418
	REM7_7  volatile.Register32 // 0x41C
	REM8_7  volatile.Register32 // 0x420
	REM9_7  volatile.Register32 // 0x424
	REM10_7 volatile.Register32 // 0x428
	REM11_7 volatile.Register32 // 0x42C
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	SPIP0  volatile.Register32 // 0x54
	DPIP0  volatile.Register32 // 0x58
	_      [8]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	SPIP1  volatile.Register32 // 0x7C
	DPIP1  volatile.Register32 // 0x80
	_      [8]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	SPIP2  volatile.Register32 // 0xA4
	DPIP2  volatile.Register32 // 0xA8
	_      [8]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	SPIP3  volatile.Register32 // 0xCC
	DPIP3  volatile.Register32 // 0xD0
	_      [8]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	SPIP4  volatile.Register32 // 0xF4
	DPIP4  volatile.Register32 // 0xF8
	_      [8]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	SPIP5  volatile.Register32 // 0x11C
	DPIP5  volatile.Register32 // 0x120
	_      [8]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	SPIP6  volatile.Register32 // 0x144
	DPIP6  volatile.Register32 // 0x148
	_      [8]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	SPIP7  volatile.Register32 // 0x16C
	DPIP7  volatile.Register32 // 0x170
	_      [112]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
	_     [152]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [12]byte
	DELAYR  volatile.Register32 // 0x110
	DRIVER1 volatile.Register32 // 0x114
	DRIVER2 volatile.Register32 // 0x118
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER    volatile.Register32 // 0x0
	PMC_SCDR    volatile.Register32 // 0x4
	PMC_SCSR    volatile.Register32 // 0x8
	_           [4]byte
	PMC_PCER    volatile.Register32 // 0x10
	PMC_PCDR    volatile.Register32 // 0x14
	PMC_PCSR    volatile.Register32 // 0x18
	_           [4]byte
	CKGR_MOR    volatile.Register32 // 0x20
	CKGR_MCFR   volatile.Register32 // 0x24
	CKGR_PLLAR  volatile.Register32 // 0x28
	CKGR_PLLBR  volatile.Register32 // 0x2C
	PMC_MCKR    volatile.Register32 // 0x30
	_           [4]byte
	PMC_USB     volatile.Register32 // 0x38
	_           [4]byte
	PMC_PCK     [2]volatile.Register32 // 0x40
	_           [24]byte
	PMC_IER     volatile.Register32 // 0x60
	PMC_IDR     volatile.Register32 // 0x64
	PMC_SR      volatile.Register32 // 0x68
	PMC_IMR     volatile.Register32 // 0x6C
	_           [16]byte
	PMC_PLLICPR volatile.Register32 // 0x80
	_           [96]byte
	PMC_WPMR    volatile.Register32 // 0xE4
	PMC_WPSR    volatile.Register32 // 0xE8
	_           [32]byte
	PMC_PCR     volatile.Register32 // 0x10C
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Real-time Clock
type RTC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	TIMR   volatile.Register32 // 0x8
	CALR   volatile.Register32 // 0xC
	TIMALR volatile.Register32 // 0x10
	CALALR volatile.Register32 // 0x14
	SR     volatile.Register32 // 0x18
	SCCR   volatile.Register32 // 0x1C
	IER    volatile.Register32 // 0x20
	IDR    volatile.Register32 // 0x24
	IMR    volatile.Register32 // 0x28
	VER    volatile.Register32 // 0x2C
}

// Bitfields for SPI0: Serial Peripheral Interface 0
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of SPIWPEN field.
	SPI_WPMR_SPIWPEN_Pos = 0x0
	// Bit mask of SPIWPEN field.
	SPI_WPMR_SPIWPEN_Msk = 0x1
	// Bit SPIWPEN.
	SPI_WPMR_SPIWPEN = 0x1
	// Position of SPIWPKEY field.
	SPI_WPMR_SPIWPKEY_Pos = 0x8
	// Bit mask of SPIWPKEY field.
	SPI_WPMR_SPIWPKEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of SPIWPVS field.
	SPI_WPSR_SPIWPVS_Pos = 0x0
	// Bit mask of SPIWPVS field.
	SPI_WPSR_SPIWPVS_Msk = 0x7
	// Position of SPIWPVSRC field.
	SPI_WPSR_SPIWPVSRC_Pos = 0x8
	// Bit mask of SPIWPVSRC field.
	SPI_WPSR_SPIWPVSRC_Msk = 0xff00
)

// Bitfields for HSMCI: High Speed MultiMedia Card Interface
const (
	// CR: Control Register
	// Position of MCIEN field.
	HSMCI_CR_MCIEN_Pos = 0x0
	// Bit mask of MCIEN field.
	HSMCI_CR_MCIEN_Msk = 0x1
	// Bit MCIEN.
	HSMCI_CR_MCIEN = 0x1
	// Position of MCIDIS field.
	HSMCI_CR_MCIDIS_Pos = 0x1
	// Bit mask of MCIDIS field.
	HSMCI_CR_MCIDIS_Msk = 0x2
	// Bit MCIDIS.
	HSMCI_CR_MCIDIS = 0x2
	// Position of PWSEN field.
	HSMCI_CR_PWSEN_Pos = 0x2
	// Bit mask of PWSEN field.
	HSMCI_CR_PWSEN_Msk = 0x4
	// Bit PWSEN.
	HSMCI_CR_PWSEN = 0x4
	// Position of PWSDIS field.
	HSMCI_CR_PWSDIS_Pos = 0x3
	// Bit mask of PWSDIS field.
	HSMCI_CR_PWSDIS_Msk = 0x8
	// Bit PWSDIS.
	HSMCI_CR_PWSDIS = 0x8
	// Position of SWRST field.
	HSMCI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	HSMCI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	HSMCI_CR_SWRST = 0x80

	// MR: Mode Register
	// Position of CLKDIV field.
	HSMCI_MR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	HSMCI_MR_CLKDIV_Msk = 0xff
	// Position of PWSDIV field.
	HSMCI_MR_PWSDIV_Pos = 0x8
	// Bit mask of PWSDIV field.
	HSMCI_MR_PWSDIV_Msk = 0x700
	// Position of RDPROOF field.
	HSMCI_MR_RDPROOF_Pos = 0xb
	// Bit mask of RDPROOF field.
	HSMCI_MR_RDPROOF_Msk = 0x800
	// Bit RDPROOF.
	HSMCI_MR_RDPROOF = 0x800
	// Position of WRPROOF field.
	HSMCI_MR_WRPROOF_Pos = 0xc
	// Bit mask of WRPROOF field.
	HSMCI_MR_WRPROOF_Msk = 0x1000
	// Bit WRPROOF.
	HSMCI_MR_WRPROOF = 0x1000
	// Position of FBYTE field.
	HSMCI_MR_FBYTE_Pos = 0xd
	// Bit mask of FBYTE field.
	HSMCI_MR_FBYTE_Msk = 0x2000
	// Bit FBYTE.
	HSMCI_MR_FBYTE = 0x2000
	// Position of PADV field.
	HSMCI_MR_PADV_Pos = 0xe
	// Bit mask of PADV field.
	HSMCI_MR_PADV_Msk = 0x4000
	// Bit PADV.
	HSMCI_MR_PADV = 0x4000
	// Position of CLKODD field.
	HSMCI_MR_CLKODD_Pos = 0x10
	// Bit mask of CLKODD field.
	HSMCI_MR_CLKODD_Msk = 0x10000
	// Bit CLKODD.
	HSMCI_MR_CLKODD = 0x10000

	// DTOR: Data Timeout Register
	// Position of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Pos = 0x0
	// Bit mask of DTOCYC field.
	HSMCI_DTOR_DTOCYC_Msk = 0xf
	// Position of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Pos = 0x4
	// Bit mask of DTOMUL field.
	HSMCI_DTOR_DTOMUL_Msk = 0x70
	// DTOCYC
	HSMCI_DTOR_DTOMUL_1 = 0x0
	// DTOCYC x 16
	HSMCI_DTOR_DTOMUL_16 = 0x1
	// DTOCYC x 128
	HSMCI_DTOR_DTOMUL_128 = 0x2
	// DTOCYC x 256
	HSMCI_DTOR_DTOMUL_256 = 0x3
	// DTOCYC x 1024
	HSMCI_DTOR_DTOMUL_1024 = 0x4
	// DTOCYC x 4096
	HSMCI_DTOR_DTOMUL_4096 = 0x5
	// DTOCYC x 65536
	HSMCI_DTOR_DTOMUL_65536 = 0x6
	// DTOCYC x 1048576
	HSMCI_DTOR_DTOMUL_1048576 = 0x7

	// SDCR: SD/SDIO Card Register
	// Position of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Pos = 0x0
	// Bit mask of SDCSEL field.
	HSMCI_SDCR_SDCSEL_Msk = 0x3
	// Slot A is selected.
	HSMCI_SDCR_SDCSEL_SLOTA = 0x0
	// -
	HSMCI_SDCR_SDCSEL_SLOTB = 0x1
	// -
	HSMCI_SDCR_SDCSEL_SLOTC = 0x2
	// -
	HSMCI_SDCR_SDCSEL_SLOTD = 0x3
	// Position of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Pos = 0x6
	// Bit mask of SDCBUS field.
	HSMCI_SDCR_SDCBUS_Msk = 0xc0
	// 1 bit
	HSMCI_SDCR_SDCBUS_1 = 0x0
	// 4 bit
	HSMCI_SDCR_SDCBUS_4 = 0x2
	// 8 bit
	HSMCI_SDCR_SDCBUS_8 = 0x3

	// ARGR: Argument Register
	// Position of ARG field.
	HSMCI_ARGR_ARG_Pos = 0x0
	// Bit mask of ARG field.
	HSMCI_ARGR_ARG_Msk = 0xffffffff

	// CMDR: Command Register
	// Position of CMDNB field.
	HSMCI_CMDR_CMDNB_Pos = 0x0
	// Bit mask of CMDNB field.
	HSMCI_CMDR_CMDNB_Msk = 0x3f
	// Position of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Pos = 0x6
	// Bit mask of RSPTYP field.
	HSMCI_CMDR_RSPTYP_Msk = 0xc0
	// No response.
	HSMCI_CMDR_RSPTYP_NORESP = 0x0
	// 48-bit response.
	HSMCI_CMDR_RSPTYP_48_BIT = 0x1
	// 136-bit response.
	HSMCI_CMDR_RSPTYP_136_BIT = 0x2
	// R1b response type
	HSMCI_CMDR_RSPTYP_R1B = 0x3
	// Position of SPCMD field.
	HSMCI_CMDR_SPCMD_Pos = 0x8
	// Bit mask of SPCMD field.
	HSMCI_CMDR_SPCMD_Msk = 0x700
	// Not a special CMD.
	HSMCI_CMDR_SPCMD_STD = 0x0
	// Initialization CMD: 74 clock cycles for initialization sequence.
	HSMCI_CMDR_SPCMD_INIT = 0x1
	// Synchronized CMD: Wait for the end of the current data block transfer before sending the pending command.
	HSMCI_CMDR_SPCMD_SYNC = 0x2
	// CE-ATA Completion Signal disable Command. The host cancels the ability for the device to return a command completion signal on the command line.
	HSMCI_CMDR_SPCMD_CE_ATA = 0x3
	// Interrupt command: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_CMD = 0x4
	// Interrupt response: Corresponds to the Interrupt Mode (CMD40).
	HSMCI_CMDR_SPCMD_IT_RESP = 0x5
	// Boot Operation Request. Start a boot operation mode, the host processor can read boot data from the MMC device directly.
	HSMCI_CMDR_SPCMD_BOR = 0x6
	// End Boot Operation. This command allows the host processor to terminate the boot operation mode.
	HSMCI_CMDR_SPCMD_EBO = 0x7
	// Position of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Pos = 0xb
	// Bit mask of OPDCMD field.
	HSMCI_CMDR_OPDCMD_Msk = 0x800
	// Bit OPDCMD.
	HSMCI_CMDR_OPDCMD = 0x800
	// Push pull command.
	HSMCI_CMDR_OPDCMD_PUSHPULL = 0x0
	// Open drain command.
	HSMCI_CMDR_OPDCMD_OPENDRAIN = 0x1
	// Position of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Pos = 0xc
	// Bit mask of MAXLAT field.
	HSMCI_CMDR_MAXLAT_Msk = 0x1000
	// Bit MAXLAT.
	HSMCI_CMDR_MAXLAT = 0x1000
	// 5-cycle max latency.
	HSMCI_CMDR_MAXLAT_5 = 0x0
	// 64-cycle max latency.
	HSMCI_CMDR_MAXLAT_64 = 0x1
	// Position of TRCMD field.
	HSMCI_CMDR_TRCMD_Pos = 0x10
	// Bit mask of TRCMD field.
	HSMCI_CMDR_TRCMD_Msk = 0x30000
	// No data transfer
	HSMCI_CMDR_TRCMD_NO_DATA = 0x0
	// Start data transfer
	HSMCI_CMDR_TRCMD_START_DATA = 0x1
	// Stop data transfer
	HSMCI_CMDR_TRCMD_STOP_DATA = 0x2
	// Position of TRDIR field.
	HSMCI_CMDR_TRDIR_Pos = 0x12
	// Bit mask of TRDIR field.
	HSMCI_CMDR_TRDIR_Msk = 0x40000
	// Bit TRDIR.
	HSMCI_CMDR_TRDIR = 0x40000
	// Write.
	HSMCI_CMDR_TRDIR_WRITE = 0x0
	// Read.
	HSMCI_CMDR_TRDIR_READ = 0x1
	// Position of TRTYP field.
	HSMCI_CMDR_TRTYP_Pos = 0x13
	// Bit mask of TRTYP field.
	HSMCI_CMDR_TRTYP_Msk = 0x380000
	// MMC/SD Card Single Block
	HSMCI_CMDR_TRTYP_SINGLE = 0x0
	// MMC/SD Card Multiple Block
	HSMCI_CMDR_TRTYP_MULTIPLE = 0x1
	// MMC Stream
	HSMCI_CMDR_TRTYP_STREAM = 0x2
	// SDIO Byte
	HSMCI_CMDR_TRTYP_BYTE = 0x4
	// SDIO Block
	HSMCI_CMDR_TRTYP_BLOCK = 0x5
	// Position of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Pos = 0x18
	// Bit mask of IOSPCMD field.
	HSMCI_CMDR_IOSPCMD_Msk = 0x3000000
	// Not an SDIO Special Command
	HSMCI_CMDR_IOSPCMD_STD = 0x0
	// SDIO Suspend Command
	HSMCI_CMDR_IOSPCMD_SUSPEND = 0x1
	// SDIO Resume Command
	HSMCI_CMDR_IOSPCMD_RESUME = 0x2
	// Position of ATACS field.
	HSMCI_CMDR_ATACS_Pos = 0x1a
	// Bit mask of ATACS field.
	HSMCI_CMDR_ATACS_Msk = 0x4000000
	// Bit ATACS.
	HSMCI_CMDR_ATACS = 0x4000000
	// Normal operation mode.
	HSMCI_CMDR_ATACS_NORMAL = 0x0
	// This bit indicates that a completion signal is expected within a programmed amount of time (HSMCI_CSTOR).
	HSMCI_CMDR_ATACS_COMPLETION = 0x1
	// Position of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Pos = 0x1b
	// Bit mask of BOOT_ACK field.
	HSMCI_CMDR_BOOT_ACK_Msk = 0x8000000
	// Bit BOOT_ACK.
	HSMCI_CMDR_BOOT_ACK = 0x8000000

	// BLKR: Block Register
	// Position of BCNT field.
	HSMCI_BLKR_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	HSMCI_BLKR_BCNT_Msk = 0xffff
	// Position of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Pos = 0x10
	// Bit mask of BLKLEN field.
	HSMCI_BLKR_BLKLEN_Msk = 0xffff0000

	// CSTOR: Completion Signal Timeout Register
	// Position of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Pos = 0x0
	// Bit mask of CSTOCYC field.
	HSMCI_CSTOR_CSTOCYC_Msk = 0xf
	// Position of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Pos = 0x4
	// Bit mask of CSTOMUL field.
	HSMCI_CSTOR_CSTOMUL_Msk = 0x70
	// CSTOCYC x 1
	HSMCI_CSTOR_CSTOMUL_1 = 0x0
	// CSTOCYC x 16
	HSMCI_CSTOR_CSTOMUL_16 = 0x1
	// CSTOCYC x 128
	HSMCI_CSTOR_CSTOMUL_128 = 0x2
	// CSTOCYC x 256
	HSMCI_CSTOR_CSTOMUL_256 = 0x3
	// CSTOCYC x 1024
	HSMCI_CSTOR_CSTOMUL_1024 = 0x4
	// CSTOCYC x 4096
	HSMCI_CSTOR_CSTOMUL_4096 = 0x5
	// CSTOCYC x 65536
	HSMCI_CSTOR_CSTOMUL_65536 = 0x6
	// CSTOCYC x 1048576
	HSMCI_CSTOR_CSTOMUL_1048576 = 0x7

	// RSPR: Response Register
	// Position of RSP field.
	HSMCI_RSPR_RSP_Pos = 0x0
	// Bit mask of RSP field.
	HSMCI_RSPR_RSP_Msk = 0xffffffff

	// RDR: Receive Data Register
	// Position of DATA field.
	HSMCI_RDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_RDR_DATA_Msk = 0xffffffff

	// TDR: Transmit Data Register
	// Position of DATA field.
	HSMCI_TDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_TDR_DATA_Msk = 0xffffffff

	// SR: Status Register
	// Position of CMDRDY field.
	HSMCI_SR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_SR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_SR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_SR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_SR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_SR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_SR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_SR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_SR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_SR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_SR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_SR_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_SR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_SR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_SR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_SR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_SR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_SR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_SR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_SR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_SR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_SR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_SR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_SR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_SR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_SR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_SR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_SR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_SR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_SR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_SR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_SR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_SR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_SR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_SR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_SR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_SR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_SR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_SR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_SR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_SR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_SR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_SR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_SR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_SR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_SR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_SR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_SR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_SR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_SR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_SR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_SR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_SR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_SR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_SR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_SR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_SR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_SR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_SR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_SR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_SR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_SR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_SR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_SR_UNRE = 0x80000000

	// IER: Interrupt Enable Register
	// Position of CMDRDY field.
	HSMCI_IER_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IER_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IER_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IER_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IER_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IER_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IER_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IER_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IER_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IER_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IER_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IER_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IER_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IER_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IER_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IER_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IER_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IER_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IER_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IER_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IER_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IER_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IER_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IER_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IER_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IER_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IER_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IER_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IER_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IER_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IER_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IER_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IER_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IER_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IER_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IER_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IER_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IER_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IER_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IER_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IER_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IER_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IER_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IER_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IER_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IER_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IER_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IER_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IER_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IER_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IER_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IER_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IER_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IER_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IER_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IER_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IER_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IER_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IER_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IER_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IER_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IER_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IER_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IER_UNRE = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of CMDRDY field.
	HSMCI_IDR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IDR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IDR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IDR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IDR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IDR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IDR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IDR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IDR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IDR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IDR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IDR_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IDR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IDR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IDR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IDR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IDR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IDR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IDR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IDR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IDR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IDR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IDR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IDR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IDR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IDR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IDR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IDR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IDR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IDR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IDR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IDR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IDR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IDR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IDR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IDR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IDR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IDR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IDR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IDR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IDR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IDR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IDR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IDR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IDR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IDR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IDR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IDR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IDR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IDR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IDR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IDR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IDR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IDR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IDR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IDR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IDR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IDR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IDR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IDR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IDR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IDR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IDR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IDR_UNRE = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of CMDRDY field.
	HSMCI_IMR_CMDRDY_Pos = 0x0
	// Bit mask of CMDRDY field.
	HSMCI_IMR_CMDRDY_Msk = 0x1
	// Bit CMDRDY.
	HSMCI_IMR_CMDRDY = 0x1
	// Position of RXRDY field.
	HSMCI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	HSMCI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	HSMCI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	HSMCI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	HSMCI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	HSMCI_IMR_TXRDY = 0x4
	// Position of BLKE field.
	HSMCI_IMR_BLKE_Pos = 0x3
	// Bit mask of BLKE field.
	HSMCI_IMR_BLKE_Msk = 0x8
	// Bit BLKE.
	HSMCI_IMR_BLKE = 0x8
	// Position of DTIP field.
	HSMCI_IMR_DTIP_Pos = 0x4
	// Bit mask of DTIP field.
	HSMCI_IMR_DTIP_Msk = 0x10
	// Bit DTIP.
	HSMCI_IMR_DTIP = 0x10
	// Position of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Pos = 0x5
	// Bit mask of NOTBUSY field.
	HSMCI_IMR_NOTBUSY_Msk = 0x20
	// Bit NOTBUSY.
	HSMCI_IMR_NOTBUSY = 0x20
	// Position of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Pos = 0x8
	// Bit mask of SDIOIRQA field.
	HSMCI_IMR_SDIOIRQA_Msk = 0x100
	// Bit SDIOIRQA.
	HSMCI_IMR_SDIOIRQA = 0x100
	// Position of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Pos = 0xc
	// Bit mask of SDIOWAIT field.
	HSMCI_IMR_SDIOWAIT_Msk = 0x1000
	// Bit SDIOWAIT.
	HSMCI_IMR_SDIOWAIT = 0x1000
	// Position of CSRCV field.
	HSMCI_IMR_CSRCV_Pos = 0xd
	// Bit mask of CSRCV field.
	HSMCI_IMR_CSRCV_Msk = 0x2000
	// Bit CSRCV.
	HSMCI_IMR_CSRCV = 0x2000
	// Position of RINDE field.
	HSMCI_IMR_RINDE_Pos = 0x10
	// Bit mask of RINDE field.
	HSMCI_IMR_RINDE_Msk = 0x10000
	// Bit RINDE.
	HSMCI_IMR_RINDE = 0x10000
	// Position of RDIRE field.
	HSMCI_IMR_RDIRE_Pos = 0x11
	// Bit mask of RDIRE field.
	HSMCI_IMR_RDIRE_Msk = 0x20000
	// Bit RDIRE.
	HSMCI_IMR_RDIRE = 0x20000
	// Position of RCRCE field.
	HSMCI_IMR_RCRCE_Pos = 0x12
	// Bit mask of RCRCE field.
	HSMCI_IMR_RCRCE_Msk = 0x40000
	// Bit RCRCE.
	HSMCI_IMR_RCRCE = 0x40000
	// Position of RENDE field.
	HSMCI_IMR_RENDE_Pos = 0x13
	// Bit mask of RENDE field.
	HSMCI_IMR_RENDE_Msk = 0x80000
	// Bit RENDE.
	HSMCI_IMR_RENDE = 0x80000
	// Position of RTOE field.
	HSMCI_IMR_RTOE_Pos = 0x14
	// Bit mask of RTOE field.
	HSMCI_IMR_RTOE_Msk = 0x100000
	// Bit RTOE.
	HSMCI_IMR_RTOE = 0x100000
	// Position of DCRCE field.
	HSMCI_IMR_DCRCE_Pos = 0x15
	// Bit mask of DCRCE field.
	HSMCI_IMR_DCRCE_Msk = 0x200000
	// Bit DCRCE.
	HSMCI_IMR_DCRCE = 0x200000
	// Position of DTOE field.
	HSMCI_IMR_DTOE_Pos = 0x16
	// Bit mask of DTOE field.
	HSMCI_IMR_DTOE_Msk = 0x400000
	// Bit DTOE.
	HSMCI_IMR_DTOE = 0x400000
	// Position of CSTOE field.
	HSMCI_IMR_CSTOE_Pos = 0x17
	// Bit mask of CSTOE field.
	HSMCI_IMR_CSTOE_Msk = 0x800000
	// Bit CSTOE.
	HSMCI_IMR_CSTOE = 0x800000
	// Position of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Pos = 0x18
	// Bit mask of BLKOVRE field.
	HSMCI_IMR_BLKOVRE_Msk = 0x1000000
	// Bit BLKOVRE.
	HSMCI_IMR_BLKOVRE = 0x1000000
	// Position of DMADONE field.
	HSMCI_IMR_DMADONE_Pos = 0x19
	// Bit mask of DMADONE field.
	HSMCI_IMR_DMADONE_Msk = 0x2000000
	// Bit DMADONE.
	HSMCI_IMR_DMADONE = 0x2000000
	// Position of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Pos = 0x1a
	// Bit mask of FIFOEMPTY field.
	HSMCI_IMR_FIFOEMPTY_Msk = 0x4000000
	// Bit FIFOEMPTY.
	HSMCI_IMR_FIFOEMPTY = 0x4000000
	// Position of XFRDONE field.
	HSMCI_IMR_XFRDONE_Pos = 0x1b
	// Bit mask of XFRDONE field.
	HSMCI_IMR_XFRDONE_Msk = 0x8000000
	// Bit XFRDONE.
	HSMCI_IMR_XFRDONE = 0x8000000
	// Position of ACKRCV field.
	HSMCI_IMR_ACKRCV_Pos = 0x1c
	// Bit mask of ACKRCV field.
	HSMCI_IMR_ACKRCV_Msk = 0x10000000
	// Bit ACKRCV.
	HSMCI_IMR_ACKRCV = 0x10000000
	// Position of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Pos = 0x1d
	// Bit mask of ACKRCVE field.
	HSMCI_IMR_ACKRCVE_Msk = 0x20000000
	// Bit ACKRCVE.
	HSMCI_IMR_ACKRCVE = 0x20000000
	// Position of OVRE field.
	HSMCI_IMR_OVRE_Pos = 0x1e
	// Bit mask of OVRE field.
	HSMCI_IMR_OVRE_Msk = 0x40000000
	// Bit OVRE.
	HSMCI_IMR_OVRE = 0x40000000
	// Position of UNRE field.
	HSMCI_IMR_UNRE_Pos = 0x1f
	// Bit mask of UNRE field.
	HSMCI_IMR_UNRE_Msk = 0x80000000
	// Bit UNRE.
	HSMCI_IMR_UNRE = 0x80000000

	// DMA: DMA Configuration Register
	// Position of OFFSET field.
	HSMCI_DMA_OFFSET_Pos = 0x0
	// Bit mask of OFFSET field.
	HSMCI_DMA_OFFSET_Msk = 0x3
	// Position of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Pos = 0x4
	// Bit mask of CHKSIZE field.
	HSMCI_DMA_CHKSIZE_Msk = 0x70
	// Position of DMAEN field.
	HSMCI_DMA_DMAEN_Pos = 0x8
	// Bit mask of DMAEN field.
	HSMCI_DMA_DMAEN_Msk = 0x100
	// Bit DMAEN.
	HSMCI_DMA_DMAEN = 0x100
	// Position of ROPT field.
	HSMCI_DMA_ROPT_Pos = 0xc
	// Bit mask of ROPT field.
	HSMCI_DMA_ROPT_Msk = 0x1000
	// Bit ROPT.
	HSMCI_DMA_ROPT = 0x1000

	// CFG: Configuration Register
	// Position of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Pos = 0x0
	// Bit mask of FIFOMODE field.
	HSMCI_CFG_FIFOMODE_Msk = 0x1
	// Bit FIFOMODE.
	HSMCI_CFG_FIFOMODE = 0x1
	// Position of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Pos = 0x4
	// Bit mask of FERRCTRL field.
	HSMCI_CFG_FERRCTRL_Msk = 0x10
	// Bit FERRCTRL.
	HSMCI_CFG_FERRCTRL = 0x10
	// Position of HSMODE field.
	HSMCI_CFG_HSMODE_Pos = 0x8
	// Bit mask of HSMODE field.
	HSMCI_CFG_HSMODE_Msk = 0x100
	// Bit HSMODE.
	HSMCI_CFG_HSMODE = 0x100
	// Position of LSYNC field.
	HSMCI_CFG_LSYNC_Pos = 0xc
	// Bit mask of LSYNC field.
	HSMCI_CFG_LSYNC_Msk = 0x1000
	// Bit LSYNC.
	HSMCI_CFG_LSYNC = 0x1000

	// WPMR: Write Protection Mode Register
	// Position of WP_EN field.
	HSMCI_WPMR_WP_EN_Pos = 0x0
	// Bit mask of WP_EN field.
	HSMCI_WPMR_WP_EN_Msk = 0x1
	// Bit WP_EN.
	HSMCI_WPMR_WP_EN = 0x1
	// Position of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Pos = 0x8
	// Bit mask of WP_KEY field.
	HSMCI_WPMR_WP_KEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WP_VS field.
	HSMCI_WPSR_WP_VS_Pos = 0x0
	// Bit mask of WP_VS field.
	HSMCI_WPSR_WP_VS_Msk = 0xf
	// No Write Protection Violation occurred since the last read of this register (WP_SR)
	HSMCI_WPSR_WP_VS_NONE = 0x0
	// Write Protection detected unauthorized attempt to write a control register had occurred (since the last read.)
	HSMCI_WPSR_WP_VS_WRITE = 0x1
	// Software reset had been performed while Write Protection was enabled (since the last read).
	HSMCI_WPSR_WP_VS_RESET = 0x2
	// Both Write Protection violation and software reset with Write Protection enabled have occurred since the last read.
	HSMCI_WPSR_WP_VS_BOTH = 0x3
	// Position of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Pos = 0x8
	// Bit mask of WP_VSRC field.
	HSMCI_WPSR_WP_VSRC_Msk = 0xffff00

	// FIFO: FIFO Memory Aperture0
	// Position of DATA field.
	HSMCI_FIFO_DATA_Pos = 0x0
	// Bit mask of DATA field.
	HSMCI_FIFO_DATA_Msk = 0xffffffff
)

// Bitfields for AES: Advanced Encryption Standard
const (
	// CR: Control Register
	// Position of START field.
	AES_CR_START_Pos = 0x0
	// Bit mask of START field.
	AES_CR_START_Msk = 0x1
	// Bit START.
	AES_CR_START = 0x1
	// Position of SWRST field.
	AES_CR_SWRST_Pos = 0x8
	// Bit mask of SWRST field.
	AES_CR_SWRST_Msk = 0x100
	// Bit SWRST.
	AES_CR_SWRST = 0x100

	// MR: Mode Register
	// Position of CIPHER field.
	AES_MR_CIPHER_Pos = 0x0
	// Bit mask of CIPHER field.
	AES_MR_CIPHER_Msk = 0x1
	// Bit CIPHER.
	AES_MR_CIPHER = 0x1
	// Position of DUALBUFF field.
	AES_MR_DUALBUFF_Pos = 0x3
	// Bit mask of DUALBUFF field.
	AES_MR_DUALBUFF_Msk = 0x8
	// Bit DUALBUFF.
	AES_MR_DUALBUFF = 0x8
	// AES_IDATARx cannot be written during processing of previous block.
	AES_MR_DUALBUFF_INACTIVE = 0x0
	// AES_IDATARx can be written during processing of previous block when SMOD = 0x2. It speeds up the overall runtime of large files.
	AES_MR_DUALBUFF_ACTIVE = 0x1
	// Position of PROCDLY field.
	AES_MR_PROCDLY_Pos = 0x4
	// Bit mask of PROCDLY field.
	AES_MR_PROCDLY_Msk = 0xf0
	// Position of SMOD field.
	AES_MR_SMOD_Pos = 0x8
	// Bit mask of SMOD field.
	AES_MR_SMOD_Msk = 0x300
	// Manual Mode
	AES_MR_SMOD_MANUAL_START = 0x0
	// Auto Mode
	AES_MR_SMOD_AUTO_START = 0x1
	// AES_IDATAR0 access only Auto Mode
	AES_MR_SMOD_IDATAR0_START = 0x2
	// Position of KEYSIZE field.
	AES_MR_KEYSIZE_Pos = 0xa
	// Bit mask of KEYSIZE field.
	AES_MR_KEYSIZE_Msk = 0xc00
	// AES Key Size is 128 bits
	AES_MR_KEYSIZE_AES128 = 0x0
	// AES Key Size is 192 bits
	AES_MR_KEYSIZE_AES192 = 0x1
	// AES Key Size is 256 bits
	AES_MR_KEYSIZE_AES256 = 0x2
	// Position of OPMOD field.
	AES_MR_OPMOD_Pos = 0xc
	// Bit mask of OPMOD field.
	AES_MR_OPMOD_Msk = 0x7000
	// ECB: Electronic Code Book mode
	AES_MR_OPMOD_ECB = 0x0
	// CBC: Cipher Block Chaining mode
	AES_MR_OPMOD_CBC = 0x1
	// OFB: Output Feedback mode
	AES_MR_OPMOD_OFB = 0x2
	// CFB: Cipher Feedback mode
	AES_MR_OPMOD_CFB = 0x3
	// CTR: Counter mode (16-bit internal counter)
	AES_MR_OPMOD_CTR = 0x4
	// Position of LOD field.
	AES_MR_LOD_Pos = 0xf
	// Bit mask of LOD field.
	AES_MR_LOD_Msk = 0x8000
	// Bit LOD.
	AES_MR_LOD = 0x8000
	// Position of CFBS field.
	AES_MR_CFBS_Pos = 0x10
	// Bit mask of CFBS field.
	AES_MR_CFBS_Msk = 0x70000
	// 128-bit
	AES_MR_CFBS_SIZE_128BIT = 0x0
	// 64-bit
	AES_MR_CFBS_SIZE_64BIT = 0x1
	// 32-bit
	AES_MR_CFBS_SIZE_32BIT = 0x2
	// 16-bit
	AES_MR_CFBS_SIZE_16BIT = 0x3
	// 8-bit
	AES_MR_CFBS_SIZE_8BIT = 0x4
	// Position of CKEY field.
	AES_MR_CKEY_Pos = 0x14
	// Bit mask of CKEY field.
	AES_MR_CKEY_Msk = 0xf00000

	// IER: Interrupt Enable Register
	// Position of DATRDY field.
	AES_IER_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	AES_IER_DATRDY_Msk = 0x1
	// Bit DATRDY.
	AES_IER_DATRDY = 0x1
	// Position of URAD field.
	AES_IER_URAD_Pos = 0x8
	// Bit mask of URAD field.
	AES_IER_URAD_Msk = 0x100
	// Bit URAD.
	AES_IER_URAD = 0x100

	// IDR: Interrupt Disable Register
	// Position of DATRDY field.
	AES_IDR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	AES_IDR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	AES_IDR_DATRDY = 0x1
	// Position of URAD field.
	AES_IDR_URAD_Pos = 0x8
	// Bit mask of URAD field.
	AES_IDR_URAD_Msk = 0x100
	// Bit URAD.
	AES_IDR_URAD = 0x100

	// IMR: Interrupt Mask Register
	// Position of DATRDY field.
	AES_IMR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	AES_IMR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	AES_IMR_DATRDY = 0x1
	// Position of URAD field.
	AES_IMR_URAD_Pos = 0x8
	// Bit mask of URAD field.
	AES_IMR_URAD_Msk = 0x100
	// Bit URAD.
	AES_IMR_URAD = 0x100

	// ISR: Interrupt Status Register
	// Position of DATRDY field.
	AES_ISR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	AES_ISR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	AES_ISR_DATRDY = 0x1
	// Position of URAD field.
	AES_ISR_URAD_Pos = 0x8
	// Bit mask of URAD field.
	AES_ISR_URAD_Msk = 0x100
	// Bit URAD.
	AES_ISR_URAD = 0x100
	// Position of URAT field.
	AES_ISR_URAT_Pos = 0xc
	// Bit mask of URAT field.
	AES_ISR_URAT_Msk = 0xf000
	// Input Data Register written during the data processing when SMOD=0x2 mode.
	AES_ISR_URAT_IDR_WR_PROCESSING = 0x0
	// Output Data Register read during the data processing.
	AES_ISR_URAT_ODR_RD_PROCESSING = 0x1
	// Mode Register written during the data processing.
	AES_ISR_URAT_MR_WR_PROCESSING = 0x2
	// Output Data Register read during the sub-keys generation.
	AES_ISR_URAT_ODR_RD_SUBKGEN = 0x3
	// Mode Register written during the sub-keys generation.
	AES_ISR_URAT_MR_WR_SUBKGEN = 0x4
	// Write-only register read access.
	AES_ISR_URAT_WOR_RD_ACCESS = 0x5

	// KEYWR: Key Word Register
	// Position of KEYW field.
	AES_KEYWR_KEYW_Pos = 0x0
	// Bit mask of KEYW field.
	AES_KEYWR_KEYW_Msk = 0xffffffff

	// IDATAR: Input Data Register
	// Position of IDATA field.
	AES_IDATAR_IDATA_Pos = 0x0
	// Bit mask of IDATA field.
	AES_IDATAR_IDATA_Msk = 0xffffffff

	// ODATAR: Output Data Register
	// Position of ODATA field.
	AES_ODATAR_ODATA_Pos = 0x0
	// Bit mask of ODATA field.
	AES_ODATAR_ODATA_Msk = 0xffffffff

	// IVR: Initialization Vector Register
	// Position of IV field.
	AES_IVR_IV_Pos = 0x0
	// Bit mask of IV field.
	AES_IVR_IV_Msk = 0xffffffff
)

// Bitfields for SSC: Synchronous Serial Controller
const (
	// CR: Control Register
	// Position of RXEN field.
	SSC_CR_RXEN_Pos = 0x0
	// Bit mask of RXEN field.
	SSC_CR_RXEN_Msk = 0x1
	// Bit RXEN.
	SSC_CR_RXEN = 0x1
	// Position of RXDIS field.
	SSC_CR_RXDIS_Pos = 0x1
	// Bit mask of RXDIS field.
	SSC_CR_RXDIS_Msk = 0x2
	// Bit RXDIS.
	SSC_CR_RXDIS = 0x2
	// Position of TXEN field.
	SSC_CR_TXEN_Pos = 0x8
	// Bit mask of TXEN field.
	SSC_CR_TXEN_Msk = 0x100
	// Bit TXEN.
	SSC_CR_TXEN = 0x100
	// Position of TXDIS field.
	SSC_CR_TXDIS_Pos = 0x9
	// Bit mask of TXDIS field.
	SSC_CR_TXDIS_Msk = 0x200
	// Bit TXDIS.
	SSC_CR_TXDIS = 0x200
	// Position of SWRST field.
	SSC_CR_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	SSC_CR_SWRST_Msk = 0x8000
	// Bit SWRST.
	SSC_CR_SWRST = 0x8000

	// CMR: Clock Mode Register
	// Position of DIV field.
	SSC_CMR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	SSC_CMR_DIV_Msk = 0xfff

	// RCMR: Receive Clock Mode Register
	// Position of CKS field.
	SSC_RCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_RCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_RCMR_CKS_MCK = 0x0
	// TK Clock signal
	SSC_RCMR_CKS_TK = 0x1
	// RK pin
	SSC_RCMR_CKS_RK = 0x2
	// Position of CKO field.
	SSC_RCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_RCMR_CKO_Msk = 0x1c
	// None, RK pin is an input
	SSC_RCMR_CKO_NONE = 0x0
	// Continuous Receive Clock, RK pin is an output
	SSC_RCMR_CKO_CONTINUOUS = 0x1
	// Receive Clock only during data transfers, RK pin is an output
	SSC_RCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_RCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_RCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_RCMR_CKI = 0x20
	// Position of CKG field.
	SSC_RCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_RCMR_CKG_Msk = 0xc0
	// None
	SSC_RCMR_CKG_CONTINUOUS = 0x0
	// Receive Clock enabled only if RF Pin is Low
	SSC_RCMR_CKG_EN_RF_LOW = 0x1
	// Receive Clock enabled only if RF Pin is High
	SSC_RCMR_CKG_EN_RF_HIGH = 0x2
	// Position of START field.
	SSC_RCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_RCMR_START_Msk = 0xf00
	// Continuous, as soon as the receiver is enabled, and immediately after the end of transfer of the previous data.
	SSC_RCMR_START_CONTINUOUS = 0x0
	// Transmit start
	SSC_RCMR_START_TRANSMIT = 0x1
	// Detection of a low level on RF signal
	SSC_RCMR_START_RF_LOW = 0x2
	// Detection of a high level on RF signal
	SSC_RCMR_START_RF_HIGH = 0x3
	// Detection of a falling edge on RF signal
	SSC_RCMR_START_RF_FALLING = 0x4
	// Detection of a rising edge on RF signal
	SSC_RCMR_START_RF_RISING = 0x5
	// Detection of any level change on RF signal
	SSC_RCMR_START_RF_LEVEL = 0x6
	// Detection of any edge on RF signal
	SSC_RCMR_START_RF_EDGE = 0x7
	// Compare 0
	SSC_RCMR_START_CMP_0 = 0x8
	// Position of STOP field.
	SSC_RCMR_STOP_Pos = 0xc
	// Bit mask of STOP field.
	SSC_RCMR_STOP_Msk = 0x1000
	// Bit STOP.
	SSC_RCMR_STOP = 0x1000
	// Position of STTDLY field.
	SSC_RCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_RCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_RCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_RCMR_PERIOD_Msk = 0xff000000

	// RFMR: Receive Frame Mode Register
	// Position of DATLEN field.
	SSC_RFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_RFMR_DATLEN_Msk = 0x1f
	// Position of LOOP field.
	SSC_RFMR_LOOP_Pos = 0x5
	// Bit mask of LOOP field.
	SSC_RFMR_LOOP_Msk = 0x20
	// Bit LOOP.
	SSC_RFMR_LOOP = 0x20
	// Position of MSBF field.
	SSC_RFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_RFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_RFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_RFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_RFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_RFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_RFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_RFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_RFMR_FSOS_Msk = 0x700000
	// None, RF pin is an input
	SSC_RFMR_FSOS_NONE = 0x0
	// Negative Pulse, RF pin is an output
	SSC_RFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse, RF pin is an output
	SSC_RFMR_FSOS_POSITIVE = 0x2
	// Driven Low during data transfer, RF pin is an output
	SSC_RFMR_FSOS_LOW = 0x3
	// Driven High during data transfer, RF pin is an output
	SSC_RFMR_FSOS_HIGH = 0x4
	// Toggling at each start of data transfer, RF pin is an output
	SSC_RFMR_FSOS_TOGGLING = 0x5
	// Position of FSEDGE field.
	SSC_RFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_RFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_RFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_RFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_RFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_RFMR_FSLEN_EXT_Msk = 0xf0000000

	// TCMR: Transmit Clock Mode Register
	// Position of CKS field.
	SSC_TCMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SSC_TCMR_CKS_Msk = 0x3
	// Divided Clock
	SSC_TCMR_CKS_MCK = 0x0
	// RK Clock signal
	SSC_TCMR_CKS_RK = 0x1
	// TK pin
	SSC_TCMR_CKS_TK = 0x2
	// Position of CKO field.
	SSC_TCMR_CKO_Pos = 0x2
	// Bit mask of CKO field.
	SSC_TCMR_CKO_Msk = 0x1c
	// None, TK pin is an input
	SSC_TCMR_CKO_NONE = 0x0
	// Continuous Transmit Clock, TK pin is an output
	SSC_TCMR_CKO_CONTINUOUS = 0x1
	// Transmit Clock only during data transfers, TK pin is an output
	SSC_TCMR_CKO_TRANSFER = 0x2
	// Position of CKI field.
	SSC_TCMR_CKI_Pos = 0x5
	// Bit mask of CKI field.
	SSC_TCMR_CKI_Msk = 0x20
	// Bit CKI.
	SSC_TCMR_CKI = 0x20
	// Position of CKG field.
	SSC_TCMR_CKG_Pos = 0x6
	// Bit mask of CKG field.
	SSC_TCMR_CKG_Msk = 0xc0
	// None
	SSC_TCMR_CKG_CONTINUOUS = 0x0
	// Transmit Clock enabled only if TF pin is Low
	SSC_TCMR_CKG_EN_TF_LOW = 0x1
	// Transmit Clock enabled only if TF pin is High
	SSC_TCMR_CKG_EN_TF_HIGH = 0x2
	// Position of START field.
	SSC_TCMR_START_Pos = 0x8
	// Bit mask of START field.
	SSC_TCMR_START_Msk = 0xf00
	// Continuous, as soon as a word is written in the SSC_THR Register (if Transmit is enabled), and immediately after the end of transfer of the previous data.
	SSC_TCMR_START_CONTINUOUS = 0x0
	// Receive start
	SSC_TCMR_START_RECEIVE = 0x1
	// Detection of a low level on TF signal
	SSC_TCMR_START_TF_LOW = 0x2
	// Detection of a high level on TF signal
	SSC_TCMR_START_TF_HIGH = 0x3
	// Detection of a falling edge on TF signal
	SSC_TCMR_START_TF_FALLING = 0x4
	// Detection of a rising edge on TF signal
	SSC_TCMR_START_TF_RISING = 0x5
	// Detection of any level change on TF signal
	SSC_TCMR_START_TF_LEVEL = 0x6
	// Detection of any edge on TF signal
	SSC_TCMR_START_TF_EDGE = 0x7
	// Position of STTDLY field.
	SSC_TCMR_STTDLY_Pos = 0x10
	// Bit mask of STTDLY field.
	SSC_TCMR_STTDLY_Msk = 0xff0000
	// Position of PERIOD field.
	SSC_TCMR_PERIOD_Pos = 0x18
	// Bit mask of PERIOD field.
	SSC_TCMR_PERIOD_Msk = 0xff000000

	// TFMR: Transmit Frame Mode Register
	// Position of DATLEN field.
	SSC_TFMR_DATLEN_Pos = 0x0
	// Bit mask of DATLEN field.
	SSC_TFMR_DATLEN_Msk = 0x1f
	// Position of DATDEF field.
	SSC_TFMR_DATDEF_Pos = 0x5
	// Bit mask of DATDEF field.
	SSC_TFMR_DATDEF_Msk = 0x20
	// Bit DATDEF.
	SSC_TFMR_DATDEF = 0x20
	// Position of MSBF field.
	SSC_TFMR_MSBF_Pos = 0x7
	// Bit mask of MSBF field.
	SSC_TFMR_MSBF_Msk = 0x80
	// Bit MSBF.
	SSC_TFMR_MSBF = 0x80
	// Position of DATNB field.
	SSC_TFMR_DATNB_Pos = 0x8
	// Bit mask of DATNB field.
	SSC_TFMR_DATNB_Msk = 0xf00
	// Position of FSLEN field.
	SSC_TFMR_FSLEN_Pos = 0x10
	// Bit mask of FSLEN field.
	SSC_TFMR_FSLEN_Msk = 0xf0000
	// Position of FSOS field.
	SSC_TFMR_FSOS_Pos = 0x14
	// Bit mask of FSOS field.
	SSC_TFMR_FSOS_Msk = 0x700000
	// None, TF pin is an input
	SSC_TFMR_FSOS_NONE = 0x0
	// Negative Pulse, TF pin is an output
	SSC_TFMR_FSOS_NEGATIVE = 0x1
	// Positive Pulse,TF pin is an output
	SSC_TFMR_FSOS_POSITIVE = 0x2
	// TF pin Driven Low during data transfer
	SSC_TFMR_FSOS_LOW = 0x3
	// TF pin Driven High during data transfer
	SSC_TFMR_FSOS_HIGH = 0x4
	// TF pin Toggles at each start of data transfer
	SSC_TFMR_FSOS_TOGGLING = 0x5
	// Position of FSDEN field.
	SSC_TFMR_FSDEN_Pos = 0x17
	// Bit mask of FSDEN field.
	SSC_TFMR_FSDEN_Msk = 0x800000
	// Bit FSDEN.
	SSC_TFMR_FSDEN = 0x800000
	// Position of FSEDGE field.
	SSC_TFMR_FSEDGE_Pos = 0x18
	// Bit mask of FSEDGE field.
	SSC_TFMR_FSEDGE_Msk = 0x1000000
	// Bit FSEDGE.
	SSC_TFMR_FSEDGE = 0x1000000
	// Positive Edge Detection
	SSC_TFMR_FSEDGE_POSITIVE = 0x0
	// Negative Edge Detection
	SSC_TFMR_FSEDGE_NEGATIVE = 0x1
	// Position of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Pos = 0x1c
	// Bit mask of FSLEN_EXT field.
	SSC_TFMR_FSLEN_EXT_Msk = 0xf0000000

	// RHR: Receive Holding Register
	// Position of RDAT field.
	SSC_RHR_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SSC_RHR_RDAT_Msk = 0xffffffff

	// THR: Transmit Holding Register
	// Position of TDAT field.
	SSC_THR_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SSC_THR_TDAT_Msk = 0xffffffff

	// RSHR: Receive Sync. Holding Register
	// Position of RSDAT field.
	SSC_RSHR_RSDAT_Pos = 0x0
	// Bit mask of RSDAT field.
	SSC_RSHR_RSDAT_Msk = 0xffff

	// TSHR: Transmit Sync. Holding Register
	// Position of TSDAT field.
	SSC_TSHR_TSDAT_Pos = 0x0
	// Bit mask of TSDAT field.
	SSC_TSHR_TSDAT_Msk = 0xffff

	// RC0R: Receive Compare 0 Register
	// Position of CP0 field.
	SSC_RC0R_CP0_Pos = 0x0
	// Bit mask of CP0 field.
	SSC_RC0R_CP0_Msk = 0xffff

	// RC1R: Receive Compare 1 Register
	// Position of CP1 field.
	SSC_RC1R_CP1_Pos = 0x0
	// Bit mask of CP1 field.
	SSC_RC1R_CP1_Msk = 0xffff

	// SR: Status Register
	// Position of TXRDY field.
	SSC_SR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_SR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_SR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_SR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_SR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_SR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_SR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_SR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_SR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_SR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_SR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_SR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_SR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_SR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_SR_CP0 = 0x100
	// Position of CP1 field.
	SSC_SR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_SR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_SR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_SR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_SR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_SR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_SR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_SR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_SR_RXSYN = 0x800
	// Position of TXEN field.
	SSC_SR_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SSC_SR_TXEN_Msk = 0x10000
	// Bit TXEN.
	SSC_SR_TXEN = 0x10000
	// Position of RXEN field.
	SSC_SR_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SSC_SR_RXEN_Msk = 0x20000
	// Bit RXEN.
	SSC_SR_RXEN = 0x20000

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	SSC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IER_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IER_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IER_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IER_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IER_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IER_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IER_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IER_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IER_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IER_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IER_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IER_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IER_CP0 = 0x100
	// Position of CP1 field.
	SSC_IER_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IER_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IER_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IER_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IER_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IER_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IER_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IER_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IER_RXSYN = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	SSC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IDR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IDR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IDR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IDR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IDR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IDR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IDR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IDR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IDR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IDR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IDR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IDR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IDR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IDR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IDR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IDR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IDR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IDR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IDR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IDR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IDR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IDR_RXSYN = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	SSC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	SSC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	SSC_IMR_TXRDY = 0x1
	// Position of TXEMPTY field.
	SSC_IMR_TXEMPTY_Pos = 0x1
	// Bit mask of TXEMPTY field.
	SSC_IMR_TXEMPTY_Msk = 0x2
	// Bit TXEMPTY.
	SSC_IMR_TXEMPTY = 0x2
	// Position of RXRDY field.
	SSC_IMR_RXRDY_Pos = 0x4
	// Bit mask of RXRDY field.
	SSC_IMR_RXRDY_Msk = 0x10
	// Bit RXRDY.
	SSC_IMR_RXRDY = 0x10
	// Position of OVRUN field.
	SSC_IMR_OVRUN_Pos = 0x5
	// Bit mask of OVRUN field.
	SSC_IMR_OVRUN_Msk = 0x20
	// Bit OVRUN.
	SSC_IMR_OVRUN = 0x20
	// Position of CP0 field.
	SSC_IMR_CP0_Pos = 0x8
	// Bit mask of CP0 field.
	SSC_IMR_CP0_Msk = 0x100
	// Bit CP0.
	SSC_IMR_CP0 = 0x100
	// Position of CP1 field.
	SSC_IMR_CP1_Pos = 0x9
	// Bit mask of CP1 field.
	SSC_IMR_CP1_Msk = 0x200
	// Bit CP1.
	SSC_IMR_CP1 = 0x200
	// Position of TXSYN field.
	SSC_IMR_TXSYN_Pos = 0xa
	// Bit mask of TXSYN field.
	SSC_IMR_TXSYN_Msk = 0x400
	// Bit TXSYN.
	SSC_IMR_TXSYN = 0x400
	// Position of RXSYN field.
	SSC_IMR_RXSYN_Pos = 0xb
	// Bit mask of RXSYN field.
	SSC_IMR_RXSYN_Msk = 0x800
	// Bit RXSYN.
	SSC_IMR_RXSYN = 0x800

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	SSC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SSC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SSC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SSC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SSC_WPMR_WPKEY_Msk = 0xffffff00
)

// Bitfields for SHA: Secure Hash Algorithm
const (
	// CR: Control Register
	// Position of START field.
	SHA_CR_START_Pos = 0x0
	// Bit mask of START field.
	SHA_CR_START_Msk = 0x1
	// Bit START.
	SHA_CR_START = 0x1
	// Position of FIRST field.
	SHA_CR_FIRST_Pos = 0x4
	// Bit mask of FIRST field.
	SHA_CR_FIRST_Msk = 0x10
	// Bit FIRST.
	SHA_CR_FIRST = 0x10
	// Position of SWRST field.
	SHA_CR_SWRST_Pos = 0x8
	// Bit mask of SWRST field.
	SHA_CR_SWRST_Msk = 0x100
	// Bit SWRST.
	SHA_CR_SWRST = 0x100

	// MR: Mode Register
	// Position of SMOD field.
	SHA_MR_SMOD_Pos = 0x0
	// Bit mask of SMOD field.
	SHA_MR_SMOD_Msk = 0x3
	// Manual Mode
	SHA_MR_SMOD_MANUAL_START = 0x0
	// Auto Mode
	SHA_MR_SMOD_AUTO_START = 0x1
	// SHA_IDATAR0 access only Auto Mode
	SHA_MR_SMOD_IDATAR0_START = 0x2
	// Position of PROCDLY field.
	SHA_MR_PROCDLY_Pos = 0x4
	// Bit mask of PROCDLY field.
	SHA_MR_PROCDLY_Msk = 0x10
	// Bit PROCDLY.
	SHA_MR_PROCDLY = 0x10
	// SHA processing runtime is the shortest one
	SHA_MR_PROCDLY_SHORTEST = 0x0
	// SHA processing runtime is the longest one
	SHA_MR_PROCDLY_LONGEST = 0x1
	// Position of ALGO field.
	SHA_MR_ALGO_Pos = 0x8
	// Bit mask of ALGO field.
	SHA_MR_ALGO_Msk = 0x700
	// SHA1 algorithm processed
	SHA_MR_ALGO_SHA1 = 0x0
	// SHA256 algorithm processed
	SHA_MR_ALGO_SHA256 = 0x1
	// SHA224 algorithm processed
	SHA_MR_ALGO_SHA224 = 0x4
	// Position of DUALBUFF field.
	SHA_MR_DUALBUFF_Pos = 0x10
	// Bit mask of DUALBUFF field.
	SHA_MR_DUALBUFF_Msk = 0x10000
	// Bit DUALBUFF.
	SHA_MR_DUALBUFF = 0x10000
	// SHA_IDATARx and SHA_IODATARx cannot be written during processing of previous block.
	SHA_MR_DUALBUFF_INACTIVE = 0x0
	// SHA_IDATARx and SHA_IODATARx can be written during processing of previous block when SMOD=0x2. It speeds up the overall runtime of large files.
	SHA_MR_DUALBUFF_ACTIVE = 0x1

	// IER: Interrupt Enable Register
	// Position of DATRDY field.
	SHA_IER_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	SHA_IER_DATRDY_Msk = 0x1
	// Bit DATRDY.
	SHA_IER_DATRDY = 0x1
	// Position of URAD field.
	SHA_IER_URAD_Pos = 0x8
	// Bit mask of URAD field.
	SHA_IER_URAD_Msk = 0x100
	// Bit URAD.
	SHA_IER_URAD = 0x100

	// IDR: Interrupt Disable Register
	// Position of DATRDY field.
	SHA_IDR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	SHA_IDR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	SHA_IDR_DATRDY = 0x1
	// Position of URAD field.
	SHA_IDR_URAD_Pos = 0x8
	// Bit mask of URAD field.
	SHA_IDR_URAD_Msk = 0x100
	// Bit URAD.
	SHA_IDR_URAD = 0x100

	// IMR: Interrupt Mask Register
	// Position of DATRDY field.
	SHA_IMR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	SHA_IMR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	SHA_IMR_DATRDY = 0x1
	// Position of URAD field.
	SHA_IMR_URAD_Pos = 0x8
	// Bit mask of URAD field.
	SHA_IMR_URAD_Msk = 0x100
	// Bit URAD.
	SHA_IMR_URAD = 0x100

	// ISR: Interrupt Status Register
	// Position of DATRDY field.
	SHA_ISR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	SHA_ISR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	SHA_ISR_DATRDY = 0x1
	// Position of URAD field.
	SHA_ISR_URAD_Pos = 0x8
	// Bit mask of URAD field.
	SHA_ISR_URAD_Msk = 0x100
	// Bit URAD.
	SHA_ISR_URAD = 0x100
	// Position of URAT field.
	SHA_ISR_URAT_Pos = 0xc
	// Bit mask of URAT field.
	SHA_ISR_URAT_Msk = 0x7000

	// IDATAR: Input Data 0 Register
	// Position of IDATA field.
	SHA_IDATAR_IDATA_Pos = 0x0
	// Bit mask of IDATA field.
	SHA_IDATAR_IDATA_Msk = 0xffffffff

	// ODATAR: Output Data 0 Register
	// Position of ODATA field.
	SHA_ODATAR_ODATA_Pos = 0x0
	// Bit mask of ODATA field.
	SHA_ODATAR_ODATA_Msk = 0xffffffff
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVE_EQ_1: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR0_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// RAB0: Register AB (channel = 0)
	// Position of RAB field.
	TC_RAB0_RAB_Pos = 0x0
	// Bit mask of RAB field.
	TC_RAB0_RAB_Msk = 0xffffffff

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVE_EQ_1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR1_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// RAB1: Register AB (channel = 1)
	// Position of RAB field.
	TC_RAB1_RAB_Pos = 0x0
	// Bit mask of RAB field.
	TC_RAB1_RAB_Msk = 0xffffffff

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVE_EQ_1: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVE_EQ_1_TCCLKS_Msk = 0x7
	// Clock selected: TCLK1
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: TCLK2
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: TCLK3
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: TCLK4
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: TCLK5
	TC_CMR2_WAVE_EQ_1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVE_EQ_1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVE_EQ_1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVE_EQ_1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVE_EQ_1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVE_EQ_1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVE_EQ_1_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVE_EQ_1_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVE_EQ_1_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVE_EQ_1_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVE_EQ_1_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVE_EQ_1_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVE_EQ_1_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVE_EQ_1_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVE_EQ_1_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVE_EQ_1_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVE_EQ_1_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVE_EQ_1_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVE_EQ_1_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVE_EQ_1_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVE_EQ_1_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVE_EQ_1_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVE_EQ_1_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_EQ_1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE_EQ_1_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVE_EQ_1_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVE_EQ_1_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVE_EQ_1_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVE_EQ_1_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVE_EQ_1_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVE_EQ_1_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVE_EQ_1_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVE_EQ_1_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVE_EQ_1_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVE_EQ_1_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVE_EQ_1_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVE_EQ_1_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVE_EQ_1_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVE_EQ_1_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVE_EQ_1_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVE_EQ_1_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVE_EQ_1_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVE_EQ_1_BSWTRG_TOGGLE = 0x3

	// RAB2: Register AB (channel = 2)
	// Position of RAB field.
	TC_RAB2_RAB_Pos = 0x0
	// Bit mask of RAB field.
	TC_RAB2_RAB_Msk = 0xffffffff

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x2
	// Signal connected to XC2: TIOA2
	TC_BMR_TC2XC2S_TIOA2 = 0x3
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// WPROT_MODE: Protection Mode Register
	// Position of WPROT field.
	TWI_WPROT_MODE_WPROT_Pos = 0x0
	// Bit mask of WPROT field.
	TWI_WPROT_MODE_WPROT_Msk = 0x1
	// Bit WPROT.
	TWI_WPROT_MODE_WPROT = 0x1
	// Position of SECURITY_CODE field.
	TWI_WPROT_MODE_SECURITY_CODE_Pos = 0x8
	// Bit mask of SECURITY_CODE field.
	TWI_WPROT_MODE_SECURITY_CODE_Msk = 0xffffff00

	// WPROT_STATUS: Protection Status Register
	// Position of WPROTERR field.
	TWI_WPROT_STATUS_WPROTERR_Pos = 0x0
	// Bit mask of WPROTERR field.
	TWI_WPROT_STATUS_WPROTERR_Msk = 0x1
	// Bit WPROTERR.
	TWI_WPROT_STATUS_WPROTERR = 0x1
	// Position of WPROTADDR field.
	TWI_WPROT_STATUS_WPROTADDR_Pos = 0x8
	// Bit mask of WPROTADDR field.
	TWI_WPROT_STATUS_WPROTADDR_Msk = 0xffffff00
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000
	// Position of LINABT field.
	USART_CR_LINABT_Pos = 0x14
	// Bit mask of LINABT field.
	USART_CR_LINABT_Msk = 0x100000
	// Bit LINABT.
	USART_CR_LINABT = 0x100000
	// Position of LINWKUP field.
	USART_CR_LINWKUP_Pos = 0x15
	// Bit mask of LINWKUP field.
	USART_CR_LINWKUP_Msk = 0x200000
	// Bit LINWKUP.
	USART_CR_LINWKUP = 0x200000

	// CR_SPI_MODE: Control Register
	// Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_SPI_MODE_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_SPI_MODE_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_SPI_MODE_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_SPI_MODE_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_SPI_MODE_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_SPI_MODE_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_SPI_MODE_RSTSTA = 0x100
	// Position of FCS field.
	USART_CR_SPI_MODE_FCS_Pos = 0x12
	// Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS_Msk = 0x40000
	// Bit FCS.
	USART_CR_SPI_MODE_FCS = 0x40000
	// Position of RCS field.
	USART_CR_SPI_MODE_RCS_Pos = 0x13
	// Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS_Msk = 0x80000
	// Bit RCS.
	USART_CR_SPI_MODE_RCS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// LIN Master
	USART_MR_USART_MODE_LIN_MASTER = 0xa
	// LIN Slave
	USART_MR_USART_MODE_LIN_SLAVE = 0xb
	// SPI Master
	USART_MR_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of VAR_SYNC field.
	USART_MR_VAR_SYNC_Pos = 0x16
	// Bit mask of VAR_SYNC field.
	USART_MR_VAR_SYNC_Msk = 0x400000
	// Bit VAR_SYNC.
	USART_MR_VAR_SYNC = 0x400000
	// Position of INVDATA field.
	USART_MR_INVDATA_Pos = 0x17
	// Bit mask of INVDATA field.
	USART_MR_INVDATA_Msk = 0x800000
	// Bit INVDATA.
	USART_MR_INVDATA = 0x800000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000
	// Position of MAN field.
	USART_MR_MAN_Pos = 0x1d
	// Bit mask of MAN field.
	USART_MR_MAN_Msk = 0x20000000
	// Bit MAN.
	USART_MR_MAN = 0x20000000
	// Position of MODSYNC field.
	USART_MR_MODSYNC_Pos = 0x1e
	// Bit mask of MODSYNC field.
	USART_MR_MODSYNC_Msk = 0x40000000
	// Bit MODSYNC.
	USART_MR_MODSYNC = 0x40000000
	// Position of ONEBIT field.
	USART_MR_ONEBIT_Pos = 0x1f
	// Bit mask of ONEBIT field.
	USART_MR_ONEBIT_Msk = 0x80000000
	// Bit ONEBIT.
	USART_MR_ONEBIT = 0x80000000

	// MR_SPI_MODE: Mode Register
	// Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk = 0xf
	// SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_SPI_MODE_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk = 0xc0
	// Character length is 8 bits
	USART_MR_SPI_MODE_CHRL_8_BIT = 0x3
	// Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Pos = 0x8
	// Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk = 0x100
	// Bit CPHA.
	USART_MR_SPI_MODE_CPHA = 0x100
	// Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Pos = 0x10
	// Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk = 0x10000
	// Bit CPOL.
	USART_MR_SPI_MODE_CPOL = 0x10000
	// Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Pos = 0x14
	// Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk = 0x100000
	// Bit WRDBT.
	USART_MR_SPI_MODE_WRDBT = 0x100000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000
	// Position of MANE field.
	USART_IER_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IER_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IER_MANE = 0x1000000

	// IER_SPI_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IER_SPI_MODE_UNRE = 0x400

	// IER_LIN_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_LIN_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IER_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_IER_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_LIN_MODE_TXEMPTY = 0x200
	// Position of LINBK field.
	USART_IER_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_IER_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_IER_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_IER_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_IER_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_IER_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_IER_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_IER_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_IER_LIN_MODE_LINTC = 0x8000
	// Position of LINBE field.
	USART_IER_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_IER_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_IER_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_IER_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_IER_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_IER_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_IER_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_IER_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_IER_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_IER_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_IER_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_IER_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_IER_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_IER_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_IER_LIN_MODE_LINSNRE = 0x20000000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IDR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IDR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IDR_MANE = 0x1000000

	// IDR_SPI_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IDR_SPI_MODE_UNRE = 0x400

	// IDR_LIN_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_LIN_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IDR_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_LIN_MODE_TXEMPTY = 0x200
	// Position of LINBK field.
	USART_IDR_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_IDR_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_IDR_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_IDR_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_IDR_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_IDR_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_IDR_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_IDR_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_IDR_LIN_MODE_LINTC = 0x8000
	// Position of LINBE field.
	USART_IDR_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_IDR_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_IDR_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_IDR_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_IDR_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_IDR_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_IDR_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_IDR_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_IDR_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_IDR_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_IDR_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_IDR_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_IDR_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_IDR_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_IDR_LIN_MODE_LINSNRE = 0x20000000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000
	// Position of MANE field.
	USART_IMR_MANE_Pos = 0x18
	// Bit mask of MANE field.
	USART_IMR_MANE_Msk = 0x1000000
	// Bit MANE.
	USART_IMR_MANE = 0x1000000

	// IMR_SPI_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IMR_SPI_MODE_UNRE = 0x400

	// IMR_LIN_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_LIN_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IMR_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_LIN_MODE_TXEMPTY = 0x200
	// Position of LINBK field.
	USART_IMR_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_IMR_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_IMR_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_IMR_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_IMR_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_IMR_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_IMR_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_IMR_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_IMR_LIN_MODE_LINTC = 0x8000
	// Position of LINBE field.
	USART_IMR_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_IMR_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_IMR_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_IMR_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_IMR_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_IMR_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_IMR_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_IMR_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_IMR_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_IMR_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_IMR_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_IMR_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_IMR_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_IMR_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_IMR_LIN_MODE_LINSNRE = 0x20000000

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000
	// Position of MANERR field.
	USART_CSR_MANERR_Pos = 0x18
	// Bit mask of MANERR field.
	USART_CSR_MANERR_Msk = 0x1000000
	// Bit MANERR.
	USART_CSR_MANERR = 0x1000000

	// CSR_SPI_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_CSR_SPI_MODE_UNRE = 0x400

	// CSR_LIN_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_LIN_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_LIN_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_LIN_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_LIN_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_LIN_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_LIN_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_CSR_LIN_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_LIN_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_LIN_MODE_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_LIN_MODE_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_LIN_MODE_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_LIN_MODE_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_LIN_MODE_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_LIN_MODE_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_LIN_MODE_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_LIN_MODE_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_LIN_MODE_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_LIN_MODE_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_LIN_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_LIN_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_LIN_MODE_TXEMPTY = 0x200
	// Position of LINBK field.
	USART_CSR_LIN_MODE_LINBK_Pos = 0xd
	// Bit mask of LINBK field.
	USART_CSR_LIN_MODE_LINBK_Msk = 0x2000
	// Bit LINBK.
	USART_CSR_LIN_MODE_LINBK = 0x2000
	// Position of LINID field.
	USART_CSR_LIN_MODE_LINID_Pos = 0xe
	// Bit mask of LINID field.
	USART_CSR_LIN_MODE_LINID_Msk = 0x4000
	// Bit LINID.
	USART_CSR_LIN_MODE_LINID = 0x4000
	// Position of LINTC field.
	USART_CSR_LIN_MODE_LINTC_Pos = 0xf
	// Bit mask of LINTC field.
	USART_CSR_LIN_MODE_LINTC_Msk = 0x8000
	// Bit LINTC.
	USART_CSR_LIN_MODE_LINTC = 0x8000
	// Position of LINBLS field.
	USART_CSR_LIN_MODE_LINBLS_Pos = 0x17
	// Bit mask of LINBLS field.
	USART_CSR_LIN_MODE_LINBLS_Msk = 0x800000
	// Bit LINBLS.
	USART_CSR_LIN_MODE_LINBLS = 0x800000
	// Position of LINBE field.
	USART_CSR_LIN_MODE_LINBE_Pos = 0x19
	// Bit mask of LINBE field.
	USART_CSR_LIN_MODE_LINBE_Msk = 0x2000000
	// Bit LINBE.
	USART_CSR_LIN_MODE_LINBE = 0x2000000
	// Position of LINISFE field.
	USART_CSR_LIN_MODE_LINISFE_Pos = 0x1a
	// Bit mask of LINISFE field.
	USART_CSR_LIN_MODE_LINISFE_Msk = 0x4000000
	// Bit LINISFE.
	USART_CSR_LIN_MODE_LINISFE = 0x4000000
	// Position of LINIPE field.
	USART_CSR_LIN_MODE_LINIPE_Pos = 0x1b
	// Bit mask of LINIPE field.
	USART_CSR_LIN_MODE_LINIPE_Msk = 0x8000000
	// Bit LINIPE.
	USART_CSR_LIN_MODE_LINIPE = 0x8000000
	// Position of LINCE field.
	USART_CSR_LIN_MODE_LINCE_Pos = 0x1c
	// Bit mask of LINCE field.
	USART_CSR_LIN_MODE_LINCE_Msk = 0x10000000
	// Bit LINCE.
	USART_CSR_LIN_MODE_LINCE = 0x10000000
	// Position of LINSNRE field.
	USART_CSR_LIN_MODE_LINSNRE_Pos = 0x1d
	// Bit mask of LINSNRE field.
	USART_CSR_LIN_MODE_LINSNRE_Msk = 0x20000000
	// Bit LINSNRE.
	USART_CSR_LIN_MODE_LINSNRE = 0x20000000

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0x1ffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// MAN: Manchester Encoder Decoder Register
	// Position of TX_PL field.
	USART_MAN_TX_PL_Pos = 0x0
	// Bit mask of TX_PL field.
	USART_MAN_TX_PL_Msk = 0xf
	// Position of TX_PP field.
	USART_MAN_TX_PP_Pos = 0x8
	// Bit mask of TX_PP field.
	USART_MAN_TX_PP_Msk = 0x300
	// The preamble is composed of '1's
	USART_MAN_TX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_TX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_TX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_TX_PP_ONE_ZERO = 0x3
	// Position of TX_MPOL field.
	USART_MAN_TX_MPOL_Pos = 0xc
	// Bit mask of TX_MPOL field.
	USART_MAN_TX_MPOL_Msk = 0x1000
	// Bit TX_MPOL.
	USART_MAN_TX_MPOL = 0x1000
	// Position of RX_PL field.
	USART_MAN_RX_PL_Pos = 0x10
	// Bit mask of RX_PL field.
	USART_MAN_RX_PL_Msk = 0xf0000
	// Position of RX_PP field.
	USART_MAN_RX_PP_Pos = 0x18
	// Bit mask of RX_PP field.
	USART_MAN_RX_PP_Msk = 0x3000000
	// The preamble is composed of '1's
	USART_MAN_RX_PP_ALL_ONE = 0x0
	// The preamble is composed of '0's
	USART_MAN_RX_PP_ALL_ZERO = 0x1
	// The preamble is composed of '01's
	USART_MAN_RX_PP_ZERO_ONE = 0x2
	// The preamble is composed of '10's
	USART_MAN_RX_PP_ONE_ZERO = 0x3
	// Position of RX_MPOL field.
	USART_MAN_RX_MPOL_Pos = 0x1c
	// Bit mask of RX_MPOL field.
	USART_MAN_RX_MPOL_Msk = 0x10000000
	// Bit RX_MPOL.
	USART_MAN_RX_MPOL = 0x10000000
	// Position of ONE field.
	USART_MAN_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	USART_MAN_ONE_Msk = 0x20000000
	// Bit ONE.
	USART_MAN_ONE = 0x20000000
	// Position of DRIFT field.
	USART_MAN_DRIFT_Pos = 0x1e
	// Bit mask of DRIFT field.
	USART_MAN_DRIFT_Msk = 0x40000000
	// Bit DRIFT.
	USART_MAN_DRIFT = 0x40000000

	// LINMR: LIN Mode Register
	// Position of NACT field.
	USART_LINMR_NACT_Pos = 0x0
	// Bit mask of NACT field.
	USART_LINMR_NACT_Msk = 0x3
	// The USART transmits the response.
	USART_LINMR_NACT_PUBLISH = 0x0
	// The USART receives the response.
	USART_LINMR_NACT_SUBSCRIBE = 0x1
	// The USART does not transmit and does not receive the response.
	USART_LINMR_NACT_IGNORE = 0x2
	// Position of PARDIS field.
	USART_LINMR_PARDIS_Pos = 0x2
	// Bit mask of PARDIS field.
	USART_LINMR_PARDIS_Msk = 0x4
	// Bit PARDIS.
	USART_LINMR_PARDIS = 0x4
	// Position of CHKDIS field.
	USART_LINMR_CHKDIS_Pos = 0x3
	// Bit mask of CHKDIS field.
	USART_LINMR_CHKDIS_Msk = 0x8
	// Bit CHKDIS.
	USART_LINMR_CHKDIS = 0x8
	// Position of CHKTYP field.
	USART_LINMR_CHKTYP_Pos = 0x4
	// Bit mask of CHKTYP field.
	USART_LINMR_CHKTYP_Msk = 0x10
	// Bit CHKTYP.
	USART_LINMR_CHKTYP = 0x10
	// Position of DLM field.
	USART_LINMR_DLM_Pos = 0x5
	// Bit mask of DLM field.
	USART_LINMR_DLM_Msk = 0x20
	// Bit DLM.
	USART_LINMR_DLM = 0x20
	// Position of FSDIS field.
	USART_LINMR_FSDIS_Pos = 0x6
	// Bit mask of FSDIS field.
	USART_LINMR_FSDIS_Msk = 0x40
	// Bit FSDIS.
	USART_LINMR_FSDIS = 0x40
	// Position of WKUPTYP field.
	USART_LINMR_WKUPTYP_Pos = 0x7
	// Bit mask of WKUPTYP field.
	USART_LINMR_WKUPTYP_Msk = 0x80
	// Bit WKUPTYP.
	USART_LINMR_WKUPTYP = 0x80
	// Position of DLC field.
	USART_LINMR_DLC_Pos = 0x8
	// Bit mask of DLC field.
	USART_LINMR_DLC_Msk = 0xff00
	// Position of PDCM field.
	USART_LINMR_PDCM_Pos = 0x10
	// Bit mask of PDCM field.
	USART_LINMR_PDCM_Msk = 0x10000
	// Bit PDCM.
	USART_LINMR_PDCM = 0x10000

	// LINIR: LIN Identifier Register
	// Position of IDCHR field.
	USART_LINIR_IDCHR_Pos = 0x0
	// Bit mask of IDCHR field.
	USART_LINIR_IDCHR_Msk = 0xff

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	USART_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	USART_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	USART_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	USART_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	USART_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	USART_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	USART_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	USART_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// MR: PWM Mode Register
	// Position of DIVA field.
	PWM_MR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PWM_MR_DIVA_Msk = 0xff
	// CLKA, CLKB clock is turned off
	PWM_MR_DIVA_CLK_OFF = 0x0
	// CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_DIVA_CLK_DIV1 = 0x1
	// Position of PREA field.
	PWM_MR_PREA_Pos = 0x8
	// Bit mask of PREA field.
	PWM_MR_PREA_Msk = 0xf00
	// Master Clock
	PWM_MR_PREA_MCK = 0x0
	// Master Clock divided by 2
	PWM_MR_PREA_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_MR_PREA_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_MR_PREA_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_MR_PREA_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_MR_PREA_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_MR_PREA_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_MR_PREA_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_MR_PREA_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_MR_PREA_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_MR_PREA_MCKDIV1024 = 0xa
	// Position of DIVB field.
	PWM_MR_DIVB_Pos = 0x10
	// Bit mask of DIVB field.
	PWM_MR_DIVB_Msk = 0xff0000
	// CLKA, CLKB clock is turned off
	PWM_MR_DIVB_CLK_OFF = 0x0
	// CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_DIVB_CLK_DIV1 = 0x1
	// Position of PREB field.
	PWM_MR_PREB_Pos = 0x18
	// Bit mask of PREB field.
	PWM_MR_PREB_Msk = 0xf000000
	// Master Clock
	PWM_MR_PREB_MCK = 0x0
	// Master Clock divided by 2
	PWM_MR_PREB_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_MR_PREB_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_MR_PREB_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_MR_PREB_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_MR_PREB_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_MR_PREB_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_MR_PREB_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_MR_PREB_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_MR_PREB_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_MR_PREB_MCKDIV1024 = 0xa

	// ENA: PWM Enable Register
	// Position of CHID0 field.
	PWM_ENA_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ENA_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ENA_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ENA_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ENA_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ENA_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ENA_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ENA_CHID3 = 0x8

	// DIS: PWM Disable Register
	// Position of CHID0 field.
	PWM_DIS_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_DIS_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_DIS_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_DIS_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_DIS_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_DIS_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_DIS_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_DIS_CHID3 = 0x8

	// SR: PWM Status Register
	// Position of CHID0 field.
	PWM_SR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_SR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_SR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_SR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_SR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_SR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_SR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_SR_CHID3 = 0x8

	// IER: PWM Interrupt Enable Register
	// Position of CHID0 field.
	PWM_IER_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IER_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IER_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IER_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IER_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IER_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IER_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IER_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IER_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IER_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IER_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IER_CHID3 = 0x8

	// IDR: PWM Interrupt Disable Register
	// Position of CHID0 field.
	PWM_IDR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IDR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IDR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IDR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IDR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IDR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IDR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IDR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IDR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IDR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IDR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IDR_CHID3 = 0x8

	// IMR: PWM Interrupt Mask Register
	// Position of CHID0 field.
	PWM_IMR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IMR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IMR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IMR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IMR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IMR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IMR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IMR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IMR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IMR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IMR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IMR_CHID3 = 0x8

	// ISR: PWM Interrupt Status Register
	// Position of CHID0 field.
	PWM_ISR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ISR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ISR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ISR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ISR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ISR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ISR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ISR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ISR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ISR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ISR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ISR_CHID3 = 0x8

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	// Position of CPRE field.
	PWM_CMR0_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR0_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR0_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR0_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR0_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR0_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR0_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR0_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR0_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR0_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR0_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR0_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR0_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR0_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR0_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR0_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR0_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR0_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR0_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR0_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR0_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR0_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR0_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR0_CPD = 0x400

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	// Position of CDTY field.
	PWM_CDTY0_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffffff

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	// Position of CPRD field.
	PWM_CPRD0_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffffff

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	// Position of CNT field.
	PWM_CCNT0_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffffff

	// CUPD0: PWM Channel Update Register (ch_num = 0)
	// Position of CUPD field.
	PWM_CUPD0_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD0_CUPD_Msk = 0xffffffff

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	// Position of CPRE field.
	PWM_CMR1_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR1_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR1_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR1_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR1_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR1_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR1_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR1_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR1_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR1_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR1_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR1_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR1_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR1_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR1_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR1_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR1_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR1_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR1_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR1_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR1_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR1_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR1_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR1_CPD = 0x400

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	// Position of CDTY field.
	PWM_CDTY1_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffffff

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	// Position of CPRD field.
	PWM_CPRD1_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffffff

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	// Position of CNT field.
	PWM_CCNT1_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffffff

	// CUPD1: PWM Channel Update Register (ch_num = 1)
	// Position of CUPD field.
	PWM_CUPD1_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD1_CUPD_Msk = 0xffffffff

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	// Position of CPRE field.
	PWM_CMR2_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR2_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR2_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR2_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR2_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR2_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR2_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR2_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR2_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR2_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR2_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR2_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR2_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR2_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR2_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR2_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR2_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR2_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR2_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR2_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR2_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR2_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR2_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR2_CPD = 0x400

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	// Position of CDTY field.
	PWM_CDTY2_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffffff

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	// Position of CPRD field.
	PWM_CPRD2_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffffff

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	// Position of CNT field.
	PWM_CCNT2_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffffff

	// CUPD2: PWM Channel Update Register (ch_num = 2)
	// Position of CUPD field.
	PWM_CUPD2_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD2_CUPD_Msk = 0xffffffff

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	// Position of CPRE field.
	PWM_CMR3_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR3_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR3_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR3_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR3_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR3_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR3_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR3_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR3_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR3_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR3_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR3_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR3_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR3_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR3_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR3_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR3_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR3_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR3_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR3_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR3_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR3_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR3_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR3_CPD = 0x400

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	// Position of CDTY field.
	PWM_CDTY3_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffffff

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	// Position of CPRD field.
	PWM_CPRD3_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffffff

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	// Position of CNT field.
	PWM_CCNT3_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffffff

	// CUPD3: PWM Channel Update Register (ch_num = 3)
	// Position of CUPD field.
	PWM_CUPD3_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD3_CUPD_Msk = 0xffffffff
)

// Bitfields for LCDC: LCD Controller
const (
	// LCDCFG0: LCD Controller Configuration Register 0
	// Position of CLKPOL field.
	LCDC_LCDCFG0_CLKPOL_Pos = 0x0
	// Bit mask of CLKPOL field.
	LCDC_LCDCFG0_CLKPOL_Msk = 0x1
	// Bit CLKPOL.
	LCDC_LCDCFG0_CLKPOL = 0x1
	// Position of CLKSEL field.
	LCDC_LCDCFG0_CLKSEL_Pos = 0x2
	// Bit mask of CLKSEL field.
	LCDC_LCDCFG0_CLKSEL_Msk = 0x4
	// Bit CLKSEL.
	LCDC_LCDCFG0_CLKSEL = 0x4
	// Position of CLKPWMSEL field.
	LCDC_LCDCFG0_CLKPWMSEL_Pos = 0x3
	// Bit mask of CLKPWMSEL field.
	LCDC_LCDCFG0_CLKPWMSEL_Msk = 0x8
	// Bit CLKPWMSEL.
	LCDC_LCDCFG0_CLKPWMSEL = 0x8
	// Position of CGDISBASE field.
	LCDC_LCDCFG0_CGDISBASE_Pos = 0x8
	// Bit mask of CGDISBASE field.
	LCDC_LCDCFG0_CGDISBASE_Msk = 0x100
	// Bit CGDISBASE.
	LCDC_LCDCFG0_CGDISBASE = 0x100
	// Position of CLKDIV field.
	LCDC_LCDCFG0_CLKDIV_Pos = 0x10
	// Bit mask of CLKDIV field.
	LCDC_LCDCFG0_CLKDIV_Msk = 0xff0000

	// LCDCFG1: LCD Controller Configuration Register 1
	// Position of HSPW field.
	LCDC_LCDCFG1_HSPW_Pos = 0x0
	// Bit mask of HSPW field.
	LCDC_LCDCFG1_HSPW_Msk = 0x3f
	// Position of VSPW field.
	LCDC_LCDCFG1_VSPW_Pos = 0x10
	// Bit mask of VSPW field.
	LCDC_LCDCFG1_VSPW_Msk = 0x3f0000

	// LCDCFG2: LCD Controller Configuration Register 2
	// Position of VFPW field.
	LCDC_LCDCFG2_VFPW_Pos = 0x0
	// Bit mask of VFPW field.
	LCDC_LCDCFG2_VFPW_Msk = 0x3f
	// Position of VBPW field.
	LCDC_LCDCFG2_VBPW_Pos = 0x10
	// Bit mask of VBPW field.
	LCDC_LCDCFG2_VBPW_Msk = 0x3f0000

	// LCDCFG3: LCD Controller Configuration Register 3
	// Position of HFPW field.
	LCDC_LCDCFG3_HFPW_Pos = 0x0
	// Bit mask of HFPW field.
	LCDC_LCDCFG3_HFPW_Msk = 0xff
	// Position of HBPW field.
	LCDC_LCDCFG3_HBPW_Pos = 0x10
	// Bit mask of HBPW field.
	LCDC_LCDCFG3_HBPW_Msk = 0xff0000

	// LCDCFG4: LCD Controller Configuration Register 4
	// Position of PPL field.
	LCDC_LCDCFG4_PPL_Pos = 0x0
	// Bit mask of PPL field.
	LCDC_LCDCFG4_PPL_Msk = 0x7ff
	// Position of RPF field.
	LCDC_LCDCFG4_RPF_Pos = 0x10
	// Bit mask of RPF field.
	LCDC_LCDCFG4_RPF_Msk = 0x7ff0000

	// LCDCFG5: LCD Controller Configuration Register 5
	// Position of HSPOL field.
	LCDC_LCDCFG5_HSPOL_Pos = 0x0
	// Bit mask of HSPOL field.
	LCDC_LCDCFG5_HSPOL_Msk = 0x1
	// Bit HSPOL.
	LCDC_LCDCFG5_HSPOL = 0x1
	// Position of VSPOL field.
	LCDC_LCDCFG5_VSPOL_Pos = 0x1
	// Bit mask of VSPOL field.
	LCDC_LCDCFG5_VSPOL_Msk = 0x2
	// Bit VSPOL.
	LCDC_LCDCFG5_VSPOL = 0x2
	// Position of VSPDLYS field.
	LCDC_LCDCFG5_VSPDLYS_Pos = 0x2
	// Bit mask of VSPDLYS field.
	LCDC_LCDCFG5_VSPDLYS_Msk = 0x4
	// Bit VSPDLYS.
	LCDC_LCDCFG5_VSPDLYS = 0x4
	// Position of VSPDLYE field.
	LCDC_LCDCFG5_VSPDLYE_Pos = 0x3
	// Bit mask of VSPDLYE field.
	LCDC_LCDCFG5_VSPDLYE_Msk = 0x8
	// Bit VSPDLYE.
	LCDC_LCDCFG5_VSPDLYE = 0x8
	// Position of DISPPOL field.
	LCDC_LCDCFG5_DISPPOL_Pos = 0x4
	// Bit mask of DISPPOL field.
	LCDC_LCDCFG5_DISPPOL_Msk = 0x10
	// Bit DISPPOL.
	LCDC_LCDCFG5_DISPPOL = 0x10
	// Position of DITHER field.
	LCDC_LCDCFG5_DITHER_Pos = 0x6
	// Bit mask of DITHER field.
	LCDC_LCDCFG5_DITHER_Msk = 0x40
	// Bit DITHER.
	LCDC_LCDCFG5_DITHER = 0x40
	// Position of DISPDLY field.
	LCDC_LCDCFG5_DISPDLY_Pos = 0x7
	// Bit mask of DISPDLY field.
	LCDC_LCDCFG5_DISPDLY_Msk = 0x80
	// Bit DISPDLY.
	LCDC_LCDCFG5_DISPDLY = 0x80
	// Position of MODE field.
	LCDC_LCDCFG5_MODE_Pos = 0x8
	// Bit mask of MODE field.
	LCDC_LCDCFG5_MODE_Msk = 0x300
	// LCD output mode is set to 12 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_12BPP = 0x0
	// LCD output mode is set to 16 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_16BPP = 0x1
	// LCD output mode is set to 18 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_18BPP = 0x2
	// LCD output mode is set to 24 bits per pixel
	LCDC_LCDCFG5_MODE_OUTPUT_24BPP = 0x3
	// Position of VSPSU field.
	LCDC_LCDCFG5_VSPSU_Pos = 0xc
	// Bit mask of VSPSU field.
	LCDC_LCDCFG5_VSPSU_Msk = 0x1000
	// Bit VSPSU.
	LCDC_LCDCFG5_VSPSU = 0x1000
	// Position of VSPHO field.
	LCDC_LCDCFG5_VSPHO_Pos = 0xd
	// Bit mask of VSPHO field.
	LCDC_LCDCFG5_VSPHO_Msk = 0x2000
	// Bit VSPHO.
	LCDC_LCDCFG5_VSPHO = 0x2000
	// Position of GUARDTIME field.
	LCDC_LCDCFG5_GUARDTIME_Pos = 0x10
	// Bit mask of GUARDTIME field.
	LCDC_LCDCFG5_GUARDTIME_Msk = 0x1f0000

	// LCDCFG6: LCD Controller Configuration Register 6
	// Position of PWMPS field.
	LCDC_LCDCFG6_PWMPS_Pos = 0x0
	// Bit mask of PWMPS field.
	LCDC_LCDCFG6_PWMPS_Msk = 0x7
	// Position of PWMPOL field.
	LCDC_LCDCFG6_PWMPOL_Pos = 0x4
	// Bit mask of PWMPOL field.
	LCDC_LCDCFG6_PWMPOL_Msk = 0x10
	// Bit PWMPOL.
	LCDC_LCDCFG6_PWMPOL = 0x10
	// Position of PWMCVAL field.
	LCDC_LCDCFG6_PWMCVAL_Pos = 0x8
	// Bit mask of PWMCVAL field.
	LCDC_LCDCFG6_PWMCVAL_Msk = 0xff00

	// LCDEN: LCD Controller Enable Register
	// Position of CLKEN field.
	LCDC_LCDEN_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	LCDC_LCDEN_CLKEN_Msk = 0x1
	// Bit CLKEN.
	LCDC_LCDEN_CLKEN = 0x1
	// Position of SYNCEN field.
	LCDC_LCDEN_SYNCEN_Pos = 0x1
	// Bit mask of SYNCEN field.
	LCDC_LCDEN_SYNCEN_Msk = 0x2
	// Bit SYNCEN.
	LCDC_LCDEN_SYNCEN = 0x2
	// Position of DISPEN field.
	LCDC_LCDEN_DISPEN_Pos = 0x2
	// Bit mask of DISPEN field.
	LCDC_LCDEN_DISPEN_Msk = 0x4
	// Bit DISPEN.
	LCDC_LCDEN_DISPEN = 0x4
	// Position of PWMEN field.
	LCDC_LCDEN_PWMEN_Pos = 0x3
	// Bit mask of PWMEN field.
	LCDC_LCDEN_PWMEN_Msk = 0x8
	// Bit PWMEN.
	LCDC_LCDEN_PWMEN = 0x8

	// LCDDIS: LCD Controller Disable Register
	// Position of CLKDIS field.
	LCDC_LCDDIS_CLKDIS_Pos = 0x0
	// Bit mask of CLKDIS field.
	LCDC_LCDDIS_CLKDIS_Msk = 0x1
	// Bit CLKDIS.
	LCDC_LCDDIS_CLKDIS = 0x1
	// Position of SYNCDIS field.
	LCDC_LCDDIS_SYNCDIS_Pos = 0x1
	// Bit mask of SYNCDIS field.
	LCDC_LCDDIS_SYNCDIS_Msk = 0x2
	// Bit SYNCDIS.
	LCDC_LCDDIS_SYNCDIS = 0x2
	// Position of DISPDIS field.
	LCDC_LCDDIS_DISPDIS_Pos = 0x2
	// Bit mask of DISPDIS field.
	LCDC_LCDDIS_DISPDIS_Msk = 0x4
	// Bit DISPDIS.
	LCDC_LCDDIS_DISPDIS = 0x4
	// Position of PWMDIS field.
	LCDC_LCDDIS_PWMDIS_Pos = 0x3
	// Bit mask of PWMDIS field.
	LCDC_LCDDIS_PWMDIS_Msk = 0x8
	// Bit PWMDIS.
	LCDC_LCDDIS_PWMDIS = 0x8
	// Position of CLKRST field.
	LCDC_LCDDIS_CLKRST_Pos = 0x8
	// Bit mask of CLKRST field.
	LCDC_LCDDIS_CLKRST_Msk = 0x100
	// Bit CLKRST.
	LCDC_LCDDIS_CLKRST = 0x100
	// Position of SYNCRST field.
	LCDC_LCDDIS_SYNCRST_Pos = 0x9
	// Bit mask of SYNCRST field.
	LCDC_LCDDIS_SYNCRST_Msk = 0x200
	// Bit SYNCRST.
	LCDC_LCDDIS_SYNCRST = 0x200
	// Position of DISPRST field.
	LCDC_LCDDIS_DISPRST_Pos = 0xa
	// Bit mask of DISPRST field.
	LCDC_LCDDIS_DISPRST_Msk = 0x400
	// Bit DISPRST.
	LCDC_LCDDIS_DISPRST = 0x400
	// Position of PWMRST field.
	LCDC_LCDDIS_PWMRST_Pos = 0xb
	// Bit mask of PWMRST field.
	LCDC_LCDDIS_PWMRST_Msk = 0x800
	// Bit PWMRST.
	LCDC_LCDDIS_PWMRST = 0x800

	// LCDSR: LCD Controller Status Register
	// Position of CLKSTS field.
	LCDC_LCDSR_CLKSTS_Pos = 0x0
	// Bit mask of CLKSTS field.
	LCDC_LCDSR_CLKSTS_Msk = 0x1
	// Bit CLKSTS.
	LCDC_LCDSR_CLKSTS = 0x1
	// Position of LCDSTS field.
	LCDC_LCDSR_LCDSTS_Pos = 0x1
	// Bit mask of LCDSTS field.
	LCDC_LCDSR_LCDSTS_Msk = 0x2
	// Bit LCDSTS.
	LCDC_LCDSR_LCDSTS = 0x2
	// Position of DISPSTS field.
	LCDC_LCDSR_DISPSTS_Pos = 0x2
	// Bit mask of DISPSTS field.
	LCDC_LCDSR_DISPSTS_Msk = 0x4
	// Bit DISPSTS.
	LCDC_LCDSR_DISPSTS = 0x4
	// Position of PWMSTS field.
	LCDC_LCDSR_PWMSTS_Pos = 0x3
	// Bit mask of PWMSTS field.
	LCDC_LCDSR_PWMSTS_Msk = 0x8
	// Bit PWMSTS.
	LCDC_LCDSR_PWMSTS = 0x8
	// Position of SIPSTS field.
	LCDC_LCDSR_SIPSTS_Pos = 0x4
	// Bit mask of SIPSTS field.
	LCDC_LCDSR_SIPSTS_Msk = 0x10
	// Bit SIPSTS.
	LCDC_LCDSR_SIPSTS = 0x10

	// LCDIER: LCD Controller Interrupt Enable Register
	// Position of SOFIE field.
	LCDC_LCDIER_SOFIE_Pos = 0x0
	// Bit mask of SOFIE field.
	LCDC_LCDIER_SOFIE_Msk = 0x1
	// Bit SOFIE.
	LCDC_LCDIER_SOFIE = 0x1
	// Position of DISIE field.
	LCDC_LCDIER_DISIE_Pos = 0x1
	// Bit mask of DISIE field.
	LCDC_LCDIER_DISIE_Msk = 0x2
	// Bit DISIE.
	LCDC_LCDIER_DISIE = 0x2
	// Position of DISPIE field.
	LCDC_LCDIER_DISPIE_Pos = 0x2
	// Bit mask of DISPIE field.
	LCDC_LCDIER_DISPIE_Msk = 0x4
	// Bit DISPIE.
	LCDC_LCDIER_DISPIE = 0x4
	// Position of FIFOERRIE field.
	LCDC_LCDIER_FIFOERRIE_Pos = 0x4
	// Bit mask of FIFOERRIE field.
	LCDC_LCDIER_FIFOERRIE_Msk = 0x10
	// Bit FIFOERRIE.
	LCDC_LCDIER_FIFOERRIE = 0x10
	// Position of BASEIE field.
	LCDC_LCDIER_BASEIE_Pos = 0x8
	// Bit mask of BASEIE field.
	LCDC_LCDIER_BASEIE_Msk = 0x100
	// Bit BASEIE.
	LCDC_LCDIER_BASEIE = 0x100

	// LCDIDR: LCD Controller Interrupt Disable Register
	// Position of SOFID field.
	LCDC_LCDIDR_SOFID_Pos = 0x0
	// Bit mask of SOFID field.
	LCDC_LCDIDR_SOFID_Msk = 0x1
	// Bit SOFID.
	LCDC_LCDIDR_SOFID = 0x1
	// Position of DISID field.
	LCDC_LCDIDR_DISID_Pos = 0x1
	// Bit mask of DISID field.
	LCDC_LCDIDR_DISID_Msk = 0x2
	// Bit DISID.
	LCDC_LCDIDR_DISID = 0x2
	// Position of DISPID field.
	LCDC_LCDIDR_DISPID_Pos = 0x2
	// Bit mask of DISPID field.
	LCDC_LCDIDR_DISPID_Msk = 0x4
	// Bit DISPID.
	LCDC_LCDIDR_DISPID = 0x4
	// Position of FIFOERRID field.
	LCDC_LCDIDR_FIFOERRID_Pos = 0x4
	// Bit mask of FIFOERRID field.
	LCDC_LCDIDR_FIFOERRID_Msk = 0x10
	// Bit FIFOERRID.
	LCDC_LCDIDR_FIFOERRID = 0x10
	// Position of BASEID field.
	LCDC_LCDIDR_BASEID_Pos = 0x8
	// Bit mask of BASEID field.
	LCDC_LCDIDR_BASEID_Msk = 0x100
	// Bit BASEID.
	LCDC_LCDIDR_BASEID = 0x100

	// LCDIMR: LCD Controller Interrupt Mask Register
	// Position of SOFIM field.
	LCDC_LCDIMR_SOFIM_Pos = 0x0
	// Bit mask of SOFIM field.
	LCDC_LCDIMR_SOFIM_Msk = 0x1
	// Bit SOFIM.
	LCDC_LCDIMR_SOFIM = 0x1
	// Position of DISIM field.
	LCDC_LCDIMR_DISIM_Pos = 0x1
	// Bit mask of DISIM field.
	LCDC_LCDIMR_DISIM_Msk = 0x2
	// Bit DISIM.
	LCDC_LCDIMR_DISIM = 0x2
	// Position of DISPIM field.
	LCDC_LCDIMR_DISPIM_Pos = 0x2
	// Bit mask of DISPIM field.
	LCDC_LCDIMR_DISPIM_Msk = 0x4
	// Bit DISPIM.
	LCDC_LCDIMR_DISPIM = 0x4
	// Position of FIFOERRIM field.
	LCDC_LCDIMR_FIFOERRIM_Pos = 0x4
	// Bit mask of FIFOERRIM field.
	LCDC_LCDIMR_FIFOERRIM_Msk = 0x10
	// Bit FIFOERRIM.
	LCDC_LCDIMR_FIFOERRIM = 0x10
	// Position of BASEIM field.
	LCDC_LCDIMR_BASEIM_Pos = 0x8
	// Bit mask of BASEIM field.
	LCDC_LCDIMR_BASEIM_Msk = 0x100
	// Bit BASEIM.
	LCDC_LCDIMR_BASEIM = 0x100

	// LCDISR: LCD Controller Interrupt Status Register
	// Position of SOF field.
	LCDC_LCDISR_SOF_Pos = 0x0
	// Bit mask of SOF field.
	LCDC_LCDISR_SOF_Msk = 0x1
	// Bit SOF.
	LCDC_LCDISR_SOF = 0x1
	// Position of DIS field.
	LCDC_LCDISR_DIS_Pos = 0x1
	// Bit mask of DIS field.
	LCDC_LCDISR_DIS_Msk = 0x2
	// Bit DIS.
	LCDC_LCDISR_DIS = 0x2
	// Position of DISP field.
	LCDC_LCDISR_DISP_Pos = 0x2
	// Bit mask of DISP field.
	LCDC_LCDISR_DISP_Msk = 0x4
	// Bit DISP.
	LCDC_LCDISR_DISP = 0x4
	// Position of FIFOERR field.
	LCDC_LCDISR_FIFOERR_Pos = 0x4
	// Bit mask of FIFOERR field.
	LCDC_LCDISR_FIFOERR_Msk = 0x10
	// Bit FIFOERR.
	LCDC_LCDISR_FIFOERR = 0x10
	// Position of BASE field.
	LCDC_LCDISR_BASE_Pos = 0x8
	// Bit mask of BASE field.
	LCDC_LCDISR_BASE_Msk = 0x100
	// Bit BASE.
	LCDC_LCDISR_BASE = 0x100

	// BASECHER: Base Layer Channel Enable Register
	// Position of CHEN field.
	LCDC_BASECHER_CHEN_Pos = 0x0
	// Bit mask of CHEN field.
	LCDC_BASECHER_CHEN_Msk = 0x1
	// Bit CHEN.
	LCDC_BASECHER_CHEN = 0x1
	// Position of UPDATEEN field.
	LCDC_BASECHER_UPDATEEN_Pos = 0x1
	// Bit mask of UPDATEEN field.
	LCDC_BASECHER_UPDATEEN_Msk = 0x2
	// Bit UPDATEEN.
	LCDC_BASECHER_UPDATEEN = 0x2
	// Position of A2QEN field.
	LCDC_BASECHER_A2QEN_Pos = 0x2
	// Bit mask of A2QEN field.
	LCDC_BASECHER_A2QEN_Msk = 0x4
	// Bit A2QEN.
	LCDC_BASECHER_A2QEN = 0x4

	// BASECHDR: Base Layer Channel Disable Register
	// Position of CHDIS field.
	LCDC_BASECHDR_CHDIS_Pos = 0x0
	// Bit mask of CHDIS field.
	LCDC_BASECHDR_CHDIS_Msk = 0x1
	// Bit CHDIS.
	LCDC_BASECHDR_CHDIS = 0x1
	// Position of CHRST field.
	LCDC_BASECHDR_CHRST_Pos = 0x8
	// Bit mask of CHRST field.
	LCDC_BASECHDR_CHRST_Msk = 0x100
	// Bit CHRST.
	LCDC_BASECHDR_CHRST = 0x100

	// BASECHSR: Base Layer Channel Status Register
	// Position of CHSR field.
	LCDC_BASECHSR_CHSR_Pos = 0x0
	// Bit mask of CHSR field.
	LCDC_BASECHSR_CHSR_Msk = 0x1
	// Bit CHSR.
	LCDC_BASECHSR_CHSR = 0x1
	// Position of UPDATESR field.
	LCDC_BASECHSR_UPDATESR_Pos = 0x1
	// Bit mask of UPDATESR field.
	LCDC_BASECHSR_UPDATESR_Msk = 0x2
	// Bit UPDATESR.
	LCDC_BASECHSR_UPDATESR = 0x2
	// Position of A2QSR field.
	LCDC_BASECHSR_A2QSR_Pos = 0x2
	// Bit mask of A2QSR field.
	LCDC_BASECHSR_A2QSR_Msk = 0x4
	// Bit A2QSR.
	LCDC_BASECHSR_A2QSR = 0x4

	// BASEIER: Base Layer Interrupt Enable Register
	// Position of DMA field.
	LCDC_BASEIER_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEIER_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEIER_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEIER_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEIER_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEIER_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEIER_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEIER_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEIER_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEIER_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEIER_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEIER_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEIER_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEIER_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEIER_OVR = 0x40

	// BASEIDR: Base Layer Interrupt Disabled Register
	// Position of DMA field.
	LCDC_BASEIDR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEIDR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEIDR_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEIDR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEIDR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEIDR_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEIDR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEIDR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEIDR_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEIDR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEIDR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEIDR_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEIDR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEIDR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEIDR_OVR = 0x40

	// BASEIMR: Base Layer Interrupt Mask Register
	// Position of DMA field.
	LCDC_BASEIMR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEIMR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEIMR_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEIMR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEIMR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEIMR_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEIMR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEIMR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEIMR_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEIMR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEIMR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEIMR_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEIMR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEIMR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEIMR_OVR = 0x40

	// BASEISR: Base Layer Interrupt status Register
	// Position of DMA field.
	LCDC_BASEISR_DMA_Pos = 0x2
	// Bit mask of DMA field.
	LCDC_BASEISR_DMA_Msk = 0x4
	// Bit DMA.
	LCDC_BASEISR_DMA = 0x4
	// Position of DSCR field.
	LCDC_BASEISR_DSCR_Pos = 0x3
	// Bit mask of DSCR field.
	LCDC_BASEISR_DSCR_Msk = 0x8
	// Bit DSCR.
	LCDC_BASEISR_DSCR = 0x8
	// Position of ADD field.
	LCDC_BASEISR_ADD_Pos = 0x4
	// Bit mask of ADD field.
	LCDC_BASEISR_ADD_Msk = 0x10
	// Bit ADD.
	LCDC_BASEISR_ADD = 0x10
	// Position of DONE field.
	LCDC_BASEISR_DONE_Pos = 0x5
	// Bit mask of DONE field.
	LCDC_BASEISR_DONE_Msk = 0x20
	// Bit DONE.
	LCDC_BASEISR_DONE = 0x20
	// Position of OVR field.
	LCDC_BASEISR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	LCDC_BASEISR_OVR_Msk = 0x40
	// Bit OVR.
	LCDC_BASEISR_OVR = 0x40

	// BASEHEAD: Base Layer DMA Head Register
	// Position of HEAD field.
	LCDC_BASEHEAD_HEAD_Pos = 0x2
	// Bit mask of HEAD field.
	LCDC_BASEHEAD_HEAD_Msk = 0xfffffffc

	// BASEADDR: Base Layer DMA Address Register
	// Position of ADDR field.
	LCDC_BASEADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	LCDC_BASEADDR_ADDR_Msk = 0xffffffff

	// BASECTRL: Base Layer DMA Control Register
	// Position of DFETCH field.
	LCDC_BASECTRL_DFETCH_Pos = 0x0
	// Bit mask of DFETCH field.
	LCDC_BASECTRL_DFETCH_Msk = 0x1
	// Bit DFETCH.
	LCDC_BASECTRL_DFETCH = 0x1
	// Position of LFETCH field.
	LCDC_BASECTRL_LFETCH_Pos = 0x1
	// Bit mask of LFETCH field.
	LCDC_BASECTRL_LFETCH_Msk = 0x2
	// Bit LFETCH.
	LCDC_BASECTRL_LFETCH = 0x2
	// Position of DMAIEN field.
	LCDC_BASECTRL_DMAIEN_Pos = 0x2
	// Bit mask of DMAIEN field.
	LCDC_BASECTRL_DMAIEN_Msk = 0x4
	// Bit DMAIEN.
	LCDC_BASECTRL_DMAIEN = 0x4
	// Position of DSCRIEN field.
	LCDC_BASECTRL_DSCRIEN_Pos = 0x3
	// Bit mask of DSCRIEN field.
	LCDC_BASECTRL_DSCRIEN_Msk = 0x8
	// Bit DSCRIEN.
	LCDC_BASECTRL_DSCRIEN = 0x8
	// Position of ADDIEN field.
	LCDC_BASECTRL_ADDIEN_Pos = 0x4
	// Bit mask of ADDIEN field.
	LCDC_BASECTRL_ADDIEN_Msk = 0x10
	// Bit ADDIEN.
	LCDC_BASECTRL_ADDIEN = 0x10
	// Position of DONEIEN field.
	LCDC_BASECTRL_DONEIEN_Pos = 0x5
	// Bit mask of DONEIEN field.
	LCDC_BASECTRL_DONEIEN_Msk = 0x20
	// Bit DONEIEN.
	LCDC_BASECTRL_DONEIEN = 0x20

	// BASENEXT: Base Layer DMA Next Register
	// Position of NEXT field.
	LCDC_BASENEXT_NEXT_Pos = 0x0
	// Bit mask of NEXT field.
	LCDC_BASENEXT_NEXT_Msk = 0xffffffff

	// BASECFG0: Base Layer Configuration Register 0
	// Position of BLEN field.
	LCDC_BASECFG0_BLEN_Pos = 0x4
	// Bit mask of BLEN field.
	LCDC_BASECFG0_BLEN_Msk = 0x30
	// AHB Access is started as soon as there is enough space in the FIFO to store one 32-bit data. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_SINGLE = 0x0
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of four 32-bit data. An AHB INCR4 Burst is preferred. SINGLE, INCR and INCR4 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR4 = 0x1
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of eight 32-bit data. An AHB INCR8 Burst is preferred. SINGLE, INCR, INCR4 and INCR8 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR8 = 0x2
	// AHB Access is started as soon as there is enough space in the FIFO to store a total amount of sixteen 32-bit data. An AHB INCR16 Burst is preferred. SINGLE, INCR, INCR4, INCR8 and INCR16 bursts can be used. INCR is used for a burst of 2 and 3 beats.
	LCDC_BASECFG0_BLEN_AHB_INCR16 = 0x3
	// Position of DLBO field.
	LCDC_BASECFG0_DLBO_Pos = 0x8
	// Bit mask of DLBO field.
	LCDC_BASECFG0_DLBO_Msk = 0x100
	// Bit DLBO.
	LCDC_BASECFG0_DLBO = 0x100

	// BASECFG1: Base Layer Configuration Register 1
	// Position of CLUTEN field.
	LCDC_BASECFG1_CLUTEN_Pos = 0x0
	// Bit mask of CLUTEN field.
	LCDC_BASECFG1_CLUTEN_Msk = 0x1
	// Bit CLUTEN.
	LCDC_BASECFG1_CLUTEN = 0x1
	// Position of RGBMODE field.
	LCDC_BASECFG1_RGBMODE_Pos = 0x4
	// Bit mask of RGBMODE field.
	LCDC_BASECFG1_RGBMODE_Msk = 0xf0
	// 12 bpp RGB 444
	LCDC_BASECFG1_RGBMODE_12BPP_RGB_444 = 0x0
	// 16 bpp ARGB 4444
	LCDC_BASECFG1_RGBMODE_16BPP_ARGB_4444 = 0x1
	// 16 bpp RGBA 4444
	LCDC_BASECFG1_RGBMODE_16BPP_RGBA_4444 = 0x2
	// 16 bpp RGB 565
	LCDC_BASECFG1_RGBMODE_16BPP_RGB_565 = 0x3
	// 16 bpp TRGB 1555
	LCDC_BASECFG1_RGBMODE_16BPP_TRGB_1555 = 0x4
	// 18 bpp RGB 666
	LCDC_BASECFG1_RGBMODE_18BPP_RGB_666 = 0x5
	// 18 bpp RGB 666 PACKED
	LCDC_BASECFG1_RGBMODE_18BPP_RGB_666_PACKED = 0x6
	// 19 bpp TRGB 1666
	LCDC_BASECFG1_RGBMODE_19BPP_TRGB_1666 = 0x7
	// 19 bpp TRGB 1666 PACKED
	LCDC_BASECFG1_RGBMODE_19BPP_TRGB_PACKED = 0x8
	// 24 bpp RGB 888
	LCDC_BASECFG1_RGBMODE_24BPP_RGB_888 = 0x9
	// 24 bpp RGB 888 PACKED
	LCDC_BASECFG1_RGBMODE_24BPP_RGB_888_PACKED = 0xa
	// 25 bpp TRGB 1888
	LCDC_BASECFG1_RGBMODE_25BPP_TRGB_1888 = 0xb
	// 32 bpp ARGB 8888
	LCDC_BASECFG1_RGBMODE_32BPP_ARGB_8888 = 0xc
	// 32 bpp RGBA 8888
	LCDC_BASECFG1_RGBMODE_32BPP_RGBA_8888 = 0xd
	// Position of CLUTMODE field.
	LCDC_BASECFG1_CLUTMODE_Pos = 0x8
	// Bit mask of CLUTMODE field.
	LCDC_BASECFG1_CLUTMODE_Msk = 0x300
	// color lookup table mode set to 1 bit per pixel
	LCDC_BASECFG1_CLUTMODE_1BPP = 0x0
	// color lookup table mode set to 2 bits per pixel
	LCDC_BASECFG1_CLUTMODE_2BPP = 0x1
	// color lookup table mode set to 4 bits per pixel
	LCDC_BASECFG1_CLUTMODE_4BPP = 0x2
	// color lookup table mode set to 8 bits per pixel
	LCDC_BASECFG1_CLUTMODE_8BPP = 0x3

	// BASECFG2: Base Layer Configuration Register 2
	// Position of XSTRIDE field.
	LCDC_BASECFG2_XSTRIDE_Pos = 0x0
	// Bit mask of XSTRIDE field.
	LCDC_BASECFG2_XSTRIDE_Msk = 0xffffffff

	// BASECFG3: Base Layer Configuration Register 3
	// Position of BDEF field.
	LCDC_BASECFG3_BDEF_Pos = 0x0
	// Bit mask of BDEF field.
	LCDC_BASECFG3_BDEF_Msk = 0xff
	// Position of GDEF field.
	LCDC_BASECFG3_GDEF_Pos = 0x8
	// Bit mask of GDEF field.
	LCDC_BASECFG3_GDEF_Msk = 0xff00
	// Position of RDEF field.
	LCDC_BASECFG3_RDEF_Pos = 0x10
	// Bit mask of RDEF field.
	LCDC_BASECFG3_RDEF_Msk = 0xff0000

	// BASECFG4: Base Layer Configuration Register 4
	// Position of DMA field.
	LCDC_BASECFG4_DMA_Pos = 0x8
	// Bit mask of DMA field.
	LCDC_BASECFG4_DMA_Msk = 0x100
	// Bit DMA.
	LCDC_BASECFG4_DMA = 0x100
	// Position of REP field.
	LCDC_BASECFG4_REP_Pos = 0x9
	// Bit mask of REP field.
	LCDC_BASECFG4_REP_Msk = 0x200
	// Bit REP.
	LCDC_BASECFG4_REP = 0x200

	// BASECLUT: Base CLUT Register
	// Position of BCLUT field.
	LCDC_BASECLUT_BCLUT_Pos = 0x0
	// Bit mask of BCLUT field.
	LCDC_BASECLUT_BCLUT_Msk = 0xff
	// Position of GCLUT field.
	LCDC_BASECLUT_GCLUT_Pos = 0x8
	// Bit mask of GCLUT field.
	LCDC_BASECLUT_GCLUT_Msk = 0xff00
	// Position of RCLUT field.
	LCDC_BASECLUT_RCLUT_Pos = 0x10
	// Bit mask of RCLUT field.
	LCDC_BASECLUT_RCLUT_Msk = 0xff0000
)

// Bitfields for UDP: USB Device Port
const (
	// FRM_NUM: Frame Number Register
	// Position of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Pos = 0x0
	// Bit mask of FRM_NUM field.
	UDP_FRM_NUM_FRM_NUM_Msk = 0x7ff
	// Position of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Pos = 0x10
	// Bit mask of FRM_ERR field.
	UDP_FRM_NUM_FRM_ERR_Msk = 0x10000
	// Bit FRM_ERR.
	UDP_FRM_NUM_FRM_ERR = 0x10000
	// Position of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Pos = 0x11
	// Bit mask of FRM_OK field.
	UDP_FRM_NUM_FRM_OK_Msk = 0x20000
	// Bit FRM_OK.
	UDP_FRM_NUM_FRM_OK = 0x20000

	// GLB_STAT: Global State Register
	// Position of FADDEN field.
	UDP_GLB_STAT_FADDEN_Pos = 0x0
	// Bit mask of FADDEN field.
	UDP_GLB_STAT_FADDEN_Msk = 0x1
	// Bit FADDEN.
	UDP_GLB_STAT_FADDEN = 0x1
	// Position of CONFG field.
	UDP_GLB_STAT_CONFG_Pos = 0x1
	// Bit mask of CONFG field.
	UDP_GLB_STAT_CONFG_Msk = 0x2
	// Bit CONFG.
	UDP_GLB_STAT_CONFG = 0x2
	// Position of ESR field.
	UDP_GLB_STAT_ESR_Pos = 0x2
	// Bit mask of ESR field.
	UDP_GLB_STAT_ESR_Msk = 0x4
	// Bit ESR.
	UDP_GLB_STAT_ESR = 0x4
	// Position of RSMINPR field.
	UDP_GLB_STAT_RSMINPR_Pos = 0x3
	// Bit mask of RSMINPR field.
	UDP_GLB_STAT_RSMINPR_Msk = 0x8
	// Bit RSMINPR.
	UDP_GLB_STAT_RSMINPR = 0x8
	// Position of RMWUPE field.
	UDP_GLB_STAT_RMWUPE_Pos = 0x4
	// Bit mask of RMWUPE field.
	UDP_GLB_STAT_RMWUPE_Msk = 0x10
	// Bit RMWUPE.
	UDP_GLB_STAT_RMWUPE = 0x10

	// FADDR: Function Address Register
	// Position of FADD field.
	UDP_FADDR_FADD_Pos = 0x0
	// Bit mask of FADD field.
	UDP_FADDR_FADD_Msk = 0x7f
	// Position of FEN field.
	UDP_FADDR_FEN_Pos = 0x8
	// Bit mask of FEN field.
	UDP_FADDR_FEN_Msk = 0x100
	// Bit FEN.
	UDP_FADDR_FEN = 0x100

	// IER: Interrupt Enable Register
	// Position of EP0INT field.
	UDP_IER_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IER_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IER_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IER_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IER_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IER_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IER_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IER_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IER_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IER_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IER_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IER_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IER_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IER_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IER_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IER_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IER_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IER_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IER_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IER_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IER_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IER_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IER_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IER_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_IER_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_IER_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_IER_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_IER_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IER_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IER_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IER_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IER_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IER_WAKEUP = 0x2000

	// IDR: Interrupt Disable Register
	// Position of EP0INT field.
	UDP_IDR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IDR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IDR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IDR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IDR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IDR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IDR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IDR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IDR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IDR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IDR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IDR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IDR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IDR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IDR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IDR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IDR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IDR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IDR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IDR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IDR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IDR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IDR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IDR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_IDR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_IDR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_IDR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_IDR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IDR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IDR_SOFINT = 0x800
	// Position of WAKEUP field.
	UDP_IDR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IDR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IDR_WAKEUP = 0x2000

	// IMR: Interrupt Mask Register
	// Position of EP0INT field.
	UDP_IMR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_IMR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_IMR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_IMR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_IMR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_IMR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_IMR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_IMR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_IMR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_IMR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_IMR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_IMR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_IMR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_IMR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_IMR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_IMR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_IMR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_IMR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_IMR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_IMR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_IMR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_IMR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_IMR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_IMR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_IMR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_IMR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_IMR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_IMR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_IMR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_IMR_SOFINT = 0x800
	// Position of BIT12 field.
	UDP_IMR_BIT12_Pos = 0xc
	// Bit mask of BIT12 field.
	UDP_IMR_BIT12_Msk = 0x1000
	// Bit BIT12.
	UDP_IMR_BIT12 = 0x1000
	// Position of WAKEUP field.
	UDP_IMR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_IMR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_IMR_WAKEUP = 0x2000

	// ISR: Interrupt Status Register
	// Position of EP0INT field.
	UDP_ISR_EP0INT_Pos = 0x0
	// Bit mask of EP0INT field.
	UDP_ISR_EP0INT_Msk = 0x1
	// Bit EP0INT.
	UDP_ISR_EP0INT = 0x1
	// Position of EP1INT field.
	UDP_ISR_EP1INT_Pos = 0x1
	// Bit mask of EP1INT field.
	UDP_ISR_EP1INT_Msk = 0x2
	// Bit EP1INT.
	UDP_ISR_EP1INT = 0x2
	// Position of EP2INT field.
	UDP_ISR_EP2INT_Pos = 0x2
	// Bit mask of EP2INT field.
	UDP_ISR_EP2INT_Msk = 0x4
	// Bit EP2INT.
	UDP_ISR_EP2INT = 0x4
	// Position of EP3INT field.
	UDP_ISR_EP3INT_Pos = 0x3
	// Bit mask of EP3INT field.
	UDP_ISR_EP3INT_Msk = 0x8
	// Bit EP3INT.
	UDP_ISR_EP3INT = 0x8
	// Position of EP4INT field.
	UDP_ISR_EP4INT_Pos = 0x4
	// Bit mask of EP4INT field.
	UDP_ISR_EP4INT_Msk = 0x10
	// Bit EP4INT.
	UDP_ISR_EP4INT = 0x10
	// Position of EP5INT field.
	UDP_ISR_EP5INT_Pos = 0x5
	// Bit mask of EP5INT field.
	UDP_ISR_EP5INT_Msk = 0x20
	// Bit EP5INT.
	UDP_ISR_EP5INT = 0x20
	// Position of RXSUSP field.
	UDP_ISR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ISR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ISR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ISR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ISR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ISR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_ISR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_ISR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_ISR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_ISR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ISR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ISR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ISR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ISR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ISR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ISR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ISR_WAKEUP = 0x2000

	// ICR: Interrupt Clear Register
	// Position of RXSUSP field.
	UDP_ICR_RXSUSP_Pos = 0x8
	// Bit mask of RXSUSP field.
	UDP_ICR_RXSUSP_Msk = 0x100
	// Bit RXSUSP.
	UDP_ICR_RXSUSP = 0x100
	// Position of RXRSM field.
	UDP_ICR_RXRSM_Pos = 0x9
	// Bit mask of RXRSM field.
	UDP_ICR_RXRSM_Msk = 0x200
	// Bit RXRSM.
	UDP_ICR_RXRSM = 0x200
	// Position of EXTRSM field.
	UDP_ICR_EXTRSM_Pos = 0xa
	// Bit mask of EXTRSM field.
	UDP_ICR_EXTRSM_Msk = 0x400
	// Bit EXTRSM.
	UDP_ICR_EXTRSM = 0x400
	// Position of SOFINT field.
	UDP_ICR_SOFINT_Pos = 0xb
	// Bit mask of SOFINT field.
	UDP_ICR_SOFINT_Msk = 0x800
	// Bit SOFINT.
	UDP_ICR_SOFINT = 0x800
	// Position of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Pos = 0xc
	// Bit mask of ENDBUSRES field.
	UDP_ICR_ENDBUSRES_Msk = 0x1000
	// Bit ENDBUSRES.
	UDP_ICR_ENDBUSRES = 0x1000
	// Position of WAKEUP field.
	UDP_ICR_WAKEUP_Pos = 0xd
	// Bit mask of WAKEUP field.
	UDP_ICR_WAKEUP_Msk = 0x2000
	// Bit WAKEUP.
	UDP_ICR_WAKEUP = 0x2000

	// RST_EP: Reset Endpoint Register
	// Position of EP0 field.
	UDP_RST_EP_EP0_Pos = 0x0
	// Bit mask of EP0 field.
	UDP_RST_EP_EP0_Msk = 0x1
	// Bit EP0.
	UDP_RST_EP_EP0 = 0x1
	// Position of EP1 field.
	UDP_RST_EP_EP1_Pos = 0x1
	// Bit mask of EP1 field.
	UDP_RST_EP_EP1_Msk = 0x2
	// Bit EP1.
	UDP_RST_EP_EP1 = 0x2
	// Position of EP2 field.
	UDP_RST_EP_EP2_Pos = 0x2
	// Bit mask of EP2 field.
	UDP_RST_EP_EP2_Msk = 0x4
	// Bit EP2.
	UDP_RST_EP_EP2 = 0x4
	// Position of EP3 field.
	UDP_RST_EP_EP3_Pos = 0x3
	// Bit mask of EP3 field.
	UDP_RST_EP_EP3_Msk = 0x8
	// Bit EP3.
	UDP_RST_EP_EP3 = 0x8
	// Position of EP4 field.
	UDP_RST_EP_EP4_Pos = 0x4
	// Bit mask of EP4 field.
	UDP_RST_EP_EP4_Msk = 0x10
	// Bit EP4.
	UDP_RST_EP_EP4 = 0x10
	// Position of EP5 field.
	UDP_RST_EP_EP5_Pos = 0x5
	// Bit mask of EP5 field.
	UDP_RST_EP_EP5_Msk = 0x20
	// Bit EP5.
	UDP_RST_EP_EP5 = 0x20

	// CSR: Endpoint Control and Status Register
	// Position of TXCOMP field.
	UDP_CSR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR_RXSETUP = 0x4
	// Position of STALLSENT field.
	UDP_CSR_STALLSENT_Pos = 0x3
	// Bit mask of STALLSENT field.
	UDP_CSR_STALLSENT_Msk = 0x8
	// Bit STALLSENT.
	UDP_CSR_STALLSENT = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR_EPTYPE_Msk = 0x700
	// Control
	UDP_CSR_EPTYPE_CTRL = 0x0
	// Isochronous OUT
	UDP_CSR_EPTYPE_ISO_OUT = 0x1
	// Bulk OUT
	UDP_CSR_EPTYPE_BULK_OUT = 0x2
	// Interrupt OUT
	UDP_CSR_EPTYPE_INT_OUT = 0x3
	// Isochronous IN
	UDP_CSR_EPTYPE_ISO_IN = 0x5
	// Bulk IN
	UDP_CSR_EPTYPE_BULK_IN = 0x6
	// Interrupt IN
	UDP_CSR_EPTYPE_INT_IN = 0x7
	// Position of DTGLE field.
	UDP_CSR_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR_RXBYTECNT_Msk = 0x7ff0000

	// CSR0_ISOENDPT: Endpoint Control and Status Register
	// Position of TXCOMP field.
	UDP_CSR0_ISOENDPT_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	UDP_CSR0_ISOENDPT_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	UDP_CSR0_ISOENDPT_TXCOMP = 0x1
	// Position of RX_DATA_BK0 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0_Pos = 0x1
	// Bit mask of RX_DATA_BK0 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0_Msk = 0x2
	// Bit RX_DATA_BK0.
	UDP_CSR0_ISOENDPT_RX_DATA_BK0 = 0x2
	// Position of RXSETUP field.
	UDP_CSR0_ISOENDPT_RXSETUP_Pos = 0x2
	// Bit mask of RXSETUP field.
	UDP_CSR0_ISOENDPT_RXSETUP_Msk = 0x4
	// Bit RXSETUP.
	UDP_CSR0_ISOENDPT_RXSETUP = 0x4
	// Position of ISOERROR field.
	UDP_CSR0_ISOENDPT_ISOERROR_Pos = 0x3
	// Bit mask of ISOERROR field.
	UDP_CSR0_ISOENDPT_ISOERROR_Msk = 0x8
	// Bit ISOERROR.
	UDP_CSR0_ISOENDPT_ISOERROR = 0x8
	// Position of TXPKTRDY field.
	UDP_CSR0_ISOENDPT_TXPKTRDY_Pos = 0x4
	// Bit mask of TXPKTRDY field.
	UDP_CSR0_ISOENDPT_TXPKTRDY_Msk = 0x10
	// Bit TXPKTRDY.
	UDP_CSR0_ISOENDPT_TXPKTRDY = 0x10
	// Position of FORCESTALL field.
	UDP_CSR0_ISOENDPT_FORCESTALL_Pos = 0x5
	// Bit mask of FORCESTALL field.
	UDP_CSR0_ISOENDPT_FORCESTALL_Msk = 0x20
	// Bit FORCESTALL.
	UDP_CSR0_ISOENDPT_FORCESTALL = 0x20
	// Position of RX_DATA_BK1 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1_Pos = 0x6
	// Bit mask of RX_DATA_BK1 field.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1_Msk = 0x40
	// Bit RX_DATA_BK1.
	UDP_CSR0_ISOENDPT_RX_DATA_BK1 = 0x40
	// Position of DIR field.
	UDP_CSR0_ISOENDPT_DIR_Pos = 0x7
	// Bit mask of DIR field.
	UDP_CSR0_ISOENDPT_DIR_Msk = 0x80
	// Bit DIR.
	UDP_CSR0_ISOENDPT_DIR = 0x80
	// Position of EPTYPE field.
	UDP_CSR0_ISOENDPT_EPTYPE_Pos = 0x8
	// Bit mask of EPTYPE field.
	UDP_CSR0_ISOENDPT_EPTYPE_Msk = 0x700
	// Control
	UDP_CSR0_ISOENDPT_EPTYPE_CTRL = 0x0
	// Isochronous OUT
	UDP_CSR0_ISOENDPT_EPTYPE_ISO_OUT = 0x1
	// Isochronous IN
	UDP_CSR0_ISOENDPT_EPTYPE_ISO_IN = 0x5
	// Bulk OUT
	UDP_CSR0_ISOENDPT_EPTYPE_BULK_OUT = 0x2
	// Bulk IN
	UDP_CSR0_ISOENDPT_EPTYPE_BULK_IN = 0x6
	// Interrupt OUT
	UDP_CSR0_ISOENDPT_EPTYPE_INT_OUT = 0x3
	// Interrupt IN
	UDP_CSR0_ISOENDPT_EPTYPE_INT_IN = 0x7
	// Position of DTGLE field.
	UDP_CSR0_ISOENDPT_DTGLE_Pos = 0xb
	// Bit mask of DTGLE field.
	UDP_CSR0_ISOENDPT_DTGLE_Msk = 0x800
	// Bit DTGLE.
	UDP_CSR0_ISOENDPT_DTGLE = 0x800
	// Position of EPEDS field.
	UDP_CSR0_ISOENDPT_EPEDS_Pos = 0xf
	// Bit mask of EPEDS field.
	UDP_CSR0_ISOENDPT_EPEDS_Msk = 0x8000
	// Bit EPEDS.
	UDP_CSR0_ISOENDPT_EPEDS = 0x8000
	// Position of RXBYTECNT field.
	UDP_CSR0_ISOENDPT_RXBYTECNT_Pos = 0x10
	// Bit mask of RXBYTECNT field.
	UDP_CSR0_ISOENDPT_RXBYTECNT_Msk = 0x7ff0000

	// FDR: Endpoint FIFO Data Register
	// Position of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Pos = 0x0
	// Bit mask of FIFO_DATA field.
	UDP_FDR_FIFO_DATA_Msk = 0xff

	// TXVC: Transceiver Control Register
	// Position of TXVDIS field.
	UDP_TXVC_TXVDIS_Pos = 0x8
	// Bit mask of TXVDIS field.
	UDP_TXVC_TXVDIS_Msk = 0x100
	// Bit TXVDIS.
	UDP_TXVC_TXVDIS = 0x100
	// Position of PUON field.
	UDP_TXVC_PUON_Pos = 0x9
	// Bit mask of PUON field.
	UDP_TXVC_PUON_Msk = 0x200
	// Bit PUON.
	UDP_TXVC_PUON = 0x200
)

// Bitfields for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	UART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	UART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	UART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	UART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	UART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	UART_CR_RSTTX = 0x8
	// Position of RXEN field.
	UART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	UART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	UART_CR_RXEN = 0x10
	// Position of RXDIS field.
	UART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	UART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	UART_CR_RXDIS = 0x20
	// Position of TXEN field.
	UART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	UART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	UART_CR_TXEN = 0x40
	// Position of TXDIS field.
	UART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	UART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	UART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	UART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	UART_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	UART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	UART_MR_PAR_Msk = 0xe00
	// Even parity
	UART_MR_PAR_EVEN = 0x0
	// Odd parity
	UART_MR_PAR_ODD = 0x1
	// Space: parity forced to 0
	UART_MR_PAR_SPACE = 0x2
	// Mark: parity forced to 1
	UART_MR_PAR_MARK = 0x3
	// No parity
	UART_MR_PAR_NO = 0x4
	// Position of CHMODE field.
	UART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	UART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	UART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo
	UART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback
	UART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	UART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IER_TXRDY = 0x2
	// Position of OVRE field.
	UART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IER_OVRE = 0x20
	// Position of FRAME field.
	UART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IER_FRAME = 0x40
	// Position of PARE field.
	UART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IER_PARE_Msk = 0x80
	// Bit PARE.
	UART_IER_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IER_TXEMPTY = 0x200

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	UART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IDR_TXRDY = 0x2
	// Position of OVRE field.
	UART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IDR_OVRE = 0x20
	// Position of FRAME field.
	UART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IDR_FRAME = 0x40
	// Position of PARE field.
	UART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IDR_TXEMPTY = 0x200

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	UART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IMR_TXRDY = 0x2
	// Position of OVRE field.
	UART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IMR_OVRE = 0x20
	// Position of FRAME field.
	UART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IMR_FRAME = 0x40
	// Position of PARE field.
	UART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IMR_TXEMPTY = 0x200

	// SR: Status Register
	// Position of RXRDY field.
	UART_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_SR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_SR_TXRDY = 0x2
	// Position of OVRE field.
	UART_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_SR_OVRE = 0x20
	// Position of FRAME field.
	UART_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_SR_FRAME = 0x40
	// Position of PARE field.
	UART_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_SR_PARE_Msk = 0x80
	// Bit PARE.
	UART_SR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_SR_TXEMPTY = 0x200

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	UART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	UART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	UART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	UART_BRGR_CD_Msk = 0xffff
)

// Bitfields for TRNG: True Random Number Generator
const (
	// CR: Control Register
	// Position of ENABLE field.
	TRNG_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TRNG_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	TRNG_CR_ENABLE = 0x1
	// Position of KEY field.
	TRNG_CR_KEY_Pos = 0x8
	// Bit mask of KEY field.
	TRNG_CR_KEY_Msk = 0xffffff00

	// IER: Interrupt Enable Register
	// Position of DATRDY field.
	TRNG_IER_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IER_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IER_DATRDY = 0x1

	// IDR: Interrupt Disable Register
	// Position of DATRDY field.
	TRNG_IDR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IDR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IDR_DATRDY = 0x1

	// IMR: Interrupt Mask Register
	// Position of DATRDY field.
	TRNG_IMR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_IMR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_IMR_DATRDY = 0x1

	// ISR: Interrupt Status Register
	// Position of DATRDY field.
	TRNG_ISR_DATRDY_Pos = 0x0
	// Bit mask of DATRDY field.
	TRNG_ISR_DATRDY_Msk = 0x1
	// Bit DATRDY.
	TRNG_ISR_DATRDY = 0x1

	// ODATA: Output Data Register
	// Position of ODATA field.
	TRNG_ODATA_ODATA_Pos = 0x0
	// Bit mask of ODATA field.
	TRNG_ODATA_ODATA_Msk = 0xffffffff
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2
	// Position of TSCALIB field.
	ADC_CR_TSCALIB_Pos = 0x2
	// Bit mask of TSCALIB field.
	ADC_CR_TSCALIB_Msk = 0x4
	// Bit TSCALIB.
	ADC_CR_TSCALIB = 0x4

	// MR: Mode Register
	// Position of LOWRES field.
	ADC_MR_LOWRES_Pos = 0x4
	// Bit mask of LOWRES field.
	ADC_MR_LOWRES_Msk = 0x10
	// Bit LOWRES.
	ADC_MR_LOWRES = 0x10
	// 10-bit resolution
	ADC_MR_LOWRES_BITS_10 = 0x0
	// 8-bit resolution
	ADC_MR_LOWRES_BITS_8 = 0x1
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_NORMAL = 0x0
	// Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_SLEEP_SLEEP = 0x1
	// Position of FWUP field.
	ADC_MR_FWUP_Pos = 0x6
	// Bit mask of FWUP field.
	ADC_MR_FWUP_Msk = 0x40
	// Bit FWUP.
	ADC_MR_FWUP = 0x40
	// Normal Sleep Mode: The sleep mode is defined by the SLEEP bit
	ADC_MR_FWUP_OFF = 0x0
	// Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FWUP_ON = 0x1
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0xf0000
	// 0 periods of ADCClock
	ADC_MR_STARTUP_SUT0 = 0x0
	// 8 periods of ADCClock
	ADC_MR_STARTUP_SUT8 = 0x1
	// 16 periods of ADCClock
	ADC_MR_STARTUP_SUT16 = 0x2
	// 24 periods of ADCClock
	ADC_MR_STARTUP_SUT24 = 0x3
	// 64 periods of ADCClock
	ADC_MR_STARTUP_SUT64 = 0x4
	// 80 periods of ADCClock
	ADC_MR_STARTUP_SUT80 = 0x5
	// 96 periods of ADCClock
	ADC_MR_STARTUP_SUT96 = 0x6
	// 112 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7
	// 512 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8
	// 576 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9
	// 640 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa
	// 704 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb
	// 768 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc
	// 832 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd
	// 896 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe
	// 960 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf
	// Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Pos = 0x18
	// Bit mask of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk = 0xf000000
	// Position of USEQ field.
	ADC_MR_USEQ_Pos = 0x1f
	// Bit mask of USEQ field.
	ADC_MR_USEQ_Msk = 0x80000000
	// Bit USEQ.
	ADC_MR_USEQ = 0x80000000
	// Normal Mode: The controller converts channels in a simple numeric order.
	ADC_MR_USEQ_NUM_ORDER = 0x0
	// User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers.
	ADC_MR_USEQ_REG_ORDER = 0x1

	// SEQR1: Channel Sequence Register 1
	// Position of USCH1 field.
	ADC_SEQR1_USCH1_Pos = 0x0
	// Bit mask of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf
	// Position of USCH2 field.
	ADC_SEQR1_USCH2_Pos = 0x4
	// Bit mask of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0
	// Position of USCH3 field.
	ADC_SEQR1_USCH3_Pos = 0x8
	// Bit mask of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00
	// Position of USCH4 field.
	ADC_SEQR1_USCH4_Pos = 0xc
	// Bit mask of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000
	// Position of USCH5 field.
	ADC_SEQR1_USCH5_Pos = 0x10
	// Bit mask of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000
	// Position of USCH6 field.
	ADC_SEQR1_USCH6_Pos = 0x14
	// Bit mask of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000
	// Position of USCH7 field.
	ADC_SEQR1_USCH7_Pos = 0x18
	// Bit mask of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000
	// Position of USCH8 field.
	ADC_SEQR1_USCH8_Pos = 0x1c
	// Bit mask of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000

	// SEQR2: Channel Sequence Register 2
	// Position of USCH9 field.
	ADC_SEQR2_USCH9_Pos = 0x0
	// Bit mask of USCH9 field.
	ADC_SEQR2_USCH9_Msk = 0xf
	// Position of USCH10 field.
	ADC_SEQR2_USCH10_Pos = 0x4
	// Bit mask of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0
	// Position of USCH11 field.
	ADC_SEQR2_USCH11_Pos = 0x8
	// Bit mask of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00
	// Position of USCH12 field.
	ADC_SEQR2_USCH12_Pos = 0xc
	// Bit mask of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0xf000
	// Position of USCH13 field.
	ADC_SEQR2_USCH13_Pos = 0x10
	// Bit mask of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0xf0000
	// Position of USCH14 field.
	ADC_SEQR2_USCH14_Pos = 0x14
	// Bit mask of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0xf00000
	// Position of USCH15 field.
	ADC_SEQR2_USCH15_Pos = 0x18
	// Bit mask of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0xf000000
	// Position of USCH16 field.
	ADC_SEQR2_USCH16_Pos = 0x1c
	// Bit mask of USCH16 field.
	ADC_SEQR2_USCH16_Msk = 0xf0000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHER_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHER_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHER_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHER_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHER_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHER_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHER_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHER_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHER_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHER_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHER_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHER_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHER_CH11 = 0x800

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHDR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHDR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHDR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHDR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHDR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHDR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHDR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHDR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHDR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHDR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHDR_CH11 = 0x800

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHSR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHSR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHSR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHSR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHSR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHSR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHSR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHSR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHSR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHSR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHSR_CH11 = 0x800

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff
	// Position of CHNB field.
	ADC_LCDR_CHNB_Pos = 0xc
	// Bit mask of CHNB field.
	ADC_LCDR_CHNB_Msk = 0xf000

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IER_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IER_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IER_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IER_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IER_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IER_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IER_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IER_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IER_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IER_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IER_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IER_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IER_EOC11 = 0x800
	// Position of XRDY field.
	ADC_IER_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_IER_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_IER_XRDY = 0x100000
	// Position of YRDY field.
	ADC_IER_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_IER_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_IER_YRDY = 0x200000
	// Position of PRDY field.
	ADC_IER_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_IER_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_IER_PRDY = 0x400000
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IER_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IER_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IER_COMPE = 0x4000000
	// Position of PEN field.
	ADC_IER_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_IER_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_IER_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_IER_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_IER_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_IER_NOPEN = 0x40000000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IDR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IDR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IDR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IDR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IDR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IDR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IDR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IDR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IDR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IDR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IDR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IDR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IDR_EOC11 = 0x800
	// Position of XRDY field.
	ADC_IDR_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_IDR_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_IDR_XRDY = 0x100000
	// Position of YRDY field.
	ADC_IDR_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_IDR_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_IDR_YRDY = 0x200000
	// Position of PRDY field.
	ADC_IDR_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_IDR_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_IDR_PRDY = 0x400000
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IDR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IDR_COMPE = 0x4000000
	// Position of PEN field.
	ADC_IDR_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_IDR_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_IDR_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_IDR_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_IDR_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_IDR_NOPEN = 0x40000000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IMR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IMR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IMR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IMR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IMR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IMR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IMR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IMR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IMR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IMR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IMR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IMR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IMR_EOC11 = 0x800
	// Position of XRDY field.
	ADC_IMR_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_IMR_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_IMR_XRDY = 0x100000
	// Position of YRDY field.
	ADC_IMR_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_IMR_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_IMR_YRDY = 0x200000
	// Position of PRDY field.
	ADC_IMR_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_IMR_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_IMR_PRDY = 0x400000
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IMR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IMR_COMPE = 0x4000000
	// Position of PEN field.
	ADC_IMR_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_IMR_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_IMR_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_IMR_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_IMR_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_IMR_NOPEN = 0x40000000

	// ISR: Interrupt Status Register
	// Position of EOC0 field.
	ADC_ISR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_ISR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_ISR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_ISR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_ISR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_ISR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_ISR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_ISR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_ISR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_ISR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_ISR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_ISR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_ISR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_ISR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_ISR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_ISR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_ISR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_ISR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_ISR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_ISR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_ISR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_ISR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_ISR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_ISR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_ISR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_ISR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_ISR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_ISR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_ISR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_ISR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_ISR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_ISR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_ISR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_ISR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_ISR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_ISR_EOC11 = 0x800
	// Position of XRDY field.
	ADC_ISR_XRDY_Pos = 0x14
	// Bit mask of XRDY field.
	ADC_ISR_XRDY_Msk = 0x100000
	// Bit XRDY.
	ADC_ISR_XRDY = 0x100000
	// Position of YRDY field.
	ADC_ISR_YRDY_Pos = 0x15
	// Bit mask of YRDY field.
	ADC_ISR_YRDY_Msk = 0x200000
	// Bit YRDY.
	ADC_ISR_YRDY = 0x200000
	// Position of PRDY field.
	ADC_ISR_PRDY_Pos = 0x16
	// Bit mask of PRDY field.
	ADC_ISR_PRDY_Msk = 0x400000
	// Bit PRDY.
	ADC_ISR_PRDY = 0x400000
	// Position of DRDY field.
	ADC_ISR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_ISR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_ISR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_ISR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_ISR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_ISR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_ISR_COMPE = 0x4000000
	// Position of PEN field.
	ADC_ISR_PEN_Pos = 0x1d
	// Bit mask of PEN field.
	ADC_ISR_PEN_Msk = 0x20000000
	// Bit PEN.
	ADC_ISR_PEN = 0x20000000
	// Position of NOPEN field.
	ADC_ISR_NOPEN_Pos = 0x1e
	// Bit mask of NOPEN field.
	ADC_ISR_NOPEN_Msk = 0x40000000
	// Bit NOPEN.
	ADC_ISR_NOPEN = 0x40000000
	// Position of PENS field.
	ADC_ISR_PENS_Pos = 0x1f
	// Bit mask of PENS field.
	ADC_ISR_PENS_Msk = 0x80000000
	// Bit PENS.
	ADC_ISR_PENS = 0x80000000

	// OVER: Overrun Status Register
	// Position of OVRE0 field.
	ADC_OVER_OVRE0_Pos = 0x0
	// Bit mask of OVRE0 field.
	ADC_OVER_OVRE0_Msk = 0x1
	// Bit OVRE0.
	ADC_OVER_OVRE0 = 0x1
	// Position of OVRE1 field.
	ADC_OVER_OVRE1_Pos = 0x1
	// Bit mask of OVRE1 field.
	ADC_OVER_OVRE1_Msk = 0x2
	// Bit OVRE1.
	ADC_OVER_OVRE1 = 0x2
	// Position of OVRE2 field.
	ADC_OVER_OVRE2_Pos = 0x2
	// Bit mask of OVRE2 field.
	ADC_OVER_OVRE2_Msk = 0x4
	// Bit OVRE2.
	ADC_OVER_OVRE2 = 0x4
	// Position of OVRE3 field.
	ADC_OVER_OVRE3_Pos = 0x3
	// Bit mask of OVRE3 field.
	ADC_OVER_OVRE3_Msk = 0x8
	// Bit OVRE3.
	ADC_OVER_OVRE3 = 0x8
	// Position of OVRE4 field.
	ADC_OVER_OVRE4_Pos = 0x4
	// Bit mask of OVRE4 field.
	ADC_OVER_OVRE4_Msk = 0x10
	// Bit OVRE4.
	ADC_OVER_OVRE4 = 0x10
	// Position of OVRE5 field.
	ADC_OVER_OVRE5_Pos = 0x5
	// Bit mask of OVRE5 field.
	ADC_OVER_OVRE5_Msk = 0x20
	// Bit OVRE5.
	ADC_OVER_OVRE5 = 0x20
	// Position of OVRE6 field.
	ADC_OVER_OVRE6_Pos = 0x6
	// Bit mask of OVRE6 field.
	ADC_OVER_OVRE6_Msk = 0x40
	// Bit OVRE6.
	ADC_OVER_OVRE6 = 0x40
	// Position of OVRE7 field.
	ADC_OVER_OVRE7_Pos = 0x7
	// Bit mask of OVRE7 field.
	ADC_OVER_OVRE7_Msk = 0x80
	// Bit OVRE7.
	ADC_OVER_OVRE7 = 0x80
	// Position of OVRE8 field.
	ADC_OVER_OVRE8_Pos = 0x8
	// Bit mask of OVRE8 field.
	ADC_OVER_OVRE8_Msk = 0x100
	// Bit OVRE8.
	ADC_OVER_OVRE8 = 0x100
	// Position of OVRE9 field.
	ADC_OVER_OVRE9_Pos = 0x9
	// Bit mask of OVRE9 field.
	ADC_OVER_OVRE9_Msk = 0x200
	// Bit OVRE9.
	ADC_OVER_OVRE9 = 0x200
	// Position of OVRE10 field.
	ADC_OVER_OVRE10_Pos = 0xa
	// Bit mask of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400
	// Bit OVRE10.
	ADC_OVER_OVRE10 = 0x400
	// Position of OVRE11 field.
	ADC_OVER_OVRE11_Pos = 0xb
	// Bit mask of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800
	// Bit OVRE11.
	ADC_OVER_OVRE11 = 0x800

	// EMR: Extended Mode Register
	// Position of CMPMODE field.
	ADC_EMR_CMPMODE_Pos = 0x0
	// Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_Msk = 0x3
	// Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_LOW = 0x0
	// Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1
	// Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_IN = 0x2
	// Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPMODE_OUT = 0x3
	// Position of CMPSEL field.
	ADC_EMR_CMPSEL_Pos = 0x4
	// Bit mask of CMPSEL field.
	ADC_EMR_CMPSEL_Msk = 0xf0
	// Position of CMPALL field.
	ADC_EMR_CMPALL_Pos = 0x9
	// Bit mask of CMPALL field.
	ADC_EMR_CMPALL_Msk = 0x200
	// Bit CMPALL.
	ADC_EMR_CMPALL = 0x200
	// Position of TAG field.
	ADC_EMR_TAG_Pos = 0x18
	// Bit mask of TAG field.
	ADC_EMR_TAG_Msk = 0x1000000
	// Bit TAG.
	ADC_EMR_TAG = 0x1000000

	// CWR: Compare Window Register
	// Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Pos = 0x0
	// Bit mask of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk = 0xfff
	// Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10
	// Bit mask of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0xfff

	// ACR: Analog Control Register
	// Position of PENDETSENS field.
	ADC_ACR_PENDETSENS_Pos = 0x0
	// Bit mask of PENDETSENS field.
	ADC_ACR_PENDETSENS_Msk = 0x3

	// TSMR: Touchscreen Mode Register
	// Position of TSMODE field.
	ADC_TSMR_TSMODE_Pos = 0x0
	// Bit mask of TSMODE field.
	ADC_TSMR_TSMODE_Msk = 0x3
	// No Touchscreen
	ADC_TSMR_TSMODE_NONE = 0x0
	// 4-wire Touchscreen without pressure measurement
	ADC_TSMR_TSMODE_4_WIRE_NO_PM = 0x1
	// 4-wire Touchscreen with pressure measurement
	ADC_TSMR_TSMODE_4_WIRE = 0x2
	// 5-wire Touchscreen
	ADC_TSMR_TSMODE_5_WIRE = 0x3
	// Position of TSAV field.
	ADC_TSMR_TSAV_Pos = 0x4
	// Bit mask of TSAV field.
	ADC_TSMR_TSAV_Msk = 0x30
	// No Filtering. Only one ADC conversion per measure
	ADC_TSMR_TSAV_NO_FILTER = 0x0
	// Averages 2 ADC conversions
	ADC_TSMR_TSAV_AVG2CONV = 0x1
	// Averages 4 ADC conversions
	ADC_TSMR_TSAV_AVG4CONV = 0x2
	// Averages 8 ADC conversions
	ADC_TSMR_TSAV_AVG8CONV = 0x3
	// Position of TSFREQ field.
	ADC_TSMR_TSFREQ_Pos = 0x8
	// Bit mask of TSFREQ field.
	ADC_TSMR_TSFREQ_Msk = 0xf00
	// Position of TSSCTIM field.
	ADC_TSMR_TSSCTIM_Pos = 0x10
	// Bit mask of TSSCTIM field.
	ADC_TSMR_TSSCTIM_Msk = 0xf0000
	// Position of NOTSDMA field.
	ADC_TSMR_NOTSDMA_Pos = 0x16
	// Bit mask of NOTSDMA field.
	ADC_TSMR_NOTSDMA_Msk = 0x400000
	// Bit NOTSDMA.
	ADC_TSMR_NOTSDMA = 0x400000
	// Position of PENDET field.
	ADC_TSMR_PENDET_Pos = 0x18
	// Bit mask of PENDET field.
	ADC_TSMR_PENDET_Msk = 0x1000000
	// Bit PENDET.
	ADC_TSMR_PENDET = 0x1000000
	// Position of PENDBC field.
	ADC_TSMR_PENDBC_Pos = 0x1c
	// Bit mask of PENDBC field.
	ADC_TSMR_PENDBC_Msk = 0xf0000000

	// XPOSR: Touchscreen X Position Register
	// Position of XPOS field.
	ADC_XPOSR_XPOS_Pos = 0x0
	// Bit mask of XPOS field.
	ADC_XPOSR_XPOS_Msk = 0x3ff
	// Position of XSCALE field.
	ADC_XPOSR_XSCALE_Pos = 0x10
	// Bit mask of XSCALE field.
	ADC_XPOSR_XSCALE_Msk = 0x3ff0000

	// YPOSR: Touchscreen Y Position Register
	// Position of YPOS field.
	ADC_YPOSR_YPOS_Pos = 0x0
	// Bit mask of YPOS field.
	ADC_YPOSR_YPOS_Msk = 0x3ff
	// Position of YSCALE field.
	ADC_YPOSR_YSCALE_Pos = 0x10
	// Bit mask of YSCALE field.
	ADC_YPOSR_YSCALE_Msk = 0x3ff0000

	// PRESSR: Touchscreen Pressure Register
	// Position of Z1 field.
	ADC_PRESSR_Z1_Pos = 0x0
	// Bit mask of Z1 field.
	ADC_PRESSR_Z1_Msk = 0x3ff
	// Position of Z2 field.
	ADC_PRESSR_Z2_Pos = 0x10
	// Bit mask of Z2 field.
	ADC_PRESSR_Z2_Msk = 0x3ff0000

	// TRGR: Trigger Register
	// Position of TRGMOD field.
	ADC_TRGR_TRGMOD_Pos = 0x0
	// Bit mask of TRGMOD field.
	ADC_TRGR_TRGMOD_Msk = 0x7
	// No trigger, only software trigger can start conversions
	ADC_TRGR_TRGMOD_NO_TRIGGER = 0x0
	// External Trigger Rising Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_RISE = 0x1
	// External Trigger Falling Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_FALL = 0x2
	// External Trigger Any Edge
	ADC_TRGR_TRGMOD_EXT_TRIG_ANY = 0x3
	// Pen Detect Trigger (shall be selected only if PENDET is set and TSAMOD = Touchscreen only mode)
	ADC_TRGR_TRGMOD_PEN_TRIG = 0x4
	// Periodic Trigger (TRGPER shall be initiated appropriately)
	ADC_TRGR_TRGMOD_PERIOD_TRIG = 0x5
	// Continuous Mode
	ADC_TRGR_TRGMOD_CONTINUOUS = 0x6
	// Position of TRGPER field.
	ADC_TRGR_TRGPER_Pos = 0x10
	// Bit mask of TRGPER field.
	ADC_TRGR_TRGPER_Msk = 0xffff0000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ADC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ADC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ADC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ADC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	ADC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	ADC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	ADC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for FUSE: Fuse Controller
const (
	// CR: Fuse Control Register
	// Position of WRQ field.
	FUSE_CR_WRQ_Pos = 0x0
	// Bit mask of WRQ field.
	FUSE_CR_WRQ_Msk = 0x1
	// Bit WRQ.
	FUSE_CR_WRQ = 0x1
	// Position of RRQ field.
	FUSE_CR_RRQ_Pos = 0x1
	// Bit mask of RRQ field.
	FUSE_CR_RRQ_Msk = 0x2
	// Bit RRQ.
	FUSE_CR_RRQ = 0x2
	// Position of KEY field.
	FUSE_CR_KEY_Pos = 0x8
	// Bit mask of KEY field.
	FUSE_CR_KEY_Msk = 0xff00
	// valid key.
	FUSE_CR_KEY_VALID = 0xfb

	// MR: Fuse Mode Register
	// Position of MSK field.
	FUSE_MR_MSK_Pos = 0x0
	// Bit mask of MSK field.
	FUSE_MR_MSK_Msk = 0x1
	// Bit MSK.
	FUSE_MR_MSK = 0x1

	// IR: Fuse Index Register
	// Position of WS field.
	FUSE_IR_WS_Pos = 0x0
	// Bit mask of WS field.
	FUSE_IR_WS_Msk = 0x1
	// Bit WS.
	FUSE_IR_WS = 0x1
	// Position of RS field.
	FUSE_IR_RS_Pos = 0x1
	// Bit mask of RS field.
	FUSE_IR_RS_Msk = 0x2
	// Bit RS.
	FUSE_IR_RS = 0x2
	// Position of WSEL field.
	FUSE_IR_WSEL_Pos = 0x8
	// Bit mask of WSEL field.
	FUSE_IR_WSEL_Msk = 0xf00

	// DR: Fuse Data Register
	// Position of DATA field.
	FUSE_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	FUSE_DR_DATA_Msk = 0xffffffff

	// SR: Fuse Status Register
	// Position of FUSE field.
	FUSE_SR_FUSE_Pos = 0x0
	// Bit mask of FUSE field.
	FUSE_SR_FUSE_Msk = 0xffffffff
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MCFG: Master Configuration Register
	// Position of ULBT field.
	MATRIX_MCFG_ULBT_Pos = 0x0
	// Bit mask of ULBT field.
	MATRIX_MCFG_ULBT_Msk = 0x7

	// SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_SCFG_SLOT_CYCLE_Msk = 0x1ff
	// Position of DEFMSTR_TYPE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x3c0000

	// PRAS0: Priority Register A for Slave 0
	// Position of M0PR field.
	MATRIX_PRAS0_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS0_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS0_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS0_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS0_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS0_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS0_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS0_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS0_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS0_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_PRAS0_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_PRAS0_M5PR_Msk = 0x300000

	// PRAS1: Priority Register A for Slave 1
	// Position of M0PR field.
	MATRIX_PRAS1_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS1_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS1_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS1_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS1_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS1_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS1_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS1_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS1_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS1_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_PRAS1_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_PRAS1_M5PR_Msk = 0x300000

	// PRAS2: Priority Register A for Slave 2
	// Position of M0PR field.
	MATRIX_PRAS2_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS2_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS2_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS2_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS2_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS2_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS2_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS2_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS2_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS2_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_PRAS2_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_PRAS2_M5PR_Msk = 0x300000

	// PRAS3: Priority Register A for Slave 3
	// Position of M0PR field.
	MATRIX_PRAS3_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS3_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS3_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS3_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS3_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS3_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS3_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS3_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS3_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS3_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_PRAS3_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_PRAS3_M5PR_Msk = 0x300000

	// PRAS4: Priority Register A for Slave 4
	// Position of M0PR field.
	MATRIX_PRAS4_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_PRAS4_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_PRAS4_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_PRAS4_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_PRAS4_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_PRAS4_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_PRAS4_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_PRAS4_M3PR_Msk = 0x3000
	// Position of M4PR field.
	MATRIX_PRAS4_M4PR_Pos = 0x10
	// Bit mask of M4PR field.
	MATRIX_PRAS4_M4PR_Msk = 0x30000
	// Position of M5PR field.
	MATRIX_PRAS4_M5PR_Pos = 0x14
	// Bit mask of M5PR field.
	MATRIX_PRAS4_M5PR_Msk = 0x300000

	// MRCR: Master Remap Control Register
	// Position of RCB0 field.
	MATRIX_MRCR_RCB0_Pos = 0x0
	// Bit mask of RCB0 field.
	MATRIX_MRCR_RCB0_Msk = 0x1
	// Bit RCB0.
	MATRIX_MRCR_RCB0 = 0x1
	// Position of RCB1 field.
	MATRIX_MRCR_RCB1_Pos = 0x1
	// Bit mask of RCB1 field.
	MATRIX_MRCR_RCB1_Msk = 0x2
	// Bit RCB1.
	MATRIX_MRCR_RCB1 = 0x2
	// Position of RCB2 field.
	MATRIX_MRCR_RCB2_Pos = 0x2
	// Bit mask of RCB2 field.
	MATRIX_MRCR_RCB2_Msk = 0x4
	// Bit RCB2.
	MATRIX_MRCR_RCB2 = 0x4
	// Position of RCB3 field.
	MATRIX_MRCR_RCB3_Pos = 0x3
	// Bit mask of RCB3 field.
	MATRIX_MRCR_RCB3_Msk = 0x8
	// Bit RCB3.
	MATRIX_MRCR_RCB3 = 0x8
	// Position of RCB4 field.
	MATRIX_MRCR_RCB4_Pos = 0x4
	// Bit mask of RCB4 field.
	MATRIX_MRCR_RCB4_Msk = 0x10
	// Bit RCB4.
	MATRIX_MRCR_RCB4 = 0x10
	// Position of RCB5 field.
	MATRIX_MRCR_RCB5_Pos = 0x5
	// Bit mask of RCB5 field.
	MATRIX_MRCR_RCB5_Msk = 0x20
	// Bit RCB5.
	MATRIX_MRCR_RCB5 = 0x20

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	MATRIX_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	MATRIX_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	MATRIX_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	MATRIX_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	MATRIX_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	MATRIX_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	MATRIX_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	MATRIX_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	MATRIX_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	MATRIX_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for PMECC: Programmable Multibit Error Corrected Code Controller
const (
	// CFG: PMECC Configuration Register
	// Position of BCH_ERR field.
	EBI_CFG_BCH_ERR_Pos = 0x0
	// Bit mask of BCH_ERR field.
	EBI_CFG_BCH_ERR_Msk = 0x7
	// 2 errors
	EBI_CFG_BCH_ERR_BCH_ERR2 = 0x0
	// 4 errors
	EBI_CFG_BCH_ERR_BCH_ERR4 = 0x1
	// 8 errors
	EBI_CFG_BCH_ERR_BCH_ERR8 = 0x2
	// 12 errors
	EBI_CFG_BCH_ERR_BCH_ERR12 = 0x3
	// 24 errors
	EBI_CFG_BCH_ERR_BCH_ERR24 = 0x4
	// Position of SECTORSZ field.
	EBI_CFG_SECTORSZ_Pos = 0x4
	// Bit mask of SECTORSZ field.
	EBI_CFG_SECTORSZ_Msk = 0x10
	// Bit SECTORSZ.
	EBI_CFG_SECTORSZ = 0x10
	// Position of PAGESIZE field.
	EBI_CFG_PAGESIZE_Pos = 0x8
	// Bit mask of PAGESIZE field.
	EBI_CFG_PAGESIZE_Msk = 0x300
	// 1 sector for main area (512 or 1024 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_1SEC = 0x0
	// 2 sectors for main area (1024 or 2048 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_2SEC = 0x1
	// 4 sectors for main area (2048 or 4096 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_4SEC = 0x2
	// 8 errors for main area (4096 or 8192 bytes)
	EBI_CFG_PAGESIZE_PAGESIZE_8SEC = 0x3
	// Position of NANDWR field.
	EBI_CFG_NANDWR_Pos = 0xc
	// Bit mask of NANDWR field.
	EBI_CFG_NANDWR_Msk = 0x1000
	// Bit NANDWR.
	EBI_CFG_NANDWR = 0x1000
	// Position of SPAREEN field.
	EBI_CFG_SPAREEN_Pos = 0x10
	// Bit mask of SPAREEN field.
	EBI_CFG_SPAREEN_Msk = 0x10000
	// Bit SPAREEN.
	EBI_CFG_SPAREEN = 0x10000
	// Position of AUTO field.
	EBI_CFG_AUTO_Pos = 0x14
	// Bit mask of AUTO field.
	EBI_CFG_AUTO_Msk = 0x100000
	// Bit AUTO.
	EBI_CFG_AUTO = 0x100000

	// SAREA: PMECC Spare Area Size Register
	// Position of SPARESIZE field.
	EBI_SAREA_SPARESIZE_Pos = 0x0
	// Bit mask of SPARESIZE field.
	EBI_SAREA_SPARESIZE_Msk = 0x1ff

	// SADDR: PMECC Start Address Register
	// Position of STARTADDR field.
	EBI_SADDR_STARTADDR_Pos = 0x0
	// Bit mask of STARTADDR field.
	EBI_SADDR_STARTADDR_Msk = 0x1ff

	// EADDR: PMECC End Address Register
	// Position of ENDADDR field.
	EBI_EADDR_ENDADDR_Pos = 0x0
	// Bit mask of ENDADDR field.
	EBI_EADDR_ENDADDR_Msk = 0x1ff

	// CLK: PMECC Clock Control Register
	// Position of CLKCTRL field.
	EBI_CLK_CLKCTRL_Pos = 0x0
	// Bit mask of CLKCTRL field.
	EBI_CLK_CLKCTRL_Msk = 0x7

	// CTRL: PMECC Control Register
	// Position of RST field.
	EBI_CTRL_RST_Pos = 0x0
	// Bit mask of RST field.
	EBI_CTRL_RST_Msk = 0x1
	// Bit RST.
	EBI_CTRL_RST = 0x1
	// Position of DATA field.
	EBI_CTRL_DATA_Pos = 0x1
	// Bit mask of DATA field.
	EBI_CTRL_DATA_Msk = 0x2
	// Bit DATA.
	EBI_CTRL_DATA = 0x2
	// Position of USER field.
	EBI_CTRL_USER_Pos = 0x2
	// Bit mask of USER field.
	EBI_CTRL_USER_Msk = 0x4
	// Bit USER.
	EBI_CTRL_USER = 0x4
	// Position of ENABLE field.
	EBI_CTRL_ENABLE_Pos = 0x4
	// Bit mask of ENABLE field.
	EBI_CTRL_ENABLE_Msk = 0x10
	// Bit ENABLE.
	EBI_CTRL_ENABLE = 0x10
	// Position of DISABLE field.
	EBI_CTRL_DISABLE_Pos = 0x5
	// Bit mask of DISABLE field.
	EBI_CTRL_DISABLE_Msk = 0x20
	// Bit DISABLE.
	EBI_CTRL_DISABLE = 0x20

	// SR: PMECC Status Register
	// Position of BUSY field.
	EBI_SR_BUSY_Pos = 0x0
	// Bit mask of BUSY field.
	EBI_SR_BUSY_Msk = 0x1
	// Bit BUSY.
	EBI_SR_BUSY = 0x1
	// Position of ENABLE field.
	EBI_SR_ENABLE_Pos = 0x4
	// Bit mask of ENABLE field.
	EBI_SR_ENABLE_Msk = 0x10
	// Bit ENABLE.
	EBI_SR_ENABLE = 0x10

	// IER: PMECC Interrupt Enable register
	// Position of ERRIE field.
	EBI_IER_ERRIE_Pos = 0x0
	// Bit mask of ERRIE field.
	EBI_IER_ERRIE_Msk = 0x1
	// Bit ERRIE.
	EBI_IER_ERRIE = 0x1

	// IDR: PMECC Interrupt Disable Register
	// Position of ERRID field.
	EBI_IDR_ERRID_Pos = 0x0
	// Bit mask of ERRID field.
	EBI_IDR_ERRID_Msk = 0x1
	// Bit ERRID.
	EBI_IDR_ERRID = 0x1

	// IMR: PMECC Interrupt Mask Register
	// Position of ERRIM field.
	EBI_IMR_ERRIM_Pos = 0x0
	// Bit mask of ERRIM field.
	EBI_IMR_ERRIM_Msk = 0x1
	// Bit ERRIM.
	EBI_IMR_ERRIM = 0x1

	// ISR: PMECC Interrupt Status Register
	// Position of ERRIS field.
	EBI_ISR_ERRIS_Pos = 0x0
	// Bit mask of ERRIS field.
	EBI_ISR_ERRIS_Msk = 0xff

	// ECC0_0: PMECC ECC 0 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC0_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_0_ECC_Msk = 0xffffffff

	// ECC1_0: PMECC ECC 1 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC1_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_0_ECC_Msk = 0xffffffff

	// ECC2_0: PMECC ECC 2 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC2_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_0_ECC_Msk = 0xffffffff

	// ECC3_0: PMECC ECC 3 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC3_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_0_ECC_Msk = 0xffffffff

	// ECC4_0: PMECC ECC 4 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC4_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_0_ECC_Msk = 0xffffffff

	// ECC5_0: PMECC ECC 5 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC5_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_0_ECC_Msk = 0xffffffff

	// ECC6_0: PMECC ECC 6 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC6_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_0_ECC_Msk = 0xffffffff

	// ECC7_0: PMECC ECC 7 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC7_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_0_ECC_Msk = 0xffffffff

	// ECC8_0: PMECC ECC 8 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC8_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_0_ECC_Msk = 0xffffffff

	// ECC9_0: PMECC ECC 9 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC9_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_0_ECC_Msk = 0xffffffff

	// ECC10_0: PMECC ECC 10 Register (sec_num = 0)
	// Position of ECC field.
	EBI_ECC10_0_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_0_ECC_Msk = 0xffffffff

	// ECC0_1: PMECC ECC 0 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC0_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_1_ECC_Msk = 0xffffffff

	// ECC1_1: PMECC ECC 1 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC1_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_1_ECC_Msk = 0xffffffff

	// ECC2_1: PMECC ECC 2 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC2_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_1_ECC_Msk = 0xffffffff

	// ECC3_1: PMECC ECC 3 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC3_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_1_ECC_Msk = 0xffffffff

	// ECC4_1: PMECC ECC 4 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC4_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_1_ECC_Msk = 0xffffffff

	// ECC5_1: PMECC ECC 5 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC5_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_1_ECC_Msk = 0xffffffff

	// ECC6_1: PMECC ECC 6 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC6_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_1_ECC_Msk = 0xffffffff

	// ECC7_1: PMECC ECC 7 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC7_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_1_ECC_Msk = 0xffffffff

	// ECC8_1: PMECC ECC 8 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC8_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_1_ECC_Msk = 0xffffffff

	// ECC9_1: PMECC ECC 9 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC9_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_1_ECC_Msk = 0xffffffff

	// ECC10_1: PMECC ECC 10 Register (sec_num = 1)
	// Position of ECC field.
	EBI_ECC10_1_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_1_ECC_Msk = 0xffffffff

	// ECC0_2: PMECC ECC 0 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC0_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_2_ECC_Msk = 0xffffffff

	// ECC1_2: PMECC ECC 1 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC1_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_2_ECC_Msk = 0xffffffff

	// ECC2_2: PMECC ECC 2 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC2_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_2_ECC_Msk = 0xffffffff

	// ECC3_2: PMECC ECC 3 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC3_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_2_ECC_Msk = 0xffffffff

	// ECC4_2: PMECC ECC 4 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC4_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_2_ECC_Msk = 0xffffffff

	// ECC5_2: PMECC ECC 5 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC5_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_2_ECC_Msk = 0xffffffff

	// ECC6_2: PMECC ECC 6 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC6_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_2_ECC_Msk = 0xffffffff

	// ECC7_2: PMECC ECC 7 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC7_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_2_ECC_Msk = 0xffffffff

	// ECC8_2: PMECC ECC 8 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC8_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_2_ECC_Msk = 0xffffffff

	// ECC9_2: PMECC ECC 9 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC9_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_2_ECC_Msk = 0xffffffff

	// ECC10_2: PMECC ECC 10 Register (sec_num = 2)
	// Position of ECC field.
	EBI_ECC10_2_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_2_ECC_Msk = 0xffffffff

	// ECC0_3: PMECC ECC 0 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC0_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_3_ECC_Msk = 0xffffffff

	// ECC1_3: PMECC ECC 1 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC1_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_3_ECC_Msk = 0xffffffff

	// ECC2_3: PMECC ECC 2 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC2_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_3_ECC_Msk = 0xffffffff

	// ECC3_3: PMECC ECC 3 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC3_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_3_ECC_Msk = 0xffffffff

	// ECC4_3: PMECC ECC 4 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC4_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_3_ECC_Msk = 0xffffffff

	// ECC5_3: PMECC ECC 5 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC5_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_3_ECC_Msk = 0xffffffff

	// ECC6_3: PMECC ECC 6 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC6_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_3_ECC_Msk = 0xffffffff

	// ECC7_3: PMECC ECC 7 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC7_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_3_ECC_Msk = 0xffffffff

	// ECC8_3: PMECC ECC 8 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC8_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_3_ECC_Msk = 0xffffffff

	// ECC9_3: PMECC ECC 9 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC9_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_3_ECC_Msk = 0xffffffff

	// ECC10_3: PMECC ECC 10 Register (sec_num = 3)
	// Position of ECC field.
	EBI_ECC10_3_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_3_ECC_Msk = 0xffffffff

	// ECC0_4: PMECC ECC 0 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC0_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_4_ECC_Msk = 0xffffffff

	// ECC1_4: PMECC ECC 1 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC1_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_4_ECC_Msk = 0xffffffff

	// ECC2_4: PMECC ECC 2 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC2_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_4_ECC_Msk = 0xffffffff

	// ECC3_4: PMECC ECC 3 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC3_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_4_ECC_Msk = 0xffffffff

	// ECC4_4: PMECC ECC 4 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC4_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_4_ECC_Msk = 0xffffffff

	// ECC5_4: PMECC ECC 5 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC5_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_4_ECC_Msk = 0xffffffff

	// ECC6_4: PMECC ECC 6 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC6_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_4_ECC_Msk = 0xffffffff

	// ECC7_4: PMECC ECC 7 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC7_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_4_ECC_Msk = 0xffffffff

	// ECC8_4: PMECC ECC 8 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC8_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_4_ECC_Msk = 0xffffffff

	// ECC9_4: PMECC ECC 9 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC9_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_4_ECC_Msk = 0xffffffff

	// ECC10_4: PMECC ECC 10 Register (sec_num = 4)
	// Position of ECC field.
	EBI_ECC10_4_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_4_ECC_Msk = 0xffffffff

	// ECC0_5: PMECC ECC 0 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC0_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_5_ECC_Msk = 0xffffffff

	// ECC1_5: PMECC ECC 1 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC1_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_5_ECC_Msk = 0xffffffff

	// ECC2_5: PMECC ECC 2 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC2_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_5_ECC_Msk = 0xffffffff

	// ECC3_5: PMECC ECC 3 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC3_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_5_ECC_Msk = 0xffffffff

	// ECC4_5: PMECC ECC 4 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC4_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_5_ECC_Msk = 0xffffffff

	// ECC5_5: PMECC ECC 5 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC5_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_5_ECC_Msk = 0xffffffff

	// ECC6_5: PMECC ECC 6 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC6_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_5_ECC_Msk = 0xffffffff

	// ECC7_5: PMECC ECC 7 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC7_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_5_ECC_Msk = 0xffffffff

	// ECC8_5: PMECC ECC 8 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC8_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_5_ECC_Msk = 0xffffffff

	// ECC9_5: PMECC ECC 9 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC9_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_5_ECC_Msk = 0xffffffff

	// ECC10_5: PMECC ECC 10 Register (sec_num = 5)
	// Position of ECC field.
	EBI_ECC10_5_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_5_ECC_Msk = 0xffffffff

	// ECC0_6: PMECC ECC 0 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC0_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_6_ECC_Msk = 0xffffffff

	// ECC1_6: PMECC ECC 1 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC1_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_6_ECC_Msk = 0xffffffff

	// ECC2_6: PMECC ECC 2 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC2_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_6_ECC_Msk = 0xffffffff

	// ECC3_6: PMECC ECC 3 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC3_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_6_ECC_Msk = 0xffffffff

	// ECC4_6: PMECC ECC 4 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC4_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_6_ECC_Msk = 0xffffffff

	// ECC5_6: PMECC ECC 5 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC5_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_6_ECC_Msk = 0xffffffff

	// ECC6_6: PMECC ECC 6 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC6_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_6_ECC_Msk = 0xffffffff

	// ECC7_6: PMECC ECC 7 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC7_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_6_ECC_Msk = 0xffffffff

	// ECC8_6: PMECC ECC 8 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC8_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_6_ECC_Msk = 0xffffffff

	// ECC9_6: PMECC ECC 9 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC9_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_6_ECC_Msk = 0xffffffff

	// ECC10_6: PMECC ECC 10 Register (sec_num = 6)
	// Position of ECC field.
	EBI_ECC10_6_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_6_ECC_Msk = 0xffffffff

	// ECC0_7: PMECC ECC 0 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC0_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC0_7_ECC_Msk = 0xffffffff

	// ECC1_7: PMECC ECC 1 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC1_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC1_7_ECC_Msk = 0xffffffff

	// ECC2_7: PMECC ECC 2 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC2_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC2_7_ECC_Msk = 0xffffffff

	// ECC3_7: PMECC ECC 3 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC3_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC3_7_ECC_Msk = 0xffffffff

	// ECC4_7: PMECC ECC 4 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC4_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC4_7_ECC_Msk = 0xffffffff

	// ECC5_7: PMECC ECC 5 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC5_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC5_7_ECC_Msk = 0xffffffff

	// ECC6_7: PMECC ECC 6 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC6_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC6_7_ECC_Msk = 0xffffffff

	// ECC7_7: PMECC ECC 7 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC7_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC7_7_ECC_Msk = 0xffffffff

	// ECC8_7: PMECC ECC 8 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC8_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC8_7_ECC_Msk = 0xffffffff

	// ECC9_7: PMECC ECC 9 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC9_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC9_7_ECC_Msk = 0xffffffff

	// ECC10_7: PMECC ECC 10 Register (sec_num = 7)
	// Position of ECC field.
	EBI_ECC10_7_ECC_Pos = 0x0
	// Bit mask of ECC field.
	EBI_ECC10_7_ECC_Msk = 0xffffffff

	// REM0_0: PMECC REM 0 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM0_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_0_REM2NP3_Msk = 0x3fff0000

	// REM1_0: PMECC REM 1 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM1_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_0_REM2NP3_Msk = 0x3fff0000

	// REM2_0: PMECC REM 2 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM2_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_0_REM2NP3_Msk = 0x3fff0000

	// REM3_0: PMECC REM 3 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM3_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_0_REM2NP3_Msk = 0x3fff0000

	// REM4_0: PMECC REM 4 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM4_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_0_REM2NP3_Msk = 0x3fff0000

	// REM5_0: PMECC REM 5 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM5_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_0_REM2NP3_Msk = 0x3fff0000

	// REM6_0: PMECC REM 6 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM6_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_0_REM2NP3_Msk = 0x3fff0000

	// REM7_0: PMECC REM 7 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM7_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_0_REM2NP3_Msk = 0x3fff0000

	// REM8_0: PMECC REM 8 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM8_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_0_REM2NP3_Msk = 0x3fff0000

	// REM9_0: PMECC REM 9 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM9_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_0_REM2NP3_Msk = 0x3fff0000

	// REM10_0: PMECC REM 10 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM10_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_0_REM2NP3_Msk = 0x3fff0000

	// REM11_0: PMECC REM 11 Register (sec_num = 0)
	// Position of REM2NP1 field.
	EBI_REM11_0_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_0_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_0_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_0_REM2NP3_Msk = 0x3fff0000

	// REM0_1: PMECC REM 0 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM0_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_1_REM2NP3_Msk = 0x3fff0000

	// REM1_1: PMECC REM 1 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM1_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_1_REM2NP3_Msk = 0x3fff0000

	// REM2_1: PMECC REM 2 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM2_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_1_REM2NP3_Msk = 0x3fff0000

	// REM3_1: PMECC REM 3 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM3_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_1_REM2NP3_Msk = 0x3fff0000

	// REM4_1: PMECC REM 4 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM4_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_1_REM2NP3_Msk = 0x3fff0000

	// REM5_1: PMECC REM 5 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM5_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_1_REM2NP3_Msk = 0x3fff0000

	// REM6_1: PMECC REM 6 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM6_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_1_REM2NP3_Msk = 0x3fff0000

	// REM7_1: PMECC REM 7 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM7_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_1_REM2NP3_Msk = 0x3fff0000

	// REM8_1: PMECC REM 8 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM8_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_1_REM2NP3_Msk = 0x3fff0000

	// REM9_1: PMECC REM 9 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM9_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_1_REM2NP3_Msk = 0x3fff0000

	// REM10_1: PMECC REM 10 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM10_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_1_REM2NP3_Msk = 0x3fff0000

	// REM11_1: PMECC REM 11 Register (sec_num = 1)
	// Position of REM2NP1 field.
	EBI_REM11_1_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_1_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_1_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_1_REM2NP3_Msk = 0x3fff0000

	// REM0_2: PMECC REM 0 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM0_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_2_REM2NP3_Msk = 0x3fff0000

	// REM1_2: PMECC REM 1 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM1_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_2_REM2NP3_Msk = 0x3fff0000

	// REM2_2: PMECC REM 2 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM2_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_2_REM2NP3_Msk = 0x3fff0000

	// REM3_2: PMECC REM 3 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM3_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_2_REM2NP3_Msk = 0x3fff0000

	// REM4_2: PMECC REM 4 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM4_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_2_REM2NP3_Msk = 0x3fff0000

	// REM5_2: PMECC REM 5 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM5_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_2_REM2NP3_Msk = 0x3fff0000

	// REM6_2: PMECC REM 6 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM6_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_2_REM2NP3_Msk = 0x3fff0000

	// REM7_2: PMECC REM 7 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM7_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_2_REM2NP3_Msk = 0x3fff0000

	// REM8_2: PMECC REM 8 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM8_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_2_REM2NP3_Msk = 0x3fff0000

	// REM9_2: PMECC REM 9 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM9_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_2_REM2NP3_Msk = 0x3fff0000

	// REM10_2: PMECC REM 10 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM10_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_2_REM2NP3_Msk = 0x3fff0000

	// REM11_2: PMECC REM 11 Register (sec_num = 2)
	// Position of REM2NP1 field.
	EBI_REM11_2_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_2_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_2_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_2_REM2NP3_Msk = 0x3fff0000

	// REM0_3: PMECC REM 0 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM0_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_3_REM2NP3_Msk = 0x3fff0000

	// REM1_3: PMECC REM 1 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM1_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_3_REM2NP3_Msk = 0x3fff0000

	// REM2_3: PMECC REM 2 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM2_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_3_REM2NP3_Msk = 0x3fff0000

	// REM3_3: PMECC REM 3 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM3_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_3_REM2NP3_Msk = 0x3fff0000

	// REM4_3: PMECC REM 4 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM4_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_3_REM2NP3_Msk = 0x3fff0000

	// REM5_3: PMECC REM 5 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM5_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_3_REM2NP3_Msk = 0x3fff0000

	// REM6_3: PMECC REM 6 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM6_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_3_REM2NP3_Msk = 0x3fff0000

	// REM7_3: PMECC REM 7 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM7_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_3_REM2NP3_Msk = 0x3fff0000

	// REM8_3: PMECC REM 8 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM8_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_3_REM2NP3_Msk = 0x3fff0000

	// REM9_3: PMECC REM 9 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM9_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_3_REM2NP3_Msk = 0x3fff0000

	// REM10_3: PMECC REM 10 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM10_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_3_REM2NP3_Msk = 0x3fff0000

	// REM11_3: PMECC REM 11 Register (sec_num = 3)
	// Position of REM2NP1 field.
	EBI_REM11_3_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_3_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_3_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_3_REM2NP3_Msk = 0x3fff0000

	// REM0_4: PMECC REM 0 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM0_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_4_REM2NP3_Msk = 0x3fff0000

	// REM1_4: PMECC REM 1 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM1_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_4_REM2NP3_Msk = 0x3fff0000

	// REM2_4: PMECC REM 2 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM2_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_4_REM2NP3_Msk = 0x3fff0000

	// REM3_4: PMECC REM 3 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM3_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_4_REM2NP3_Msk = 0x3fff0000

	// REM4_4: PMECC REM 4 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM4_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_4_REM2NP3_Msk = 0x3fff0000

	// REM5_4: PMECC REM 5 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM5_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_4_REM2NP3_Msk = 0x3fff0000

	// REM6_4: PMECC REM 6 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM6_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_4_REM2NP3_Msk = 0x3fff0000

	// REM7_4: PMECC REM 7 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM7_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_4_REM2NP3_Msk = 0x3fff0000

	// REM8_4: PMECC REM 8 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM8_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_4_REM2NP3_Msk = 0x3fff0000

	// REM9_4: PMECC REM 9 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM9_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_4_REM2NP3_Msk = 0x3fff0000

	// REM10_4: PMECC REM 10 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM10_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_4_REM2NP3_Msk = 0x3fff0000

	// REM11_4: PMECC REM 11 Register (sec_num = 4)
	// Position of REM2NP1 field.
	EBI_REM11_4_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_4_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_4_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_4_REM2NP3_Msk = 0x3fff0000

	// REM0_5: PMECC REM 0 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM0_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_5_REM2NP3_Msk = 0x3fff0000

	// REM1_5: PMECC REM 1 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM1_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_5_REM2NP3_Msk = 0x3fff0000

	// REM2_5: PMECC REM 2 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM2_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_5_REM2NP3_Msk = 0x3fff0000

	// REM3_5: PMECC REM 3 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM3_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_5_REM2NP3_Msk = 0x3fff0000

	// REM4_5: PMECC REM 4 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM4_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_5_REM2NP3_Msk = 0x3fff0000

	// REM5_5: PMECC REM 5 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM5_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_5_REM2NP3_Msk = 0x3fff0000

	// REM6_5: PMECC REM 6 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM6_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_5_REM2NP3_Msk = 0x3fff0000

	// REM7_5: PMECC REM 7 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM7_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_5_REM2NP3_Msk = 0x3fff0000

	// REM8_5: PMECC REM 8 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM8_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_5_REM2NP3_Msk = 0x3fff0000

	// REM9_5: PMECC REM 9 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM9_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_5_REM2NP3_Msk = 0x3fff0000

	// REM10_5: PMECC REM 10 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM10_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_5_REM2NP3_Msk = 0x3fff0000

	// REM11_5: PMECC REM 11 Register (sec_num = 5)
	// Position of REM2NP1 field.
	EBI_REM11_5_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_5_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_5_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_5_REM2NP3_Msk = 0x3fff0000

	// REM0_6: PMECC REM 0 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM0_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_6_REM2NP3_Msk = 0x3fff0000

	// REM1_6: PMECC REM 1 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM1_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_6_REM2NP3_Msk = 0x3fff0000

	// REM2_6: PMECC REM 2 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM2_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_6_REM2NP3_Msk = 0x3fff0000

	// REM3_6: PMECC REM 3 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM3_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_6_REM2NP3_Msk = 0x3fff0000

	// REM4_6: PMECC REM 4 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM4_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_6_REM2NP3_Msk = 0x3fff0000

	// REM5_6: PMECC REM 5 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM5_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_6_REM2NP3_Msk = 0x3fff0000

	// REM6_6: PMECC REM 6 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM6_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_6_REM2NP3_Msk = 0x3fff0000

	// REM7_6: PMECC REM 7 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM7_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_6_REM2NP3_Msk = 0x3fff0000

	// REM8_6: PMECC REM 8 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM8_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_6_REM2NP3_Msk = 0x3fff0000

	// REM9_6: PMECC REM 9 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM9_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_6_REM2NP3_Msk = 0x3fff0000

	// REM10_6: PMECC REM 10 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM10_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_6_REM2NP3_Msk = 0x3fff0000

	// REM11_6: PMECC REM 11 Register (sec_num = 6)
	// Position of REM2NP1 field.
	EBI_REM11_6_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_6_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_6_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_6_REM2NP3_Msk = 0x3fff0000

	// REM0_7: PMECC REM 0 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM0_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM0_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM0_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM0_7_REM2NP3_Msk = 0x3fff0000

	// REM1_7: PMECC REM 1 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM1_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM1_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM1_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM1_7_REM2NP3_Msk = 0x3fff0000

	// REM2_7: PMECC REM 2 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM2_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM2_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM2_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM2_7_REM2NP3_Msk = 0x3fff0000

	// REM3_7: PMECC REM 3 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM3_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM3_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM3_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM3_7_REM2NP3_Msk = 0x3fff0000

	// REM4_7: PMECC REM 4 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM4_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM4_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM4_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM4_7_REM2NP3_Msk = 0x3fff0000

	// REM5_7: PMECC REM 5 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM5_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM5_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM5_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM5_7_REM2NP3_Msk = 0x3fff0000

	// REM6_7: PMECC REM 6 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM6_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM6_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM6_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM6_7_REM2NP3_Msk = 0x3fff0000

	// REM7_7: PMECC REM 7 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM7_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM7_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM7_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM7_7_REM2NP3_Msk = 0x3fff0000

	// REM8_7: PMECC REM 8 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM8_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM8_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM8_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM8_7_REM2NP3_Msk = 0x3fff0000

	// REM9_7: PMECC REM 9 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM9_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM9_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM9_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM9_7_REM2NP3_Msk = 0x3fff0000

	// REM10_7: PMECC REM 10 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM10_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM10_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM10_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM10_7_REM2NP3_Msk = 0x3fff0000

	// REM11_7: PMECC REM 11 Register (sec_num = 7)
	// Position of REM2NP1 field.
	EBI_REM11_7_REM2NP1_Pos = 0x0
	// Bit mask of REM2NP1 field.
	EBI_REM11_7_REM2NP1_Msk = 0x3fff
	// Position of REM2NP3 field.
	EBI_REM11_7_REM2NP3_Pos = 0x10
	// Bit mask of REM2NP3 field.
	EBI_REM11_7_REM2NP3_Msk = 0x3fff0000
)

// Bitfields for DMAC: DMA Controller
const (
	// GCFG: DMAC Global Configuration Register
	// Position of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Pos = 0x4
	// Bit mask of ARB_CFG field.
	DMAC_GCFG_ARB_CFG_Msk = 0x10
	// Bit ARB_CFG.
	DMAC_GCFG_ARB_CFG = 0x10
	// Fixed priority arbiter.
	DMAC_GCFG_ARB_CFG_FIXED = 0x0
	// Modified round robin arbiter.
	DMAC_GCFG_ARB_CFG_ROUND_ROBIN = 0x1
	// Position of DICEN field.
	DMAC_GCFG_DICEN_Pos = 0x8
	// Bit mask of DICEN field.
	DMAC_GCFG_DICEN_Msk = 0x100
	// Bit DICEN.
	DMAC_GCFG_DICEN = 0x100

	// EN: DMAC Enable Register
	// Position of ENABLE field.
	DMAC_EN_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	DMAC_EN_ENABLE_Msk = 0x1
	// Bit ENABLE.
	DMAC_EN_ENABLE = 0x1

	// SREQ: DMAC Software Single Request Register
	// Position of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Pos = 0x0
	// Bit mask of SSREQ0 field.
	DMAC_SREQ_SSREQ0_Msk = 0x1
	// Bit SSREQ0.
	DMAC_SREQ_SSREQ0 = 0x1
	// Position of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Pos = 0x1
	// Bit mask of DSREQ0 field.
	DMAC_SREQ_DSREQ0_Msk = 0x2
	// Bit DSREQ0.
	DMAC_SREQ_DSREQ0 = 0x2
	// Position of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Pos = 0x2
	// Bit mask of SSREQ1 field.
	DMAC_SREQ_SSREQ1_Msk = 0x4
	// Bit SSREQ1.
	DMAC_SREQ_SSREQ1 = 0x4
	// Position of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Pos = 0x3
	// Bit mask of DSREQ1 field.
	DMAC_SREQ_DSREQ1_Msk = 0x8
	// Bit DSREQ1.
	DMAC_SREQ_DSREQ1 = 0x8
	// Position of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Pos = 0x4
	// Bit mask of SSREQ2 field.
	DMAC_SREQ_SSREQ2_Msk = 0x10
	// Bit SSREQ2.
	DMAC_SREQ_SSREQ2 = 0x10
	// Position of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Pos = 0x5
	// Bit mask of DSREQ2 field.
	DMAC_SREQ_DSREQ2_Msk = 0x20
	// Bit DSREQ2.
	DMAC_SREQ_DSREQ2 = 0x20
	// Position of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Pos = 0x6
	// Bit mask of SSREQ3 field.
	DMAC_SREQ_SSREQ3_Msk = 0x40
	// Bit SSREQ3.
	DMAC_SREQ_SSREQ3 = 0x40
	// Position of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Pos = 0x7
	// Bit mask of DSREQ3 field.
	DMAC_SREQ_DSREQ3_Msk = 0x80
	// Bit DSREQ3.
	DMAC_SREQ_DSREQ3 = 0x80
	// Position of SSREQ4 field.
	DMAC_SREQ_SSREQ4_Pos = 0x8
	// Bit mask of SSREQ4 field.
	DMAC_SREQ_SSREQ4_Msk = 0x100
	// Bit SSREQ4.
	DMAC_SREQ_SSREQ4 = 0x100
	// Position of DSREQ4 field.
	DMAC_SREQ_DSREQ4_Pos = 0x9
	// Bit mask of DSREQ4 field.
	DMAC_SREQ_DSREQ4_Msk = 0x200
	// Bit DSREQ4.
	DMAC_SREQ_DSREQ4 = 0x200
	// Position of SSREQ5 field.
	DMAC_SREQ_SSREQ5_Pos = 0xa
	// Bit mask of SSREQ5 field.
	DMAC_SREQ_SSREQ5_Msk = 0x400
	// Bit SSREQ5.
	DMAC_SREQ_SSREQ5 = 0x400
	// Position of DSREQ5 field.
	DMAC_SREQ_DSREQ5_Pos = 0xb
	// Bit mask of DSREQ5 field.
	DMAC_SREQ_DSREQ5_Msk = 0x800
	// Bit DSREQ5.
	DMAC_SREQ_DSREQ5 = 0x800
	// Position of SSREQ6 field.
	DMAC_SREQ_SSREQ6_Pos = 0xc
	// Bit mask of SSREQ6 field.
	DMAC_SREQ_SSREQ6_Msk = 0x1000
	// Bit SSREQ6.
	DMAC_SREQ_SSREQ6 = 0x1000
	// Position of DSREQ6 field.
	DMAC_SREQ_DSREQ6_Pos = 0xd
	// Bit mask of DSREQ6 field.
	DMAC_SREQ_DSREQ6_Msk = 0x2000
	// Bit DSREQ6.
	DMAC_SREQ_DSREQ6 = 0x2000
	// Position of SSREQ7 field.
	DMAC_SREQ_SSREQ7_Pos = 0xe
	// Bit mask of SSREQ7 field.
	DMAC_SREQ_SSREQ7_Msk = 0x4000
	// Bit SSREQ7.
	DMAC_SREQ_SSREQ7 = 0x4000
	// Position of DSREQ7 field.
	DMAC_SREQ_DSREQ7_Pos = 0xf
	// Bit mask of DSREQ7 field.
	DMAC_SREQ_DSREQ7_Msk = 0x8000
	// Bit DSREQ7.
	DMAC_SREQ_DSREQ7 = 0x8000

	// CREQ: DMAC Software Chunk Transfer Request Register
	// Position of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Pos = 0x0
	// Bit mask of SCREQ0 field.
	DMAC_CREQ_SCREQ0_Msk = 0x1
	// Bit SCREQ0.
	DMAC_CREQ_SCREQ0 = 0x1
	// Position of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Pos = 0x1
	// Bit mask of DCREQ0 field.
	DMAC_CREQ_DCREQ0_Msk = 0x2
	// Bit DCREQ0.
	DMAC_CREQ_DCREQ0 = 0x2
	// Position of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Pos = 0x2
	// Bit mask of SCREQ1 field.
	DMAC_CREQ_SCREQ1_Msk = 0x4
	// Bit SCREQ1.
	DMAC_CREQ_SCREQ1 = 0x4
	// Position of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Pos = 0x3
	// Bit mask of DCREQ1 field.
	DMAC_CREQ_DCREQ1_Msk = 0x8
	// Bit DCREQ1.
	DMAC_CREQ_DCREQ1 = 0x8
	// Position of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Pos = 0x4
	// Bit mask of SCREQ2 field.
	DMAC_CREQ_SCREQ2_Msk = 0x10
	// Bit SCREQ2.
	DMAC_CREQ_SCREQ2 = 0x10
	// Position of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Pos = 0x5
	// Bit mask of DCREQ2 field.
	DMAC_CREQ_DCREQ2_Msk = 0x20
	// Bit DCREQ2.
	DMAC_CREQ_DCREQ2 = 0x20
	// Position of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Pos = 0x6
	// Bit mask of SCREQ3 field.
	DMAC_CREQ_SCREQ3_Msk = 0x40
	// Bit SCREQ3.
	DMAC_CREQ_SCREQ3 = 0x40
	// Position of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Pos = 0x7
	// Bit mask of DCREQ3 field.
	DMAC_CREQ_DCREQ3_Msk = 0x80
	// Bit DCREQ3.
	DMAC_CREQ_DCREQ3 = 0x80
	// Position of SCREQ4 field.
	DMAC_CREQ_SCREQ4_Pos = 0x8
	// Bit mask of SCREQ4 field.
	DMAC_CREQ_SCREQ4_Msk = 0x100
	// Bit SCREQ4.
	DMAC_CREQ_SCREQ4 = 0x100
	// Position of DCREQ4 field.
	DMAC_CREQ_DCREQ4_Pos = 0x9
	// Bit mask of DCREQ4 field.
	DMAC_CREQ_DCREQ4_Msk = 0x200
	// Bit DCREQ4.
	DMAC_CREQ_DCREQ4 = 0x200
	// Position of SCREQ5 field.
	DMAC_CREQ_SCREQ5_Pos = 0xa
	// Bit mask of SCREQ5 field.
	DMAC_CREQ_SCREQ5_Msk = 0x400
	// Bit SCREQ5.
	DMAC_CREQ_SCREQ5 = 0x400
	// Position of DCREQ5 field.
	DMAC_CREQ_DCREQ5_Pos = 0xb
	// Bit mask of DCREQ5 field.
	DMAC_CREQ_DCREQ5_Msk = 0x800
	// Bit DCREQ5.
	DMAC_CREQ_DCREQ5 = 0x800
	// Position of SCREQ6 field.
	DMAC_CREQ_SCREQ6_Pos = 0xc
	// Bit mask of SCREQ6 field.
	DMAC_CREQ_SCREQ6_Msk = 0x1000
	// Bit SCREQ6.
	DMAC_CREQ_SCREQ6 = 0x1000
	// Position of DCREQ6 field.
	DMAC_CREQ_DCREQ6_Pos = 0xd
	// Bit mask of DCREQ6 field.
	DMAC_CREQ_DCREQ6_Msk = 0x2000
	// Bit DCREQ6.
	DMAC_CREQ_DCREQ6 = 0x2000
	// Position of SCREQ7 field.
	DMAC_CREQ_SCREQ7_Pos = 0xe
	// Bit mask of SCREQ7 field.
	DMAC_CREQ_SCREQ7_Msk = 0x4000
	// Bit SCREQ7.
	DMAC_CREQ_SCREQ7 = 0x4000
	// Position of DCREQ7 field.
	DMAC_CREQ_DCREQ7_Pos = 0xf
	// Bit mask of DCREQ7 field.
	DMAC_CREQ_DCREQ7_Msk = 0x8000
	// Bit DCREQ7.
	DMAC_CREQ_DCREQ7 = 0x8000

	// LAST: DMAC Software Last Transfer Flag Register
	// Position of SLAST0 field.
	DMAC_LAST_SLAST0_Pos = 0x0
	// Bit mask of SLAST0 field.
	DMAC_LAST_SLAST0_Msk = 0x1
	// Bit SLAST0.
	DMAC_LAST_SLAST0 = 0x1
	// Position of DLAST0 field.
	DMAC_LAST_DLAST0_Pos = 0x1
	// Bit mask of DLAST0 field.
	DMAC_LAST_DLAST0_Msk = 0x2
	// Bit DLAST0.
	DMAC_LAST_DLAST0 = 0x2
	// Position of SLAST1 field.
	DMAC_LAST_SLAST1_Pos = 0x2
	// Bit mask of SLAST1 field.
	DMAC_LAST_SLAST1_Msk = 0x4
	// Bit SLAST1.
	DMAC_LAST_SLAST1 = 0x4
	// Position of DLAST1 field.
	DMAC_LAST_DLAST1_Pos = 0x3
	// Bit mask of DLAST1 field.
	DMAC_LAST_DLAST1_Msk = 0x8
	// Bit DLAST1.
	DMAC_LAST_DLAST1 = 0x8
	// Position of SLAST2 field.
	DMAC_LAST_SLAST2_Pos = 0x4
	// Bit mask of SLAST2 field.
	DMAC_LAST_SLAST2_Msk = 0x10
	// Bit SLAST2.
	DMAC_LAST_SLAST2 = 0x10
	// Position of DLAST2 field.
	DMAC_LAST_DLAST2_Pos = 0x5
	// Bit mask of DLAST2 field.
	DMAC_LAST_DLAST2_Msk = 0x20
	// Bit DLAST2.
	DMAC_LAST_DLAST2 = 0x20
	// Position of SLAST3 field.
	DMAC_LAST_SLAST3_Pos = 0x6
	// Bit mask of SLAST3 field.
	DMAC_LAST_SLAST3_Msk = 0x40
	// Bit SLAST3.
	DMAC_LAST_SLAST3 = 0x40
	// Position of DLAST3 field.
	DMAC_LAST_DLAST3_Pos = 0x7
	// Bit mask of DLAST3 field.
	DMAC_LAST_DLAST3_Msk = 0x80
	// Bit DLAST3.
	DMAC_LAST_DLAST3 = 0x80
	// Position of SLAST4 field.
	DMAC_LAST_SLAST4_Pos = 0x8
	// Bit mask of SLAST4 field.
	DMAC_LAST_SLAST4_Msk = 0x100
	// Bit SLAST4.
	DMAC_LAST_SLAST4 = 0x100
	// Position of DLAST4 field.
	DMAC_LAST_DLAST4_Pos = 0x9
	// Bit mask of DLAST4 field.
	DMAC_LAST_DLAST4_Msk = 0x200
	// Bit DLAST4.
	DMAC_LAST_DLAST4 = 0x200
	// Position of SLAST5 field.
	DMAC_LAST_SLAST5_Pos = 0xa
	// Bit mask of SLAST5 field.
	DMAC_LAST_SLAST5_Msk = 0x400
	// Bit SLAST5.
	DMAC_LAST_SLAST5 = 0x400
	// Position of DLAST5 field.
	DMAC_LAST_DLAST5_Pos = 0xb
	// Bit mask of DLAST5 field.
	DMAC_LAST_DLAST5_Msk = 0x800
	// Bit DLAST5.
	DMAC_LAST_DLAST5 = 0x800
	// Position of SLAST6 field.
	DMAC_LAST_SLAST6_Pos = 0xc
	// Bit mask of SLAST6 field.
	DMAC_LAST_SLAST6_Msk = 0x1000
	// Bit SLAST6.
	DMAC_LAST_SLAST6 = 0x1000
	// Position of DLAST6 field.
	DMAC_LAST_DLAST6_Pos = 0xd
	// Bit mask of DLAST6 field.
	DMAC_LAST_DLAST6_Msk = 0x2000
	// Bit DLAST6.
	DMAC_LAST_DLAST6 = 0x2000
	// Position of SLAST7 field.
	DMAC_LAST_SLAST7_Pos = 0xe
	// Bit mask of SLAST7 field.
	DMAC_LAST_SLAST7_Msk = 0x4000
	// Bit SLAST7.
	DMAC_LAST_SLAST7 = 0x4000
	// Position of DLAST7 field.
	DMAC_LAST_DLAST7_Pos = 0xf
	// Bit mask of DLAST7 field.
	DMAC_LAST_DLAST7_Msk = 0x8000
	// Bit DLAST7.
	DMAC_LAST_DLAST7 = 0x8000

	// EBCIER: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Enable register.
	// Position of BTC0 field.
	DMAC_EBCIER_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIER_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIER_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIER_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIER_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIER_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIER_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIER_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIER_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIER_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIER_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIER_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCIER_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCIER_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCIER_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCIER_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCIER_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCIER_BTC5 = 0x20
	// Position of BTC6 field.
	DMAC_EBCIER_BTC6_Pos = 0x6
	// Bit mask of BTC6 field.
	DMAC_EBCIER_BTC6_Msk = 0x40
	// Bit BTC6.
	DMAC_EBCIER_BTC6 = 0x40
	// Position of BTC7 field.
	DMAC_EBCIER_BTC7_Pos = 0x7
	// Bit mask of BTC7 field.
	DMAC_EBCIER_BTC7_Msk = 0x80
	// Bit BTC7.
	DMAC_EBCIER_BTC7 = 0x80
	// Position of CBTC0 field.
	DMAC_EBCIER_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIER_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIER_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIER_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIER_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIER_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIER_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIER_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIER_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIER_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIER_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIER_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCIER_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCIER_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCIER_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCIER_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCIER_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCIER_CBTC5 = 0x2000
	// Position of CBTC6 field.
	DMAC_EBCIER_CBTC6_Pos = 0xe
	// Bit mask of CBTC6 field.
	DMAC_EBCIER_CBTC6_Msk = 0x4000
	// Bit CBTC6.
	DMAC_EBCIER_CBTC6 = 0x4000
	// Position of CBTC7 field.
	DMAC_EBCIER_CBTC7_Pos = 0xf
	// Bit mask of CBTC7 field.
	DMAC_EBCIER_CBTC7_Msk = 0x8000
	// Bit CBTC7.
	DMAC_EBCIER_CBTC7 = 0x8000
	// Position of ERR0 field.
	DMAC_EBCIER_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIER_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIER_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIER_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIER_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIER_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIER_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIER_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIER_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIER_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIER_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIER_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCIER_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCIER_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCIER_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCIER_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCIER_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCIER_ERR5 = 0x200000
	// Position of ERR6 field.
	DMAC_EBCIER_ERR6_Pos = 0x16
	// Bit mask of ERR6 field.
	DMAC_EBCIER_ERR6_Msk = 0x400000
	// Bit ERR6.
	DMAC_EBCIER_ERR6 = 0x400000
	// Position of ERR7 field.
	DMAC_EBCIER_ERR7_Pos = 0x17
	// Bit mask of ERR7 field.
	DMAC_EBCIER_ERR7_Msk = 0x800000
	// Bit ERR7.
	DMAC_EBCIER_ERR7 = 0x800000
	// Position of DICERR0 field.
	DMAC_EBCIER_DICERR0_Pos = 0x18
	// Bit mask of DICERR0 field.
	DMAC_EBCIER_DICERR0_Msk = 0x1000000
	// Bit DICERR0.
	DMAC_EBCIER_DICERR0 = 0x1000000
	// Position of DICERR1 field.
	DMAC_EBCIER_DICERR1_Pos = 0x19
	// Bit mask of DICERR1 field.
	DMAC_EBCIER_DICERR1_Msk = 0x2000000
	// Bit DICERR1.
	DMAC_EBCIER_DICERR1 = 0x2000000
	// Position of DICERR2 field.
	DMAC_EBCIER_DICERR2_Pos = 0x1a
	// Bit mask of DICERR2 field.
	DMAC_EBCIER_DICERR2_Msk = 0x4000000
	// Bit DICERR2.
	DMAC_EBCIER_DICERR2 = 0x4000000
	// Position of DICERR3 field.
	DMAC_EBCIER_DICERR3_Pos = 0x1b
	// Bit mask of DICERR3 field.
	DMAC_EBCIER_DICERR3_Msk = 0x8000000
	// Bit DICERR3.
	DMAC_EBCIER_DICERR3 = 0x8000000
	// Position of DICERR4 field.
	DMAC_EBCIER_DICERR4_Pos = 0x1c
	// Bit mask of DICERR4 field.
	DMAC_EBCIER_DICERR4_Msk = 0x10000000
	// Bit DICERR4.
	DMAC_EBCIER_DICERR4 = 0x10000000
	// Position of DICERR5 field.
	DMAC_EBCIER_DICERR5_Pos = 0x1d
	// Bit mask of DICERR5 field.
	DMAC_EBCIER_DICERR5_Msk = 0x20000000
	// Bit DICERR5.
	DMAC_EBCIER_DICERR5 = 0x20000000
	// Position of DICERR6 field.
	DMAC_EBCIER_DICERR6_Pos = 0x1e
	// Bit mask of DICERR6 field.
	DMAC_EBCIER_DICERR6_Msk = 0x40000000
	// Bit DICERR6.
	DMAC_EBCIER_DICERR6 = 0x40000000
	// Position of DICERR7 field.
	DMAC_EBCIER_DICERR7_Pos = 0x1f
	// Bit mask of DICERR7 field.
	DMAC_EBCIER_DICERR7_Msk = 0x80000000
	// Bit DICERR7.
	DMAC_EBCIER_DICERR7 = 0x80000000

	// EBCIDR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer Transfer Completed Interrupt Disable register.
	// Position of BTC0 field.
	DMAC_EBCIDR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIDR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIDR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIDR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIDR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIDR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIDR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIDR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIDR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIDR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIDR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIDR_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCIDR_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCIDR_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCIDR_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCIDR_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCIDR_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCIDR_BTC5 = 0x20
	// Position of BTC6 field.
	DMAC_EBCIDR_BTC6_Pos = 0x6
	// Bit mask of BTC6 field.
	DMAC_EBCIDR_BTC6_Msk = 0x40
	// Bit BTC6.
	DMAC_EBCIDR_BTC6 = 0x40
	// Position of BTC7 field.
	DMAC_EBCIDR_BTC7_Pos = 0x7
	// Bit mask of BTC7 field.
	DMAC_EBCIDR_BTC7_Msk = 0x80
	// Bit BTC7.
	DMAC_EBCIDR_BTC7 = 0x80
	// Position of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIDR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIDR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIDR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIDR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIDR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIDR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIDR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIDR_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCIDR_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCIDR_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCIDR_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCIDR_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCIDR_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCIDR_CBTC5 = 0x2000
	// Position of CBTC6 field.
	DMAC_EBCIDR_CBTC6_Pos = 0xe
	// Bit mask of CBTC6 field.
	DMAC_EBCIDR_CBTC6_Msk = 0x4000
	// Bit CBTC6.
	DMAC_EBCIDR_CBTC6 = 0x4000
	// Position of CBTC7 field.
	DMAC_EBCIDR_CBTC7_Pos = 0xf
	// Bit mask of CBTC7 field.
	DMAC_EBCIDR_CBTC7_Msk = 0x8000
	// Bit CBTC7.
	DMAC_EBCIDR_CBTC7 = 0x8000
	// Position of ERR0 field.
	DMAC_EBCIDR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIDR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIDR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIDR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIDR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIDR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIDR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIDR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIDR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIDR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIDR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIDR_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCIDR_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCIDR_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCIDR_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCIDR_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCIDR_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCIDR_ERR5 = 0x200000
	// Position of ERR6 field.
	DMAC_EBCIDR_ERR6_Pos = 0x16
	// Bit mask of ERR6 field.
	DMAC_EBCIDR_ERR6_Msk = 0x400000
	// Bit ERR6.
	DMAC_EBCIDR_ERR6 = 0x400000
	// Position of ERR7 field.
	DMAC_EBCIDR_ERR7_Pos = 0x17
	// Bit mask of ERR7 field.
	DMAC_EBCIDR_ERR7_Msk = 0x800000
	// Bit ERR7.
	DMAC_EBCIDR_ERR7 = 0x800000
	// Position of DICERR0 field.
	DMAC_EBCIDR_DICERR0_Pos = 0x18
	// Bit mask of DICERR0 field.
	DMAC_EBCIDR_DICERR0_Msk = 0x1000000
	// Bit DICERR0.
	DMAC_EBCIDR_DICERR0 = 0x1000000
	// Position of DICERR1 field.
	DMAC_EBCIDR_DICERR1_Pos = 0x19
	// Bit mask of DICERR1 field.
	DMAC_EBCIDR_DICERR1_Msk = 0x2000000
	// Bit DICERR1.
	DMAC_EBCIDR_DICERR1 = 0x2000000
	// Position of DICERR2 field.
	DMAC_EBCIDR_DICERR2_Pos = 0x1a
	// Bit mask of DICERR2 field.
	DMAC_EBCIDR_DICERR2_Msk = 0x4000000
	// Bit DICERR2.
	DMAC_EBCIDR_DICERR2 = 0x4000000
	// Position of DICERR3 field.
	DMAC_EBCIDR_DICERR3_Pos = 0x1b
	// Bit mask of DICERR3 field.
	DMAC_EBCIDR_DICERR3_Msk = 0x8000000
	// Bit DICERR3.
	DMAC_EBCIDR_DICERR3 = 0x8000000
	// Position of DICERR4 field.
	DMAC_EBCIDR_DICERR4_Pos = 0x1c
	// Bit mask of DICERR4 field.
	DMAC_EBCIDR_DICERR4_Msk = 0x10000000
	// Bit DICERR4.
	DMAC_EBCIDR_DICERR4 = 0x10000000
	// Position of DICERR5 field.
	DMAC_EBCIDR_DICERR5_Pos = 0x1d
	// Bit mask of DICERR5 field.
	DMAC_EBCIDR_DICERR5_Msk = 0x20000000
	// Bit DICERR5.
	DMAC_EBCIDR_DICERR5 = 0x20000000
	// Position of DICERR6 field.
	DMAC_EBCIDR_DICERR6_Pos = 0x1e
	// Bit mask of DICERR6 field.
	DMAC_EBCIDR_DICERR6_Msk = 0x40000000
	// Bit DICERR6.
	DMAC_EBCIDR_DICERR6 = 0x40000000
	// Position of DICERR7 field.
	DMAC_EBCIDR_DICERR7_Pos = 0x1f
	// Bit mask of DICERR7 field.
	DMAC_EBCIDR_DICERR7_Msk = 0x80000000
	// Bit DICERR7.
	DMAC_EBCIDR_DICERR7 = 0x80000000

	// EBCIMR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Mask Register.
	// Position of BTC0 field.
	DMAC_EBCIMR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCIMR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCIMR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCIMR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCIMR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCIMR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCIMR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCIMR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCIMR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCIMR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCIMR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCIMR_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCIMR_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCIMR_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCIMR_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCIMR_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCIMR_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCIMR_BTC5 = 0x20
	// Position of BTC6 field.
	DMAC_EBCIMR_BTC6_Pos = 0x6
	// Bit mask of BTC6 field.
	DMAC_EBCIMR_BTC6_Msk = 0x40
	// Bit BTC6.
	DMAC_EBCIMR_BTC6 = 0x40
	// Position of BTC7 field.
	DMAC_EBCIMR_BTC7_Pos = 0x7
	// Bit mask of BTC7 field.
	DMAC_EBCIMR_BTC7_Msk = 0x80
	// Bit BTC7.
	DMAC_EBCIMR_BTC7 = 0x80
	// Position of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCIMR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCIMR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCIMR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCIMR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCIMR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCIMR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCIMR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCIMR_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCIMR_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCIMR_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCIMR_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCIMR_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCIMR_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCIMR_CBTC5 = 0x2000
	// Position of CBTC6 field.
	DMAC_EBCIMR_CBTC6_Pos = 0xe
	// Bit mask of CBTC6 field.
	DMAC_EBCIMR_CBTC6_Msk = 0x4000
	// Bit CBTC6.
	DMAC_EBCIMR_CBTC6 = 0x4000
	// Position of CBTC7 field.
	DMAC_EBCIMR_CBTC7_Pos = 0xf
	// Bit mask of CBTC7 field.
	DMAC_EBCIMR_CBTC7_Msk = 0x8000
	// Bit CBTC7.
	DMAC_EBCIMR_CBTC7 = 0x8000
	// Position of ERR0 field.
	DMAC_EBCIMR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCIMR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCIMR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCIMR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCIMR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCIMR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCIMR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCIMR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCIMR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCIMR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCIMR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCIMR_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCIMR_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCIMR_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCIMR_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCIMR_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCIMR_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCIMR_ERR5 = 0x200000
	// Position of ERR6 field.
	DMAC_EBCIMR_ERR6_Pos = 0x16
	// Bit mask of ERR6 field.
	DMAC_EBCIMR_ERR6_Msk = 0x400000
	// Bit ERR6.
	DMAC_EBCIMR_ERR6 = 0x400000
	// Position of ERR7 field.
	DMAC_EBCIMR_ERR7_Pos = 0x17
	// Bit mask of ERR7 field.
	DMAC_EBCIMR_ERR7_Msk = 0x800000
	// Bit ERR7.
	DMAC_EBCIMR_ERR7 = 0x800000
	// Position of DICERR0 field.
	DMAC_EBCIMR_DICERR0_Pos = 0x18
	// Bit mask of DICERR0 field.
	DMAC_EBCIMR_DICERR0_Msk = 0x1000000
	// Bit DICERR0.
	DMAC_EBCIMR_DICERR0 = 0x1000000
	// Position of DICERR1 field.
	DMAC_EBCIMR_DICERR1_Pos = 0x19
	// Bit mask of DICERR1 field.
	DMAC_EBCIMR_DICERR1_Msk = 0x2000000
	// Bit DICERR1.
	DMAC_EBCIMR_DICERR1 = 0x2000000
	// Position of DICERR2 field.
	DMAC_EBCIMR_DICERR2_Pos = 0x1a
	// Bit mask of DICERR2 field.
	DMAC_EBCIMR_DICERR2_Msk = 0x4000000
	// Bit DICERR2.
	DMAC_EBCIMR_DICERR2 = 0x4000000
	// Position of DICERR3 field.
	DMAC_EBCIMR_DICERR3_Pos = 0x1b
	// Bit mask of DICERR3 field.
	DMAC_EBCIMR_DICERR3_Msk = 0x8000000
	// Bit DICERR3.
	DMAC_EBCIMR_DICERR3 = 0x8000000
	// Position of DICERR4 field.
	DMAC_EBCIMR_DICERR4_Pos = 0x1c
	// Bit mask of DICERR4 field.
	DMAC_EBCIMR_DICERR4_Msk = 0x10000000
	// Bit DICERR4.
	DMAC_EBCIMR_DICERR4 = 0x10000000
	// Position of DICERR5 field.
	DMAC_EBCIMR_DICERR5_Pos = 0x1d
	// Bit mask of DICERR5 field.
	DMAC_EBCIMR_DICERR5_Msk = 0x20000000
	// Bit DICERR5.
	DMAC_EBCIMR_DICERR5 = 0x20000000
	// Position of DICERR6 field.
	DMAC_EBCIMR_DICERR6_Pos = 0x1e
	// Bit mask of DICERR6 field.
	DMAC_EBCIMR_DICERR6_Msk = 0x40000000
	// Bit DICERR6.
	DMAC_EBCIMR_DICERR6 = 0x40000000
	// Position of DICERR7 field.
	DMAC_EBCIMR_DICERR7_Pos = 0x1f
	// Bit mask of DICERR7 field.
	DMAC_EBCIMR_DICERR7_Msk = 0x80000000
	// Bit DICERR7.
	DMAC_EBCIMR_DICERR7 = 0x80000000

	// EBCISR: DMAC Error, Chained Buffer Transfer Completed Interrupt and Buffer transfer completed Status Register.
	// Position of BTC0 field.
	DMAC_EBCISR_BTC0_Pos = 0x0
	// Bit mask of BTC0 field.
	DMAC_EBCISR_BTC0_Msk = 0x1
	// Bit BTC0.
	DMAC_EBCISR_BTC0 = 0x1
	// Position of BTC1 field.
	DMAC_EBCISR_BTC1_Pos = 0x1
	// Bit mask of BTC1 field.
	DMAC_EBCISR_BTC1_Msk = 0x2
	// Bit BTC1.
	DMAC_EBCISR_BTC1 = 0x2
	// Position of BTC2 field.
	DMAC_EBCISR_BTC2_Pos = 0x2
	// Bit mask of BTC2 field.
	DMAC_EBCISR_BTC2_Msk = 0x4
	// Bit BTC2.
	DMAC_EBCISR_BTC2 = 0x4
	// Position of BTC3 field.
	DMAC_EBCISR_BTC3_Pos = 0x3
	// Bit mask of BTC3 field.
	DMAC_EBCISR_BTC3_Msk = 0x8
	// Bit BTC3.
	DMAC_EBCISR_BTC3 = 0x8
	// Position of BTC4 field.
	DMAC_EBCISR_BTC4_Pos = 0x4
	// Bit mask of BTC4 field.
	DMAC_EBCISR_BTC4_Msk = 0x10
	// Bit BTC4.
	DMAC_EBCISR_BTC4 = 0x10
	// Position of BTC5 field.
	DMAC_EBCISR_BTC5_Pos = 0x5
	// Bit mask of BTC5 field.
	DMAC_EBCISR_BTC5_Msk = 0x20
	// Bit BTC5.
	DMAC_EBCISR_BTC5 = 0x20
	// Position of BTC6 field.
	DMAC_EBCISR_BTC6_Pos = 0x6
	// Bit mask of BTC6 field.
	DMAC_EBCISR_BTC6_Msk = 0x40
	// Bit BTC6.
	DMAC_EBCISR_BTC6 = 0x40
	// Position of BTC7 field.
	DMAC_EBCISR_BTC7_Pos = 0x7
	// Bit mask of BTC7 field.
	DMAC_EBCISR_BTC7_Msk = 0x80
	// Bit BTC7.
	DMAC_EBCISR_BTC7 = 0x80
	// Position of CBTC0 field.
	DMAC_EBCISR_CBTC0_Pos = 0x8
	// Bit mask of CBTC0 field.
	DMAC_EBCISR_CBTC0_Msk = 0x100
	// Bit CBTC0.
	DMAC_EBCISR_CBTC0 = 0x100
	// Position of CBTC1 field.
	DMAC_EBCISR_CBTC1_Pos = 0x9
	// Bit mask of CBTC1 field.
	DMAC_EBCISR_CBTC1_Msk = 0x200
	// Bit CBTC1.
	DMAC_EBCISR_CBTC1 = 0x200
	// Position of CBTC2 field.
	DMAC_EBCISR_CBTC2_Pos = 0xa
	// Bit mask of CBTC2 field.
	DMAC_EBCISR_CBTC2_Msk = 0x400
	// Bit CBTC2.
	DMAC_EBCISR_CBTC2 = 0x400
	// Position of CBTC3 field.
	DMAC_EBCISR_CBTC3_Pos = 0xb
	// Bit mask of CBTC3 field.
	DMAC_EBCISR_CBTC3_Msk = 0x800
	// Bit CBTC3.
	DMAC_EBCISR_CBTC3 = 0x800
	// Position of CBTC4 field.
	DMAC_EBCISR_CBTC4_Pos = 0xc
	// Bit mask of CBTC4 field.
	DMAC_EBCISR_CBTC4_Msk = 0x1000
	// Bit CBTC4.
	DMAC_EBCISR_CBTC4 = 0x1000
	// Position of CBTC5 field.
	DMAC_EBCISR_CBTC5_Pos = 0xd
	// Bit mask of CBTC5 field.
	DMAC_EBCISR_CBTC5_Msk = 0x2000
	// Bit CBTC5.
	DMAC_EBCISR_CBTC5 = 0x2000
	// Position of CBTC6 field.
	DMAC_EBCISR_CBTC6_Pos = 0xe
	// Bit mask of CBTC6 field.
	DMAC_EBCISR_CBTC6_Msk = 0x4000
	// Bit CBTC6.
	DMAC_EBCISR_CBTC6 = 0x4000
	// Position of CBTC7 field.
	DMAC_EBCISR_CBTC7_Pos = 0xf
	// Bit mask of CBTC7 field.
	DMAC_EBCISR_CBTC7_Msk = 0x8000
	// Bit CBTC7.
	DMAC_EBCISR_CBTC7 = 0x8000
	// Position of ERR0 field.
	DMAC_EBCISR_ERR0_Pos = 0x10
	// Bit mask of ERR0 field.
	DMAC_EBCISR_ERR0_Msk = 0x10000
	// Bit ERR0.
	DMAC_EBCISR_ERR0 = 0x10000
	// Position of ERR1 field.
	DMAC_EBCISR_ERR1_Pos = 0x11
	// Bit mask of ERR1 field.
	DMAC_EBCISR_ERR1_Msk = 0x20000
	// Bit ERR1.
	DMAC_EBCISR_ERR1 = 0x20000
	// Position of ERR2 field.
	DMAC_EBCISR_ERR2_Pos = 0x12
	// Bit mask of ERR2 field.
	DMAC_EBCISR_ERR2_Msk = 0x40000
	// Bit ERR2.
	DMAC_EBCISR_ERR2 = 0x40000
	// Position of ERR3 field.
	DMAC_EBCISR_ERR3_Pos = 0x13
	// Bit mask of ERR3 field.
	DMAC_EBCISR_ERR3_Msk = 0x80000
	// Bit ERR3.
	DMAC_EBCISR_ERR3 = 0x80000
	// Position of ERR4 field.
	DMAC_EBCISR_ERR4_Pos = 0x14
	// Bit mask of ERR4 field.
	DMAC_EBCISR_ERR4_Msk = 0x100000
	// Bit ERR4.
	DMAC_EBCISR_ERR4 = 0x100000
	// Position of ERR5 field.
	DMAC_EBCISR_ERR5_Pos = 0x15
	// Bit mask of ERR5 field.
	DMAC_EBCISR_ERR5_Msk = 0x200000
	// Bit ERR5.
	DMAC_EBCISR_ERR5 = 0x200000
	// Position of ERR6 field.
	DMAC_EBCISR_ERR6_Pos = 0x16
	// Bit mask of ERR6 field.
	DMAC_EBCISR_ERR6_Msk = 0x400000
	// Bit ERR6.
	DMAC_EBCISR_ERR6 = 0x400000
	// Position of ERR7 field.
	DMAC_EBCISR_ERR7_Pos = 0x17
	// Bit mask of ERR7 field.
	DMAC_EBCISR_ERR7_Msk = 0x800000
	// Bit ERR7.
	DMAC_EBCISR_ERR7 = 0x800000
	// Position of DICERR0 field.
	DMAC_EBCISR_DICERR0_Pos = 0x18
	// Bit mask of DICERR0 field.
	DMAC_EBCISR_DICERR0_Msk = 0x1000000
	// Bit DICERR0.
	DMAC_EBCISR_DICERR0 = 0x1000000
	// Position of DICERR1 field.
	DMAC_EBCISR_DICERR1_Pos = 0x19
	// Bit mask of DICERR1 field.
	DMAC_EBCISR_DICERR1_Msk = 0x2000000
	// Bit DICERR1.
	DMAC_EBCISR_DICERR1 = 0x2000000
	// Position of DICERR2 field.
	DMAC_EBCISR_DICERR2_Pos = 0x1a
	// Bit mask of DICERR2 field.
	DMAC_EBCISR_DICERR2_Msk = 0x4000000
	// Bit DICERR2.
	DMAC_EBCISR_DICERR2 = 0x4000000
	// Position of DICERR3 field.
	DMAC_EBCISR_DICERR3_Pos = 0x1b
	// Bit mask of DICERR3 field.
	DMAC_EBCISR_DICERR3_Msk = 0x8000000
	// Bit DICERR3.
	DMAC_EBCISR_DICERR3 = 0x8000000
	// Position of DICERR4 field.
	DMAC_EBCISR_DICERR4_Pos = 0x1c
	// Bit mask of DICERR4 field.
	DMAC_EBCISR_DICERR4_Msk = 0x10000000
	// Bit DICERR4.
	DMAC_EBCISR_DICERR4 = 0x10000000
	// Position of DICERR5 field.
	DMAC_EBCISR_DICERR5_Pos = 0x1d
	// Bit mask of DICERR5 field.
	DMAC_EBCISR_DICERR5_Msk = 0x20000000
	// Bit DICERR5.
	DMAC_EBCISR_DICERR5 = 0x20000000
	// Position of DICERR6 field.
	DMAC_EBCISR_DICERR6_Pos = 0x1e
	// Bit mask of DICERR6 field.
	DMAC_EBCISR_DICERR6_Msk = 0x40000000
	// Bit DICERR6.
	DMAC_EBCISR_DICERR6 = 0x40000000
	// Position of DICERR7 field.
	DMAC_EBCISR_DICERR7_Pos = 0x1f
	// Bit mask of DICERR7 field.
	DMAC_EBCISR_DICERR7_Msk = 0x80000000
	// Bit DICERR7.
	DMAC_EBCISR_DICERR7 = 0x80000000

	// CHER: DMAC Channel Handler Enable Register
	// Position of ENA0 field.
	DMAC_CHER_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMAC_CHER_ENA0_Msk = 0x1
	// Bit ENA0.
	DMAC_CHER_ENA0 = 0x1
	// Position of ENA1 field.
	DMAC_CHER_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMAC_CHER_ENA1_Msk = 0x2
	// Bit ENA1.
	DMAC_CHER_ENA1 = 0x2
	// Position of ENA2 field.
	DMAC_CHER_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMAC_CHER_ENA2_Msk = 0x4
	// Bit ENA2.
	DMAC_CHER_ENA2 = 0x4
	// Position of ENA3 field.
	DMAC_CHER_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMAC_CHER_ENA3_Msk = 0x8
	// Bit ENA3.
	DMAC_CHER_ENA3 = 0x8
	// Position of ENA4 field.
	DMAC_CHER_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	DMAC_CHER_ENA4_Msk = 0x10
	// Bit ENA4.
	DMAC_CHER_ENA4 = 0x10
	// Position of ENA5 field.
	DMAC_CHER_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	DMAC_CHER_ENA5_Msk = 0x20
	// Bit ENA5.
	DMAC_CHER_ENA5 = 0x20
	// Position of ENA6 field.
	DMAC_CHER_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	DMAC_CHER_ENA6_Msk = 0x40
	// Bit ENA6.
	DMAC_CHER_ENA6 = 0x40
	// Position of ENA7 field.
	DMAC_CHER_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	DMAC_CHER_ENA7_Msk = 0x80
	// Bit ENA7.
	DMAC_CHER_ENA7 = 0x80
	// Position of SUSP0 field.
	DMAC_CHER_SUSP0_Pos = 0x8
	// Bit mask of SUSP0 field.
	DMAC_CHER_SUSP0_Msk = 0x100
	// Bit SUSP0.
	DMAC_CHER_SUSP0 = 0x100
	// Position of SUSP1 field.
	DMAC_CHER_SUSP1_Pos = 0x9
	// Bit mask of SUSP1 field.
	DMAC_CHER_SUSP1_Msk = 0x200
	// Bit SUSP1.
	DMAC_CHER_SUSP1 = 0x200
	// Position of SUSP2 field.
	DMAC_CHER_SUSP2_Pos = 0xa
	// Bit mask of SUSP2 field.
	DMAC_CHER_SUSP2_Msk = 0x400
	// Bit SUSP2.
	DMAC_CHER_SUSP2 = 0x400
	// Position of SUSP3 field.
	DMAC_CHER_SUSP3_Pos = 0xb
	// Bit mask of SUSP3 field.
	DMAC_CHER_SUSP3_Msk = 0x800
	// Bit SUSP3.
	DMAC_CHER_SUSP3 = 0x800
	// Position of SUSP4 field.
	DMAC_CHER_SUSP4_Pos = 0xc
	// Bit mask of SUSP4 field.
	DMAC_CHER_SUSP4_Msk = 0x1000
	// Bit SUSP4.
	DMAC_CHER_SUSP4 = 0x1000
	// Position of SUSP5 field.
	DMAC_CHER_SUSP5_Pos = 0xd
	// Bit mask of SUSP5 field.
	DMAC_CHER_SUSP5_Msk = 0x2000
	// Bit SUSP5.
	DMAC_CHER_SUSP5 = 0x2000
	// Position of SUSP6 field.
	DMAC_CHER_SUSP6_Pos = 0xe
	// Bit mask of SUSP6 field.
	DMAC_CHER_SUSP6_Msk = 0x4000
	// Bit SUSP6.
	DMAC_CHER_SUSP6 = 0x4000
	// Position of SUSP7 field.
	DMAC_CHER_SUSP7_Pos = 0xf
	// Bit mask of SUSP7 field.
	DMAC_CHER_SUSP7_Msk = 0x8000
	// Bit SUSP7.
	DMAC_CHER_SUSP7 = 0x8000
	// Position of KEEP0 field.
	DMAC_CHER_KEEP0_Pos = 0x18
	// Bit mask of KEEP0 field.
	DMAC_CHER_KEEP0_Msk = 0x1000000
	// Bit KEEP0.
	DMAC_CHER_KEEP0 = 0x1000000
	// Position of KEEP1 field.
	DMAC_CHER_KEEP1_Pos = 0x19
	// Bit mask of KEEP1 field.
	DMAC_CHER_KEEP1_Msk = 0x2000000
	// Bit KEEP1.
	DMAC_CHER_KEEP1 = 0x2000000
	// Position of KEEP2 field.
	DMAC_CHER_KEEP2_Pos = 0x1a
	// Bit mask of KEEP2 field.
	DMAC_CHER_KEEP2_Msk = 0x4000000
	// Bit KEEP2.
	DMAC_CHER_KEEP2 = 0x4000000
	// Position of KEEP3 field.
	DMAC_CHER_KEEP3_Pos = 0x1b
	// Bit mask of KEEP3 field.
	DMAC_CHER_KEEP3_Msk = 0x8000000
	// Bit KEEP3.
	DMAC_CHER_KEEP3 = 0x8000000
	// Position of KEEP4 field.
	DMAC_CHER_KEEP4_Pos = 0x1c
	// Bit mask of KEEP4 field.
	DMAC_CHER_KEEP4_Msk = 0x10000000
	// Bit KEEP4.
	DMAC_CHER_KEEP4 = 0x10000000
	// Position of KEEP5 field.
	DMAC_CHER_KEEP5_Pos = 0x1d
	// Bit mask of KEEP5 field.
	DMAC_CHER_KEEP5_Msk = 0x20000000
	// Bit KEEP5.
	DMAC_CHER_KEEP5 = 0x20000000
	// Position of KEEP6 field.
	DMAC_CHER_KEEP6_Pos = 0x1e
	// Bit mask of KEEP6 field.
	DMAC_CHER_KEEP6_Msk = 0x40000000
	// Bit KEEP6.
	DMAC_CHER_KEEP6 = 0x40000000
	// Position of KEEP7 field.
	DMAC_CHER_KEEP7_Pos = 0x1f
	// Bit mask of KEEP7 field.
	DMAC_CHER_KEEP7_Msk = 0x80000000
	// Bit KEEP7.
	DMAC_CHER_KEEP7 = 0x80000000

	// CHDR: DMAC Channel Handler Disable Register
	// Position of DIS0 field.
	DMAC_CHDR_DIS0_Pos = 0x0
	// Bit mask of DIS0 field.
	DMAC_CHDR_DIS0_Msk = 0x1
	// Bit DIS0.
	DMAC_CHDR_DIS0 = 0x1
	// Position of DIS1 field.
	DMAC_CHDR_DIS1_Pos = 0x1
	// Bit mask of DIS1 field.
	DMAC_CHDR_DIS1_Msk = 0x2
	// Bit DIS1.
	DMAC_CHDR_DIS1 = 0x2
	// Position of DIS2 field.
	DMAC_CHDR_DIS2_Pos = 0x2
	// Bit mask of DIS2 field.
	DMAC_CHDR_DIS2_Msk = 0x4
	// Bit DIS2.
	DMAC_CHDR_DIS2 = 0x4
	// Position of DIS3 field.
	DMAC_CHDR_DIS3_Pos = 0x3
	// Bit mask of DIS3 field.
	DMAC_CHDR_DIS3_Msk = 0x8
	// Bit DIS3.
	DMAC_CHDR_DIS3 = 0x8
	// Position of DIS4 field.
	DMAC_CHDR_DIS4_Pos = 0x4
	// Bit mask of DIS4 field.
	DMAC_CHDR_DIS4_Msk = 0x10
	// Bit DIS4.
	DMAC_CHDR_DIS4 = 0x10
	// Position of DIS5 field.
	DMAC_CHDR_DIS5_Pos = 0x5
	// Bit mask of DIS5 field.
	DMAC_CHDR_DIS5_Msk = 0x20
	// Bit DIS5.
	DMAC_CHDR_DIS5 = 0x20
	// Position of DIS6 field.
	DMAC_CHDR_DIS6_Pos = 0x6
	// Bit mask of DIS6 field.
	DMAC_CHDR_DIS6_Msk = 0x40
	// Bit DIS6.
	DMAC_CHDR_DIS6 = 0x40
	// Position of DIS7 field.
	DMAC_CHDR_DIS7_Pos = 0x7
	// Bit mask of DIS7 field.
	DMAC_CHDR_DIS7_Msk = 0x80
	// Bit DIS7.
	DMAC_CHDR_DIS7 = 0x80
	// Position of RES0 field.
	DMAC_CHDR_RES0_Pos = 0x8
	// Bit mask of RES0 field.
	DMAC_CHDR_RES0_Msk = 0x100
	// Bit RES0.
	DMAC_CHDR_RES0 = 0x100
	// Position of RES1 field.
	DMAC_CHDR_RES1_Pos = 0x9
	// Bit mask of RES1 field.
	DMAC_CHDR_RES1_Msk = 0x200
	// Bit RES1.
	DMAC_CHDR_RES1 = 0x200
	// Position of RES2 field.
	DMAC_CHDR_RES2_Pos = 0xa
	// Bit mask of RES2 field.
	DMAC_CHDR_RES2_Msk = 0x400
	// Bit RES2.
	DMAC_CHDR_RES2 = 0x400
	// Position of RES3 field.
	DMAC_CHDR_RES3_Pos = 0xb
	// Bit mask of RES3 field.
	DMAC_CHDR_RES3_Msk = 0x800
	// Bit RES3.
	DMAC_CHDR_RES3 = 0x800
	// Position of RES4 field.
	DMAC_CHDR_RES4_Pos = 0xc
	// Bit mask of RES4 field.
	DMAC_CHDR_RES4_Msk = 0x1000
	// Bit RES4.
	DMAC_CHDR_RES4 = 0x1000
	// Position of RES5 field.
	DMAC_CHDR_RES5_Pos = 0xd
	// Bit mask of RES5 field.
	DMAC_CHDR_RES5_Msk = 0x2000
	// Bit RES5.
	DMAC_CHDR_RES5 = 0x2000
	// Position of RES6 field.
	DMAC_CHDR_RES6_Pos = 0xe
	// Bit mask of RES6 field.
	DMAC_CHDR_RES6_Msk = 0x4000
	// Bit RES6.
	DMAC_CHDR_RES6 = 0x4000
	// Position of RES7 field.
	DMAC_CHDR_RES7_Pos = 0xf
	// Bit mask of RES7 field.
	DMAC_CHDR_RES7_Msk = 0x8000
	// Bit RES7.
	DMAC_CHDR_RES7 = 0x8000

	// CHSR: DMAC Channel Handler Status Register
	// Position of ENA0 field.
	DMAC_CHSR_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	DMAC_CHSR_ENA0_Msk = 0x1
	// Bit ENA0.
	DMAC_CHSR_ENA0 = 0x1
	// Position of ENA1 field.
	DMAC_CHSR_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	DMAC_CHSR_ENA1_Msk = 0x2
	// Bit ENA1.
	DMAC_CHSR_ENA1 = 0x2
	// Position of ENA2 field.
	DMAC_CHSR_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	DMAC_CHSR_ENA2_Msk = 0x4
	// Bit ENA2.
	DMAC_CHSR_ENA2 = 0x4
	// Position of ENA3 field.
	DMAC_CHSR_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	DMAC_CHSR_ENA3_Msk = 0x8
	// Bit ENA3.
	DMAC_CHSR_ENA3 = 0x8
	// Position of ENA4 field.
	DMAC_CHSR_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	DMAC_CHSR_ENA4_Msk = 0x10
	// Bit ENA4.
	DMAC_CHSR_ENA4 = 0x10
	// Position of ENA5 field.
	DMAC_CHSR_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	DMAC_CHSR_ENA5_Msk = 0x20
	// Bit ENA5.
	DMAC_CHSR_ENA5 = 0x20
	// Position of ENA6 field.
	DMAC_CHSR_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	DMAC_CHSR_ENA6_Msk = 0x40
	// Bit ENA6.
	DMAC_CHSR_ENA6 = 0x40
	// Position of ENA7 field.
	DMAC_CHSR_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	DMAC_CHSR_ENA7_Msk = 0x80
	// Bit ENA7.
	DMAC_CHSR_ENA7 = 0x80
	// Position of SUSP0 field.
	DMAC_CHSR_SUSP0_Pos = 0x8
	// Bit mask of SUSP0 field.
	DMAC_CHSR_SUSP0_Msk = 0x100
	// Bit SUSP0.
	DMAC_CHSR_SUSP0 = 0x100
	// Position of SUSP1 field.
	DMAC_CHSR_SUSP1_Pos = 0x9
	// Bit mask of SUSP1 field.
	DMAC_CHSR_SUSP1_Msk = 0x200
	// Bit SUSP1.
	DMAC_CHSR_SUSP1 = 0x200
	// Position of SUSP2 field.
	DMAC_CHSR_SUSP2_Pos = 0xa
	// Bit mask of SUSP2 field.
	DMAC_CHSR_SUSP2_Msk = 0x400
	// Bit SUSP2.
	DMAC_CHSR_SUSP2 = 0x400
	// Position of SUSP3 field.
	DMAC_CHSR_SUSP3_Pos = 0xb
	// Bit mask of SUSP3 field.
	DMAC_CHSR_SUSP3_Msk = 0x800
	// Bit SUSP3.
	DMAC_CHSR_SUSP3 = 0x800
	// Position of SUSP4 field.
	DMAC_CHSR_SUSP4_Pos = 0xc
	// Bit mask of SUSP4 field.
	DMAC_CHSR_SUSP4_Msk = 0x1000
	// Bit SUSP4.
	DMAC_CHSR_SUSP4 = 0x1000
	// Position of SUSP5 field.
	DMAC_CHSR_SUSP5_Pos = 0xd
	// Bit mask of SUSP5 field.
	DMAC_CHSR_SUSP5_Msk = 0x2000
	// Bit SUSP5.
	DMAC_CHSR_SUSP5 = 0x2000
	// Position of SUSP6 field.
	DMAC_CHSR_SUSP6_Pos = 0xe
	// Bit mask of SUSP6 field.
	DMAC_CHSR_SUSP6_Msk = 0x4000
	// Bit SUSP6.
	DMAC_CHSR_SUSP6 = 0x4000
	// Position of SUSP7 field.
	DMAC_CHSR_SUSP7_Pos = 0xf
	// Bit mask of SUSP7 field.
	DMAC_CHSR_SUSP7_Msk = 0x8000
	// Bit SUSP7.
	DMAC_CHSR_SUSP7 = 0x8000
	// Position of EMPT0 field.
	DMAC_CHSR_EMPT0_Pos = 0x10
	// Bit mask of EMPT0 field.
	DMAC_CHSR_EMPT0_Msk = 0x10000
	// Bit EMPT0.
	DMAC_CHSR_EMPT0 = 0x10000
	// Position of EMPT1 field.
	DMAC_CHSR_EMPT1_Pos = 0x11
	// Bit mask of EMPT1 field.
	DMAC_CHSR_EMPT1_Msk = 0x20000
	// Bit EMPT1.
	DMAC_CHSR_EMPT1 = 0x20000
	// Position of EMPT2 field.
	DMAC_CHSR_EMPT2_Pos = 0x12
	// Bit mask of EMPT2 field.
	DMAC_CHSR_EMPT2_Msk = 0x40000
	// Bit EMPT2.
	DMAC_CHSR_EMPT2 = 0x40000
	// Position of EMPT3 field.
	DMAC_CHSR_EMPT3_Pos = 0x13
	// Bit mask of EMPT3 field.
	DMAC_CHSR_EMPT3_Msk = 0x80000
	// Bit EMPT3.
	DMAC_CHSR_EMPT3 = 0x80000
	// Position of EMPT4 field.
	DMAC_CHSR_EMPT4_Pos = 0x14
	// Bit mask of EMPT4 field.
	DMAC_CHSR_EMPT4_Msk = 0x100000
	// Bit EMPT4.
	DMAC_CHSR_EMPT4 = 0x100000
	// Position of EMPT5 field.
	DMAC_CHSR_EMPT5_Pos = 0x15
	// Bit mask of EMPT5 field.
	DMAC_CHSR_EMPT5_Msk = 0x200000
	// Bit EMPT5.
	DMAC_CHSR_EMPT5 = 0x200000
	// Position of EMPT6 field.
	DMAC_CHSR_EMPT6_Pos = 0x16
	// Bit mask of EMPT6 field.
	DMAC_CHSR_EMPT6_Msk = 0x400000
	// Bit EMPT6.
	DMAC_CHSR_EMPT6 = 0x400000
	// Position of EMPT7 field.
	DMAC_CHSR_EMPT7_Pos = 0x17
	// Bit mask of EMPT7 field.
	DMAC_CHSR_EMPT7_Msk = 0x800000
	// Bit EMPT7.
	DMAC_CHSR_EMPT7 = 0x800000
	// Position of STAL0 field.
	DMAC_CHSR_STAL0_Pos = 0x18
	// Bit mask of STAL0 field.
	DMAC_CHSR_STAL0_Msk = 0x1000000
	// Bit STAL0.
	DMAC_CHSR_STAL0 = 0x1000000
	// Position of STAL1 field.
	DMAC_CHSR_STAL1_Pos = 0x19
	// Bit mask of STAL1 field.
	DMAC_CHSR_STAL1_Msk = 0x2000000
	// Bit STAL1.
	DMAC_CHSR_STAL1 = 0x2000000
	// Position of STAL2 field.
	DMAC_CHSR_STAL2_Pos = 0x1a
	// Bit mask of STAL2 field.
	DMAC_CHSR_STAL2_Msk = 0x4000000
	// Bit STAL2.
	DMAC_CHSR_STAL2 = 0x4000000
	// Position of STAL3 field.
	DMAC_CHSR_STAL3_Pos = 0x1b
	// Bit mask of STAL3 field.
	DMAC_CHSR_STAL3_Msk = 0x8000000
	// Bit STAL3.
	DMAC_CHSR_STAL3 = 0x8000000
	// Position of STAL4 field.
	DMAC_CHSR_STAL4_Pos = 0x1c
	// Bit mask of STAL4 field.
	DMAC_CHSR_STAL4_Msk = 0x10000000
	// Bit STAL4.
	DMAC_CHSR_STAL4 = 0x10000000
	// Position of STAL5 field.
	DMAC_CHSR_STAL5_Pos = 0x1d
	// Bit mask of STAL5 field.
	DMAC_CHSR_STAL5_Msk = 0x20000000
	// Bit STAL5.
	DMAC_CHSR_STAL5 = 0x20000000
	// Position of STAL6 field.
	DMAC_CHSR_STAL6_Pos = 0x1e
	// Bit mask of STAL6 field.
	DMAC_CHSR_STAL6_Msk = 0x40000000
	// Bit STAL6.
	DMAC_CHSR_STAL6 = 0x40000000
	// Position of STAL7 field.
	DMAC_CHSR_STAL7_Pos = 0x1f
	// Bit mask of STAL7 field.
	DMAC_CHSR_STAL7_Msk = 0x80000000
	// Bit STAL7.
	DMAC_CHSR_STAL7 = 0x80000000

	// SADDR0: DMAC Channel Source Address Register (ch_num = 0)
	// Position of SADDR field.
	DMAC_SADDR0_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR0_SADDR_Msk = 0xffffffff

	// DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
	// Position of DADDR field.
	DMAC_DADDR0_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR0_DADDR_Msk = 0xffffffff

	// DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
	// Position of DSCR_IF field.
	DMAC_DSCR0_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR0_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR0_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR0_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR0_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR0_DSCR_Msk = 0xfffffffc

	// CTRLA0: DMAC Channel Control A Register (ch_num = 0)
	// Position of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA0_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA0_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA0_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA0_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA0_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA0_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA0_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA0_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA0_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA0_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA0_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA0_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA0_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA0_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA0_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA0_DONE = 0x80000000

	// CTRLB0: DMAC Channel Control B Register (ch_num = 0)
	// Position of SIF field.
	DMAC_CTRLB0_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB0_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB0_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB0_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB0_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB0_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB0_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB0_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB0_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB0_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB0_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB0_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB0_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB0_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB0_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB0_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB0_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB0_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB0_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB0_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB0_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB0_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB0_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB0_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB0_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB0_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB0_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB0_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB0_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB0_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB0_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB0_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB0_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB0_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB0_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB0_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB0_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB0_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB0_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB0_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB0_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB0_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB0_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB0_AUTO_ENABLE = 0x1

	// CFG0: DMAC Channel Configuration Register (ch_num = 0)
	// Position of SRC_PER field.
	DMAC_CFG0_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG0_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG0_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG0_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG0_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG0_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG0_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG0_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG0_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG0_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG0_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG0_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG0_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG0_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG0_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG0_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG0_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG0_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG0_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG0_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG0_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG0_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG0_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG0_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG0_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG0_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG0_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG0_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG0_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG0_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG0_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG0_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG0_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG0_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG0_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG0_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG0_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG0_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG0_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG0_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG0_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG0_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG0_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG0_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG0_FIFOCFG_ASAP_CFG = 0x2

	// SPIP0: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 0)
	// Position of SPIP_HOLE field.
	DMAC_SPIP0_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP0_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP0_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP0_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP0: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 0)
	// Position of DPIP_HOLE field.
	DMAC_DPIP0_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP0_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP0_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP0_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR1: DMAC Channel Source Address Register (ch_num = 1)
	// Position of SADDR field.
	DMAC_SADDR1_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR1_SADDR_Msk = 0xffffffff

	// DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
	// Position of DADDR field.
	DMAC_DADDR1_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR1_DADDR_Msk = 0xffffffff

	// DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
	// Position of DSCR_IF field.
	DMAC_DSCR1_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR1_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR1_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR1_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR1_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR1_DSCR_Msk = 0xfffffffc

	// CTRLA1: DMAC Channel Control A Register (ch_num = 1)
	// Position of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA1_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA1_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA1_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA1_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA1_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA1_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA1_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA1_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA1_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA1_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA1_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA1_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA1_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA1_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA1_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA1_DONE = 0x80000000

	// CTRLB1: DMAC Channel Control B Register (ch_num = 1)
	// Position of SIF field.
	DMAC_CTRLB1_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB1_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB1_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB1_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB1_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB1_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB1_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB1_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB1_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB1_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB1_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB1_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB1_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB1_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB1_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB1_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB1_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB1_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB1_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB1_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB1_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB1_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB1_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB1_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB1_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB1_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB1_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB1_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB1_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB1_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB1_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB1_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB1_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB1_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB1_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB1_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB1_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB1_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB1_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB1_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB1_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB1_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB1_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB1_AUTO_ENABLE = 0x1

	// CFG1: DMAC Channel Configuration Register (ch_num = 1)
	// Position of SRC_PER field.
	DMAC_CFG1_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG1_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG1_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG1_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG1_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG1_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG1_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG1_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG1_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG1_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG1_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG1_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG1_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG1_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG1_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG1_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG1_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG1_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG1_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG1_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG1_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG1_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG1_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG1_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG1_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG1_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG1_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG1_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG1_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG1_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG1_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG1_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG1_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG1_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG1_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG1_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG1_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG1_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG1_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG1_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG1_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG1_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG1_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG1_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG1_FIFOCFG_ASAP_CFG = 0x2

	// SPIP1: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 1)
	// Position of SPIP_HOLE field.
	DMAC_SPIP1_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP1_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP1_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP1_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP1: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 1)
	// Position of DPIP_HOLE field.
	DMAC_DPIP1_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP1_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP1_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP1_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR2: DMAC Channel Source Address Register (ch_num = 2)
	// Position of SADDR field.
	DMAC_SADDR2_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR2_SADDR_Msk = 0xffffffff

	// DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
	// Position of DADDR field.
	DMAC_DADDR2_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR2_DADDR_Msk = 0xffffffff

	// DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
	// Position of DSCR_IF field.
	DMAC_DSCR2_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR2_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR2_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR2_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR2_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR2_DSCR_Msk = 0xfffffffc

	// CTRLA2: DMAC Channel Control A Register (ch_num = 2)
	// Position of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA2_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA2_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA2_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA2_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA2_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA2_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA2_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA2_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA2_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA2_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA2_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA2_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA2_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA2_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA2_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA2_DONE = 0x80000000

	// CTRLB2: DMAC Channel Control B Register (ch_num = 2)
	// Position of SIF field.
	DMAC_CTRLB2_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB2_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB2_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB2_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB2_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB2_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB2_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB2_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB2_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB2_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB2_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB2_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB2_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB2_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB2_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB2_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB2_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB2_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB2_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB2_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB2_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB2_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB2_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB2_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB2_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB2_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB2_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB2_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB2_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB2_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB2_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB2_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB2_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB2_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB2_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB2_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB2_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB2_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB2_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB2_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB2_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB2_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB2_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB2_AUTO_ENABLE = 0x1

	// CFG2: DMAC Channel Configuration Register (ch_num = 2)
	// Position of SRC_PER field.
	DMAC_CFG2_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG2_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG2_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG2_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG2_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG2_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG2_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG2_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG2_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG2_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG2_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG2_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG2_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG2_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG2_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG2_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG2_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG2_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG2_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG2_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG2_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG2_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG2_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG2_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG2_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG2_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG2_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG2_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG2_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG2_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG2_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG2_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG2_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG2_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG2_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG2_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG2_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG2_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG2_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG2_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG2_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG2_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG2_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG2_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG2_FIFOCFG_ASAP_CFG = 0x2

	// SPIP2: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 2)
	// Position of SPIP_HOLE field.
	DMAC_SPIP2_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP2_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP2_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP2_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP2: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 2)
	// Position of DPIP_HOLE field.
	DMAC_DPIP2_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP2_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP2_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP2_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR3: DMAC Channel Source Address Register (ch_num = 3)
	// Position of SADDR field.
	DMAC_SADDR3_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR3_SADDR_Msk = 0xffffffff

	// DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
	// Position of DADDR field.
	DMAC_DADDR3_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR3_DADDR_Msk = 0xffffffff

	// DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
	// Position of DSCR_IF field.
	DMAC_DSCR3_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR3_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR3_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR3_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR3_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR3_DSCR_Msk = 0xfffffffc

	// CTRLA3: DMAC Channel Control A Register (ch_num = 3)
	// Position of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA3_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA3_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA3_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA3_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA3_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA3_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA3_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA3_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA3_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA3_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA3_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA3_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA3_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA3_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA3_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA3_DONE = 0x80000000

	// CTRLB3: DMAC Channel Control B Register (ch_num = 3)
	// Position of SIF field.
	DMAC_CTRLB3_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB3_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB3_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB3_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB3_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB3_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB3_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB3_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB3_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB3_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB3_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB3_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB3_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB3_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB3_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB3_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB3_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB3_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB3_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB3_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB3_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB3_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB3_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB3_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB3_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB3_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB3_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB3_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB3_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB3_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB3_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB3_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB3_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB3_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB3_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB3_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB3_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB3_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB3_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB3_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB3_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB3_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB3_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB3_AUTO_ENABLE = 0x1

	// CFG3: DMAC Channel Configuration Register (ch_num = 3)
	// Position of SRC_PER field.
	DMAC_CFG3_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG3_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG3_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG3_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG3_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG3_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG3_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG3_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG3_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG3_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG3_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG3_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG3_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG3_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG3_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG3_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG3_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG3_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG3_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG3_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG3_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG3_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG3_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG3_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG3_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG3_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG3_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG3_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG3_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG3_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG3_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG3_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG3_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG3_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG3_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG3_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG3_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG3_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG3_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG3_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG3_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG3_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG3_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG3_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG3_FIFOCFG_ASAP_CFG = 0x2

	// SPIP3: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 3)
	// Position of SPIP_HOLE field.
	DMAC_SPIP3_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP3_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP3_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP3_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP3: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 3)
	// Position of DPIP_HOLE field.
	DMAC_DPIP3_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP3_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP3_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP3_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR4: DMAC Channel Source Address Register (ch_num = 4)
	// Position of SADDR field.
	DMAC_SADDR4_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR4_SADDR_Msk = 0xffffffff

	// DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
	// Position of DADDR field.
	DMAC_DADDR4_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR4_DADDR_Msk = 0xffffffff

	// DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
	// Position of DSCR_IF field.
	DMAC_DSCR4_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR4_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR4_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR4_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR4_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR4_DSCR_Msk = 0xfffffffc

	// CTRLA4: DMAC Channel Control A Register (ch_num = 4)
	// Position of BTSIZE field.
	DMAC_CTRLA4_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA4_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA4_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA4_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA4_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA4_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA4_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA4_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA4_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA4_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA4_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA4_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA4_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA4_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA4_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA4_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA4_DONE = 0x80000000

	// CTRLB4: DMAC Channel Control B Register (ch_num = 4)
	// Position of SIF field.
	DMAC_CTRLB4_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB4_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB4_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB4_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB4_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB4_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB4_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB4_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB4_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB4_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB4_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB4_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB4_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB4_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB4_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB4_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB4_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB4_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB4_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB4_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB4_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB4_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB4_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB4_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB4_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB4_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB4_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB4_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB4_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB4_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB4_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB4_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB4_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB4_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB4_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB4_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB4_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB4_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB4_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB4_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB4_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB4_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB4_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB4_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB4_AUTO_ENABLE = 0x1

	// CFG4: DMAC Channel Configuration Register (ch_num = 4)
	// Position of SRC_PER field.
	DMAC_CFG4_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG4_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG4_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG4_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG4_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG4_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG4_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG4_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG4_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG4_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG4_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG4_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG4_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG4_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG4_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG4_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG4_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG4_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG4_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG4_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG4_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG4_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG4_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG4_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG4_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG4_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG4_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG4_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG4_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG4_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG4_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG4_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG4_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG4_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG4_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG4_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG4_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG4_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG4_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG4_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG4_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG4_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG4_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG4_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG4_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG4_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG4_FIFOCFG_ASAP_CFG = 0x2

	// SPIP4: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 4)
	// Position of SPIP_HOLE field.
	DMAC_SPIP4_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP4_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP4_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP4_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP4: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 4)
	// Position of DPIP_HOLE field.
	DMAC_DPIP4_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP4_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP4_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP4_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR5: DMAC Channel Source Address Register (ch_num = 5)
	// Position of SADDR field.
	DMAC_SADDR5_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR5_SADDR_Msk = 0xffffffff

	// DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
	// Position of DADDR field.
	DMAC_DADDR5_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR5_DADDR_Msk = 0xffffffff

	// DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
	// Position of DSCR_IF field.
	DMAC_DSCR5_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR5_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR5_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR5_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR5_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR5_DSCR_Msk = 0xfffffffc

	// CTRLA5: DMAC Channel Control A Register (ch_num = 5)
	// Position of BTSIZE field.
	DMAC_CTRLA5_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA5_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA5_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA5_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA5_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA5_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA5_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA5_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA5_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA5_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA5_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA5_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA5_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA5_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA5_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA5_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA5_DONE = 0x80000000

	// CTRLB5: DMAC Channel Control B Register (ch_num = 5)
	// Position of SIF field.
	DMAC_CTRLB5_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB5_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB5_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB5_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB5_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB5_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB5_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB5_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB5_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB5_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB5_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB5_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB5_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB5_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB5_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB5_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB5_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB5_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB5_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB5_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB5_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB5_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB5_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB5_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB5_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB5_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB5_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB5_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB5_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB5_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB5_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB5_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB5_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB5_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB5_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB5_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB5_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB5_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB5_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB5_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB5_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB5_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB5_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB5_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB5_AUTO_ENABLE = 0x1

	// CFG5: DMAC Channel Configuration Register (ch_num = 5)
	// Position of SRC_PER field.
	DMAC_CFG5_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG5_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG5_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG5_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG5_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG5_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG5_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG5_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG5_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG5_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG5_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG5_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG5_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG5_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG5_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG5_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG5_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG5_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG5_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG5_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG5_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG5_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG5_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG5_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG5_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG5_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG5_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG5_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG5_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG5_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG5_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG5_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG5_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG5_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG5_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG5_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG5_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG5_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG5_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG5_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG5_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG5_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG5_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG5_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG5_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG5_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG5_FIFOCFG_ASAP_CFG = 0x2

	// SPIP5: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 5)
	// Position of SPIP_HOLE field.
	DMAC_SPIP5_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP5_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP5_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP5_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP5: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 5)
	// Position of DPIP_HOLE field.
	DMAC_DPIP5_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP5_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP5_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP5_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR6: DMAC Channel Source Address Register (ch_num = 6)
	// Position of SADDR field.
	DMAC_SADDR6_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR6_SADDR_Msk = 0xffffffff

	// DADDR6: DMAC Channel Destination Address Register (ch_num = 6)
	// Position of DADDR field.
	DMAC_DADDR6_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR6_DADDR_Msk = 0xffffffff

	// DSCR6: DMAC Channel Descriptor Address Register (ch_num = 6)
	// Position of DSCR_IF field.
	DMAC_DSCR6_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR6_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR6_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR6_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR6_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR6_DSCR_Msk = 0xfffffffc

	// CTRLA6: DMAC Channel Control A Register (ch_num = 6)
	// Position of BTSIZE field.
	DMAC_CTRLA6_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA6_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA6_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA6_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA6_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA6_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA6_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA6_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA6_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA6_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA6_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA6_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA6_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA6_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA6_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA6_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA6_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA6_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA6_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA6_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA6_DONE = 0x80000000

	// CTRLB6: DMAC Channel Control B Register (ch_num = 6)
	// Position of SIF field.
	DMAC_CTRLB6_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB6_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB6_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB6_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB6_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB6_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB6_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB6_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB6_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB6_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB6_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB6_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB6_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB6_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB6_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB6_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB6_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB6_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB6_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB6_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB6_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB6_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB6_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB6_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB6_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB6_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB6_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB6_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB6_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB6_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB6_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB6_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB6_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB6_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB6_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB6_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB6_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB6_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB6_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB6_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB6_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB6_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB6_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB6_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB6_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB6_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB6_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB6_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB6_AUTO_ENABLE = 0x1

	// CFG6: DMAC Channel Configuration Register (ch_num = 6)
	// Position of SRC_PER field.
	DMAC_CFG6_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG6_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG6_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG6_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG6_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG6_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG6_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG6_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG6_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG6_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG6_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG6_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG6_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG6_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG6_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG6_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG6_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG6_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG6_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG6_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG6_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG6_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG6_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG6_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG6_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG6_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG6_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG6_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG6_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG6_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG6_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG6_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG6_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG6_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG6_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG6_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG6_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG6_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG6_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG6_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG6_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG6_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG6_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG6_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG6_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG6_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG6_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG6_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG6_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG6_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG6_FIFOCFG_ASAP_CFG = 0x2

	// SPIP6: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 6)
	// Position of SPIP_HOLE field.
	DMAC_SPIP6_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP6_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP6_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP6_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP6: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 6)
	// Position of DPIP_HOLE field.
	DMAC_DPIP6_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP6_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP6_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP6_DPIP_BOUNDARY_Msk = 0x3ff0000

	// SADDR7: DMAC Channel Source Address Register (ch_num = 7)
	// Position of SADDR field.
	DMAC_SADDR7_SADDR_Pos = 0x0
	// Bit mask of SADDR field.
	DMAC_SADDR7_SADDR_Msk = 0xffffffff

	// DADDR7: DMAC Channel Destination Address Register (ch_num = 7)
	// Position of DADDR field.
	DMAC_DADDR7_DADDR_Pos = 0x0
	// Bit mask of DADDR field.
	DMAC_DADDR7_DADDR_Msk = 0xffffffff

	// DSCR7: DMAC Channel Descriptor Address Register (ch_num = 7)
	// Position of DSCR_IF field.
	DMAC_DSCR7_DSCR_IF_Pos = 0x0
	// Bit mask of DSCR_IF field.
	DMAC_DSCR7_DSCR_IF_Msk = 0x3
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 0
	DMAC_DSCR7_DSCR_IF_AHB_IF0 = 0x0
	// The buffer transfer descriptor is fetched via AHB-Lite Interface 1
	DMAC_DSCR7_DSCR_IF_AHB_IF1 = 0x1
	// Position of DSCR field.
	DMAC_DSCR7_DSCR_Pos = 0x2
	// Bit mask of DSCR field.
	DMAC_DSCR7_DSCR_Msk = 0xfffffffc

	// CTRLA7: DMAC Channel Control A Register (ch_num = 7)
	// Position of BTSIZE field.
	DMAC_CTRLA7_BTSIZE_Pos = 0x0
	// Bit mask of BTSIZE field.
	DMAC_CTRLA7_BTSIZE_Msk = 0xffff
	// Position of SCSIZE field.
	DMAC_CTRLA7_SCSIZE_Pos = 0x10
	// Bit mask of SCSIZE field.
	DMAC_CTRLA7_SCSIZE_Msk = 0x70000
	// 1 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA7_SCSIZE_CHK_256 = 0x7
	// Position of DCSIZE field.
	DMAC_CTRLA7_DCSIZE_Pos = 0x14
	// Bit mask of DCSIZE field.
	DMAC_CTRLA7_DCSIZE_Msk = 0x700000
	// 1 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_1 = 0x0
	// 4 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_4 = 0x1
	// 8 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_8 = 0x2
	// 16 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_16 = 0x3
	// 32 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_32 = 0x4
	// 64 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_64 = 0x5
	// 128 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_128 = 0x6
	// 256 data transferred
	DMAC_CTRLA7_DCSIZE_CHK_256 = 0x7
	// Position of SRC_WIDTH field.
	DMAC_CTRLA7_SRC_WIDTH_Pos = 0x18
	// Bit mask of SRC_WIDTH field.
	DMAC_CTRLA7_SRC_WIDTH_Msk = 0x3000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA7_SRC_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA7_SRC_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA7_SRC_WIDTH_WORD = 0x2
	// Position of DST_WIDTH field.
	DMAC_CTRLA7_DST_WIDTH_Pos = 0x1c
	// Bit mask of DST_WIDTH field.
	DMAC_CTRLA7_DST_WIDTH_Msk = 0x30000000
	// the transfer size is set to 8-bit width
	DMAC_CTRLA7_DST_WIDTH_BYTE = 0x0
	// the transfer size is set to 16-bit width
	DMAC_CTRLA7_DST_WIDTH_HALF_WORD = 0x1
	// the transfer size is set to 32-bit width
	DMAC_CTRLA7_DST_WIDTH_WORD = 0x2
	// Position of DONE field.
	DMAC_CTRLA7_DONE_Pos = 0x1f
	// Bit mask of DONE field.
	DMAC_CTRLA7_DONE_Msk = 0x80000000
	// Bit DONE.
	DMAC_CTRLA7_DONE = 0x80000000

	// CTRLB7: DMAC Channel Control B Register (ch_num = 7)
	// Position of SIF field.
	DMAC_CTRLB7_SIF_Pos = 0x0
	// Bit mask of SIF field.
	DMAC_CTRLB7_SIF_Msk = 0x3
	// The source transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB7_SIF_AHB_IF0 = 0x0
	// The source transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB7_SIF_AHB_IF1 = 0x1
	// Position of DIF field.
	DMAC_CTRLB7_DIF_Pos = 0x4
	// Bit mask of DIF field.
	DMAC_CTRLB7_DIF_Msk = 0x30
	// The destination transfer is done via AHB-Lite Interface 0
	DMAC_CTRLB7_DIF_AHB_IF0 = 0x0
	// The destination transfer is done via AHB-Lite Interface 1
	DMAC_CTRLB7_DIF_AHB_IF1 = 0x1
	// Position of SRC_PIP field.
	DMAC_CTRLB7_SRC_PIP_Pos = 0x8
	// Bit mask of SRC_PIP field.
	DMAC_CTRLB7_SRC_PIP_Msk = 0x100
	// Bit SRC_PIP.
	DMAC_CTRLB7_SRC_PIP = 0x100
	// Picture-in-Picture mode is disabled. The source data area is contiguous.
	DMAC_CTRLB7_SRC_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the source PIP counter reaches the programmable boundary, the address is automatically incremented by a user defined amount.
	DMAC_CTRLB7_SRC_PIP_ENABLE = 0x1
	// Position of DST_PIP field.
	DMAC_CTRLB7_DST_PIP_Pos = 0xc
	// Bit mask of DST_PIP field.
	DMAC_CTRLB7_DST_PIP_Msk = 0x1000
	// Bit DST_PIP.
	DMAC_CTRLB7_DST_PIP = 0x1000
	// Picture-in-Picture mode is disabled. The Destination data area is contiguous.
	DMAC_CTRLB7_DST_PIP_DISABLE = 0x0
	// Picture-in-Picture mode is enabled. When the Destination PIP counter reaches the programmable boundary the address is automatically incremented by a user-defined amount.
	DMAC_CTRLB7_DST_PIP_ENABLE = 0x1
	// Position of SRC_DSCR field.
	DMAC_CTRLB7_SRC_DSCR_Pos = 0x10
	// Bit mask of SRC_DSCR field.
	DMAC_CTRLB7_SRC_DSCR_Msk = 0x10000
	// Bit SRC_DSCR.
	DMAC_CTRLB7_SRC_DSCR = 0x10000
	// Source address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB7_SRC_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the source.
	DMAC_CTRLB7_SRC_DSCR_FETCH_DISABLE = 0x1
	// Position of DST_DSCR field.
	DMAC_CTRLB7_DST_DSCR_Pos = 0x14
	// Bit mask of DST_DSCR field.
	DMAC_CTRLB7_DST_DSCR_Msk = 0x100000
	// Bit DST_DSCR.
	DMAC_CTRLB7_DST_DSCR = 0x100000
	// Destination address is updated when the descriptor is fetched from the memory.
	DMAC_CTRLB7_DST_DSCR_FETCH_FROM_MEM = 0x0
	// Buffer Descriptor Fetch operation is disabled for the destination.
	DMAC_CTRLB7_DST_DSCR_FETCH_DISABLE = 0x1
	// Position of FC field.
	DMAC_CTRLB7_FC_Pos = 0x15
	// Bit mask of FC field.
	DMAC_CTRLB7_FC_Msk = 0xe00000
	// Memory-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_MEM2MEM_DMA_FC = 0x0
	// Memory-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_MEM2PER_DMA_FC = 0x1
	// Peripheral-to-Memory Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2MEM_DMA_FC = 0x2
	// Peripheral-to-Peripheral Transfer DMAC is flow controller
	DMAC_CTRLB7_FC_PER2PER_DMA_FC = 0x3
	// Position of SRC_INCR field.
	DMAC_CTRLB7_SRC_INCR_Pos = 0x18
	// Bit mask of SRC_INCR field.
	DMAC_CTRLB7_SRC_INCR_Msk = 0x3000000
	// The source address is incremented
	DMAC_CTRLB7_SRC_INCR_INCREMENTING = 0x0
	// The source address is decremented
	DMAC_CTRLB7_SRC_INCR_DECREMENTING = 0x1
	// The source address remains unchanged
	DMAC_CTRLB7_SRC_INCR_FIXED = 0x2
	// Position of DST_INCR field.
	DMAC_CTRLB7_DST_INCR_Pos = 0x1c
	// Bit mask of DST_INCR field.
	DMAC_CTRLB7_DST_INCR_Msk = 0x30000000
	// The destination address is incremented
	DMAC_CTRLB7_DST_INCR_INCREMENTING = 0x0
	// The destination address is decremented
	DMAC_CTRLB7_DST_INCR_DECREMENTING = 0x1
	// The destination address remains unchanged
	DMAC_CTRLB7_DST_INCR_FIXED = 0x2
	// Position of IEN field.
	DMAC_CTRLB7_IEN_Pos = 0x1e
	// Bit mask of IEN field.
	DMAC_CTRLB7_IEN_Msk = 0x40000000
	// Bit IEN.
	DMAC_CTRLB7_IEN = 0x40000000
	// Position of AUTO field.
	DMAC_CTRLB7_AUTO_Pos = 0x1f
	// Bit mask of AUTO field.
	DMAC_CTRLB7_AUTO_Msk = 0x80000000
	// Bit AUTO.
	DMAC_CTRLB7_AUTO = 0x80000000
	// Automatic multiple buffer transfer is disabled.
	DMAC_CTRLB7_AUTO_DISABLE = 0x0
	// Automatic multiple buffer transfer is enabled. This bit enables replay mode or contiguous mode when several buffers are transferred.
	DMAC_CTRLB7_AUTO_ENABLE = 0x1

	// CFG7: DMAC Channel Configuration Register (ch_num = 7)
	// Position of SRC_PER field.
	DMAC_CFG7_SRC_PER_Pos = 0x0
	// Bit mask of SRC_PER field.
	DMAC_CFG7_SRC_PER_Msk = 0xf
	// Position of DST_PER field.
	DMAC_CFG7_DST_PER_Pos = 0x4
	// Bit mask of DST_PER field.
	DMAC_CFG7_DST_PER_Msk = 0xf0
	// Position of SRC_REP field.
	DMAC_CFG7_SRC_REP_Pos = 0x8
	// Bit mask of SRC_REP field.
	DMAC_CFG7_SRC_REP_Msk = 0x100
	// Bit SRC_REP.
	DMAC_CFG7_SRC_REP = 0x100
	// When automatic mode is activated, source address is contiguous between two buffers.
	DMAC_CFG7_SRC_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the source address and the control register are reloaded from previous transfer.
	DMAC_CFG7_SRC_REP_RELOAD_ADDR = 0x1
	// Position of SRC_H2SEL field.
	DMAC_CFG7_SRC_H2SEL_Pos = 0x9
	// Bit mask of SRC_H2SEL field.
	DMAC_CFG7_SRC_H2SEL_Msk = 0x200
	// Bit SRC_H2SEL.
	DMAC_CFG7_SRC_H2SEL = 0x200
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_SRC_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_SRC_H2SEL_HW = 0x1
	// Position of SRC_PER_MSB field.
	DMAC_CFG7_SRC_PER_MSB_Pos = 0xa
	// Bit mask of SRC_PER_MSB field.
	DMAC_CFG7_SRC_PER_MSB_Msk = 0xc00
	// Position of DST_REP field.
	DMAC_CFG7_DST_REP_Pos = 0xc
	// Bit mask of DST_REP field.
	DMAC_CFG7_DST_REP_Msk = 0x1000
	// Bit DST_REP.
	DMAC_CFG7_DST_REP = 0x1000
	// When automatic mode is activated, destination address is contiguous between two buffers.
	DMAC_CFG7_DST_REP_CONTIGUOUS_ADDR = 0x0
	// When automatic mode is activated, the destination and the control register are reloaded from the pre-vious transfer.
	DMAC_CFG7_DST_REP_RELOAD_ADDR = 0x1
	// Position of DST_H2SEL field.
	DMAC_CFG7_DST_H2SEL_Pos = 0xd
	// Bit mask of DST_H2SEL field.
	DMAC_CFG7_DST_H2SEL_Msk = 0x2000
	// Bit DST_H2SEL.
	DMAC_CFG7_DST_H2SEL = 0x2000
	// Software handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_DST_H2SEL_SW = 0x0
	// Hardware handshaking interface is used to trigger a transfer request.
	DMAC_CFG7_DST_H2SEL_HW = 0x1
	// Position of DST_PER_MSB field.
	DMAC_CFG7_DST_PER_MSB_Pos = 0xe
	// Bit mask of DST_PER_MSB field.
	DMAC_CFG7_DST_PER_MSB_Msk = 0xc000
	// Position of SOD field.
	DMAC_CFG7_SOD_Pos = 0x10
	// Bit mask of SOD field.
	DMAC_CFG7_SOD_Msk = 0x10000
	// Bit SOD.
	DMAC_CFG7_SOD = 0x10000
	// STOP ON DONE disabled, the descriptor fetch operation ignores DONE Field of CTRLA register.
	DMAC_CFG7_SOD_DISABLE = 0x0
	// STOP ON DONE activated, the DMAC module is automatically disabled if DONE FIELD is set to 1.
	DMAC_CFG7_SOD_ENABLE = 0x1
	// Position of LOCK_IF field.
	DMAC_CFG7_LOCK_IF_Pos = 0x14
	// Bit mask of LOCK_IF field.
	DMAC_CFG7_LOCK_IF_Msk = 0x100000
	// Bit LOCK_IF.
	DMAC_CFG7_LOCK_IF = 0x100000
	// Interface Lock capability is disabled
	DMAC_CFG7_LOCK_IF_DISABLE = 0x0
	// Interface Lock capability is enabled
	DMAC_CFG7_LOCK_IF_ENABLE = 0x1
	// Position of LOCK_B field.
	DMAC_CFG7_LOCK_B_Pos = 0x15
	// Bit mask of LOCK_B field.
	DMAC_CFG7_LOCK_B_Msk = 0x200000
	// Bit LOCK_B.
	DMAC_CFG7_LOCK_B = 0x200000
	// AHB Bus Locking capability is disabled.
	DMAC_CFG7_LOCK_B_DISABLE = 0x0
	// Position of LOCK_IF_L field.
	DMAC_CFG7_LOCK_IF_L_Pos = 0x16
	// Bit mask of LOCK_IF_L field.
	DMAC_CFG7_LOCK_IF_L_Msk = 0x400000
	// Bit LOCK_IF_L.
	DMAC_CFG7_LOCK_IF_L = 0x400000
	// The Master Interface Arbiter is locked by the channel x for a chunk transfer.
	DMAC_CFG7_LOCK_IF_L_CHUNK = 0x0
	// The Master Interface Arbiter is locked by the channel x for a buffer transfer.
	DMAC_CFG7_LOCK_IF_L_BUFFER = 0x1
	// Position of AHB_PROT field.
	DMAC_CFG7_AHB_PROT_Pos = 0x18
	// Bit mask of AHB_PROT field.
	DMAC_CFG7_AHB_PROT_Msk = 0x7000000
	// Position of FIFOCFG field.
	DMAC_CFG7_FIFOCFG_Pos = 0x1c
	// Bit mask of FIFOCFG field.
	DMAC_CFG7_FIFOCFG_Msk = 0x30000000
	// The largest defined length AHB burst is performed on the destination AHB interface.
	DMAC_CFG7_FIFOCFG_ALAP_CFG = 0x0
	// When half FIFO size is available/filled, a source/destination request is serviced.
	DMAC_CFG7_FIFOCFG_HALF_CFG = 0x1
	// When there is enough space/data available to perform a single AHB access, then the request is serviced.
	DMAC_CFG7_FIFOCFG_ASAP_CFG = 0x2

	// SPIP7: DMAC Channel Source Picture-in-Picture Configuration Register (ch_num = 7)
	// Position of SPIP_HOLE field.
	DMAC_SPIP7_SPIP_HOLE_Pos = 0x0
	// Bit mask of SPIP_HOLE field.
	DMAC_SPIP7_SPIP_HOLE_Msk = 0xffff
	// Position of SPIP_BOUNDARY field.
	DMAC_SPIP7_SPIP_BOUNDARY_Pos = 0x10
	// Bit mask of SPIP_BOUNDARY field.
	DMAC_SPIP7_SPIP_BOUNDARY_Msk = 0x3ff0000

	// DPIP7: DMAC Channel Destination Picture-in-Picture Configuration Register (ch_num = 7)
	// Position of DPIP_HOLE field.
	DMAC_DPIP7_DPIP_HOLE_Pos = 0x0
	// Bit mask of DPIP_HOLE field.
	DMAC_DPIP7_DPIP_HOLE_Msk = 0xffff
	// Position of DPIP_BOUNDARY field.
	DMAC_DPIP7_DPIP_BOUNDARY_Pos = 0x10
	// Bit mask of DPIP_BOUNDARY field.
	DMAC_DPIP7_DPIP_BOUNDARY_Msk = 0x3ff0000

	// WPMR: DMAC Write Protect Mode Register
	// Position of WPEN field.
	DMAC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	DMAC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	DMAC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	DMAC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	DMAC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: DMAC Write Protect Status Register
	// Position of WPVS field.
	DMAC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	DMAC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	DMAC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	DMAC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	DMAC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for AIC: Advanced Interrupt Controller
const (
	// SMR: Source Mode Register
	// Position of PRIOR field.
	AIC_SMR_PRIOR_Pos = 0x0
	// Bit mask of PRIOR field.
	AIC_SMR_PRIOR_Msk = 0x7
	// Position of SRCTYPE field.
	AIC_SMR_SRCTYPE_Pos = 0x5
	// Bit mask of SRCTYPE field.
	AIC_SMR_SRCTYPE_Msk = 0x60
	// High level Sensitive for internal sourceLow level Sensitive for external source
	AIC_SMR_SRCTYPE_INT_LEVEL_SENSITIVE = 0x0
	// Positive edge triggered for internal sourceNegative edge triggered for external source
	AIC_SMR_SRCTYPE_INT_EDGE_TRIGGERED = 0x1
	// High level Sensitive for internal sourceHigh level Sensitive for external source
	AIC_SMR_SRCTYPE_EXT_HIGH_LEVEL = 0x2
	// Positive edge triggered for internal sourcePositive edge triggered for external source
	AIC_SMR_SRCTYPE_EXT_POSITIVE_EDGE = 0x3

	// SVR: Source Vector Register
	// Position of VECTOR field.
	AIC_SVR_VECTOR_Pos = 0x0
	// Bit mask of VECTOR field.
	AIC_SVR_VECTOR_Msk = 0xffffffff

	// IVR: Interrupt Vector Register
	// Position of IRQV field.
	AIC_IVR_IRQV_Pos = 0x0
	// Bit mask of IRQV field.
	AIC_IVR_IRQV_Msk = 0xffffffff

	// FVR: FIQ Interrupt Vector Register
	// Position of FIQV field.
	AIC_FVR_FIQV_Pos = 0x0
	// Bit mask of FIQV field.
	AIC_FVR_FIQV_Msk = 0xffffffff

	// ISR: Interrupt Status Register
	// Position of IRQID field.
	AIC_ISR_IRQID_Pos = 0x0
	// Bit mask of IRQID field.
	AIC_ISR_IRQID_Msk = 0x1f

	// IPR: Interrupt Pending Register
	// Position of FIQ field.
	AIC_IPR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IPR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IPR_FIQ = 0x1
	// Position of SYS field.
	AIC_IPR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IPR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IPR_SYS = 0x2
	// Position of PID2 field.
	AIC_IPR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IPR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IPR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IPR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IPR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IPR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IPR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IPR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IPR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IPR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IPR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IPR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IPR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IPR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IPR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IPR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IPR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IPR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IPR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IPR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IPR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IPR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IPR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IPR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IPR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IPR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IPR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IPR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IPR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IPR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IPR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IPR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IPR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IPR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IPR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IPR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IPR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IPR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IPR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IPR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IPR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IPR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IPR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IPR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IPR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IPR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IPR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IPR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IPR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IPR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IPR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IPR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IPR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IPR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IPR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IPR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IPR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IPR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IPR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IPR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IPR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IPR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IPR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IPR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IPR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IPR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IPR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IPR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IPR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IPR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IPR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IPR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IPR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IPR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IPR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IPR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IPR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IPR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IPR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IPR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IPR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IPR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IPR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IPR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IPR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IPR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IPR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IPR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IPR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IPR_PID31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of FIQ field.
	AIC_IMR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IMR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IMR_FIQ = 0x1
	// Position of SYS field.
	AIC_IMR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IMR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IMR_SYS = 0x2
	// Position of PID2 field.
	AIC_IMR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IMR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IMR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IMR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IMR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IMR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IMR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IMR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IMR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IMR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IMR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IMR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IMR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IMR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IMR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IMR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IMR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IMR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IMR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IMR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IMR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IMR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IMR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IMR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IMR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IMR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IMR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IMR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IMR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IMR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IMR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IMR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IMR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IMR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IMR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IMR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IMR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IMR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IMR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IMR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IMR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IMR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IMR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IMR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IMR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IMR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IMR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IMR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IMR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IMR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IMR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IMR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IMR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IMR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IMR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IMR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IMR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IMR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IMR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IMR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IMR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IMR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IMR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IMR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IMR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IMR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IMR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IMR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IMR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IMR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IMR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IMR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IMR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IMR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IMR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IMR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IMR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IMR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IMR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IMR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IMR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IMR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IMR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IMR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IMR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IMR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IMR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IMR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IMR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IMR_PID31 = 0x80000000

	// CISR: Core Interrupt Status Register
	// Position of NFIQ field.
	AIC_CISR_NFIQ_Pos = 0x0
	// Bit mask of NFIQ field.
	AIC_CISR_NFIQ_Msk = 0x1
	// Bit NFIQ.
	AIC_CISR_NFIQ = 0x1
	// Position of NIRQ field.
	AIC_CISR_NIRQ_Pos = 0x1
	// Bit mask of NIRQ field.
	AIC_CISR_NIRQ_Msk = 0x2
	// Bit NIRQ.
	AIC_CISR_NIRQ = 0x2

	// IECR: Interrupt Enable Command Register
	// Position of FIQ field.
	AIC_IECR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IECR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IECR_FIQ = 0x1
	// Position of SYS field.
	AIC_IECR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IECR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IECR_SYS = 0x2
	// Position of PID2 field.
	AIC_IECR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IECR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IECR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IECR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IECR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IECR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IECR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IECR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IECR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IECR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IECR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IECR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IECR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IECR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IECR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IECR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IECR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IECR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IECR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IECR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IECR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IECR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IECR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IECR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IECR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IECR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IECR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IECR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IECR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IECR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IECR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IECR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IECR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IECR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IECR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IECR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IECR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IECR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IECR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IECR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IECR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IECR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IECR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IECR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IECR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IECR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IECR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IECR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IECR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IECR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IECR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IECR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IECR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IECR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IECR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IECR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IECR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IECR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IECR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IECR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IECR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IECR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IECR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IECR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IECR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IECR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IECR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IECR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IECR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IECR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IECR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IECR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IECR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IECR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IECR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IECR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IECR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IECR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IECR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IECR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IECR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IECR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IECR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IECR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IECR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IECR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IECR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IECR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IECR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IECR_PID31 = 0x80000000

	// IDCR: Interrupt Disable Command Register
	// Position of FIQ field.
	AIC_IDCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_IDCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_IDCR_FIQ = 0x1
	// Position of SYS field.
	AIC_IDCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_IDCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_IDCR_SYS = 0x2
	// Position of PID2 field.
	AIC_IDCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_IDCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_IDCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_IDCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_IDCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_IDCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_IDCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_IDCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_IDCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_IDCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_IDCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_IDCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_IDCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_IDCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_IDCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_IDCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_IDCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_IDCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_IDCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_IDCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_IDCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_IDCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_IDCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_IDCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_IDCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_IDCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_IDCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_IDCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_IDCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_IDCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_IDCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_IDCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_IDCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_IDCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_IDCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_IDCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_IDCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_IDCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_IDCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_IDCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_IDCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_IDCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_IDCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_IDCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_IDCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_IDCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_IDCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_IDCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_IDCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_IDCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_IDCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_IDCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_IDCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_IDCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_IDCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_IDCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_IDCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_IDCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_IDCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_IDCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_IDCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_IDCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_IDCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_IDCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_IDCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_IDCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_IDCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_IDCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_IDCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_IDCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_IDCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_IDCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_IDCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_IDCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_IDCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_IDCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_IDCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_IDCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_IDCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_IDCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_IDCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_IDCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_IDCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_IDCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_IDCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_IDCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_IDCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_IDCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_IDCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_IDCR_PID31 = 0x80000000

	// ICCR: Interrupt Clear Command Register
	// Position of FIQ field.
	AIC_ICCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_ICCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_ICCR_FIQ = 0x1
	// Position of SYS field.
	AIC_ICCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_ICCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_ICCR_SYS = 0x2
	// Position of PID2 field.
	AIC_ICCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_ICCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_ICCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_ICCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_ICCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_ICCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_ICCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_ICCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_ICCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_ICCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_ICCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_ICCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_ICCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_ICCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_ICCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_ICCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_ICCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_ICCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_ICCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_ICCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_ICCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_ICCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_ICCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_ICCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_ICCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_ICCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_ICCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_ICCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_ICCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_ICCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_ICCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_ICCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_ICCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_ICCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_ICCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_ICCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_ICCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_ICCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_ICCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_ICCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_ICCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_ICCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_ICCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_ICCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_ICCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_ICCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_ICCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_ICCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_ICCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_ICCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_ICCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_ICCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_ICCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_ICCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_ICCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_ICCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_ICCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_ICCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_ICCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_ICCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_ICCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_ICCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_ICCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_ICCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_ICCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_ICCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_ICCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_ICCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_ICCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_ICCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_ICCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_ICCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_ICCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_ICCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_ICCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_ICCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_ICCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_ICCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_ICCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_ICCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_ICCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_ICCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_ICCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_ICCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_ICCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_ICCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_ICCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_ICCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_ICCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_ICCR_PID31 = 0x80000000

	// ISCR: Interrupt Set Command Register
	// Position of FIQ field.
	AIC_ISCR_FIQ_Pos = 0x0
	// Bit mask of FIQ field.
	AIC_ISCR_FIQ_Msk = 0x1
	// Bit FIQ.
	AIC_ISCR_FIQ = 0x1
	// Position of SYS field.
	AIC_ISCR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_ISCR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_ISCR_SYS = 0x2
	// Position of PID2 field.
	AIC_ISCR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_ISCR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_ISCR_PID2 = 0x4
	// Position of PID3 field.
	AIC_ISCR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_ISCR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_ISCR_PID3 = 0x8
	// Position of PID4 field.
	AIC_ISCR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_ISCR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_ISCR_PID4 = 0x10
	// Position of PID5 field.
	AIC_ISCR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_ISCR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_ISCR_PID5 = 0x20
	// Position of PID6 field.
	AIC_ISCR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_ISCR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_ISCR_PID6 = 0x40
	// Position of PID7 field.
	AIC_ISCR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_ISCR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_ISCR_PID7 = 0x80
	// Position of PID8 field.
	AIC_ISCR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_ISCR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_ISCR_PID8 = 0x100
	// Position of PID9 field.
	AIC_ISCR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_ISCR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_ISCR_PID9 = 0x200
	// Position of PID10 field.
	AIC_ISCR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_ISCR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_ISCR_PID10 = 0x400
	// Position of PID11 field.
	AIC_ISCR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_ISCR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_ISCR_PID11 = 0x800
	// Position of PID12 field.
	AIC_ISCR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_ISCR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_ISCR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_ISCR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_ISCR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_ISCR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_ISCR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_ISCR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_ISCR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_ISCR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_ISCR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_ISCR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_ISCR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_ISCR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_ISCR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_ISCR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_ISCR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_ISCR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_ISCR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_ISCR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_ISCR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_ISCR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_ISCR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_ISCR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_ISCR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_ISCR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_ISCR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_ISCR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_ISCR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_ISCR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_ISCR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_ISCR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_ISCR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_ISCR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_ISCR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_ISCR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_ISCR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_ISCR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_ISCR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_ISCR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_ISCR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_ISCR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_ISCR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_ISCR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_ISCR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_ISCR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_ISCR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_ISCR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_ISCR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_ISCR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_ISCR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_ISCR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_ISCR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_ISCR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_ISCR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_ISCR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_ISCR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_ISCR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_ISCR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_ISCR_PID31 = 0x80000000

	// SPU: Spurious Interrupt Vector Register
	// Position of SIVR field.
	AIC_SPU_SIVR_Pos = 0x0
	// Bit mask of SIVR field.
	AIC_SPU_SIVR_Msk = 0xffffffff

	// DCR: Debug Control Register
	// Position of PROT field.
	AIC_DCR_PROT_Pos = 0x0
	// Bit mask of PROT field.
	AIC_DCR_PROT_Msk = 0x1
	// Bit PROT.
	AIC_DCR_PROT = 0x1
	// Position of GMSK field.
	AIC_DCR_GMSK_Pos = 0x1
	// Bit mask of GMSK field.
	AIC_DCR_GMSK_Msk = 0x2
	// Bit GMSK.
	AIC_DCR_GMSK = 0x2

	// FFER: Fast Forcing Enable Register
	// Position of SYS field.
	AIC_FFER_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFER_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFER_SYS = 0x2
	// Position of PID2 field.
	AIC_FFER_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFER_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFER_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFER_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFER_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFER_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFER_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFER_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFER_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFER_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFER_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFER_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFER_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFER_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFER_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFER_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFER_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFER_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFER_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFER_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFER_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFER_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFER_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFER_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFER_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFER_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFER_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFER_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFER_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFER_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFER_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFER_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFER_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFER_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFER_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFER_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFER_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFER_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFER_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFER_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFER_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFER_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFER_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFER_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFER_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFER_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFER_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFER_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFER_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFER_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFER_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFER_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFER_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFER_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFER_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFER_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFER_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFER_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFER_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFER_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFER_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFER_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFER_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFER_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFER_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFER_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFER_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFER_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFER_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFER_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFER_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFER_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFER_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFER_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFER_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFER_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFER_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFER_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFER_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFER_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFER_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFER_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFER_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFER_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFER_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFER_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFER_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFER_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFER_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFER_PID31 = 0x80000000

	// FFDR: Fast Forcing Disable Register
	// Position of SYS field.
	AIC_FFDR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFDR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFDR_SYS = 0x2
	// Position of PID2 field.
	AIC_FFDR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFDR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFDR_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFDR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFDR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFDR_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFDR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFDR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFDR_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFDR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFDR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFDR_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFDR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFDR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFDR_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFDR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFDR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFDR_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFDR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFDR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFDR_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFDR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFDR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFDR_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFDR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFDR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFDR_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFDR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFDR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFDR_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFDR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFDR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFDR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFDR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFDR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFDR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFDR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFDR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFDR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFDR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFDR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFDR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFDR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFDR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFDR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFDR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFDR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFDR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFDR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFDR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFDR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFDR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFDR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFDR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFDR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFDR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFDR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFDR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFDR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFDR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFDR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFDR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFDR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFDR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFDR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFDR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFDR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFDR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFDR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFDR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFDR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFDR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFDR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFDR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFDR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFDR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFDR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFDR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFDR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFDR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFDR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFDR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFDR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFDR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFDR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFDR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFDR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFDR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFDR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFDR_PID31 = 0x80000000

	// FFSR: Fast Forcing Status Register
	// Position of SYS field.
	AIC_FFSR_SYS_Pos = 0x1
	// Bit mask of SYS field.
	AIC_FFSR_SYS_Msk = 0x2
	// Bit SYS.
	AIC_FFSR_SYS = 0x2
	// Position of PID2 field.
	AIC_FFSR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	AIC_FFSR_PID2_Msk = 0x4
	// Bit PID2.
	AIC_FFSR_PID2 = 0x4
	// Position of PID3 field.
	AIC_FFSR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	AIC_FFSR_PID3_Msk = 0x8
	// Bit PID3.
	AIC_FFSR_PID3 = 0x8
	// Position of PID4 field.
	AIC_FFSR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	AIC_FFSR_PID4_Msk = 0x10
	// Bit PID4.
	AIC_FFSR_PID4 = 0x10
	// Position of PID5 field.
	AIC_FFSR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	AIC_FFSR_PID5_Msk = 0x20
	// Bit PID5.
	AIC_FFSR_PID5 = 0x20
	// Position of PID6 field.
	AIC_FFSR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	AIC_FFSR_PID6_Msk = 0x40
	// Bit PID6.
	AIC_FFSR_PID6 = 0x40
	// Position of PID7 field.
	AIC_FFSR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	AIC_FFSR_PID7_Msk = 0x80
	// Bit PID7.
	AIC_FFSR_PID7 = 0x80
	// Position of PID8 field.
	AIC_FFSR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	AIC_FFSR_PID8_Msk = 0x100
	// Bit PID8.
	AIC_FFSR_PID8 = 0x100
	// Position of PID9 field.
	AIC_FFSR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	AIC_FFSR_PID9_Msk = 0x200
	// Bit PID9.
	AIC_FFSR_PID9 = 0x200
	// Position of PID10 field.
	AIC_FFSR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	AIC_FFSR_PID10_Msk = 0x400
	// Bit PID10.
	AIC_FFSR_PID10 = 0x400
	// Position of PID11 field.
	AIC_FFSR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	AIC_FFSR_PID11_Msk = 0x800
	// Bit PID11.
	AIC_FFSR_PID11 = 0x800
	// Position of PID12 field.
	AIC_FFSR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	AIC_FFSR_PID12_Msk = 0x1000
	// Bit PID12.
	AIC_FFSR_PID12 = 0x1000
	// Position of PID13 field.
	AIC_FFSR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	AIC_FFSR_PID13_Msk = 0x2000
	// Bit PID13.
	AIC_FFSR_PID13 = 0x2000
	// Position of PID14 field.
	AIC_FFSR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	AIC_FFSR_PID14_Msk = 0x4000
	// Bit PID14.
	AIC_FFSR_PID14 = 0x4000
	// Position of PID15 field.
	AIC_FFSR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	AIC_FFSR_PID15_Msk = 0x8000
	// Bit PID15.
	AIC_FFSR_PID15 = 0x8000
	// Position of PID16 field.
	AIC_FFSR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	AIC_FFSR_PID16_Msk = 0x10000
	// Bit PID16.
	AIC_FFSR_PID16 = 0x10000
	// Position of PID17 field.
	AIC_FFSR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	AIC_FFSR_PID17_Msk = 0x20000
	// Bit PID17.
	AIC_FFSR_PID17 = 0x20000
	// Position of PID18 field.
	AIC_FFSR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	AIC_FFSR_PID18_Msk = 0x40000
	// Bit PID18.
	AIC_FFSR_PID18 = 0x40000
	// Position of PID19 field.
	AIC_FFSR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	AIC_FFSR_PID19_Msk = 0x80000
	// Bit PID19.
	AIC_FFSR_PID19 = 0x80000
	// Position of PID20 field.
	AIC_FFSR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	AIC_FFSR_PID20_Msk = 0x100000
	// Bit PID20.
	AIC_FFSR_PID20 = 0x100000
	// Position of PID21 field.
	AIC_FFSR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	AIC_FFSR_PID21_Msk = 0x200000
	// Bit PID21.
	AIC_FFSR_PID21 = 0x200000
	// Position of PID22 field.
	AIC_FFSR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	AIC_FFSR_PID22_Msk = 0x400000
	// Bit PID22.
	AIC_FFSR_PID22 = 0x400000
	// Position of PID23 field.
	AIC_FFSR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	AIC_FFSR_PID23_Msk = 0x800000
	// Bit PID23.
	AIC_FFSR_PID23 = 0x800000
	// Position of PID24 field.
	AIC_FFSR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	AIC_FFSR_PID24_Msk = 0x1000000
	// Bit PID24.
	AIC_FFSR_PID24 = 0x1000000
	// Position of PID25 field.
	AIC_FFSR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	AIC_FFSR_PID25_Msk = 0x2000000
	// Bit PID25.
	AIC_FFSR_PID25 = 0x2000000
	// Position of PID26 field.
	AIC_FFSR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	AIC_FFSR_PID26_Msk = 0x4000000
	// Bit PID26.
	AIC_FFSR_PID26 = 0x4000000
	// Position of PID27 field.
	AIC_FFSR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	AIC_FFSR_PID27_Msk = 0x8000000
	// Bit PID27.
	AIC_FFSR_PID27 = 0x8000000
	// Position of PID28 field.
	AIC_FFSR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	AIC_FFSR_PID28_Msk = 0x10000000
	// Bit PID28.
	AIC_FFSR_PID28 = 0x10000000
	// Position of PID29 field.
	AIC_FFSR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	AIC_FFSR_PID29_Msk = 0x20000000
	// Bit PID29.
	AIC_FFSR_PID29 = 0x20000000
	// Position of PID30 field.
	AIC_FFSR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	AIC_FFSR_PID30_Msk = 0x40000000
	// Bit PID30.
	AIC_FFSR_PID30 = 0x40000000
	// Position of PID31 field.
	AIC_FFSR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	AIC_FFSR_PID31_Msk = 0x80000000
	// Bit PID31.
	AIC_FFSR_PID31 = 0x80000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	AIC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	AIC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	AIC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	AIC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	AIC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	AIC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	AIC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	AIC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	AIC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	AIC_WPSR_WPVSRC_Msk = 0xffff00
)

// Bitfields for DBGU: Debug Unit
const (
	// CR: Control Register
	// Position of RSTRX field.
	DBGU_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	DBGU_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	DBGU_CR_RSTRX = 0x4
	// Position of RSTTX field.
	DBGU_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	DBGU_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	DBGU_CR_RSTTX = 0x8
	// Position of RXEN field.
	DBGU_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	DBGU_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	DBGU_CR_RXEN = 0x10
	// Position of RXDIS field.
	DBGU_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	DBGU_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	DBGU_CR_RXDIS = 0x20
	// Position of TXEN field.
	DBGU_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	DBGU_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	DBGU_CR_TXEN = 0x40
	// Position of TXDIS field.
	DBGU_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	DBGU_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	DBGU_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	DBGU_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	DBGU_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	DBGU_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	DBGU_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	DBGU_MR_PAR_Msk = 0xe00
	// Even Parity
	DBGU_MR_PAR_EVEN = 0x0
	// Odd Parity
	DBGU_MR_PAR_ODD = 0x1
	// Space: Parity forced to 0
	DBGU_MR_PAR_SPACE = 0x2
	// Mark: Parity forced to 1
	DBGU_MR_PAR_MARK = 0x3
	// No Parity
	DBGU_MR_PAR_NONE = 0x4
	// Position of CHMODE field.
	DBGU_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	DBGU_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	DBGU_MR_CHMODE_NORM = 0x0
	// Automatic Echo
	DBGU_MR_CHMODE_AUTO = 0x1
	// Local Loopback
	DBGU_MR_CHMODE_LOCLOOP = 0x2
	// Remote Loopback
	DBGU_MR_CHMODE_REMLOOP = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	DBGU_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IER_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IER_TXRDY = 0x2
	// Position of OVRE field.
	DBGU_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IER_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IER_FRAME = 0x40
	// Position of PARE field.
	DBGU_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IER_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IER_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IER_TXEMPTY = 0x200
	// Position of COMMTX field.
	DBGU_IER_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IER_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IER_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IER_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IER_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IER_COMMRX = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	DBGU_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IDR_TXRDY = 0x2
	// Position of OVRE field.
	DBGU_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IDR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IDR_FRAME = 0x40
	// Position of PARE field.
	DBGU_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IDR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IDR_TXEMPTY = 0x200
	// Position of COMMTX field.
	DBGU_IDR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IDR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IDR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IDR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IDR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IDR_COMMRX = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	DBGU_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_IMR_TXRDY = 0x2
	// Position of OVRE field.
	DBGU_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_IMR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_IMR_FRAME = 0x40
	// Position of PARE field.
	DBGU_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_IMR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_IMR_TXEMPTY = 0x200
	// Position of COMMTX field.
	DBGU_IMR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_IMR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_IMR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_IMR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_IMR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_IMR_COMMRX = 0x80000000

	// SR: Status Register
	// Position of RXRDY field.
	DBGU_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	DBGU_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	DBGU_SR_RXRDY = 0x1
	// Position of TXRDY field.
	DBGU_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	DBGU_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	DBGU_SR_TXRDY = 0x2
	// Position of OVRE field.
	DBGU_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	DBGU_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	DBGU_SR_OVRE = 0x20
	// Position of FRAME field.
	DBGU_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	DBGU_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	DBGU_SR_FRAME = 0x40
	// Position of PARE field.
	DBGU_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	DBGU_SR_PARE_Msk = 0x80
	// Bit PARE.
	DBGU_SR_PARE = 0x80
	// Position of TXEMPTY field.
	DBGU_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	DBGU_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	DBGU_SR_TXEMPTY = 0x200
	// Position of COMMTX field.
	DBGU_SR_COMMTX_Pos = 0x1e
	// Bit mask of COMMTX field.
	DBGU_SR_COMMTX_Msk = 0x40000000
	// Bit COMMTX.
	DBGU_SR_COMMTX = 0x40000000
	// Position of COMMRX field.
	DBGU_SR_COMMRX_Pos = 0x1f
	// Bit mask of COMMRX field.
	DBGU_SR_COMMRX_Msk = 0x80000000
	// Bit COMMRX.
	DBGU_SR_COMMRX = 0x80000000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	DBGU_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	DBGU_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	DBGU_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	DBGU_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	DBGU_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	DBGU_BRGR_CD_Msk = 0xffff
	// DBGU Disabled
	DBGU_BRGR_CD_DISABLED = 0x0
	// MCK
	DBGU_BRGR_CD_MCK = 0x1

	// CIDR: Chip ID Register
	// Position of VERSION field.
	DBGU_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	DBGU_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	DBGU_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	DBGU_CIDR_EPROC_Msk = 0xe0
	// ARM946ES
	DBGU_CIDR_EPROC_ARM946ES = 0x1
	// ARM7TDMI
	DBGU_CIDR_EPROC_ARM7TDMI = 0x2
	// Cortex-M3
	DBGU_CIDR_EPROC_CM3 = 0x3
	// ARM920T
	DBGU_CIDR_EPROC_ARM920T = 0x4
	// ARM926EJS
	DBGU_CIDR_EPROC_ARM926EJS = 0x5
	// Cortex-A5
	DBGU_CIDR_EPROC_CA5 = 0x6
	// Position of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	DBGU_CIDR_NVPSIZ_Msk = 0xf00
	// None
	DBGU_CIDR_NVPSIZ_NONE = 0x0
	// 8K bytes
	DBGU_CIDR_NVPSIZ_8K = 0x1
	// 16K bytes
	DBGU_CIDR_NVPSIZ_16K = 0x2
	// 32K bytes
	DBGU_CIDR_NVPSIZ_32K = 0x3
	// 64K bytes
	DBGU_CIDR_NVPSIZ_64K = 0x5
	// 128K bytes
	DBGU_CIDR_NVPSIZ_128K = 0x7
	// 256K bytes
	DBGU_CIDR_NVPSIZ_256K = 0x9
	// 512K bytes
	DBGU_CIDR_NVPSIZ_512K = 0xa
	// 1024K bytes
	DBGU_CIDR_NVPSIZ_1024K = 0xc
	// 2048K bytes
	DBGU_CIDR_NVPSIZ_2048K = 0xe
	// Position of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	DBGU_CIDR_NVPSIZ2_Msk = 0xf000
	// None
	DBGU_CIDR_NVPSIZ2_NONE = 0x0
	// 8K bytes
	DBGU_CIDR_NVPSIZ2_8K = 0x1
	// 16K bytes
	DBGU_CIDR_NVPSIZ2_16K = 0x2
	// 32K bytes
	DBGU_CIDR_NVPSIZ2_32K = 0x3
	// 64K bytes
	DBGU_CIDR_NVPSIZ2_64K = 0x5
	// 128K bytes
	DBGU_CIDR_NVPSIZ2_128K = 0x7
	// 256K bytes
	DBGU_CIDR_NVPSIZ2_256K = 0x9
	// 512K bytes
	DBGU_CIDR_NVPSIZ2_512K = 0xa
	// 1024K bytes
	DBGU_CIDR_NVPSIZ2_1024K = 0xc
	// 2048K bytes
	DBGU_CIDR_NVPSIZ2_2048K = 0xe
	// Position of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	DBGU_CIDR_SRAMSIZ_Msk = 0xf0000
	// 1K bytes
	DBGU_CIDR_SRAMSIZ_1K = 0x1
	// 2K bytes
	DBGU_CIDR_SRAMSIZ_2K = 0x2
	// 6K bytes
	DBGU_CIDR_SRAMSIZ_6K = 0x3
	// 112K bytes
	DBGU_CIDR_SRAMSIZ_112K = 0x4
	// 4K bytes
	DBGU_CIDR_SRAMSIZ_4K = 0x5
	// 80K bytes
	DBGU_CIDR_SRAMSIZ_80K = 0x6
	// 160K bytes
	DBGU_CIDR_SRAMSIZ_160K = 0x7
	// 8K bytes
	DBGU_CIDR_SRAMSIZ_8K = 0x8
	// 16K bytes
	DBGU_CIDR_SRAMSIZ_16K = 0x9
	// 32K bytes
	DBGU_CIDR_SRAMSIZ_32K = 0xa
	// 64K bytes
	DBGU_CIDR_SRAMSIZ_64K = 0xb
	// 128K bytes
	DBGU_CIDR_SRAMSIZ_128K = 0xc
	// 256K bytes
	DBGU_CIDR_SRAMSIZ_256K = 0xd
	// 96K bytes
	DBGU_CIDR_SRAMSIZ_96K = 0xe
	// 512K bytes
	DBGU_CIDR_SRAMSIZ_512K = 0xf
	// Position of ARCH field.
	DBGU_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	DBGU_CIDR_ARCH_Msk = 0xff00000
	// AT91SAM9xx Series
	DBGU_CIDR_ARCH_AT91SAM9xx = 0x19
	// AT91SAM9XExx Series
	DBGU_CIDR_ARCH_AT91SAM9XExx = 0x29
	// AT91x34 Series
	DBGU_CIDR_ARCH_AT91x34 = 0x34
	// CAP7 Series
	DBGU_CIDR_ARCH_CAP7 = 0x37
	// CAP9 Series
	DBGU_CIDR_ARCH_CAP9 = 0x39
	// CAP11 Series
	DBGU_CIDR_ARCH_CAP11 = 0x3b
	// AT91x40 Series
	DBGU_CIDR_ARCH_AT91x40 = 0x40
	// AT91x42 Series
	DBGU_CIDR_ARCH_AT91x42 = 0x42
	// AT91x55 Series
	DBGU_CIDR_ARCH_AT91x55 = 0x55
	// AT91SAM7Axx Series
	DBGU_CIDR_ARCH_AT91SAM7Axx = 0x60
	// AT91SAM7AQxx Series
	DBGU_CIDR_ARCH_AT91SAM7AQxx = 0x61
	// AT91x63 Series
	DBGU_CIDR_ARCH_AT91x63 = 0x63
	// AT91SAM7Sxx Series
	DBGU_CIDR_ARCH_AT91SAM7Sxx = 0x70
	// AT91SAM7XCxx Series
	DBGU_CIDR_ARCH_AT91SAM7XCxx = 0x71
	// AT91SAM7SExx Series
	DBGU_CIDR_ARCH_AT91SAM7SExx = 0x72
	// AT91SAM7Lxx Series
	DBGU_CIDR_ARCH_AT91SAM7Lxx = 0x73
	// AT91SAM7Xxx Series
	DBGU_CIDR_ARCH_AT91SAM7Xxx = 0x75
	// AT91SAM7SLxx Series
	DBGU_CIDR_ARCH_AT91SAM7SLxx = 0x76
	// ATSAM3UxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3UxC = 0x80
	// ATSAM3UxE Series (144-pin version)
	DBGU_CIDR_ARCH_ATSAM3UxE = 0x81
	// ATSAM3AxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3AxC = 0x83
	// ATSAM3XxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxC = 0x84
	// ATSAM3XxE Series (144-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxE = 0x85
	// ATSAM3XxG Series (208/217-pin version)
	DBGU_CIDR_ARCH_ATSAM3XxG = 0x86
	// ATSAM3SxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxA = 0x88
	// ATSAM3SxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxB = 0x89
	// ATSAM3SxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3SxC = 0x8a
	// AT91x92 Series
	DBGU_CIDR_ARCH_AT91x92 = 0x92
	// ATSAM3NxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxA = 0x93
	// ATSAM3NxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxB = 0x94
	// ATSAM3NxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3NxC = 0x95
	// ATSAM3SDxA Series (48-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxA = 0x98
	// ATSAM3SDxB Series (64-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxB = 0x99
	// ATSAM3SDxC Series (100-pin version)
	DBGU_CIDR_ARCH_ATSAM3SDxC = 0x9a
	// AT75Cxx Series
	DBGU_CIDR_ARCH_AT75Cxx = 0xf0
	// Position of NVPTYP field.
	DBGU_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	DBGU_CIDR_NVPTYP_Msk = 0x70000000
	// ROM
	DBGU_CIDR_NVPTYP_ROM = 0x0
	// ROMless or on-chip Flash
	DBGU_CIDR_NVPTYP_ROMLESS = 0x1
	// Embedded Flash Memory
	DBGU_CIDR_NVPTYP_FLASH = 0x2
	// ROM and Embedded Flash MemoryNVPSIZ is ROM size NVPSIZ2 is Flash size
	DBGU_CIDR_NVPTYP_ROM_FLASH = 0x3
	// SRAM emulating ROM
	DBGU_CIDR_NVPTYP_SRAM = 0x4
	// Position of EXT field.
	DBGU_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	DBGU_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	DBGU_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	DBGU_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	DBGU_EXID_EXID_Msk = 0xffffffff

	// FNR: Force NTRST Register
	// Position of FNTRST field.
	DBGU_FNR_FNTRST_Pos = 0x0
	// Bit mask of FNTRST field.
	DBGU_FNR_FNTRST_Msk = 0x1
	// Bit FNTRST.
	DBGU_FNR_FNTRST = 0x1
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ABCDSR: Peripheral Select Register
	// Position of P0 field.
	PIO_ABCDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABCDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABCDSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABCDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABCDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABCDSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABCDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABCDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABCDSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABCDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABCDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABCDSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABCDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABCDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABCDSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABCDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABCDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABCDSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABCDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABCDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABCDSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABCDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABCDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABCDSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABCDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABCDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABCDSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABCDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABCDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABCDSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABCDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABCDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABCDSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABCDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABCDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABCDSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABCDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABCDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABCDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABCDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABCDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABCDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABCDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABCDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABCDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABCDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABCDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABCDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABCDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABCDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABCDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABCDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABCDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABCDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABCDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABCDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABCDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABCDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABCDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABCDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABCDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABCDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABCDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABCDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABCDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABCDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABCDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABCDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABCDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABCDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABCDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABCDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABCDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABCDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABCDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABCDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABCDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABCDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABCDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABCDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABCDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABCDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABCDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABCDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABCDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABCDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABCDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABCDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABCDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABCDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABCDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABCDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABCDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABCDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABCDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABCDSR_P31 = 0x80000000

	// IFSCDR: Input Filter Slow Clock Disable Register
	// Position of P0 field.
	PIO_IFSCDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCDR_P31 = 0x80000000

	// IFSCER: Input Filter Slow Clock Enable Register
	// Position of P0 field.
	PIO_IFSCER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCER_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCER_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCER_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCER_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCER_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCER_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCER_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCER_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCER_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCER_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCER_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCER_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCER_P31 = 0x80000000

	// IFSCSR: Input Filter Slow Clock Status Register
	// Position of P0 field.
	PIO_IFSCSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCSR_P31 = 0x80000000

	// SCDR: Slow Clock Divider Debouncing Register
	// Position of DIV field.
	PIO_SCDR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PIO_SCDR_DIV_Msk = 0x3fff

	// PPDDR: Pad Pull-down Disable Register
	// Position of P0 field.
	PIO_PPDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDDR_P0 = 0x1
	// Position of P1 field.
	PIO_PPDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDDR_P1 = 0x2
	// Position of P2 field.
	PIO_PPDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDDR_P2 = 0x4
	// Position of P3 field.
	PIO_PPDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDDR_P3 = 0x8
	// Position of P4 field.
	PIO_PPDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDDR_P4 = 0x10
	// Position of P5 field.
	PIO_PPDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDDR_P5 = 0x20
	// Position of P6 field.
	PIO_PPDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDDR_P6 = 0x40
	// Position of P7 field.
	PIO_PPDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDDR_P7 = 0x80
	// Position of P8 field.
	PIO_PPDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDDR_P8 = 0x100
	// Position of P9 field.
	PIO_PPDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDDR_P9 = 0x200
	// Position of P10 field.
	PIO_PPDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDDR_P10 = 0x400
	// Position of P11 field.
	PIO_PPDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDDR_P11 = 0x800
	// Position of P12 field.
	PIO_PPDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDDR_P31 = 0x80000000

	// PPDER: Pad Pull-down Enable Register
	// Position of P0 field.
	PIO_PPDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDER_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDER_P0 = 0x1
	// Position of P1 field.
	PIO_PPDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDER_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDER_P1 = 0x2
	// Position of P2 field.
	PIO_PPDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDER_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDER_P2 = 0x4
	// Position of P3 field.
	PIO_PPDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDER_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDER_P3 = 0x8
	// Position of P4 field.
	PIO_PPDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDER_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDER_P4 = 0x10
	// Position of P5 field.
	PIO_PPDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDER_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDER_P5 = 0x20
	// Position of P6 field.
	PIO_PPDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDER_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDER_P6 = 0x40
	// Position of P7 field.
	PIO_PPDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDER_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDER_P7 = 0x80
	// Position of P8 field.
	PIO_PPDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDER_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDER_P8 = 0x100
	// Position of P9 field.
	PIO_PPDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDER_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDER_P9 = 0x200
	// Position of P10 field.
	PIO_PPDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDER_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDER_P10 = 0x400
	// Position of P11 field.
	PIO_PPDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDER_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDER_P11 = 0x800
	// Position of P12 field.
	PIO_PPDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDER_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDER_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDER_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDER_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDER_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDER_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDER_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDER_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDER_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDER_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDER_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDER_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDER_P31 = 0x80000000

	// PPDSR: Pad Pull-down Status Register
	// Position of P0 field.
	PIO_PPDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PPDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PPDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PPDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PPDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PPDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PPDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PPDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PPDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PPDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PPDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PPDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PPDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDSR_P31 = 0x80000000

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000

	// AIMER: Additional Interrupt Modes Enable Register
	// Position of P0 field.
	PIO_AIMER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMER_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMER_P0 = 0x1
	// Position of P1 field.
	PIO_AIMER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMER_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMER_P1 = 0x2
	// Position of P2 field.
	PIO_AIMER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMER_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMER_P2 = 0x4
	// Position of P3 field.
	PIO_AIMER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMER_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMER_P3 = 0x8
	// Position of P4 field.
	PIO_AIMER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMER_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMER_P4 = 0x10
	// Position of P5 field.
	PIO_AIMER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMER_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMER_P5 = 0x20
	// Position of P6 field.
	PIO_AIMER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMER_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMER_P6 = 0x40
	// Position of P7 field.
	PIO_AIMER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMER_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMER_P7 = 0x80
	// Position of P8 field.
	PIO_AIMER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMER_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMER_P8 = 0x100
	// Position of P9 field.
	PIO_AIMER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMER_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMER_P9 = 0x200
	// Position of P10 field.
	PIO_AIMER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMER_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMER_P10 = 0x400
	// Position of P11 field.
	PIO_AIMER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMER_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMER_P11 = 0x800
	// Position of P12 field.
	PIO_AIMER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMER_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMER_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMER_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMER_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMER_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMER_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMER_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMER_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMER_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMER_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMER_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMER_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMER_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMER_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMER_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMER_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMER_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMER_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMER_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMER_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMER_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMER_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMER_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMER_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMER_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMER_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMER_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMER_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMER_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMER_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMER_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMER_P31 = 0x80000000

	// AIMDR: Additional Interrupt Modes Disables Register
	// Position of P0 field.
	PIO_AIMDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMDR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMDR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMDR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMDR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMDR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMDR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMDR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMDR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMDR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMDR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMDR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMDR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMDR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMDR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMDR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMDR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMDR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMDR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMDR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMDR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMDR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMDR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMDR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMDR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMDR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMDR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMDR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMDR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMDR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMDR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMDR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMDR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMDR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMDR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMDR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMDR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMDR_P31 = 0x80000000

	// AIMMR: Additional Interrupt Modes Mask Register
	// Position of P0 field.
	PIO_AIMMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMMR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMMR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMMR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMMR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMMR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMMR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMMR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMMR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMMR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMMR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMMR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMMR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMMR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMMR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMMR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMMR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMMR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMMR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMMR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMMR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMMR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMMR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMMR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMMR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMMR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMMR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMMR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMMR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMMR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMMR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMMR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMMR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMMR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMMR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMMR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMMR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMMR_P31 = 0x80000000

	// ESR: Edge Select Register
	// Position of P0 field.
	PIO_ESR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ESR_P0_Msk = 0x1
	// Bit P0.
	PIO_ESR_P0 = 0x1
	// Position of P1 field.
	PIO_ESR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ESR_P1_Msk = 0x2
	// Bit P1.
	PIO_ESR_P1 = 0x2
	// Position of P2 field.
	PIO_ESR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ESR_P2_Msk = 0x4
	// Bit P2.
	PIO_ESR_P2 = 0x4
	// Position of P3 field.
	PIO_ESR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ESR_P3_Msk = 0x8
	// Bit P3.
	PIO_ESR_P3 = 0x8
	// Position of P4 field.
	PIO_ESR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ESR_P4_Msk = 0x10
	// Bit P4.
	PIO_ESR_P4 = 0x10
	// Position of P5 field.
	PIO_ESR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ESR_P5_Msk = 0x20
	// Bit P5.
	PIO_ESR_P5 = 0x20
	// Position of P6 field.
	PIO_ESR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ESR_P6_Msk = 0x40
	// Bit P6.
	PIO_ESR_P6 = 0x40
	// Position of P7 field.
	PIO_ESR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ESR_P7_Msk = 0x80
	// Bit P7.
	PIO_ESR_P7 = 0x80
	// Position of P8 field.
	PIO_ESR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ESR_P8_Msk = 0x100
	// Bit P8.
	PIO_ESR_P8 = 0x100
	// Position of P9 field.
	PIO_ESR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ESR_P9_Msk = 0x200
	// Bit P9.
	PIO_ESR_P9 = 0x200
	// Position of P10 field.
	PIO_ESR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ESR_P10_Msk = 0x400
	// Bit P10.
	PIO_ESR_P10 = 0x400
	// Position of P11 field.
	PIO_ESR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ESR_P11_Msk = 0x800
	// Bit P11.
	PIO_ESR_P11 = 0x800
	// Position of P12 field.
	PIO_ESR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ESR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ESR_P12 = 0x1000
	// Position of P13 field.
	PIO_ESR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ESR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ESR_P13 = 0x2000
	// Position of P14 field.
	PIO_ESR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ESR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ESR_P14 = 0x4000
	// Position of P15 field.
	PIO_ESR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ESR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ESR_P15 = 0x8000
	// Position of P16 field.
	PIO_ESR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ESR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ESR_P16 = 0x10000
	// Position of P17 field.
	PIO_ESR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ESR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ESR_P17 = 0x20000
	// Position of P18 field.
	PIO_ESR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ESR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ESR_P18 = 0x40000
	// Position of P19 field.
	PIO_ESR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ESR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ESR_P19 = 0x80000
	// Position of P20 field.
	PIO_ESR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ESR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ESR_P20 = 0x100000
	// Position of P21 field.
	PIO_ESR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ESR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ESR_P21 = 0x200000
	// Position of P22 field.
	PIO_ESR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ESR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ESR_P22 = 0x400000
	// Position of P23 field.
	PIO_ESR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ESR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ESR_P23 = 0x800000
	// Position of P24 field.
	PIO_ESR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ESR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ESR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ESR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ESR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ESR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ESR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ESR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ESR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ESR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ESR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ESR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ESR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ESR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ESR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ESR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ESR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ESR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ESR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ESR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ESR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ESR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ESR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ESR_P31 = 0x80000000

	// LSR: Level Select Register
	// Position of P0 field.
	PIO_LSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LSR_P0 = 0x1
	// Position of P1 field.
	PIO_LSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LSR_P1 = 0x2
	// Position of P2 field.
	PIO_LSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LSR_P2 = 0x4
	// Position of P3 field.
	PIO_LSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LSR_P3 = 0x8
	// Position of P4 field.
	PIO_LSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LSR_P4 = 0x10
	// Position of P5 field.
	PIO_LSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LSR_P5 = 0x20
	// Position of P6 field.
	PIO_LSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LSR_P6 = 0x40
	// Position of P7 field.
	PIO_LSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LSR_P7 = 0x80
	// Position of P8 field.
	PIO_LSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LSR_P8 = 0x100
	// Position of P9 field.
	PIO_LSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LSR_P9 = 0x200
	// Position of P10 field.
	PIO_LSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LSR_P10 = 0x400
	// Position of P11 field.
	PIO_LSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LSR_P11 = 0x800
	// Position of P12 field.
	PIO_LSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LSR_P31 = 0x80000000

	// ELSR: Edge/Level Status Register
	// Position of P0 field.
	PIO_ELSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ELSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ELSR_P0 = 0x1
	// Position of P1 field.
	PIO_ELSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ELSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ELSR_P1 = 0x2
	// Position of P2 field.
	PIO_ELSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ELSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ELSR_P2 = 0x4
	// Position of P3 field.
	PIO_ELSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ELSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ELSR_P3 = 0x8
	// Position of P4 field.
	PIO_ELSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ELSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ELSR_P4 = 0x10
	// Position of P5 field.
	PIO_ELSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ELSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ELSR_P5 = 0x20
	// Position of P6 field.
	PIO_ELSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ELSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ELSR_P6 = 0x40
	// Position of P7 field.
	PIO_ELSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ELSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ELSR_P7 = 0x80
	// Position of P8 field.
	PIO_ELSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ELSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ELSR_P8 = 0x100
	// Position of P9 field.
	PIO_ELSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ELSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ELSR_P9 = 0x200
	// Position of P10 field.
	PIO_ELSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ELSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ELSR_P10 = 0x400
	// Position of P11 field.
	PIO_ELSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ELSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ELSR_P11 = 0x800
	// Position of P12 field.
	PIO_ELSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ELSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ELSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ELSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ELSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ELSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ELSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ELSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ELSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ELSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ELSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ELSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ELSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ELSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ELSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ELSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ELSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ELSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ELSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ELSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ELSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ELSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ELSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ELSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ELSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ELSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ELSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ELSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ELSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ELSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ELSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ELSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ELSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ELSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ELSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ELSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ELSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ELSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ELSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ELSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ELSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ELSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ELSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ELSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ELSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ELSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ELSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ELSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ELSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ELSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ELSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ELSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ELSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ELSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ELSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ELSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ELSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ELSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ELSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ELSR_P31 = 0x80000000

	// FELLSR: Falling Edge/Low Level Select Register
	// Position of P0 field.
	PIO_FELLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FELLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FELLSR_P0 = 0x1
	// Position of P1 field.
	PIO_FELLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FELLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FELLSR_P1 = 0x2
	// Position of P2 field.
	PIO_FELLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FELLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FELLSR_P2 = 0x4
	// Position of P3 field.
	PIO_FELLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FELLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FELLSR_P3 = 0x8
	// Position of P4 field.
	PIO_FELLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FELLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FELLSR_P4 = 0x10
	// Position of P5 field.
	PIO_FELLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FELLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FELLSR_P5 = 0x20
	// Position of P6 field.
	PIO_FELLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FELLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FELLSR_P6 = 0x40
	// Position of P7 field.
	PIO_FELLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FELLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FELLSR_P7 = 0x80
	// Position of P8 field.
	PIO_FELLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FELLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FELLSR_P8 = 0x100
	// Position of P9 field.
	PIO_FELLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FELLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FELLSR_P9 = 0x200
	// Position of P10 field.
	PIO_FELLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FELLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FELLSR_P10 = 0x400
	// Position of P11 field.
	PIO_FELLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FELLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FELLSR_P11 = 0x800
	// Position of P12 field.
	PIO_FELLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FELLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FELLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FELLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FELLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FELLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FELLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FELLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FELLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FELLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FELLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FELLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FELLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FELLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FELLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FELLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FELLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FELLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FELLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FELLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FELLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FELLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FELLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FELLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FELLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FELLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FELLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FELLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FELLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FELLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FELLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FELLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FELLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FELLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FELLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FELLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FELLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FELLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FELLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FELLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FELLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FELLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FELLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FELLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FELLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FELLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FELLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FELLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FELLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FELLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FELLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FELLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FELLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FELLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FELLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FELLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FELLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FELLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FELLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FELLSR_P31 = 0x80000000

	// REHLSR: Rising Edge/ High Level Select Register
	// Position of P0 field.
	PIO_REHLSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_REHLSR_P0_Msk = 0x1
	// Bit P0.
	PIO_REHLSR_P0 = 0x1
	// Position of P1 field.
	PIO_REHLSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_REHLSR_P1_Msk = 0x2
	// Bit P1.
	PIO_REHLSR_P1 = 0x2
	// Position of P2 field.
	PIO_REHLSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_REHLSR_P2_Msk = 0x4
	// Bit P2.
	PIO_REHLSR_P2 = 0x4
	// Position of P3 field.
	PIO_REHLSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_REHLSR_P3_Msk = 0x8
	// Bit P3.
	PIO_REHLSR_P3 = 0x8
	// Position of P4 field.
	PIO_REHLSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_REHLSR_P4_Msk = 0x10
	// Bit P4.
	PIO_REHLSR_P4 = 0x10
	// Position of P5 field.
	PIO_REHLSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_REHLSR_P5_Msk = 0x20
	// Bit P5.
	PIO_REHLSR_P5 = 0x20
	// Position of P6 field.
	PIO_REHLSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_REHLSR_P6_Msk = 0x40
	// Bit P6.
	PIO_REHLSR_P6 = 0x40
	// Position of P7 field.
	PIO_REHLSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_REHLSR_P7_Msk = 0x80
	// Bit P7.
	PIO_REHLSR_P7 = 0x80
	// Position of P8 field.
	PIO_REHLSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_REHLSR_P8_Msk = 0x100
	// Bit P8.
	PIO_REHLSR_P8 = 0x100
	// Position of P9 field.
	PIO_REHLSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_REHLSR_P9_Msk = 0x200
	// Bit P9.
	PIO_REHLSR_P9 = 0x200
	// Position of P10 field.
	PIO_REHLSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_REHLSR_P10_Msk = 0x400
	// Bit P10.
	PIO_REHLSR_P10 = 0x400
	// Position of P11 field.
	PIO_REHLSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_REHLSR_P11_Msk = 0x800
	// Bit P11.
	PIO_REHLSR_P11 = 0x800
	// Position of P12 field.
	PIO_REHLSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_REHLSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_REHLSR_P12 = 0x1000
	// Position of P13 field.
	PIO_REHLSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_REHLSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_REHLSR_P13 = 0x2000
	// Position of P14 field.
	PIO_REHLSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_REHLSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_REHLSR_P14 = 0x4000
	// Position of P15 field.
	PIO_REHLSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_REHLSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_REHLSR_P15 = 0x8000
	// Position of P16 field.
	PIO_REHLSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_REHLSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_REHLSR_P16 = 0x10000
	// Position of P17 field.
	PIO_REHLSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_REHLSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_REHLSR_P17 = 0x20000
	// Position of P18 field.
	PIO_REHLSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_REHLSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_REHLSR_P18 = 0x40000
	// Position of P19 field.
	PIO_REHLSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_REHLSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_REHLSR_P19 = 0x80000
	// Position of P20 field.
	PIO_REHLSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_REHLSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_REHLSR_P20 = 0x100000
	// Position of P21 field.
	PIO_REHLSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_REHLSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_REHLSR_P21 = 0x200000
	// Position of P22 field.
	PIO_REHLSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_REHLSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_REHLSR_P22 = 0x400000
	// Position of P23 field.
	PIO_REHLSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_REHLSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_REHLSR_P23 = 0x800000
	// Position of P24 field.
	PIO_REHLSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_REHLSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_REHLSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_REHLSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_REHLSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_REHLSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_REHLSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_REHLSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_REHLSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_REHLSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_REHLSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_REHLSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_REHLSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_REHLSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_REHLSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_REHLSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_REHLSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_REHLSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_REHLSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_REHLSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_REHLSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_REHLSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_REHLSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_REHLSR_P31 = 0x80000000

	// FRLHSR: Fall/Rise - Low/High Status Register
	// Position of P0 field.
	PIO_FRLHSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_FRLHSR_P0_Msk = 0x1
	// Bit P0.
	PIO_FRLHSR_P0 = 0x1
	// Position of P1 field.
	PIO_FRLHSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_FRLHSR_P1_Msk = 0x2
	// Bit P1.
	PIO_FRLHSR_P1 = 0x2
	// Position of P2 field.
	PIO_FRLHSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_FRLHSR_P2_Msk = 0x4
	// Bit P2.
	PIO_FRLHSR_P2 = 0x4
	// Position of P3 field.
	PIO_FRLHSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_FRLHSR_P3_Msk = 0x8
	// Bit P3.
	PIO_FRLHSR_P3 = 0x8
	// Position of P4 field.
	PIO_FRLHSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_FRLHSR_P4_Msk = 0x10
	// Bit P4.
	PIO_FRLHSR_P4 = 0x10
	// Position of P5 field.
	PIO_FRLHSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_FRLHSR_P5_Msk = 0x20
	// Bit P5.
	PIO_FRLHSR_P5 = 0x20
	// Position of P6 field.
	PIO_FRLHSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_FRLHSR_P6_Msk = 0x40
	// Bit P6.
	PIO_FRLHSR_P6 = 0x40
	// Position of P7 field.
	PIO_FRLHSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_FRLHSR_P7_Msk = 0x80
	// Bit P7.
	PIO_FRLHSR_P7 = 0x80
	// Position of P8 field.
	PIO_FRLHSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_FRLHSR_P8_Msk = 0x100
	// Bit P8.
	PIO_FRLHSR_P8 = 0x100
	// Position of P9 field.
	PIO_FRLHSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_FRLHSR_P9_Msk = 0x200
	// Bit P9.
	PIO_FRLHSR_P9 = 0x200
	// Position of P10 field.
	PIO_FRLHSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_FRLHSR_P10_Msk = 0x400
	// Bit P10.
	PIO_FRLHSR_P10 = 0x400
	// Position of P11 field.
	PIO_FRLHSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_FRLHSR_P11_Msk = 0x800
	// Bit P11.
	PIO_FRLHSR_P11 = 0x800
	// Position of P12 field.
	PIO_FRLHSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_FRLHSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_FRLHSR_P12 = 0x1000
	// Position of P13 field.
	PIO_FRLHSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_FRLHSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_FRLHSR_P13 = 0x2000
	// Position of P14 field.
	PIO_FRLHSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_FRLHSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_FRLHSR_P14 = 0x4000
	// Position of P15 field.
	PIO_FRLHSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_FRLHSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_FRLHSR_P15 = 0x8000
	// Position of P16 field.
	PIO_FRLHSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_FRLHSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_FRLHSR_P16 = 0x10000
	// Position of P17 field.
	PIO_FRLHSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_FRLHSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_FRLHSR_P17 = 0x20000
	// Position of P18 field.
	PIO_FRLHSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_FRLHSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_FRLHSR_P18 = 0x40000
	// Position of P19 field.
	PIO_FRLHSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_FRLHSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_FRLHSR_P19 = 0x80000
	// Position of P20 field.
	PIO_FRLHSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_FRLHSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_FRLHSR_P20 = 0x100000
	// Position of P21 field.
	PIO_FRLHSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_FRLHSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_FRLHSR_P21 = 0x200000
	// Position of P22 field.
	PIO_FRLHSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_FRLHSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_FRLHSR_P22 = 0x400000
	// Position of P23 field.
	PIO_FRLHSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_FRLHSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_FRLHSR_P23 = 0x800000
	// Position of P24 field.
	PIO_FRLHSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_FRLHSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_FRLHSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_FRLHSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_FRLHSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_FRLHSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_FRLHSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_FRLHSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_FRLHSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_FRLHSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_FRLHSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_FRLHSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_FRLHSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_FRLHSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_FRLHSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_FRLHSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_FRLHSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_FRLHSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_FRLHSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_FRLHSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_FRLHSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_FRLHSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_FRLHSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_FRLHSR_P31 = 0x80000000

	// LOCKSR: Lock Status
	// Position of P0 field.
	PIO_LOCKSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_LOCKSR_P0_Msk = 0x1
	// Bit P0.
	PIO_LOCKSR_P0 = 0x1
	// Position of P1 field.
	PIO_LOCKSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_LOCKSR_P1_Msk = 0x2
	// Bit P1.
	PIO_LOCKSR_P1 = 0x2
	// Position of P2 field.
	PIO_LOCKSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_LOCKSR_P2_Msk = 0x4
	// Bit P2.
	PIO_LOCKSR_P2 = 0x4
	// Position of P3 field.
	PIO_LOCKSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_LOCKSR_P3_Msk = 0x8
	// Bit P3.
	PIO_LOCKSR_P3 = 0x8
	// Position of P4 field.
	PIO_LOCKSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_LOCKSR_P4_Msk = 0x10
	// Bit P4.
	PIO_LOCKSR_P4 = 0x10
	// Position of P5 field.
	PIO_LOCKSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_LOCKSR_P5_Msk = 0x20
	// Bit P5.
	PIO_LOCKSR_P5 = 0x20
	// Position of P6 field.
	PIO_LOCKSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_LOCKSR_P6_Msk = 0x40
	// Bit P6.
	PIO_LOCKSR_P6 = 0x40
	// Position of P7 field.
	PIO_LOCKSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_LOCKSR_P7_Msk = 0x80
	// Bit P7.
	PIO_LOCKSR_P7 = 0x80
	// Position of P8 field.
	PIO_LOCKSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_LOCKSR_P8_Msk = 0x100
	// Bit P8.
	PIO_LOCKSR_P8 = 0x100
	// Position of P9 field.
	PIO_LOCKSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_LOCKSR_P9_Msk = 0x200
	// Bit P9.
	PIO_LOCKSR_P9 = 0x200
	// Position of P10 field.
	PIO_LOCKSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_LOCKSR_P10_Msk = 0x400
	// Bit P10.
	PIO_LOCKSR_P10 = 0x400
	// Position of P11 field.
	PIO_LOCKSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_LOCKSR_P11_Msk = 0x800
	// Bit P11.
	PIO_LOCKSR_P11 = 0x800
	// Position of P12 field.
	PIO_LOCKSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_LOCKSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_LOCKSR_P12 = 0x1000
	// Position of P13 field.
	PIO_LOCKSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_LOCKSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_LOCKSR_P13 = 0x2000
	// Position of P14 field.
	PIO_LOCKSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_LOCKSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_LOCKSR_P14 = 0x4000
	// Position of P15 field.
	PIO_LOCKSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_LOCKSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_LOCKSR_P15 = 0x8000
	// Position of P16 field.
	PIO_LOCKSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_LOCKSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_LOCKSR_P16 = 0x10000
	// Position of P17 field.
	PIO_LOCKSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_LOCKSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_LOCKSR_P17 = 0x20000
	// Position of P18 field.
	PIO_LOCKSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_LOCKSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_LOCKSR_P18 = 0x40000
	// Position of P19 field.
	PIO_LOCKSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_LOCKSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_LOCKSR_P19 = 0x80000
	// Position of P20 field.
	PIO_LOCKSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_LOCKSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_LOCKSR_P20 = 0x100000
	// Position of P21 field.
	PIO_LOCKSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_LOCKSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_LOCKSR_P21 = 0x200000
	// Position of P22 field.
	PIO_LOCKSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_LOCKSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_LOCKSR_P22 = 0x400000
	// Position of P23 field.
	PIO_LOCKSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_LOCKSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_LOCKSR_P23 = 0x800000
	// Position of P24 field.
	PIO_LOCKSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_LOCKSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_LOCKSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_LOCKSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_LOCKSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_LOCKSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_LOCKSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_LOCKSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_LOCKSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_LOCKSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_LOCKSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_LOCKSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_LOCKSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_LOCKSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_LOCKSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_LOCKSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_LOCKSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_LOCKSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_LOCKSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_LOCKSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_LOCKSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_LOCKSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_LOCKSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_LOCKSR_P31 = 0x80000000

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PIO_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PIO_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PIO_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PIO_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PIO_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	PIO_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PIO_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PIO_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PIO_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PIO_WPSR_WPVSRC_Msk = 0xffff00

	// SCHMITT: Schmitt Trigger Register
	// Position of SCHMITT0 field.
	PIO_SCHMITT_SCHMITT0_Pos = 0x0
	// Bit mask of SCHMITT0 field.
	PIO_SCHMITT_SCHMITT0_Msk = 0x1
	// Bit SCHMITT0.
	PIO_SCHMITT_SCHMITT0 = 0x1
	// Position of SCHMITT1 field.
	PIO_SCHMITT_SCHMITT1_Pos = 0x1
	// Bit mask of SCHMITT1 field.
	PIO_SCHMITT_SCHMITT1_Msk = 0x2
	// Bit SCHMITT1.
	PIO_SCHMITT_SCHMITT1 = 0x2
	// Position of SCHMITT2 field.
	PIO_SCHMITT_SCHMITT2_Pos = 0x2
	// Bit mask of SCHMITT2 field.
	PIO_SCHMITT_SCHMITT2_Msk = 0x4
	// Bit SCHMITT2.
	PIO_SCHMITT_SCHMITT2 = 0x4
	// Position of SCHMITT3 field.
	PIO_SCHMITT_SCHMITT3_Pos = 0x3
	// Bit mask of SCHMITT3 field.
	PIO_SCHMITT_SCHMITT3_Msk = 0x8
	// Bit SCHMITT3.
	PIO_SCHMITT_SCHMITT3 = 0x8
	// Position of SCHMITT4 field.
	PIO_SCHMITT_SCHMITT4_Pos = 0x4
	// Bit mask of SCHMITT4 field.
	PIO_SCHMITT_SCHMITT4_Msk = 0x10
	// Bit SCHMITT4.
	PIO_SCHMITT_SCHMITT4 = 0x10
	// Position of SCHMITT5 field.
	PIO_SCHMITT_SCHMITT5_Pos = 0x5
	// Bit mask of SCHMITT5 field.
	PIO_SCHMITT_SCHMITT5_Msk = 0x20
	// Bit SCHMITT5.
	PIO_SCHMITT_SCHMITT5 = 0x20
	// Position of SCHMITT6 field.
	PIO_SCHMITT_SCHMITT6_Pos = 0x6
	// Bit mask of SCHMITT6 field.
	PIO_SCHMITT_SCHMITT6_Msk = 0x40
	// Bit SCHMITT6.
	PIO_SCHMITT_SCHMITT6 = 0x40
	// Position of SCHMITT7 field.
	PIO_SCHMITT_SCHMITT7_Pos = 0x7
	// Bit mask of SCHMITT7 field.
	PIO_SCHMITT_SCHMITT7_Msk = 0x80
	// Bit SCHMITT7.
	PIO_SCHMITT_SCHMITT7 = 0x80
	// Position of SCHMITT8 field.
	PIO_SCHMITT_SCHMITT8_Pos = 0x8
	// Bit mask of SCHMITT8 field.
	PIO_SCHMITT_SCHMITT8_Msk = 0x100
	// Bit SCHMITT8.
	PIO_SCHMITT_SCHMITT8 = 0x100
	// Position of SCHMITT9 field.
	PIO_SCHMITT_SCHMITT9_Pos = 0x9
	// Bit mask of SCHMITT9 field.
	PIO_SCHMITT_SCHMITT9_Msk = 0x200
	// Bit SCHMITT9.
	PIO_SCHMITT_SCHMITT9 = 0x200
	// Position of SCHMITT10 field.
	PIO_SCHMITT_SCHMITT10_Pos = 0xa
	// Bit mask of SCHMITT10 field.
	PIO_SCHMITT_SCHMITT10_Msk = 0x400
	// Bit SCHMITT10.
	PIO_SCHMITT_SCHMITT10 = 0x400
	// Position of SCHMITT11 field.
	PIO_SCHMITT_SCHMITT11_Pos = 0xb
	// Bit mask of SCHMITT11 field.
	PIO_SCHMITT_SCHMITT11_Msk = 0x800
	// Bit SCHMITT11.
	PIO_SCHMITT_SCHMITT11 = 0x800
	// Position of SCHMITT12 field.
	PIO_SCHMITT_SCHMITT12_Pos = 0xc
	// Bit mask of SCHMITT12 field.
	PIO_SCHMITT_SCHMITT12_Msk = 0x1000
	// Bit SCHMITT12.
	PIO_SCHMITT_SCHMITT12 = 0x1000
	// Position of SCHMITT13 field.
	PIO_SCHMITT_SCHMITT13_Pos = 0xd
	// Bit mask of SCHMITT13 field.
	PIO_SCHMITT_SCHMITT13_Msk = 0x2000
	// Bit SCHMITT13.
	PIO_SCHMITT_SCHMITT13 = 0x2000
	// Position of SCHMITT14 field.
	PIO_SCHMITT_SCHMITT14_Pos = 0xe
	// Bit mask of SCHMITT14 field.
	PIO_SCHMITT_SCHMITT14_Msk = 0x4000
	// Bit SCHMITT14.
	PIO_SCHMITT_SCHMITT14 = 0x4000
	// Position of SCHMITT15 field.
	PIO_SCHMITT_SCHMITT15_Pos = 0xf
	// Bit mask of SCHMITT15 field.
	PIO_SCHMITT_SCHMITT15_Msk = 0x8000
	// Bit SCHMITT15.
	PIO_SCHMITT_SCHMITT15 = 0x8000
	// Position of SCHMITT16 field.
	PIO_SCHMITT_SCHMITT16_Pos = 0x10
	// Bit mask of SCHMITT16 field.
	PIO_SCHMITT_SCHMITT16_Msk = 0x10000
	// Bit SCHMITT16.
	PIO_SCHMITT_SCHMITT16 = 0x10000
	// Position of SCHMITT17 field.
	PIO_SCHMITT_SCHMITT17_Pos = 0x11
	// Bit mask of SCHMITT17 field.
	PIO_SCHMITT_SCHMITT17_Msk = 0x20000
	// Bit SCHMITT17.
	PIO_SCHMITT_SCHMITT17 = 0x20000
	// Position of SCHMITT18 field.
	PIO_SCHMITT_SCHMITT18_Pos = 0x12
	// Bit mask of SCHMITT18 field.
	PIO_SCHMITT_SCHMITT18_Msk = 0x40000
	// Bit SCHMITT18.
	PIO_SCHMITT_SCHMITT18 = 0x40000
	// Position of SCHMITT19 field.
	PIO_SCHMITT_SCHMITT19_Pos = 0x13
	// Bit mask of SCHMITT19 field.
	PIO_SCHMITT_SCHMITT19_Msk = 0x80000
	// Bit SCHMITT19.
	PIO_SCHMITT_SCHMITT19 = 0x80000
	// Position of SCHMITT20 field.
	PIO_SCHMITT_SCHMITT20_Pos = 0x14
	// Bit mask of SCHMITT20 field.
	PIO_SCHMITT_SCHMITT20_Msk = 0x100000
	// Bit SCHMITT20.
	PIO_SCHMITT_SCHMITT20 = 0x100000
	// Position of SCHMITT21 field.
	PIO_SCHMITT_SCHMITT21_Pos = 0x15
	// Bit mask of SCHMITT21 field.
	PIO_SCHMITT_SCHMITT21_Msk = 0x200000
	// Bit SCHMITT21.
	PIO_SCHMITT_SCHMITT21 = 0x200000
	// Position of SCHMITT22 field.
	PIO_SCHMITT_SCHMITT22_Pos = 0x16
	// Bit mask of SCHMITT22 field.
	PIO_SCHMITT_SCHMITT22_Msk = 0x400000
	// Bit SCHMITT22.
	PIO_SCHMITT_SCHMITT22 = 0x400000
	// Position of SCHMITT23 field.
	PIO_SCHMITT_SCHMITT23_Pos = 0x17
	// Bit mask of SCHMITT23 field.
	PIO_SCHMITT_SCHMITT23_Msk = 0x800000
	// Bit SCHMITT23.
	PIO_SCHMITT_SCHMITT23 = 0x800000
	// Position of SCHMITT24 field.
	PIO_SCHMITT_SCHMITT24_Pos = 0x18
	// Bit mask of SCHMITT24 field.
	PIO_SCHMITT_SCHMITT24_Msk = 0x1000000
	// Bit SCHMITT24.
	PIO_SCHMITT_SCHMITT24 = 0x1000000
	// Position of SCHMITT25 field.
	PIO_SCHMITT_SCHMITT25_Pos = 0x19
	// Bit mask of SCHMITT25 field.
	PIO_SCHMITT_SCHMITT25_Msk = 0x2000000
	// Bit SCHMITT25.
	PIO_SCHMITT_SCHMITT25 = 0x2000000
	// Position of SCHMITT26 field.
	PIO_SCHMITT_SCHMITT26_Pos = 0x1a
	// Bit mask of SCHMITT26 field.
	PIO_SCHMITT_SCHMITT26_Msk = 0x4000000
	// Bit SCHMITT26.
	PIO_SCHMITT_SCHMITT26 = 0x4000000
	// Position of SCHMITT27 field.
	PIO_SCHMITT_SCHMITT27_Pos = 0x1b
	// Bit mask of SCHMITT27 field.
	PIO_SCHMITT_SCHMITT27_Msk = 0x8000000
	// Bit SCHMITT27.
	PIO_SCHMITT_SCHMITT27 = 0x8000000
	// Position of SCHMITT28 field.
	PIO_SCHMITT_SCHMITT28_Pos = 0x1c
	// Bit mask of SCHMITT28 field.
	PIO_SCHMITT_SCHMITT28_Msk = 0x10000000
	// Bit SCHMITT28.
	PIO_SCHMITT_SCHMITT28 = 0x10000000
	// Position of SCHMITT29 field.
	PIO_SCHMITT_SCHMITT29_Pos = 0x1d
	// Bit mask of SCHMITT29 field.
	PIO_SCHMITT_SCHMITT29_Msk = 0x20000000
	// Bit SCHMITT29.
	PIO_SCHMITT_SCHMITT29 = 0x20000000
	// Position of SCHMITT30 field.
	PIO_SCHMITT_SCHMITT30_Pos = 0x1e
	// Bit mask of SCHMITT30 field.
	PIO_SCHMITT_SCHMITT30_Msk = 0x40000000
	// Bit SCHMITT30.
	PIO_SCHMITT_SCHMITT30 = 0x40000000
	// Position of SCHMITT31 field.
	PIO_SCHMITT_SCHMITT31_Pos = 0x1f
	// Bit mask of SCHMITT31 field.
	PIO_SCHMITT_SCHMITT31_Msk = 0x80000000
	// Bit SCHMITT31.
	PIO_SCHMITT_SCHMITT31 = 0x80000000

	// DELAYR: IO Delay Register
	// Position of Delay0 field.
	PIO_DELAYR_Delay0_Pos = 0x0
	// Bit mask of Delay0 field.
	PIO_DELAYR_Delay0_Msk = 0xf
	// Position of Delay1 field.
	PIO_DELAYR_Delay1_Pos = 0x4
	// Bit mask of Delay1 field.
	PIO_DELAYR_Delay1_Msk = 0xf0
	// Position of Delay2 field.
	PIO_DELAYR_Delay2_Pos = 0x8
	// Bit mask of Delay2 field.
	PIO_DELAYR_Delay2_Msk = 0xf00
	// Position of Delay3 field.
	PIO_DELAYR_Delay3_Pos = 0xc
	// Bit mask of Delay3 field.
	PIO_DELAYR_Delay3_Msk = 0xf000
	// Position of Delay4 field.
	PIO_DELAYR_Delay4_Pos = 0x10
	// Bit mask of Delay4 field.
	PIO_DELAYR_Delay4_Msk = 0xf0000
	// Position of Delay5 field.
	PIO_DELAYR_Delay5_Pos = 0x14
	// Bit mask of Delay5 field.
	PIO_DELAYR_Delay5_Msk = 0xf00000
	// Position of Delay6 field.
	PIO_DELAYR_Delay6_Pos = 0x18
	// Bit mask of Delay6 field.
	PIO_DELAYR_Delay6_Msk = 0xf000000
	// Position of Delay7 field.
	PIO_DELAYR_Delay7_Pos = 0x1c
	// Bit mask of Delay7 field.
	PIO_DELAYR_Delay7_Msk = 0xf0000000

	// DRIVER1: I/O Drive Register 1
	// Position of LINE0 field.
	PIO_DRIVER1_LINE0_Pos = 0x0
	// Bit mask of LINE0 field.
	PIO_DRIVER1_LINE0_Msk = 0x3
	// High drive
	PIO_DRIVER1_LINE0_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE0_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE0_LO_DRIVE = 0x2
	// Position of LINE1 field.
	PIO_DRIVER1_LINE1_Pos = 0x2
	// Bit mask of LINE1 field.
	PIO_DRIVER1_LINE1_Msk = 0xc
	// High drive
	PIO_DRIVER1_LINE1_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE1_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE1_LO_DRIVE = 0x2
	// Position of LINE2 field.
	PIO_DRIVER1_LINE2_Pos = 0x4
	// Bit mask of LINE2 field.
	PIO_DRIVER1_LINE2_Msk = 0x30
	// High drive
	PIO_DRIVER1_LINE2_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE2_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE2_LO_DRIVE = 0x2
	// Position of LINE3 field.
	PIO_DRIVER1_LINE3_Pos = 0x6
	// Bit mask of LINE3 field.
	PIO_DRIVER1_LINE3_Msk = 0xc0
	// High drive
	PIO_DRIVER1_LINE3_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE3_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE3_LO_DRIVE = 0x2
	// Position of LINE4 field.
	PIO_DRIVER1_LINE4_Pos = 0x8
	// Bit mask of LINE4 field.
	PIO_DRIVER1_LINE4_Msk = 0x300
	// High drive
	PIO_DRIVER1_LINE4_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE4_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE4_LO_DRIVE = 0x2
	// Position of LINE5 field.
	PIO_DRIVER1_LINE5_Pos = 0xa
	// Bit mask of LINE5 field.
	PIO_DRIVER1_LINE5_Msk = 0xc00
	// High drive
	PIO_DRIVER1_LINE5_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE5_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE5_LO_DRIVE = 0x2
	// Position of LINE6 field.
	PIO_DRIVER1_LINE6_Pos = 0xc
	// Bit mask of LINE6 field.
	PIO_DRIVER1_LINE6_Msk = 0x3000
	// High drive
	PIO_DRIVER1_LINE6_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE6_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE6_LO_DRIVE = 0x2
	// Position of LINE7 field.
	PIO_DRIVER1_LINE7_Pos = 0xe
	// Bit mask of LINE7 field.
	PIO_DRIVER1_LINE7_Msk = 0xc000
	// High drive
	PIO_DRIVER1_LINE7_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE7_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE7_LO_DRIVE = 0x2
	// Position of LINE8 field.
	PIO_DRIVER1_LINE8_Pos = 0x10
	// Bit mask of LINE8 field.
	PIO_DRIVER1_LINE8_Msk = 0x30000
	// High drive
	PIO_DRIVER1_LINE8_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE8_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE8_LO_DRIVE = 0x2
	// Position of LINE9 field.
	PIO_DRIVER1_LINE9_Pos = 0x12
	// Bit mask of LINE9 field.
	PIO_DRIVER1_LINE9_Msk = 0xc0000
	// High drive
	PIO_DRIVER1_LINE9_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE9_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE9_LO_DRIVE = 0x2
	// Position of LINE10 field.
	PIO_DRIVER1_LINE10_Pos = 0x14
	// Bit mask of LINE10 field.
	PIO_DRIVER1_LINE10_Msk = 0x300000
	// High drive
	PIO_DRIVER1_LINE10_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE10_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE10_LO_DRIVE = 0x2
	// Position of LINE11 field.
	PIO_DRIVER1_LINE11_Pos = 0x16
	// Bit mask of LINE11 field.
	PIO_DRIVER1_LINE11_Msk = 0xc00000
	// High drive
	PIO_DRIVER1_LINE11_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE11_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE11_LO_DRIVE = 0x2
	// Position of LINE12 field.
	PIO_DRIVER1_LINE12_Pos = 0x18
	// Bit mask of LINE12 field.
	PIO_DRIVER1_LINE12_Msk = 0x3000000
	// High drive
	PIO_DRIVER1_LINE12_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE12_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE12_LO_DRIVE = 0x2
	// Position of LINE13 field.
	PIO_DRIVER1_LINE13_Pos = 0x1a
	// Bit mask of LINE13 field.
	PIO_DRIVER1_LINE13_Msk = 0xc000000
	// High drive
	PIO_DRIVER1_LINE13_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE13_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE13_LO_DRIVE = 0x2
	// Position of LINE14 field.
	PIO_DRIVER1_LINE14_Pos = 0x1c
	// Bit mask of LINE14 field.
	PIO_DRIVER1_LINE14_Msk = 0x30000000
	// High drive
	PIO_DRIVER1_LINE14_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE14_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE14_LO_DRIVE = 0x2
	// Position of LINE15 field.
	PIO_DRIVER1_LINE15_Pos = 0x1e
	// Bit mask of LINE15 field.
	PIO_DRIVER1_LINE15_Msk = 0xc0000000
	// High drive
	PIO_DRIVER1_LINE15_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER1_LINE15_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER1_LINE15_LO_DRIVE = 0x2

	// DRIVER2: I/O Drive Register 2
	// Position of LINE16 field.
	PIO_DRIVER2_LINE16_Pos = 0x0
	// Bit mask of LINE16 field.
	PIO_DRIVER2_LINE16_Msk = 0x3
	// High drive
	PIO_DRIVER2_LINE16_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE16_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE16_LO_DRIVE = 0x2
	// Position of LINE17 field.
	PIO_DRIVER2_LINE17_Pos = 0x2
	// Bit mask of LINE17 field.
	PIO_DRIVER2_LINE17_Msk = 0xc
	// High drive
	PIO_DRIVER2_LINE17_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE17_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE17_LO_DRIVE = 0x2
	// Position of LINE18 field.
	PIO_DRIVER2_LINE18_Pos = 0x4
	// Bit mask of LINE18 field.
	PIO_DRIVER2_LINE18_Msk = 0x30
	// High drive
	PIO_DRIVER2_LINE18_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE18_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE18_LO_DRIVE = 0x2
	// Position of LINE19 field.
	PIO_DRIVER2_LINE19_Pos = 0x6
	// Bit mask of LINE19 field.
	PIO_DRIVER2_LINE19_Msk = 0xc0
	// High drive
	PIO_DRIVER2_LINE19_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE19_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE19_LO_DRIVE = 0x2
	// Position of LINE20 field.
	PIO_DRIVER2_LINE20_Pos = 0x8
	// Bit mask of LINE20 field.
	PIO_DRIVER2_LINE20_Msk = 0x300
	// High drive
	PIO_DRIVER2_LINE20_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE20_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE20_LO_DRIVE = 0x2
	// Position of LINE21 field.
	PIO_DRIVER2_LINE21_Pos = 0xa
	// Bit mask of LINE21 field.
	PIO_DRIVER2_LINE21_Msk = 0xc00
	// High drive
	PIO_DRIVER2_LINE21_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE21_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE21_LO_DRIVE = 0x2
	// Position of LINE22 field.
	PIO_DRIVER2_LINE22_Pos = 0xc
	// Bit mask of LINE22 field.
	PIO_DRIVER2_LINE22_Msk = 0x3000
	// High drive
	PIO_DRIVER2_LINE22_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE22_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE22_LO_DRIVE = 0x2
	// Position of LINE23 field.
	PIO_DRIVER2_LINE23_Pos = 0xe
	// Bit mask of LINE23 field.
	PIO_DRIVER2_LINE23_Msk = 0xc000
	// High drive
	PIO_DRIVER2_LINE23_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE23_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE23_LO_DRIVE = 0x2
	// Position of LINE24 field.
	PIO_DRIVER2_LINE24_Pos = 0x10
	// Bit mask of LINE24 field.
	PIO_DRIVER2_LINE24_Msk = 0x30000
	// High drive
	PIO_DRIVER2_LINE24_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE24_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE24_LO_DRIVE = 0x2
	// Position of LINE25 field.
	PIO_DRIVER2_LINE25_Pos = 0x12
	// Bit mask of LINE25 field.
	PIO_DRIVER2_LINE25_Msk = 0xc0000
	// High drive
	PIO_DRIVER2_LINE25_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE25_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE25_LO_DRIVE = 0x2
	// Position of LINE26 field.
	PIO_DRIVER2_LINE26_Pos = 0x14
	// Bit mask of LINE26 field.
	PIO_DRIVER2_LINE26_Msk = 0x300000
	// High drive
	PIO_DRIVER2_LINE26_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE26_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE26_LO_DRIVE = 0x2
	// Position of LINE27 field.
	PIO_DRIVER2_LINE27_Pos = 0x16
	// Bit mask of LINE27 field.
	PIO_DRIVER2_LINE27_Msk = 0xc00000
	// High drive
	PIO_DRIVER2_LINE27_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE27_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE27_LO_DRIVE = 0x2
	// Position of LINE28 field.
	PIO_DRIVER2_LINE28_Pos = 0x18
	// Bit mask of LINE28 field.
	PIO_DRIVER2_LINE28_Msk = 0x3000000
	// High drive
	PIO_DRIVER2_LINE28_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE28_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE28_LO_DRIVE = 0x2
	// Position of LINE29 field.
	PIO_DRIVER2_LINE29_Pos = 0x1a
	// Bit mask of LINE29 field.
	PIO_DRIVER2_LINE29_Msk = 0xc000000
	// High drive
	PIO_DRIVER2_LINE29_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE29_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE29_LO_DRIVE = 0x2
	// Position of LINE30 field.
	PIO_DRIVER2_LINE30_Pos = 0x1c
	// Bit mask of LINE30 field.
	PIO_DRIVER2_LINE30_Msk = 0x30000000
	// High drive
	PIO_DRIVER2_LINE30_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE30_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE30_LO_DRIVE = 0x2
	// Position of LINE31 field.
	PIO_DRIVER2_LINE31_Pos = 0x1e
	// Bit mask of LINE31 field.
	PIO_DRIVER2_LINE31_Msk = 0xc0000000
	// High drive
	PIO_DRIVER2_LINE31_HI_DRIVE = 0x0
	// Medium drive
	PIO_DRIVER2_LINE31_ME_DRIVE = 0x1
	// Low drive
	PIO_DRIVER2_LINE31_LO_DRIVE = 0x2
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of DDRCK field.
	PMC_PMC_SCER_DDRCK_Pos = 0x2
	// Bit mask of DDRCK field.
	PMC_PMC_SCER_DDRCK_Msk = 0x4
	// Bit DDRCK.
	PMC_PMC_SCER_DDRCK = 0x4
	// Position of LCDCK field.
	PMC_PMC_SCER_LCDCK_Pos = 0x3
	// Bit mask of LCDCK field.
	PMC_PMC_SCER_LCDCK_Msk = 0x8
	// Bit LCDCK.
	PMC_PMC_SCER_LCDCK = 0x8
	// Position of UHP field.
	PMC_PMC_SCER_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCER_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCER_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCER_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCER_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCER_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200

	// PMC_SCDR: System Clock Disable Register
	// Position of PCK field.
	PMC_PMC_SCDR_PCK_Pos = 0x0
	// Bit mask of PCK field.
	PMC_PMC_SCDR_PCK_Msk = 0x1
	// Bit PCK.
	PMC_PMC_SCDR_PCK = 0x1
	// Position of DDRCK field.
	PMC_PMC_SCDR_DDRCK_Pos = 0x2
	// Bit mask of DDRCK field.
	PMC_PMC_SCDR_DDRCK_Msk = 0x4
	// Bit DDRCK.
	PMC_PMC_SCDR_DDRCK = 0x4
	// Position of LCDCK field.
	PMC_PMC_SCDR_LCDCK_Pos = 0x3
	// Bit mask of LCDCK field.
	PMC_PMC_SCDR_LCDCK_Msk = 0x8
	// Bit LCDCK.
	PMC_PMC_SCDR_LCDCK = 0x8
	// Position of UHP field.
	PMC_PMC_SCDR_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCDR_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCDR_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCDR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCDR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCDR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200

	// PMC_SCSR: System Clock Status Register
	// Position of PCK field.
	PMC_PMC_SCSR_PCK_Pos = 0x0
	// Bit mask of PCK field.
	PMC_PMC_SCSR_PCK_Msk = 0x1
	// Bit PCK.
	PMC_PMC_SCSR_PCK = 0x1
	// Position of DDRCK field.
	PMC_PMC_SCSR_DDRCK_Pos = 0x2
	// Bit mask of DDRCK field.
	PMC_PMC_SCSR_DDRCK_Msk = 0x4
	// Bit DDRCK.
	PMC_PMC_SCSR_DDRCK = 0x4
	// Position of LCDCK field.
	PMC_PMC_SCSR_LCDCK_Pos = 0x3
	// Bit mask of LCDCK field.
	PMC_PMC_SCSR_LCDCK_Msk = 0x8
	// Bit LCDCK.
	PMC_PMC_SCSR_LCDCK = 0x8
	// Position of UHP field.
	PMC_PMC_SCSR_UHP_Pos = 0x6
	// Bit mask of UHP field.
	PMC_PMC_SCSR_UHP_Msk = 0x40
	// Bit UHP.
	PMC_PMC_SCSR_UHP = 0x40
	// Position of UDP field.
	PMC_PMC_SCSR_UDP_Pos = 0x7
	// Bit mask of UDP field.
	PMC_PMC_SCSR_UDP_Msk = 0x80
	// Bit UDP.
	PMC_PMC_SCSR_UDP = 0x80
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200

	// PMC_PCER: Peripheral Clock Enable Register
	// Position of PID2 field.
	PMC_PMC_PCER_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCER_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCER_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCER_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCER_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCER_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCER_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCER_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCER_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCER_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCER_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCER_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCER_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCER_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCER_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCER_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCER_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCER_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCER_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCER_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCER_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCER_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCER_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCER_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCER_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCER_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCER_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCER_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCER_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCER_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCER_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCER_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCER_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCER_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCER_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCER_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCER_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCER_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCER_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCER_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCER_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCER_PID31 = 0x80000000

	// PMC_PCDR: Peripheral Clock Disable Register
	// Position of PID2 field.
	PMC_PMC_PCDR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCDR_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCDR_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCDR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCDR_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCDR_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCDR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCDR_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCDR_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCDR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCDR_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCDR_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCDR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCDR_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCDR_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCDR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCDR_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCDR_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCDR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCDR_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCDR_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCDR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCDR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCDR_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCDR_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCDR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCDR_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCDR_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCDR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCDR_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCDR_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCDR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCDR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCDR_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCDR_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCDR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCDR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCDR_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCDR_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCDR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCDR_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCDR_PID31 = 0x80000000

	// PMC_PCSR: Peripheral Clock Status Register
	// Position of PID2 field.
	PMC_PMC_PCSR_PID2_Pos = 0x2
	// Bit mask of PID2 field.
	PMC_PMC_PCSR_PID2_Msk = 0x4
	// Bit PID2.
	PMC_PMC_PCSR_PID2 = 0x4
	// Position of PID3 field.
	PMC_PMC_PCSR_PID3_Pos = 0x3
	// Bit mask of PID3 field.
	PMC_PMC_PCSR_PID3_Msk = 0x8
	// Bit PID3.
	PMC_PMC_PCSR_PID3 = 0x8
	// Position of PID4 field.
	PMC_PMC_PCSR_PID4_Pos = 0x4
	// Bit mask of PID4 field.
	PMC_PMC_PCSR_PID4_Msk = 0x10
	// Bit PID4.
	PMC_PMC_PCSR_PID4 = 0x10
	// Position of PID5 field.
	PMC_PMC_PCSR_PID5_Pos = 0x5
	// Bit mask of PID5 field.
	PMC_PMC_PCSR_PID5_Msk = 0x20
	// Bit PID5.
	PMC_PMC_PCSR_PID5 = 0x20
	// Position of PID6 field.
	PMC_PMC_PCSR_PID6_Pos = 0x6
	// Bit mask of PID6 field.
	PMC_PMC_PCSR_PID6_Msk = 0x40
	// Bit PID6.
	PMC_PMC_PCSR_PID6 = 0x40
	// Position of PID7 field.
	PMC_PMC_PCSR_PID7_Pos = 0x7
	// Bit mask of PID7 field.
	PMC_PMC_PCSR_PID7_Msk = 0x80
	// Bit PID7.
	PMC_PMC_PCSR_PID7 = 0x80
	// Position of PID8 field.
	PMC_PMC_PCSR_PID8_Pos = 0x8
	// Bit mask of PID8 field.
	PMC_PMC_PCSR_PID8_Msk = 0x100
	// Bit PID8.
	PMC_PMC_PCSR_PID8 = 0x100
	// Position of PID9 field.
	PMC_PMC_PCSR_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR_PID15 = 0x8000
	// Position of PID16 field.
	PMC_PMC_PCSR_PID16_Pos = 0x10
	// Bit mask of PID16 field.
	PMC_PMC_PCSR_PID16_Msk = 0x10000
	// Bit PID16.
	PMC_PMC_PCSR_PID16 = 0x10000
	// Position of PID17 field.
	PMC_PMC_PCSR_PID17_Pos = 0x11
	// Bit mask of PID17 field.
	PMC_PMC_PCSR_PID17_Msk = 0x20000
	// Bit PID17.
	PMC_PMC_PCSR_PID17 = 0x20000
	// Position of PID18 field.
	PMC_PMC_PCSR_PID18_Pos = 0x12
	// Bit mask of PID18 field.
	PMC_PMC_PCSR_PID18_Msk = 0x40000
	// Bit PID18.
	PMC_PMC_PCSR_PID18 = 0x40000
	// Position of PID19 field.
	PMC_PMC_PCSR_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR_PID21 = 0x200000
	// Position of PID22 field.
	PMC_PMC_PCSR_PID22_Pos = 0x16
	// Bit mask of PID22 field.
	PMC_PMC_PCSR_PID22_Msk = 0x400000
	// Bit PID22.
	PMC_PMC_PCSR_PID22 = 0x400000
	// Position of PID23 field.
	PMC_PMC_PCSR_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCSR_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCSR_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCSR_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCSR_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCSR_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCSR_PID31 = 0x80000000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Pos = 0x0
	// Bit mask of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Msk = 0x1
	// Bit MOSCXTEN.
	PMC_CKGR_MOR_MOSCXTEN = 0x1
	// Position of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Pos = 0x1
	// Bit mask of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Msk = 0x2
	// Bit MOSCXTBY.
	PMC_CKGR_MOR_MOSCXTBY = 0x2
	// Position of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Pos = 0x3
	// Bit mask of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Msk = 0x8
	// Bit MOSCRCEN.
	PMC_CKGR_MOR_MOSCRCEN = 0x8
	// Position of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Pos = 0x8
	// Bit mask of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Msk = 0xff00
	// Position of KEY field.
	PMC_CKGR_MOR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PMC_CKGR_MOR_KEY_Msk = 0xff0000
	// Position of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Pos = 0x18
	// Bit mask of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Msk = 0x1000000
	// Bit MOSCSEL.
	PMC_CKGR_MOR_MOSCSEL = 0x1000000
	// Position of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Pos = 0x19
	// Bit mask of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Msk = 0x2000000
	// Bit CFDEN.
	PMC_CKGR_MOR_CFDEN = 0x2000000

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Pos = 0x10
	// Bit mask of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Msk = 0x10000
	// Bit MAINFRDY.
	PMC_CKGR_MCFR_MAINFRDY = 0x10000
	// Position of RCMEAS field.
	PMC_CKGR_MCFR_RCMEAS_Pos = 0x14
	// Bit mask of RCMEAS field.
	PMC_CKGR_MCFR_RCMEAS_Msk = 0x100000
	// Bit RCMEAS.
	PMC_CKGR_MCFR_RCMEAS = 0x100000

	// CKGR_PLLAR: PLLA Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Pos = 0xe
	// Bit mask of OUTA field.
	PMC_CKGR_PLLAR_OUTA_Msk = 0xc000
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0x7ff0000
	// Position of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Pos = 0x1d
	// Bit mask of STUCKTO1 field.
	PMC_CKGR_PLLAR_STUCKTO1_Msk = 0x20000000
	// Bit STUCKTO1.
	PMC_CKGR_PLLAR_STUCKTO1 = 0x20000000

	// CKGR_PLLBR: PLLB Register
	// Position of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Pos = 0x0
	// Bit mask of DIVB field.
	PMC_CKGR_PLLBR_DIVB_Msk = 0xff
	// Position of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Pos = 0x8
	// Bit mask of PLLBCOUNT field.
	PMC_CKGR_PLLBR_PLLBCOUNT_Msk = 0x3f00
	// Position of OUTB field.
	PMC_CKGR_PLLBR_OUTB_Pos = 0xe
	// Bit mask of OUTB field.
	PMC_CKGR_PLLBR_OUTB_Msk = 0xc000
	// Position of MULB field.
	PMC_CKGR_PLLBR_MULB_Pos = 0x10
	// Bit mask of MULB field.
	PMC_CKGR_PLLBR_MULB_Msk = 0x7ff0000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Slow Clock is selected
	PMC_PMC_MCKR_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_MCKR_CSS_MAIN_CLK = 0x1
	// PLLACK/PLLADIV2 is selected
	PMC_PMC_MCKR_CSS_PLLA_CLK = 0x2
	// PLLBCK is selected
	PMC_PMC_MCKR_CSS_PLLB_CLK = 0x3
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_MCKR_PRES_CLOCK_DIV1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_MCKR_PRES_CLOCK_DIV2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_MCKR_PRES_CLOCK_DIV4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_MCKR_PRES_CLOCK_DIV8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_MCKR_PRES_CLOCK_DIV16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_MCKR_PRES_CLOCK_DIV32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_MCKR_PRES_CLOCK_DIV64 = 0x6
	// Position of MDIV field.
	PMC_PMC_MCKR_MDIV_Pos = 0x8
	// Bit mask of MDIV field.
	PMC_PMC_MCKR_MDIV_Msk = 0x300
	// Master Clock is Prescaler Output Clock divided by 1.Warning: SysClk DDR and DDRCK are not available.
	PMC_PMC_MCKR_MDIV_EQ_PCK = 0x0
	// Master Clock is Prescaler Output Clock divided by 2.SysClk DDR is equal to 2 x MCK. DDRCK is equal to MCK.
	PMC_PMC_MCKR_MDIV_PCK_DIV2 = 0x1
	// Master Clock is Prescaler Output Clock divided by 4.SysClk DDR is equal to 2 x MCK. DDRCK is equal to MCK.
	PMC_PMC_MCKR_MDIV_PCK_DIV4 = 0x2
	// Master Clock is Prescaler Output Clock divided by 3.SysClk DDR is equal to 2 x MCK. DDRCK is equal to MCK.
	PMC_PMC_MCKR_MDIV_PCK_DIV3 = 0x3
	// Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc
	// Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000
	// Bit PLLADIV2.
	PMC_PMC_MCKR_PLLADIV2 = 0x1000
	// PLLA clock frequency is divided by 1.
	PMC_PMC_MCKR_PLLADIV2_NOT_DIV2 = 0x0
	// PLLA clock frequency is divided by 2.
	PMC_PMC_MCKR_PLLADIV2_DIV2 = 0x1

	// PMC_USB: USB Clock Register
	// Position of USBS field.
	PMC_PMC_USB_USBS_Pos = 0x0
	// Bit mask of USBS field.
	PMC_PMC_USB_USBS_Msk = 0x1
	// Bit USBS.
	PMC_PMC_USB_USBS = 0x1
	// Position of USBDIV field.
	PMC_PMC_USB_USBDIV_Pos = 0x8
	// Bit mask of USBDIV field.
	PMC_PMC_USB_USBDIV_Msk = 0xf00

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x7
	// Slow Clock is selected
	PMC_PMC_PCK_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_PCK_CSS_MAIN_CLK = 0x1
	// PLLACK/PLLADIV2 is selected
	PMC_PMC_PCK_CSS_PLLA_CLK = 0x2
	// PLLBCK is selected
	PMC_PMC_PCK_CSS_PLLB_CLK = 0x3
	// Master Clock is selected
	PMC_PMC_PCK_CSS_MCK_CLK = 0x4
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_PCK_PRES_CLOCK_DIV1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_PCK_PRES_CLOCK_DIV2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_PCK_PRES_CLOCK_DIV4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_PCK_PRES_CLOCK_DIV8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_PCK_PRES_CLOCK_DIV16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_PCK_PRES_CLOCK_DIV32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_PCK_PRES_CLOCK_DIV64 = 0x6

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IER_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IER_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IER_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IER_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200
	// Position of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IER_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IER_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IER_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IER_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IER_CFDEV = 0x40000

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IDR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IDR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IDR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IDR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200
	// Position of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IDR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IDR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IDR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IDR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IDR_CFDEV = 0x40000

	// PMC_SR: Status Register
	// Position of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_SR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_SR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_SR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_SR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Pos = 0x7
	// Bit mask of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Msk = 0x80
	// Bit OSCSELS.
	PMC_PMC_SR_OSCSELS = 0x80
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200
	// Position of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_SR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_SR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_SR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_SR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_SR_CFDEV = 0x40000
	// Position of CFDS field.
	PMC_PMC_SR_CFDS_Pos = 0x13
	// Bit mask of CFDS field.
	PMC_PMC_SR_CFDS_Msk = 0x80000
	// Bit CFDS.
	PMC_PMC_SR_CFDS = 0x80000
	// Position of FOS field.
	PMC_PMC_SR_FOS_Pos = 0x14
	// Bit mask of FOS field.
	PMC_PMC_SR_FOS_Msk = 0x100000
	// Bit FOS.
	PMC_PMC_SR_FOS = 0x100000

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IMR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of LOCKB field.
	PMC_PMC_IMR_LOCKB_Pos = 0x2
	// Bit mask of LOCKB field.
	PMC_PMC_IMR_LOCKB_Msk = 0x4
	// Bit LOCKB.
	PMC_PMC_IMR_LOCKB = 0x4
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200
	// Position of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IMR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IMR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IMR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IMR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IMR_CFDEV = 0x40000

	// PMC_PLLICPR: PLL Charge Pump Current Register
	// Position of ICPLLA field.
	PMC_PMC_PLLICPR_ICPLLA_Pos = 0x0
	// Bit mask of ICPLLA field.
	PMC_PMC_PLLICPR_ICPLLA_Msk = 0x1
	// Bit ICPLLA.
	PMC_PMC_PLLICPR_ICPLLA = 0x1

	// PMC_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PMC_PMC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PMC_PMC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PMC_PMC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Msk = 0xffffff00

	// PMC_WPSR: Write Protect Status Register
	// Position of WPVS field.
	PMC_PMC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PMC_PMC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PMC_PMC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Msk = 0xffff00

	// PMC_PCR: Peripheral Control Register
	// Position of PID field.
	PMC_PMC_PCR_PID_Pos = 0x0
	// Bit mask of PID field.
	PMC_PMC_PCR_PID_Msk = 0x3f
	// Position of CMD field.
	PMC_PMC_PCR_CMD_Pos = 0xc
	// Bit mask of CMD field.
	PMC_PMC_PCR_CMD_Msk = 0x1000
	// Bit CMD.
	PMC_PMC_PCR_CMD = 0x1000
	// Position of DIV field.
	PMC_PMC_PCR_DIV_Pos = 0x10
	// Bit mask of DIV field.
	PMC_PMC_PCR_DIV_Msk = 0x30000
	// Peripheral clock is MCK
	PMC_PMC_PCR_DIV_PERIPH_DIV_MCK = 0x0
	// Peripheral clock is MCK/2
	PMC_PMC_PCR_DIV_PERIPH_DIV2_MCK = 0x1
	// Peripheral clock is MCK/4
	PMC_PMC_PCR_DIV_PERIPH_DIV4_MCK = 0x2
	// Peripheral clock is MCK/8
	PMC_PMC_PCR_DIV_PERIPH_DIV8_MCK = 0x3
	// Position of EN field.
	PMC_PMC_PCR_EN_Pos = 0x1c
	// Bit mask of EN field.
	PMC_PMC_PCR_EN_Msk = 0x10000000
	// Bit EN.
	PMC_PMC_PCR_EN = 0x10000000
)

// Bitfields for RSTC: Reset Controller
const (
	// CR: Control Register
	// Position of PROCRST field.
	SYSC_CR_PROCRST_Pos = 0x0
	// Bit mask of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1
	// Bit PROCRST.
	SYSC_CR_PROCRST = 0x1
	// Position of PERRST field.
	SYSC_CR_PERRST_Pos = 0x2
	// Bit mask of PERRST field.
	SYSC_CR_PERRST_Msk = 0x4
	// Bit PERRST.
	SYSC_CR_PERRST = 0x4
	// Position of EXTRST field.
	SYSC_CR_EXTRST_Pos = 0x3
	// Bit mask of EXTRST field.
	SYSC_CR_EXTRST_Msk = 0x8
	// Bit EXTRST.
	SYSC_CR_EXTRST = 0x8
	// Position of KEY field.
	SYSC_CR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_CR_KEY_Msk = 0xff000000

	// SR: Status Register
	// Position of URSTS field.
	SYSC_SR_URSTS_Pos = 0x0
	// Bit mask of URSTS field.
	SYSC_SR_URSTS_Msk = 0x1
	// Bit URSTS.
	SYSC_SR_URSTS = 0x1
	// Position of RSTTYP field.
	SYSC_SR_RSTTYP_Pos = 0x8
	// Bit mask of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700
	// Position of NRSTL field.
	SYSC_SR_NRSTL_Pos = 0x10
	// Bit mask of NRSTL field.
	SYSC_SR_NRSTL_Msk = 0x10000
	// Bit NRSTL.
	SYSC_SR_NRSTL = 0x10000
	// Position of SRCMP field.
	SYSC_SR_SRCMP_Pos = 0x11
	// Bit mask of SRCMP field.
	SYSC_SR_SRCMP_Msk = 0x20000
	// Bit SRCMP.
	SYSC_SR_SRCMP = 0x20000

	// MR: Mode Register
	// Position of ERSTL field.
	SYSC_MR_ERSTL_Pos = 0x8
	// Bit mask of ERSTL field.
	SYSC_MR_ERSTL_Msk = 0xf00
	// Position of KEY field.
	SYSC_MR_KEY_Pos = 0x18
	// Bit mask of KEY field.
	SYSC_MR_KEY_Msk = 0xff000000
)

// Bitfields for RTC: Real-time Clock
const (
	// CR: Control Register
	// Position of UPDTIM field.
	RTC_CR_UPDTIM_Pos = 0x0
	// Bit mask of UPDTIM field.
	RTC_CR_UPDTIM_Msk = 0x1
	// Bit UPDTIM.
	RTC_CR_UPDTIM = 0x1
	// Position of UPDCAL field.
	RTC_CR_UPDCAL_Pos = 0x1
	// Bit mask of UPDCAL field.
	RTC_CR_UPDCAL_Msk = 0x2
	// Bit UPDCAL.
	RTC_CR_UPDCAL = 0x2
	// Position of TIMEVSEL field.
	RTC_CR_TIMEVSEL_Pos = 0x8
	// Bit mask of TIMEVSEL field.
	RTC_CR_TIMEVSEL_Msk = 0x300
	// Minute change
	RTC_CR_TIMEVSEL_MINUTE = 0x0
	// Hour change
	RTC_CR_TIMEVSEL_HOUR = 0x1
	// Every day at midnight
	RTC_CR_TIMEVSEL_MIDNIGHT = 0x2
	// Every day at noon
	RTC_CR_TIMEVSEL_NOON = 0x3
	// Position of CALEVSEL field.
	RTC_CR_CALEVSEL_Pos = 0x10
	// Bit mask of CALEVSEL field.
	RTC_CR_CALEVSEL_Msk = 0x30000
	// Week change (every Monday at time 00:00:00)
	RTC_CR_CALEVSEL_WEEK = 0x0
	// Month change (every 01 of each month at time 00:00:00)
	RTC_CR_CALEVSEL_MONTH = 0x1
	// Year change (every January 1 at time 00:00:00)
	RTC_CR_CALEVSEL_YEAR = 0x2

	// MR: Mode Register
	// Position of HRMOD field.
	RTC_MR_HRMOD_Pos = 0x0
	// Bit mask of HRMOD field.
	RTC_MR_HRMOD_Msk = 0x1
	// Bit HRMOD.
	RTC_MR_HRMOD = 0x1

	// TIMR: Time Register
	// Position of SEC field.
	RTC_TIMR_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_TIMR_SEC_Msk = 0x7f
	// Position of MIN field.
	RTC_TIMR_MIN_Pos = 0x8
	// Bit mask of MIN field.
	RTC_TIMR_MIN_Msk = 0x7f00
	// Position of HOUR field.
	RTC_TIMR_HOUR_Pos = 0x10
	// Bit mask of HOUR field.
	RTC_TIMR_HOUR_Msk = 0x3f0000
	// Position of AMPM field.
	RTC_TIMR_AMPM_Pos = 0x16
	// Bit mask of AMPM field.
	RTC_TIMR_AMPM_Msk = 0x400000
	// Bit AMPM.
	RTC_TIMR_AMPM = 0x400000

	// CALR: Calendar Register
	// Position of CENT field.
	RTC_CALR_CENT_Pos = 0x0
	// Bit mask of CENT field.
	RTC_CALR_CENT_Msk = 0x7f
	// Position of YEAR field.
	RTC_CALR_YEAR_Pos = 0x8
	// Bit mask of YEAR field.
	RTC_CALR_YEAR_Msk = 0xff00
	// Position of MONTH field.
	RTC_CALR_MONTH_Pos = 0x10
	// Bit mask of MONTH field.
	RTC_CALR_MONTH_Msk = 0x1f0000
	// Position of DAY field.
	RTC_CALR_DAY_Pos = 0x15
	// Bit mask of DAY field.
	RTC_CALR_DAY_Msk = 0xe00000
	// Position of DATE field.
	RTC_CALR_DATE_Pos = 0x18
	// Bit mask of DATE field.
	RTC_CALR_DATE_Msk = 0x3f000000

	// TIMALR: Time Alarm Register
	// Position of SEC field.
	RTC_TIMALR_SEC_Pos = 0x0
	// Bit mask of SEC field.
	RTC_TIMALR_SEC_Msk = 0x7f
	// Position of SECEN field.
	RTC_TIMALR_SECEN_Pos = 0x7
	// Bit mask of SECEN field.
	RTC_TIMALR_SECEN_Msk = 0x80
	// Bit SECEN.
	RTC_TIMALR_SECEN = 0x80
	// Position of MIN field.
	RTC_TIMALR_MIN_Pos = 0x8
	// Bit mask of MIN field.
	RTC_TIMALR_MIN_Msk = 0x7f00
	// Position of MINEN field.
	RTC_TIMALR_MINEN_Pos = 0xf
	// Bit mask of MINEN field.
	RTC_TIMALR_MINEN_Msk = 0x8000
	// Bit MINEN.
	RTC_TIMALR_MINEN = 0x8000
	// Position of HOUR field.
	RTC_TIMALR_HOUR_Pos = 0x10
	// Bit mask of HOUR field.
	RTC_TIMALR_HOUR_Msk = 0x3f0000
	// Position of AMPM field.
	RTC_TIMALR_AMPM_Pos = 0x16
	// Bit mask of AMPM field.
	RTC_TIMALR_AMPM_Msk = 0x400000
	// Bit AMPM.
	RTC_TIMALR_AMPM = 0x400000
	// Position of HOUREN field.
	RTC_TIMALR_HOUREN_Pos = 0x17
	// Bit mask of HOUREN field.
	RTC_TIMALR_HOUREN_Msk = 0x800000
	// Bit HOUREN.
	RTC_TIMALR_HOUREN = 0x800000

	// CALALR: Calendar Alarm Register
	// Position of MONTH field.
	RTC_CALALR_MONTH_Pos = 0x10
	// Bit mask of MONTH field.
	RTC_CALALR_MONTH_Msk = 0x1f0000
	// Position of MTHEN field.
	RTC_CALALR_MTHEN_Pos = 0x17
	// Bit mask of MTHEN field.
	RTC_CALALR_MTHEN_Msk = 0x800000
	// Bit MTHEN.
	RTC_CALALR_MTHEN = 0x800000
	// Position of DATE field.
	RTC_CALALR_DATE_Pos = 0x18
	// Bit mask of DATE field.
	RTC_CALALR_DATE_Msk = 0x3f000000
	// Position of DATEEN field.
	RTC_CALALR_DATEEN_Pos = 0x1f
	// Bit mask of DATEEN field.
	RTC_CALALR_DATEEN_Msk = 0x80000000
	// Bit DATEEN.
	RTC_CALALR_DATEEN = 0x80000000

	// SR: Status Register
	// Position of ACKUPD field.
	RTC_SR_ACKUPD_Pos = 0x0
	// Bit mask of ACKUPD field.
	RTC_SR_ACKUPD_Msk = 0x1
	// Bit ACKUPD.
	RTC_SR_ACKUPD = 0x1
	// Position of ALARM field.
	RTC_SR_ALARM_Pos = 0x1
	// Bit mask of ALARM field.
	RTC_SR_ALARM_Msk = 0x2
	// Bit ALARM.
	RTC_SR_ALARM = 0x2
	// Position of SEC field.
	RTC_SR_SEC_Pos = 0x2
	// Bit mask of SEC field.
	RTC_SR_SEC_Msk = 0x4
	// Bit SEC.
	RTC_SR_SEC = 0x4
	// Position of TIMEV field.
	RTC_SR_TIMEV_Pos = 0x3
	// Bit mask of TIMEV field.
	RTC_SR_TIMEV_Msk = 0x8
	// Bit TIMEV.
	RTC_SR_TIMEV = 0x8
	// Position of CALEV field.
	RTC_SR_CALEV_Pos = 0x4
	// Bit mask of CALEV field.
	RTC_SR_CALEV_Msk = 0x10
	// Bit CALEV.
	RTC_SR_CALEV = 0x10

	// SCCR: Status Clear Command Register
	// Position of ACKCLR field.
	RTC_SCCR_ACKCLR_Pos = 0x0
	// Bit mask of ACKCLR field.
	RTC_SCCR_ACKCLR_Msk = 0x1
	// Bit ACKCLR.
	RTC_SCCR_ACKCLR = 0x1
	// Position of ALRCLR field.
	RTC_SCCR_ALRCLR_Pos = 0x1
	// Bit mask of ALRCLR field.
	RTC_SCCR_ALRCLR_Msk = 0x2
	// Bit ALRCLR.
	RTC_SCCR_ALRCLR = 0x2
	// Position of SECCLR field.
	RTC_SCCR_SECCLR_Pos = 0x2
	// Bit mask of SECCLR field.
	RTC_SCCR_SECCLR_Msk = 0x4
	// Bit SECCLR.
	RTC_SCCR_SECCLR = 0x4
	// Position of TIMCLR field.
	RTC_SCCR_TIMCLR_Pos = 0x3
	// Bit mask of TIMCLR field.
	RTC_SCCR_TIMCLR_Msk = 0x8
	// Bit TIMCLR.
	RTC_SCCR_TIMCLR = 0x8
	// Position of CALCLR field.
	RTC_SCCR_CALCLR_Pos = 0x4
	// Bit mask of CALCLR field.
	RTC_SCCR_CALCLR_Msk = 0x10
	// Bit CALCLR.
	RTC_SCCR_CALCLR = 0x10

	// IER: Interrupt Enable Register
	// Position of ACKEN field.
	RTC_IER_ACKEN_Pos = 0x0
	// Bit mask of ACKEN field.
	RTC_IER_ACKEN_Msk = 0x1
	// Bit ACKEN.
	RTC_IER_ACKEN = 0x1
	// Position of ALREN field.
	RTC_IER_ALREN_Pos = 0x1
	// Bit mask of ALREN field.
	RTC_IER_ALREN_Msk = 0x2
	// Bit ALREN.
	RTC_IER_ALREN = 0x2
	// Position of SECEN field.
	RTC_IER_SECEN_Pos = 0x2
	// Bit mask of SECEN field.
	RTC_IER_SECEN_Msk = 0x4
	// Bit SECEN.
	RTC_IER_SECEN = 0x4
	// Position of TIMEN field.
	RTC_IER_TIMEN_Pos = 0x3
	// Bit mask of TIMEN field.
	RTC_IER_TIMEN_Msk = 0x8
	// Bit TIMEN.
	RTC_IER_TIMEN = 0x8
	// Position of CALEN field.
	RTC_IER_CALEN_Pos = 0x4
	// Bit mask of CALEN field.
	RTC_IER_CALEN_Msk = 0x10
	// Bit CALEN.
	RTC_IER_CALEN = 0x10

	// IDR: Interrupt Disable Register
	// Position of ACKDIS field.
	RTC_IDR_ACKDIS_Pos = 0x0
	// Bit mask of ACKDIS field.
	RTC_IDR_ACKDIS_Msk = 0x1
	// Bit ACKDIS.
	RTC_IDR_ACKDIS = 0x1
	// Position of ALRDIS field.
	RTC_IDR_ALRDIS_Pos = 0x1
	// Bit mask of ALRDIS field.
	RTC_IDR_ALRDIS_Msk = 0x2
	// Bit ALRDIS.
	RTC_IDR_ALRDIS = 0x2
	// Position of SECDIS field.
	RTC_IDR_SECDIS_Pos = 0x2
	// Bit mask of SECDIS field.
	RTC_IDR_SECDIS_Msk = 0x4
	// Bit SECDIS.
	RTC_IDR_SECDIS = 0x4
	// Position of TIMDIS field.
	RTC_IDR_TIMDIS_Pos = 0x3
	// Bit mask of TIMDIS field.
	RTC_IDR_TIMDIS_Msk = 0x8
	// Bit TIMDIS.
	RTC_IDR_TIMDIS = 0x8
	// Position of CALDIS field.
	RTC_IDR_CALDIS_Pos = 0x4
	// Bit mask of CALDIS field.
	RTC_IDR_CALDIS_Msk = 0x10
	// Bit CALDIS.
	RTC_IDR_CALDIS = 0x10

	// IMR: Interrupt Mask Register
	// Position of ACK field.
	RTC_IMR_ACK_Pos = 0x0
	// Bit mask of ACK field.
	RTC_IMR_ACK_Msk = 0x1
	// Bit ACK.
	RTC_IMR_ACK = 0x1
	// Position of ALR field.
	RTC_IMR_ALR_Pos = 0x1
	// Bit mask of ALR field.
	RTC_IMR_ALR_Msk = 0x2
	// Bit ALR.
	RTC_IMR_ALR = 0x2
	// Position of SEC field.
	RTC_IMR_SEC_Pos = 0x2
	// Bit mask of SEC field.
	RTC_IMR_SEC_Msk = 0x4
	// Bit SEC.
	RTC_IMR_SEC = 0x4
	// Position of TIM field.
	RTC_IMR_TIM_Pos = 0x3
	// Bit mask of TIM field.
	RTC_IMR_TIM_Msk = 0x8
	// Bit TIM.
	RTC_IMR_TIM = 0x8
	// Position of CAL field.
	RTC_IMR_CAL_Pos = 0x4
	// Bit mask of CAL field.
	RTC_IMR_CAL_Msk = 0x10
	// Bit CAL.
	RTC_IMR_CAL = 0x10

	// VER: Valid Entry Register
	// Position of NVTIM field.
	RTC_VER_NVTIM_Pos = 0x0
	// Bit mask of NVTIM field.
	RTC_VER_NVTIM_Msk = 0x1
	// Bit NVTIM.
	RTC_VER_NVTIM = 0x1
	// Position of NVCAL field.
	RTC_VER_NVCAL_Pos = 0x1
	// Bit mask of NVCAL field.
	RTC_VER_NVCAL_Msk = 0x2
	// Bit NVCAL.
	RTC_VER_NVCAL = 0x2
	// Position of NVTIMALR field.
	RTC_VER_NVTIMALR_Pos = 0x2
	// Bit mask of NVTIMALR field.
	RTC_VER_NVTIMALR_Msk = 0x4
	// Bit NVTIMALR.
	RTC_VER_NVTIMALR = 0x4
	// Position of NVCALALR field.
	RTC_VER_NVCALALR_Pos = 0x3
	// Bit mask of NVCALALR field.
	RTC_VER_NVCALALR_Msk = 0x8
	// Bit NVCALALR.
	RTC_VER_NVCALALR = 0x8
)
