/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.mail.Flags;

class IMAPFlags
extends Flags {
    Flags saved;

    IMAPFlags() {
    }

    void checkpoint() {
        this.saved = new Flags((Flags)this);
    }

    List getAddedFlags() {
        if (this.saved == null) {
            return Collections.EMPTY_LIST;
        }
        List current = IMAPFlags.getIMAPFlags(this);
        List original = IMAPFlags.getIMAPFlags(this.saved);
        current.removeAll(original);
        return current;
    }

    List getRemovedFlags() {
        if (this.saved == null) {
            return Collections.EMPTY_LIST;
        }
        List current = IMAPFlags.getIMAPFlags(this);
        List original = IMAPFlags.getIMAPFlags(this.saved);
        original.removeAll(current);
        return original;
    }

    static List getIMAPFlags(Flags flags) {
        Flags.Flag[] sflags = flags.getSystemFlags();
        String[] uflags = flags.getUserFlags();
        ArrayList<String> iflags = new ArrayList<String>(sflags.length + uflags.length);
        for (int i = 0; i < sflags.length; ++i) {
            Flags.Flag f = sflags[i];
            if (f == Flags.Flag.ANSWERED) {
                iflags.add("\\Answered");
                continue;
            }
            if (f == Flags.Flag.DELETED) {
                iflags.add("\\Deleted");
                continue;
            }
            if (f == Flags.Flag.DRAFT) {
                iflags.add("\\Draft");
                continue;
            }
            if (f == Flags.Flag.FLAGGED) {
                iflags.add("\\Flagged");
                continue;
            }
            if (f != Flags.Flag.SEEN) continue;
            iflags.add("\\Seen");
        }
        iflags.addAll(Arrays.asList(uflags));
        return iflags;
    }
}

