/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.CompressionConfig;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http2Protocol
implements UpgradeProtocol {
    private static final Log log = LogFactory.getLog(Http2Protocol.class);
    private static final StringManager sm = StringManager.getManager(Http2Protocol.class);
    static final long DEFAULT_READ_TIMEOUT = 5000L;
    static final long DEFAULT_WRITE_TIMEOUT = 5000L;
    static final long DEFAULT_KEEP_ALIVE_TIMEOUT = 20000L;
    static final long DEFAULT_STREAM_READ_TIMEOUT = 20000L;
    static final long DEFAULT_STREAM_WRITE_TIMEOUT = 20000L;
    static final long DEFAULT_MAX_CONCURRENT_STREAMS = 100L;
    static final int DEFAULT_MAX_CONCURRENT_STREAM_EXECUTION = 20;
    static final int DEFAULT_OVERHEAD_COUNT_FACTOR = 1;
    static final int DEFAULT_OVERHEAD_CONTINUATION_THRESHOLD = 1024;
    static final int DEFAULT_OVERHEAD_DATA_THRESHOLD = 1024;
    static final int DEFAULT_OVERHEAD_WINDOW_UPDATE_THRESHOLD = 1024;
    private static final String HTTP_UPGRADE_NAME = "h2c";
    private static final String ALPN_NAME = "h2";
    private static final byte[] ALPN_IDENTIFIER = "h2".getBytes(StandardCharsets.UTF_8);
    private long readTimeout = 5000L;
    private long writeTimeout = 5000L;
    private long keepAliveTimeout = 20000L;
    private long streamReadTimeout = 20000L;
    private long streamWriteTimeout = 20000L;
    private long maxConcurrentStreams = 100L;
    private int maxConcurrentStreamExecution = 20;
    private int initialWindowSize = 65535;
    private Set<String> allowedTrailerHeaders = Collections.newSetFromMap(new ConcurrentHashMap());
    private int maxHeaderCount = 100;
    private int maxHeaderSize = 8192;
    private int maxTrailerCount = 100;
    private int maxTrailerSize = 8192;
    private int overheadCountFactor = 1;
    private int overheadContinuationThreshold = 1024;
    private int overheadDataThreshold = 1024;
    private int overheadWindowUpdateThreshold = 1024;
    private boolean initiatePingDisabled = false;
    private final CompressionConfig compressionConfig = new CompressionConfig();
    private AbstractHttp11Protocol<?> http11Protocol = null;
    private RequestGroupInfo global = new RequestGroupInfo();

    @Override
    public String getHttpUpgradeName(boolean bl) {
        if (bl) {
            return null;
        }
        return HTTP_UPGRADE_NAME;
    }

    @Override
    public byte[] getAlpnIdentifier() {
        return ALPN_IDENTIFIER;
    }

    @Override
    public String getAlpnName() {
        return ALPN_NAME;
    }

    @Override
    public Processor getProcessor(SocketWrapperBase<?> socketWrapperBase, Adapter adapter) {
        String string = this.getUpgradeProtocolName();
        UpgradeProcessorInternal upgradeProcessorInternal = new UpgradeProcessorInternal(socketWrapperBase, new UpgradeToken(this.getInternalUpgradeHandler(adapter, null), null, null, string), null);
        return upgradeProcessorInternal;
    }

    @Override
    public InternalHttpUpgradeHandler getInternalUpgradeHandler(Adapter adapter, Request request) {
        Http2UpgradeHandler http2UpgradeHandler = new Http2UpgradeHandler(this, adapter, request);
        http2UpgradeHandler.setReadTimeout(this.getReadTimeout());
        http2UpgradeHandler.setKeepAliveTimeout(this.getKeepAliveTimeout());
        http2UpgradeHandler.setWriteTimeout(this.getWriteTimeout());
        http2UpgradeHandler.setMaxConcurrentStreams(this.getMaxConcurrentStreams());
        http2UpgradeHandler.setMaxConcurrentStreamExecution(this.getMaxConcurrentStreamExecution());
        http2UpgradeHandler.setInitialWindowSize(this.getInitialWindowSize());
        http2UpgradeHandler.setAllowedTrailerHeaders(this.allowedTrailerHeaders);
        http2UpgradeHandler.setMaxHeaderCount(this.getMaxHeaderCount());
        http2UpgradeHandler.setMaxHeaderSize(this.getMaxHeaderSize());
        http2UpgradeHandler.setMaxTrailerCount(this.getMaxTrailerCount());
        http2UpgradeHandler.setMaxTrailerSize(this.getMaxTrailerSize());
        http2UpgradeHandler.setInitiatePingDisabled(this.initiatePingDisabled);
        return http2UpgradeHandler;
    }

    @Override
    public boolean accept(Request request) {
        Enumeration<String> enumeration = request.getMimeHeaders().values("HTTP2-Settings");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        if (n != 1) {
            return false;
        }
        Enumeration<String> enumeration2 = request.getMimeHeaders().values("Connection");
        boolean bl = false;
        while (enumeration2.hasMoreElements() && !bl) {
            bl = enumeration2.nextElement().contains("HTTP2-Settings");
        }
        return bl;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long l) {
        this.readTimeout = l;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long l) {
        this.writeTimeout = l;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long l) {
        this.keepAliveTimeout = l;
    }

    public long getStreamReadTimeout() {
        return this.streamReadTimeout;
    }

    public void setStreamReadTimeout(long l) {
        this.streamReadTimeout = l;
    }

    public long getStreamWriteTimeout() {
        return this.streamWriteTimeout;
    }

    public void setStreamWriteTimeout(long l) {
        this.streamWriteTimeout = l;
    }

    public long getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(long l) {
        this.maxConcurrentStreams = l;
    }

    public int getMaxConcurrentStreamExecution() {
        return this.maxConcurrentStreamExecution;
    }

    public void setMaxConcurrentStreamExecution(int n) {
        this.maxConcurrentStreamExecution = n;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int n) {
        this.initialWindowSize = n;
    }

    public void setAllowedTrailerHeaders(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.allowedTrailerHeaders);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                String string3 = string2.trim().toLowerCase(Locale.ENGLISH);
                if (hashSet.contains(string3)) {
                    hashSet.remove(string3);
                    continue;
                }
                this.allowedTrailerHeaders.add(string3);
            }
            this.allowedTrailerHeaders.removeAll(hashSet);
        }
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>(this.allowedTrailerHeaders.size());
        arrayList.addAll(this.allowedTrailerHeaders);
        return StringUtils.join(arrayList);
    }

    public void setMaxHeaderCount(int n) {
        this.maxHeaderCount = n;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderSize(int n) {
        this.maxHeaderSize = n;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public void setMaxTrailerCount(int n) {
        this.maxTrailerCount = n;
    }

    public int getMaxTrailerCount() {
        return this.maxTrailerCount;
    }

    public void setMaxTrailerSize(int n) {
        this.maxTrailerSize = n;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public int getOverheadCountFactor() {
        return this.overheadCountFactor;
    }

    public void setOverheadCountFactor(int n) {
        this.overheadCountFactor = n;
    }

    public int getOverheadContinuationThreshold() {
        return this.overheadContinuationThreshold;
    }

    public void setOverheadContinuationThreshold(int n) {
        this.overheadContinuationThreshold = n;
    }

    public int getOverheadDataThreshold() {
        return this.overheadDataThreshold;
    }

    public void setOverheadDataThreshold(int n) {
        this.overheadDataThreshold = n;
    }

    public int getOverheadWindowUpdateThreshold() {
        return this.overheadWindowUpdateThreshold;
    }

    public void setOverheadWindowUpdateThreshold(int n) {
        this.overheadWindowUpdateThreshold = n;
    }

    public void setInitiatePingDisabled(boolean bl) {
        this.initiatePingDisabled = bl;
    }

    public void setCompression(String string) {
        this.compressionConfig.setCompression(string);
    }

    public String getCompression() {
        return this.compressionConfig.getCompression();
    }

    protected int getCompressionLevel() {
        return this.compressionConfig.getCompressionLevel();
    }

    public String getNoCompressionUserAgents() {
        return this.compressionConfig.getNoCompressionUserAgents();
    }

    protected Pattern getNoCompressionUserAgentsPattern() {
        return this.compressionConfig.getNoCompressionUserAgentsPattern();
    }

    public void setNoCompressionUserAgents(String string) {
        this.compressionConfig.setNoCompressionUserAgents(string);
    }

    public String getCompressibleMimeType() {
        return this.compressionConfig.getCompressibleMimeType();
    }

    public void setCompressibleMimeType(String string) {
        this.compressionConfig.setCompressibleMimeType(string);
    }

    public String[] getCompressibleMimeTypes() {
        return this.compressionConfig.getCompressibleMimeTypes();
    }

    public int getCompressionMinSize() {
        return this.compressionConfig.getCompressionMinSize();
    }

    public void setCompressionMinSize(int n) {
        this.compressionConfig.setCompressionMinSize(n);
    }

    @Deprecated
    public boolean getNoCompressionStrongETag() {
        return this.compressionConfig.getNoCompressionStrongETag();
    }

    @Deprecated
    public void setNoCompressionStrongETag(boolean bl) {
        this.compressionConfig.setNoCompressionStrongETag(bl);
    }

    public boolean useCompression(Request request, Response response) {
        return this.compressionConfig.useCompression(request, response);
    }

    public ContinueResponseTiming getContinueResponseTimingInternal() {
        return this.http11Protocol.getContinueResponseTimingInternal();
    }

    public AbstractHttp11Protocol<?> getHttp11Protocol() {
        return this.http11Protocol;
    }

    public void setHttp11Protocol(AbstractHttp11Protocol<?> abstractHttp11Protocol) {
        this.http11Protocol = abstractHttp11Protocol;
        try {
            ObjectName objectName = this.http11Protocol.getONameForUpgrade(this.getUpgradeProtocolName());
            if (objectName != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this.global, objectName, null);
            }
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("http2Protocol.jmxRegistration.fail"), (Throwable)exception);
        }
    }

    public String getUpgradeProtocolName() {
        if (this.http11Protocol.isSSLEnabled()) {
            return ALPN_NAME;
        }
        return HTTP_UPGRADE_NAME;
    }

    public RequestGroupInfo getGlobal() {
        return this.global;
    }
}

