/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.Action;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Note;
import net.sf.sdedit.drawable.Rectangle;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.ui.impl.DiagramInteraction;
import net.sf.sdedit.ui.impl.DiagramTextTab;

public class DiagramTextInteraction
extends DiagramInteraction {
    private DiagramTextTab tab;

    public DiagramTextInteraction(DiagramTextTab tab) {
        this.tab = tab;
    }

    @Override
    protected List<Action> _getContextActions(Drawable drawable) {
        return null;
    }

    @Override
    protected void _mouseClickedDrawable(MouseEvent ev, Drawable drawable) {
        Note note;
        URI link;
        Integer pos;
        Diagram diag = this.tab.getDiagram();
        if (diag != null && (pos = (Integer)diag.getStateForDrawable(drawable)) != null) {
            this.tab.moveCursorToPosition(pos);
        }
        if (drawable instanceof Note && (link = (note = (Note)drawable).getLink()) != null) {
            File linked;
            File current = this.tab.getFile();
            if (link.isAbsolute()) {
                linked = new File(link);
            } else if (current != null) {
                linked = new File(current.toURI().resolve(link));
            } else {
                return;
            }
            if (!this.tab.get_UI().selectTabWith(linked)) {
                try {
                    Editor.getEditor().load(linked.toURI().toURL());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.tab.get_UI().errorMessage(e, null, null);
                }
            }
        }
    }

    @Override
    protected boolean _mouseEnteredDrawable(Drawable drawable) {
        Diagram diag = this.tab.getDiagram();
        return diag != null && diag.getStateForDrawable(drawable) != null;
    }

    @Override
    protected boolean _mouseExitedDrawable(Drawable drawable) {
        return false;
    }

    @Override
    public String getTooltip(Drawable drawable) {
        String text = null;
        if (drawable instanceof ExtensibleDrawable) {
            ExtensibleDrawable ed = (ExtensibleDrawable)drawable;
            Lifeline lifeline = ed.getLifeline();
            text = lifeline.toString();
            if (text.startsWith("/")) {
                text = text.substring(1);
            }
            if (lifeline.getDiagram().getConfiguration().isThreaded() && !lifeline.isAlwaysActive() && ed instanceof Rectangle) {
                text = text + " [thread=" + lifeline.getThread() + "]";
            }
        }
        return text;
    }
}

