/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.profiler.global.CommonConstants;

public class Platform
implements CommonConstants {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_VMS = 8192;
    public static final int OS_WIN_OTHER = 16384;
    public static final int OS_OTHER = 65536;
    public static final int OS_WINDOWS_MASK = 20487;
    public static final int OS_UNIX_MASK = 3064;
    private static int operatingSystem = -1;
    private static String jdkDenoteString;
    private static int jdkVersion;
    private static int sysArch;

    public static String getAgentNativeLibFullName(String string, boolean bl, String string2, int n) {
        String string3;
        boolean bl2;
        if (string2 == null) {
            string2 = Platform.getJDKVersionString();
        }
        if (n == -1) {
            n = Platform.getSystemArchitecture();
        }
        boolean bl3 = bl2 = n == 64;
        if (string2.equals("jdk17") || string2.equals("jdk18") || string2.equals("jdk19") || string2.equals("jdk100") || string2.equals("jdk110") || string2.equals("jdk120") || string2.equals("jdk130")) {
            string2 = "jdk16";
        }
        String string4 = "";
        if (!Platform.isWindows()) {
            string4 = "lib";
        }
        String string5 = "";
        string5 = Platform.isWindows() ? ".dll" : (Platform.isMac() ? ".jnilib" : (Platform.isHpux() ? ".sl" : ".so"));
        String string6 = "/";
        if (!bl) {
            string3 = Platform.isWindows() ? "windows" : (Platform.isMac() ? "mac" : (Platform.isLinux() ? "linux" : (Platform.isHpux() ? "hpux" : "solaris")));
            String string7 = null;
            if (bl2) {
                if (Platform.isLinux() || Platform.isWindows() || Platform.isSolarisIntel()) {
                    string7 = "amd64";
                } else if (Platform.isSolarisSparc()) {
                    string7 = "sparcv9";
                } else if (Platform.isHpux()) {
                    string7 = "pa_risc2.0w";
                }
            } else if (Platform.isSolarisIntel()) {
                string7 = "i386";
            } else if (Platform.isSolarisSparc()) {
                string7 = "sparc";
            } else if (Platform.isHpux()) {
                string7 = "pa_risc2.0";
            } else if (Platform.isLinuxArm()) {
                string7 = Platform.isLinuxArmVfpHflt() ? "arm-vfp-hflt" : "arm";
            }
            if (string7 != null) {
                string3 = string3 + "-" + string7;
            }
            string6 = "/deployed/" + string2 + "/" + string3 + "/";
        }
        string3 = string;
        if (string.startsWith("\"")) {
            string3 = string.substring(1, string.length() - 1);
        }
        string3 = string3.replace('\\', '/');
        return string3 + string6 + string4 + "profilerinterface" + string5;
    }

    public static int getJDKMinorNumber(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.lastIndexOf(95);
        if (n > 0 && n < string.length() - 1) {
            String string2 = string.substring(n + 1);
            int n2 = string2.indexOf(45);
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            return Integer.parseInt(string2);
        }
        return 0;
    }

    private static int getJDKVersionNumber(String string) {
        int n = string.startsWith("1.5") ? 2 : (string.startsWith("1.6") ? 3 : (string.startsWith("1.7") ? 4 : (string.startsWith("1.8") ? 6 : (string.startsWith("1.9") ? 7 : (string.equals("9") || string.startsWith("9.") ? 7 : (string.equals("10") || string.startsWith("10.") ? 8 : (string.equals("11") || string.equals("11-ea") || string.startsWith("11.") ? 9 : (string.equals("12") || string.equals("12-ea") || string.startsWith("12.") ? 10 : (string.equals("13") || string.equals("13-ea") || string.startsWith("13.") ? 11 : (string.equals("CVM") ? 5 : -1))))))))));
        return n;
    }

    public static int getJDKVersionNumber() {
        if (jdkVersion == 0) {
            jdkVersion = Platform.getJDKVersionNumber(Platform.getJavaVersionString());
        }
        return jdkVersion;
    }

    public static String getJDKVersionString(String string) {
        int n = Platform.getJDKVersionNumber(string);
        switch (n) {
            case 2: {
                return "jdk15";
            }
            case 3: {
                return "jdk16";
            }
            case 4: {
                return "jdk17";
            }
            case 6: {
                return "jdk18";
            }
            case 7: {
                return "jdk19";
            }
            case 8: {
                return "jdk100";
            }
            case 9: {
                return "jdk110";
            }
            case 10: {
                return "jdk120";
            }
            case 11: {
                return "jdk130";
            }
            case 5: {
                return "cvm";
            }
            case -1: {
                return "UNSUPPORTED_JDK";
            }
        }
        System.err.println("Unsupported java " + string);
        return "UNSUPPORTED_JDK";
    }

    public static String getJDKVersionString() {
        if (jdkDenoteString == null) {
            jdkDenoteString = Platform.getJDKVersionString(Platform.getJavaVersionString());
        }
        return jdkDenoteString;
    }

    public static String getJavaVersionString() {
        String string = System.getProperty("java.vm.name");
        if ("CVM".equals(string)) {
            return string;
        }
        return System.getProperty("java.version");
    }

    public static String getJFluidNativeLibDirName(String string, String string2, int n) {
        String string3 = Platform.getAgentNativeLibFullName(string, false, string2, n);
        return string3.substring(0, string3.lastIndexOf(47));
    }

    public static boolean isLinux() {
        return Platform.getOperatingSystem() == 16;
    }

    public static boolean isLinux(String string) {
        return Platform.getOperatingSystem(string) == 16;
    }

    public static boolean isMac() {
        return Platform.getOperatingSystem() == 2048;
    }

    public static boolean isHpux() {
        return Platform.getOperatingSystem() == 32;
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = Platform.getOperatingSystem(string);
        }
        return operatingSystem;
    }

    public static int getOperatingSystem(String string) {
        if ("Windows NT".equals(string)) {
            return 1;
        }
        if ("Windows 95".equals(string)) {
            return 2;
        }
        if ("Windows 98".equals(string)) {
            return 4;
        }
        if ("Windows 2000".equals(string)) {
            return 4096;
        }
        if (string.startsWith("Windows ")) {
            return 16384;
        }
        if ("Solaris".equals(string)) {
            return 8;
        }
        if (string.startsWith("SunOS")) {
            return 8;
        }
        if (string.endsWith("Linux")) {
            return 16;
        }
        if ("HP-UX".equals(string)) {
            return 32;
        }
        if ("AIX".equals(string)) {
            return 64;
        }
        if ("Irix".equals(string)) {
            return 128;
        }
        if ("SunOS".equals(string)) {
            return 8;
        }
        if ("Digital UNIX".equals(string)) {
            return 512;
        }
        if ("OS/2".equals(string)) {
            return 1024;
        }
        if ("OpenVMS".equals(string)) {
            return 8192;
        }
        if (string.equalsIgnoreCase("mac os x")) {
            return 2048;
        }
        if (string.startsWith("Darwin")) {
            return 2048;
        }
        return 65536;
    }

    public static String getProfilerUserDir() throws IOException {
        String string = System.getProperty("nbprofiler.home");
        if (string != null) {
            File file = new File(string);
            if (!file.exists() && !file.mkdir()) {
                throw new IOException("Could not create directory " + string);
            }
            return string;
        }
        String string2 = System.getProperty("user.home") + File.separator + ".nbprofiler";
        File file = new File(string2);
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Could not create directory " + string2);
        }
        return string2;
    }

    public static boolean isSolaris() {
        return Platform.getOperatingSystem() == 8;
    }

    public static boolean isSolarisIntel() {
        String string = System.getProperty("os.arch");
        return Platform.isSolaris() && (string.endsWith("86") || string.equals("amd64"));
    }

    public static boolean isSolarisSparc() {
        String string = System.getProperty("os.arch");
        return Platform.isSolaris() && string.startsWith("sparc");
    }

    public static boolean isLinuxArm() {
        String string = System.getProperty("os.arch");
        return Platform.isLinux() && string.startsWith("arm");
    }

    public static boolean isLinuxArmVfpHflt() {
        String string = System.getProperty("sun.arch.abi");
        return Platform.isLinux() && Platform.isLinuxArm() && "gnueabihf".equals(string);
    }

    public static int getSystemArchitecture() {
        if (sysArch == 0) {
            String string = System.getProperty("sun.arch.data.model");
            sysArch = Platform.getSystemArchitecture(string);
        }
        return sysArch;
    }

    public static int getSystemArchitecture(String string) {
        return "64".equals(string) ? 64 : 32;
    }

    public static boolean isUnix() {
        return (Platform.getOperatingSystem() & 0xBF8) != 0;
    }

    public static boolean isWindows() {
        return (Platform.getOperatingSystem() & 0x5007) != 0;
    }

    public static boolean isWindows(String string) {
        return (Platform.getOperatingSystem(string) & 0x5007) != 0;
    }

    public static boolean is32bitArchitecture() {
        return Platform.getSystemArchitecture() == 32;
    }

    public static boolean is64bitArchitecture() {
        return Platform.getSystemArchitecture() == 64;
    }

    public static boolean supportsDynamicAttach(String string) {
        return "jdk16".equals(string) || "jdk17".equals(string) || "jdk18".equals(string) || "jdk19".equals(string) || "jdk100".equals(string) || "jdk110".equals(string) || "jdk120".equals(string) || "jdk130".equals(string);
    }

    public static boolean supportsThreadSleepingStateMonitoring(String string) {
        return string != null && (string.equals("jdk15") || string.equals("jdk16") || string.equals("jdk17") || string.equals("jdk18") || string.equals("jdk19") || string.equals("jdk100") || string.equals("jdk110") || string.equals("jdk120") || string.equals("jdk130") || string.equals("cvm"));
    }

    public static boolean thisVMSupportsThreadSleepingStateMonitoring() {
        return Platform.supportsThreadSleepingStateMonitoring(Platform.getJDKVersionNumber());
    }

    private static boolean supportsThreadSleepingStateMonitoring(int n) {
        return n == 2 || n == 3 || n == 4 || n == 6 || n >= 7 || n == 5;
    }
}

