/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.utils.formatting;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;

public class MethodNameFormatterFactory {
    private static MethodNameFormatterFactory instance;
    private final Map formatterMap;
    private MethodNameFormatter defaultFormatter;

    private MethodNameFormatterFactory() {
        this.formatterMap = new HashMap();
    }

    private MethodNameFormatterFactory(MethodNameFormatterFactory methodNameFormatterFactory) {
        this.formatterMap = methodNameFormatterFactory.formatterMap;
    }

    public static synchronized MethodNameFormatterFactory getDefault() {
        if (instance == null) {
            instance = new MethodNameFormatterFactory();
            MethodNameFormatterFactory.instance.defaultFormatter = new DefaultMethodNameFormatter();
        }
        return instance;
    }

    public static synchronized MethodNameFormatterFactory getDefault(MethodNameFormatter methodNameFormatter) {
        MethodNameFormatterFactory methodNameFormatterFactory = new MethodNameFormatterFactory(MethodNameFormatterFactory.getDefault());
        methodNameFormatterFactory.defaultFormatter = methodNameFormatter;
        return methodNameFormatterFactory;
    }

    public MethodNameFormatter getFormatter() {
        return this.defaultFormatter;
    }

    public synchronized MethodNameFormatter getFormatter(Mark mark) {
        if (mark == null || mark.isDefault()) {
            return this.defaultFormatter;
        }
        MethodNameFormatter methodNameFormatter = (MethodNameFormatter)this.formatterMap.get(mark);
        if (methodNameFormatter == null) {
            return this.defaultFormatter;
        }
        return methodNameFormatter;
    }

    public synchronized void registerFormatter(Mark mark, MethodNameFormatter methodNameFormatter) {
        this.formatterMap.put(mark, methodNameFormatter);
    }
}

