/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.fibs.geotag.Settings;
import org.fibs.geotag.gui.FontChooser;
import org.fibs.geotag.gui.settings.SettingsPanel;
import org.fibs.geotag.util.FontUtil;

public class FontSettingsPanel
extends SettingsPanel {
    private JTextField textField;

    public FontSettingsPanel(JFrame parent, String title, Settings.SETTING setting, String defaultValue) {
        this(parent, title, null, true, setting, defaultValue);
    }

    public FontSettingsPanel(JFrame parent, String title, Settings.SETTING enablingSetting, boolean defaultEnabled, Settings.SETTING setting, String defaultValue) {
        super(parent, title, enablingSetting, defaultEnabled, setting, defaultValue);
        JPanel fontPanel = new JPanel(new BorderLayout());
        this.textField = new JTextField(Settings.get(setting, defaultValue));
        fontPanel.add((Component)this.textField, "Center");
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font font = FontUtil.fontFromID(Settings.get(FontSettingsPanel.this.getSetting(), FontSettingsPanel.this.getDefaultValue()));
                FontChooser fontChooser = new FontChooser((Frame)FontSettingsPanel.this.getParentFrame(), font);
                if (fontChooser.showDialog() != null) {
                    Font selectedFont = fontChooser.getSelectedFont();
                    FontSettingsPanel.this.getTextField().setText(FontUtil.fontToID(selectedFont));
                }
            }
        });
        fontPanel.add((Component)browseButton, "East");
        this.addEditor(fontPanel);
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    JTextField getTextField() {
        return this.textField;
    }
}

