/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class ExporterDL
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean exportVisible = false;
    private Workspace workspace;
    private Writer writer;
    private boolean cancel = false;
    ProgressTicket progressTicket;
    private boolean useMatrixFormat = false;
    private boolean useListFormat = true;
    private boolean makeSymmetricMatrix = false;

    public boolean isMakeSymmetricMatrix() {
        return this.makeSymmetricMatrix;
    }

    public void setMakeSymmetricMatrix(boolean makeSymmetricMatrix) {
        this.makeSymmetricMatrix = makeSymmetricMatrix;
    }

    public boolean isUseListFormat() {
        return this.useListFormat;
    }

    public void setUseListFormat(boolean useListFormat) {
        this.useListFormat = useListFormat;
    }

    public boolean isUseMatrixFormat() {
        return this.useMatrixFormat;
    }

    public void setUseMatrixFormat(boolean useMatrixFormat) {
        this.useMatrixFormat = useMatrixFormat;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel(this.workspace);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        Progress.start((ProgressTicket)this.progressTicket, (int)graph.getNodeCount());
        try {
            boolean useLabels = true;
            NodeIterable nodeIterable = graph.getNodes();
            for (Node node : nodeIterable) {
                if (this.cancel) {
                    nodeIterable.doBreak();
                    break;
                }
                useLabels &= node.getLabel() != null;
            }
            if (!this.cancel) {
                if (this.useListFormat) {
                    this.saveAsEdgeList1(useLabels, graph);
                } else {
                    this.saveAsFullMatrix(useLabels, graph);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(ExporterDL.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlockAll();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    private void saveAsEdgeList1(boolean useLabels, Graph graph) throws IOException {
        HashMap<Object, String> idToLabel = new HashMap<Object, String>();
        HashSet<String> labelUsed = new HashSet<String>();
        if (useLabels) {
            block0: for (Node node : graph.getNodes()) {
                if (labelUsed.contains(node.getLabel())) {
                    int i = 0;
                    while (true) {
                        if (!labelUsed.contains(node.getLabel() + "_" + i)) {
                            idToLabel.put(node.getId(), node.getLabel() + "_" + i);
                            labelUsed.add(node.getLabel() + "_" + i);
                            continue block0;
                        }
                        ++i;
                    }
                }
                idToLabel.put(node.getId(), node.getLabel());
                labelUsed.add(node.getLabel());
            }
        }
        this.writer.write("dl\n");
        this.writer.write("format = edgelist1\n");
        this.writer.write("n = " + graph.getNodeCount() + "\n");
        this.writer.write("labels embedded:\n");
        this.writer.write("data:\n");
        EdgeIterable edgesIterable = graph.getEdges();
        for (Edge edge : edgesIterable) {
            if (this.cancel) {
                edgesIterable.doBreak();
                break;
            }
            double weight = edge.getWeight(graph.getView());
            if (useLabels) {
                this.writer.write(this.formatLabel((String)idToLabel.get(edge.getSource().getId()), false) + " " + this.formatLabel((String)idToLabel.get(edge.getTarget().getId()), false) + " " + weight + "\n");
            } else {
                this.writer.write(this.formatLabel(edge.getSource().getId().toString(), false) + " " + this.formatLabel(edge.getTarget().getId().toString(), false) + " " + weight + "\n");
            }
            if (edge.isDirected()) continue;
            if (useLabels) {
                this.writer.write(this.formatLabel((String)idToLabel.get(edge.getTarget().getId()), false) + " " + this.formatLabel((String)idToLabel.get(edge.getSource().getId()), false) + " " + weight + "\n");
                continue;
            }
            this.writer.write(this.formatLabel(edge.getTarget().getId().toString(), false) + " " + this.formatLabel(edge.getSource().getId().toString(), false) + " " + weight + "\n");
        }
    }

    private String formatLabel(String input, boolean strictFormatting) {
        String res = input.replace(' ', '_');
        if (strictFormatting) {
            res = res.replace("\r\n", "-").replace('\n', '-').replace(',', '_');
        }
        return res;
    }

    private void saveAsFullMatrix(boolean useLabels, Graph graph) throws IOException {
        int i;
        this.writer.write("dl\n");
        this.writer.write("format = fullmatrix\n");
        this.writer.write("n = " + graph.getNodeCount() + "\n");
        HashMap<Integer, Node> idToNode = new HashMap<Integer, Node>();
        int idForNode = 0;
        for (Object node : graph.getNodes()) {
            idToNode.put(idForNode++, (Node)node);
        }
        int maxLengthOfEdgeWeight = 0;
        if (this.makeSymmetricMatrix) {
            for (Edge edge : graph.getEdges()) {
                double weight = edge.getWeight(graph.getView());
                maxLengthOfEdgeWeight = Math.max(maxLengthOfEdgeWeight, Double.toString(weight).length());
            }
        }
        this.writer.write("labels:\n");
        for (i = 0; i < graph.getNodeCount(); ++i) {
            if (i > 0) {
                this.writer.write(44);
            }
            if (useLabels) {
                this.writer.write(this.formatLabel(((Node)idToNode.get(i)).getLabel(), true));
                continue;
            }
            this.writer.write(this.formatLabel(((Node)idToNode.get(i)).getId().toString(), true));
        }
        this.writer.write("\n");
        this.writer.write("data:\n");
        for (i = 0; i < graph.getNodeCount() && !this.cancel; ++i) {
            Node source = (Node)idToNode.get(i);
            for (int j = 0; j < graph.getNodeCount() && !this.cancel; ++j) {
                Node target = (Node)idToNode.get(j);
                double weight = 0.0;
                Edge edge = graph.getEdge(source, target);
                if (edge != null) {
                    weight = edge.getWeight(graph.getView());
                }
                this.writer.write(Double.toString(weight) + " ");
                if (!this.makeSymmetricMatrix) continue;
                for (int repeatSpace = Double.toString(weight).length(); repeatSpace < maxLengthOfEdgeWeight; ++repeatSpace) {
                    this.writer.write(" ");
                }
            }
            this.writer.write("\n");
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

