/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.context.AbstractBeanDefinitionReference;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import java.io.IOException;
import java.io.OutputStream;

@Internal
public class BeanDefinitionReferenceWriter
extends AbstractAnnotationMetadataWriter {
    public static final String REF_SUFFIX = "Class";
    private final String beanTypeName;
    private final String beanDefinitionName;
    private final String beanDefinitionClassInternalName;
    private final String beanDefinitionReferenceClassName;
    private boolean contextScope = false;
    private boolean requiresMethodProcessing;

    public BeanDefinitionReferenceWriter(String beanTypeName, String beanDefinitionName, AnnotationMetadata annotationMetadata) {
        super(beanDefinitionName + REF_SUFFIX, annotationMetadata, true);
        this.beanTypeName = beanTypeName;
        this.beanDefinitionName = beanDefinitionName;
        this.beanDefinitionReferenceClassName = beanDefinitionName + REF_SUFFIX;
        this.beanDefinitionClassInternalName = BeanDefinitionReferenceWriter.getInternalName(beanDefinitionName) + REF_SUFFIX;
    }

    @Override
    public void accept(ClassWriterOutputVisitor outputVisitor) throws IOException {
        try (OutputStream outputStream = outputVisitor.visitClass(this.getBeanDefinitionQualifiedClassName());){
            ClassWriter classWriter = this.generateClassBytes();
            outputStream.write(classWriter.toByteArray());
        }
        outputVisitor.visitServiceDescriptor(BeanDefinitionReference.class, this.beanDefinitionReferenceClassName);
    }

    public void setContextScope(boolean contextScope) {
        this.contextScope = contextScope;
    }

    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.requiresMethodProcessing = shouldPreProcess;
    }

    public String getBeanDefinitionQualifiedClassName() {
        String newClassName = this.beanDefinitionName;
        if (newClassName.endsWith("[]")) {
            newClassName = newClassName.substring(0, newClassName.length() - 2);
        }
        return newClassName + REF_SUFFIX;
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(1);
        Type superType = Type.getType(AbstractBeanDefinitionReference.class);
        this.startPublicClass((ClassVisitor)classWriter, this.beanDefinitionClassInternalName, superType);
        Type beanDefinitionType = BeanDefinitionReferenceWriter.getTypeReference(this.beanDefinitionName);
        this.writeAnnotationMetadataStaticInitializer(classWriter);
        GeneratorAdapter cv = this.startConstructor((ClassVisitor)classWriter);
        cv.loadThis();
        cv.push(this.beanTypeName);
        cv.push(this.beanDefinitionName);
        this.invokeConstructor((MethodVisitor)cv, AbstractBeanDefinitionReference.class, String.class, String.class);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
        GeneratorAdapter loadMethod = this.startPublicMethodZeroArgs(classWriter, BeanDefinition.class, "load");
        this.pushNewInstance(loadMethod, beanDefinitionType);
        loadMethod.returnValue();
        loadMethod.visitMaxs(2, 1);
        if (this.contextScope) {
            GeneratorAdapter isContextScopeMethod = this.startPublicMethodZeroArgs(classWriter, Boolean.TYPE, "isContextScope");
            isContextScopeMethod.push(true);
            isContextScopeMethod.returnValue();
            isContextScopeMethod.visitMaxs(1, 1);
        }
        GeneratorAdapter getBeanDefinitionType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanDefinitionType");
        getBeanDefinitionType.push(beanDefinitionType);
        getBeanDefinitionType.returnValue();
        getBeanDefinitionType.visitMaxs(2, 1);
        GeneratorAdapter getBeanType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanType");
        getBeanType.push(BeanDefinitionReferenceWriter.getTypeReference(this.beanTypeName));
        getBeanType.returnValue();
        getBeanType.visitMaxs(2, 1);
        if (this.requiresMethodProcessing) {
            GeneratorAdapter requiresMethodProcessing = this.startPublicMethod(classWriter, "requiresMethodProcessing", Boolean.TYPE.getName(), new String[0]);
            requiresMethodProcessing.push(true);
            requiresMethodProcessing.visitInsn(172);
            requiresMethodProcessing.visitMaxs(1, 1);
            requiresMethodProcessing.visitEnd();
        }
        this.writeGetAnnotationMetadataMethod(classWriter);
        for (GeneratorAdapter generatorAdapter : this.loadTypeMethods.values()) {
            generatorAdapter.visitMaxs(3, 1);
        }
        return classWriter;
    }
}

