/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.repository.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.AbstractRepository;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.file.FileResource;
import org.jetbrains.kotlin.org.apache.ivy.util.Checks;
import org.jetbrains.kotlin.org.apache.ivy.util.CopyProgressListener;
import org.jetbrains.kotlin.org.apache.ivy.util.FileUtil;

public class FileRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private File baseDir = null;
    private boolean local = true;

    @Override
    public Resource getResource(String source) throws IOException {
        return new FileResource(this, this.getFile(source));
    }

    @Override
    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        this.copy(this.getFile(source), destination, true);
    }

    private void copy(File src, File destination, boolean overwrite) throws IOException {
        try {
            this.getProgressListener().setTotalLength(src.length());
            if (!FileUtil.copy(src, destination, (CopyProgressListener)this.getProgressListener(), overwrite)) {
                if (!overwrite && destination.exists()) {
                    throw new IOException("file copy not done from " + src + " to " + destination + ": destination already exists and overwrite is false");
                }
                throw new IOException("file copy not done from " + src + " to " + destination);
            }
        }
        catch (IOException | RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.getProgressListener().setTotalLength(null);
        }
    }

    protected RepositoryCopyProgressListener getProgressListener() {
        return this.progress;
    }

    @Override
    public List<String> list(String parent) throws IOException {
        String[] names;
        File dir = this.getFile(parent);
        if (dir.exists() && dir.isDirectory() && (names = dir.list()) != null) {
            ArrayList<String> ret = new ArrayList<String>(names.length);
            for (String name : names) {
                ret.add(parent + this.getFileSeparator() + name);
            }
            return ret;
        }
        return null;
    }

    File getFile(String source) {
        if (this.baseDir == null) {
            return Checks.checkAbsolute(source, "source");
        }
        return FileUtil.resolveFile(this.baseDir, source);
    }

    public boolean isLocal() {
        return this.local;
    }

    @Override
    public String standardize(String source) {
        if (this.baseDir == null) {
            return FileUtil.normalize(source).getPath();
        }
        return FileUtil.resolveFile(this.baseDir, source).getPath();
    }

    @Override
    public String getFileSeparator() {
        return File.separator;
    }
}

