/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public final class CommandFactoryNoteOnLink
implements SingleMultiFactoryCommand<CucaDiagram> {
    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(CommandFactoryNoteOnLink.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("o[nf]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("link"), RegexLeaf.spaceZeroOrMore(), CommandFactoryNoteOnLink.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(CommandFactoryNoteOnLink.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("o[nf]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("link"), RegexLeaf.spaceZeroOrMore(), CommandFactoryNoteOnLink.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<CucaDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<CucaDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?note$";
            }

            @Override
            protected CommandExecutionResult executeNow(CucaDiagram system, BlocLines lines) throws NoSuchColorException {
                String line0 = lines.getFirst().getTrimmed().getString();
                lines = lines.subExtract(1, 1);
                if ((lines = lines.removeEmptyColumns()).size() > 0) {
                    RegexResult arg = this.getStartingPattern().matcher(line0);
                    return CommandFactoryNoteOnLink.this.executeInternal(system, lines, arg);
                }
                return CommandExecutionResult.error("No note defined");
            }
        };
    }

    @Override
    public Command<CucaDiagram> createSingleLine() {
        return new SingleLineCommand2<CucaDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(CucaDiagram system, LineLocation location, RegexResult arg) throws NoSuchColorException {
                BlocLines note = BlocLines.getWithNewlines(arg.get("NOTE", 0));
                return CommandFactoryNoteOnLink.this.executeInternal(system, note, arg);
            }
        };
    }

    private CommandExecutionResult executeInternal(CucaDiagram diagram, BlocLines note, RegexResult arg) throws NoSuchColorException {
        Link link = diagram.getLastLink();
        if (link == null) {
            return CommandExecutionResult.error("No link defined");
        }
        Position position = Position.BOTTOM;
        if (arg.get("POSITION", 0) != null) {
            position = Position.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0)));
        }
        Url url = null;
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        Colors colors = CommandFactoryNoteOnLink.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        link.addNote(note.toDisplay(), position, colors);
        return CommandExecutionResult.ok();
    }
}

