/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import gen.lib.cgraph.attr__c;
import gen.lib.cgraph.edge__c;
import gen.lib.cgraph.graph__c;
import gen.lib.cgraph.node__c;
import gen.lib.gvc.gvc__c;
import gen.lib.gvc.gvlayout__c;
import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraph_s;
import h.ST_GVC_s;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.jsondiagram.JsonCurve;
import net.sourceforge.plantuml.jsondiagram.Mirror;
import net.sourceforge.plantuml.jsondiagram.TextBlockJson;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import smetana.core.CString;
import smetana.core.Macro;
import smetana.core.Z;

public class SmetanaForJson {
    private static int NUM = 0;
    private static final boolean printFirst = false;
    private static final boolean exitAfterFirst = false;
    private final UGraphic ug;
    private final ISkinParam skinParam;
    private int num;
    private ST_Agraph_s g;
    private StringBounder stringBounder;
    private final List<InternalNode> nodes = new ArrayList<InternalNode>();
    private final List<ST_Agedge_s> edges = new ArrayList<ST_Agedge_s>();
    private Mirror xMirror;

    public SmetanaForJson(UGraphic ug, ISkinParam skinParam) {
        this.stringBounder = ug.getStringBounder();
        this.skinParam = skinParam;
        this.ug = ug;
    }

    private UGraphic getUgFor(SName name) {
        return this.getStyle(name).applyStrokeAndLineColor(this.ug, this.skinParam.getIHtmlColorSet());
    }

    private SName getDiagramType() {
        return this.skinParam.getUmlDiagramType() == UmlDiagramType.YAML ? SName.yamlDiagram : SName.jsonDiagram;
    }

    private Style getStyle(SName name) {
        return StyleSignature.of(SName.root, SName.element, this.getDiagramType(), name).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private Style getStyleNodeHighlight() {
        return StyleSignature.of(SName.root, SName.element, this.getDiagramType(), SName.node, SName.highlight).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private ST_Agnode_s manageOneNode(JsonValue current, List<String> highlighted) {
        TextBlockJson block = new TextBlockJson(this.skinParam, current, highlighted, this.getStyle(SName.node), this.getStyleNodeHighlight());
        ST_Agnode_s node1 = this.createNode(block.calculateDimension(this.stringBounder), block.size(), current.isArray(), (int)block.getWidthColA(this.stringBounder), (int)block.getWidthColB(this.stringBounder));
        this.nodes.add(new InternalNode(block, node1));
        List<JsonValue> children = block.children();
        List<String> keys = block.keys();
        for (int i = 0; i < children.size(); ++i) {
            JsonValue tmp = children.get(i);
            if (tmp == null) continue;
            ST_Agnode_s childBloc = this.manageOneNode(tmp, this.removeOneLevel(keys.get(i), highlighted));
            ST_Agedge_s edge = this.createEdge(node1, childBloc, i);
            this.edges.add(edge);
        }
        return node1;
    }

    private List<String> removeOneLevel(String key, List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (String tmp : list) {
            if (!tmp.startsWith("\"" + key + "\"") || (tmp = tmp.trim().replaceFirst("\"([^\"]+)\"", "").trim()).length() <= 0) continue;
            tmp = tmp.substring(1).trim();
            result.add(tmp);
        }
        return Collections.unmodifiableList(result);
    }

    public void drawMe(JsonValue root, List<String> highlighted) {
        this.initGraph(root, highlighted);
        double max = 0.0;
        for (InternalNode node : this.nodes) {
            max = Math.max(max, node.getMaxX());
        }
        this.xMirror = new Mirror(max);
        for (InternalNode node : this.nodes) {
            node.block.drawU(this.getUgFor(SName.node).apply(this.getPosition(node.node)));
        }
        HColor color = this.getStyle(SName.arrow).value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        for (ST_Agedge_s edge : this.edges) {
            JsonCurve curve = this.getCurve(edge, 13.0);
            curve.drawCurve(color, this.getUgFor(SName.arrow));
            curve.drawSpot(this.getUgFor(SName.arrow).apply(color.bg()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGraph(JsonValue root, List<String> highlighted) {
        if (this.g != null) {
            return;
        }
        Z.open();
        try {
            this.g = graph__c.agopen(new CString("g"), Z.z().Agdirected, null);
            this.manageOneNode(root, highlighted);
            ST_GVC_s gvc = gvc__c.gvContext(new Object[0]);
            gvlayout__c.gvLayoutJobs(gvc, this.g);
        }
        finally {
            Z.close();
            ++NUM;
        }
    }

    private UTranslate getPosition(ST_Agnode_s node) {
        ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(node);
        double width = data.width * 72.0;
        double height = data.height * 72.0;
        double x = data.coord.x;
        double y = data.coord.y;
        return new UTranslate(x - width / 2.0, this.xMirror.inv(y + height / 2.0)).sym();
    }

    private JsonCurve getCurve(ST_Agedge_s e, double veryFirstLine) {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(e);
        return new JsonCurve(data, this.xMirror, veryFirstLine);
    }

    private ST_Agedge_s createEdge(ST_Agnode_s a0, ST_Agnode_s a1, int num) {
        ST_Agedge_s edge = edge__c.agedge(this.g, a0, a1, null, true);
        edge.NAME = a0.NAME + "-" + a1.NAME;
        attr__c.agsafeset(edge, new CString("arrowsize"), new CString(".75"), new CString(""));
        attr__c.agsafeset(edge, new CString("arrowtail"), new CString("none"), new CString(""));
        attr__c.agsafeset(edge, new CString("arrowhead"), new CString("normal"), new CString(""));
        attr__c.agsafeset(edge, new CString("tailport"), new CString("P" + num), new CString(""));
        StringBuilder sb = new StringBuilder();
        sb.append("N" + a0.UID + " -> N" + a1.UID + " [tailport=\"P" + num + "\", arrowsize=.75]");
        if (NUM == 0) {
            // empty if block
        }
        return edge;
    }

    private ST_Agnode_s createNode(Dimension2D dim, int size, boolean isArray, int colAwidth, int colBwidth) {
        String width = "" + dim.getWidth() / 72.0;
        String height = "" + dim.getHeight() / 72.0;
        ST_Agnode_s node = node__c.agnode(this.g, new CString("N" + this.num), true);
        node.NAME = "N " + this.num;
        ++this.num;
        attr__c.agsafeset(node, new CString("shape"), new CString("record"), new CString(""));
        attr__c.agsafeset(node, new CString("height"), new CString("" + width), new CString(""));
        attr__c.agsafeset(node, new CString("width"), new CString("" + height), new CString(""));
        boolean lineHeight = false;
        String dotLabel = this.getDotLabel(size, isArray, colAwidth - 8, colBwidth - 8, 0);
        if (size > 0) {
            attr__c.agsafeset(node, new CString("label"), new CString(dotLabel), new CString(""));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("N" + node.UID + " [");
        sb.append("shape=record, height=" + width + ", width=" + height + ", label=\"" + dotLabel.replace('x', '.') + "\"]");
        if (NUM == 0) {
            // empty if block
        }
        return node;
    }

    private String getDotLabel(int size, boolean isArray, int widthA, int widthB, int height) {
        StringBuilder sb = new StringBuilder("");
        if (!isArray) {
            sb.append("{_dim_" + height + "_" + widthA + "_|{");
        }
        for (int i = 0; i < size; ++i) {
            sb.append("<P" + i + ">");
            sb.append("_dim_" + height + "_" + widthB + "_");
            if (i >= size - 1) continue;
            sb.append("|");
        }
        if (!isArray) {
            sb.append("}}");
        }
        return sb.toString();
    }

    static class InternalNode {
        private final TextBlockJson block;
        private final ST_Agnode_s node;

        public InternalNode(TextBlockJson block, ST_Agnode_s node) {
            this.block = block;
            this.node = node;
        }

        double getMaxX() {
            ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(this.node);
            double height = data.height * 72.0;
            double y = data.coord.y;
            return y + height / 2.0;
        }
    }
}

