/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class ArrowAndNoteBox
extends Arrow
implements InGroupable {
    private final Arrow arrow;
    private final List<NoteBox> noteBoxes = new ArrayList<NoteBox>();

    public ArrowAndNoteBox(StringBounder stringBounder, Arrow arrow, List<NoteBox> noteBoxes) {
        super(arrow.getStartingY(), arrow.getSkin(), arrow.getArrowComponent(), arrow.getUrl());
        this.arrow = arrow;
        this.noteBoxes.addAll(noteBoxes);
        for (NoteBox noteBox : noteBoxes) {
            double arrowHeight = arrow.getPreferredHeight(stringBounder);
            double noteHeight = noteBox.getPreferredHeight(stringBounder);
            double myHeight = this.getPreferredHeight(stringBounder);
            double diffHeightArrow = myHeight - arrowHeight;
            double diffHeightNote = myHeight - noteHeight;
            if (diffHeightArrow > 0.0) {
                arrow.pushToDown(diffHeightArrow / 2.0);
            }
            if (!(diffHeightNote > 0.0)) continue;
            noteBox.pushToDown(diffHeightNote / 2.0);
        }
    }

    @Override
    public final double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.arrow.getPreferredWidth(stringBounder);
    }

    @Override
    public void setMaxX(double m) {
        super.setMaxX(m);
        this.arrow.setMaxX(m);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        this.arrow.drawU(ug, maxX, context);
        for (NoteBox noteBox : this.noteBoxes) {
            noteBox.drawU(ug, maxX, context);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        double result = this.arrow.getPreferredHeight(stringBounder);
        for (NoteBox noteBox : this.noteBoxes) {
            result = Math.max(result, noteBox.getPreferredHeight(stringBounder));
        }
        return result;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double w = this.arrow.getPreferredWidth(stringBounder);
        double result = w = Math.max(w, this.arrow.getActualWidth(stringBounder));
        for (NoteBox noteBox : this.noteBoxes) {
            result += noteBox.getPreferredWidth(stringBounder);
            if (noteBox.getNotePosition() != NotePosition.RIGHT) continue;
            result += noteBox.getRightShift(this.arrow.getStartingY());
        }
        return result;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        double result = this.arrow.getStartingX(stringBounder);
        for (NoteBox noteBox : this.noteBoxes) {
            result = Math.min(result, noteBox.getStartingX(stringBounder));
        }
        return result;
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return this.arrow.getDirection(stringBounder);
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYStartLevel(stringBounder);
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        return this.arrow.getArrowYEndLevel(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition position) {
        return this.arrow.getParticipantAt(stringBounder, position);
    }
}

