/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ActiveScanTableModel;
import org.zaproxy.zap.extension.ascan.AttackScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.FilterMessageTableModel;
import org.zaproxy.zap.extension.ascan.ScanProgressDialog;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.ScanListenner2;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.TableExportButton;
import org.zaproxy.zap.view.ScanPanel2;
import org.zaproxy.zap.view.ZapTable;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

public class ActiveScanPanel
extends ScanPanel2<ActiveScan, ScanController<ActiveScan>>
implements ScanListenner2,
ScannerListener {
    private static final Logger LOGGER = LogManager.getLogger(ActiveScanPanel.class);
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String PANEL_NAME = "ascan";
    public static final String MESSAGE_CONTAINER_NAME = "ActiveScanMessageContainer";
    private static final String ZERO_REQUESTS_LABEL_TEXT = "0";
    private static final String ZERO_NEW_ALERTS_LABEL_TEXT = "0";
    private static final ActiveScanTableModel EMPTY_RESULTS_MODEL = new ActiveScanTableModel();
    private static final FilterMessageTableModel EMPTY_FILTER_MESSAGE_MODEL = new FilterMessageTableModel();
    private ExtensionActiveScan extension;
    private HistoryReferencesTable messagesTable;
    private ZapTable filterMessageTable;
    private JButton policyButton = null;
    private JButton scanButton = null;
    private JButton progressButton;
    private JLabel numRequests;
    private JLabel numNewAlerts;
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private TableExportButton<ZapTable> exportButton;

    public ActiveScanPanel(ExtensionActiveScan extension) {
        super(PANEL_NAME, new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/16/093.png")), extension);
        this.tabbedPane.addChangeListener(e -> {
            switch (this.tabbedPane.getSelectedIndex()) {
                case 0: {
                    this.getExportButton().setTable(this.getMessagesTable());
                    break;
                }
                case 1: {
                    this.getExportButton().setTable(this.getFilterMessageTable());
                }
            }
        });
        this.extension = extension;
        this.setDefaultAccelerator(extension.getView().getMenuShortcutKeyStroke(65, 576, false));
        this.setMnemonic(Constant.messages.getChar("ascan.panel.mnemonic"));
    }

    @Override
    protected int addToolBarElements(JToolBar panelToolbar, ScanPanel2.Location loc, int x) {
        if (ScanPanel2.Location.start.equals((Object)loc)) {
            panelToolbar.add((Component)this.getPolicyManagerButton(), this.getGBC(x++, 0));
        }
        if (ScanPanel2.Location.beforeProgressBar.equals((Object)loc)) {
            panelToolbar.add((Component)this.getProgressButton(), this.getGBC(x++, 0));
        }
        if (ScanPanel2.Location.afterProgressBar.equals((Object)loc)) {
            panelToolbar.add((Component)new JToolBar.Separator(), this.getGBC(x++, 0));
            panelToolbar.add((Component)new JLabel(Constant.messages.getString("ascan.toolbar.requests.label")), this.getGBC(x++, 0));
            panelToolbar.add((Component)this.getNumRequests(), this.getGBC(x++, 0));
            panelToolbar.add((Component)new JToolBar.Separator(), this.getGBC(x++, 0));
            panelToolbar.add((Component)new JLabel(Constant.messages.getString("ascan.toolbar.newalerts.label")), this.getGBC(x++, 0));
            panelToolbar.add((Component)this.getNumNewAlerts(), this.getGBC(x++, 0));
            panelToolbar.add((Component)new JToolBar.Separator(), this.getGBC(x++, 0));
            panelToolbar.add(this.getExportButton(), this.getGBC(x++, 0));
        }
        return x;
    }

    private JButton getPolicyManagerButton() {
        if (this.policyButton == null) {
            this.policyButton = new JButton();
            this.policyButton.setToolTipText(Constant.messages.getString("menu.analyse.scanPolicy"));
            this.policyButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/fugue/equalizer.png"))));
            this.policyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActiveScanPanel.this.extension.showPolicyManagerDialog();
                }
            });
        }
        return this.policyButton;
    }

    @Override
    public JButton getNewScanButton() {
        if (this.scanButton == null) {
            this.scanButton = new JButton(Constant.messages.getString("ascan.toolbar.button.new"));
            this.scanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/16/093.png"))));
            this.scanButton.addActionListener(e -> this.extension.showCustomScanDialog((Target)null));
        }
        return this.scanButton;
    }

    private JButton getProgressButton() {
        if (this.progressButton == null) {
            this.progressButton = new JButton();
            this.progressButton.setEnabled(false);
            this.progressButton.setToolTipText(Constant.messages.getString("ascan.toolbar.button.progress"));
            this.progressButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ActiveScanPanel.class.getResource("/resource/icon/fugue/system-monitor.png"))));
            this.progressButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActiveScanPanel.this.showScanProgressDialog();
                }
            });
        }
        return this.progressButton;
    }

    private JLabel getNumRequests() {
        if (this.numRequests == null) {
            this.numRequests = new JLabel("0");
        }
        return this.numRequests;
    }

    private void showScanProgressDialog() {
        ActiveScan scan = (ActiveScan)this.getSelectedScanner();
        if (scan != null) {
            ScanProgressDialog spp = new ScanProgressDialog((Frame)View.getSingleton().getMainFrame(), scan.getDisplayName(), this.extension);
            spp.setActiveScan(scan);
            spp.setVisible(true);
        }
    }

    private TableExportButton<ZapTable> getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new TableExportButton<HistoryReferencesTable>(this.getMessagesTable());
        }
        return this.exportButton;
    }

    @Override
    public void clearFinishedScans() {
        if (this.extension.getScannerParam().isPromptToClearFinishedScans()) {
            int res = View.getSingleton().showConfirmDontPromptDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("ascan.toolbar.confirm.clear"));
            if (View.getSingleton().isDontPromptLastDialogChosen()) {
                this.extension.getScannerParam().setPromptToClearFinishedScans(false);
            }
            if (res != 0) {
                return;
            }
        }
        super.clearFinishedScans();
    }

    @Override
    protected JPanel getWorkPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setName("ActiveScanMessagePane");
            jScrollPane.setViewportView((Component)((Object)this.getMessagesTable()));
            JScrollPane filterPane = new JScrollPane();
            filterPane.setName("FilterMessagePane");
            filterPane.setViewportView((Component)((Object)this.getFilterMessageTable()));
            this.tabbedPane.add(Constant.messages.getString("ascan.panel.tab.scannedMessages"), jScrollPane);
            this.tabbedPane.add(Constant.messages.getString("ascan.panel.tab.filteredMessages"), filterPane);
            this.tabbedPane.setSelectedIndex(0);
            this.mainPanel.add(this.tabbedPane);
        }
        return this.mainPanel;
    }

    private void resetMessagesTable() {
        this.getMessagesTable().setModel(EMPTY_RESULTS_MODEL);
    }

    private void resetFilterMessageTable() {
        this.getFilterMessageTable().setModel(EMPTY_FILTER_MESSAGE_MODEL);
    }

    private HistoryReferencesTable getMessagesTable() {
        if (this.messagesTable == null) {
            this.messagesTable = new HistoryReferencesTable(EMPTY_RESULTS_MODEL);
            this.messagesTable.setName(MESSAGE_CONTAINER_NAME);
            this.messagesTable.setAutoCreateColumnsFromModel(false);
        }
        return this.messagesTable;
    }

    private ZapTable getFilterMessageTable() {
        if (this.filterMessageTable == null) {
            this.filterMessageTable = new ZapTable(EMPTY_FILTER_MESSAGE_MODEL);
            this.filterMessageTable.setName("FilterMessageTable");
            this.filterMessageTable.setAutoCreateColumnsFromModel(false);
        }
        return this.filterMessageTable;
    }

    @Override
    public void switchView(final ActiveScan scanner) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ActiveScanPanel.this.switchView(scanner);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.error("Failed to switch view: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        if (scanner != null) {
            this.getMessagesTable().setModel(scanner.getMessagesTableModel());
            this.getFilterMessageTable().setModel(scanner.getFilterMessageTableModel());
            this.getNumRequests().setText(Integer.toString(scanner.getTotalRequests()));
            this.getNumNewAlerts().setText(Integer.toString(scanner.getTotalNewAlerts()));
            this.getProgressButton().setEnabled(true);
            if (scanner instanceof AttackScan) {
                this.getProgressBar().setEnabled(false);
                this.getProgressButton().setEnabled(false);
                this.getPauseScanButton().setEnabled(false);
                this.getStopScanButton().setEnabled(false);
            }
        } else {
            this.resetMessagesTable();
            this.resetFilterMessageTable();
            this.getNumRequests().setText("0");
            this.getNumNewAlerts().setText("0");
            this.getProgressButton().setEnabled(false);
        }
    }

    @Override
    public void alertFound(Alert alert) {
    }

    @Override
    public void hostComplete(int id, String hostAndPort) {
        this.scanFinshed(id, hostAndPort);
    }

    @Override
    public void hostNewScan(int id, String hostAndPort, HostProcess hostThread) {
    }

    @Override
    public void hostProgress(int id, String hostAndPort, String msg, int percentage) {
        this.scanProgress(id, hostAndPort, percentage, 100);
        this.updateRequestCount();
        this.updateNewAlertCount();
    }

    @Override
    public void scannerComplete(int id) {
        this.scanFinshed(id, this.getName());
    }

    private void updateRequestCount() {
        ActiveScan ac = (ActiveScan)this.getSelectedScanner();
        if (ac != null) {
            this.getNumRequests().setText(Integer.toString(ac.getTotalRequests()));
        }
    }

    @Override
    public void notifyNewMessage(HttpMessage msg) {
    }

    private void updateNewAlertCount() {
        ActiveScan ac = (ActiveScan)this.getSelectedScanner();
        if (ac != null) {
            this.getNumNewAlerts().setText(Integer.toString(ac.getTotalNewAlerts()));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetMessagesTable();
        this.resetFilterMessageTable();
        this.getProgressButton().setEnabled(false);
    }

    @Override
    protected int getNumberOfScansToShow() {
        return this.extension.getScannerParam().getMaxScansInUI();
    }

    private JLabel getNumNewAlerts() {
        if (this.numNewAlerts == null) {
            this.numNewAlerts = new JLabel("0");
        }
        return this.numNewAlerts;
    }
}

