/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.OptionsViewPanel;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class BreakpointsOptionsPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 7483614036849207715L;
    private JCheckBox checkBoxConfirmDropMessage = null;
    private JCheckBox checkBoxAlwaysOnTop = null;
    private JCheckBox checkBoxInScopeOnly = null;
    private JCheckBox checkBoxShowIgnoreFilesButtons = null;
    private ZapTextField javascriptUrlRegexField = null;
    private ZapTextField cssAndFontsUrlRegexField = null;
    private ZapTextField multimediaUrlRegexField = null;
    private JComboBox<String> buttonMode = null;

    public BreakpointsOptionsPanel() {
        this.setName(Constant.messages.getString("brk.optionspanel.name"));
        this.setLayout(new CardLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        int row = 0;
        panel.add((Component)this.getCheckBoxConfirmDropMessage(), LayoutHelper.getGBC(0, row++, 2, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)this.getCheckBoxInScopeOnly(), LayoutHelper.getGBC(0, row++, 2, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)this.getCheckBoxAlwaysOnTop(), LayoutHelper.getGBC(0, row++, 2, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)this.getCheckBoxShowIgnoreFilesButtons(), LayoutHelper.getGBC(0, row++, 2, 1.0, new Insets(2, 2, 2, 2)));
        JLabel javascriptUrlRegexLabel = new JLabel(Constant.messages.getString("brk.optionspanel.option.javaScriptUrlRegex.label"));
        javascriptUrlRegexLabel.setLabelFor(this.getJavascriptUrlRegexField());
        panel.add((Component)javascriptUrlRegexLabel, LayoutHelper.getGBC(0, 4, 1, 2.0));
        panel.add((Component)this.getJavascriptUrlRegexField(), LayoutHelper.getGBC(1, 4, 1, 8.0));
        JLabel cssAndFontsUrlRegexLabel = new JLabel(Constant.messages.getString("brk.optionspanel.option.cssAndFontsUrlRegex.label"));
        cssAndFontsUrlRegexLabel.setLabelFor(this.getCssAndFontsUrlRegexField());
        panel.add((Component)cssAndFontsUrlRegexLabel, LayoutHelper.getGBC(0, 5, 1, 2.0));
        panel.add((Component)this.getCssAndFontsUrlRegexField(), LayoutHelper.getGBC(1, 5, 1, 8.0));
        JLabel multimediaUrlRegexLabel = new JLabel(Constant.messages.getString("brk.optionspanel.option.multimediaUrlRegex.label"));
        multimediaUrlRegexLabel.setLabelFor(this.getMultimediaUrlRegexField());
        panel.add((Component)multimediaUrlRegexLabel, LayoutHelper.getGBC(0, 6, 1, 2.0));
        panel.add((Component)this.getMultimediaUrlRegexField(), LayoutHelper.getGBC(1, 6, 1, 8.0));
        JLabel modeLabel = new JLabel(Constant.messages.getString("brk.optionspanel.option.breakmode.label"));
        modeLabel.setLabelFor(this.getButtonMode());
        panel.add((Component)modeLabel, LayoutHelper.getGBC(0, 7, 1, 0.5));
        panel.add(this.getButtonMode(), LayoutHelper.getGBC(1, 7, 1, 0.5));
        panel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        this.add(panel);
    }

    private JCheckBox getCheckBoxConfirmDropMessage() {
        if (this.checkBoxConfirmDropMessage == null) {
            this.checkBoxConfirmDropMessage = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.confirmDropMessage.label"));
        }
        return this.checkBoxConfirmDropMessage;
    }

    private JCheckBox getCheckBoxAlwaysOnTop() {
        if (this.checkBoxAlwaysOnTop == null) {
            this.checkBoxAlwaysOnTop = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.alwaysOnTop.label"));
        }
        return this.checkBoxAlwaysOnTop;
    }

    private JCheckBox getCheckBoxInScopeOnly() {
        if (this.checkBoxInScopeOnly == null) {
            this.checkBoxInScopeOnly = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.inScopeOnly.label"));
        }
        return this.checkBoxInScopeOnly;
    }

    private JCheckBox getCheckBoxShowIgnoreFilesButtons() {
        if (this.checkBoxShowIgnoreFilesButtons == null) {
            this.checkBoxShowIgnoreFilesButtons = new JCheckBox(Constant.messages.getString("brk.optionspanel.option.showBreakFilteringButtons.label"));
        }
        return this.checkBoxShowIgnoreFilesButtons;
    }

    private ZapTextField getJavascriptUrlRegexField() {
        if (this.javascriptUrlRegexField == null) {
            this.javascriptUrlRegexField = new ZapTextField();
        }
        return this.javascriptUrlRegexField;
    }

    private ZapTextField getCssAndFontsUrlRegexField() {
        if (this.cssAndFontsUrlRegexField == null) {
            this.cssAndFontsUrlRegexField = new ZapTextField();
        }
        return this.cssAndFontsUrlRegexField;
    }

    private ZapTextField getMultimediaUrlRegexField() {
        if (this.multimediaUrlRegexField == null) {
            this.multimediaUrlRegexField = new ZapTextField();
        }
        return this.multimediaUrlRegexField;
    }

    private JComboBox<String> getButtonMode() {
        if (this.buttonMode == null) {
            this.buttonMode = new JComboBox();
            this.buttonMode.addItem(Constant.messages.getString("brk.optionspanel.option.breakmode.simple.label"));
            this.buttonMode.addItem(Constant.messages.getString("brk.optionspanel.option.breakmode.dual.label"));
        }
        return this.buttonMode;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        BreakpointsParam param = options.getParamSet(BreakpointsParam.class);
        this.getCheckBoxConfirmDropMessage().setSelected(param.isConfirmDropMessage());
        this.getCheckBoxAlwaysOnTop().setSelected(!Boolean.FALSE.equals(param.getAlwaysOnTop()));
        this.getCheckBoxInScopeOnly().setSelected(param.isInScopeOnly());
        this.getCheckBoxShowIgnoreFilesButtons().setSelected(param.isShowIgnoreFilesButtons());
        if (options.getViewParam().getBrkPanelViewOption() == OptionsViewPanel.BreakLocation.TOOL_BAR_ONLY.getValue()) {
            this.checkBoxShowIgnoreFilesButtons.setEnabled(false);
            this.checkBoxShowIgnoreFilesButtons.setToolTipText(Constant.messages.getString("brk.optionspanel.option.notpossibletoshowtip"));
        } else {
            this.checkBoxShowIgnoreFilesButtons.setEnabled(true);
            this.checkBoxShowIgnoreFilesButtons.setToolTipText("");
        }
        this.getButtonMode().setSelectedIndex(param.getButtonMode() - 1);
        this.getJavascriptUrlRegexField().setText(param.getJavascriptUrlRegex());
        this.getJavascriptUrlRegexField().discardAllEdits();
        this.getCssAndFontsUrlRegexField().setText(param.getCssAndFontsUrlRegex());
        this.getCssAndFontsUrlRegexField().discardAllEdits();
        this.getMultimediaUrlRegexField().setText(param.getMultimediaUrlRegex());
        this.getMultimediaUrlRegexField().discardAllEdits();
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        BreakpointsParam param = options.getParamSet(BreakpointsParam.class);
        param.setConfirmDropMessage(this.getCheckBoxConfirmDropMessage().isSelected());
        if (param.getAlwaysOnTop() != null || !this.getCheckBoxAlwaysOnTop().isSelected()) {
            param.setAlwaysOnTop(this.getCheckBoxAlwaysOnTop().isSelected());
        }
        param.setInScopeOnly(this.getCheckBoxInScopeOnly().isSelected());
        param.setShowIgnoreFilesButtons(this.getCheckBoxShowIgnoreFilesButtons().isSelected());
        param.setButtonMode(this.getButtonMode().getSelectedIndex() + 1);
        param.setJavascriptUrlRegex(this.getJavascriptUrlRegexField().getText());
        param.setCssAndFontsUrlRegex(this.getCssAndFontsUrlRegexField().getText());
        param.setMultimediaUrlRegex(this.getMultimediaUrlRegexField().getText());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.breakpoints";
    }
}

