/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.network.HttpEncoding;
import org.zaproxy.zap.network.HttpEncodingDeflate;
import org.zaproxy.zap.network.HttpEncodingGzip;
import org.zaproxy.zap.network.HttpRequestBody;
import org.zaproxy.zap.network.HttpResponseBody;
import org.zaproxy.zap.users.User;

public class HttpMessage
implements Message {
    public static final String EVENT_DATA_URI = "uri";
    public static final String EVENT_DATA_REQUEST_HEADER = "requestHeader";
    public static final String EVENT_DATA_REQUEST_BODY = "requestBody";
    public static final String EVENT_DATA_RESPONSE_HEADER = "responseHeader";
    public static final String EVENT_DATA_RESPONSE_BODY = "responseBody";
    public static final String MESSAGE_TYPE = "HTTP";
    private HttpRequestHeader mReqHeader = new HttpRequestHeader();
    private HttpRequestBody mReqBody = new HttpRequestBody();
    private HttpResponseHeader mResHeader = new HttpResponseHeader();
    private HttpResponseBody mResBody = new HttpResponseBody();
    private Object userObject = null;
    private int timeElapsed = 0;
    private long timeSent = 0L;
    private String note = "";
    private HistoryReference historyRef = null;
    private static Logger log = LogManager.getLogger(HttpMessage.class);
    private HttpSession httpSession = null;
    private User requestUser;
    private boolean forceIntercept = false;
    private boolean responseFromTargetHost = false;

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyRef) {
        this.historyRef = historyRef;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public void setHttpSession(HttpSession session) {
        this.httpSession = session;
    }

    public HttpMessage() {
    }

    public HttpMessage(URI uri) throws HttpMalformedHeaderException {
        this.setRequestHeader(new HttpRequestHeader("GET", uri, "HTTP/1.1"));
    }

    @Deprecated
    public HttpMessage(URI uri, ConnectionParam params) throws HttpMalformedHeaderException {
        this(uri);
    }

    public HttpMessage(HttpRequestHeader reqHeader) {
        this.setRequestHeader(reqHeader);
    }

    public HttpMessage(HttpRequestHeader reqHeader, HttpRequestBody reqBody) {
        this.setRequestHeader(reqHeader);
        this.setRequestBody(reqBody);
    }

    public HttpMessage(HttpRequestHeader reqHeader, HttpRequestBody reqBody, HttpResponseHeader resHeader, HttpResponseBody resBody) {
        this.setRequestHeader(reqHeader);
        this.setRequestBody(reqBody);
        this.setResponseHeader(resHeader);
        this.setResponseBody(resBody);
    }

    public HttpMessage(String reqHeader, byte[] reqBody, String resHeader, byte[] resBody) throws HttpMalformedHeaderException {
        this.setRequestHeader(reqHeader);
        this.setRequestBody(reqBody);
        if (resHeader != null && !resHeader.equals("")) {
            this.setResponseHeader(resHeader);
            this.setResponseBody(resBody);
        }
    }

    public HttpMessage(HttpMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("The parameter message must not be null.");
        }
        message.copyRequestInto(this);
        message.copyResponseInto(this);
        this.setUserObject(message.getUserObject());
        this.setTimeSentMillis(message.getTimeSentMillis());
        this.setTimeElapsedMillis(message.getTimeElapsedMillis());
        this.setNote(message.getNote());
        this.setHistoryRef(message.getHistoryRef());
        this.setHttpSession(message.getHttpSession());
        this.setRequestingUser(message.getRequestingUser());
        this.setForceIntercept(message.isForceIntercept());
        this.setResponseFromTargetHost(message.isResponseFromTargetHost());
    }

    public HttpRequestHeader getRequestHeader() {
        return this.mReqHeader;
    }

    public void setRequestHeader(HttpRequestHeader reqHeader) {
        if (reqHeader == null) {
            throw new IllegalArgumentException("The parameter reqHeader must not be null.");
        }
        this.mReqHeader = reqHeader;
    }

    public HttpResponseHeader getResponseHeader() {
        return this.mResHeader;
    }

    public void setResponseHeader(HttpResponseHeader resHeader) {
        if (resHeader == null) {
            throw new IllegalArgumentException("The parameter resHeader must not be null.");
        }
        this.mResHeader = resHeader;
    }

    public HttpRequestBody getRequestBody() {
        return this.mReqBody;
    }

    public void setRequestBody(HttpRequestBody reqBody) {
        if (reqBody == null) {
            throw new IllegalArgumentException("The parameter reqBody must not be null.");
        }
        this.mReqBody = reqBody;
    }

    public HttpResponseBody getResponseBody() {
        return this.mResBody;
    }

    public void setResponseBody(HttpResponseBody resBody) {
        if (resBody == null) {
            throw new IllegalArgumentException("The parameter resBody must not be null.");
        }
        this.mResBody = resBody;
        this.getResponseBody().setCharset(this.getResponseHeader().getCharset());
    }

    public void setRequestHeader(String reqHeader) throws HttpMalformedHeaderException {
        HttpRequestHeader newHeader = new HttpRequestHeader(reqHeader);
        this.setRequestHeader(newHeader);
    }

    public void setResponseHeader(String resHeader) throws HttpMalformedHeaderException {
        HttpResponseHeader newHeader = new HttpResponseHeader(resHeader);
        this.setResponseHeader(newHeader);
    }

    public static void setContentEncodings(HttpHeader header, HttpBody body) {
        String encoding = header.getHeader("Content-Encoding");
        if (encoding == null || encoding.isEmpty()) {
            body.setContentEncodings(Collections.emptyList());
            return;
        }
        ArrayList<HttpEncoding> encodings = new ArrayList<HttpEncoding>(1);
        if (encoding.contains("deflate")) {
            encodings.add(HttpEncodingDeflate.getSingleton());
        } else if (encoding.contains("gzip")) {
            encodings.add(HttpEncodingGzip.getSingleton());
        }
        body.setContentEncodings(encodings);
    }

    public void setRequestBody(String body) {
        HttpMessage.setContentEncodings(this.getRequestHeader(), this.getRequestBody());
        this.getRequestBody().setCharset(this.getRequestHeader().getCharset());
        this.getRequestBody().setBody(body);
    }

    public void setRequestBody(byte[] body) {
        this.getRequestBody().setBody(body);
        this.getRequestBody().setCharset(this.getRequestHeader().getCharset());
        HttpMessage.setContentEncodings(this.getRequestHeader(), this.getRequestBody());
    }

    public void setResponseBody(String body) {
        HttpMessage.setContentEncodings(this.getResponseHeader(), this.getResponseBody());
        this.getResponseBody().setCharset(this.getResponseHeader().getCharset());
        this.getResponseBody().setDetermineCharset(this.getResponseHeader().isText());
        this.getResponseBody().setBody(body);
    }

    public void setResponseBody(byte[] body) {
        this.getResponseBody().setBody(body);
        this.getResponseBody().setCharset(this.getResponseHeader().getCharset());
        HttpMessage.setContentEncodings(this.getResponseHeader(), this.getResponseBody());
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpMessage)) {
            return false;
        }
        HttpMessage msg = (HttpMessage)object;
        boolean result = false;
        if (!this.getRequestHeader().getMethod().equalsIgnoreCase(msg.getRequestHeader().getMethod())) {
            return false;
        }
        URI uri1 = this.getRequestHeader().getURI();
        URI uri2 = msg.getRequestHeader().getURI();
        if (uri1 == null) {
            return uri2 == null;
        }
        if (uri2 == null) {
            return false;
        }
        try {
            if (uri1.getHost() == null || uri2.getHost() == null || !uri1.getHost().equalsIgnoreCase(uri2.getHost())) {
                return false;
            }
            if (uri1.getPort() != uri2.getPort()) {
                return false;
            }
            String pathQuery1 = uri1.getPathQuery();
            String pathQuery2 = uri2.getPathQuery();
            if (pathQuery1 == null && pathQuery2 == null) {
                return true;
            }
            if (pathQuery1 != null && pathQuery2 != null) {
                return pathQuery1.equalsIgnoreCase(pathQuery2);
            }
            if (pathQuery1 == null || pathQuery2 == null) {
                return false;
            }
            if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
                return this.getRequestBody().equals(msg.getRequestBody());
            }
            result = true;
        }
        catch (URIException e) {
            try {
                result = this.getRequestHeader().getURI().toString().equalsIgnoreCase(msg.getRequestHeader().getURI().toString());
            }
            catch (Exception e1) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getRequestHeader().getMethod().toLowerCase(Locale.ROOT).hashCode();
        URI uri = this.getRequestHeader().getURI();
        if (uri != null) {
            result = 31 * result + uri.getPort();
            try {
                result = 31 * result + (uri.getRawHost() == null ? 0 : uri.getHost().toLowerCase(Locale.ROOT).hashCode());
            }
            catch (URIException e) {
                log.error("Failed to obtain the host for hashCode calculation: " + uri.toString(), (Throwable)e);
            }
            result = 31 * result + (uri.getRawPathQuery() == null ? 0 : uri.getEscapedPathQuery().toLowerCase(Locale.ROOT).hashCode());
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            result = 31 * result + this.getRequestBody().hashCode();
        }
        return result;
    }

    public boolean equalType(HttpMessage msg) {
        boolean result = false;
        if (!this.getRequestHeader().getMethod().equalsIgnoreCase(msg.getRequestHeader().getMethod())) {
            return false;
        }
        URI uri1 = this.getRequestHeader().getURI();
        URI uri2 = msg.getRequestHeader().getURI();
        try {
            if (uri1.getHost() == null || uri2.getHost() == null || !uri1.getHost().equalsIgnoreCase(uri2.getHost())) {
                return false;
            }
            if (uri1.getPort() != uri2.getPort()) {
                return false;
            }
            String path1 = uri1.getPath();
            String path2 = uri2.getPath();
            if (path1 == null && path2 == null) {
                return true;
            }
            if (path1 != null && path2 != null && !path1.equalsIgnoreCase(path2)) {
                return false;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            if (!this.queryEquals(msg)) {
                return false;
            }
            result = true;
        }
        catch (URIException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private boolean queryEquals(HttpMessage msg) {
        boolean result = false;
        TreeSet<String> set1 = null;
        TreeSet<String> set2 = null;
        set1 = this.getParamNameSet(HtmlParameter.Type.url);
        if (!((Object)set1).equals(set2 = msg.getParamNameSet(HtmlParameter.Type.url))) {
            return false;
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST") && !((Object)(set1 = this.getParamNameSet(HtmlParameter.Type.form))).equals(set2 = msg.getParamNameSet(HtmlParameter.Type.form))) {
            return false;
        }
        result = true;
        return result;
    }

    public TreeSet<String> getParamNameSet(HtmlParameter.Type type) {
        TreeSet<String> set = new TreeSet<String>();
        List<NameValuePair> paramList = Model.getSingleton().getSession().getParameters(this, type);
        for (NameValuePair nvp : paramList) {
            set.add(nvp.getName());
        }
        return set;
    }

    public List<String> getParameterNames(HtmlParameter.Type type) {
        ArrayList<String> list = new ArrayList<String>();
        Model.getSingleton().getSession().getParameters(this, type).forEach(nvp -> list.add(nvp.getName()));
        return list;
    }

    private TreeSet<HtmlParameter> getParamsSet(HtmlParameter.Type type) {
        TreeSet<HtmlParameter> set = new TreeSet<HtmlParameter>();
        List<NameValuePair> paramList = Model.getSingleton().getSession().getParameters(this, type);
        for (NameValuePair nvp : paramList) {
            set.add(new HtmlParameter(type, nvp.getName(), nvp.getValue()));
        }
        return set;
    }

    public List<HtmlParameter> getParameters(HtmlParameter.Type type) {
        ArrayList<HtmlParameter> list = new ArrayList<HtmlParameter>();
        Model.getSingleton().getSession().getParameters(this, type).forEach(nvp -> list.add(new HtmlParameter(type, nvp.getName(), nvp.getValue())));
        return list;
    }

    public String[] getParamNames() {
        Vector<String> v = new Vector<String>();
        TreeSet<String> pns = this.getParamNameSet(HtmlParameter.Type.url);
        for (String name : pns) {
            if (name == null) continue;
            v.add(name);
        }
        if (this.getRequestHeader().getMethod().equalsIgnoreCase("POST")) {
            pns = this.getParamNameSet(HtmlParameter.Type.form);
            for (String name : pns) {
                if (name == null) continue;
                v.add(name);
            }
        }
        String[] a = new String[v.size()];
        v.toArray(a);
        return a;
    }

    public TreeSet<HtmlParameter> getUrlParams() {
        return this.getParamsSet(HtmlParameter.Type.url);
    }

    public TreeSet<HtmlParameter> getFormParams() {
        String contentType = this.mReqHeader.getHeader("Content-Type");
        if (contentType == null || !StringUtils.startsWithIgnoreCase((String)contentType.trim(), (String)"application/x-www-form-urlencoded")) {
            return new TreeSet<HtmlParameter>();
        }
        return this.getParamsSet(HtmlParameter.Type.form);
    }

    public void setCookieParamsAsString(String data) {
        this.getRequestHeader().setHeader("Cookie", data);
    }

    public String getCookieParamsAsString() {
        LinkedList<String> cookies = new LinkedList<String>();
        if (!this.getRequestHeader().isEmpty()) {
            cookies.addAll(this.getRequestHeader().getHeaderValues("Cookie"));
        }
        if (!this.getResponseHeader().isEmpty()) {
            cookies.addAll(this.getResponseHeader().getHeaderValues("Set-Cookie"));
            cookies.addAll(this.getResponseHeader().getHeaderValues("Set-Cookie2"));
        }
        if (cookies.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String header : cookies) {
            sb.append(header);
        }
        return sb.toString();
    }

    public TreeSet<HtmlParameter> getCookieParams() {
        TreeSet<HtmlParameter> set = new TreeSet<HtmlParameter>();
        if (!this.getRequestHeader().isEmpty()) {
            set.addAll(this.getRequestHeader().getCookieParams());
        }
        if (!this.getResponseHeader().isEmpty()) {
            set.addAll(this.getResponseHeader().getCookieParams());
        }
        return set;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public HttpMessage cloneAll() {
        HttpMessage newMsg = this.cloneRequest();
        this.copyResponseInto(newMsg);
        return newMsg;
    }

    private void copyResponseInto(HttpMessage newMsg) {
        if (!this.getResponseHeader().isEmpty()) {
            try {
                newMsg.getResponseHeader().setMessage(this.getResponseHeader().toString());
            }
            catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                // empty catch block
            }
            newMsg.setResponseBody(this.getResponseBody().getBytes());
        }
    }

    public HttpMessage cloneRequest() {
        HttpMessage newMsg = new HttpMessage();
        this.copyRequestInto(newMsg);
        return newMsg;
    }

    private void copyRequestInto(HttpMessage newMsg) {
        if (!this.getRequestHeader().isEmpty()) {
            try {
                newMsg.getRequestHeader().setMessage(this.getRequestHeader().toString());
            }
            catch (HttpMalformedHeaderException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            newMsg.setRequestBody(this.getRequestBody().getBytes());
        }
    }

    public int getTimeElapsedMillis() {
        return this.timeElapsed;
    }

    public void setTimeElapsedMillis(int timeElapsed) {
        this.timeElapsed = timeElapsed;
    }

    public long getTimeSentMillis() {
        return this.timeSent;
    }

    public void setTimeSentMillis(long timeSent) {
        this.timeSent = timeSent;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void mutateHttpMethod(String method) {
        String header = this.getRequestHeader().toString();
        try {
            String query;
            HttpRequestHeader hrh = new HttpRequestHeader(header);
            URI uri = hrh.getURI();
            String body = this.getRequestBody().toString();
            String prevMethod = hrh.getMethod();
            if (prevMethod.equalsIgnoreCase(method)) {
                return;
            }
            if (prevMethod.equals("POST")) {
                if (body != null && body.length() > 0) {
                    String[] params;
                    StringBuilder sb = new StringBuilder();
                    if (uri.getQuery() != null) {
                        sb.append(uri.getQuery());
                    }
                    for (String param : params = body.split("&")) {
                        String[] nv;
                        if (sb.length() > 0) {
                            sb.append('&');
                        }
                        if ((nv = param.split("=")).length == 1) {
                            sb.append(nv[0]);
                            continue;
                        }
                        sb.append(param);
                    }
                    uri.setQuery(sb.toString());
                }
                hrh.setURI(uri);
                body = "";
            } else if (method.equals("POST") && (query = uri.getQuery()) != null) {
                String[] params;
                StringBuilder sb = new StringBuilder();
                for (String param : params = query.split("&")) {
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    sb.append(param);
                    String[] nv = param.split("=");
                    if (nv.length != 1) continue;
                    sb.append('=');
                }
                body = sb.toString();
                uri.setQuery(null);
                hrh.setURI(uri);
            }
            hrh.setMethod(method);
            this.getRequestHeader().setMessage(hrh.toString());
            this.getRequestBody().setBody(body);
        }
        catch (HttpMalformedHeaderException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (URIException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setFormParams(TreeSet<HtmlParameter> postParams) {
        this.mReqBody.setFormParams(postParams);
    }

    public void setGetParams(TreeSet<HtmlParameter> getParams) {
        this.mReqHeader.setGetParams(getParams);
    }

    public void setCookieParams(TreeSet<HtmlParameter> cookieParams) {
        this.mReqHeader.setCookieParams(cookieParams);
    }

    public boolean isWebSocketUpgrade() {
        if (!this.getResponseHeader().isEmpty()) {
            String connectionHeader = this.getResponseHeader().getHeader("connection");
            String upgradeHeader = this.getResponseHeader().getHeader("upgrade");
            if (connectionHeader != null && connectionHeader.equalsIgnoreCase("upgrade") && upgradeHeader != null && upgradeHeader.equalsIgnoreCase("websocket")) {
                return true;
            }
        }
        return false;
    }

    public void setCookies(List<HttpCookie> cookies) {
        this.mReqHeader.setCookies(cookies);
    }

    @Override
    public boolean isInScope() {
        return Model.getSingleton().getSession().isInScope(this.getRequestHeader().getURI().toString());
    }

    public boolean isEventStream() {
        boolean isEventStream = false;
        if (!this.getResponseHeader().isEmpty()) {
            isEventStream = this.getResponseHeader().hasContentType("text/event-stream");
        } else {
            String acceptHeader = this.getRequestHeader().getHeader("Accept");
            if (acceptHeader != null && acceptHeader.equals("text/event-stream")) {
                isEventStream = true;
            }
        }
        return isEventStream;
    }

    @Override
    public boolean isForceIntercept() {
        String vals = this.getRequestHeader().getHeader("X-Security-Proxy");
        if (vals != null) {
            for (String val : vals.split(",")) {
                if (!"intercept".equalsIgnoreCase(val.trim())) continue;
                return true;
            }
        }
        return this.forceIntercept;
    }

    public void setForceIntercept(boolean force) {
        this.forceIntercept = force;
    }

    public User getRequestingUser() {
        return this.requestUser;
    }

    public void setRequestingUser(User requestUser) {
        this.requestUser = requestUser;
    }

    public boolean isResponseFromTargetHost() {
        return this.responseFromTargetHost;
    }

    public void setResponseFromTargetHost(boolean responseFromTargetHost) {
        this.responseFromTargetHost = responseFromTargetHost;
    }

    @Override
    public Map<String, String> toEventData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(EVENT_DATA_URI, this.getRequestHeader().getURI().toString());
        map.put(EVENT_DATA_REQUEST_HEADER, this.getRequestHeader().toString());
        map.put(EVENT_DATA_REQUEST_BODY, this.getRequestBody().toString());
        if (!this.getResponseHeader().isEmpty()) {
            map.put(EVENT_DATA_RESPONSE_HEADER, this.getResponseHeader().toString());
            map.put(EVENT_DATA_RESPONSE_BODY, this.getResponseBody().toString());
        }
        return map;
    }

    @Override
    public String getType() {
        return MESSAGE_TYPE;
    }
}

