/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BS\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u0006\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0006H\u0002R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "T", "", "parent", "reserved", "", "", "sanitizer", "Lkotlin/Function1;", "mappedNames", "", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;Ljava/util/Set;Lkotlin/jvm/functions/Function1;Ljava/util/Map;)V", "finished", "", "getFinished", "()Z", "setFinished", "(Z)V", "getMappedNames", "()Ljava/util/Map;", "names", "getNames", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "getReserved", "()Ljava/util/Set;", "getSanitizer", "()Lkotlin/jvm/functions/Function1;", "declareFreshName", "declaration", "suggestedName", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "declareStableName", "", "name", "(Ljava/lang/Object;Ljava/lang/String;)V", "findFreshName", "isReserved", "backend.js"})
public final class NameTable<T> {
    @Nullable
    private final NameTable<?> parent;
    @NotNull
    private final Set<String> reserved;
    @NotNull
    private final Function1<String, String> sanitizer;
    @Nullable
    private final Map<String, String> mappedNames;
    private boolean finished;
    @NotNull
    private final Map<T, String> names;

    public NameTable(@Nullable NameTable<?> parent2, @NotNull Set<String> reserved, @NotNull Function1<? super String, String> sanitizer, @Nullable Map<String, String> mappedNames) {
        Intrinsics.checkNotNullParameter(reserved, "reserved");
        Intrinsics.checkNotNullParameter(sanitizer, "sanitizer");
        this.parent = parent2;
        this.reserved = reserved;
        this.sanitizer = sanitizer;
        this.mappedNames = mappedNames;
        boolean bl = false;
        this.names = new LinkedHashMap();
    }

    public /* synthetic */ NameTable(NameTable nameTable, Set set, Function1 function1, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            nameTable = null;
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        this(nameTable, set, function1, map);
    }

    @Nullable
    public final NameTable<?> getParent() {
        return this.parent;
    }

    @NotNull
    public final Set<String> getReserved() {
        return this.reserved;
    }

    @NotNull
    public final Function1<String, String> getSanitizer() {
        return this.sanitizer;
    }

    @Nullable
    public final Map<String, String> getMappedNames() {
        return this.mappedNames;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished(boolean bl) {
        this.finished = bl;
    }

    @NotNull
    public final Map<T, String> getNames() {
        return this.names;
    }

    private final boolean isReserved(String name) {
        if (this.parent != null && super.isReserved(name)) {
            return true;
        }
        return this.reserved.contains(name);
    }

    public final void declareStableName(T declaration2, @NotNull String name) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.parent != null) {
            bl3 = this.parent.finished;
            bl2 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl3) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
        }
        bl3 = !this.finished;
        bl2 = false;
        bl = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        Map<Object, String> map = this.names;
        bl2 = false;
        map.put(declaration2, name);
        this.reserved.add(name);
        map = this.mappedNames;
        if (map != null) {
            Map<Object, String> map2 = map;
            String string4 = NameTablesKt.access$mapToKey(declaration2);
            boolean bl6 = false;
            map2.put(string4, name);
        }
    }

    @NotNull
    public final String declareFreshName(T declaration2, @NotNull String suggestedName) {
        Intrinsics.checkNotNullParameter(suggestedName, "suggestedName");
        String freshName = this.findFreshName(this.sanitizer.invoke(suggestedName));
        this.declareStableName(declaration2, freshName);
        return freshName;
    }

    private final String findFreshName(String suggestedName) {
        if (!this.isReserved(suggestedName)) {
            return suggestedName;
        }
        Ref.IntRef i = new Ref.IntRef();
        while (this.isReserved(NameTable.findFreshName$freshName(suggestedName, i))) {
            int n = i.element;
            i.element = n + 1;
        }
        return NameTable.findFreshName$freshName(suggestedName, i);
    }

    private static final String findFreshName$freshName(String $suggestedName, Ref.IntRef i) {
        return $suggestedName + '_' + i.element;
    }

    public NameTable() {
        this(null, null, null, null, 15, null);
    }
}

