/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.CapturedArguments;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a \u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u001a\u001a\u0010\u000f\u001a\u00020\u000b*\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u00a8\u0006\u0011"}, d2={"captureArguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "status", "Lorg/jetbrains/kotlin/types/model/CaptureStatus;", "captureArgumentsForIntersectionType", "Lorg/jetbrains/kotlin/types/checker/CapturedArguments;", "Lorg/jetbrains/kotlin/types/KotlinType;", "captureFromArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "captureFromExpression", "prepareArgumentTypeRegardingCaptureTypes", "argumentType", "replaceArguments", "arguments", "descriptors"})
public final class NewCapturedTypeKt {
    @Nullable
    public static final UnwrappedType prepareArgumentTypeRegardingCaptureTypes(@NotNull UnwrappedType argumentType) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        return argumentType instanceof NewCapturedType ? null : NewCapturedTypeKt.captureFromExpression(argumentType);
    }

    @Nullable
    public static final UnwrappedType captureFromExpression(@NotNull UnwrappedType type2) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter(type2, "type");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (!(typeConstructor2 instanceof IntersectionTypeConstructor)) {
            return NewCapturedTypeKt.captureFromArguments(type2, CaptureStatus.FROM_EXPRESSION);
        }
        List<CapturedArguments> list2 = NewCapturedTypeKt.captureArgumentsForIntersectionType(type2);
        if (list2 == null) {
            return null;
        }
        List<CapturedArguments> capturedArgumentsByComponents = list2;
        if (type2 instanceof FlexibleType) {
            SimpleType lowerIntersectedType = IntersectionTypeKt.intersectTypes(NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, ((FlexibleType)type2).getLowerBound())).makeNullableAsSpecified(((FlexibleType)type2).getLowerBound().isMarkedNullable());
            SimpleType upperIntersectedType = IntersectionTypeKt.intersectTypes(NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, ((FlexibleType)type2).getUpperBound())).makeNullableAsSpecified(((FlexibleType)type2).getUpperBound().isMarkedNullable());
            unwrappedType = KotlinTypeFactory.flexibleType(lowerIntersectedType, upperIntersectedType);
        } else {
            unwrappedType = IntersectionTypeKt.intersectTypes(NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, type2)).makeNullableAsSpecified(type2.isMarkedNullable());
        }
        return unwrappedType;
    }

    @Nullable
    public static final SimpleType captureFromArguments(@NotNull SimpleType type2, @NotNull CaptureStatus status2) {
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter((Object)status2, "status");
        List<TypeProjection> list2 = NewCapturedTypeKt.captureArguments(type2, status2);
        if (list2 == null) {
            simpleType2 = null;
        } else {
            List<TypeProjection> list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List<TypeProjection> it = list3;
            boolean bl3 = false;
            simpleType2 = NewCapturedTypeKt.replaceArguments(type2, it);
        }
        return simpleType2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CapturedArguments> captureArgumentsForIntersectionType(KotlinType type2) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection;
        HashSet<Pair<Object, List<TypeProjection>>> set$iv;
        if (type2 instanceof FlexibleType) {
            List<KotlinType> typesToCapture = CollectionsKt.plus(NewCapturedTypeKt.captureArgumentsForIntersectionType$getTypesToCapture(((FlexibleType)type2).getLowerBound()), (Iterable)NewCapturedTypeKt.captureArgumentsForIntersectionType$getTypesToCapture(((FlexibleType)type2).getUpperBound()));
            Iterable $this$distinctBy$iv = typesToCapture;
            boolean $i$f$distinctBy = false;
            set$iv = new HashSet<Pair<Object, List<TypeProjection>>>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                KotlinType it = (KotlinType)e$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                FqName fqName2 = FlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(it);
                Pair<Object, List<TypeProjection>> key$iv = TuplesKt.to(fqName2 == null ? it.getConstructor() : fqName2, it.getArguments());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            collection = list$iv;
        } else {
            collection = type2.getConstructor().getSupertypes();
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNullExpressionValue(collection2, "if (type is FlexibleType) {\n            val typesToCapture = getTypesToCapture(type.lowerBound) + getTypesToCapture(type.upperBound)\n            typesToCapture.distinctBy { (FlexibleTypeBoundsChecker.getBaseBoundFqNameByMutability(it) ?: it.constructor) to it.arguments }\n        } else type.constructor.supertypes");
        Collection filteredTypesToCapture = collection2;
        boolean changed = false;
        HashSet<Pair<Object, List<TypeProjection>>> $this$mapNotNull$iv = (HashSet<Pair<Object, List<TypeProjection>>>)filteredTypesToCapture;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CapturedArguments capturedArguments;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType typeToCapture = (KotlinType)element$iv$iv;
            boolean bl2 = false;
            List<TypeProjection> list2 = NewCapturedTypeKt.captureArguments(typeToCapture.unwrap(), CaptureStatus.FROM_EXPRESSION);
            if (list2 == null) {
                capturedArguments = null;
            } else {
                List<TypeProjection> capturedArguments2 = list2;
                changed = true;
                Intrinsics.checkNotNullExpressionValue(typeToCapture, "typeToCapture");
                capturedArguments = new CapturedArguments(capturedArguments2, typeToCapture);
            }
            if (capturedArguments == null) continue;
            CapturedArguments capturedArguments3 = capturedArguments;
            boolean bl3 = false;
            boolean bl4 = false;
            CapturedArguments it$iv$iv = capturedArguments3;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List capturedArgumentsByTypes = (List)destination$iv$iv;
        if (!changed) {
            return null;
        }
        return capturedArgumentsByTypes;
    }

    private static final UnwrappedType captureFromArguments(UnwrappedType type2, CaptureStatus status2) {
        List<TypeProjection> list2 = NewCapturedTypeKt.captureArguments(type2, status2);
        if (list2 == null) {
            return null;
        }
        List<TypeProjection> capturedArguments = list2;
        return type2 instanceof FlexibleType ? KotlinTypeFactory.flexibleType(NewCapturedTypeKt.replaceArguments(((FlexibleType)type2).getLowerBound(), capturedArguments), NewCapturedTypeKt.replaceArguments(((FlexibleType)type2).getUpperBound(), capturedArguments)) : (UnwrappedType)NewCapturedTypeKt.replaceArguments(type2, capturedArguments);
    }

    private static final SimpleType replaceArguments(UnwrappedType $this$replaceArguments, List<? extends TypeProjection> arguments2) {
        return KotlinTypeFactory.simpleType$default($this$replaceArguments.getAnnotations(), $this$replaceArguments.getConstructor(), arguments2, $this$replaceArguments.isMarkedNullable(), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeProjection> captureArguments(UnwrappedType type2, CaptureStatus status2) {
        Object object;
        Iterable<KotlinType> $dstr$projection$parameter;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List<TypeProjection> arguments2;
        block12: {
            if (type2.getArguments().size() != type2.getConstructor().getParameters().size()) {
                return null;
            }
            arguments2 = type2.getArguments();
            Iterable $this$all$iv = arguments2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    TypeProjection it = (TypeProjection)element$iv2;
                    boolean bl2 = false;
                    if (it.getProjectionKind() == Variance.INVARIANT) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        Iterable iterable = arguments2;
        List<TypeParameterDescriptor> $i$f$all = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue($i$f$all, "type.constructor.parameters");
        Iterable $this$map$iv = CollectionsKt.zip(iterable, (Iterable)$i$f$all);
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeProjection typeProjection;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$a$-map-NewCapturedTypeKt$captureArguments$capturedArguments$22 = false;
            TypeProjection projection = (TypeProjection)((Pair)((Object)$dstr$projection$parameter)).component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)((Pair)((Object)$dstr$projection$parameter)).component2();
            if (projection.getProjectionKind() == Variance.INVARIANT) {
                typeProjection = projection;
            } else {
                UnwrappedType lowerType = !projection.isStarProjection() && projection.getProjectionKind() == Variance.IN_VARIANCE ? projection.getType().unwrap() : (UnwrappedType)null;
                Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
                typeProjection = TypeUtilsKt.asTypeProjection(new NewCapturedType(status2, lowerType, projection, parameter));
            }
            object = typeProjection;
            collection.add(object);
        }
        List capturedArguments = (List)destination$iv$iv;
        TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(type2.getConstructor(), capturedArguments).buildSubstitutor();
        int n = 0;
        int n2 = arguments2.size() + -1;
        if (n <= n2) {
            do {
                void destination$iv;
                Collection $this$mapTo$iv;
                int index2 = n++;
                TypeProjection oldProjection = arguments2.get(index2);
                TypeProjection newProjection = (TypeProjection)capturedArguments.get(index2);
                if (oldProjection.getProjectionKind() == Variance.INVARIANT) continue;
                $dstr$projection$parameter = type2.getConstructor().getParameters().get(index2).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue($dstr$projection$parameter, "type.constructor.parameters[index].upperBounds");
                $dstr$projection$parameter = $dstr$projection$parameter;
                boolean $i$a$-map-NewCapturedTypeKt$captureArguments$capturedArguments$22 = false;
                Collection $i$a$-map-NewCapturedTypeKt$captureArguments$capturedArguments$22 = new ArrayList();
                boolean $i$f$mapTo2 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    KotlinType kotlinType = (KotlinType)item$iv;
                    collection = destination$iv;
                    boolean bl3 = false;
                    object = NewKotlinTypeChecker.Companion.getDefault().transformToNewType(substitutor2.safeSubstitute((KotlinType)it, Variance.INVARIANT).unwrap());
                    collection.add(object);
                }
                List capturedTypeSupertypes = (List)destination$iv;
                if (!oldProjection.isStarProjection() && oldProjection.getProjectionKind() == Variance.OUT_VARIANCE) {
                    $this$mapTo$iv = capturedTypeSupertypes;
                    UnwrappedType unwrappedType = NewKotlinTypeChecker.Companion.getDefault().transformToNewType(oldProjection.getType().unwrap());
                    boolean bl4 = false;
                    $this$mapTo$iv.add(unwrappedType);
                }
                NewCapturedType capturedType = (NewCapturedType)newProjection.getType();
                capturedType.getConstructor().initializeSupertypes(capturedTypeSupertypes);
            } while (n <= n2);
        }
        return capturedArguments;
    }

    private static final List<TypeProjection> captureFromExpression$findCorrespondingCapturedArgumentsForType(List<CapturedArguments> capturedArgumentsByComponents, KotlinType type2) {
        Object v0;
        block1: {
            Iterable iterable = capturedArgumentsByComponents;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                CapturedArguments typeToCapture = (CapturedArguments)t;
                boolean bl3 = false;
                if (!typeToCapture.isSuitableForType(type2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        CapturedArguments capturedArguments = v0;
        return capturedArguments == null ? null : capturedArguments.getCapturedArguments();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SimpleType> captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(List<CapturedArguments> capturedArgumentsByComponents, UnwrappedType typeToReplace) {
        List list2;
        if (typeToReplace.getConstructor() instanceof IntersectionTypeConstructor) {
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection = typeToReplace.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, "typeToReplace.constructor.supertypes");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SimpleType simpleType2;
                void componentType;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(componentType, "componentType");
                List<TypeProjection> list3 = NewCapturedTypeKt.captureFromExpression$findCorrespondingCapturedArgumentsForType(capturedArgumentsByComponents, (KotlinType)componentType);
                if (list3 == null) {
                    simpleType2 = TypeSubstitutionKt.asSimpleType((KotlinType)componentType);
                } else {
                    List<TypeProjection> capturedArguments = list3;
                    simpleType2 = NewCapturedTypeKt.replaceArguments(componentType.unwrap(), capturedArguments);
                }
                SimpleType simpleType3 = simpleType2;
                collection2.add(simpleType3);
            }
            list2 = (List)destination$iv$iv;
        } else {
            List<TypeProjection> list4 = NewCapturedTypeKt.captureFromExpression$findCorrespondingCapturedArgumentsForType(capturedArgumentsByComponents, typeToReplace);
            if (list4 == null) {
                return CollectionsKt.listOf(TypeSubstitutionKt.asSimpleType(typeToReplace));
            }
            List<TypeProjection> capturedArguments = list4;
            list2 = CollectionsKt.listOf(NewCapturedTypeKt.replaceArguments(typeToReplace.unwrap(), capturedArguments));
        }
        return list2;
    }

    private static final Collection<KotlinType> captureArgumentsForIntersectionType$getTypesToCapture(KotlinType type2) {
        Collection<KotlinType> collection;
        if (type2.getConstructor() instanceof IntersectionTypeConstructor) {
            Collection<KotlinType> collection2 = type2.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection2, "type.constructor.supertypes");
            collection = collection2;
        } else {
            collection = (Collection<KotlinType>)CollectionsKt.listOf(type2);
        }
        return collection;
    }
}

