/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket.server;

import aQute.bnd.annotation.spi.ServiceConsumer;
import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.DefaultServerEndpointConfig;
import jakarta.websocket.server.HandshakeRequest;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public interface ServerEndpointConfig
extends EndpointConfig {
    public Class<?> getEndpointClass();

    public String getPath();

    public List<String> getSubprotocols();

    public List<Extension> getExtensions();

    public Configurator getConfigurator();

    @ServiceConsumer(value=Configurator.class)
    public static class Configurator {
        private static volatile Configurator defaultImpl = null;
        private static final Object defaultImplLock = new Object();
        private static final String DEFAULT_IMPL_CLASSNAME = "org.apache.tomcat.websocket.server.DefaultServerEndpointConfigurator";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Configurator fetchContainerDefaultConfigurator() {
            if (defaultImpl == null) {
                Object object = defaultImplLock;
                synchronized (object) {
                    if (defaultImpl == null) {
                        defaultImpl = System.getSecurityManager() == null ? Configurator.loadDefault() : AccessController.doPrivileged(new PrivilegedLoadDefault());
                    }
                }
            }
            return defaultImpl;
        }

        private static Configurator loadDefault() {
            Configurator configurator = null;
            ServiceLoader<Configurator> serviceLoader = ServiceLoader.load(Configurator.class);
            Iterator<Configurator> iterator = serviceLoader.iterator();
            while (configurator == null && iterator.hasNext()) {
                configurator = iterator.next();
            }
            if (configurator == null) {
                try {
                    Class<?> clazz = Class.forName(DEFAULT_IMPL_CLASSNAME);
                    configurator = (Configurator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                    // empty catch block
                }
            }
            return configurator;
        }

        public String getNegotiatedSubprotocol(List<String> list, List<String> list2) {
            return Configurator.fetchContainerDefaultConfigurator().getNegotiatedSubprotocol(list, list2);
        }

        public List<Extension> getNegotiatedExtensions(List<Extension> list, List<Extension> list2) {
            return Configurator.fetchContainerDefaultConfigurator().getNegotiatedExtensions(list, list2);
        }

        public boolean checkOrigin(String string) {
            return Configurator.fetchContainerDefaultConfigurator().checkOrigin(string);
        }

        public void modifyHandshake(ServerEndpointConfig serverEndpointConfig, HandshakeRequest handshakeRequest, HandshakeResponse handshakeResponse) {
            Configurator.fetchContainerDefaultConfigurator().modifyHandshake(serverEndpointConfig, handshakeRequest, handshakeResponse);
        }

        public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
            return Configurator.fetchContainerDefaultConfigurator().getEndpointInstance(clazz);
        }

        private static class PrivilegedLoadDefault
        implements PrivilegedAction<Configurator> {
            private PrivilegedLoadDefault() {
            }

            @Override
            public Configurator run() {
                return Configurator.loadDefault();
            }
        }
    }

    public static final class Builder {
        private final Class<?> endpointClass;
        private final String path;
        private List<Class<? extends Encoder>> encoders = Collections.emptyList();
        private List<Class<? extends Decoder>> decoders = Collections.emptyList();
        private List<String> subprotocols = Collections.emptyList();
        private List<Extension> extensions = Collections.emptyList();
        private Configurator configurator = Configurator.fetchContainerDefaultConfigurator();

        public static Builder create(Class<?> clazz, String string) {
            return new Builder(clazz, string);
        }

        private Builder(Class<?> clazz, String string) {
            this.endpointClass = clazz;
            this.path = string;
        }

        public ServerEndpointConfig build() {
            return new DefaultServerEndpointConfig(this.endpointClass, this.path, this.subprotocols, this.extensions, this.encoders, this.decoders, this.configurator);
        }

        public Builder encoders(List<Class<? extends Encoder>> list) {
            this.encoders = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder decoders(List<Class<? extends Decoder>> list) {
            this.decoders = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder subprotocols(List<String> list) {
            this.subprotocols = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder extensions(List<Extension> list) {
            this.extensions = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder configurator(Configurator configurator) {
            this.configurator = configurator == null ? Configurator.fetchContainerDefaultConfigurator() : configurator;
            return this;
        }
    }
}

