/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.Format;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class LivenessTableView
extends MemoryView {
    private MemoryTableModel tableModel;
    private ProfilerTable table;
    private int nTrackedItems;
    private ClientUtils.SourceCodeSelection[] classNames;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private long[] nTrackedAllocObjects;
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final boolean includeTotalAllocs;
    private boolean filterZeroItems = true;
    private HideableBarRenderer[] renderers;
    private NumberRenderer[] renderersEx;

    LivenessTableView(Set<ClientUtils.SourceCodeSelection> set, boolean bl) {
        this.selection = set;
        this.includeTotalAllocs = bl;
        this.initUI();
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    private void setData(final int n, final String[] stringArray, final int[] nArray, final long[] lArray, final long[] lArray2, final float[] fArray, final int[] nArray2, final int[] nArray3, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LivenessTableView.this.tableModel != null) {
                    LivenessTableView.this.nTrackedItems = n;
                    LivenessTableView.access$202(LivenessTableView.this, new ClientUtils.SourceCodeSelection[stringArray.length]);
                    for (int i = 0; i < LivenessTableView.this.classNames.length; ++i) {
                        ((LivenessTableView)LivenessTableView.this).classNames[i] = new ClientUtils.SourceCodeSelection(stringArray[i], "*", null);
                    }
                    LivenessTableView.access$302(LivenessTableView.this, nArray);
                    LivenessTableView.access$402(LivenessTableView.this, lArray);
                    LivenessTableView.access$502(LivenessTableView.this, lArray2);
                    LivenessTableView.access$602(LivenessTableView.this, fArray);
                    LivenessTableView.access$702(LivenessTableView.this, nArray2);
                    if (LivenessTableView.this.includeTotalAllocs) {
                        LivenessTableView.access$902(LivenessTableView.this, nArray3);
                    }
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    long l5 = 0L;
                    long l6 = 0L;
                    long l7 = 0L;
                    long l8 = 0L;
                    for (int i = 0; i < LivenessTableView.this.nTrackedItems; ++i) {
                        if (bl) {
                            l = Math.max(l, LivenessTableView.this.trackedLiveObjectsSize[i]);
                            l2 = Math.min(l2, LivenessTableView.this.trackedLiveObjectsSize[i]);
                            l3 = Math.max(l3, (long)LivenessTableView.this.nTrackedLiveObjects[i]);
                            l4 = Math.min(l4, (long)LivenessTableView.this.nTrackedLiveObjects[i]);
                            l5 = Math.max(l5, LivenessTableView.this.nTrackedAllocObjects[i]);
                            l6 = Math.min(l6, LivenessTableView.this.nTrackedAllocObjects[i]);
                            if (!LivenessTableView.this.includeTotalAllocs) continue;
                            l7 = Math.max(l7, (long)LivenessTableView.this.nTotalAllocObjects[i]);
                            l8 = Math.min(l8, (long)LivenessTableView.this.nTotalAllocObjects[i]);
                            continue;
                        }
                        l += LivenessTableView.this.trackedLiveObjectsSize[i];
                        l3 += (long)LivenessTableView.this.nTrackedLiveObjects[i];
                        l5 += LivenessTableView.this.nTrackedAllocObjects[i];
                        if (!LivenessTableView.this.includeTotalAllocs) continue;
                        l7 += (long)LivenessTableView.this.nTotalAllocObjects[i];
                    }
                    if (bl) {
                        LivenessTableView.this.renderers[0].setMaxValue(Math.max(Math.abs(l), Math.abs(l2)));
                        LivenessTableView.this.renderers[1].setMaxValue(Math.max(Math.abs(l3), Math.abs(l4)));
                        LivenessTableView.this.renderers[2].setMaxValue(Math.max(Math.abs(l5), Math.abs(l6)));
                        if (LivenessTableView.this.includeTotalAllocs) {
                            LivenessTableView.this.renderers[3].setMaxValue(Math.max(Math.abs(l7), Math.abs(l8)));
                        }
                    } else {
                        LivenessTableView.this.renderers[0].setMaxValue(l);
                        LivenessTableView.this.renderers[1].setMaxValue(l3);
                        LivenessTableView.this.renderers[2].setMaxValue(l5);
                        if (LivenessTableView.this.includeTotalAllocs) {
                            LivenessTableView.this.renderers[3].setMaxValue(l7);
                        }
                    }
                    LivenessTableView.this.renderers[0].setDiffMode(bl);
                    LivenessTableView.this.renderers[1].setDiffMode(bl);
                    LivenessTableView.this.renderers[2].setDiffMode(bl);
                    if (LivenessTableView.this.includeTotalAllocs) {
                        LivenessTableView.this.renderers[3].setDiffMode(bl);
                    }
                    LivenessTableView.this.renderersEx[0].setDiffMode(bl);
                    LivenessTableView.this.renderersEx[1].setDiffMode(bl);
                    LivenessTableView.this.tableModel.fireTableDataChanged();
                }
            }
        });
    }

    @Override
    public void setData(MemoryResultsSnapshot memoryResultsSnapshot, GenericFilter genericFilter, int n) {
        LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot = (LivenessMemoryResultsSnapshot)memoryResultsSnapshot;
        boolean bl = livenessMemoryResultsSnapshot instanceof LivenessMemoryResultsDiff;
        String[] stringArray = livenessMemoryResultsSnapshot.getClassNames();
        int[] nArray = livenessMemoryResultsSnapshot.getNTrackedLiveObjects();
        long[] lArray = livenessMemoryResultsSnapshot.getTrackedLiveObjectsSize();
        long[] lArray2 = livenessMemoryResultsSnapshot.getNTrackedAllocObjects();
        float[] fArray = livenessMemoryResultsSnapshot.getAvgObjectAge();
        int[] nArray2 = livenessMemoryResultsSnapshot.getMaxSurvGen();
        int[] nArray3 = livenessMemoryResultsSnapshot.getnTotalAllocObjects();
        int n2 = Math.min(livenessMemoryResultsSnapshot.getNProfiledClasses(), stringArray.length);
        n2 = Math.min(n2, nArray3.length);
        if (genericFilter == null) {
            this.filterZeroItems = !bl;
            this.setData(n2, stringArray, nArray, lArray, lArray2, fArray, nArray2, nArray3, bl);
        } else {
            int n3;
            this.filterZeroItems = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            ArrayList<Long> arrayList4 = new ArrayList<Long>();
            ArrayList<Float> arrayList5 = new ArrayList<Float>();
            ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
            for (n3 = 0; n3 < n2; ++n3) {
                if (!genericFilter.passes(stringArray[n3].replace('.', '/'))) continue;
                arrayList.add(stringArray[n3]);
                arrayList2.add(nArray[n3]);
                arrayList3.add(lArray[n3]);
                arrayList4.add(lArray2[n3]);
                arrayList5.add(Float.valueOf(fArray[n3]));
                arrayList6.add(nArray2[n3]);
            }
            n3 = arrayList.size();
            String[] stringArray2 = arrayList.toArray(new String[0]);
            int[] nArray4 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray4[i] = (Integer)arrayList2.get(i);
            }
            long[] lArray3 = new long[n3];
            for (int i = 0; i < n3; ++i) {
                lArray3[i] = (Long)arrayList3.get(i);
            }
            long[] lArray4 = new long[n3];
            for (int i = 0; i < n3; ++i) {
                lArray4[i] = (Long)arrayList4.get(i);
            }
            float[] fArray2 = new float[n3];
            for (int i = 0; i < n3; ++i) {
                fArray2[i] = ((Float)arrayList5.get(i)).floatValue();
            }
            int[] nArray5 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray5[i] = (Integer)arrayList6.get(i);
            }
            this.setData(n3, stringArray2, nArray4, lArray3, lArray4, fArray2, nArray5, nArray3, bl);
        }
    }

    @Override
    public void resetData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LivenessTableView.this.nTrackedItems = 0;
                LivenessTableView.access$202(LivenessTableView.this, null);
                LivenessTableView.access$302(LivenessTableView.this, null);
                LivenessTableView.access$402(LivenessTableView.this, null);
                LivenessTableView.access$502(LivenessTableView.this, null);
                LivenessTableView.access$602(LivenessTableView.this, null);
                LivenessTableView.access$702(LivenessTableView.this, null);
                LivenessTableView.access$902(LivenessTableView.this, null);
                LivenessTableView.this.renderers[0].setMaxValue(0L);
                LivenessTableView.this.renderers[1].setMaxValue(0L);
                LivenessTableView.this.renderers[2].setMaxValue(0L);
                if (LivenessTableView.this.includeTotalAllocs) {
                    LivenessTableView.this.renderers[3].setMaxValue(0L);
                }
                LivenessTableView.this.renderers[0].setDiffMode(false);
                LivenessTableView.this.renderers[1].setDiffMode(false);
                LivenessTableView.this.renderers[2].setDiffMode(false);
                if (LivenessTableView.this.includeTotalAllocs) {
                    LivenessTableView.this.renderers[3].setDiffMode(false);
                }
                LivenessTableView.this.renderersEx[0].setDiffMode(false);
                LivenessTableView.this.renderersEx[1].setDiffMode(false);
                LivenessTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_ALLOCATED_LIVE);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_ALLOCATED_LIVE);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        final int n = this.selection == null ? -1 : 0;
        this.tableModel = new MemoryTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return LivenessTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                LivenessTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                LivenessTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LivenessTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray2[2] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray2[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray2[4] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray2[5] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[6] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[8];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray3[3] = LIVE_COUNT_COLUMN_TOOLTIP;
            stringArray3[4] = ALLOC_COUNT_COLUMN_TOOLTIP;
            stringArray3[5] = AVG_AGE_COLUMN_TOOLTIP;
            stringArray3[6] = GENERATIONS_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[7] = TOTAL_ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        this.table.setMainColumn(1 + n);
        this.table.setFitWidthColumn(1 + n);
        this.table.setSortColumn(2 + n);
        this.table.setDefaultSortOrder(1 + n, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.table.setColumnVisibility(5 + n, false);
        if (this.includeTotalAllocs) {
            this.table.setColumnVisibility(7 + n, false);
        }
        this.table.addRowFilter(new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                return !LivenessTableView.this.filterZeroItems || ((Number)entry.getValue(4 + n)).intValue() > 0;
            }
        });
        this.renderers = new HideableBarRenderer[4];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[2] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[3] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        this.renderers[2].setMaxValue(12345678L);
        this.renderers[3].setMaxValue(12345678L);
        this.renderersEx = new NumberRenderer[2];
        this.renderersEx[0] = new NumberRenderer(){

            @Override
            protected String getValueString(Object object, int n, Format format) {
                if (object == null) {
                    return "-";
                }
                float f = ((Float)object).floatValue();
                String string = StringUtils.floatPerCentToString((float)f);
                if (this.renderingDiff && f >= 0.0f) {
                    string = '+' + string;
                }
                return string;
            }
        };
        this.renderersEx[1] = new NumberRenderer();
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer());
        }
        this.table.setColumnRenderer(1 + n, new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(2 + n, this.renderers[0]);
        this.table.setColumnRenderer(3 + n, this.renderers[1]);
        this.table.setColumnRenderer(4 + n, this.renderers[2]);
        this.table.setColumnRenderer(5 + n, this.renderersEx[0]);
        this.table.setColumnRenderer(6 + n, this.renderersEx[1]);
        if (this.includeTotalAllocs) {
            this.table.setColumnRenderer(7 + n, this.renderers[3]);
        }
        if (this.selection != null) {
            int n2 = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, n2 + 15);
        }
        this.table.setDefaultColumnWidth(2 + n, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(3 + n, this.renderers[1].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(4 + n, this.renderers[2].getMaxNoBarWidth());
        this.table.setDefaultColumnWidth(5 + n, this.renderers[2].getNoBarWidth() - 25);
        this.table.setDefaultColumnWidth(6 + n, this.renderers[2].getNoBarWidth() - 25);
        if (this.includeTotalAllocs) {
            this.table.setDefaultColumnWidth(7 + n, this.renderers[3].getMaxNoBarWidth());
        }
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        if (this.nTrackedItems == 0 || n == -1) {
            return null;
        }
        if (n >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.classNames[this.table.convertRowIndexToModel(n)];
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$202(LivenessTableView livenessTableView, ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        livenessTableView.classNames = sourceCodeSelectionArray;
        return sourceCodeSelectionArray;
    }

    static /* synthetic */ int[] access$302(LivenessTableView livenessTableView, int[] nArray) {
        livenessTableView.nTrackedLiveObjects = nArray;
        return nArray;
    }

    static /* synthetic */ long[] access$402(LivenessTableView livenessTableView, long[] lArray) {
        livenessTableView.trackedLiveObjectsSize = lArray;
        return lArray;
    }

    static /* synthetic */ long[] access$502(LivenessTableView livenessTableView, long[] lArray) {
        livenessTableView.nTrackedAllocObjects = lArray;
        return lArray;
    }

    static /* synthetic */ float[] access$602(LivenessTableView livenessTableView, float[] fArray) {
        livenessTableView.avgObjectAge = fArray;
        return fArray;
    }

    static /* synthetic */ int[] access$702(LivenessTableView livenessTableView, int[] nArray) {
        livenessTableView.maxSurvGen = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$902(LivenessTableView livenessTableView, int[] nArray) {
        livenessTableView.nTotalAllocObjects = nArray;
        return nArray;
    }

    private class MemoryTableModel
    extends AbstractTableModel {
        private final int columns;

        private MemoryTableModel() {
            this.columns = 6 + (LivenessTableView.this.selection == null ? 0 : 1) + (LivenessTableView.this.includeTotalAllocs ? 1 : 0);
        }

        @Override
        public String getColumnName(int n) {
            if (LivenessTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (n == 2) {
                return MemoryView.COLUMN_LIVE_BYTES;
            }
            if (n == 3) {
                return MemoryView.COLUMN_LIVE_OBJECTS;
            }
            if (n == 4) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (n == 5) {
                return MemoryView.COLUMN_AVG_AGE;
            }
            if (n == 6) {
                return MemoryView.COLUMN_GENERATIONS;
            }
            if (n == 7) {
                return MemoryView.COLUMN_TOTAL_ALLOCATED_OBJECTS;
            }
            if (n == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (LivenessTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return String.class;
            }
            if (n == 2) {
                return Long.class;
            }
            if (n == 3) {
                return Integer.class;
            }
            if (n == 4) {
                return Long.class;
            }
            if (n == 5) {
                return Float.class;
            }
            if (n == 6) {
                return Integer.class;
            }
            if (n == 7) {
                return Integer.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return LivenessTableView.this.nTrackedItems;
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (LivenessTableView.this.nTrackedItems == 0) {
                return null;
            }
            if (LivenessTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 1) {
                return LivenessTableView.this.classNames[n].getClassName();
            }
            if (n2 == 2) {
                return LivenessTableView.this.trackedLiveObjectsSize[n];
            }
            if (n2 == 3) {
                return LivenessTableView.this.nTrackedLiveObjects[n];
            }
            if (n2 == 4) {
                return LivenessTableView.this.nTrackedAllocObjects[n];
            }
            if (n2 == 5) {
                return Float.valueOf(LivenessTableView.this.avgObjectAge[n]);
            }
            if (n2 == 6) {
                return LivenessTableView.this.maxSurvGen[n];
            }
            if (n2 == 7) {
                return LivenessTableView.this.nTotalAllocObjects[n];
            }
            if (n2 == 0) {
                if (LivenessTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return LivenessTableView.this.selection.contains(LivenessTableView.this.classNames[n]);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (LivenessTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 0) {
                if (Boolean.FALSE.equals(object)) {
                    LivenessTableView.this.selection.remove(LivenessTableView.this.classNames[n]);
                } else {
                    LivenessTableView.this.selection.add(LivenessTableView.this.classNames[n]);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (LivenessTableView.this.selection == null) {
                ++n2;
            }
            return n2 == 0;
        }
    }
}

