/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingResultSet;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;
import org.apache.tomcat.dbcp.dbcp2.SQLExceptionList;
import org.apache.tomcat.dbcp.dbcp2.Utils;

public class DelegatingStatement
extends AbandonedTrace
implements Statement {
    private Statement statement;
    private DelegatingConnection<?> connection;
    private boolean closed = false;

    public DelegatingStatement(DelegatingConnection<?> delegatingConnection, Statement statement) {
        super(delegatingConnection);
        this.statement = statement;
        this.connection = delegatingConnection;
    }

    public void activate() throws SQLException {
        if (this.statement instanceof DelegatingStatement) {
            ((DelegatingStatement)this.statement).activate();
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.checkOpen();
        try {
            this.statement.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        try {
            this.statement.cancel();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(this.getClass().getName() + " with address: \"" + this.toString() + "\" is closed.");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        try {
            this.statement.clearBatch();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        try {
            List<AbandonedTrace> list;
            if (this.connection != null) {
                this.connection.removeTrace(this);
                this.connection = null;
            }
            if ((list = this.getTrace()) != null) {
                ResultSet[] resultSetArray;
                for (ResultSet resultSet : resultSetArray = list.toArray(Utils.EMPTY_RESULT_SET_ARRAY)) {
                    if (resultSet == null) continue;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        if (this.connection != null) {
                            this.connection.handleExceptionNoThrow(exception);
                        }
                        arrayList.add(exception);
                    }
                }
                this.clearTrace();
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception exception) {
                    if (this.connection != null) {
                        this.connection.handleExceptionNoThrow(exception);
                    }
                    arrayList.add(exception);
                }
            }
        }
        finally {
            this.closed = true;
            this.statement = null;
            if (!arrayList.isEmpty()) {
                throw new SQLExceptionList(arrayList);
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            Jdbc41Bridge.closeOnCompletion(this.statement);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return DelegatingResultSet.wrapResultSet(this, this.statement.executeQuery(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        this.setLastUsedInParent();
        try {
            return this.statement.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.getConnectionInternal();
    }

    protected DelegatingConnection<?> getConnectionInternal() {
        return this.connection;
    }

    public Statement getDelegate() {
        return this.statement;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getFetchSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this.statement.getGeneratedKeys());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    public Statement getInnermostDelegate() {
        Statement statement = this.statement;
        while (statement instanceof DelegatingStatement) {
            if (this != (statement = ((DelegatingStatement)statement).getDelegate())) continue;
            return null;
        }
        return statement;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this, this.statement.getResultSet());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this.connection == null) {
            throw sQLException;
        }
        this.connection.handleException(sQLException);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    protected boolean isClosedInternal() {
        return this.closed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        try {
            return Jdbc41Bridge.isCloseOnCompletion(this.statement);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        try {
            return this.statement.isPoolable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (clazz.isAssignableFrom(this.statement.getClass())) {
            return true;
        }
        return this.statement.isWrapperFor(clazz);
    }

    public void passivate() throws SQLException {
        if (this.statement instanceof DelegatingStatement) {
            ((DelegatingStatement)this.statement).passivate();
        }
    }

    protected void setClosedInternal(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setDelegate(Statement statement) {
        this.statement = statement;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    private void setLastUsedInParent() {
        if (this.connection != null) {
            this.connection.setLastUsed();
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.checkOpen();
        try {
            this.statement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public synchronized String toString() {
        return this.statement == null ? "NULL" : this.statement.toString();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this.statement.getClass())) {
            return clazz.cast(this.statement);
        }
        return this.statement.unwrap(clazz);
    }
}

