/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.DictionaryBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

final class Dictionary
extends DictionaryBase {
    public Dictionary() {
        this.tree = new char[10000];
        this.tree[this.size++] = 65535;
    }

    public Dictionary(char[] cArray) {
        super(cArray);
    }

    public long save(String string) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
        return file.length();
    }

    public void save(OutputStream outputStream) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
        for (int i = 0; i < this.size; ++i) {
            deflaterOutputStream.write(this.tree[i]);
            deflaterOutputStream.write(this.tree[i] >> 8);
        }
        deflaterOutputStream.flush();
        deflaterOutputStream.close();
    }

    public void load(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.load(fileInputStream);
    }

    public void load(InputStream inputStream) throws IOException {
        FilterInputStream filterInputStream = new InflaterInputStream(inputStream);
        filterInputStream = new BufferedInputStream(filterInputStream);
        this.size = 0;
        while (((InputStream)filterInputStream).available() > 0) {
            char c = (char)(((InputStream)filterInputStream).read() + (((InputStream)filterInputStream).read() << 8));
            this.checkSize(this.size + 1);
            this.tree[this.size++] = c;
        }
        ((InputStream)filterInputStream).close();
        this.trimToSize();
    }

    void trimToSize() {
        char[] cArray = new char[this.size];
        System.arraycopy(this.tree, 0, cArray, 0, this.size);
        this.tree = cArray;
    }

    public void add(String string) {
        this.idx = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.searchCharOrAdd(c);
            if (i == string.length() - 1) {
                int n = this.idx + 1;
                this.tree[n] = (char)(this.tree[n] | 0x8000);
                return;
            }
            int n = this.readIndex();
            this.idx = n == 0 ? this.createNewNode() : n;
        }
    }

    public char[] toArray() {
        char[] cArray = new char[this.size];
        System.arraycopy(this.tree, 0, cArray, 0, this.size);
        return cArray;
    }

    public int getDataSize() {
        return this.size;
    }

    private void searchCharOrAdd(char c) {
        if (c == '\uffff') {
            throw new RuntimeException("Invalid Character");
        }
        while (this.idx < this.size && this.tree[this.idx] < c) {
            this.idx += 3;
        }
        if (this.idx >= this.size) {
            throw new RuntimeException("Internal Error");
        }
        if (this.tree[this.idx] == c) {
            return;
        }
        this.insertChar(c);
    }

    private void insertChar(char c) {
        this.checkSize(this.size + 3);
        System.arraycopy(this.tree, this.idx, this.tree, this.idx + 3, this.size - this.idx);
        this.tree[this.idx] = c;
        this.tree[this.idx + 1] = '\u0000';
        this.tree[this.idx + 2] = '\u0000';
        this.size += 3;
        int n = 0;
        while (n < this.size) {
            if (this.tree[n] == '\uffff') {
                ++n;
                continue;
            }
            int n2 = (this.tree[n + 1] << 16) + this.tree[n + 2];
            int n3 = n2 & Integer.MAX_VALUE;
            if (n3 > this.idx) {
                this.tree[n + 1] = (char)((n2 += 3) >> 16);
                this.tree[n + 2] = (char)n2;
            }
            n += 3;
        }
    }

    private final int createNewNode() {
        this.checkSize(this.size + 1);
        int n = this.idx + 1;
        this.tree[n] = (char)(this.tree[n] | (char)(this.size >> 16));
        int n2 = this.idx + 2;
        this.tree[n2] = (char)(this.tree[n2] | (char)this.size);
        this.idx = this.size++;
        this.tree[this.idx] = 65535;
        return this.idx;
    }

    private final void checkSize(int n) {
        if (n > this.tree.length) {
            char[] cArray = new char[Math.max(n, 2 * this.tree.length)];
            System.arraycopy(this.tree, 0, cArray, 0, this.size);
            this.tree = cArray;
        }
    }
}

