/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.List;
import java.util.Map;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.diagram.DiagramDataProvider;
import net.sf.sdedit.diagram.DiagramDataProviderFactory;
import net.sf.sdedit.diagram.DiagramFactory;
import net.sf.sdedit.diagram.NullPaintDevice;
import net.sf.sdedit.diagram.PaintDevice;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.diagram.SequenceDiagramDataProvider;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.text.TextHandler;

public class SequenceDiagramFactory
implements DiagramFactory,
DiagramDataProviderFactory {
    private String text;
    private PaintDevice paintDevice;
    private DiagramDataProviderFactory providerFactory;
    private Diagram diagram;
    private DiagramDataProvider provider;

    public SequenceDiagramFactory(DiagramDataProviderFactory providerFactory, PaintDevice paintDevice) {
        this.providerFactory = providerFactory;
        this.paintDevice = paintDevice;
    }

    public SequenceDiagramFactory(String text, PaintDevice paintDevice) {
        this.paintDevice = paintDevice;
        this.providerFactory = this;
        this.text = text;
    }

    protected SequenceDiagram newDiagram(SequenceConfiguration configuration, DiagramDataProvider provider, PaintDevice paintDevice) {
        return new SequenceDiagram(configuration, (SequenceDiagramDataProvider)provider, paintDevice);
    }

    @Override
    public DiagramDataProvider createProvider() {
        return new TextHandler(this.text);
    }

    @Override
    public void generateDiagram(Configuration conf) throws DiagramError {
        SequenceConfiguration configuration = conf.cast(SequenceConfiguration.class);
        Map<Integer, List<String>> map = null;
        this.provider = this.providerFactory.createProvider();
        SequenceDiagram _diagram = this.newDiagram(configuration, this.provider, new NullPaintDevice());
        try {
            _diagram.generate(false);
        }
        catch (DiagramError diagramError) {
            // empty catch block
        }
        map = _diagram.makeReverseIdMap();
        this.provider = this.providerFactory.createProvider();
        this.diagram = this.newDiagram(configuration, this.provider, this.paintDevice);
        if (map != null) {
            ((SequenceDiagram)this.getDiagram()).setReverseIdMap(map);
        }
        this.diagram.generate();
    }

    @Override
    public DiagramDataProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    @Override
    public DiagramDataProvider getProvider() {
        return this.provider;
    }

    @Override
    public PaintDevice getPaintDevice() {
        return this.paintDevice;
    }

    @Override
    public Diagram getDiagram() {
        return this.diagram;
    }
}

