/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.callback;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public interface AuthnCallback {
    public UsernameResult usernamePrompt(String var1, boolean var2);

    public UserPasswordResult userPasswordPrompt(String var1, String var2, boolean var3);

    public SSLServerTrustResult sslServerTrustPrompt(String var1, SSLServerCertFailures var2, SSLServerCertInfo var3, boolean var4);

    public SSLClientCertResult sslClientCertPrompt(String var1, boolean var2);

    public SSLClientCertPassphraseResult sslClientCertPassphrasePrompt(String var1, boolean var2);

    public boolean allowStorePlaintextPassword(String var1);

    public boolean allowStorePlaintextPassphrase(String var1);

    public static final class SSLClientCertPassphraseResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SSLClientCertPassphraseResult(String string) {
            this.secret = string;
        }

        public SSLClientCertPassphraseResult(String string, boolean bl) {
            this.save = bl;
            this.secret = string;
        }
    }

    public static final class SSLClientCertResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SSLClientCertResult(String string) {
            this.identity = string;
        }

        public SSLClientCertResult(String string, boolean bl) {
            this.save = bl;
            this.identity = string;
        }
    }

    public static final class SSLServerTrustResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static SSLServerTrustResult reject() {
            return new SSLServerTrustResult(false, false);
        }

        public static SSLServerTrustResult acceptTemporarily() {
            return new SSLServerTrustResult(true, false);
        }

        public static SSLServerTrustResult acceptPermanently() {
            return new SSLServerTrustResult(true, true);
        }

        private SSLServerTrustResult(boolean bl, boolean bl2) {
            this.save = bl2;
            this.trust = bl;
        }
    }

    public static class SSLServerCertInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String subject;
        private String issuer;
        private Date validFrom;
        private Date validTo;
        private byte[] fingerprint;
        private List<String> hostnames;
        private String asciiCert;

        public String getSubject() {
            return this.subject;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public Date getValidFrom() {
            return this.validFrom;
        }

        public Date getValidTo() {
            return this.validTo;
        }

        public byte[] getFingerprint() {
            return this.fingerprint;
        }

        public List<String> getHostnames() {
            return this.hostnames;
        }

        public String getCert() {
            return this.asciiCert;
        }

        private SSLServerCertInfo(String string, String string2, long l, long l2, byte[] byArray, List<String> list, String string3) {
            this.subject = string;
            this.issuer = string2;
            this.validFrom = new Date(l);
            this.validTo = new Date(l2);
            this.fingerprint = byArray;
            this.hostnames = list;
            this.asciiCert = string3;
        }
    }

    public static class SSLServerCertFailures
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int NOT_YET_VALID = 1;
        private static final int EXPIRED = 2;
        private static final int CN_MISMATCH = 4;
        private static final int UNKNOWN_CA = 8;
        private static final int OTHER = 0x40000000;
        private static final int ALL_KNOWN = 0x4000000F;
        private int failures;

        public boolean notYetValid() {
            return (this.failures & 1) != 0;
        }

        public boolean expired() {
            return (this.failures & 2) != 0;
        }

        public boolean cnMismatch() {
            return (this.failures & 4) != 0;
        }

        public boolean unknownCA() {
            return (this.failures & 8) != 0;
        }

        public boolean other() {
            return (this.failures & 0x40000000) != 0 || (this.failures & 0xBFFFFFF0) != 0;
        }

        public int getFailures() {
            return this.failures;
        }

        private SSLServerCertFailures(int n) {
            int n2 = n & 0xBFFFFFF0;
            if (n2 != 0) {
                Logger logger = Logger.getLogger("org.apache.subversion.javahl");
                logger.warning(String.format("Unknown SSL certificate parsing failure flags: %1$x", n2));
            }
            this.failures = n;
        }
    }

    public static final class UserPasswordResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public UserPasswordResult(String string, String string2) {
            this.identity = string;
            this.secret = string2;
        }

        public UserPasswordResult(String string, String string2, boolean bl) {
            this.save = bl;
            this.identity = string;
            this.secret = string2;
        }
    }

    public static final class UsernameResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public UsernameResult(String string) {
            this.identity = string;
        }

        public UsernameResult(String string, boolean bl) {
            this.save = bl;
            this.identity = string;
        }
    }

    public static abstract class AuthnResult {
        protected boolean save = false;
        protected boolean trust = false;
        protected String identity = null;
        protected String secret = null;
    }
}

