"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const string_width_1 = __importDefault(require("string-width"));
const alignLeft = (subject, width) => {
    return subject + ' '.repeat(width);
};
const alignRight = (subject, width) => {
    return ' '.repeat(width) + subject;
};
const alignCenter = (subject, width) => {
    let halfWidth;
    halfWidth = width / 2;
    if (width % 2 === 0) {
        return ' '.repeat(halfWidth) + subject + ' '.repeat(halfWidth);
    }
    else {
        halfWidth = Math.floor(halfWidth);
        return ' '.repeat(halfWidth) + subject + ' '.repeat(halfWidth + 1);
    }
};
/**
 * Pads a string to the left and/or right to position the subject
 * text in a desired alignment within a container.
 */
exports.default = (subject, containerWidth, alignment) => {
    if (typeof subject !== 'string') {
        throw new TypeError('Subject parameter value must be a string.');
    }
    const subjectWidth = string_width_1.default(subject);
    if (subjectWidth > containerWidth) {
        throw new Error('Subject parameter value width cannot be greater than the container width.');
    }
    if (subjectWidth === 0) {
        return ' '.repeat(containerWidth);
    }
    const availableWidth = containerWidth - subjectWidth;
    if (alignment === 'left') {
        return alignLeft(subject, availableWidth);
    }
    if (alignment === 'right') {
        return alignRight(subject, availableWidth);
    }
    return alignCenter(subject, availableWidth);
};
