/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.history;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.AboHistoryController;
import mediathek.controller.history.MVUsedUrlModelHelper;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.models.NonEditableTableModel;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class PanelErledigteUrls
extends JPanel {
    protected final Daten daten = Daten.getInstance();
    protected AboHistoryController workList;
    protected JTable jTable1;
    protected JToggleButton jToggleButtonLaden;
    private JLabel jLabelSum;

    public PanelErledigteUrls() {
        this.initComponents();
        this.jTable1.addMouseListener(new BeobMausTabelle());
        this.initListeners();
    }

    protected void changeListHandler() {
        if (this.jToggleButtonLaden.isSelected()) {
            this.updateModelAndRecalculate(this.createDataModel());
        }
    }

    private void initListeners() {
        this.jToggleButtonLaden.addActionListener(e -> {
            if (this.jToggleButtonLaden.isSelected()) {
                this.updateModelAndRecalculate(this.createDataModel());
            } else {
                this.updateModelAndRecalculate(new NonEditableTableModel(null, MVUsedUrlModelHelper.TITLE_HEADER));
            }
        });
    }

    private void updateModelAndRecalculate(@NotNull TableModel model) {
        this.jTable1.setModel(model);
        this.setsum();
    }

    protected TableModel createDataModel() {
        Object[][] data = MVUsedUrlModelHelper.getObjectData(this.workList.getListeUrlsSortDate());
        return new NonEditableTableModel(data, MVUsedUrlModelHelper.TITLE_HEADER);
    }

    private void setsum() {
        if (this.jTable1.getRowCount() <= 0) {
            this.jLabelSum.setText("");
        } else {
            this.jLabelSum.setText("Anzahl: " + this.jTable1.getRowCount());
        }
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        JPanel panel1 = new JPanel();
        this.jToggleButtonLaden = new JToggleButton();
        this.jLabelSum = new JLabel();
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("0", "0"), new AC().grow().fill(), new AC().grow().fill().gap().fill()));
        jScrollPane1.setViewportView(this.jTable1);
        this.add((Component)jScrollPane1, new CC().cell(0, 0));
        panel1.setLayout(new MigLayout(new LC().insets("5 5 0 5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().fill()));
        this.jToggleButtonLaden.setText("Laden");
        panel1.add((Component)this.jToggleButtonLaden, new CC().cell(0, 0));
        this.jLabelSum.setHorizontalAlignment(4);
        panel1.add((Component)this.jLabelSum, new CC().cell(1, 0));
        this.add((Component)panel1, new CC().cell(0, 1));
    }

    class BeobMausTabelle
    extends MouseAdapter {
        BeobMausTabelle() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            Point p = evt.getPoint();
            int nr = PanelErledigteUrls.this.jTable1.rowAtPoint(p);
            if (nr >= 0) {
                PanelErledigteUrls.this.jTable1.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Url aus der Liste l\u00f6schen");
            item.addActionListener(e -> {
                int selectedTableRow = PanelErledigteUrls.this.jTable1.getSelectedRow();
                if (selectedTableRow != -1) {
                    String del = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(selectedTableRow), 3).toString();
                    PanelErledigteUrls.this.workList.urlAusLogfileLoeschen(del);
                }
            });
            jPopupMenu.add(item);
            item = new JMenuItem("URL kopieren");
            item.addActionListener(e -> {
                int selectedTableRow = PanelErledigteUrls.this.jTable1.getSelectedRow();
                if (selectedTableRow != -1) {
                    String url = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(selectedTableRow), 3).toString();
                    GuiFunktionen.copyToClipboard(url);
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

