/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.CatalogItemToolTip;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FurnitureCatalogTree
extends JTree
implements View {
    private final UserPreferences preferences;
    private TreeSelectionListener treeSelectionListener;
    private CatalogItemToolTip toolTip;

    public FurnitureCatalogTree(FurnitureCatalog furnitureCatalog) {
        this(furnitureCatalog, null);
    }

    public FurnitureCatalogTree(FurnitureCatalog furnitureCatalog, FurnitureCatalogController furnitureCatalogController) {
        this(furnitureCatalog, null, furnitureCatalogController);
    }

    public FurnitureCatalogTree(FurnitureCatalog furnitureCatalog, UserPreferences userPreferences, FurnitureCatalogController furnitureCatalogController) {
        this.preferences = userPreferences;
        float f = SwingTools.getResolutionScale();
        if (f != 1.0f) {
            this.setRowHeight(Math.round((float)this.getRowHeight() * f));
        }
        this.toolTip = new CatalogItemToolTip(true, userPreferences);
        this.setModel(new CatalogTreeModel(furnitureCatalog));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new CatalogCellRenderer());
        this.addDragListener();
        if (furnitureCatalogController != null) {
            this.updateTreeSelectedFurniture(furnitureCatalog, furnitureCatalogController);
            this.addSelectionListeners(furnitureCatalog, furnitureCatalogController);
            this.addMouseListeners(furnitureCatalogController);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addVerticalScrollBarAdjustmentListener();
        this.getActionMap().getParent().remove("selectAll");
    }

    private void addDragListener() {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private boolean canExport;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.canExport = SwingUtilities.isLeftMouseButton(mouseEvent) && FurnitureCatalogTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.canExport && FurnitureCatalogTree.this.getTransferHandler() != null) {
                    FurnitureCatalogTree.this.getTransferHandler().exportAsDrag(FurnitureCatalogTree.this, mouseEvent, 1);
                }
                this.canExport = false;
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    private void addSelectionListeners(final FurnitureCatalog furnitureCatalog, final FurnitureCatalogController furnitureCatalogController) {
        final SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureCatalogTree.this.updateTreeSelectedFurniture(furnitureCatalog, furnitureCatalogController);
            }
        };
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                furnitureCatalogController.removeSelectionListener(selectionListener);
                furnitureCatalogController.setSelectedFurniture(FurnitureCatalogTree.this.getSelectedFurniture());
                furnitureCatalogController.addSelectionListener(selectionListener);
            }
        };
        furnitureCatalogController.addSelectionListener(selectionListener);
        this.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
    }

    private void updateTreeSelectedFurniture(FurnitureCatalog furnitureCatalog, FurnitureCatalogController furnitureCatalogController) {
        if (this.treeSelectionListener != null) {
            this.getSelectionModel().removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.clearSelection();
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCatalogController.getSelectedFurniture()) {
            TreePath treePath = new TreePath(new Object[]{furnitureCatalog, catalogPieceOfFurniture.getCategory(), catalogPieceOfFurniture});
            this.addSelectionPath(treePath);
            this.scrollRowToVisible(this.getRowForPath(treePath));
        }
        if (this.treeSelectionListener != null) {
            this.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    private List<CatalogPieceOfFurniture> getSelectedFurniture() {
        ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>();
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                if (treePath.getPathCount() != 3) continue;
                arrayList.add((CatalogPieceOfFurniture)treePath.getLastPathComponent());
            }
        }
        return arrayList;
    }

    private void addMouseListeners(final FurnitureCatalogController furnitureCatalogController) {
        final Cursor cursor = new Cursor(12);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.getClickCount() == 2) {
                        TreePath treePath = FurnitureCatalogTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                        if (treePath != null && treePath.getLastPathComponent() instanceof CatalogPieceOfFurniture) {
                            furnitureCatalogController.modifySelectedFurniture();
                        }
                    } else {
                        URL uRL = this.getURLAt(mouseEvent.getPoint(), (JTree)mouseEvent.getSource());
                        if (uRL != null) {
                            SwingTools.showDocumentInBrowser(uRL);
                        }
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                final URL uRL = this.getURLAt(mouseEvent.getPoint(), (JTree)mouseEvent.getSource());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (uRL != null) {
                            FurnitureCatalogTree.this.setCursor(cursor);
                        } else {
                            FurnitureCatalogTree.this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
            }

            private URL getURLAt(Point point, JTree jTree) {
                CatalogPieceOfFurniture catalogPieceOfFurniture;
                String string;
                TreePath treePath = jTree.getPathForLocation(point.x, point.y);
                if (treePath != null && treePath.getLastPathComponent() instanceof CatalogPieceOfFurniture && (string = (catalogPieceOfFurniture = (CatalogPieceOfFurniture)treePath.getLastPathComponent()).getInformation()) != null) {
                    int n = jTree.getRowForPath(treePath);
                    JComponent jComponent = (JComponent)jTree.getCellRenderer().getTreeCellRendererComponent(jTree, catalogPieceOfFurniture, false, false, false, n, false);
                    jComponent.doLayout();
                    for (JEditorPane jEditorPane : SwingTools.findChildren(jComponent, JEditorPane.class)) {
                        String string2;
                        HTMLDocument hTMLDocument;
                        Element element;
                        AttributeSet attributeSet;
                        AttributeSet attributeSet2;
                        int n2;
                        Rectangle rectangle = jTree.getRowBounds(n);
                        point.x -= rectangle.x + jEditorPane.getX();
                        point.y -= rectangle.y + jEditorPane.getY();
                        if (point.x <= 0 || point.y <= 0 || (n2 = jEditorPane.viewToModel(point)) <= 0 || (attributeSet2 = (AttributeSet)(attributeSet = (element = (hTMLDocument = (HTMLDocument)jEditorPane.getDocument()).getCharacterElement(n2)).getAttributes()).getAttribute(HTML.Tag.A)) == null || (string2 = (String)attributeSet2.getAttribute(HTML.Attribute.HREF)) == null) continue;
                        try {
                            return new URL(string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                    }
                }
                return null;
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
    }

    private void addVerticalScrollBarAdjustmentListener() {
        this.addAncestorListener(new AncestorListener(){
            private AdjustmentListener adjustmentListener;

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Container container = FurnitureCatalogTree.this.getParent();
                if (container instanceof JViewport) {
                    JScrollPane jScrollPane = (JScrollPane)((JViewport)container).getParent();
                    this.adjustmentListener = SwingTools.createAdjustmentListenerUpdatingScrollPaneViewToolTip(jScrollPane);
                    jScrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (this.adjustmentListener != null) {
                    ((JScrollPane)((JViewport)FurnitureCatalogTree.this.getParent()).getParent()).getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
                    this.adjustmentListener = null;
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    @Override
    public JToolTip createToolTip() {
        if (this.toolTip.isTipTextComplete()) {
            return super.createToolTip();
        }
        this.toolTip.setComponent(this);
        return this.toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this.preferences != null && treePath != null && treePath.getPathCount() == 3) {
            this.toolTip.setCatalogItem((CatalogPieceOfFurniture)treePath.getLastPathComponent());
            return this.toolTip.getTipText();
        }
        return null;
    }

    private static class CatalogTreeModel
    implements TreeModel {
        private FurnitureCatalog catalog;
        private List<TreeModelListener> listeners;

        public CatalogTreeModel(FurnitureCatalog furnitureCatalog) {
            this.catalog = furnitureCatalog;
            this.listeners = new ArrayList<TreeModelListener>(2);
            furnitureCatalog.addFurnitureListener(new CatalogFurnitureListener(this));
        }

        @Override
        public Object getRoot() {
            return this.catalog;
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object instanceof FurnitureCatalog) {
                return ((FurnitureCatalog)object).getCategory(n);
            }
            return ((FurnitureCategory)object).getPieceOfFurniture(n);
        }

        @Override
        public int getChildCount(Object object) {
            if (object instanceof FurnitureCatalog) {
                return ((FurnitureCatalog)object).getCategoriesCount();
            }
            if (object instanceof FurnitureCategory) {
                return ((FurnitureCategory)object).getFurnitureCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof FurnitureCatalog) {
                return Collections.binarySearch(((FurnitureCatalog)object).getCategories(), (FurnitureCategory)object2);
            }
            return ((FurnitureCategory)object).getIndexOfPieceOfFurniture((CatalogPieceOfFurniture)object2);
        }

        @Override
        public boolean isLeaf(Object object) {
            return object instanceof CatalogPieceOfFurniture;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.remove(treeModelListener);
        }

        private void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeModelListener[] treeModelListenerArray;
            for (TreeModelListener treeModelListener : treeModelListenerArray = this.listeners.toArray(new TreeModelListener[this.listeners.size()])) {
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        private void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModelListener[] treeModelListenerArray;
            for (TreeModelListener treeModelListener : treeModelListenerArray = this.listeners.toArray(new TreeModelListener[this.listeners.size()])) {
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }

        private static class CatalogFurnitureListener
        implements CollectionListener<CatalogPieceOfFurniture> {
            private WeakReference<CatalogTreeModel> catalogTreeModel;

            public CatalogFurnitureListener(CatalogTreeModel catalogTreeModel) {
                this.catalogTreeModel = new WeakReference<CatalogTreeModel>(catalogTreeModel);
            }

            @Override
            public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                CatalogTreeModel catalogTreeModel = (CatalogTreeModel)this.catalogTreeModel.get();
                FurnitureCatalog furnitureCatalog = (FurnitureCatalog)collectionEvent.getSource();
                if (catalogTreeModel == null) {
                    furnitureCatalog.removeFurnitureListener(this);
                } else {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = collectionEvent.getItem();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            if (catalogPieceOfFurniture.getCategory().getFurnitureCount() == 1) {
                                catalogTreeModel.fireTreeNodesInserted(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog}, new int[]{Collections.binarySearch(furnitureCatalog.getCategories(), catalogPieceOfFurniture.getCategory())}, new Object[]{catalogPieceOfFurniture.getCategory()}));
                                break;
                            }
                            catalogTreeModel.fireTreeNodesInserted(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog, catalogPieceOfFurniture.getCategory()}, new int[]{collectionEvent.getIndex()}, new Object[]{catalogPieceOfFurniture}));
                            break;
                        }
                        case DELETE: {
                            if (catalogPieceOfFurniture.getCategory().getFurnitureCount() == 0) {
                                catalogTreeModel.fireTreeNodesRemoved(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog}, new int[]{-(Collections.binarySearch(furnitureCatalog.getCategories(), catalogPieceOfFurniture.getCategory()) + 1)}, new Object[]{catalogPieceOfFurniture.getCategory()}));
                                break;
                            }
                            catalogTreeModel.fireTreeNodesRemoved(new TreeModelEvent((Object)catalogTreeModel, new Object[]{furnitureCatalog, catalogPieceOfFurniture.getCategory()}, new int[]{collectionEvent.getIndex()}, new Object[]{catalogPieceOfFurniture}));
                        }
                    }
                }
            }
        }
    }

    private class CatalogCellRenderer
    extends JComponent
    implements TreeCellRenderer {
        private static final int DEFAULT_ICON_HEIGHT = 32;
        private Font defaultFont;
        private Font modifiablePieceFont;
        private DefaultTreeCellRenderer nameLabel;
        private JEditorPane informationPane;

        public CatalogCellRenderer() {
            this.setLayout(null);
            this.nameLabel = new DefaultTreeCellRenderer();
            this.informationPane = new JEditorPane("text/html", null);
            this.informationPane.setOpaque(false);
            this.informationPane.setEditable(false);
            this.informationPane.setBorder(null);
            this.add(this.nameLabel);
            this.add(this.informationPane);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            this.nameLabel.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (this.defaultFont == null) {
                this.defaultFont = this.nameLabel.getFont();
                object2 = "body { font-family: " + this.defaultFont.getFamily() + "; font-size: " + this.defaultFont.getSize() + "pt; margin: 0px; }";
                ((HTMLDocument)this.informationPane.getDocument()).getStyleSheet().addRule((String)object2);
                this.modifiablePieceFont = new Font(this.defaultFont.getFontName(), 2, this.defaultFont.getSize());
            }
            if (object instanceof FurnitureCategory) {
                this.nameLabel.setText(((FurnitureCategory)object).getName());
                this.nameLabel.setFont(this.defaultFont);
                this.informationPane.setVisible(false);
            } else if (object instanceof CatalogPieceOfFurniture) {
                object2 = (CatalogPieceOfFurniture)object;
                this.nameLabel.setText(((CatalogPieceOfFurniture)object2).getName());
                this.nameLabel.setIcon(this.getLabelIcon(jTree, ((CatalogPieceOfFurniture)object2).getIcon()));
                this.nameLabel.setFont(((CatalogPieceOfFurniture)object2).isModifiable() ? this.modifiablePieceFont : this.defaultFont);
                this.informationPane.setVisible(true);
                this.informationPane.setText(((CatalogPieceOfFurniture)object2).getInformation());
                Dimension dimension = this.informationPane.getPreferredSize();
                this.informationPane.setSize(dimension.width, 1000);
            }
            return this;
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.nameLabel.getPreferredSize();
            this.nameLabel.setSize(dimension);
            if (this.informationPane.isVisible()) {
                Dimension dimension2 = this.informationPane.getPreferredSize();
                int n = Math.max(0, (dimension.height - dimension2.height) / 2);
                if (this.nameLabel.getComponentOrientation().isLeftToRight()) {
                    this.informationPane.setBounds(dimension.width, n, dimension2.width, dimension.height);
                } else {
                    this.informationPane.setBounds(0, n, dimension2.width, dimension.height);
                    this.nameLabel.setLocation(dimension2.width + 2, 0);
                }
            } else {
                this.nameLabel.setLocation(0, 0);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.nameLabel.getPreferredSize();
            if (this.informationPane.isVisible()) {
                dimension.width += 2 + this.informationPane.getPreferredSize().width;
            }
            return dimension;
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void repaint(Rectangle rectangle) {
        }

        @Override
        public void repaint() {
        }

        private Icon getLabelIcon(JTree jTree, Content content) {
            return IconManager.getInstance().getIcon(content, this.getRowHeight(jTree), jTree);
        }

        private int getRowHeight(JTree jTree) {
            return jTree.isFixedRowHeight() ? jTree.getRowHeight() : 32;
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintChildren(graphics);
        }
    }
}

