/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.data;

import net.osmand.plus.api.SQLiteAPI;
import net.sourceforge.offroad.OsmWindow;

public abstract class SQLiteOpenHelper {
    private OsmWindow mCtx;
    private String mDatabaseName;
    private int mDatabaseVersion;

    public SQLiteOpenHelper(OsmWindow pCtx, String pDatabaseName, Object pObject, int pDatabaseVersion) {
        SQLiteAPI.SQLiteConnection db2;
        this.mCtx = pCtx;
        this.mDatabaseName = pDatabaseName;
        this.mDatabaseVersion = pDatabaseVersion;
        if (!this.mCtx.getSQLiteAPI().isDatabaseExistent(pDatabaseName)) {
            SQLiteAPI.SQLiteConnection db = this.getWritableDatabase();
            this.onCreate(db);
            db.setVersion(pDatabaseVersion);
            db.close();
        }
        if ((db2 = this.getWritableDatabase()).getVersion() != pDatabaseVersion) {
            this.onUpgrade(db2, db2.getVersion(), pDatabaseVersion);
            db2.setVersion(pDatabaseVersion);
        }
        db2.close();
    }

    public abstract void onCreate(SQLiteAPI.SQLiteConnection var1);

    public abstract void onUpgrade(SQLiteAPI.SQLiteConnection var1, int var2, int var3);

    public SQLiteAPI.SQLiteConnection getWritableDatabase() {
        return this.mCtx.getSQLiteAPI().getOrCreateDatabase(this.mDatabaseName, false);
    }

    public SQLiteAPI.SQLiteConnection getReadableDatabase() {
        return this.mCtx.getSQLiteAPI().getOrCreateDatabase(this.mDatabaseName, true);
    }
}

