from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female = (
        '{{first_name_female}} {{last_name}}',
        '{{first_name_unisex}} {{last_name}}',
        '{{prefix_female}} {{first_name_unisex}} {{last_name}}',
        '{{prefix_female}} {{first_name_female}} {{last_name}}',
    )
    formats_male = (
        '{{first_name_male}} {{last_name}}',
        '{{first_name_male}} {{middle_name}} {{last_name}}',
        '{{first_name_unisex}} {{middle_name}} {{last_name}}',
        '{{prefix_male}} {{first_name_male}} {{last_name}}',
    )
    formats = formats_female + formats_male

    # All the names are extracted from Odia Wikipedia by Soumendra Kumar Sahoo.
    # 1. https://or.wikipedia.org/s/1duk and
    # 2. https://or.wikipedia.org/s/3vz
    first_names_female = (
        'ଅଜୟନ୍ତୀ',
        'ଅଞ୍ଜଳି',
        'ଅନିଶା',
        'ଅନୀତା',
        'ଅନୁ',
        'ଅନୁପ୍ରିୟା',
        'ଅନୁଭା',
        'ଅପରାଜିତା',
        'ଅମିତା',
        'ଅମିୟବାଳା',
        'ଅର୍ଚ୍ଚିତା',
        'ଅର୍ପିତା',
        'ଅସୀମା',
        'ଆଞ୍ଚଲ',
        'ଆନିଷା',
        'ଆମେଲି',
        'ଇନ୍ଦୁ',
        'ଇନ୍ଦୁରାଣୀ',
        'ଇନ୍ଦ୍ରାଣୀ',
        'ଇରାନି',
        'ଇଲା',
        'ଉଷସୀ',
        'ଉଷା',
        'ଏଲିନା',
        'କନକଲତା',
        'କବିତା',
        'କମଳା',
        'କଲ୍ୟାଣୀ',
        'କାଜଲ',
        'କୁମୁଦ',
        'କୁସୁମ',
        'କୋଏଲ',
        'ଗାର୍ଗୀ',
        'ଗାୟତ୍ରୀବାଳା',
        'ଗୀତା',
        'ଗୁନ୍ ଗୁନ୍',
        'ଗୌରୀ',
        'ଗ୍ଲୋରିଆ',
        'ଚନ୍ଦ୍ରମା',
        'ଛବି',
        'ଜିନା',
        'ଜ୍ୟୋତିର୍ମୟୀ',
        'ଜ୍ୟୋତ୍ସ୍ନା',
        'ଜୟନ୍ତୀ',
        'ଝରଣା',
        'ଝିଲିକ୍',
        'ଟୁକୁନି',
        'ତନ୍ଦ୍ରା',
        'ତମନ୍ନା',
        'ତୃପ୍ତି',
        'ତ୍ରିପୁରା',
        'ଦୀପା',
        'ଦୀପ୍ତିରେଖା',
        'ଦେବଯାନୀ',
        'ଦେବୀ',
        'ନନ୍ଦିତା',
        'ନନ୍ଦିନୀ',
        'ନମିତା',
        'ନମ୍ରତା',
        'ନଳିନୀ',
        'ନାଜିଆ',
        'ନିକିତା',
        'ନିବେଦିତା',
        'ନିର୍ମଳା',
        'ନିହାରିକା',
        'ନୀତୁ',
        'ନୈନା',
        'ପଦ୍ମିନୀ',
        'ପାର୍ବତୀ',
        'ପିଙ୍କି',
        'ପୁନମ',
        'ପୁପୁଲ',
        'ପୁଷ୍ପା',
        'ପ୍ରକୃତି',
        'ପ୍ରତିଜ୍ଞା',
        'ପ୍ରମିଳା',
        'ପ୍ରିୟଙ୍କା',
        'ପ୍ରିୟମ୍ବଦା',
        'ପ୍ରିୟା',
        'ପ୍ରେମଲତା',
        'ଫୁଲମଣି',
        'ବନଜା',
        'ବନ୍ଦିତା',
        'ବବ୍ଲି',
        'ବର୍ଣ୍ଣାଳୀ',
        'ବର୍ଷା',
        'ବାସନ୍ତି',
        'ବାସନ୍ତୀ',
        'ବିଜୟଲକ୍ଷ୍ମୀ',
        'ବିଜୟିନୀ',
        'ବିଦୁସ୍ମିତା',
        'ବିନୋଦିନୀ',
        'ବିରଜା',
        'ବିଷ୍ଣୁପ୍ରିୟା',
        'ବୀଣା',
        'ବୈଶାଳୀ',
        'ଭଗବତୀ',
        'ଭବାନୀ',
        'ଭାନୁମତୀ',
        'ଭାସ୍ୱତୀ',
        'ଭୂମିକା',
        'ମଙ୍ଗଳା',
        'ମଞ୍ଜୁଲତା',
        'ମଞ୍ଜୁଳା',
        'ମଣିମାଳା',
        'ମନ୍ଦାକିନୀ',
        'ମମତା',
        'ମହାଶ୍ୱେତା',
        'ମାଧୁରୀ',
        'ମାମିନା',
        'ମିନତି',
        'ମିନାକ୍ଷୀ',
        'ମେଘନା',
        'ମେଘା',
        'ଯଶୋଦା',
        'ରଚନା',
        'ରଜନୀ',
        'ରଞ୍ଜିତା',
        'ରତ୍ନପ୍ରଭା',
        'ରଶ୍ମୀରେଖା',
        'ରାକ୍ଷୀ',
        'ରାଜଶ୍ରୀ',
        'ରାଧାରାଣୀ',
        'ରାଲି',
        'ରାସମଞ୍ଜରୀ',
        'ରାସେଶ୍ୱରୀ',
        'ରିନା',
        'ରିୟା',
        'ରୀତା',
        'ରୀତାରାଣୀ',
        'ରୁକ୍ମଣୀ',
        'ରୁନୁ',
        'ରୋଜା',
        'ରୋଷନୀ',
        'ରୋସନାରା',
        'ଲକ୍ଷ୍ମୀ',
        'ଲକ୍ଷ୍ମୀପ୍ରିୟା',
        'ଲତିକା',
        'ଲିପି',
        'ଲିପିକା',
        'ଲିପ୍ସା',
        'ଲୀଳା',
        'ଲେଖା',
        'ଲେସ୍ଲି',
        'ଶିବାନୀ',
        'ଶୀତଲ',
        'ଶୁଭଶ୍ରୀ',
        'ଶେଫାଳୀ',
        'ଶୈରିନ୍ଦ୍ରୀ',
        'ଶ୍ରୀମତି',
        'ଶ୍ରୀମତୀ',
        'ସଂଘମିତ୍ରା',
        'ସଞ୍ଚିତା',
        'ସନ୍ମିରା',
        'ସରସ୍ୱତୀ',
        'ସସ୍ମିତା',
        'ସାବିତ୍ରୀ',
        'ସିପ୍ରା',
        'ସୀମାରାଣୀ',
        'ସୁଚିତ୍ରା',
        'ସୁଜାତା',
        'ସୁନନ୍ଦା',
        'ସୁପ୍ରିୟା',
        'ସୁମନୀ',
        'ସୁରମା',
        'ସୋନିକା',
        'ସୋଫିଆ',
        'ସୌଦାମିନୀ',
        'ସୌମ୍ୟା',
        'ସ୍ନିଗ୍ଧା',
        'ସ୍ନେହାଙ୍ଗିନୀ',
        'ସ୍ମିତା',
        'ସ୍ୱାଗତିକା',
    )
    first_names_unisex = (
        'ଅଶ୍ୱିନୀ',
        'ଅଶ୍ୱିନୀ',
        'କବି',
        'ଗୀତା',
        'ଜ୍ୟୋତି',
        'ଦୁର୍ଗା',
        'ଦେବୀ',
        'ପଦ୍ମ',
        'ପୁପୁଲ',
        'ପ୍ରିୟଦର୍ଶୀ',
        'ମକର',
        'ମଙ୍ଗଳା',
        'ମୌସଦୀ',
        'ରତି',
        'ରଶ୍ମି',
        'ଶାନ୍ତି',
        'ସିମନ୍',
        'ସୁଧାଂଶୁମାଳିନୀ',
        'ସୁମନ',
        'ସ୍ନିତି',
    )
    first_names_male = (
        'ଅଂଶୁମାନ',
        'ଅକ୍ଷୟ',
        'ଅଖିଳ',
        'ଅଗସ୍ତି',
        'ଅଙ୍ଗଦ',
        'ଅଚ୍ୟୁତାନନ୍ଦ',
        'ଅଜିତ',
        'ଅଜୟ',
        'ଅତନୁ',
        'ଅଦ୍ୱୈତ',
        'ଅଧିରାଜ',
        'ଅନନ୍ତ',
        'ଅନାଦି',
        'ଅନାଦୀ',
        'ଅନିରୁଦ୍ଧ',
        'ଅନିଲ',
        'ଅନୀଲ',
        'ଅନୁଭବ',
        'ଅନ୍ତର୍ଯ୍ୟାମୀ',
        'ଅପୂର୍ବ',
        'ଅଭିନ୍ନ',
        'ଅଭିମନ୍ୟୁ',
        'ଅଭିରାମ',
        'ଅଭିଷେକ',
        'ଅଭୟ',
        'ଅମର',
        'ଅମରନାଥ',
        'ଅମରେନ୍ଦ୍ର',
        'ଅମିନୂଲ',
        'ଅମ୍ଳାନ',
        'ଅରକ୍ଷିତ',
        'ଅରବିନ୍ଦ',
        'ଅରିନ୍ଦମ',
        'ଅରୁଣ',
        'ଅର୍କ',
        'ଅର୍ଜୁନ',
        'ଅଲେଖ',
        'ଅଶୋକ',
        'ଅଶ୍ରୁମୋଚନ',
        'ଅସୀତ',
        'ଆକାଶ',
        'ଆକୁଳାନନ୍ଦ',
        'ଆଦିତ୍ୟ',
        'ଆନନ୍ଦ',
        'ଆପଲସ୍ୱାମୀ',
        'ଆରତି',
        'ଆର୍ଯ୍ୟନ',
        'ଆଲୋକ',
        'ଆଶ୍ରିତ',
        'ଆସଫ',
        'ଇତିସ',
        'ଇନ୍ଦ୍ରମଣି',
        'ଇରାଶିଷ',
        'ଇଶ୍ୱର',
        'ଉତ୍କଳ',
        'ଉତ୍ତମ',
        'ଉତ୍ସବ',
        'ଉଧାର',
        'ଉପେନ୍ଦ୍ର',
        'ଉପେନ୍ଦ୍ରନାଥ',
        'ଉମାକାନ୍ତ',
        'ଉମାବଲ୍ଲଭ',
        'ଉମାଶଙ୍କର',
        'ଓଡ଼ିଆ',
        'ଓମପ୍ରକାଶ',
        'ଓମ୍',
        'କନକବର୍ଦ୍ଧନ',
        'କପିଳ',
        'କମଳାକାନ୍ତ',
        'କରୁଣାକର',
        'କରେନ୍ଦ୍ର',
        'କଳିଙ୍ଗ',
        'କଳ୍ପତରୁ',
        'କହ୍ନେଇ',
        'କାଙ୍ଗାଳି',
        'କାଙ୍ଗୋଇ',
        'କାର୍ତ୍ତିକ',
        'କାର୍ତ୍ତିକେଶ୍ୱର',
        'କାଳନ୍ଦୀ',
        'କାଳିଆ',
        'କାଳୁଖଣ୍ଡାୟତ',
        'କାଶୀନାଥ',
        'କାହ୍ନୁ',
        'କାହ୍ନୁରାମ',
        'କିରଣ',
        'କିଶୋରଚନ୍ଦ୍ର',
        'କିଶୋରୀମଣି',
        'କୁଞ୍ଜବିହାରୀ',
        'କୁଣାଳ',
        'କୁନା',
        'କୁମୁଦ',
        'କୁଳମଣି',
        'କୃଷ୍ଣ',
        'କୃଷ୍ଣଚନ୍ଦ୍ର',
        'କେଦାର',
        'କେଦାରନାଥ',
        'କେଶବ',
        'କୈଳାଶ',
        'କୈଳାସ',
        'କ୍ଷୀରୋଦ',
        'କ୍ଷେତ୍ର',
        'ଖଗେଶ୍ୱର',
        'ଖାରବେଳ',
        'ଗଙ୍ଗାଧର',
        'ଗଣେଶରାମ',
        'ଗଣେଶ୍ୱର',
        'ଗଦାଧର',
        'ଗିରିଜା',
        'ଗିରିଶ',
        'ଗିରୀଶ',
        'ଗୁରୁ',
        'ଗୁରୁକୃଷ୍ଣ',
        'ଗୁରୁଚରଣ',
        'ଗୈାତମ',
        'ଗୋକୁଳାନନ୍ଦ',
        'ଗୋପନାରାୟଣ',
        'ଗୋପାଳ',
        'ଗୋପାଳବଲ୍ଲଭ',
        'ଗୋପୀନାଥ',
        'ଗୋବିନ୍ଦ',
        'ଗୋଲକ',
        'ଗୌତମ',
        'ଗୌର',
        'ଗୌରହରି',
        'ଘଣ୍ଟେଶ୍ୱର',
        'ଘନଶ୍ୟାମ',
        'ଘାସିରାମ',
        'ଚକ୍ରଧର',
        'ଚକ୍ରମଣି',
        'ଚନ୍ଦନ',
        'ଚନ୍ଦ୍ରମଣି',
        'ଚନ୍ଦ୍ରଶେଖର',
        'ଚନ୍ଦ୍ରସେନ',
        'ଚିତରଂଜନ',
        'ଚିତ୍ତରଞ୍ଜନ',
        'ଚିନ୍ତାମଣି',
        'ଚିନ୍ମୟ',
        'ଚିରଂଜୀବ',
        'ଚୈତନ୍ୟ',
        'ଛତିଶ',
        'ଛୋଟରାୟ',
        'ଜଗତେଶ୍ୱର',
        'ଜଗଦାନନ୍ଦ',
        'ଜଗଦିଶ',
        'ଜଗନ୍ନାଥ',
        'ଜଗବନ୍ଧୁ',
        'ଜନାର୍ଦନ',
        'ଜର୍ଜ',
        'ଜଲାଲ',
        'ଜିତୁ',
        'ଜୀବନ',
        'ଜୀବନାନନ୍ଦ',
        'ଜ୍ଞାନ',
        'ଜ୍ୟୋତି',
        'ଜ୍ୟୋତିନ୍ଦ୍ର',
        'ଜ୍ୟୋତିପ୍ରକାଶ',
        'ଜ୍ୟୋତିରିନ୍ଦ୍ର',
        'ଜୟକୃଷ୍ଣ',
        'ଜୟଦେବ',
        'ଜୟନାରାୟଣ',
        'ଜୟନ୍ତ',
        'ଜୟରାମ',
        'ଜୟୀରାମ',
        'ଝିନ୍ନ',
        'ତନ୍ମୟ',
        'ତପନ',
        'ତପୁ',
        'ତାନସେନ',
        'ତାରାପ୍ରସାଦ',
        'ତୁଷାରକାନ୍ତି',
        'ତ୍ରିନାଥ',
        'ତ୍ରିଲୋଚନ',
        'ଦାମୋଦର',
        'ଦାଶରଥୀ',
        'ଦିଗମ୍ବର',
        'ଦିନେଶ',
        'ଦିବାକରନାଥ',
        'ଦିବ୍ୟଶଙ୍କର',
        'ଦିଲୀପ',
        'ଦିଲ୍ଲୀପ',
        'ଦୀନବନ୍ଧୁ',
        'ଦୀପକ',
        'ଦୀପ୍ତିରଞ୍ଜନ',
        'ଦୁଃଖୀରାମ',
        'ଦୁଃଶାସନ',
        'ଦୁତିଅ',
        'ଦୁର୍ଯ୍ୟୋଧନ',
        'ଦୁର୍ଲଭ',
        'ଦୁଷ୍ମନ୍ତ',
        'ଦେବଦାସ',
        'ଦେବନାରାୟଣ',
        'ଦେବରାଜ',
        'ଦେବାଶିଷ',
        'ଦେବୀରଞ୍ଜନ',
        'ଦେବୁ',
        'ଦେବେନ',
        'ଦେବେନ୍ଦ୍ର',
        'ଦେବେନ୍ଦ୍ରନାଥ',
        'ଦେବେଶ',
        'ଦୈତାରି',
        'ଦୈତାରୀ',
        'ଦୋଳଗୋବିନ୍ଦ',
        'ଧନଞ୍ଜୟ',
        'ଧନୁର୍ଜୟ',
        'ଧନେଶ୍ୱର',
        'ଧରଣୀଧର',
        'ଧର୍ମାନନ୍ଦ',
        'ଧାମରାଜ',
        'ଧୀର',
        'ଧୃବ',
        'ଧ୍ରୁବ',
        'ନଗେନ',
        'ନଗେନ୍ଦ୍ର',
        'ନଟରାଜ',
        'ନନ୍ଦକିଶୋର',
        'ନବ',
        'ନବକିଶୋର',
        'ନବଘନ',
        'ନବଜ୍ୟୋତି',
        'ନବୀନ',
        'ନରସିଂ',
        'ନରସିଂହ',
        'ନରେନ',
        'ନରେନ୍ଦ୍ର',
        'ନାଉରୀ',
        'ନିଜାମ',
        'ନିତାଇ',
        'ନିତ୍ୟାନନ୍ଦ',
        'ନିପନ୍',
        'ନିରଞ୍ଜନ',
        'ନିହାର',
        'ନୀରଦ',
        'ନୀଳମଣୀ',
        'ନୀଳମାଧବ',
        'ନୀଳାଦ୍ରି',
        'ନୀଳାମ୍ବର',
        'ନୃସିଂହ',
        'ନେତ୍ରାନନ୍ଦ',
        'ନୟନ',
        'ପଞ୍ଚାନନ',
        'ପଠାଣି',
        'ପଦ',
        'ପଦ୍ମଚରଣ',
        'ପଦ୍ମନ',
        'ପଦ୍ମନାଭ',
        'ପଦ୍ମଲୋଚନ',
        'ପପୁ',
        'ପବିତ୍ର',
        'ପରମା',
        'ପରମାନନ୍ଦ',
        'ପରମେଶ୍ୱର',
        'ପର୍ଶୁରାମ',
        'ପାଟ୍ଟ',
        'ପାଡୁ',
        'ପାଣୁ',
        'ପିଣ୍ଟୁ',
        'ପିଣ୍ଡାକୀ',
        'ପୀତାମ୍ବର',
        'ପୁଣ୍ୟପ୍ରଭା',
        'ପୁପିନ୍ଦର',
        'ପୁରୁଷୋତ୍ତମ',
        'ପୂର୍ଣଚନ୍ଦ୍ର',
        'ପୂର୍ଣ୍ଣଚନ୍ଦ୍ର',
        'ପୂର୍ଣ୍ଣବାସୀ',
        'ପୂର୍ଣ୍ଣାନନ୍ଦ',
        'ପୃଥ୍ୱୀରାଜ',
        'ପ୍ରଜ୍ଞାନ',
        'ପ୍ରଣବ',
        'ପ୍ରଦିପ୍ତ',
        'ପ୍ରଦୀପ୍ତ',
        'ପ୍ରଦ୍ୟୁମ୍ନ',
        'ପ୍ରଫୁଲ',
        'ପ୍ରଫୁଲ୍ଲ',
        'ପ୍ରଫେସର',
        'ପ୍ରବୀଣ',
        'ପ୍ରଭାକର',
        'ପ୍ରଭାତ',
        'ପ୍ରଭାସ',
        'ପ୍ରଭୁ',
        'ପ୍ରମୋଦ',
        'ପ୍ରଶାନ୍ତ',
        'ପ୍ରହଲ୍ଲାଦ',
        'ପ୍ରାଣ',
        'ପ୍ରିୟନାଥ',
        'ପ୍ରିୟା',
        'ପ୍ରୀତମ୍',
        'ପ୍ରୀତିରଞ୍ଜନ',
        'ପ୍ରେମାନନ୍ଦ',
        'ପ୍ୟାରୀମୋହନ',
        'ଫକୀର',
        'ବଂଶୀଧର',
        'ବଟକୃଷ୍ଣ',
        'ବଦ୍ରି',
        'ବଦ୍ରିନାରାୟଣ',
        'ବନବାସୀ',
        'ବନମାଳି',
        'ବନମାଳୀ',
        'ବବି',
        'ବରେନ୍ଦ୍ର',
        'ବଳଭଦ୍ର',
        'ବଳରାମ',
        'ବସେନ',
        'ବାଇକୋଳି',
        'ବାଇଧର',
        'ବାଙ୍କ',
        'ବାବୁ',
        'ବାବୁଶାନ୍',
        'ବାଳକୃଷ୍ଣ',
        'ବାଳକ୍ରିଷ୍ଣ',
        'ବାଳଗୋପାଳ',
        'ବାସୁଦେବ',
        'ବିକଳାନନ୍ଦ',
        'ବିକ୍ରମ',
        'ବିଜୁ',
        'ବିଜୟ',
        'ବିଜୟରଞ୍ଜନ',
        'ବିଜୟଶ୍ରୀ',
        'ବିଜୟାନନ୍ଦ',
        'ବିଧୁ',
        'ବିଧୁଭୂଷଣ',
        'ବିନୋଦ',
        'ବିପିନ',
        'ବିପ୍ଳବ',
        'ବିଭୁତି',
        'ବିଭୁଦତ୍ତ',
        'ବିଭୁଧେନ୍ଦ୍ର',
        'ବିଭୂତି',
        'ବିଭୂତିଭୂଷଣ',
        'ବିମଳ',
        'ବିରେନ',
        'ବିରେନ୍',
        'ବିଶ୍ୱଜିତ',
        'ବିଶ୍ୱନାଥ',
        'ବିଶ୍ୱଭୂଷଣ',
        'ବିଶ୍ୱରଞ୍ଜନ',
        'ବିଷ୍ଣୁ',
        'ବିଷ୍ଣୁବ୍ରତ',
        'ବିସ୍ମୟ',
        'ବୀର',
        'ବୀରକିଶୋର',
        'ବୀରଭଦ୍ର',
        'ବୀରେନ',
        'ବୀରେନ୍ଦ୍ରନାଥ',
        'ବୁଦ୍ଧାଦିତ୍ୟ',
        'ବୁଧନ',
        'ବୃନ୍ଦାବନ',
        'ବେଣୀମାଧବ',
        'ବେଣୁଧର',
        'ବେଦ',
        'ବେଦବ୍ୟାସ',
        'ବେଦାଙ୍ଗଦାସ',
        'ବୈଦ୍ୟନାଥ',
        'ବୈରାଗୀ',
        'ବୈଷ୍ଣବ',
        'ବୋନାଜ',
        'ବ୍ରଜ',
        'ବ୍ରହ୍ମାନନ୍ଦ',
        'ବ୍ୟୋମକେଶ',
        'ଭଗୀରଥ',
        'ଭଜମନ',
        'ଭବାନୀଶଙ୍କର',
        'ଭବେନ୍ଦ୍ରନାଥ',
        'ଭାଇଗା',
        'ଭାଗବତ',
        'ଭାଗିରଥୀ',
        'ଭାଗୀରଥି',
        'ଭାଦବ',
        'ଭାନୁଚରଣ',
        'ଭାବଗ୍ରାହୀ',
        'ଭାସ୍କର',
        'ଭୀମ',
        'ଭୁବନାନନ୍ଦ',
        'ଭୁବନେଶ୍ୱର',
        'ଭୂଜବଳ',
        'ଭୂପିନ୍ଦର',
        'ଭୂବନାନନ୍ଦ',
        'ଭୋକାଲି',
        'ମଙ୍ଗରାଜ',
        'ମଙ୍ଗଳ',
        'ମଦନ',
        'ମଦନମୋହନ',
        'ମଧୁସୂଦନ',
        'ମନମୋହନ',
        'ମନୋଜ',
        'ମନୋରଞ୍ଜନ',
        'ମନୋହର',
        'ମନ୍ମଥ',
        'ମହମ୍ମଦ',
        'ମହାଦେବ',
        'ମହୀଧର',
        'ମହେନ୍ଦ୍ର',
        'ମହେଶ',
        'ମହେଶ୍ୱର',
        'ମାଖନଲାଲ',
        'ମାଧବ',
        'ମାଧବାନନ୍ଦ',
        'ମାନସ',
        'ମାର୍କଣ୍ଡ',
        'ମାଲା',
        'ମାୟାଧର',
        'ମିତ୍ରଭାନୁ',
        'ମିଲନ',
        'ମିହିର',
        'ମୀନକେତନ',
        'ମୁକୁନ୍ଦ',
        'ମୁକେଶ',
        'ମୁନ୍ନା',
        'ମୁରଲୀ',
        'ମୂରଲୀଧର',
        'ମୃଣାଳ',
        'ମୃତ୍ୟୁଞ୍ଜୟ',
        'ମେହମୁଦ',
        'ମୋଚିରାମ',
        'ମୋହନ',
        'ଯଦୁମଣି',
        'ଯଦୁମଣୀ',
        'ଯାଦବ',
        'ଯୁଗଳ',
        'ଯୁଧିଷ୍ଠିର',
        'ଯୋଗେନ୍ଦ୍ର',
        'ଯୋଗେଶ',
        'ରଂଜନ',
        'ରଘୁନନ୍ଦନ',
        'ରଘୁନାଥ',
        'ରଘୁରାମ',
        'ରଜନୀ',
        'ରଜନୀକାନ୍ତ',
        'ରଞ୍ଜିତ',
        'ରଞ୍ଜୀବ',
        'ରଣେନ୍ଦ୍ର',
        'ରତ୍ନ',
        'ରତ୍ନାକର',
        'ରଥ',
        'ରବି',
        'ରବିନାରାୟଣ',
        'ରବିନ୍ଦ୍ର',
        'ରବୀନ୍ଦ୍ର',
        'ରମାକାନ୍ତ',
        'ରମେଶ',
        'ରସାନନ୍ଦ',
        'ରାଇଚରଣ',
        'ରାଇମୋହନ',
        'ରାକେଶ',
        'ରାଖାଲ',
        'ରାଘବ',
        'ରାଜ',
        'ରାଜକିଶୋର',
        'ରାଜକୃଷ୍ଣ',
        'ରାଜୀବ',
        'ରାଜୁ',
        'ରାଜେନ୍ଦ୍ର',
        'ରାଜେଶ୍ୱରୀ',
        'ରାଧାକାନ୍ତ',
        'ରାଧାକୃଷ୍ଣ',
        'ରାଧାମୋହନ',
        'ରାଧୁ',
        'ରାମ',
        'ରାମଚନ୍ଦ୍ର',
        'ରାମରାୟ',
        'ରିପୁନାଥ',
        'ରିଷଭ',
        'ରୁଦ୍ର',
        'ରୋମାଞ୍ଚ',
        'ରୋହିତ',
        'ରୋହିଦାସ',
        'ଲକ୍ଷ୍ମଣ',
        'ଲକ୍ଷ୍ମୀକାନ୍ତ',
        'ଲକ୍ଷ୍ମୀଧର',
        'ଲଡ଼ୁ',
        'ଲମ୍ବୋଦର',
        'ଲଳିତ',
        'ଲଳିତେନ୍ଦୁ',
        'ଲାଲ',
        'ଲାଲବିହାରୀ',
        'ଲାଲା',
        'ଲିଙ୍ଗରାଜ',
        'ଲୋକନାଥ',
        'ଶଇବ',
        'ଶତ୍ରୁଘ୍ନ',
        'ଶମ୍ଭୁନାଥ',
        'ଶରତ',
        'ଶରଦ',
        'ଶଶି',
        'ଶଶିକାନ୍ତ',
        'ଶଶିଭୂଷଣ',
        'ଶାନ୍ତନୁ',
        'ଶାନ୍ତିରାଜ',
        'ଶାରଦା',
        'ଶିବବ୍ରତ',
        'ଶିବଶଙ୍କର',
        'ଶିବସୁନ୍ଦର',
        'ଶିବାଜୀ',
        'ଶିଶିର',
        'ଶୁକଦେବ',
        'ଶେକ',
        'ଶୈଳେନ୍ଦ୍ର',
        'ଶୋଭରାମ',
        'ଶ୍ରୀକାନ୍ତ',
        'ଶ୍ରୀତମ',
        'ଶ୍ରୀଦେବ',
        'ଶ୍ରୀଧର',
        'ଶ୍ରୀନାଥ',
        'ଶ୍ରୀରାମ',
        'ଶ୍ୟାମ',
        'ଶ୍ୟାମଘନ',
        'ଶ୍ୟାମଳେନ୍ଦୁ',
        'ଶ୍ୟାମସୁନ୍ଦର',
        'ସଂଗ୍ରାମ',
        'ସଉରା',
        'ସକିଲା',
        'ସଚ୍ଚି',
        'ସଞ୍ଜିବ',
        'ସଞ୍ଜୀବ',
        'ସଞ୍ଜୟ',
        'ସତ୍ୟନାରାୟଣ',
        'ସତ୍ୟପ୍ରିୟ',
        'ସତ୍ୟବାଦୀ',
        'ସତ୍ୟବ୍ରତ',
        'ସତ୍ୟଭାମା',
        'ସତ୍ୟଭୂଷଣ',
        'ସତ୍ୟସୁନ୍ଦର',
        'ସତ୍ୟାନନ୍ଦ',
        'ସଦନ',
        'ସଦାଶିବ',
        'ସନତ',
        'ସନାତନ',
        'ସନ୍ତୋଷ',
        'ସମରେନ୍ଦ୍ର',
        'ସମରେଶ',
        'ସମଲ',
        'ସମୀର',
        'ସମ୍ପଦ',
        'ସମ୍ବିତ',
        'ସରୋଜ',
        'ସରୋଜକାନ୍ତ',
        'ସରୋଜିନୀ',
        'ସଲିଲ',
        'ସହରାଇ',
        'ସାଗର',
        'ସାଗୀର',
        'ସାଧୁ',
        'ସାନନ୍ଦ',
        'ସାମୁଏଲ',
        'ସାରଦା',
        'ସାଲଖାନ',
        'ସାଲବେଗ',
        'ସାଲୁଜା',
        'ସାହେବ',
        'ସିକନ୍ଦର',
        'ସିଦ୍ଧଲାଲ',
        'ସିଦ୍ଧାନ୍ତ',
        'ସିଦ୍ଧାର୍ଥ',
        'ସୀତାକାନ୍ତ',
        'ସୁକାନ୍ତ',
        'ସୁକୁଡା',
        'ସୁକୁମାର',
        'ସୁଜିତ',
        'ସୁଦର୍ଶନ',
        'ସୁଦାମ',
        'ସୁଧାଂଶୁ',
        'ସୁଧାକର',
        'ସୁଧୀର',
        'ସୁନୀଲ',
        'ସୁନ୍ଦର',
        'ସୁବର୍ଣ୍ଣ',
        'ସୁବାଶ',
        'ସୁବାଷ',
        'ସୁବାସ',
        'ସୁବୋଧ',
        'ସୁବ୍ରତ',
        'ସୁମନ',
        'ସୁର',
        'ସୁରେନ୍ଦ୍ର',
        'ସୁରେନ୍ଦ୍ରନାଥ',
        'ସୁରେଶ',
        'ସୁଶାନ୍ତ',
        'ସୁଶୀଳ',
        'ସୂର୍ଯ୍ୟ',
        'ସୂର୍ଯ୍ୟମଣି',
        'ସୋମେଶ',
        'ସୌଭିକ',
        'ସୌମ୍ୟ',
        'ସ୍ୱରାଜ',
        'ସ୍ୱରୂପ',
        'ହର',
        'ହରମୋହନ',
        'ହରିଚରଣ',
        'ହରିପ୍ରସାଦ',
        'ହରିହର',
        'ହରେକୃଷ୍ଣ',
        'ହାଡ଼ି',
        'ହାଡ଼ିବନ୍ଧୁ',
        'ହିମାଂଶୁ',
        'ହେମନ୍ତ',
        'ହୋମସିଂହ',
    )
    first_names = first_names_male + first_names_female + first_names_unisex
    middle_names = (
        'ଅଲ୍ଲୀ',
        'କିଶୋର',
        'କୃଷ୍ଣ',
        'କେତନ',
        'କେଶରୀ',
        'ଚନ୍ଦ୍ର',
        'ଚରଣ',
        'ତିଆଡ଼ି',
        'ନାଥ',
        'ବଲ୍ଲଭ',
        'ବିଦ୍ୟାଧର',
        'ବିହାରି',
        'ବିହାରୀ',
        'ଭଞ୍ଜ',
        'ଭାରତୀ',
        'ଭୂଷଣ',
        'ମଂଜରୀ',
        'ମଞ୍ଜରୀ',
        'ମତଲୁବ',
        'ମାଧବ',
        'ମାନସିଂହ',
        'ମୋହନ',
        'ଯୋଶେଫ୍',
        'ରାଣୀ',
        'ରାଧାରାଣୀ',
        'ଲକ୍ଷ୍ମୀପ୍ରିୟା',
        'ଲେଖା',
        'ଲୋଚନ',
        'ଶଙ୍କର',
        'ଶେଖର',
        'ଶ୍ରୀ',
        'ସବ୍ୟସାଚୀ',
        'ସାରଥି',
        'ସାରଥୀ',
        'ସିଂ',
        'ସିଂହ',
        'ସୁନ୍ଦରସୁର୍ଯ୍ୟା',
    )
    last_names = (
        'ଅଗରୱାଲ',
        'ଅଗ୍ନିବେଶ',
        'ଅଗ୍ରୱାଲ',
        'ଅତାହାର',
        'ଅମାତ',
        'ଅଲୀ',
        'ଅହମଦ',
        'ଆଚାର୍ଯ୍ୟ',
        'ଆଦେନୀ',
        'ଆନନ୍ଦ',
        'ଆଲାମ',
        'ଇସଲାମ',
        'ଉଲ୍ଲାକା',
        'ଏକ୍କା',
        'ଓଝା',
        'ଓରାମ',
        'କଅଁର',
        'କର',
        'କହଁର',
        'କାଡାମ୍',
        'କାଡ୍ରାକା',
        'କାନୁନଗୋ',
        'କିନ୍ନାଗି',
        'କିଶାନ',
        'କିଷାନ',
        'କୁଅଁର',
        'କୁଣ୍ଡୁ',
        'କୁମାର',
        'କୁଲଦୀପ୍',
        'କୁଲେସିକା',
        'ଖଟୁଆ',
        'ଖାଁ',
        'ଖାନ',
        'ଖୁଣ୍ଟିଆ',
        'ଖୋସଲା',
        'ଗଜପତି',
        'ଗଡନାୟକ',
        'ଗଡ଼ତିଆ',
        'ଗଡ଼ନାୟକ',
        'ଗଣପତି',
        'ଗଣ୍ଡ',
        'ଗମାଙ୍ଗ',
        'ଗରଡ଼ିଆ',
        'ଗର୍ଦ୍ଦା',
        'ଗିରି',
        'ଗୁରୁ',
        'ଗୋସ୍ୱାମୀ',
        'ଗୌତମ',
        'ଗୌନ୍ତିଆ',
        'ଘଡ଼ାଇ',
        'ଘଡ଼େଇ',
        'ଘୋଷ',
        'ଚକ୍ରବର୍ତ୍ତୀ',
        'ଚଣ୍ଡ',
        'ଚମ୍ପତିରାୟ',
        'ଚାଟାର୍ଜି',
        'ଚିରଞ୍ଜୀବି',
        'ଚୌଧୁରୀ',
        'ଚୌରାଶିଆ',
        'ଛତ୍ରିଆ',
        'ଛୁରିଆ',
        'ଛୋଟରାୟ',
        'ଛୋଲିଆ',
        'ଜଗଡାଲ',
        'ଜଗଦେବ',
        'ଜାନୀ',
        'ଜେନା',
        'ଜୈନ',
        'ଝୋଡ଼ିଆ',
        'ଟିକାୟତ',
        'ଟୁଡୁ',
        'ଟେଟେ',
        'ଡାଙ୍ଗ',
        'ଢ଼ୋଲକିଆ',
        'ଢାଲି',
        'ତନ୍ତି',
        'ତରାଇ',
        'ତିଆଡ଼ି',
        'ତିରିୟା',
        'ତିର୍କୀ',
        'ତେଜ',
        'ତ୍ରିପାଠୀ',
        'ଥାପା',
        'ଦତ୍ତ',
        'ଦରାଇ',
        'ଦଳବେହେରା',
        'ଦାଶ',
        'ଦାସ',
        'ଦାସନାୟକ',
        'ଦାସବର୍ମା',
        'ଦିଆନ',
        'ଦିଶାରୀ',
        'ଦୀପ',
        'ଦୁରିଆ',
        'ଦୁଲାଳୀ',
        'ଦେ',
        'ଦେଇ',
        'ଦେଓ',
        'ଦେବ',
        'ଦେବତା',
        'ଦେବି',
        'ଦେବୀ',
        'ଦେହୁରୀ',
        'ଦୋରା',
        'ଦ୍ୟାନସାମନ୍ତରାୟ',
        'ଦ୍ୱିବେଦୀ',
        'ଧଡ଼ା',
        'ଧଡା',
        'ଧଳ',
        'ନନ୍ଦ',
        'ନନ୍ଦି',
        'ନାଏକ',
        'ନାଗ',
        'ନାଗେଶ',
        'ନାଥ',
        'ନାହାକ',
        'ନାୟକ',
        'ନିଆଲ',
        'ପଟୁଆ',
        'ପଟ୍ଟନାୟକ',
        'ପଣ୍ଡା',
        'ପଣ୍ଡିତ',
        'ପତି',
        'ପମ',
        'ପରବୀନ',
        'ପରମାଣିକ',
        'ପରିଜା',
        'ପରିଡ଼ା',
        'ପରିଡା',
        'ପଲେଇ',
        'ପଲ୍ଲାଇ',
        'ପାଇକରାୟ',
        'ପାଙ୍ଗୀ',
        'ପାଢ଼ୀ',
        'ପାଣି',
        'ପାଣିଗ୍ରାହୀ',
        'ପାତ୍ର',
        'ପାଲ',
        'ପାଲିତ',
        'ପାଳ',
        'ପୁଜାରୀ',
        'ପୁଟୀ',
        'ପୁରୋହିତ',
        'ପୂଜାରୀ',
        'ପୃଷ୍ଟି',
        'ପୋଡାଲ',
        'ପୋଦ୍ଦାର',
        'ପ୍ରତିହାରୀ',
        'ପ୍ରଧାନ',
        'ପ୍ରଧାନୀ',
        'ପ୍ରହରାଜ',
        'ପ୍ରିୟଦର୍ଶିନୀ',
        'ବକା',
        'ବଗର୍ତ୍ତି',
        'ବଡ଼ଜେନା',
        'ବରାଳ',
        'ବରିହା',
        'ବର୍ମା',
        'ବଳ',
        'ବଳବନ୍ତରାୟ',
        'ବଳସାମନ୍ତ',
        'ବଳିଆରସିଂହ',
        'ବଳୀୟାରସିଂହ',
        'ବସନ୍ତ',
        'ବସୁ',
        'ବସ୍ତିଆ',
        'ବାଗ',
        'ବାନାର୍ଜୀ',
        'ବାବୁ',
        'ବାରିକ',
        'ବାର୍ଲା',
        'ବାହିନୀପତି',
        'ବାହୁବଳେନ୍ଦ୍ର',
        'ବିଜୁଳି',
        'ବିଦ୍ୟାଧର',
        'ବିଶୋୟୀ',
        'ବିଶ୍ୱାଳ',
        'ବୀର',
        'ବେଉରା',
        'ବେହୁରା',
        'ବେହେରା',
        'ବୈଦ୍ୟ',
        'ବୋଷ',
        'ବ୍ରହ୍ମା',
        'ବ୍ୟାସ',
        'ଭଞ୍ଜ',
        'ଭଞ୍ଜଦେଓ',
        'ଭଟ୍ଟାଚାର୍ଯ୍ୟ',
        'ଭୂୟାଁ',
        'ଭୋଇ',
        'ମଙ୍ଗରାଜ',
        'ମଢ଼େଇ',
        'ମଣ୍ଡଳ',
        'ମର୍ଦ୍ଦରାଜ',
        'ମଲିକ',
        'ମଲ୍ଲ',
        'ମଲ୍ଲିକ',
        'ମହନ୍ତ',
        'ମହସୀନ',
        'ମହାକୁଡ଼',
        'ମହାନନ୍ଦ',
        'ମହାନ୍ତି',
        'ମହାପାତ୍ର',
        'ମହାରଣା',
        'ମହାରଥୀ',
        'ମହାଲିଙ୍ଗା',
        'ମହାଳିକ',
        'ମାଝି',
        'ମାଝୀ',
        'ମାଢ଼ୀ',
        'ମାଢ଼େଇ',
        'ମାନସିଂହ',
        'ମାନ୍ଧାତା',
        'ମାରାଣ୍ଡି',
        'ମିଞ୍ଜ୍',
        'ମିତ୍ର',
        'ମିର୍ଦ୍ଧା',
        'ମିଶ୍ର',
        'ମୁକ୍କିମ',
        'ମୁଖାର୍ଜୀ',
        'ମୁଣ୍ଡା',
        'ମୁଦି',
        'ମୁଦୁଲି',
        'ମୁର୍ମୁ',
        'ମୁସୀର',
        'ମେହେଟା',
        'ମେହେର',
        'ମୋକିମ୍',
        'ରଞ୍ଜନ',
        'ରଣସିଂହ',
        'ରଣା',
        'ରଥ',
        'ରନ୍ଧାରୀ',
        'ରମଣୀ',
        'ରାଉତ',
        'ରାଉତରାୟ',
        'ରାଉଳ',
        'ରାଓ',
        'ରାଜ',
        'ରାଜନ୍',
        'ରାମ',
        'ରାୟ',
        'ରାୟଚୌଧୁରୀ',
        'ରେଡ୍ଡି',
        'ରୋହିଦାସ',
        'ଲାକ୍ରା',
        'ଲାଗୁରୀ',
        'ଲାଠ',
        'ଲାଲ',
        'ଲେଙ୍କା',
        'ଲୋକ',
        'ଶତପଥୀ',
        'ଶର୍ମା',
        'ଶାନ୍ତା',
        'ଶ୍ରୀଚନ୍ଦନ',
        'ଷଡ଼ଙ୍ଗୀ',
        'ସଙ୍ଗୀତା',
        'ସର୍ଖେଲ',
        'ସର୍ଦ୍ଦାର',
        'ସାଇ',
        'ସାଉଣ୍ଟା',
        'ସାମନ୍ତ',
        'ସାମନ୍ତରାୟ',
        'ସାମଲ',
        'ସାରକା',
        'ସାଲୁଜା',
        'ସାହୁ',
        'ସିଂ',
        'ସିଂଦେଓ',
        'ସିଂହ',
        'ସିଂହଦେଓ',
        'ସିଦୁ',
        'ସିଧୁ',
        'ସିପ୍କା',
        'ସିହ୍ନା',
        'ସୁବାହୁ',
        'ସେଟି',
        'ସେଠ',
        'ସେଠୀ',
        'ସେଠ୍',
        'ସେନ',
        'ସେନାପତି',
        'ସୋଡ଼ି',
        'ସୋରେନ',
        'ସୋରେନ୍',
        'ସୌର୍ଯ୍ୟା',
        'ସ୍ବାଇଁ',
        'ସ୍ୱାଇଁ',
        'ହଇବୁରୁ',
        'ହନିଫ',
        'ହରିଚନ୍ଦନ',
        'ହାଁସଦା',
        'ହାଇବ୍ରୁ',
        'ହିକୋକା',
        'ହିକ୍କା',
        'ହିମିରିକା',
        'ହୁସେନ',
        'ହେମ୍ବ୍ରମ',
        'ହୋତା',
    )
    prefixes_female = (
        'ସୁଶ୍ରୀ',
        'ଶ୍ରୀମତୀ',
        'କୁମାରୀ',
    )
    prefixes_male = (
        'ଶ୍ରୀ',
        'ଶ୍ରୀମାନ',
        'ଶ୍ରୀଯୁକ୍ତ',
    )

    def first_name_unisex(self):
        return self.random_element(self.first_names_unisex)

    def middle_name(self):
        return self.random_element(self.middle_names)
