/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class EditorOnlyDisplayer {
    private static EditorOnlyDisplayer theInstance;
    private final PropertyChangeListener registryListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EditorOnlyDisplayer.this.onRegistryChange(propertyChangeEvent);
        }
    };
    private Container originalContentPane = null;
    private boolean originalShowEditorToolbar = true;

    private EditorOnlyDisplayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditorOnlyDisplayer getInstance() {
        Class<EditorOnlyDisplayer> clazz = EditorOnlyDisplayer.class;
        synchronized (EditorOnlyDisplayer.class) {
            if (null == theInstance) {
                theInstance = new EditorOnlyDisplayer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public boolean isActive() {
        return null != this.originalContentPane;
    }

    public void setActive(boolean bl) {
        if (bl == this.isActive()) {
            return;
        }
        if (this.isActive()) {
            this.cancel(true);
        } else {
            this.activate();
        }
    }

    private void onRegistryChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            Window window;
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (null != topComponent && null != (window = SwingUtilities.getWindowAncestor((Component)topComponent)) && !window.equals(WindowManagerImpl.getInstance().getMainWindow())) {
                return;
            }
            if (this.switchCurrentEditor()) {
                return;
            }
            this.cancel(true);
        }
    }

    private boolean switchCurrentEditor() {
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent || !TopComponentTracker.getDefault().isEditorTopComponent(topComponent)) {
            return false;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        JFrame jFrame = (JFrame)windowManagerImpl.getMainWindow();
        if (SwingUtilities.isDescendingFrom((Component)topComponent, jFrame.getContentPane())) {
            return true;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)topComponent, "Center");
        try {
            jFrame.setContentPane(jPanel);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.getLogger(EditorOnlyDisplayer.class.getName()).log(Level.INFO, "Error while switching current editor.", indexOutOfBoundsException);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorOnlyDisplayer.this.cancel(false);
                }
            });
        }
        jFrame.invalidate();
        jFrame.revalidate();
        jFrame.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                topComponent.requestFocusInWindow();
            }
        });
        return true;
    }

    public void cancel(boolean bl) {
        if (!this.isActive()) {
            return;
        }
        TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
        JFrame jFrame = (JFrame)WindowManagerImpl.getInstance().getMainWindow();
        jFrame.setContentPane(this.originalContentPane);
        this.originalContentPane = null;
        EditorOnlyDisplayer.setShowEditorToolbar(this.originalShowEditorToolbar);
        if (bl) {
            this.restoreFocus();
        }
    }

    private void restoreFocus() {
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != topComponent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topComponent.requestFocusInWindow();
                }
            });
        }
    }

    private void activate() {
        assert (null == this.originalContentPane);
        final TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent || !TopComponentTracker.getDefault().isEditorTopComponent(topComponent)) {
            return;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        JFrame jFrame = (JFrame)windowManagerImpl.getMainWindow();
        StatusDisplayer.getDefault().setStatusText(null);
        this.originalContentPane = jFrame.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)topComponent, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.invalidate();
        jFrame.revalidate();
        jFrame.repaint();
        windowManagerImpl.getRegistry().addPropertyChangeListener(this.registryListener);
        this.originalShowEditorToolbar = EditorOnlyDisplayer.setShowEditorToolbar(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                topComponent.requestFocusInWindow();
            }
        });
    }

    private static boolean setShowEditorToolbar(boolean bl) {
        JMenuItem jMenuItem;
        boolean bl2 = true;
        Action action = (Action)FileUtil.getConfigObject((String)"Editors/Actions/toggle-toolbar.instance", Action.class);
        if (null != action && action instanceof Presenter.Menu && (jMenuItem = ((Presenter.Menu)action).getMenuPresenter()) instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenuItem;
            bl2 = jCheckBoxMenuItem.isSelected();
            if (jCheckBoxMenuItem.isSelected() != bl) {
                try {
                    action.actionPerformed(new ActionEvent(jMenuItem, 0, ""));
                }
                catch (Exception exception) {
                    Logger.getLogger(EditorOnlyDisplayer.class.getName()).log(Level.FINE, null, exception);
                }
            }
        }
        return bl2;
    }
}

