/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;

public class OpAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node valueNode;
    private final RubySymbol variableName;
    private final RubySymbol operatorName;
    private final RubySymbol variableNameAsgn;
    private final boolean isLazy;

    public OpAsgnNode(ISourcePosition position, Node receiverNode, Node valueNode, RubySymbol variableName, RubySymbol operatorName, boolean isLazy) {
        super(position, receiverNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
        this.variableName = variableName;
        this.operatorName = operatorName;
        this.variableNameAsgn = variableName.asWriter();
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorName.asJavaString();
    }

    public ByteList getOperatorByteName() {
        return this.operatorName.getBytes();
    }

    public RubySymbol getOperatorSymbolName() {
        return this.operatorName;
    }

    public boolean isOr() {
        return CommonByteLists.OR_OR.equals(this.operatorName.getBytes());
    }

    public boolean isAnd() {
        return CommonByteLists.AMPERSAND_AMPERSAND.equals(this.operatorName.getBytes());
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableName.asJavaString();
    }

    public ByteList getVariableByteName() {
        return this.variableName.getBytes();
    }

    public RubySymbol getVariableSymbolName() {
        return this.variableName;
    }

    public String getVariableNameAsgn() {
        return this.variableNameAsgn.asJavaString();
    }

    public ByteList getVariableByteNameAsgn() {
        return this.variableNameAsgn.getBytes();
    }

    public RubySymbol getVariableSymbolNameAsgn() {
        return this.variableNameAsgn;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

